#include "Dll.ch"

#define CRLF chr(13)+chr(10)

STATIC nHDll
STATIC tpl_RMC_CreateChartFromFile
STATIC tpl_RMC_GetChartSizeFromFile
STATIC tpl_RMC_Draw
STATIC tpl_RMC_Paint
STATIC tpl_RMC_Reset

proc main
     ? "RMC_INIT()",RMC_INIT()
     ? "UMSATZ",    umsatz()
     wait
return

FUNCTION RMC_INIT
LOCAL hDll := DllLoad("RMCHART.DLL")
LOCAL lReply := .F.
IF hDll <= 0
    MsgBox("RMCHART.DLL nicht vorhanden!")
ELSE
    lReply := .T.
    tpl_RMC_CreateChartFromFile  := DllPrepareCall(hDll,DLL_STDCALL,"RMC_CREATECHARTFROMFILE")
    tpl_RMC_GetChartSizeFromFile := DllPrepareCall(hDll,DLL_STDCALL,"RMC_GETCHARTSIZEFROMFILE")
    tpl_RMC_Draw  := DllPrepareCall(hDll,DLL_STDCALL,"RMC_DRAW")
    tpl_RMC_Paint := DllPrepareCall(hDll,DLL_STDCALL,"RMC_PAINT")
    tpl_RMC_Reset := DllPrepareCall(hDll,DLL_STDCALL,"RMC_RESET")
ENDIF
RETURN(lReply)

FUNCTION RMC_CreateChartFromFile(nHwnd,nCtrId,nX,nY,nExportOnly,cRMCFile)
RETURN( DllExecuteCall(tpl_RMC_CreateChartFromFile,nHwnd,nCtrId,nX,nY,nExportOnly,cRMCFile) )

FUNCTION RMC_GetChartSizeFromFile(cRMCFile,nWidth,nHeight)
RETURN( DllExecuteCall(tpl_RMC_GetChartSizeFromFile,cRMCFile,@nWidth,@nHeight) )

FUNCTION RMC_Draw(nCtrId)
RETURN( DllExecuteCall(tpl_RMC_Draw,nCtrId) )

FUNCTION RMC_Paint(nCtrId)
RETURN( DllExecuteCall(tpl_RMC_Paint,nCtrId) )

FUNCTION RMC_Reset(nCtrId)
RETURN( DllExecuteCall(tpl_RMC_Reset,nCtrId) )

FUNCTION umsatz
LOCAL hWin  := SetAppWindow():getHWND()
LOCAL nIx
LOCAL c := ""
FOR nIx = 1 TO 12
    c += STR(nIx,2)+CRLF
NEXT nIx
MEMOWRIT("UMSATZ.CSV",c)
RMC_CreateChartFromFile(hWin,1,0,0,0,"simplebar.rmc") // "UMSATZ.RMC")
RMC_Draw(1)
RMC_Draw(1)
RETURN(.T.)
