#include "XBP.ch"
#include "Dll.ch"
#include "Appevent.ch"
#include "common.ch"
#include "HB_RMChart.ch"

#define CRLF chr(13)+chr(10)

#define ONLY_USE_XbpStatic

// #define BALKEN_GRAFIK
// #define XY_GRAFIK
   #define TORTEN_GRAFIK

procedure appsys()
return

proc main
     local oRMC:=nil
     local oWin, oXbp:=NIL, IsOK:=.t., oPB, oGraph
     local nEvent, mp1:=nil, mp2:=nil, nSizeX, nSizeY
     local oSleCaption,oSleImage
     local nRegion, nSeries, nColor, nIndex
     local nColorIndex := 0, aColor := {ColorAzure,ColorBeige,ColorCyan,ColorFadeGreen}

     set charset to ansi

     nSizeX := 400
     nSizeY := 400

     oWin := XbpDialog():new(appdesktop(),,{100,100},{900,900})
     oWin:close :={|| oRMC:destroy(),oWin:destroy()}
     oWin:taskList := .t.
     oWin:title := "RMChart - Test"
     oWin:create()
     SetAppWindow(oWin)
     oGraph := XbpStatic():new(oWin:drawingArea,,{100,100},{nSizeX,nSizeY})
     oGraph:tabStop := .f.
     oGraph:type := XBPSTATIC_TYPE_RAISEDBOX
     oGraph:create()
     oPB := XbpPushButton():new(oWin:drawingArea, , {10,800}, {80,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "<-"
     oPB:tabStop := .T.
     oPB:activate := {|u1,u2,oPB| oGraph:setPos({max(0,oGraph:currentPos()[1]-10),oGraph:currentPos()[2]}) }
     oPB:create()
     oPB := XbpPushButton():new(oWin:drawingArea, , {100,800}, {80,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "->"
     oPB:tabStop := .T.
     oPB:activate := {|u1,u2,oPB| oGraph:setPos({oGraph:currentPos()[1]+10,oGraph:currentPos()[2]}) }
     oPB:create()
     oPB := XbpPushButton():new(oWin:drawingArea, , {190,800}, {80,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "UP"
     oPB:tabStop := .T.
     oPB:activate := {|u1,u2,oPB| oGraph:setPos({oGraph:currentPos()[1],oGraph:currentPos()[2]+10}) }
     oPB:create()
     oPB := XbpPushButton():new(oWin:drawingArea, , {280,800}, {80,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "DOWN"
     oPB:tabStop := .T.
     oPB:activate := {|u1,u2,oPB| oGraph:setPos({oGraph:currentPos()[1],max(0,oGraph:currentPos()[2]-10)}) }
     oPB:create()
     oPB := XbpPushButton():new(oWin:drawingArea, , {760,800}, {120,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "Abbruch"
     oPB:tabStop := .T.
#if XPPVER > 1900000
     oPB:default := .t.
     oPB:cancel := .t.
#endif
     oPB:activate := {|| PostAppEvent( xbeP_Close ) }
     oPB:create()

     oSleCaption := XbpSle():new(oWin:drawingArea, , {660,770}, {95,24} )
     oSleCaption:tabstop := .t.
     oSleCaption:create()

     oPB := XbpPushButton():new(oWin:drawingArea, , {760,770}, {120,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "SetCaption Text"
     oPB:tabStop := .T.
     oPB:activate := {|| oRMC:RMC_SetCaptionText(1,alltrim(oSleCaption:getData())),oRMC:RMC_Draw() }
     oPB:create()

     oPB := XbpPushButton():new(oWin:drawingArea, , {760,740}, {120,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "SetCaption REST"
     oPB:tabStop := .T.
     oPB:activate := {|| oRMC:RMC_SetCaptionBGColor(1,0x233455),;
                         oRMC:RMC_SetCaptionTextColor(1,0xAABBCC),;
                         oRMC:RMC_SetCaptionFontBold(1,.t.),;
                         oRMC:RMC_SetCaptionFontSize(1,12),;
                         oRMC:RMC_Draw() }
     oPB:create()

     oPB := XbpPushButton():new(oWin:drawingArea, , {760,710}, {120,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "SetBG Color"
     oPB:tabStop := .T.
     oPB:activate := {|| iif(nColorIndex<len(aColor),nColorIndex++,nColorIndex:=1),;
                         oRMC:RMC_SetCtrlStyle(RMC_CTRLSTYLEFLAT ),;
                         oRMC:RMC_SetCtrlBGColor(aColor[nColorIndex]),;
                         oRMC:RMC_Draw() }
     oPB:create()

     oSleImage := XbpSle():new(oWin:drawingArea, , {660,680}, {95,24} )
     oSleImage:bufferLength := 64
     oSleImage:tabstop := .t.
     oSleImage:create()
     oSleImage:setData(curdrive()+":\"+curdir()+"BackBMP.bmp")


     oPB := XbpPushButton():new(oWin:drawingArea, , {760,680}, {120,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "SetBG Image"
     oPB:tabStop := .T.
     oPB:activate := {|| oRMC:RMC_SetCtrlBGColor( ColorTransparent ),;
                         oRMC:RMC_SetCtrlStyle( RMC_CTRLSTYLEIMAGE ),;
                         msgbox(var2char(oRMC:RMC_SetCtrlBGImage(oSleImage:getData()))),;
                         oRMC:RMC_Draw() }
     oPB:create()

     oPB := XbpPushButton():new(oWin:drawingArea, , {760,650}, {120,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "pos+, Size-"
     oPB:tabStop := .T.
     oPB:activate := {|| oRMC:RMC_SetCtrlPos(+10,+10,.t.),;
                         oRMC:RMC_SetCtrlSize(-20, -20, .t.),;
                         oRMC:RMC_Draw() }
     oPB:create()

     oPB := XbpPushButton():new(oWin:drawingArea, , {760,620}, {120,24}, { { XBP_PP_BGCLR, XBPSYSCLR_BUTTONMIDDLE }, { XBP_PP_FGCLR, -58 } } )
     oPB:caption := "Font: Arial"
     oPB:tabStop := .T.
     oPB:activate := {|| oRMC:RMC_SetCtrlFont("Arial"),;
                         oRMC:RMC_Draw() }
     oPB:create()




     SetAppFocus(oWin)
     SetAppFocus(oSleCaption)

     #ifdef ONLY_USE_XbpStatic
        oRMC := RMChart(oGraph,.t.,0,0,nSizeX,nSizeY) // ODER | OR oXbp,.t.) // oWin,.t.)
     #else
        oRMC := RMChart(oWin,.t.,0,0,nSizeX,nSizeY) // ODER | OR      oXbp,.t.) // oWin,.t.)
     #endif

     if oRMC:RMC_CreateChart()
        oRMC:RMC_AddRegion(,,,,"TestRegion 1",.t.)

#ifdef  BALKEN_GRAFIK

        oRMC:RMC_AddGrid(1)
        oRMC:RMC_AddCaption(1,"GRID-Balkengrafik",,,,.t.)
        oRMC:RMC_AddLegend(1,"Blue*Green")  // wahrscheinlich erst mit Daten !!!
        oRMC:RMC_AddLabelAxis(1,"98*99*00*01*02*03*04*05*06*07",1,,,,,,,,"LabelAxis")
        oRMC:RMC_AddDataAxis(1,,-100,100,,,,,,,"","Euro",,RMC_TEXTRIGHT) // 3. MIN, 4. MAX
        // nRegion,aNumData,nType,nStyle,nIsLucent,nColor,;
        //                          nIsHorizontal,nWhichDataAxis,nValueLabelOn,;
        //                          nPointsPerColumn,nHatchMode
        oRMC:RMC_AddBarSeries(1,;                              // nRegion
                              {-10,5,23,45,23,0,12,23,45,67},; // aNumData
                              RMC_BARGROUP ;                   // nType
                               ;                               // nStyle
                               ;                               // nIsLucent
                               ;                               // nColor
                               ;                               // nIsHorizontal
                               ;                               // nWhichDataAxis
                               ;                               // nValueLabelOn
                               ;                               // nPointsPerColumn
                               )                               // nHatchMode
        oRMC:RMC_AddBarSeries(1,{4,3,2,1,-10,-25,2,30,50,70},RMC_BARGROUP)
        oRMC:RMC_AddLineSeries(1 ,; //nRegion
                               {5,2,5,7,6,4,3,2,33,44} ; //aNumData
                               ; // nFirstPPCValue,;
                               ; // nType
                               ; // nStyle
                               ; // nLineStyle
                               ; // nIsLucent
                               ; // nColor
                               ; // nSymbol
                               ; // nWhichDataAxis
                               ; // nValueLabelOn
                               ) // nHatchMode)
// ???
/*
        oRMC:RMC_AddHighLowSeries(1,;                   //nRegion
                                  {5,7,-4,6,4,2,-8,6},; // aNumData OpenHighLowClose
                                  {4}                 ; // aPointsPerColumn
                                                      ; // nStyle
                                                      ; // nWhichDataAxis
                                                      ; // nColorLow
                                                      ) // nColorHigh
*/
// ???
/*
        oRMC:RMC_AddVolumeBarSeries(1,;                     // nRegion
                                   {10,8,9,4,6,7,3,4,1,6} ; // aNumData
                                                          ; // aPointsPerColumn,;
                                                          ; // nColor
                                                          ) // nWhichDataAxis
*/
#endif

#ifdef  XY_GRAFIK       // XY-Graph
        oRMC:RMC_AddGrid(1)
        oRMC:RMC_AddCaption(1,"GRID-XY-Punktegrafik",,,,.t.)
        oRMC:RMC_AddLegend(1,"Blue*Green")  // wahrscheinlich erst mit Daten !!!
        oRMC:RMC_AddXAxis(  1,;      // nRegion
                             ,;      // nAlignment
                            0,;      // nMinvalue
                           10,;      // nMaxvalue
                           11,;      // nTickcount = Anzahl der X-Bezeichner/Linien
                             ,;      // nFontsize
                             ,;      // nTextcolor
                             ,;      // nLinecolor
                             ,;      // nLinestyle
                             ,;      // nDecimalDigits
                             ,;      // sUnit      = Einheitenbezeichnung z.B. "$ "
            "X-Achse"        ;      // sText      = Beschriftung der gesamten Achse
                              ;      // sLabels    = Datenbeschriftung z.B. "0*a*b*c*d*E*f*g*h*i*K"
                              )      // nLabelAlignment  = RMC_TEXTUPWARD / RMC_TEXTDOWNWARD

        oRMC:RMC_AddYAxis(  1,;      // nRegion
                             ,;      // nAlignment
                           -4,;      // nMinvalue
                            6,;      // nMaxvalue
                           11,;      // nTickcount
                             ,;      // nFontsize
                             ,;      // nTextcolor
                             ,;      // nLinecolor
                             ,;      // nLinestyle
                             ,;      // nDecimalDigits
                             ,;      // sUnit      = Einheitenbezeichnung z.B. "$ "
                     "Y-Achse";      // sText      = Beschriftung der gesamten Achse
                              ;      // sLabels    = Datenbeschriftung z.B. "0*a*b*c*d*E*f*g*h*i*K"
                              )      // nLabelAlignment  = RMC_TEXTUPWARD / RMC_TEXTDOWNWARD

        oRMC:RMC_AddXYSeries( 1,;                  // nRegion
                              {1,2,3,4,5},;        // aNumDataX
                              {1,2,3,4,5} ;        // aNumDataY
                                          ;        // nColor
                                          ;        // nStyle
                                          ;        // nLineStyle
                                          ;        // nSymbol
                                          ;        // nWhichXAxis
                                          ;        // nWhichYAxis
                                          )        // nValueLabelOn)
        oRMC:RMC_AddXYSeries( 1,;                  // nRegion
                              {1,2,3.2,4.3,5},;        // aNumDataX
                              {-3,-1,2,4,6} ;        // aNumDataY
                                          ;        // nColor
                                          ;        // nStyle
                                          ;        // nLineStyle
                                          ;        // nSymbol
                                          ;        // nWhichXAxis
                                          ;        // nWhichYAxis
                                          )        // nValueLabelOn)

#endif

#ifdef  TORTEN_GRAFIK
        oRMC:RMC_AddCaption(1,"GRID-LESS: Tortengrafik",,,,.t.)
        oRMC:RMC_AddLegend(1,"1*2*3*4*5*6*7*8*9*10*11*12")  // wahrscheinlich erst mit Daten !!!
        nRegion := 1
        oRMC:RMC_AddGridlessSeries( nRegion ,;          // nRegion
                                   {1,3,5,7,2,4,6,8,1,2,3,4 } ,; // aNumData
                                   {ColorAliceBlue,    ColorAntiqueWhite, ColorAquamarine, ColorArmyGreen,;
                                    ColorAutumnOrange, ColorAvocadoGreen, ColorAzure,      ColorBabyBlue,;
                                    ColorBananaYellow, ColorBeige,        ColorBisque,     ColorBlack } ; // aColor
                                               ; // nStyle
                                               ; // nAlignment
                                               ; // nExplodemode
                                               ; // nIsLucent
                                               ; // nValueLabelOn
                                               ; // nHatchMode
                                               ) // nStartAngle)
        nSeries := 1
        nColor  := ColorRed
        nIndex  := 7
        oRMC:RMC_SetSeriesColor(nRegion, nSeries, nColor, nIndex)
#endif


        if ! IsOK
           msgbox("Fehler: DOS:"+ntrim(oRMC:DOSError)+" RMC:"+ntrim(oRMC:RMCError))
        else


           oRMC:RMC_Draw()

           #if .f.

               oRMC:RMC_WriteRMCFile("NeuGrafik.RMC")

           #endif

           msgbox("nun RegionBorder lschen ...","Mit RegionBorder")

           oRMC:RMC_SetRegionBorder(1,0)

           oRMC:RMC_Draw()

           #if .t.
               oRMC:RMC_Draw2File("NeuGrafik.JPG")
               msgbox("Gespeichert / saved as:"+CRLF+;
                      "NeuGrafik.JPG","Info")
           #endif

           #if .f.
               oRMC:RMC_Draw2Clipboard() // RMC_EMF, RMC_BMP ?
               msgbox("bergeben an Zwischenablage."+CRLF+;
                      "Send to the Clipboard","Info")
           #endif

           #if .f.
               oRMC:RMC_Draw2Printer(  ,; // nPrinterDC
                                     10,; // nLeft
                                     10,; // nTop
                                    100,; // nWidth
                                     100; // nHeight
                                        ) // RMC_EMF, RMC_EMFPLUS, RMC_BMP ) // nType
               msgbox("bergeben an Standarddrucker."+CRLF+;
                      "Send to the default printer.","Info")
           #endif

        endif
     endif

     nEvent := xbe_None
                                      // Programm bricht bei dem
     DO WHILE nEvent <> xbeP_Close    // Ereignis xbeP_Close ab
        nEvent := AppEvent( @mp1, @mp2, @oXbp, 0 )
        oXbp:handleEvent( nEvent, mp1, mp2 )
     ENDDO

return

function nTrim(nVal)
return alltrim(str(nVal))
