/*  Version 1.01.000 - 07.06.2010

    Wrapper fr RMChart.DLL

    Vielen Dank an Rainer Morgen fr dieses erstklassige Tool.

    www.rmchart.com   -> Homepage von RMChart ( Leider verschwunden :-( )
    www.XbaseForum.de -> deutsches (Inoffizielles) Forum fr Xbase++ Fragen

    NUR JPG erzeugen | ONLY save to JPG:

        oRMC := RMChart(,,0,0,SizeX,SizeY)
        oRMC:lExportOnly := .t.
        if oRMC:RMC_CreateChartFromFile(cRMCFile)
           oRMC:RMC_Draw2File(sFileName)
           oRMC:destroy()
        endif


    ANZEIGEN | normal show

        oRMC := RMChart(oWin,.t.,100,100) //oXbp,.t.) // oWin,.t.)
        if oRMC:RMC_CreateChartFromFile(cRMCFile)
           oRMC:RMC_Draw()
           // speichern ? / save ?
           oRMC:RMC_Draw2File("SimpleBar.JPG")
        else
           ? "Fehler bei RMChart()" // ERROR with
        endif
        wait
        oRMC:destroy()

    *** changed *** neu ***

    1.01.000  - L2RefStr() und 0xFFF0F8FF (ff.) ergab einen Laufzeitfehler wegen der Interpretation als DWORD
                L2RefStr() and 0xFFF0F8FF (ff.) caused an runtime error because it was interpreted as unsigned int (DWORD)
              - Mit dem XbpStatic() ::oHide wird nun verhindert, dass RMCHART auf den mouse click reagiert.
                A new XbpStatic() ::oHide will now block the mouse click befor RMCHART can catch it.

*/

#include "XBP.ch"
#include "GRA.ch"
#include "Dll.ch"
#include "Appevent.ch"
#include "common.ch"
#include "HB_RMChart.ch"

#ifndef CRLF
   #define CRLF chr(13)+chr(10)
#endif

function RMChart(oWin,lShowErrorMessage,nX,nY,nSizeX,nSizeY)
return _RMChart():New(oWin,lShowErrorMessage,nX,nY,nSizeX,nSizeY)
//
//----------------------- zur Anpassung von XbpControls
function RMC_GetChartSizeFromFile(cRMCFile)
   local nSizeX:=0,nSizeY:=0,aReturn := NIL, hDLL
   DEFAULT cRMCFile TO ""
   hDLL := DllLoad("RMCHART.DLL")
   if hDLL > 0
      if 0=DllCall( hDLL, DLL_STDCALL,"RMC_GETCHARTSIZEFROMFILE",;
                                        cRMCFile,@nSizeX,@nSizeY)
         aReturn := {nSizeX,nSizeY}
      endif
      DllUnLoad(hDLL)
   else
      msgbox("Fehler beim Laden in Funktion / Load-Error")
   endif
return aReturn
//
// DOUBLE Parameter mssen so bergeben werden: D2P(nDouble,1),D2P(nDouble,2)
//        aus einem Parameter werden also 2 Funktionsaufrufe !
//---------------------------------------------------------------------
function D2P(nDouble,nPos)
   local cDouble := F2BIN(nDouble), nLong
   DEFAULT nPos TO 0
   do case
      case nPos=1
           nLong := BIN2L(left(cDouble,4))  // Lower,  1. Parameter
      case nPos=2
           nLong := BIN2L(right(cDouble,4)) // Higher, 2. Parameter
      otherwise
      msgbox("D2P hat falschen Parameter")
   endcase
return nLong
//
//---------------------------------------------------------------------
function D2RefStr(uDouble)  // Xbase++ Array -> C DOUBLE Array ! PER REFERENZ !
   local cDouble := ""
   do case
      case IsNil(uDouble)
           cDouble := F2BIN(0)
      case valType(uDouble)="N"
           cDouble := F2BIN(uDouble)
      case valType(uDouble)="A"
           aeval(uDouble,{|nD| cDouble += F2BIN(nD)})
      otherwise
           msgbox("D2RefStr(uDouble) hat falschen Parameter")
   endcase
return cDouble
//--------------------------------------------------------------------
//
//---------------------------------------------------------------------
function L2RefStr(uLong)    // Xbase++ Array -> C LONG Array ! PER REFERENZ !
   local cLong := ""
   do case
      case IsNil(uLong)
           cLong := L2BIN(0)
      case valType(uLong)="N"
           if uLong > 2147483647
              cLong := U2BIN(uLong)
           else
              cLong := L2BIN(uLong)
           endif
      case valType(uLong)="A"
           aeval(uLong,{|nL| cLong += iif(nL > 2147483647,U2BIN(nL),L2BIN(nL))})
      otherwise
           msgbox("L2RefStr(uLong) hat falschen Parameter")
   endcase
return cLong
//--------------------------------------------------------------------

CLASS _RMChart
   exported:
   VAR IsOK
   VAR lShowErrorMessage
   VAR lExportOnly

   METHOD init
   METHOD destroy
   METHOD RMC_CreateChart
   METHOD RMC_CreateChartFromFile
   METHOD RMC_GetChartSizeFromFile
   METHOD RMC_AddRegion
   METHOD RMC_AddCaption
   METHOD RMC_AddLegend
   METHOD RMC_AddGrid              // die folgenden Befehle gehren zu GRID-Grafik
   METHOD RMC_AddLabelAxis         // Balken etc.
   METHOD RMC_AddDataAxis
   METHOD RMC_AddBarSeries
   METHOD RMC_AddLineSeries
   METHOD RMC_AddHighLowSeries
   METHOD RMC_AddVolumeBarSeries
   METHOD RMC_AddXAxis             // XY-Achsendarstellung
   METHOD RMC_AddYAxis
   METHOD RMC_AddXYSeries
   METHOD RMC_AddGridlessSeries    // GRID-Less: Torten-, Donut-, Pyramidengrafik
   METHOD RMC_Draw
   METHOD RMC_Draw2File
   METHOD RMC_Draw2Clipboard
   METHOD RMC_Draw2Printer
   METHOD RMC_WriteRMCFile
   METHOD RMC_WriteRMC2String      // gibt Definitionsdatei als String zurck.
   METHOD RMC_SetCaptionText       // nachtrgliche nderungen // RMC_DRAW() nicht vergessen !
   METHOD RMC_SetCaptionBGColor
   METHOD RMC_SetCaptionTextColor
   METHOD RMC_SetCaptionFontBold
   METHOD RMC_SetCaptionFontSize
   METHOD RMC_SetCtrlBGColor
   METHOD RMC_SetCtrlBGImage
   METHOD RMC_SetCtrlFont
   METHOD RMC_SetCtrlPos
   METHOD RMC_SetCtrlSize
   METHOD RMC_SetCtrlStyle
   METHOD RMC_SetDAXAlignment
   METHOD RMC_SetDAXDecimalDigits
   METHOD RMC_SetDAXFontSize
   METHOD RMC_SetDAXLineColor
   METHOD RMC_SetDAXLabelAlignment
   METHOD RMC_SetDAXLabels
   METHOD RMC_SetDAXLineStyle
   METHOD RMC_SetDAXMaxValue
   METHOD RMC_SetDAXMinValue
   METHOD RMC_SetDAXText
   METHOD RMC_SetDAXTextColor
   METHOD RMC_SetDAXTickcount
   METHOD RMC_SetDAXUnit
   METHOD RMC_SetGridBGColor
   METHOD RMC_SetGridGradient
   METHOD RMC_SetLAXAlignment
   METHOD RMC_SetLAXCount
   METHOD RMC_SetLAXFontSize
   METHOD RMC_SetLAXLabelAlignment
   METHOD RMC_SetLAXLabels
   METHOD RMC_SetLAXLineColor
   METHOD RMC_SetLAXLineStyle
   METHOD RMC_SetLAXText
   METHOD RMC_SetLAXTextColor
   METHOD RMC_SetLAXTickcount
   METHOD RMC_SetLegendAlignment
   METHOD RMC_SetLegendBGColor
   METHOD RMC_SetLegendFontBold
   METHOD RMC_SetLegendFontSize
   METHOD RMC_SetLegendStyle
   METHOD RMC_SetLegendText
   METHOD RMC_SetLegendTextColor
   METHOD RMC_SetRegionBorder
   METHOD RMC_SetRegionFooter
   METHOD RMC_SetRegionMargin
   METHOD RMC_SetRMCFile
   METHOD RMC_SetSeriesColor
   METHOD RMC_SetSeriesData
   METHOD RMC_SetSeriesDataAxis
   METHOD RMC_SetSeriesDataFile
   METHOD RMC_SetSeriesExplodeMode
   METHOD RMC_SetSeriesHatchMode
   METHOD RMC_SetSeriesHide
   METHOD RMC_SetSeriesLinestyle
   METHOD RMC_SetSeriesLucent
   METHOD RMC_SetSeriesSingleData
   METHOD RMC_SetSeriesStartAngle
   METHOD RMC_SetSeriesStyle
   METHOD RMC_SetSeriesSymbol
   METHOD RMC_SetSeriesValuelabel
   METHOD RMC_SetSeriesVertical
   METHOD RMC_SetSeriesXAxis
   METHOD RMC_SetSeriesYAxis
   METHOD RMC_SetSingleBarColors
   METHOD RMC_SetWatermark
   METHOD RMC_SetXAXAlignment
   METHOD RMC_SetYAXAlignment
   METHOD RMC_SetXAXDecimalDigits
   METHOD RMC_SetYAXDecimalDigits
   METHOD RMC_SetXAXFontSize
   METHOD RMC_SetYAXFontSize
   METHOD RMC_SetXAXLabels
   METHOD RMC_SetYAXLabels
   METHOD RMC_SetXAXLabelAlignment
   METHOD RMC_SetYAXLabelAlignment
   METHOD RMC_SetXAXLineColor
   METHOD RMC_SetYAXLineColor
   METHOD RMC_SetXAXLineStyle
   METHOD RMC_SetYAXLineStyle
   METHOD RMC_SetXAXMaxValue
   METHOD RMC_SetYAXMaxValue
   METHOD RMC_SetXAXMinValue
   METHOD RMC_SetYAXMinValue
   METHOD RMC_SetXAXText
   METHOD RMC_SetYAXText
   METHOD RMC_SetXAXTextColor
   METHOD RMC_SetYAXTextColor
   METHOD RMC_SetXAXTickcount
   METHOD RMC_SetYAXTickcount
   METHOD RMC_SetXAXUnit
   METHOD RMC_SetYAXUnit

   METHOD Paint

   METHOD SetPos
   METHOD SetSize
   METHOD GetPos
   METHOD GetSize
   METHOD SetWindowHandle

   ACCESS METHOD DOSError
   ACCESS METHOD RMCError
   ACCESS METHOD nPosX
   ACCESS METHOD nPosY
   ACCESS METHOD nSizeX
   ACCESS METHOD nSizeY

   protected:
   VAR oWin            // XbpCrt, XbpParts, XbpDialog
   VAR oParent         // XbpCrt, XbpParts, XbpDialog():drawingarea
   VAR hDLL
   VAR hWin            // Handle von/from oParent
   VAR nCtrlId
   VAR _nPosX
   VAR _nPosY
   VAR _nSizeX
   VAR _nSizeY
   VAR nDOSError
   VAR nRMCError
   VAR RMC_X
   VAR RMC_Y
   VAR oHide

   METHOD RMC_DeleteChart  // INTERN / INTERNAL

ENDCLASS

METHOD _RMChart:init(oWin,lShowErrorMessage,nX,nY,_nSizeX,_nSizeY)

   ::SetWindowHandle(oWin)
   if lShowErrorMessage = NIL
      ::lShowErrorMessage := .f.
   else
      ::lShowErrorMessage := lShowErrorMessage
   endif

   #ifdef RMC_ZEIG_INFOS
   ::lShowErrorMessage := .t.
   #endif

   ::lExportOnly := .f.
   ::_nPosX  := iif(nX=NIL,0,nX)
   ::_nPosY  := iif(nY=NIL,0,nY)
   ::_nSizeX := iif(_nSizeX=NIL,100,_nSizeX)
   ::_nSizeY := iif(_nSizeY=NIL,100,_nSizeY)
   ::setPos()   // initialisiert die RMC_Positionen
   ::hDLL := DllLoad("RMCHART.DLL")
   ::nCtrlId := int(seconds()*100)

   if ::hDLL <= 0
      ::IsOK := .f.
      ::nDOSError := DosError()
      if ::lShowErrorMessage
         MsgBox("RMCHART.DLL nicht vorhanden!")
      endif
   endif

   if ::oParent # NIL
      ::oHide := XbpStatic():new(::oParent,,{0,0},::oParent:currentSize(), {{ XBP_PP_FGCLR, XBPSYSCLR_TRANSPARENT }} )
      ::oHide:clipParent := .f.
      ::oHide:create()
   endif

return self
//---------------------------------------------------------------------------
METHOD _RMChart:destroy()
   if ::lExportOnly
      ::RMC_DeleteChart()
   endif
   if ::oHide # NIL
      if ::oHide:status() == XBP_STAT_CREATE
         ::oHide:destroy()
      endif
   endif
*   if ! DllUnLoad(::hDLL)
*      MsgBox("DllUnload() FEHLER ERROR")
*   endif
return self
//---------------------------------------------------------------------------
METHOD _RMChart:SetWindowHandle(oWin)
   if ! IsNil(oWin)
      ::oWin := oWin
   else
      if IsNil(::oWin)
         ::oWin := SetAppWindow()
      endif
   endif
   if ::oWin:isDerivedFrom("XbpDialog")
      ::oParent := ::oWin:drawingArea       // XbpDialog
*      ::oWin:SetDisplayFocus := {|| ::Paint() }
   else
      ::oParent := ::oWin                   // XbpCrt - XbpParts ...
   endif
   ::hWin := ::oParent:getHWND()
   ::oParent:paint := {|| ::Paint() }
return NIL
//---------------------------------------------------------------------------
METHOD _RMChart:setPos(x,y)    // Xbase Positionen links unten
   if ! IsNil(x)
      ::_nPosX  := x
   endif
   if ! IsNil(y)
      ::_nPosY  := y
   endif
   ::RMC_X := ::_nPosX          // RMC links oben
   ::RMC_Y := ::_nPosY          // Umsetzung geht noch nicht nH - ::_nSizeY
   if ::oHide # NIL
      ::oHide:setPos({::_nPosX,::_nPosY})
   endif
return NIL
//---------------------------------------------------------------------------
METHOD _RMChart:setSize(x,y)
   if ! IsNil(x)
      if valtype(x)="A"         // {x,y}
         ::_nSizeX  := x[1]
         ::_nSizeY  := x[2]
         y := NIL
      else
         ::_nSizeX  := x
      endif
   endif
   if ! IsNil(y)
      ::_nSizeY  := y
   endif
   if ::oHide # NIL
      ::oHide:setSize({::_nSizeX,::_nSizeY})
   endif
   ::setPos()                   // Position anpassen #### REFRESH ???
return {::_nSizeX,::_nSizeY}
//---------------------------------------------------------------------------
METHOD _RMChart:getPos()        // Xbase Positionen links unten
return {::_nPosX,::_nPosY}
//---------------------------------------------------------------------------
METHOD _RMChart:getSize()
return {::_nSizeX,::_nSizeY}
//---------------------------------------------------------------------------
METHOD _RMChart:nPosX
return ::_nPosX
//---------------------------------------------------------------------------
METHOD _RMChart:nPosY
return ::_nPosY
//---------------------------------------------------------------------------
METHOD _RMChart:nSizeX
return ::_nSizeX
//---------------------------------------------------------------------------
METHOD _RMChart:nSizeY
return ::_nSizeY
//---------------------------------------------------------------------------
METHOD _RMChart:DOSError()
   DEFAULT ::nDosError TO 0
return ::nDosError
//---------------------------------------------------------------------------
METHOD _RMChart:RMCError()
   DEFAULT ::nRMCError TO 0
return ::nRMCError
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_CreateChart(nBackColor,nCtrlStyle,sBgImage,sFontName)
   DEFAULT ::lExportOnly TO .f.
   DEFAULT sBgImage TO ""
   DEFAULT sFontName TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_CREATECHART",;
                        ::hWin,::nCtrlId,::RMC_X,::RMC_Y,::nSizeX,::nSizeY,;
                        nBackColor,nCtrlStyle,::lExportOnly,sBgImage,sFontName)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_CreateChartFromFile(cRMCFile)
   DEFAULT cRMCFile TO ""
   if ! FExists(cRMCFile)
      ::nDOSError := 2            // File does not exist - Datei gibt es nicht
      ::nRMCError := RMC_ERROR_RMCFILE
   else
      DEFAULT ::lExportOnly TO .f.
      ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_CREATECHARTFROMFILE",;
                        ::hWin,::nCtrlId,::RMC_X,::RMC_Y,::lExportOnly,cRMCFile)
      if ::nRMCError=0
         ::RMC_GetChartSizeFromFile(cRMCFile) // get the size
         ::SetPos()
      endif
   endif
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_GetChartSizeFromFile(cRMCFile)
   DEFAULT cRMCFile TO ""
   if ! FExists(cRMCFile)
      ::nDOSError := 2            // File does not exist - Datei gibt es nicht
      ::nRMCError := RMC_ERROR_RMCFILE
   else
      DEFAULT ::lExportOnly TO .f.
      ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_GETCHARTSIZEFROMFILE",;
                               cRMCFile,@::_nSizeX,@::_nSizeY)
   endif
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_WriteRMCFile(sRMCFile)
   DEFAULT sRMCFile TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_WRITERMCFILE",::nCtrlId,@sRMCFile)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_WriteRMC2String()
   Local cRMC := ""
   if ! ::RMC_WriteRMCFile(@cRMC)
      cRMC := ""
   endif
return cRMC
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_Draw(nAnz)
   local x
   DEFAULT nAnz TO 2  // Ist seltsamer Weise zur Anzeige doppelt ntig ?
   for x := 1 to nAnz
       ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_DRAW",::nCtrlId)
   next
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_Draw2File(sFileName,nNewSizeX,nNewSizeY)
   DEFAULT sFileName TO ""
   DEFAULT nNewSizeX TO 0     // BAD result - Schlechte Ergebnisse
   DEFAULT nNewSizeY TO 0     // BAD result - Schlechte Ergebnisse
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_DRAW2FILE",;
                           ::nCtrlId,sFileName,nNewSizeX,nNewSizeY)
   if ::nRMCError = RMC_ERROR_EMF .and. ::lShowErrorMessage
      MsgBox("Datei "+sFileName+" konnte nicht erzeugt werden !")
   endif
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_Draw2Clipboard(nType)
   DEFAULT nType TO RMC_BMP // RMC_EMF
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_DRAW2CLIPBOARD",::nCtrlId,nType)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_Draw2Printer(nPrinterDC,nLeft,nTop,nWidth,nHeight,nType)
   DEFAULT nType TO RMC_EMF
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_DRAW2PRINTER",::nCtrlId,;
                           nPrinterDC,nLeft,nTop,nWidth,nHeight,nType )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------


/* Funktioniert nicht, daher direkt Paint ...
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_Paint()     // sollte nicht ntig sein ...
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_PAINT",::nCtrlId)
return ::nRMCError=0  // keine Fehler - no error ?
*/

//---------------------------------------------------------------------------
METHOD _RMChart:Paint()     // ist ntig bei Fenster-Focus-Wechsel !
return ::RMC_Draw(1)
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_DeleteChart()
   if ::lExportOnly
      ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_DELETECHART",::nCtrlId)
   endif
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddRegion(nLeft,nTop,nWidth,nHeight,sFooter,nShowBorder)
   DEFAULT sFooter TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDREGION",::nCtrlId,;
                           nLeft,nTop,nWidth,nHeight,sFooter,nShowBorder)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddCaption(nRegion,sCaption,nBackColor,nTextColor,nFontsize,nFontbold)
   DEFAULT sCaption TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDCAPTION",::nCtrlId,;
                  nRegion,sCaption,nBackColor,nTextColor,nFontsize,nFontbold)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddLegend(nRegion,sLegendtext,nAlignment,nBackColor,nStyle,;
                                      nTextColor,nFontsize,nFontbold)
   DEFAULT sLegendtext TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDLEGEND",::nCtrlId,;
                  nRegion,sLegendtext,nAlignment,nBackColor,nStyle,;
                                      nTextColor,nFontsize,nFontbold)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddGrid(nRegion,nBackColor,nAsGradient,nLeft,nTop,nWidth,nHeight,nBiColor)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDGRID",::nCtrlId,;
              nRegion,nBackColor,nAsGradient,nLeft,nTop,nWidth,nHeight,nBiColor)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddLabelAxis(nRegion,sLabels,nAxisCount,nTickcount,;
                        nAlignment,nFontsize,nTextcolor,nTextalignment,;
                        nLinecolor,nLinestyle,sText)
   DEFAULT sLabels TO ""
   DEFAULT sText   TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDLABELAXIS",::nCtrlId,;
              nRegion,sLabels,nAxisCount,nTickcount,nAlignment,nFontsize,;
              nTextcolor,nTextalignment,nLinecolor,nLinestyle,sText)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddDataAxis(nRegion,nAlignment,nMinvalue,nMaxvalue,;
                                nTickcount,nFontsize,nTextcolor,nLinecolor,;
                                nLinestyle,nDecimalDigits,sUnit,sText,;
                                sLabels,nLabelAlignment)
   DEFAULT nMinvalue TO 0
   DEFAULT nMaxvalue TO 0
   DEFAULT sUnit   TO ""
   DEFAULT sText   TO ""
   DEFAULT sLabels TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDDATAAXIS",::nCtrlId,;
                           nRegion,nAlignment,D2P(nMinvalue,1),D2P(nMinvalue,2),;
                           D2P(nMaxvalue,1),D2P(nMaxvalue,2),nTickcount,nFontsize,;
                           nTextcolor,nLinecolor,nLinestyle,nDecimalDigits,sUnit,;
                           sText,sLabels,nLabelAlignment)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddBarSeries(nRegion,aNumData,nType,nStyle,nIsLucent,nColor,;
                                 nIsHorizontal,nWhichDataAxis,nValueLabelOn,;
                                 nPointsPerColumn,nHatchMode)
   local cNumData,nDataValuesCount
   do case
      case IsNil(aNumData)           // No Data - keine Daten
           aNumData := {0}
           nDataValuesCount := 0
      case Valtype(aNumData)="N"     // only 1 Number, nur 1 Wert
           aNumData := {aNumData}
           nDataValuesCount := 1
      otherwise                      // Xbase++ Array of values
           nDataValuesCount := len(aNumData)
   endcase
   cNumData := D2RefStr(aNumData)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDBARSERIES",::nCtrlId,;
                           nRegion,cNumData,nDataValuesCount,nType,nStyle,;
                           nIsLucent,nColor,nIsHorizontal,nWhichDataAxis,;
                           nValueLabelOn,nPointsPerColumn,nHatchMode )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddLineSeries(nRegion,aNumData,aPointsPerColumn,nType,;
                           nStyle,nLineStyle,nIsLucent,nColor,nSymbol,;
                           nWhichDataAxis,nValueLabelOn,nHatchMode)
   local cNumData,nDataValuesCount,cPointsPerColumn,nPointsPerColumnCount
   do case
      case IsNil(aNumData)           // No Data - keine Daten
           aNumData := {0}
           nDataValuesCount := 0
      case Valtype(aNumData)="N"     // only 1 Number, nur 1 Wert
           aNumData := {aNumData}
           nDataValuesCount := 1
      otherwise                      // Xbase++ Array of values
           nDataValuesCount := len(aNumData)
   endcase
   cNumData := D2RefStr(aNumData)

   do case
      case IsNil(aPointsPerColumn)   // No Info - keine Info
           aPointsPerColumn := {0}
           nPointsPerColumnCount := 0
      case Valtype(aPointsPerColumn)="N"     // only 1 Number, nur 1 Wert
           aPointsPerColumn := {aPointsPerColumn}
           nPointsPerColumnCount := 1
      otherwise                      // Xbase++ Array of values
           nPointsPerColumnCount := len(aPointsPerColumn)
   endcase
   cPointsPerColumn := D2RefStr(aPointsPerColumn)

   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDLINESERIES",::nCtrlId,;
                           nRegion,cNumData,nDataValuesCount,cPointsPerColumn,;
                           nPointsPerColumnCount,nType,nStyle,nLineStyle,nIsLucent,;
                           nColor,nSymbol,nWhichDataAxis,nValueLabelOn,nHatchMode)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddHighLowSeries(nRegion,aNumData,aPointsPerColumn,;
                           nStyle,nWhichDataAxis,nColorLow,nColorHigh)
   local cNumData,nDataValuesCount,cPointsPerColumn,nPointsPerColumnCount
   do case
      case IsNil(aNumData)           // No Data - keine Daten
           aNumData := {0}
           nDataValuesCount := 0
      case Valtype(aNumData)="N"     // only 1 Number, nur 1 Wert
           aNumData := {aNumData}
           nDataValuesCount := 1
      otherwise                      // Xbase++ Array of values
           nDataValuesCount := len(aNumData)
   endcase
   cNumData := D2RefStr(aNumData)

   do case
      case IsNil(aPointsPerColumn)   // No Info - keine Info
           aPointsPerColumn := {0}
           nPointsPerColumnCount := 0
      case Valtype(aPointsPerColumn)="N"     // only 1 Number, nur 1 Wert
           aPointsPerColumn := {aPointsPerColumn}
           nPointsPerColumnCount := 1
      otherwise                      // Xbase++ Array of values
           nPointsPerColumnCount := len(aPointsPerColumn)
   endcase
   cPointsPerColumn := D2RefStr(aPointsPerColumn)

   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDHIGHLOWSERIES",::nCtrlId,;
                           nRegion,cNumData,nDataValuesCount,cPointsPerColumn,;
                           nPointsPerColumnCount,nStyle,nWhichDataAxis,nColorLow,nColorHigh)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddVolumeBarSeries(nRegion,aNumData,aPointsPerColumn,;
                                                 nColor,nWhichDataAxis)
   local cNumData,nDataValuesCount,cPointsPerColumn,nPointsPerColumnCount
   do case
      case IsNil(aNumData)           // No Data - keine Daten
           aNumData := {0}
           nDataValuesCount := 0
      case Valtype(aNumData)="N"     // only 1 Number, nur 1 Wert
           aNumData := {aNumData}
           nDataValuesCount := 1
      otherwise                      // Xbase++ Array of values
           nDataValuesCount := len(aNumData)
   endcase
   cNumData := D2RefStr(aNumData)

   do case
      case IsNil(aPointsPerColumn)   // No Info - keine Info
           aPointsPerColumn := {0}
           nPointsPerColumnCount := 0
      case Valtype(aPointsPerColumn)="N"     // only 1 Number, nur 1 Wert
           aPointsPerColumn := {aPointsPerColumn}
           nPointsPerColumnCount := 1
      otherwise                      // Xbase++ Array of values
           nPointsPerColumnCount := len(aPointsPerColumn)
   endcase
   cPointsPerColumn := D2RefStr(aPointsPerColumn)

   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDVOLUMEBARSERIES",::nCtrlId,;
                           nRegion,cNumData,nDataValuesCount,cPointsPerColumn,;
                           nPointsPerColumnCount,nColor,nWhichDataAxis)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddXAxis(nRegion,nAlignment,nMinvalue,nMaxvalue,;
                                nTickcount,nFontsize,nTextcolor,nLinecolor,;
                                nLinestyle,nDecimalDigits,sUnit,sText,;
                                sLabels,nLabelAlignment)
   if IsNil(nAlignment) .or. nAlignment=0
      nAlignment := RMC_XAXISBOTTOM
   endif
   DEFAULT nMinvalue TO 0
   DEFAULT nMaxvalue TO 0
   DEFAULT sUnit   TO ""
   DEFAULT sText   TO ""
   DEFAULT sLabels TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDXAXIS",::nCtrlId,;
                           nRegion,nAlignment,D2P(nMinvalue,1),D2P(nMinvalue,2),;
                           D2P(nMaxvalue,1),D2P(nMaxvalue,2),nTickcount,nFontsize,;
                           nTextcolor,nLinecolor,nLinestyle,nDecimalDigits,sUnit,;
                           sText,sLabels,nLabelAlignment)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddYAxis(nRegion,nAlignment,nMinvalue,nMaxvalue,;
                                nTickcount,nFontsize,nTextcolor,nLinecolor,;
                                nLinestyle,nDecimalDigits,sUnit,sText,;
                                sLabels,nLabelAlignment)
   if IsNil(nAlignment) .or. nAlignment=0
      nAlignment := RMC_YAXISLEFT
   endif
   DEFAULT nMinvalue TO 0
   DEFAULT nMaxvalue TO 0
   DEFAULT sUnit   TO ""
   DEFAULT sText   TO ""
   DEFAULT sLabels TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDYAXIS",::nCtrlId,;
                           nRegion,nAlignment,D2P(nMinvalue,1),D2P(nMinvalue,2),;
                           D2P(nMaxvalue,1),D2P(nMaxvalue,2),nTickcount,nFontsize,;
                           nTextcolor,nLinecolor,nLinestyle,nDecimalDigits,sUnit,;
                           sText,sLabels,nLabelAlignment)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddXYSeries(nRegion,aNumDataX,aNumDataY,nColor,;
                                nStyle,nLineStyle,nSymbol,;
                                nWhichXAxis,nWhichYAxis,nValueLabelOn)
   local cNumDataX,cNumDataY,nDataValuesCountX,nDataValuesCountY
   do case
      case IsNil(aNumDataX)           // No Data - keine Daten
           aNumDataX := {0}
           nDataValuesCountX := 0
      case Valtype(aNumDataX)="N"     // only 1 Number, nur 1 Wert
           aNumDataX := {aNumDataX}
           nDataValuesCountX := 1
      otherwise                      // Xbase++ Array of values
           nDataValuesCountX := len(aNumDataX)
   endcase
   cNumDataX := D2RefStr(aNumDataX)

   do case
      case IsNil(aNumDataY)           // No Data - keine Daten
           aNumDataY := {0}
           nDataValuesCountY := 0
      case Valtype(aNumDataY)="N"     // only 1 Number, nur 1 Wert
           aNumDataY := {aNumDataY}
           nDataValuesCountY := 1
      otherwise                      // Xbase++ Array of values
           nDataValuesCountY := len(aNumDataY)
   endcase
   cNumDataY := D2RefStr(aNumDataY)

   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDXYSERIES",::nCtrlId,;
                           nRegion,cNumDataX,nDataValuesCountX,;
                                   cNumDataY,nDataValuesCountY,;
                           nColor,nStyle,nLineStyle,nSymbol,;
                           nWhichXAxis,nWhichYAxis,nValueLabelOn )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_AddGridlessSeries(nRegion,aNumData,aColor,nStyle, nAlignment,;
                                      nExplodemode, nIsLucent, nValueLabelOn,;
                                      nHatchMode, nStartAngle)
   local cNumData,nDataValuesCount,cColor,nColorCount
   do case
      case IsNil(aNumData)           // No Data - keine Daten
           aNumData := {0}
           nDataValuesCount := 0
      case Valtype(aNumData)="N"     // only 1 Number, nur 1 Wert
           aNumData := {aNumData}
           nDataValuesCount := 1
      otherwise                      // Xbase++ Array of values
           nDataValuesCount := len(aNumData)
   endcase
   cNumData := D2RefStr(aNumData)

altd()

   do case
      case IsNil(aColor)
           aColor      := {0}
           nColorCount := 0
      case Valtype(aColor)="N"     // only 1 Number, nur 1 Wert
           aColor := {aColor}
           nColorCount := 1
      otherwise                      // Xbase++ Array of values
           nColorCount := len(aColor)
   endcase
   cColor := L2RefStr(aColor)

   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_ADDGRIDLESSSERIES",::nCtrlId,;
                           nRegion,cNumData,nDataValuesCount,cColor,nColorCount,;
                           nStyle, nAlignment,nExplodemode, nIsLucent,;
                           nValueLabelOn, nHatchMode, nStartAngle)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCaptionBGColor(nRegion,nColor)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCAPTIONBGCOLOR",::nCtrlId,;
                           nRegion,nColor)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCaptionText(nRegion,sText)
   DEFAULT sText TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCAPTIONTEXT",::nCtrlId,;
                           nRegion,sText)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCaptionTextColor(nRegion,nColor)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCAPTIONTEXTCOLOR",::nCtrlId,;
                           nRegion,nColor)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCaptionFontBold(nRegion,nFontBold)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCAPTIONFONTBOLD",::nCtrlId,;
                           nRegion,nFontBold)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCaptionFontSize(nRegion,nFontSize)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCAPTIONFONTSIZE",::nCtrlId,;
                           nRegion,nFontSize)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCtrlBGColor(nColor)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCTRLBGCOLOR",::nCtrlId,nColor)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCtrlBGImage(sBGImage)
   DEFAULT sBGImage TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCTRLBGIMAGE",::nCtrlId,sBGImage)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCtrlFont(sFontName)
   DEFAULT sFontName TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCTRLFONT",::nCtrlId,sFontName)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCtrlPos(nLeft, nTop, nRelative)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCTRLPOS",::nCtrlId,;
                                            nLeft, nTop, nRelative)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCtrlSize(nWidth, nHeight, nRelative)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCTRLSIZE",::nCtrlId,;
                                          nWidth, nHeight  , nRelative)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetCtrlStyle(nStyle)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETCTRLSTYLE",::nCtrlId,nStyle)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXAlignment(nRegion,nAlignment)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXALIGNMENT",::nCtrlId,;
                  nRegion,nAlignment)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXDecimalDigits(nRegion,nDecimalDigits, nAxisIndex)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXDECIMALDIGITS",::nCtrlId,;
                  nRegion,nDecimalDigits, nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXFontSize(nRegion, nFontSize)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXFONTSIZE",::nCtrlId,;
                  nRegion, nFontSize)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXLineColor(nRegion, nColor)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXLINECOLOR",::nCtrlId,;
                  nRegion, nColor)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXLabelAlignment(nRegion, nLabelAlignment, nAxisIndex)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXLABELALIGNMENT",::nCtrlId,;
                  nRegion, nLabelAlignment, nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXLabels(nRegion, sLabels, nAxisIndex)
   DEFAULT sLabels TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXLABELS",::nCtrlId,;
                  nRegion, sLabels, nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXLineStyle(nRegion, nStyle)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXLINESTYLE",::nCtrlId,;
                  nRegion, nStyle)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXMaxValue(nRegion,nMaxvalue,nAxisIndex)
   DEFAULT nMaxvalue TO 0
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXMAXVALUE",::nCtrlId,;
                           nRegion,D2P(nMaxvalue,1),D2P(nMaxvalue,2),nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXMinValue(nRegion,nMinvalue,nAxisIndex)
   DEFAULT nMinvalue TO 0
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXMINVALUE",::nCtrlId,;
                           nRegion,D2P(nMinvalue,1),D2P(nMinvalue,2),nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXText(nRegion, sText, nAxisIndex)
   DEFAULT sText TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXTEXT",::nCtrlId,;
                  nRegion, sText, nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXTextColor(nRegion, nColor )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXTEXTCOLOR",::nCtrlId,;
                  nRegion, nColor )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXTickcount(nRegion, nTickCount )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXTICKCOUNT",::nCtrlId,;
                  nRegion, nTickCount )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetDAXUnit(nRegion, sUnit, nAxisIndex)
   DEFAULT sUnit TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETDAXUNIT",::nCtrlId,;
                  nRegion, sUnit, nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetGridBGColor(nRegion, nColor )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETGRIDBGCOLOR",::nCtrlId,;
                  nRegion, nColor )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetGridGradient(nRegion, nGradient )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETGRIDGRADIENT",::nCtrlId,;
                  nRegion, nGradient )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXAlignment(nRegion,nAlignment)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXALIGNMENT",::nCtrlId,;
                  nRegion,nAlignment)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXCount(nRegion, nLabelAxisCount)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXCOUNT",::nCtrlId,;
                  nRegion,nLabelAxisCount)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXFontSize(nRegion, nFontSize)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXFONTSIZE",::nCtrlId,;
                  nRegion, nFontSize)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXLabelAlignment(nRegion, nLabelAlignment)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXLABELALIGNMENT",::nCtrlId,;
                  nRegion, nLabelAlignment)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXLabels(nRegion, sLabels)
   DEFAULT sLabels TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXLABELS",::nCtrlId,;
                  nRegion, sLabels)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXLineColor(nRegion, nColor )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXLINECOLOR",::nCtrlId,;
                  nRegion, nColor )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXLineStyle(nRegion, nStyle )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXLINESTYLE",::nCtrlId,;
                  nRegion, nStyle )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXText(nRegion, sText)
   DEFAULT sText TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXTEXT",::nCtrlId,;
                  nRegion, sText)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXTextColor(nRegion, nColor )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXTEXTCOLOR",::nCtrlId,;
                  nRegion, nColor )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLAXTickcount(nRegion, nTickCount )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLAXTICKCOUNT",::nCtrlId,;
                  nRegion, nTickCount )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLegendAlignment(nRegion,nAlignment)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLEGENDALIGNMENT",::nCtrlId,;
                  nRegion,nAlignment)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLegendBGColor(nRegion, nColor )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLEGENDBGCOLOR",::nCtrlId,;
                  nRegion, nColor )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLegendFontBold(nRegion, nFontBold )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLEGENDFONTBOLD",::nCtrlId,;
                  nRegion, nFontBold )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLegendFontSize(nRegion, nFontSize )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLEGENDFONTSIZE",::nCtrlId,;
                  nRegion, nFontSize )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLegendStyle(nRegion, nStyle )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLEGENDSTYLE",::nCtrlId,;
                  nRegion, nStyle )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLegendText(nRegion, sText)
   DEFAULT sText TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLEGENDTEXT",::nCtrlId,;
                  nRegion, sText)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetLegendTextColor(nRegion, nColor )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETLEGENDTEXTCOLOR",::nCtrlId,;
                  nRegion, nColor )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetRegionBorder(nRegion,nShowBorder)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETREGIONBORDER",::nCtrlId,;
                  nRegion,nShowBorder)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetRegionFooter(nRegion, sFooter)
   DEFAULT sFooter TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETREGIONFOOTER",::nCtrlId,;
                  nRegion, sFooter)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetRegionMargin(nRegion, nLeft, nTop, nWidth, nHeight )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETREGIONMARGIN",::nCtrlId,;
                  nRegion, nLeft, nTop, nWidth, nHeight)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetRMCFile(sRMCFile)
   DEFAULT sRMCFile TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETRMCFILE",::nCtrlId, sRMCFile)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesColor(nRegion, nSeries, nColor, nIndex)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESCOLOR",::nCtrlId,;
                  nRegion, nSeries, nColor, nIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesData(nRegion, nSeries, aNumData, nYData)
   local cNumData,nDataValuesCount
   do case
      case IsNil(aNumData)           // No Data - keine Daten
           aNumData := {0}
           nDataValuesCount := 0
      case Valtype(aNumData)="N"     // only 1 Number, nur 1 Wert
           aNumData := {aNumData}
           nDataValuesCount := 1
      otherwise                      // Xbase++ Array of values
           nDataValuesCount := len(aNumData)
   endcase
   cNumData := D2RefStr(aNumData)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESDATA",::nCtrlId,;
                           nRegion, nSeries, cNumData,nDataValuesCount, nYData)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesDataAxis(nRegion, nSeries, nWhichAxis)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESDATA",::nCtrlId,;
                            nRegion, nSeries, nWhichAxis)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesDataFile(nRegion, nSeries, sFilename, sLines, sFields,;
                                      sFieldDelimiter, nYData)
   DEFAULT sFilename       TO ""
   DEFAULT sLines          TO ""
   DEFAULT sFields         TO ""
   DEFAULT sFieldDelimiter TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESDATAFILE",::nCtrlId,;
                                      nRegion, nSeries, sFilename, sLines, sFields,;
                                      sFieldDelimiter, nYData)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesExplodeMode(nRegion, nSeries, nExplodeMode)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESEXPLODEMODE",::nCtrlId,;
                            nRegion, nSeries, nExplodeMode)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesHatchMode(nRegion, nSeries, nHatchMode)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESHATCHMODE",::nCtrlId,;
                            nRegion, nSeries, nHatchMode)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesHide(nRegion, nSeries, nHide)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESHIDE",::nCtrlId,;
                            nRegion, nSeries, nHide)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesLinestyle(nRegion, nSeries, nLinestyle)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESLINESTYLE",::nCtrlId,;
                            nRegion, nSeries, nLinestyle)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesLucent(nRegion, nSeries, nLucent)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESLUCENT",::nCtrlId,;
                            nRegion, nSeries, nLucent)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesSingleData(nRegion, nSeries, nDataValue, nDataIndex, nYData)
   DEFAULT nDataValue TO 0
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESSINGLEDATA",::nCtrlId,;
                           nRegion, nSeries, D2P(nDataValue,1), D2P(nDataValue,2),;
                           nDataIndex, nYData)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesStartAngle(nRegion, nSeries, nStartAngle)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESSTARTANGLE",::nCtrlId,;
                            nRegion, nSeries, nStartAngle)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesStyle(nRegion, nSeries, nStyle)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESSTYLE",::nCtrlId,;
                            nRegion, nSeries, nStyle)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesSymbol(nRegion, nSeries, nSymbol)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESSYMBOL",::nCtrlId,;
                            nRegion, nSeries, nSymbol)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesValuelabel(nRegion, nSeries, nValuelabel)
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESVALUELABEL",::nCtrlId,;
                            nRegion, nSeries, nValuelabel)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesVertical(nRegion, nSeries, nVertical )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESVERTICAL",::nCtrlId,;
                            nRegion, nSeries, nVertical )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesXAxis(nRegion, nSeries, nWhichXAxis )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESXAXIS",::nCtrlId,;
                            nRegion, nSeries, nWhichXAxis )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSeriesYAxis(nRegion, nSeries, nWhichYAxis )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSERIESYAXIS",::nCtrlId,;
                            nRegion, nSeries, nWhichYAxis )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetSingleBarColors(nRegion,aColor)
   local cColor,nColorCount
   do case
      case IsNil(aColor)
           aColor      := {0}
           nColorCount := 0
      case Valtype(aColor)="N"     // only 1 Number, nur 1 Wert
           aColor := {aColor}
           nColorCount := 1
      otherwise                      // Xbase++ Array of values
           nColorCount := len(aColor)
   endcase
   cColor := L2RefStr(aColor)

   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETSINGLEBARCOLORS",::nCtrlId,;
                           nRegion,cColor,nColorCount)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetWatermark(sWatermark, nColor, nLucentValue,nAlignment, nFontSize)
   DEFAULT sWatermark TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETWATERMARK",::nCtrlId,;
                  sWatermark, nColor, nLucentValue, nAlignment, nFontSize )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXAlignment(nRegion, nAlignment, nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXALIGNMENT",::nCtrlId,;
                  nRegion, nAlignment, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXAlignment(nRegion, nAlignment, nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXALIGNMENT",::nCtrlId,;
                  nRegion, nAlignment, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXDecimalDigits(nRegion, nDecimalDigits, nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXDECIMALDIGITS",::nCtrlId,;
                  nRegion, nDecimalDigits, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXDecimalDigits(nRegion, nDecimalDigits, nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXDECIMALDIGITS",::nCtrlId,;
                  nRegion, nDecimalDigits, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXFontSize(nRegion, nFontSize, nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXFONTSIZE",::nCtrlId,;
                  nRegion, nFontSize, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXFontSize(nRegion, nFontSize, nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXFONTSIZE",::nCtrlId,;
                  nRegion, nFontSize, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXLabels(nRegion, sLabels, nAxisIndex )
   DEFAULT sLabels TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXLABELS",::nCtrlId,;
                  nRegion, sLabels, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXLabels(nRegion, sLabels, nAxisIndex )
   DEFAULT sLabels TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXLABELS",::nCtrlId,;
                  nRegion, sLabels, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXLabelAlignment(nRegion, nLabelAlignment, nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXLABELALIGNMENT",::nCtrlId,;
                  nRegion, nLabelAlignment, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXLabelAlignment(nRegion, nLabelAlignment, nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXLABELALIGNMENT",::nCtrlId,;
                  nRegion, nLabelAlignment, nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXLineColor(nRegion, nColor , nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXLINECOLOR",::nCtrlId,;
                  nRegion, nColor , nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXLineColor(nRegion, nColor , nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXLINECOLOR",::nCtrlId,;
                  nRegion, nColor , nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXLineStyle(nRegion, nStyle , nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXLINESTYLE",::nCtrlId,;
                  nRegion, nStyle , nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXLineStyle(nRegion, nStyle , nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXLINESTYLE",::nCtrlId,;
                  nRegion, nStyle , nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXMaxValue(nRegion,nMaxvalue,nAxisIndex)
   DEFAULT nMaxvalue TO 0
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXMAXVALUE",::nCtrlId,;
                           nRegion,D2P(nMaxvalue,1),D2P(nMaxvalue,2),nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXMaxValue(nRegion,nMaxvalue,nAxisIndex)
   DEFAULT nMaxvalue TO 0
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXMAXVALUE",::nCtrlId,;
                           nRegion,D2P(nMaxvalue,1),D2P(nMaxvalue,2),nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXMinValue(nRegion,nMinvalue,nAxisIndex)
   DEFAULT nMinvalue TO 0
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXMINVALUE",::nCtrlId,;
                           nRegion,D2P(nMinvalue,1),D2P(nMinvalue,2),nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXMinValue(nRegion,nMinvalue,nAxisIndex)
   DEFAULT nMinvalue TO 0
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXMINVALUE",::nCtrlId,;
                           nRegion,D2P(nMinvalue,1),D2P(nMinvalue,2),nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXText(nRegion,sText,nAxisIndex)
   DEFAULT sText TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXTEXT",::nCtrlId,;
                           nRegion,sText,nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXText(nRegion,sText,nAxisIndex)
   DEFAULT sText TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXTEXT",::nCtrlId,;
                           nRegion,sText,nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXTextColor(nRegion, nColor , nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXTEXTCOLOR",::nCtrlId,;
                  nRegion, nColor , nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXTextColor(nRegion, nColor , nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXTEXTCOLOR",::nCtrlId,;
                  nRegion, nColor , nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXTickcount(nRegion, nTickcount , nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXTICKCOUNT",::nCtrlId,;
                  nRegion, nTickcount , nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXTickcount(nRegion, nTickcount , nAxisIndex )
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXTICKCOUNT",::nCtrlId,;
                  nRegion, nTickcount , nAxisIndex )
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetXAXUnit(nRegion,sUnit,nAxisIndex)
   DEFAULT sUnit TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETXAXUNIT",::nCtrlId,;
                           nRegion,sUnit,nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?
//---------------------------------------------------------------------------
METHOD _RMChart:RMC_SetYAXUnit(nRegion,sUnit,nAxisIndex)
   DEFAULT sUnit TO ""
   ::nRMCError := DllCall( ::hDLL, DLL_STDCALL,"RMC_SETYAXUNIT",::nCtrlId,;
                           nRegion,sUnit,nAxisIndex)
return ::nRMCError=0  // keine Fehler - no error ?

