///////////////////////////////////////////////////////////////////////////////
//
//  Vom Xbase++ FormDesigner generierter Klassen Code
//    Erstellt am: 07.08.2008 Zeit: 14:43:02
//
//  Contents  :
//    Diese Datei enthlt das Gerst zur Implementierung der Nutzungsebene.
//    Daher kann und soll diese Datei verndert werden.
//
///////////////////////////////////////////////////////////////////////////////

#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"

#define CRLF chr(13)+chr(10)

******************************************************************************
* Von der Darstellungsklasse abgeleitete Klasse zur Implementierung der
* Programmlogik. Die Instanzvariablen der einzelnen Objekte sind in der
* Klasse _TestFenster deklariert.
******************************************************************************
CLASS TestFenster FROM _TestFenster
   EXPORTED:
      VAR nMode
      METHOD init
      METHOD create
      METHOD ChangeMode
      METHOD HB_Uhr_Min
      METHOD HB_Uhr_Max
ENDCLASS

******************************************************************************
* Formular initialisieren
******************************************************************************
METHOD TestFenster:init( oParent, oOwner, aPos, aSize, aPP, lVisible )
   * Methode der Superklasse rufen
   ::_TestFenster:init( oParent, oOwner, aPos, aSize, aPP, lVisible )
   ::close := {|| ::destroy() }

   ::nMode    := 0
   ::pbUhrStart:activate := {|| ::HB_UHR:Start() }
   ::pbUhrStop:activate  := {|| ::HB_UHR:Stop() }
   ::pbModi:activate     := {|| ::ChangeMode() }
   ::pbMin:activate      := {|| ::HB_Uhr_Min() }
   ::pbMax:activate      := {|| ::HB_Uhr_Max() }

   // hier knnte ::HB_UHR (das HB_CLOCK Objekt) modifiziert werden
   * ::HB_UHR - wer diese beiden Zeilen entfernt, sieht eine andere Uhr ;-)
*   ::HB_UHR:ClockBitmapFileNameOrObject := "bild.jpg"
*   ::HB_UHR:lForceZiffern := .t.

RETURN self

******************************************************************************
* Systemresourcen anfordern
******************************************************************************
METHOD TestFenster:create( oParent, oOwner, aPos, aSize, aPP, lVisible )

   * Methode der Superklasse rufen
   ::_TestFenster:create( oParent, oOwner, aPos, aSize, aPP, lVisible )

   ::mleInfo:setData("Standard ist eigener Hintergrund."+CRLF+;
                     "Schriftart:"+CRLF+;
                     "compoundName:    "+chr(9)+::HB_UHR:oClockZiffernFont:compoundName+CRLF+;
                     "height:          "+chr(9)+var2Char(::HB_UHR:oClockZiffernFont:height)+CRLF+;
                     "nominalPointSize:"+chr(9)+var2Char(::HB_UHR:oClockZiffernFont:nominalPointSize)+CRLF   )

   * Formular anzeigen
   ::show()

   ::HB_UHR:Start()

RETURN self
*----------------------------------------------------------------------------
METHOD TestFenster:HB_Uhr_Min()
   local aSize := ::HB_UHR:currentSize()
   local aPos  := ::HB_UHR:currentPos()
   local aRect := {aPos[1]-1,aPos[2]-1,aPos[1]+aSize[1]+4,aPos[2]+aSize[2]+4}
   if aSize[1] >= 100
      aSize[1] -= 10
      aSize[2] -= 10
      aPos[1]  +=  5
      aPos[2]  +=  5
      if aSize[1] < 50
         aSize := { 50,50 }
         aPos  := {160,145}
      endif
      ::HB_UHR:Stop()
      ::HB_UHR:setPosAndSize(aPos,aSize,.f.) // das Control wird kleiner, jetzt nicht zeigen
      ::invalidateRect(aRect) // jetzt alte Gre lschen
      ::HB_UHR:Start()
   endif
return self
*----------------------------------------------------------------------------
METHOD TestFenster:HB_Uhr_Max()
   local aSize := ::HB_UHR:currentSize()
   local aPos  := ::HB_UHR:currentPos()
   local aRect
   if aSize[1] < 200
      aSize[1] += 10
      aSize[2] += 10
      aPos[1]  -=  5
      aPos[2]  -=  5
      if aSize[1] > 200
         aSize := {200,200}
         aPos  := {10,95}
      endif
      aRect := {aPos[1]-1,aPos[2]-1,aPos[1]+aSize[1]+4,aPos[2]+aSize[2]+4}
      ::HB_UHR:Stop()
      ::HB_UHR:setPosAndSize(aPos,aSize,.t.) // sofort anzeigen ist OK
      ::invalidateRect(aRect) // jetzt alte Gre lschen
      ::HB_UHR:Start()
   endif
return self
*----------------------------------------------------------------------------
METHOD TestFenster:ChangeMode()
   local cBMP

   ::HB_UHR:Stop()
   ::HB_UHR:ClockDatumsAnzeige  := .t.
   ::HB_UHR:ClockZeigerZeigSek  := .t.

   do case
      case ::nMode = 0
           cBMP := "Bild.bmp"
           ::HB_UHR:lForceZiffern := .f.
           ::mleInfo:setData(" -> nur fremder Hintergrund: "+cBMP)
           ::HB_UHR:SetBitmap(cBMP)
      case ::nMode = 1
           cBMP := "Bild.bmp"
           ::HB_UHR:lForceZiffern := .t.
           ::mleInfo:setData(" -> fremder Hintergrund: "+cBMP+" mit Ziffern")
           ::HB_UHR:SetBitmap(cBMP)
      case ::nMode = 2
           cBMP := "Bild.PNG"
           ::HB_UHR:lForceZiffern := .f.
           ::mleInfo:setData(" -> nur fremder Hintergrund: "+cBMP)
           ::HB_UHR:SetBitmap(cBMP)
      case ::nMode = 3
           cBMP := "HIMMEL.BMP"
           ::HB_UHR:lForceZiffern := .t.
           ::mleInfo:setData(" -> fremder Hintergrund (sehr groe Datei): "+cBMP+" mit Ziffern")
           ::HB_UHR:SetBitmap(cBMP)
      case ::nMode = 4
           cBMP := "Bild.JPG"
           ::HB_UHR:lForceZiffern := .t.
           ::mleInfo:setData(" -> fremder Hintergrund: "+cBMP+" mit Ziffern")
           ::HB_UHR:SetBitmap(cBMP)
      case ::nMode = 5
           ::mleInfo:setData(" -> Nur eigener Hintergrund, Gelber Hintergrund")
           ::HB_UHR:lForceZiffern := .f. // wird berschrieben, eigener Hintergrund hat immer Ziffern.
           ::HB_UHR:ClockBG    := GRA_CLR_YELLOW // GraMakeRGBColor({220,250,255}) // einfache Hintergrundfarbe
           ::HB_UHR:ClockOutBG := GRA_CLR_RED
           ::HB_UHR:SetBitmap()
      case ::nMode = 6
           ::mleInfo:setData(" -> Nur eigener Hintergrund, Cyan Hintergrund")
           ::HB_UHR:lForceZiffern := .f. // wird berschrieben, eigener Hintergrund hat immer Ziffern.
           ::HB_UHR:ClockOutBG := NIL
           ::HB_UHR:ClockBG := GRA_CLR_CYAN // GraMakeRGBColor({220,250,255}) // einfache Hintergrundfarbe
           ::HB_UHR:SetBitmap()
      case ::nMode = 7
           cBMP := "Bild.JPG"
           ::HB_UHR:lForceZiffern       := .t.
           ::HB_UHR:ClockDatumsAnzeige  := .f.
           ::mleInfo:setData(" -> fremder Hintergrund: "+cBMP+" mit Ziffern ohne Datum")
           ::HB_UHR:SetBitmap(cBMP)
      case ::nMode = 8
           ::mleInfo:setData(" -> Nur eigener Hintergrund, ohne Sekundenzeiger")
           ::HB_UHR:ClockZeigerZeigSek := .f.
           ::HB_UHR:ClockBG := GRA_CLR_YELLOW // GraMakeRGBColor({220,250,255}) // einfache Hintergrundfarbe
           ::HB_UHR:SetBitmap()
      otherwise
           ::mleInfo:setData(" -> Nur eigener Hintergrund, Standardfarben, ENDE !")
           ::nMode := -1 // wird gleich erhht
           ::HB_UHR:lForceZiffern := .f. // wird berschrieben, eigener Hintergrund hat immer Ziffern.
           ::HB_UHR:SetStdColors()
           ::HB_UHR:SetBitmap()
   endcase
   ::nMode++
   ::HB_UHR:Start()
RETURN self


******************************************************************************
* Main Prozedur zum Testen des Formulars
******************************************************************************
PROCEDURE Main

   LOCAL nEvent, oXbp:=NIL, mp1:=NIL, mp2:=NIL

   set charset to ansi
   set date german
   set century on

#ifdef DEBUG
set alternate to test.txt
set alternate on
#endif

   TestFenster():New():Create()

   nEvent := xbe_None
   WHILE nEvent != xbeP_Close
      nEvent := AppEvent ( @mp1, @mp2, @oXbp )
      oXbp:HandleEvent ( nEvent, mp1, mp2 )
      IF nEvent == xbeP_Quit
         QUIT   // AppQuit()
      ENDIF
   ENDDO

RETURN

//EOF
/////
