#ifndef _HB_CLOCK_
#define _HB_CLOCK_

/* HB_CLOCK.PRG - 1.02 vom 28.08.2008

   Anwendung: im XppFD einfach ein XbpStatic() einbauen und spter im Quellcode
              von der Klasse HB_CLOCK() statt XbpStatic() ableiten (ndern).
              Aktuell ist der Datumsfont gleich dem des Ziffernblattes.
              Ansonsten kann man fast alles in der abgeleiteten INIT anpassen
              und diese Datei einfach ins Projekt einbinden.

              Natrlich knnt Ihr auch gerne diese Datei komplett umarbeiten,
              dann nennt aber die Classe nach eurem Namen ;-)

              Fragen bitte bevorzugt im   www.XbaseForum.de      oder
              per eMail an den Autor      Hubert.Brandel@gmx.de

              Jeder darf diesen Quellcode frei nutzen, solange er nicht behauptet
              ich htte bei Ihm abgeschrieben ;-)

*/


#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"


*================================================================
CLASS HB_Clock FROM XbpStatic
   EXPORTED:
      VAR ClockBG                // Ziffernblatt
      VAR ClockOutBG             // auerhalb des Ziffernblattes
      VAR ClockRandBreite        // Ziffernblatt Randbreite
      VAR ClockRandRadius        // Radius des Randes
      VAR ClockRandCLR           // Farbe des Randes
      VAR ClockMitte             // Mittelpunkt der Uhr (immer ungerade !)
      VAR ClockZiffernRadius     // Radius der Ziffern
      VAR ClockZiffernFontName   // Verdana
      VAR ClockZiffernFontNPSize // nominalPointSize -> normalerweise 0
      VAR ClockZiffernFontTeiler // Standard: ClockZiffernRadius / ClockZiffernFontTeiler
      VAR ClockZiffernFontZuRandFaktor // Standard: 0.7 * Fontbreite gibt Druckabstand zu Rand
      VAR oClockZiffernFont
      VAR oClockDatumsFont
      VAR ClockDatumsAnzeige
      VAR ClockDatumsColorFG
      VAR ClockDatumsColorBG
      VAR ClockZeigerZeigSek       // Sekundenzeiger anzeigen ?
      VAR ClockZeigerLenStd        // Zeigerlnge vorgeben, oder dynamisch berechnen lassen.
      VAR ClockZeigerLenMin
      VAR ClockZeigerLenSek
      VAR ClockZeigerLenFaktorStd  // Faktor vorgeben, falls Lnge nicht vorgegeben.
      VAR ClockZeigerLenFaktorMin
      VAR ClockZeigerLenFaktorSek
      VAR ClockZeigerWidthStd      // Dicke der Zeiger vorgeben.
      VAR ClockZeigerWidthMin
      VAR ClockZeigerWidthSek
      VAR ClockZeigerColorStd
      VAR ClockZeigerColorMin
      VAR ClockZeigerColorSek
      VAR ClockBitmapFileNameOrObject

      VAR lForceZiffern          // Ziffern immer anzeigen ?

      METHOD init
      METHOD create
      METHOD configure
      METHOD SetStdColors
      METHOD SetBitmap
      METHOD Resize
      METHOD Start
      METHOD Stop
      METHOD Running
      METHOD Paint

   PROTECTED:
      VAR oGrundBMP
      VAR oThread
      VAR IsClockRunning
      VAR IsStopClock
      VAR cLastTime
      VAR NurEigeneUhr

      METHOD ShowZeiger
      METHOD RefreshUhr
      METHOD ReCalcLen

ENDCLASS
*----------------------------------------------------------------
METHOD HB_Clock:Init(oParent,oOwner,aPos,aSize,aPresParam,lVisible)
   ::XbpStatic:Init(oParent,oOwner,aPos,aSize,aPresParam,lVisible)
   ::type := XBPSTATIC_TYPE_BITMAP // das ist Standard bei HB_Clock()
   ::clipChildren  := .f.
   ::clipParent    := .F.

   // viele Variablen werden erst nach ::XbpStatic:Create() gesetzt
*   ::ClockBG              := GraMakeRGBColor({220,250,255}) // einfache Hintergrundfarbe
*   ::ClockRandCLR         := GRA_CLR_BLACK
   ::ClockOutBG           := NIL // wird erst spter gesetzt, oder in abgeleiteter INIT vorgegeben
   ::ClockDatumsAnzeige   := .t. // Datum anzeigen
*   ::ClockDatumsColorFG   := GRA_CLR_BLUE
*   ::ClockDatumsColorBG   := XBPSYSCLR_3DHIGHLIGHT
   ::ClockZiffernFontName := "Verdana"
   ::ClockZiffernFontZuRandFaktor := .7
   ::lForceZiffern            := .f.
   ::NurEigeneUhr             := .t.
   ::oThread  := Thread():new()
   ::IsClockRunning := .f.
   ::IsStopClock    := .f.
   ::cLastTime      := "00:00:00"

   ::ClockZeigerZeigSek       := .t.
*   ::ClockZeigerColorStd      := GRA_CLR_BLACK
*   ::ClockZeigerColorMin      := GRA_CLR_RED
*   ::ClockZeigerColorSek      := GRA_CLR_BLUE
   ::ClockZeigerWidthStd      := 7
   ::ClockZeigerWidthMin      := 5
   ::ClockZeigerWidthSek      := 2
   ::ClockZeigerLenFaktorStd  := .55
   ::ClockZeigerLenFaktorMin  := .75
   ::ClockZeigerLenFaktorSek  := .85

   ::ClockBitmapFileNameOrObject      := NIL
    // das funktioniert leider nicht richtig, am Besten die Grafik mit einem
    // Grafikprogramm exact anpassen. Etwas grer ist kein Problem.
*   ::options   := XBPSTATIC_BITMAP_SCALED  // Standardmig vergrern / verkleinern
   ::options   := XBPSTATIC_BITMAP_TILED

   ::SetStdColors()

return self
*----------------------------------------------------------------
METHOD HB_Clock:SetStdColors()
   ::ClockBG              := GraMakeRGBColor({220,250,255}) // einfache Hintergrundfarbe
   ::ClockRandCLR         := GRA_CLR_BLACK
   ::ClockDatumsColorFG   := GRA_CLR_BLUE
   ::ClockDatumsColorBG   := XBPSYSCLR_3DHIGHLIGHT
   ::ClockZeigerColorStd  := GRA_CLR_BLACK
   ::ClockZeigerColorMin  := GRA_CLR_RED
   ::ClockZeigerColorSek  := GRA_CLR_BLUE
return self

*----------------------------------------------------------------
METHOD HB_Clock:Create(oParent,oOwner,aPos,aSize,aPresParam,lVisible)
   ::XbpStatic:Create(oParent,oOwner,aPos,aSize,aPresParam,lVisible)
   DEFAULT oParent TO ::SetParent() // meist wird der schon in INIT() festgelegt
   // hier werden viele DEFAULT verwendet, damit manuelle nderungen
   // in abgeleiteten INIT Methoden mglich sind.
   // Fr Resize etc. wird aber nur noch berechnet  ->  ::ReCalcLen()

   // drfte ja eigentlich nicht vorkommen
   DEFAULT aSize TO ::currentSize()
   // falls nichts anderes vorgegeben wurde wird nun die uere Hintergrundfarbe festgelegt.
   do case
      case IsNil(oParent)
           * Der Parent sollte immer vorhanden sein !
           DEFAULT ::ClockOutBG      TO XBPSYSCLR_DIALOGBACKGROUND
      case oParent:isDerivedFrom( "XbpCrt" )
           *** Bitte diese Farbe im aufrufenden Programm INIT() festlegen:   ::ClockOutBG
           DEFAULT ::ClockOutBG      TO XBPSYSCLR_DIALOGBACKGROUND
      case IsNil(oParent:setColorBG()) .or. oParent:setColorBG() == XBPSYSCLR_TRANSPARENT
           DEFAULT ::ClockOutBG      TO oParent:setParent():setColorBG()
      otherwise
           DEFAULT ::ClockOutBG      TO oParent:setColorBG()
   endcase

   DEFAULT ::ClockRandBreite TO 3

   // viele Variablen werden erst nach ::XbpStatic:Create() gesetzt
   // die Mitte der Uhr wird aus der Gre des Controlls ermittelt
   ::ClockMitte := { int(aSize[1]/2),int(aSize[2]/2) }
   // die muss auf ungerader Position liegen, sonst werden die Kreisfunktionen
   // eventuell verzerrt.
   if ::ClockMitte[1] % 2 == 0
      ::ClockMitte[1]--
   endif
   if ::ClockMitte[2] % 2 == 0
      ::ClockMitte[2]--
   endif
   // die Abzge bercksichtigen den Platz fr den Schatten !
   // die Mitte bleibt aber unverndert, wegen der fremden Hintergrnde (kein Schatten)
   ::ClockRandRadius    := min(::ClockMitte[1]-2,::ClockMitte[2]-1)
   ::ClockRandRadius    := int(::ClockRandRadius - ::ClockRandBreite/2)

   // aktuell fr Datum und Ziffern
   ::oClockZiffernFont := XbpFont():new()
   ::oClockZiffernFont:familyName := ::ClockZiffernFontName

   DEFAULT ::ClockZiffernFontTeiler TO 5 // 1/5 vom Radius

   if IsNil(::ClockZiffernFontNPSize) .or. empty(::ClockZiffernFontNPSize)
      // Ohne Vorgabe wird dynamisch berechnet
      ::oClockZiffernFont:nominalPointSize := ::ClockZiffernFontNPSize := 0
      ::oClockZiffernFont:height           := max(int(::ClockRandRadius/::ClockZiffernFontTeiler),10)
      ::oClockZiffernFont:width            := 0
   else
      ::oClockZiffernFont:nominalPointSize := ::ClockZiffernFontNPSize
      ::oClockZiffernFont:height           := 0
      ::oClockZiffernFont:width            := 0
   endif
   ::oClockZiffernFont:create()
   // Radius
   ::ClockZiffernRadius := ::ClockRandRadius - ::oClockZiffernFont:height * ::ClockZiffernFontZuRandFaktor
   DEFAULT ::ClockZeigerLenStd TO int(::ClockZiffernRadius * ::ClockZeigerLenFaktorStd)
   DEFAULT ::ClockZeigerLenMin TO int(::ClockZiffernRadius * ::ClockZeigerLenFaktorMin)
   DEFAULT ::ClockZeigerLenSek TO int(::ClockZiffernRadius * ::ClockZeigerLenFaktorSek)

   ::SetBitmap(::ClockBitmapFileNameOrObject)

return self
*----------------------------------------------------------------
METHOD HB_Clock:configure(oParent,oOwner,aPos,aSize,aPresParam,lVisible)
   ::XbpStatic:configure(oParent,oOwner,aPos,aSize,aPresParam,lVisible)
   ::ReCalcLen()
   ::SetBitmap(::ClockBitmapFileNameOrObject)
   ::ShowZeiger()
return self
*----------------------------------------------------------------
METHOD HB_Clock:SetBitmap(xBmp)   // xBMP -> cDateiname, oXbpBitmap oder NIL (selbst erzeugen)
   local oPS, oBMP, nStd, nWinkel, aPos, aAttr, aOldAttr, oAltFont, aStrAttr, aOldStrAttr
   local oParent := ::SetParent()
   do case
      case IsNil(oParent)
           * Der Parent sollte immer vorhanden sein !
           DEFAULT ::ClockOutBG      TO XBPSYSCLR_DIALOGBACKGROUND
      case oParent:isDerivedFrom( "XbpCrt" )
           *** Bitte diese Farbe im aufrufenden Programm INIT() festlegen:   ::ClockOutBG
           DEFAULT ::ClockOutBG      TO XBPSYSCLR_DIALOGBACKGROUND
      case IsNil(oParent:setColorBG()) .or. oParent:setColorBG() == XBPSYSCLR_TRANSPARENT
           DEFAULT ::ClockOutBG      TO oParent:setParent():setColorBG()
      otherwise
           DEFAULT ::ClockOutBG      TO oParent:setColorBG()
   endcase

   if ValType(xBmp)="O"           // oXbpBitmap wurde bergeben
      oPS  := XbpPresSpace():new():create()
      oBMP := xBmp                // entweder geladen oder als Resource
      oBMP:presSpace(oPS)
      ::NurEigeneUhr := .f.
      ::ClockBitmapFileNameOrObject := xBmp
   else
      oPS  := XbpPresSpace():new():create()
      oBMP := XbpBitmap():new():create(oPS)
      oBMP:presSpace(oPS)
      if ValType(xBmp)="C"
         IF oBMP:loadfile(xBmp)
            ::ClockBitmapFileNameOrObject := xBmp
            ::NurEigeneUhr := .f.
         else
            ::ClockBitmapFileNameOrObject := NIL
            ::NurEigeneUhr := .t.
            msgbox(xBmp+" konnte nicht geladen werden","Fehler")
         ENDIF
      else
         ::ClockBitmapFileNameOrObject := NIL
         ::NurEigeneUhr := .t.
      endif
      IF ::NurEigeneUhr
         ::ClockBitmapFileNameOrObject := NIL
         oBMP:make(::currentSize()[1],::currentSize()[2],1,24)
         aOldAttr := graSetAttrLine(oPS)  // alter Inhalt retten
         // Auenrnder wie der Control-/Dialog-Hintergrund
         GraSetColor(oPS, ::ClockOutBG, ::ClockOutBG )
         GraBox( oPS, {0,0},::currentSize(),GRA_FILL)
         // Liniengrundeinstellung
         aAttr := Array( GRA_AL_COUNT )
         aAttr[GRA_AL_WIDTH] := ::ClockRandBreite
         GraSetAttrLine(oPS, aAttr )
         // Schatten der Uhr
         GraSetColor(oPS,XBPSYSCLR_3DSHADOW,XBPSYSCLR_3DSHADOW)
         GraArc(oPS,{::ClockMitte[1]+2,::ClockMitte[2]-1},::ClockRandRadius)
         // Ziffernblatt
         GraSetColor(oPS,::ClockBG,::ClockBG)
         GraArc(oPS,::ClockMitte,::ClockRandRadius,,,,GRA_FILL)
         // Schatten im Ziffernblatt
         GraSetColor(oPS,XBPSYSCLR_3DSHADOW,XBPSYSCLR_3DSHADOW)
         GraArc(oPS,{::ClockMitte[1]+1,::ClockMitte[2]-1},::ClockRandRadius)
         // Rand
         GraSetColor(oPS,::ClockRandCLR,::ClockBG)
         GraArc(oPS,::ClockMitte,3,,,,GRA_FILL)
         GraArc(oPS,::ClockMitte,::ClockRandRadius)

         graSetAttrLine(oPS, aOldAttr )

         oAltFont := GraSetFont(oPS,::oClockZiffernFont)
         aStrAttr    := Array( GRA_AS_COUNT )
         aStrAttr[GRA_AS_HORIZALIGN] := GRA_HALIGN_CENTER
         aStrAttr[GRA_AS_VERTALIGN]  := GRA_VALIGN_HALF
         aOldStrAttr := GraSetAttrString(oPS,aStrAttr)

         for nStd := 1 to 12
             nWinkel := 90-(nStd)*30
             aPos := HbGradToXppArray(nWinkel,::ClockZiffernRadius)
             aPos[1] += ::ClockMitte[1]+1  // nur bei den Ziffern fr den eigenen Hintergrund
             aPos[2] += ::ClockMitte[2]    // weil der in X-Achse 1 lnger als in Y-Achse ist.
             GraStringAt(oPS,aPos,allTrim(str(nStd)))
         next

         graSetAttrString(oPS,aOldStrAttr)
         graSetFont(oPS,oAltFont)

         oAltFont:destroy()

      endif
   endif

   oPS:destroy()
   ::oGrundBMP := oBMP
   ::setCaption(::oGrundBMP)
Return self
*----------------------------------------------------------------
METHOD HB_Clock:resize(aOldSize,aNewSize)
   ::XbpStatic:resize(aOldSize,aNewSize)
   ::ReCalcLen()
   ::SetBitmap(::ClockBitmapFileNameOrObject)
   ::ShowZeiger()
return self
*----------------------------------------------------------------
METHOD HB_Clock:ReCalcLen()
   local aSize := ::currentSize()
   // die Mitte der Uhr wird aus der Gre des Controlls ermittelt
   ::ClockMitte := { int(aSize[1]/2),int(aSize[2]/2) }
   // die muss auf ungerader Position liegen, sonst werden die Kreisfunktionen
   // eventuell verzerrt.
   if ::ClockMitte[1] % 2 == 0
      ::ClockMitte[1]--
   endif
   if ::ClockMitte[2] % 2 == 0
      ::ClockMitte[2]--
   endif
   // die Abzge bercksichtigen den Platz fr den Schatten !
   // die Mitte bleibt aber unverndert, wegen der fremden Hintergrnde (kein Schatten)
   ::ClockRandRadius    := min(::ClockMitte[1]-2,::ClockMitte[2]-1)
   ::ClockRandRadius    := int(::ClockRandRadius - ::ClockRandBreite/2)

   // aktuell fr Datum und Ziffern
   ::oClockZiffernFont:familyName   := ::ClockZiffernFontName
   if IsNil(::ClockZiffernFontNPSize) .or. empty(::ClockZiffernFontNPSize)
      // Ohne Vorgabe wird dynamisch berechnet
      ::oClockZiffernFont:nominalPointSize := ::ClockZiffernFontNPSize := 0
      ::oClockZiffernFont:height           := max(int(::ClockRandRadius/::ClockZiffernFontTeiler),10)
      ::oClockZiffernFont:width            := 0
   else
      ::oClockZiffernFont:nominalPointSize := ::ClockZiffernFontNPSize
      ::oClockZiffernFont:height           := 0
      ::oClockZiffernFont:width            := 0
   endif
   ::oClockZiffernFont:configure()
   // Radius
   ::ClockZiffernRadius := ::ClockRandRadius - ::oClockZiffernFont:height * ::ClockZiffernFontZuRandFaktor
   ::ClockZeigerLenStd  := int(::ClockZiffernRadius * ::ClockZeigerLenFaktorStd)
   ::ClockZeigerLenMin  := int(::ClockZiffernRadius * ::ClockZeigerLenFaktorMin)
   ::ClockZeigerLenSek  := int(::ClockZiffernRadius * ::ClockZeigerLenFaktorSek)
return self
*----------------------------------------------------------------
METHOD HB_Clock:paint(aRect)
   ::XbpStatic:paint(aRect)
   ::ShowZeiger(.t.)              // .t. -> Aufruf durch paint
return self
*----------------------------------------------------------------
METHOD HB_Clock:Start()
   if ! ::IsClockRunning
      ::oThread:start({|| ::Running() })
   endif
return ::IsClockRunning
*----------------------------------------------------------------
METHOD HB_Clock:Stop()
   LOCAL nEvent, oXbp:=NIL, mp1:=NIL, mp2:=NIL
   nEvent := xbe_None
   ::IsStopClock := .t.
   do while ! ::oThread:synchronize(1)
      nEvent := AppEvent ( @mp1, @mp2, @oXbp,1)
      do case
         case nEvent == xbe_None
              * nix machen
         case nEvent == xbeP_Quit .or. nEvent == xbeP_Close
              quit
         otherwise
              oXbp:HandleEvent ( nEvent, mp1, mp2 )
      endcase
   enddo
return ! ::IsClockRunning
*----------------------------------------------------------------------------
METHOD HB_Clock:Running()
   if ! ::IsClockRunning
      ::IsClockRunning := .t.
      ::IsStopClock := .f.
      ::invalidateRect()   // einmal erzwingen !
      sleep(1)
      do while ! ::IsStopClock
         if ::cLastTime < time()
            ::RefreshUhr()  // .t. erzwingt komplette Neuanzeige
            ::ShowZeiger()
         endif
         sleep(1)
      enddo
      ::IsClockRunning := .f.
   endif
return self
*----------------------------------------------------------------------------
METHOD HB_Clock:ShowZeiger(IsPaint)
   local oPS, nStd, nMin, nSek, cNeuZeit
   local aOldAttr, aAttr, nSekAlt, x, nWinkel, aPos
   local aStrAttr, aOldStrAttr, oOldFont

   DEFAULT IsPaint TO .f.

   IF ::IsClockRunning

      oPS := ::lockPS()

      oOldFont    := GraSetFont(oPS,::oClockZiffernFont)
      aOldStrAttr := graSetAttrString(oPS)
      aOldAttr    := graSetAttrLine(oPS)

      cNeuZeit := time()
      nStd     := val(left(cNeuZeit,2))
      if nStd > 12
         nStd -= 12
      endif
      nMin     :=  val(substr(cNeuZeit,4,2))
      nSek     :=  val(substr(cNeuZeit,7,2))
      nSekAlt  :=  int(val(substr(::cLastTime,7,2)))

      // Anzeige zurcksetzen erledigt eine eigene Methode

      if ::NurEigeneUhr

         ::lForceZiffern := .t.  // eigene Uhr immer mit eigenen Ziffern

         aAttr := Array( GRA_AL_COUNT )
         aAttr[GRA_AL_WIDTH]   := 2
         aAttr[GRA_AL_COLOR]   := ::ClockBG
         aAttr[GRA_AL_MIXMODE] := GRA_FGMIX_OVERPAINT
         graSetAttrLine(oPS, aAttr )
         GraLine(oPS,::ClockMitte,MinSec2aPos(nSekAlt,::ClockZeigerLenSek,::ClockMitte))
         graSetAttrLine(oPS, aOldAttr )
      endif

      // Stunden - Ziffern anzeigen
      IF ::lForceZiffern .and. ! ::NurEigeneUhr // bei eigener Uhr werden Ziffen
                                                // in Hintergrund Bitmap erzeugt.
         aStrAttr    := Array( GRA_AS_COUNT )
         aStrAttr[GRA_AS_HORIZALIGN] := GRA_HALIGN_CENTER
         aStrAttr[GRA_AS_VERTALIGN]  := GRA_VALIGN_HALF
         GraSetAttrString(oPS,aStrAttr)
         for x := 1 to 12    // nStd ist schon unter Verwendung !!!
             nWinkel := 90-(x)*30
             aPos := HbGradToXppArray(nWinkel,::ClockZiffernRadius)
             aPos[1] += ::ClockMitte[1]   // bei fremdem Hintergrund nicht +1 !!!
             aPos[2] += ::ClockMitte[2]
             GraStringAt(oPS,aPos,allTrim(str(x)))
         next
      endif

      if ::ClockDatumsAnzeige
         // Datum
         aStrAttr    := Array( GRA_AS_COUNT )
         aStrAttr[GRA_AS_HORIZALIGN] := GRA_HALIGN_CENTER
         aStrAttr[GRA_AS_VERTALIGN]  := GRA_VALIGN_HALF
         aStrAttr[GRA_AS_COLOR]      := ::ClockDatumsColorFG
         aStrAttr[GRA_AS_BACKCOLOR]  := ::ClockDatumsColorBG
         aStrAttr[GRA_AS_MIXMODE]    := GRA_FGMIX_OVERPAINT
         aStrAttr[GRA_AS_BGMIXMODE]  := GRA_BGMIX_OVERPAINT // GRA_BGMIX_LEAVEALONE
         GraSetAttrString(oPS,aStrAttr)
         GraStringAt(oPS,{::ClockMitte[1],::ClockMitte[2]/3*2}," "+dtoc(date())+" ")
      endif

      // Zeiger
      aAttr := Array( GRA_AL_COUNT )
      GraSetColor(oPS,GRA_CLR_BLACK,::ClockBG)

      // Stunden
      aAttr[GRA_AL_WIDTH]      := ::ClockZeigerWidthStd
      aAttr[GRA_AL_COLOR]      := ::ClockZeigerColorStd
      aAttr[GRA_AL_MIXMODE]    := GRA_FGMIX_OVERPAINT
      graSetAttrLine(oPS, aAttr )
      GraLine(oPS,::ClockMitte,Std2aPos(nStd,nMin,::ClockZeigerLenStd,::ClockMitte))

      // Minuten
      aAttr[GRA_AL_WIDTH]      := ::ClockZeigerWidthMin
      aAttr[GRA_AL_COLOR]      := ::ClockZeigerColorMin
      aAttr[GRA_AL_MIXMODE]    := GRA_FGMIX_OVERPAINT
      graSetAttrLine(oPS, aAttr )
      GraLine(oPS,::ClockMitte,MinSec2aPos(nMin,::ClockZeigerLenMin,::ClockMitte))

      // Sekunden
      if ::ClockZeigerZeigSek
         aAttr[GRA_AL_WIDTH]   := ::ClockZeigerWidthSek
         aAttr[GRA_AL_COLOR]   := ::ClockZeigerColorSek
         aAttr[GRA_AL_MIXMODE] := GRA_FGMIX_OVERPAINT
         graSetAttrLine(oPS, aAttr )
         GraLine(oPS,::ClockMitte,MinSec2aPos(nSek,::ClockZeigerLenSek,::ClockMitte))
      endif

      // Mitte
      GraArc(oPS,::ClockMitte,3,,,,GRA_FILL)

      graSetAttrLine(oPS,aOldAttr)
      graSetAttrString(oPS,aOldStrAttr)
      GraSetFont(oPS,oOldFont)

      ::unlockPS(oPS)

      ::cLastTime := time()

   endif
return self

*----------------------------------------------------------------------------
METHOD HB_Clock:RefreshUhr(lForceRefreshAll)
   local nSek, cNeuZeit, nSekAlt, aRect, nORX, nORY, nCMX, nCMY
   DEFAULT lForceRefreshAll TO .f.

   IF ::IsClockRunning

      cNeuZeit := time()
      nSek     := val(substr(cNeuZeit,7,2))
      nSekAlt := int(val(substr(::cLastTime,7,2)))

      // Anzeige zurcksetzen

      if left(cNeuZeit,5) # left(::cLastTime,5) .or.;
         nSekAlt - nSek > 1 .or. lForceRefreshAll // jede Minute komplett refresh
         ::invalidateRect()
      else
         if ! ::NurEigeneUhr
            nORX   := ::currentSize()[1]
            nORY   := ::currentSize()[2]
            nCMX   := ::ClockMitte[1]
            nCMY   := ::ClockMitte[2]
            aRect  := NIL
            do case // recht grob ...
               case ! ::ClockDatumsAnzeige
                    aRect  := NIL          // immer alles refreshen
               case nSekAlt >= 1  .and. nSekAlt < 15
                    aRect := { nCMX-10,nCMY-10,nORX,nORY}
               case nSekAlt = 15
                    aRect := { nCMX-15,nCMY-15,nORX,nCMY+15}
               case nSekAlt < 30
                    aRect := { nCMX-10,0,nORX,nCMY+10}
               case nSekAlt = 30
                    aRect := { nCMX-15,0,nCMX+15,nCMY+15}
               case nSekAlt < 45
                    aRect := { 0,0,nCMX+10,nCMY+10 }
               case nSekAlt = 45
                    aRect := { 0,nCMY-15,nCMX+15,nCMY+15}
               case nSekAlt < 60
                    aRect := { 0,nCMY-10,nCMX+10,nORY }
               case nSekAlt = 60
                    aRect := { nCMX-15,nCMY-15,nCMX+15,nORY}
               otherwise
                    * ???
            endcase
            ::invalidateRect(aRect)
         endif
      endif

   endif

return self




*====================================================================
Function Std2aPos(nStd,nMin,nLen,aMitte)
   local nWinkel := 90-(nStd+nMin/60)*30   // Stundenzeiger soll sich jede Minute bewegen.
   local aPos := HbGradToXppArray(nWinkel,nLen)
   aPos[1] += aMitte[1]
   aPos[2] += aMitte[2]
return aPos
*--------------------------------------------------------------------
Function MinSec2aPos(nWert,nLen,aMitte)
   local nWinkel := 90-(nWert)*6
   local aPos := HbGradToXppArray(nWinkel,nLen)
   aPos[1] += aMitte[1]
   aPos[2] += aMitte[2]
return aPos
*--------------------------------------------------------------------
function HbGradToXppArray(nDrehen,nFaktor)         // noch nicht perfekt ########### prfen !!!"
   local nX, nY, aCosSin, nDrehenInt

   DEFAULT nFaktor TO 1    // Werte zwischen -1 und 1, fr Ausgabe in Bildpunkten sind diese Werte zu klein
                           // ber Faktor kann die Lnge bestimmt werden:   1 = 1/10mm, 10 = 1 mm etc.
                           // Valuerange is -1 to 1, for printtext etc. are the values to low
                           // the length could be defined with nFaktor:   1 = 1/10mm, 10 = 1 mm etc.

   aCosSin :=  { {1.0000000000000000,0.0000000000000000} , ;   // 0 Grad -> nDrehenInt+1 -> 1. Element
                 {0.9998476951563913,0.0174524064372835} , ;   // 1 Grad -> nDrehenInt+1 -> 2. Element
                 {0.9993908270190958,0.0348994967025010} , ;
                 {0.9986295347545739,0.0523359562429438} , ;
                 {0.9975640502598243,0.0697564737441253} , ;
                 {0.9961946980917455,0.0871557427476582} , ;   // Falls jemand eine bessere Funktion wei, bitte mitteilen.
                 {0.9945218953682733,0.1045284632676535} , ;   // if someone knows a better (fast) way, let me know.
                 {0.9925461516413220,0.1218693434051475} , ;
                 {0.9902680687415704,0.1391731009600654} , ;
                 {0.9876883405951378,0.1564344650402309} , ;
                 {0.9848077530122080,0.1736481776669303} , ;
                 {0.9816271834476640,0.1908089953765448} , ;
                 {0.9781476007338058,0.2079116908177593} , ;
                 {0.9743700647852353,0.2249510543438650} , ;
                 {0.9702957262759965,0.2419218955996677} , ;
                 {0.9659258262890683,0.2588190451025208} , ;
                 {0.9612616959383189,0.2756373558169992} , ;
                 {0.9563047559630355,0.2923717047227367} , ;
                 {0.9510565162951535,0.3090169943749474} , ;
                 {0.9455185755993169,0.3255681544571567} , ;
                 {0.9396926207859084,0.3420201433256687} , ;
                 {0.9335804264972018,0.3583679495453003} , ;
                 {0.9271838545667874,0.3746065934159120} , ;
                 {0.9205048534524404,0.3907311284892738} , ;
                 {0.9135454576426009,0.4067366430758001} , ;
                 {0.9063077870366499,0.4226182617406994} , ;
                 {0.8987940462991670,0.4383711467890774} , ;
                 {0.8910065241883679,0.4539904997395468} , ;
                 {0.8829475928589270,0.4694715627858908} , ;
                 {0.8746197071393958,0.4848096202463371} , ;
                 {0.8660254037844388,0.4999999999999999} , ;
                 {0.8571673007021124,0.5150380749100541} , ;
                 {0.8480480961564260,0.5299192642332049} , ;
                 {0.8386705679454240,0.5446390350150271} , ;
                 {0.8290375725550418,0.5591929034707468} , ;
                 {0.8191520442889918,0.5735764363510460} , ;
                 {0.8090169943749475,0.5877852522924731} , ;
                 {0.7986355100472929,0.6018150231520483} , ;
                 {0.7880107536067219,0.6156614753256583} , ;
                 {0.7771459614569709,0.6293203910498374} , ;
                 {0.7660444431189780,0.6427876096865393} , ;
                 {0.7547095802227720,0.6560590289905073} , ;
                 {0.7431448254773943,0.6691306063588583} , ;
                 {0.7313537016191706,0.6819983600624985} , ;
                 {0.7193398003386513,0.6946583704589973} , ;
                 {0.7071067811865476,0.7071067811865475} , ;
                 {0.6946583704589973,0.7193398003386511} , ;
                 {0.6819983600624985,0.7313537016191705} , ;
                 {0.6691306063588583,0.7431448254773941} , ;
                 {0.6560590289905073,0.7547095802227720} , ;
                 {0.6427876096865394,0.7660444431189780} , ;
                 {0.6293203910498375,0.7771459614569709} , ;
                 {0.6156614753256583,0.7880107536067219} , ;
                 {0.6018150231520484,0.7986355100472929} , ;
                 {0.5877852522924731,0.8090169943749475} , ;
                 {0.5735764363510461,0.8191520442889918} , ;
                 {0.5591929034707468,0.8290375725550418} , ;
                 {0.5446390350150272,0.8386705679454240} , ;
                 {0.5299192642332049,0.8480480961564260} , ;
                 {0.5150380749100544,0.8571673007021123} , ;
                 {0.5000000000000001,0.8660254037844386} , ;
                 {0.4848096202463371,0.8746197071393958} , ;
                 {0.4694715627858909,0.8829475928589269} , ;
                 {0.4539904997395468,0.8910065241883678} , ;
                 {0.4383711467890774,0.8987940462991670} , ;
                 {0.4226182617406994,0.9063077870366499} , ;
                 {0.4067366430758002,0.9135454576426009} , ;
                 {0.3907311284892737,0.9205048534524404} , ;
                 {0.3746065934159122,0.9271838545667874} , ;
                 {0.3583679495453004,0.9335804264972018} , ;
                 {0.3420201433256688,0.9396926207859084} , ;
                 {0.3255681544571568,0.9455185755993168} , ;
                 {0.3090169943749474,0.9510565162951535} , ;
                 {0.2923717047227368,0.9563047559630354} , ;
                 {0.2756373558169992,0.9612616959383189} , ;
                 {0.2588190451025208,0.9659258262890683} , ;
                 {0.2419218955996677,0.9702957262759965} , ;
                 {0.2249510543438652,0.9743700647852353} , ;
                 {0.2079116908177595,0.9781476007338056} , ;
                 {0.1908089953765449,0.9816271834476640} , ;
                 {0.1736481776669304,0.9848077530122080} , ;
                 {0.1564344650402309,0.9876883405951378} , ;
                 {0.1391731009600655,0.9902680687415704} , ;
                 {0.1218693434051475,0.9925461516413220} , ;
                 {0.1045284632676535,0.9945218953682733} , ;
                 {0.0871557427476581,0.9961946980917455} , ;
                 {0.0697564737441255,0.9975640502598243} , ;
                 {0.0523359562429440,0.9986295347545739} , ;
                 {0.0348994967025011,0.9993908270190958} , ;
                 {0.0174524064372836,0.9998476951563913} , ;
                 {0.0000000000000000,1.0000000000000000} }

   nDrehenInt  := int(nDrehen)                          // 23.123 -> aCosSin[23, X/Y ]

   if nDrehenInt < 0
      nDrehenInt += 360  // in den positiven Bereich schieben.
   endif

   do case
      case nDrehenInt >=  0 .and. nDrehenInt <= 90
           nX := aCosSin[nDrehenInt+1,1]
           nY := aCosSin[nDrehenInt+1,2]
      case nDrehenInt >  90 .and. nDrehenInt <=180
           nDrehenInt := 180-nDrehenInt
           nX := aCosSin[nDrehenInt+1,1] * -1
           nY := aCosSin[nDrehenInt+1,2]
      case nDrehenInt > 180 .and. nDrehenInt<=270
           nDrehenInt -= 180
           nX := aCosSin[nDrehenInt+1,1] * -1
           nY := aCosSin[nDrehenInt+1,2] * -1
      case nDrehenInt > 270 .and. nDrehenInt<=360
           nDrehenInt := 360-nDrehenInt
           nX := aCosSin[nDrehenInt+1,1]
           nY := aCosSin[nDrehenInt+1,2] * -1
   endcase

return {int(nX*nFaktor),int(nY*nFaktor)}


#endif
