/* Beispiel erstellt

   Drucken der Auftragsbesttigung aus Vorlage HBPrint im GUI/Grafikmodus

   Verwendete Dateien: Kustamm, Auftrag, AuftPos

   Parameter: Auftragsnummer

 ----------------------------------------------------------------------
    Last change: HJE 30.11.2009 18:08:37
 */
#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "xbpdev.ch"

*---------------- Fonts nur einmal erzeugen - create fonts only once ------

#define HB_FONT_7Arial          1
#define HB_FONT_8Arial          2
#define HB_FONT_14Arial         3
#define HB_FONT_10Arial         4
#define HB_FONT_12Arial         5
#define HB_FONT_12TimesNewRoman 6
#define HB_FONT_20Arial         7

proc main
    drutest1(25)
return


procedure drutest1(nAuftNummer)

local oHBPrinter
memvar cAuftNummer, n1TextZeile, n2TextZeile

private cAuftNummer := str(nAuftNummer,5)
private n1TextZeile  := 818      && Zeile 11
private n2TextZeile  := 818      && Zeile 11

/*
NetuseN("Auftrag",.f.,20)
set index to AUFTRNRI
seek cAuftNummer               && Auftragsdatei steht auf gesuchter Auftragsnummer
if .not. found()
     f_meldung(22,"Auftrag Nr. "+cAuftNummer+" nicht gefunden")
     close Auftrag
     return
endif

NetuseN("Kustamm",.f.,20)
set index to KuNumI
seek Auftrag->Kunummer    && Kundendatei steht auf Kundennummer im Auftrag
if .not. found()
   f_meldung(22,"Kunde Nr. "+Auftrag->Kunummer+" nicht gefunden")
   close Kustamm
   close Auftrag
   return
endif

NetuseN("AuftPos",.f.,20)
set index to AuftPosI
seek Auftrag->AuftragNr   && Positionsendatei steht auf erster Position
if .not. found()
   f_meldung(22,"Keine Positionen zu Auftrag "+Auftrag->AuftragNr+" gefunden")
   close Kustamm
   close Auftrag
   close AuftPos
   return
endif

NetuseN("ArtStamm",.f.,20)
set index to ArtNrI
*/

oHBPrinter := MyHBPrinter():New():create()

if oHBPrinter:IsPrinterError()             // Fehler verhindern, avoid errors
   ErrBox("Standarddrucker ist nicht verfgbar !","Druckerfehler")
   ?
   ? "Status: ",oHBPrinter:printerStatus(),"=",cPrinterStatus(oHBPrinter:printerStatus())
   wait
else

   oHBPrinter:addFont("7.Arial")
   oHBPrinter:addFont("8.Arial")
   oHBPrinter:addFont("14.Arial")
   oHBPrinter:addFont("10.Arial")
   oHBPrinter:addFont("12.Arial")
   oHBPrinter:addFont("12.Times New Roman")
   oHBPrinter:addFont({"Arial",20,.f.,.f.})

   oHBPrinter:PrintingDialog( .t. ,;   // ESC -> close
                  .t. ,;   // ALT+Enter and Enter will Print
                  xbeK_ALT_P)  // ALT+P will print
endif
/*
close KuStamm
close Auftrag
close AuftPos
close ArtStamm
*/


return

* programm enden


*-----------------------------------------------------------------------------------------------------



CLASS  MyHBPrinter from HBPrinter

   EXPORTED:
      METHOD Print                 // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                   // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
      METHOD PrintForm             // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                   // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                   // Never call ::NewPage() inside.
ENDCLASS




*-------------------------------------------------------------
* die folgenden Methoden anpassen - folowing methods has to be modified
*-------------------------------------------------------------
METHOD MyHBPrinter:PrintForm()        // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                      // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                      // Never call ::NewPage() inside.
   local altFont, x,y,cText
   memvar cAuftNummer, n1TextZeile, n2TextZeile


   ::HBPrinter:PrintForm()           // falls Vorgabeformulare bentigt werden - if you need previous forms
                                      // sonst kann es weggelassen werden       - otherwise its ok to igore it

   * in abgeleiteten Klasse - in derived classes

   altFont := ::SetFont(HB_FONT_10Arial)

   ::SetFont(HB_FONT_8Arial)

   ::PrintText(200,100, "Text")  // Text fr alle Seiten - text for all pages

   // Logo drucken rechter Rand   LOGOKLEIN.BMP muss im Verzeichnis stehen
*   ::PrintBmp(1750,790,260,260,"LOGOKLEIN.BMP")
*   ::PrintBmp(1750,790,260,260,"KBH_LOGO.JPG")

   ::SetFont(HB_FONT_10Arial)

    do case
      case ::nPageNo = 1
           ::PrintText( 200,377, "Kustamm->Kuname")  // Kundenname in Zeile 2
           ::PrintText( 200,426, "Kustamm->Kubranche")  // Zeile 3
           ::PrintText( 200,475, "Kustamm->KUSTRASSE")  //  in Zeile 4
           ::PrintText( 200,573, "Kustamm->KuPlz+' '+Kustamm->Kuort")  //  in Zeile 6
           ::PrintText( 1550,573, "dtoc(Auftrag->AuftrDatum)")  // Datum auf Zeile 6 Drucken
           n1TextZeile := 818
           if .f. // len(trim(Auftrag->Lieftext1)) > 0
              if ::GetTextLen(Auftrag->Lieftext1) > (::nRightMargin-200)
                 ::PrintMemo( 200, n1TextZeile , Auftrag->Lieftext1, "L")
                 n1TextZeile := n1TextZeile + ::LineFeed()
              else
                 ::PrintText( 200,n1TextZeile, "Auftrag->Lieftext1")  // in Zeile 11
              endif
              n1TextZeile := n1TextZeile + ::LineFeed()
           endif
           if .t. // len(trim(Auftrag->Lieftext2)) > 0
              ::PrintText( 200,n1TextZeile, "Auftrag->Lieftext2")  // in Zeile 12
              n1TextZeile := n1TextZeile +::LineFeed()
           endif
           if .t. // len(trim(Auftrag->Lieftext3)) > 0
              ::PrintText( 200,n1TextZeile, "Auftrag->Lieftext3")  // in Zeile 13
              n1TextZeile := n1TextZeile +::LineFeed()
           endif
           if .t. // len(trim(Auftrag->Lieftext4)) > 0
              ::PrintText( 200,n1TextZeile, "Auftrag->Lieftext4")  // in Zeile 14
              n1TextZeile := n1TextZeile +::LineFeed()
           endif
           IF  n1TextZeile > 818
              n1TextZeile = n1TextZeile +::LineFeed(1)
           ENDIF
           n2TextZeile := n1TextZeile
      otherwise
           n2TextZeile := 818      && zeile 11
   endcase


   ::SetFont(HB_FONT_20Arial)
   ::PrintText(200,n2TextZeile, "Auftragsbesttigung fr Auftrag Nr. XXX",,,"B",GRA_CLR_RED )  // Text fr alle Seiten - text for all pages
   n2TextZeile := n2TextZeile + ::LineFeed()     && 1 Zeilen

   ::SetFont(HB_FONT_10Arial)
   ::PrintText( 200,n2TextZeile," Kundennummer "+"Kustamm->Kunummer"+" bitte bei jeder Korrespondenz angeben.")
   ::PrintText( 1559,n2TextZeile,"E-Preis","R",210)
   if .f. // Auftrag->FrKuNummer <> "00000"
      ::PrintText( 1723,n2TextZeile,"Fracht","R",210)
   endif
   n2TextZeile := n2TextZeile +::LineFeed()
   ::PrintText( 200,n2TextZeile, "POS  Menge")
   ::PrintText( 494,n2TextZeile, "Nummer")
   ::PrintText( 820,n2TextZeile, "Artikel")
   ::PrintText(1559,n2TextZeile, "EUR","R",210)
   if .f. // Auftrag->FrKuNummer <> "00000"
      ::PrintText(1723,n2TextZeile, "EUR","R",210)
   endif
   ::PrintText(1892,n2TextZeile, "EUR","R",210)
   ::PrintLine(200,n2TextZeile+3,::nRightMargin,n2TextZeile+3)
   n2TextZeile := n2TextZeile +::LineFeed()
   n1TextZeile := n2TextZeile



   ::PrintText( 1750,2778, "Seite:"+str(::nPageNo),,, "box" )  // Seitennummer in einer kleinen Box rechts unten



   ::SetFont(HB_FONT_7Arial)
   cText := "Kommanditgesellschaft"
   ::PrintMemo( 200, 2747 , cText, "L",,,,,2936)  // Fusszeile
   //::PrintMemo( (nPosX), (nPosY), cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, cHochQuer, nMaxLen, nMaxBis,nLineFeed )

   ::SetFont(altFont)

return self

*-------------------------------------------------------------
METHOD MyHBPrinter:Print()            // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                      // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.

   local x, nMaxX, PosX, PosY, cTxt, y, nRecNo
   memvar cAuftNummer, n1TextZeile, n2TextZeile
   memvar nPosBetrag, nFrachtBetrag, nRabattBetrag, nRabattPreis, nSumFracht
   memvar zwi_summ, sk_summ, sum_qm, PosXMenge, PosXMeh, PosXArtNummer, PosXArttext
   memvar PosXEPreis, PosXFPreis, PosXProzent, PosXPosPreis, PosXSummen, PosXSuText
   memvar mwst, cPreisBinDatum

   private nPosBetrag    := 0.00
   private nFrachtBetrag := 0.00
   private nRabattBetrag := 0.00
   private nRabattPreis  := 0.00
   private nSumFracht := 0.00      //  Fracht pro Auftrag summieren
   private zwi_summ := sk_summ := 0.00
   private sum_qm := 0.00        //  QM pro Auftrag summieren
   private PosXMenge := 387      && spalten merken frs drucken  rechtsbndig
   private PosXMeh := 407        && spalten merken frs drucken
   private PosXArtNummer := 494  && spalten merken frs drucken
   private PosXArttext := 740
   private PosXEPreis := 1559   && rechtsbndig
   private PosXFPreis := 1723   && rechtsbndig
   private PosXProzent:= 1718   && rechtsbndig
   private PosXPosPreis := 1892 && rechtsbndig
   private PosXSummen := 1892   && rechtsbndig
   private PosXSuText := 1400
   private mwst := 0.0           && Mehrwertsteuerbetrag errechnet
   private cPreisBinDatum := "31.03.2009" // +str(year(Auftrag->AuftrDatum)+1,4)

   * 4ter Versuch Seitennummer 1 nicht setzen (auf default vertrauen) (dann wird nur Seite 2 ohne 1 in Vorschau angezeigt)
   ::nPageNo := 1

   * erster Versuch zur fehlerkorrektur statt .f. nun .t. (keinen Effekt)
   ::lFirstPageForm := .t.         // Formular 1. Seite noch nicht gedruckt - form 1. page not printed
   ::lFirstPageForm := .f.

   * 3ter versuch HBprinter:Print() hier ausschalten (das ndert am preview-verhalten nichts)
   ::HBPrinter:Print()      // mglich, aber eigentlich unntig - it's possible, but I think useless
   * in abgeleiteten Klasse - in derived classes

   ::SetFont(HB_FONT_10Arial)

   PosX := 230    && linker Rand erste Printposition
   PosY := ::nFirstLine
   * 2ter Versuch printForm() raus (dann wird formular garnicht gedruckt)
   ::PrintForm()      // erste Seite Formular drucken
   do case
      case ::nPageNo = 1
         ::nFirstLine := n1TextZeile
     otherwise
         ::nFirstLine := n2TextZeile
   endcase

/*
     select AuftPos
     set relation to artnummer into artstamm
     seek Auftrag->AuftragNr   && Positionsendatei steht auf erster Position
*/
nRecNo := 1 // HB nur fr Test, EOF auf 1000

     do while nRecNo < 1000 // AuftPos->AuftragNr = Auftrag->AuftragNr .and. .not. eof()
       nPosBetrag    := 0.00
       nFrachtBetrag := 0.00
       nRabattBetrag := 0.00
       nRabattPreis  := 0.00

       if PosY >= 2485 .or. PosY < 0              // Seite voll
          PosX := 230
          PosY += ::LineFeed()   && Zeilenvorschub
          ::PrintLine(PosX,PosY,::nRightMargin,PosY)
          PosY += ::LineFeed()   && Zeilenvorschub
          ::PrintText(PosXArtNummer, PosY ,"Z w i s c h e n s u m m e")
          ::PrintText(PosXSummen, PosY ,Transform(zwi_summ,"@E 9,999,999.99"),"R",210)

          ::NewPage()
          ::PrintForm()
        /*if ::IsAfterLastPage()                  // Ist Shortcut mglich ? (spart Zeit, wichtig fr Vorschau !)
             exit
          endif
       */
         *PosY := ::nFirstLine
          PosY := n2TextZeile
       endif
       ::PrintText( PosX, PosY ,"AuftPos->LIEFPOSNR","R",60)

       * PosX := PosX+ ::GetTextLen(AuftPos->LIEFPOSNR+"X")

       ::PrintText( PosXMenge, PosY ,Transform(30,"@E 99,999.99"),"R",210)

       * PosX := PosX+ ::GetTextLen(Transform(30,"@E 99999.99"))

         * PosX := PosX+ ::GetTextLen(Transform(12,"@E 9999.99")+"X")
         ::PrintText(PosXPosPreis, PosY ,Transform(nPosBetrag+nFrachtBetrag,"@E 99,999.99"),"R",210)

         zwi_summ := zwi_summ+(nPosBetrag+nRabattBetrag+nFrachtBetrag)
         nSumFracht := nSumFracht + nFrachtBetrag
         if .t. // Artstamm->EloesKonto = "20"
            nSumFracht := nSumFracht + nPosBetrag+nRabattBetrag
         endif
*         skip+1
nRecNo++
         PosY += ::LineFeed()   && Zeilenvorschub
         PosX := 230            && Startwert linker Rand
     enddo

     * Rechnungsfuss drucken
    PosX := 200
    if .t. // Auftrag->FrKuNummer <> "00000"
       if nSumFracht <> 0
          ::PrintText(PosX, PosY ,"Frachtkosten (netto):")
          PosX := PosX+ ::GetTextLen("Frachtkosten (netto):"+"X")
          ::PrintText(PosX, PosY ,Transform(nSumFracht,"@E 999,999.99")+" EUR")
       endif
   endif
    PosX := 200
    PosY += ::LineFeed()   && Zeilenvorschub
    ::PrintLine(PosX,PosY,::nRightMargin,PosY)
    PosY += ::LineFeed()   && Zeilenvorschub
    ::PrintText(PosXSuText, PosY ,"Nettobetrag  EUR  :")
    ::PrintText(PosXSummen, PosY ,Transform(6544,"@E 9,999,999.99"  ),"R",210)
     PosY += ::LineFeed()   && Zeilenvorschub
    ::PrintText(PosXSuText, PosY ,"MwSt."+Transform(14,"@E 99.9")+"% EUR  :")
    mwst := 25 // rund(Auftrag->RECHSUMOMW * Auftrag->RECHMWSTPZ / 100,2)
    ::PrintText(PosXSummen, PosY ,Transform(mwst,"@E 9999,999.99"  ),"R",210)
     PosY += ::LineFeed()   && Zeilenvorschub
    ::PrintText(PosXSuText, PosY ,"Endbetrag    EUR  :")
    ::PrintText(PosXSummen, PosY ,Transform(7777,"@E 9,999,999.99"),"R",210)
     PosY += ::LineFeed()   && Zeilenvorschub
    ::PrintText(PosX, PosY ,"Preisbindung (Zeitpunkt der Lieferung) bis zum "+cPreisBinDatum)
return self





*--------------------- allgemeine Funktionen - einmalig im Programm --------------------------
*                      used functions, usefull for other Programms too



Function ErrBox(uText,cTitel)
   local cText,x,xMax
   DEFAULT cTitel TO "Fehlermeldung"
   do case
      case valtype(uText) = "A"
           cText := uText[1]
           xMax  := len(uText)
           for x := 2 to xMax
               cText += chr(13) + uText[x]
           next
      case valtype(uText) = "C"
           cText := uText
      otherwise
           cText := "ErrBox wurde mit falschem Parameter "+;
                    " uText  aufgerufen ! Type "+valtype(uText)+;
                    " statt C oder A"+chr(13)+;
                    "Bitte diesen Fehler melden."
   endcase
   MsgBox(cText,cTitel)
return NIL

*---------------------------------------------------------------------------
function ntrim( nVar )
return strTran(alltrim( str( nVar ) ),".",",")
