#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "xbpdev.ch"


*---------------- Fonts nur einmal erzeugen - create fonts only once ------

#define HB_FONT_14Arial         1
#define HB_FONT_12Arial         2
#define HB_FONT_10Arial         3
#define HB_FONT_8Arial          4
#define HB_FONT_12TimesNewRoman 5
#define HB_FONT_20Arial         6
#define HB_FONT_7Arial          7
#define HB_FONT_7ArialFett      8

#ifndef CRLF
   #define CRLF chr(13)+chr(10)
#endif



procedure main
local oHBPrinter

SET CHARSET TO OEM

*    nur fr Tests - only for debugging

#ifdef __WIN32__
   set alternate to log.txt
#else
   set alternate to log2.txt
#endif
set alternate on


? "Test.EXE - Printertest"                  // ######## Printdialog, wahrscheinlich
                                            // open / close doc mssen das Verzeichnis
                                            // retten und wiederherstellen !!!!


? "-"+curdrive()+"-"+curdir()+"- vor MyHBPrinter create"


oHBPrinter := MyHBPrinter():New():create()

? "-"+curdrive()+"-"+curdir()+"- nach MyHBPrinter create"

if oHBPrinter:IsPrinterError()             // Fehler verhindern, avoid errors
   ?
   ? "Standarddrucker ist nicht verfgbar !"
   ? "Standardprinter is not ready !"
   ?
   ? "Status: ",oHBPrinter:printerStatus(),"=",cPrinterStatus(oHBPrinter:printerStatus())
   ?
   ?

? "-"+curdrive()+"-"+curdir()+"- Printererror"

   wait


else

? "-"+curdrive()+"-"+curdir()+"- vor AddFont"

   oHBPrinter:addFont("14.Arial")
   oHBPrinter:addFont("12.Arial")
   oHBPrinter:addFont("10.Arial")
   oHBPrinter:addFont("8.Arial")
   oHBPrinter:addFont("12.Times New Roman")
   oHBPrinter:addFont({"Arial",20,.f.,.f.})
   oHBPrinter:addFont({"Arial",7,.f.,.f.})
   oHBPrinter:addFont({"Arial",7,.t.,.f.})
   oHBPrinter:cVorgabeSeiten := "1-2" // nur 2 Seiten drucken - print only 2 pages
   oHBPrinter:icon  := NIL // := ICON_APPLICATION // muss in ARC definiert sein !
   ?
   ? "Liste der Schriften - List of used fonts"
   aeval(oHBPrinter:aFontList,{| oFont| qout(oFont:compoundname,oFont:nominalPointSize) })
   ?
   ? "Aus Ihrem Programmheraus starten Sie nun den :PrintingDialog() , egal wie !"
   ? "From your program you start the :PrintingDialog() , any way is possible !"

? "-"+curdrive()+"-"+curdir()+"- Vor Printdialog"

   wait




   oHBPrinter:PrintingDialog( .t. ,;   // ESC -> close
                              .t. ,;   // ALT+Enter and Enter will Print
                              xbeK_ALT_P)  // ALT+P will print

endif


? "-"+curdrive()+"-"+curdir()+"- nach Printdialog"

? "Wieder zurck im Programm"
wait


quit


return




*-----------------------------------------------------------------------------------------------------



CLASS  MyHBPrinter from HBPrinter

   EXPORTED:
      METHOD Print                 // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                   // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                   // all variable output is defined in this method. If necessary it will call
                                   // ::NewPage(), increase the PageNo and calls ::PrintForm()
      METHOD PrintForm             // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                   // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                   // all fix output - don't care where on page - is defined in this method.
                                   // Never call ::NewPage() inside.
ENDCLASS




*-------------------------------------------------------------
* die folgenden Methoden anpassen - folowing methods has to be modified
*-------------------------------------------------------------
METHOD MyHBPrinter:PrintForm()        // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                      // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                      // all fix output - don't care where on page - is defined in this method.
                                      // Never call ::NewPage() inside.
   local altFont, x,y, nWinkel


   ::HBPrinter:PrintForm()           // falls Vorgabeformulare bentigt werden - if you need previous forms
                                      // sonst kann es weggelassen werden       - otherwise its ok to igore it

   * in abgeleiteten Klasse - in derived classes

   altFont := ::SetFont(HB_FONT_14Arial)
   ::PrintText( 200,150, "Drucker: "+::devname ,,, "_" )
   ::PrintText(1800,200, "HB","R" )  // Text fr alle Seiten - text for all pages
   ::PrintText(1800,300, "x-HB","R" )  // Text fr alle Seiten - text for all pages
   ::SetFont(HB_FONT_12Arial)

   for x := 0 to 350 step 10
       if ::nPageNo > 1
          ::PrintText( 1300,2000, "     __________Quer"+str(x),  ,  , ,,x) // Text fr alle Seiten - text for all pages
       else
          ::PrintText(  900,2000, "     __________Quer"+str(x),  ,  , ,,x) // Text fr alle Seiten - text for all pages
       endif
   next

   ::PrintText( 200,2800, "Seite:"+str(::nPageNo),,, "box" )  // Text fr alle Seiten - text for all pages
   ::PrintText( 2000,2800, version()+"."+version(3) , "R" )

   do case
      case ::nPageNo = 1
        ::PrintText( 800,2800, "first Page",,,"-")                    // Text fr alle Seiten - text for all pages
        for nWinkel := 0 to 360
            x := HbGradToXppArray(nWinkel,250)[1]                   // ber Funktion Endpunkt mit Winkel berechnen. Lnge: 100
            y := HbGradToXppArray(nWinkel,250)[2]                   // calculate the end point with nWinkel.        Length: 100
            ::PrintLine( 1400+x/5,500+y/5,1400+x,500+y)
        next
      otherwise
        ::PrintText( 800,2800, "another page"+str(::nPageNo))         // Text je nach Seite   - spezialtext for page
   endcase

   for x := 1 to 6
       if ! IsNil(::oPrinterPS:device()) .and. ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          ::PrintText(800,1000+x*50, "PaperSize["+ntrim(x)+"]: "+ntrim(::oPrinterPS:device():PaperSize()[x]) )
       else
          ::PrintText(800,1000+x*50, "PaperSize["+ntrim(x)+"]: ?" )
       endif
   next

   ::PrintText(1500,1050, "::nPaperSizeX:" )
   ::PrintText(1890,1050, ntrim(::nPaperSizeX) )
   ::PrintText(1500,1100, "::nPaperSizeY:")
   ::PrintText(1890,1100, ntrim(::nPaperSizeY) )
   ::PrintText(1500,1150, "::nLeftMarginDC:")
   ::PrintText(1890,1150, ntrim(::nLeftMarginDC) )
   ::PrintText(1500,1200, "::nBottomMarginDC:")
   ::PrintText(1890,1200, ntrim(::nBottomMarginDC) )
   ::PrintText(1500,1250, "::nRightMarginDC:")
   ::PrintText(1890,1250, ntrim(::nRightMarginDC) )
   ::PrintText(1500,1300, "::nTopMarginDC:")
   ::PrintText(1890,1300, ntrim(::nTopMarginDC) )
   ::PrintBox(780,1000,1220,320,"R")

   ::SetFont(HB_FONT_20Arial)
   ::PrintText(800,900, "TEST: "+::devname,,,"B",GRA_CLR_RED )  // Text fr alle Seiten - text for all pages

   ::PrintTextAlltrim := .f.  // fhrende Blanks mit drucken !

   ::SetFont(altFont)

   ::PrintBmp(1730,600,200,,"BILD.BMP")  // auch JPEG oder PNP z.B. als Logo

return self

*-------------------------------------------------------------
METHOD MyHBPrinter:Print()            // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                      // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                      // all variable output is defined in this method. If necessary it will call
                                      // ::NewPage(), increase the PageNo and calls ::PrintForm()
   local x, y, nMaxX, nPosX, nPosY, cTxt, aAttribAlt

   ::nPageNo := 1
   ::lFirstPageForm := .f.         // Formular 1. Seite noch nicht gedruckt - form 1. page not printed

   * Hier folgt ihr Code
   ::HBPrinter:Print()      // mglich, aber eigentlich unntig - it's possible, but I think useless

   * in abgeleiteten Klasse - in derived classes

   ::nFirstLine := 250
   nPosX := 200
   nPosY := ::nFirstLine

   ::SetFont(HB_FONT_12TimesNewRoman)

   nMaxX := 6000

   ::PrintTextAlltrim := .f.  // fhrende Blanks mit drucken !

   ::PrintForm()      // erste Seite Formular drucken

   ::PrintTextAlltrim := .f.  // fhrende Blanks mit drucken !

   ::PrintText( 400, 300 ,      "0,01", "R" )
   ::PrintText( 400, 350 , "41.234,00", "R" )
   ::PrintText( 400, 400 ,  "1.234,00", "R" )

   //PrintText( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, nDrehen )
   ::PrintText( 400, 300 ,      "0,02", "R", , , , 180 )
   ::PrintText( 400, 350 , "41.234,00", "R", , , , 180 )
   ::PrintText( 400, 400 ,  "1.234,00", "R", , , , 180 )

   //PrintText( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, nDrehen )
   ::PrintText( 300, 600 ,      "0,03", "R", , , , 270 )
   ::PrintText( 350, 600 , "41.234,00", "R", , , , 270 )
   ::PrintText( 400, 600 ,  "1.234,00", "R", , , , 270 )

   //PrintText( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, nDrehen )
   ::PrintText( 300, 600 ,      "0,04", "R", , , ,  90 )
   ::PrintText( 350, 600 , "41.234,00", "R", , , ,  90 )
   ::PrintText( 400, 600 ,  "1.234,00", "R", , , ,  90 )

   // Box in aktueller Farbe, also schwarz - this box will be printed with the current color => black
   ::PrintBox(700,800,50,50,"R", GRA_FILL ) // Parameter nFill => GraBox()
   // Box in ROT - this box in RED
   aAttribAlt := ::SetAttrArea( {{ GRA_AA_COLOR, GRA_CLR_RED }} )   // mehrere GRA_AA_ mglich ... - many GRA_AA_ possible
   ::PrintBox(700,850,50,50,"R", GRA_FILL ) // Parameter nFill => GraBox()
   ::ReSetAttrArea( aAttribAlt )
   // Box in alter Farbe, also schwarz - this box will be printed with the saved color => black
   ::PrintBox(700,900,50,50,"R", GRA_FILL ) // Parameter nFill => GraBox()

   // mit Angabe aller Positionen ...
   x := 1600
   Y := 1500
   ::SetFont(HB_FONT_7Arial)
   cTxt := "Test fr "  // mit Blank
   ::PrintText(x,y,cTxt)
   x += ::GetTextLen(cTxt)

   ::SetFont(HB_FONT_7ArialFett)
   cTxt := "FETT EIN"  // ohne Blank
   ::PrintText(x,y,cTxt)
   x += ::GetTextLen(cTxt)

   ::SetFont(HB_FONT_7Arial)
   cTxt := " und wieder aus !"  // mit Blank
   ::PrintText(x,y,cTxt)
   x := 1600
   Y := 1550
   ::SetFont(HB_FONT_7Arial)
   cTxt := "Test fr "  // mit Blank
   ::PrintText(x,y,cTxt)
   ::SetFont(HB_FONT_7ArialFett)
   cTxt := "FETT EIN"  // ohne Blank
   ::PrintText(,y,cTxt)
   ::SetFont(HB_FONT_7Arial)
   cTxt := " und wieder aus !"  // mit Blank
   ::PrintText(,y,cTxt)

   ::PrintTextAlltrim := .f.  // fhrende Blanks mit drucken !
   ::PrintText(1500,1600,"Links mit Blanks:")
   ::PrintText(1720,1600,"   3 Blanks")
   ::PrintText(1500,1640,"Mitte:")
   ::PrintText(1720,1640,"   3 Blanks","C")
   ::PrintText(1500,1680,"Rechts:")
   ::PrintText(1720,1680,"   3 Blanks","R")
   ::PrintText(1500,1720,"Links mit Blanks:")
   ::PrintText(1720,1720,"   3 Blanks")
   ::PrintText(1500,1760,"Links ohne Blanks:")
   ::PrintTextAlltrim := .t.  // fhrende Blanks mit drucken !
   ::PrintText(1720,1760,"   3 Blanks")
   ::PrintTextAlltrim := .f.  // fhrende Blanks mit drucken !

   ::SetFont(HB_FONT_7Arial)
   ::PrintMemo( 200, 1600 , "Dies ist ein kleiner Test mit gedrehtem Text.", , 550 , , ,"Q" )

   ::SetFont(HB_FONT_8Arial)
   cTxt := "Die folgende Zeile ist einfach zu lang !"+CRLF+;
           "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890 "+CRLF+;
           "Dies ist ein Test fr die Methode PrintMemo(). "+;
           "Dieser Absatz ist ohne harten Umbruch ausgefhrt.CRCR"+CRLF+CRLF+;
           "Nach hartem Umbruch mit Leerzeile."+CRLF+;
           "Neue Zeile"+chr(13)+;
           "2. Test fr CR ohne LF der Methode PrintMemo(). "+;
           "Dieser Absatz ist ohne harten Umbruch ausgefhrt.CRCR"+CRLF+CRLF+;
           "Eine Leerzeile und ein neuer Absatz."+chr(10)+"Neue Zeile nach LF."

   nPosY := 1900
 //::PrintMemo( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, cHochQuer, nMaxLen, nMaxBis,nLineFeed )
   ::PrintMemo(  1500, nPosY, cTxt, "B" , 500 )
   nPosY := ::PrintMemoLinePosY + ::LineFeed()
   ::PrintText( 1500, nPosY , "Anzahl Zeilen: "+ntrim(::PrintMemoLineCount))

   // auf neue Seite drucken
   ::SetFont(HB_FONT_12Arial)
   nPosY := ::nFirstLine
   ::NewPage()
   ::PrintForm()

   for x := 1 to nMaxX

       if nPosY >= 2750 .or. nPosY < 0              // Seite voll - page full
          ::NewPage()
          ::PrintForm()
          if ::IsAfterLastPage()                  // Ist Shortcut mglich ? (spart Zeit, wichtig fr Vorschau !)
             exit                                 // is shortcut possible ? (saves time. Preview needs this ! )
          endif
          nPosY := ::nFirstLine
       endif
       ::PrintText( nPosX, nPosY , "Zeile:"+str(x)+str(nPosY) )
       nPosY += ::LineFeed()
   next

return self





*--------------------- allgemeine Funktionen - einmalig im Programm --------------------------
*                      used functions, usefull for other Programms too



Function ErrBox(uText,cTitel)
   local cText,x,xMax
   DEFAULT cTitel TO "Fehlermeldung"
   do case
      case valtype(uText) = "A"
           cText := uText[1]
           xMax  := len(uText)
           for x := 2 to xMax
               cText += chr(13) + uText[x]
           next
      case valtype(uText) = "C"
           cText := uText
      otherwise
           cText := "ErrBox wurde mit falschem Parameter "+;
                    " uText  aufgerufen ! Type "+valtype(uText)+;
                    " statt C oder A"+chr(13)+;
                    "Bitte diesen Fehler melden."
   endcase
   MsgBox(cText,cTitel)
return NIL

*---------------------------------------------------------------------------
function ntrim( nVar )
return strTran(alltrim( str( nVar ) ),".",",")
*----------------------------------------------------------




