#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "XBPDEV.ch"


*---------------- Fonts nur einmal erzeugen - create fonts only once ------
procedure main
local oHBPrinter, nBin, getlist := {}, aPaperBins, nSeite, nLdfNr

SET CHARSET TO OEM

oHBPrinter := HBPrinter():New():create()   // Bei Netzwerkdruckern kann es vorkommen, dass
                                           // diese nicht verfgbar sind, dann fehlen alle
                                           // Infos zum Drucker und es kommt zu Laufzeitfehlern
                                           // if your network printer is not available
                                           // there will be runtime errors
if oHBPrinter:IsPrinterError()             // Fehler verhindern, avoid errors
   ?
   ? "Drucker ist nicht verfgbar !"
   ? "Printer is not ready !"
   ?
   ? "Status: ",oHBPrinter:printerStatus(),"=",cPrinterStatus(oHBPrinter:printerStatus())

else

   oHBPrinter:addFont("10.Arial")


   ?
   ? "Printer name:     ",oHBPrinter:devName
   ? "Printer comment:  ",oHBPrinter:comment
   ? "Printer port:     ",oHBPrinter:devPort
   ? "Printer location: ",oHBPrinter:location
   ?
   ? "Status: ",oHBPrinter:printerStatus(),"=",cPrinterStatus(oHBPrinter:printerStatus())
   ?
   ? "Liste der Papierfcher - List of paperBins"

   aPaperBins := oHBPrinter:paperBins()

   nLdfNr := 1

   aeval(aPaperBins,{| oBin| qout(alltrim(str(nLdfNr++))+":   ID:",str(oBin[1],4),"Name:",oBin[2]) })
   ?

   oHBPrinter:setFont(1)

   oHBPrinter:StartDoc("PaperBin-Test")
   oHBPrinter:PrintText(200,200,"Papier vom Standardfach")
   oHBPrinter:PrintText(200,250,"paper from default bin")

   oHBPrinter:PrintText(200,500,"::nPageNo:         "+ntrim(oHBPrinter:nPageNo))
   oHBPrinter:PrintText(200,550,"::nLeftMarginDC:   "+ntrim(oHBPrinter:nLeftMarginDC))
   oHBPrinter:PrintText(200,600,"::nTopMarginDC:    "+ntrim(oHBPrinter:nTopMarginDC))
   oHBPrinter:PrintText(200,650,"::nBottomMarginDC: "+ntrim(oHBPrinter:nBottomMarginDC))
   oHBPrinter:PrintText(200,700,"::nRightMarginDC:  "+ntrim(oHBPrinter:nRightMarginDC))

   do while .t.
      nLdfNr := 0
      @24,10 say "Lfd.NR 0 = end:" get nLdfNr picture "9999"
      read
      if nLdfNr > 0 .and. nLdfNr <= len(aPaperBins)
         nBin := aPaperBins[nLdfNr,1]
         nSeite := oHBPrinter:nPageNo +1
         oHBPrinter:enddoc()            // das ist sicher

         oHBPrinter:setPaperBin( nBin )

         oHBPrinter:StartDoc("PaperBin-Test",nSeite)

         oHBPrinter:setFont(1)

         oHBPrinter:PrintText(200,200,"Papier von:        "+ntrim(aPaperBins[nLdfNr,1]))
         oHBPrinter:PrintText(200,250,"paper from:        "+aPaperBins[nLdfNr,2])

         oHBPrinter:PrintText(200,500,"::nPageNo:         "+ntrim(oHBPrinter:nPageNo))
         oHBPrinter:PrintText(200,550,"::nLeftMarginDC:   "+ntrim(oHBPrinter:nLeftMarginDC))
         oHBPrinter:PrintText(200,600,"::nTopMarginDC:    "+ntrim(oHBPrinter:nTopMarginDC))
         oHBPrinter:PrintText(200,650,"::nBottomMarginDC: "+ntrim(oHBPrinter:nBottomMarginDC))
         oHBPrinter:PrintText(200,700,"::nRightMarginDC:  "+ntrim(oHBPrinter:nRightMarginDC))

      endif

      if empty(nLdfNr)
         exit
      endif
   enddo

   oHBPrinter:EndDoc()

endif

? "Ende"

wait


return


function ntrim(nNumber)
return alltrim(str(nNumber))







