#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"

#define CRLF chr(13)+chr(10)

procedure main
local oHBPrinter

SET DATE TO SYSTEM
SET CHARSET TO OEM

* Programm erstellt ein Adressbuch zum Ausschneiden.
* Die Adressen stehen in ADR_PRIV.DBF

* This program prints a adressbook.
* The adressdate is stored in ADR_PRIV.DBF

oHBPrinter := HBPrintNote():New():create()
if oHBPrinter:IsPrinterError()             // Fehler verhindern, avoid errors
   msgbox("Standarddrucker ist nicht verfgbar !"+CRLF+;
          "Standardprinter is not ready !"+CRLF+;
          "Status: "+ntrim(oHBPrinter:printerStatus())+" = "+cPrinterStatus(oHBPrinter:printerStatus()),;
          "Error")

else
   oHBPrinter:addFont("8.Arial")
   oHBPrinter:addFont("10.Arial")
   oHBPrinter:addFont("16.Arial")
   #define Font8   1
   #define Font10  2
   #define Font16  3
   oHBPrinter:PrintingDialog()    // druckerauswahl - print select
endif

return

*-----------------------------------------------------------------------------------------------------

CLASS  HBPrintNote from HBPrinter

   EXPORTED:

      METHOD Print                 // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                   // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                   // all variable output is defined in this method. If necessary it will call
                                   // ::NewPage(), increase the PageNo and calls ::PrintForm()
      METHOD PrintForm             // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                   // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                   // all fix output - don't care where on page - is defined in this method.
                                   // Never call ::NewPage() inside.
      METHOD PrintDay
      METHOD PrintLine             // Methode ersetzen -> dnnere Linie !
ENDCLASS

*-------------------------------------------------------------
* die folgenden Methoden anpassen - folowing methods has to be modified
*-------------------------------------------------------------
METHOD HBPrintNote:PrintForm()        // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                      // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                      // all fix output - don't care where on page - is defined in this method.
                                      // Never call ::NewPage() inside.
   ::HBPrinter:PrintForm()            // falls Vorgabeformulare bentigt werden - if you need previous forms
                                      // sonst kann es weggelassen werden       - otherwise its ok to igore it
   * in abgeleiteten Klasse - in derived classes
   ::setFont(Font16)
   ::PrintText( 1150, 100, "Notizblock HB","C")
   ::setFont(Font10)
   ::PrintText( 1950, 100, "Seite: "+ntrim(::nPageNo),"R")

return self

*-------------------------------------------------------------
METHOD HBPrintNote:Print()            // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                      // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                      // all variable output is defined in this method. If necessary it will call
                                      // ::NewPage(), increase the PageNo and calls ::PrintForm()
   local x, nMaxX, dDay, dLastDay, nAnzLeerSeiten

   nMaxX      := 7  // Tage auf eine Seite - Boxes per Page
   dDay       := StoD("20090430")
   dLastDay   := StoD("20090610")

   ::nPageNo := 1
   ::lFirstPageForm := .f.         // Formular 1. Seite noch nicht gedruckt - form 1. page not printed
   nAnzLeerSeiten := 2

   do while dDay <= dLastDay
      ::PrintForm()                      // print fix text
      for x := 1 to nMaxX
          ::PrintDay(x,dDay,dLastDay)
          dDay++
      next
      if dDay <= dLastDay
         ::newPage()
      endif
   enddo
   // eine Leerseite !
   do while nAnzLeerSeiten > 0
      ::newPage()
      ::PrintForm()                      // print fix text
      for x := 1 to nMaxX
          ::PrintDay(x,dDay,dLastDay)
          dDay++
      next
      nAnzLeerSeiten--
   enddo
return self
*-------------------------------------------------------------
METHOD HBPrintNote:PrintDay(nBox,dDay,dLastDay)
   local nX, nY, nBoxX, nBoxY, nBO, nBL
   nBoxX := 1800
   nBoxY :=  350
   nBL   :=  200
   nBO   :=  150 + (nBox-1) * (nBoxY+50)
   nX    :=  nBL
   nY    :=  nBO + 40

   ::PrintBox(nX,nBO,nBoxX,nBoxY,"R")

   ::setFont(Font10)
   nX += 20
   if dDay <= dLastDay
      ::PrintText( nX,nY, dtoc(dDay))
      nX +=220
      ::PrintLine( nX,nY+10,nX,nBO )
      nX += 20
      ::PrintText( nX,nY,"C:      |      |")

      ::setFont(Font8)
      nX +=260
      ::PrintLine( nX,nY+10,nX,nBO )
      nX += 20
      ::PrintText( nX,nY,"HOTEL:")
      nX +=600
      ::PrintLine( nX,nY+10,nX,nBO )
      nX += 20
      ::PrintText( nX,nY,"ORT:")
   else
      ::setFont(Font8)
      ::PrintText( nX,nY, "ZU:")
      nX +=250
      ::PrintLine( nX,nY+10,nX,nBO )
   endif

   nY += 10

   do while nY < nBO+nBoxY
      ::PrintLine( nBL,nY,nBL+nBoxX,nY)
      nY += 50
   enddo

return self
*-------------------------------------------------------------
METHOD HBPrintNote:PrintLine(nPos1X,nPos1Y,nPos2X,nPos2Y)
    local lSuccess := .t.
    if ::IsPageToPrint()
       lSuccess := GraLine( ::oPS,::PosHBtoXPP(nPos1X,nPos1Y),::PosHBtoXPP(nPos2X, nPos2Y) )
    endif          // Linien sind zu dnn gezeichnet, lines have been to thin !
return lSuccess


*--------------------- allgemeine Funktionen - einmalig im Programm --------------------------
*                      used functions, usefull for other Programms too



Function ErrBox(uText,cTitel)
   local cText,x,xMax
   DEFAULT cTitel TO "Fehlermeldung"
   do case
      case valtype(uText) = "A"
           cText := uText[1]
           xMax  := len(uText)
           for x := 2 to xMax
               cText += chr(13) + uText[x]
           next
      case valtype(uText) = "C"
           cText := uText
      otherwise
           cText := "ErrBox wurde mit falschem Parameter "+;
                    " uText  aufgerufen ! Type "+valtype(uText)+;
                    " statt C oder A"+chr(13)+;
                    "Bitte diesen Fehler melden."
   endcase
   MsgBox(cText,cTitel)
return NIL

*---------------------------------------------------------------------------
function ntrim( nVar )
return strTran(alltrim( str( nVar ) ),".",",")

