#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "XBPDEV.ch"

*---------------- Fonts nur einmal erzeugen - create fonts only once ------
procedure main
local oHBP, nPosY, nLR, nSpaNr, x, aDaten, cWindowsDruckerObjekt

SET CHARSET TO OEM

aDaten := { {"Text a",         123.12},;
            {"Text bb",         12.54},;
            {"Text ccc",      1234.23},;
            {"Text dddd ",    9.3} }


// Netzwerkdrucker haben nicht immer den erwarteten Namen, so kann man diesen suchen
cWindowsDruckerObjekt := GetPrinterName( "Canon iP4500 series" )


oHBP := HBPrinter():New():create(cWindowsDruckerObjekt) // :create() nutzt Standarddrucker
if oHBP:IsPrinterError()             // Fehler verhindern, avoid errors
   msgbox("Drucker ist nicht verfgbar !")
else
   oHBP:addFont("10.Arial") // hier werden alle bentigten Fonts in ein internes Array geladen
   oHBP:setFont(1)  // hier wird der gewnschte Font gewhlt
   oHBP:StartDoc("Drucktest")  // ein LASER wird dies im Display anzeigen, ein PDF Druckertreiber wird es als Dateinamen verwenden.
   nPosY  :=  200   // 2 cm von oberer Papierkante - Einheit 1/10 mm => 1 mm == 10, 1cm = 100
   nLR    :=  200   // 2 cm von linker Papierkante
   nSpaNr := 1200
   oHBP:PrintText( nLR  , nPosY, "Printer: "+cWindowsDruckerObjekt )
   nPosY += oHBP:LineFeed(2)  // 2 Zeilen weiter
   for x := 1 to len(aDaten)
       //  :PrintText( nPosX, nPosY, xData, cAusrichtung, nMaxLen, cArt, nFarbe, nDrehen ) - das hilft immer ;-)
       oHBP:PrintText( nLR  , nPosY, aDaten[x,1] ) // Standardausrichtung in Drucklnge, nicht gedreht ...
       oHBP:PrintText(nSpaNr, nPosY, transform(aDaten[x,2],"999,999.99"), "R" ) // Zahlen formartiert rechtsbndig
       nPosY += oHBP:LineFeed()  // eine Zeile weiter (0,0 ist linke obere Papierkante) mit Standardabstand. 50 wren 5 mm ... wie man will.
   next
   oHBP:EndDoc()
endif
msgbox("gedruckt Umlaute ")
return

function GetPrinterName( cWindowsDruckerObjekt )
   static cPrinterName := NIL
   local oP, aL, cD, i := 0
   if cPrinterName = NIL
      oP := XbpPrinter():new()
      if oP = NIL
         msgbox("Druckerobjekt konnte nicht erzeugt werden - no Print object","GetPrinterName()")
         quit
      else
         aL := oP:list()
         i := AScan( aL, {|x| lower(x) == lower(cWindowsDruckerObjekt) } )    // genau
         if i = 0
            i := AScan( aL, {|x| lower(cWindowsDruckerObjekt) $ lower(x) } )  // einiger Maen, z.B. bei Netzwerkdrucker
         endif
      endif
      if i > 0
         cPrinterName := aL[i]
      else
         msgbox("Drucker konnte nicht gefunden werden - no such printer","GetPrinterName()")
         quit
      endif
   endif
return cPrinterName

