#include "Gra.ch"
#include "Xbp.ch"
#include "inkey.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "xbpdev.ch"
#include "directry.ch"
#include "Dll.ch"

#pragma Library( "XppUI2.lib" )

#define CRLF chr(13)+chr(10)
#define cHKT chr(34)

* #define PrintDirekt    // direkter Druck auf Drucker   - print direkt

*---------------- Fonts nur einmal erzeugen - create fonts only once ------

procedure main
local oHBP := NIL, UseHbPrinterPrintDialog
#ifdef PrintDirekt   // direkter Druck auf Drucker
   local cPrinterName
   UseHbPrinterPrintDialog := .f.
#else
   local oXbpPrinter := NIL
   local oDlg
   UseHbPrinterPrintDialog := .t.  // festlegen, define
#endif

SET CHARSET TO OEM

#ifdef PrintDirekt

   // cPrinterName := "hp deskjet 5550 series (HPA)"
   cPrinterName := "\\NAS\usbprinter1"

   oHBP := CD_Einleger():New():create(cPrinterName)  // direkt erzeugen oder ...

#else    // Auswahl ber Windows Druckerauswahl

   if UseHbPrinterPrintDialog

      oHBP := CD_Einleger():New():create()  // Default and PrintDialog() ...

   else
      oDlg := XbpPrintDialog():new()
      oDlg:enablePrintToFile := .f.
      oDlg:printToFile       := .f.
      oDlg:create()
      oXbpPrinter := oDlg:display()
      oDlg:destroy()

      if oXbpPrinter # NIL
         oHBP := CD_Einleger():New(oXbpPrinter):create()
      else
         oHBP := NIL
      endif
   endif

#endif

if oHBP # NIL
   #define CD_FONT_VORN_TITEL          1
   oHBP:addFont({"Times New Roman",30,.t.,.f.})
   #define CD_FONT_VORN_MONAT_JAHR     2
   oHBP:addFont({"Times New Roman",22,.t.,.f.})
   #define CD_FONT_VORN_CD_NAME        3
   oHBP:addFont({"Times New Roman",14,.t.,.f.})
   #define CD_FONT_VORN_ZEITRAUM       4
   oHBP:addFont("12.Times New Roman")
   #define CD_FONT_SEITE_TITEL         5
   oHBP:addFont({"Arial Narrow",10,.t.,.f.})
   #define CD_FONT_SEITE_ZEITRAUM      6
   oHBP:addFont("8.Arial Narrow")

   // Standardtexte auskommentieren
   // oHBP:CD_Titel                    := "Titel ..."
   // oHBP:CD_MonatJahr                :=
   // oHBP:CD_VonMonat                 :=
   // oHBP:CD_BisMonat                 :=
   // oHBP:CD_NAME                     :=
   // hiermit knnte man ein neues Format einstellen
   // oHBP:CD_Vorn_ObenMitte_X         := 1340
   // oHBP:CD_Vorn_ObenMitte_Y         := 1570
   // oHBP:CD_Hinten_ObenMitte_X       := 1060
   // oHBP:CD_Hinten_ObenMitte_Y       :=  190
   // oHBP:CD_Hinten_ObenMitte_Offset  :=   -5 // Hinten ist der Einleger 1mm kleiner -> 1/2*10

   if UseHbPrinterPrintDialog
      oHBP:PrintingDialog( .t. ,;   // ESC -> close
                           .t. ,;   // ALT+Enter and Enter will Print
                           xbeK_ALT_P)  // ALT+P will print
   else
      oHBP:StartDoc()
      oHBP:Print()
      oHBP:EndDoc()
   endif

   if oXbpPrinter # NIL
      oXbpPrinter:destroy()
   endif

   if oHBP # NIL
      oHBP:destroy()
   endif

endif

oHBP:destroy()

return



*-----------------------------------------------------------------------------------------------------
CLASS  CD_Einleger from HBPrinter
   PROTECTED:
      VAR aPapierArt

   EXPORTED:
      VAR CD_Titel
      VAR CD_MonatJahr            // Beschriftung z.B. Oktober 2008
      VAR CD_VonMonat             // ab z.B. 01.01.2002
      VAR CD_BisMonat             // ab z.B. 31.12.2007
      VAR CD_NAME                 // Feld CD_NAME von UVCD_ADR.DBF
      VAR CD_Vorn_ObenMitte_X
      VAR CD_Vorn_ObenMitte_Y
      VAR CD_Hinten_ObenMitte_X
      VAR CD_Hinten_ObenMitte_Y
      VAR CD_Hinten_ObenMitte_Offset // Hinten wird bei mir das gleiche wie vorne
                                     // gedruckt, allerdings ist die Hhe leicht
                                     // unterschiedlich, meist krzer ...
      METHOD Init
      METHOD Print
      METHOD GetPapierArt            // -> Array mit untersttzten Papiersorten und ID
      METHOD SetPapierArt            // -> Array mit untersttzten Papiersorten
ENDCLASS
*-------------------------------------------------------------
METHOD CD_Einleger:Init(oXbpPrinter)       // Einstellungen fr KronenBerg Einleger Art.Nr. 21479
  ::HBPrinter:init(oXbpPrinter)
  ::CD_Titel                    := "Beispieltitel"
  ::CD_MonatJahr                := "Beispielmonat 2008"
  ::CD_VonMonat                 := "01.01.2002"
  ::CD_BisMonat                 := "31.12.2007"
  ::CD_NAME                     := "NAME XYZ"
  ::CD_Vorn_ObenMitte_X         := 1340 // Vorgabewerte wie bei 1. Papierart
  ::CD_Vorn_ObenMitte_Y         := 1570
  ::CD_Hinten_ObenMitte_X       := 1060
  ::CD_Hinten_ObenMitte_Y       :=  190
  ::CD_Hinten_ObenMitte_Offset  :=   -5 // Hinten ist der Einleger 1mm kleiner -> 1/2*10
  ::aPapierArt                  := { {1,"KronenBerg Einleger Art.Nr. 21479"} }
return self
*-------------------------------------------------------------
METHOD CD_Einleger:GetPapierArt()    // -> Array mit untersttzten Papiersorten und ID
return ::aPapierArt
*-------------------------------------------------------------
METHOD CD_Einleger:SetPapierArt(nPapierArt) // -> Array mit untersttzten Papiersorten
  do case
     case IsNil(nPapierArt) .or. nPapierArt == 1
          ::CD_Vorn_ObenMitte_X         := 1340 // Vorgabewerte wie bei 1. Papierart
          ::CD_Vorn_ObenMitte_Y         := 1570
          ::CD_Hinten_ObenMitte_X       := 1060
          ::CD_Hinten_ObenMitte_Y       :=  190
          ::CD_Hinten_ObenMitte_Offset  :=   -5 // Hinten ist der Einleger 1mm kleiner -> 1/2*10
  endcase
return nil
*-------------------------------------------------------------
METHOD CD_Einleger:Print(nPapierArt)
   local cTxt, nPosY
   if ValType(::CD_VonMonat) = "D"
      ::CD_VonMonat := ctod(::CD_VonMonat)
   endif
   if ValType(::CD_BisMonat) = "D"
      ::CD_BisMonat := ctod(::CD_BisMonat)
   endif
   ::CD_VonMonat := alltrim(::CD_VonMonat)
   ::CD_BisMonat := alltrim(::CD_BisMonat)

   ::SetPapierArt(nPapierArt)

   ::SetFont(CD_FONT_VORN_TITEL)
   nPosY := 400
   ::PrintText(::CD_Vorn_ObenMitte_X,::CD_Vorn_ObenMitte_Y+nPosY,::CD_Titel,"C")
   ::PrintText(::CD_Hinten_ObenMitte_X,;
               ::CD_Hinten_ObenMitte_Y+nPosY+::CD_Hinten_ObenMitte_Offset,::CD_Titel,"C")

   ::SetFont(CD_FONT_VORN_MONAT_JAHR)
   nPosY := 615
   ::PrintText(::CD_Vorn_ObenMitte_X,::CD_Vorn_ObenMitte_Y+nPosY,::CD_MonatJahr,"C")
   ::PrintText(::CD_Hinten_ObenMitte_X,;
               ::CD_Hinten_ObenMitte_Y+nPosY+::CD_Hinten_ObenMitte_Offset,::CD_MonatJahr,"C")

   ::SetFont(CD_FONT_VORN_ZEITRAUM)
   nPosY := 790
   cTxt := "Zeitraum von "+::CD_VonMonat+" bis "+::CD_BisMonat
   ::PrintText(::CD_Vorn_ObenMitte_X,::CD_Vorn_ObenMitte_Y+nPosY,cTxt,"C")
   ::PrintText(::CD_Hinten_ObenMitte_X,;
               ::CD_Hinten_ObenMitte_Y+nPosY+::CD_Hinten_ObenMitte_Offset,cTxt,"C")
   nPosY += 50
   cTxt := "mit diesen und anderen Informationen"
   ::PrintText(::CD_Vorn_ObenMitte_X,::CD_Vorn_ObenMitte_Y+nPosY,cTxt,"C")
   ::PrintText(::CD_Hinten_ObenMitte_X,;
               ::CD_Hinten_ObenMitte_Y+nPosY+::CD_Hinten_ObenMitte_Offset,cTxt,"C")

   ::SetFont(CD_FONT_VORN_CD_NAME)
   nPosY := 1000
   ::PrintText(::CD_Vorn_ObenMitte_X,::CD_Vorn_ObenMitte_Y+nPosY,::CD_NAME,"C")
   ::PrintText(::CD_Hinten_ObenMitte_X,;
               ::CD_Hinten_ObenMitte_Y+nPosY+::CD_Hinten_ObenMitte_Offset,::CD_NAME,"C")

   ::SetFont(CD_FONT_SEITE_TITEL)
   nPosY := 1130
   cTxt := ::CD_Titel+" "+::CD_MonatJahr
   ::PrintText(::CD_Hinten_ObenMitte_X-708,;
               ::CD_Hinten_ObenMitte_Y+nPosY,cTxt,,,,,90)
   ::PrintText(::CD_Hinten_ObenMitte_X+732,;
               ::CD_Hinten_ObenMitte_Y+nPosY,cTxt,,,,,90)

   ::SetFont(CD_FONT_SEITE_ZEITRAUM)
   nPosY := 610
   cTxt := "Zeitraum von "+::CD_VonMonat+" bis "+::CD_BisMonat
   ::PrintText(::CD_Hinten_ObenMitte_X-708,;
               ::CD_Hinten_ObenMitte_Y+nPosY,cTxt,,,,,90)
   ::PrintText(::CD_Hinten_ObenMitte_X+732,;
               ::CD_Hinten_ObenMitte_Y+nPosY,cTxt,,,,,90)
return self

*--------------------- allgemeine Funktionen - einmalig im Programm --------------------------
*                      used functions, usefull for other Programms too



Function ErrBox(uText,cTitel)
   local cText,x,xMax
   DEFAULT cTitel TO "Fehlermeldung"
   do case
      case valtype(uText) = "A"
           cText := uText[1]
           xMax  := len(uText)
           for x := 2 to xMax
               cText += chr(13) + uText[x]
           next
      case valtype(uText) = "C"
           cText := uText
      otherwise
           cText := "ErrBox wurde mit falschem Parameter "+;
                    " uText  aufgerufen ! Type "+valtype(uText)+;
                    " statt C oder A"+chr(13)+;
                    "Bitte diesen Fehler melden."
   endcase
   MsgBox(cText,cTitel)
return NIL

*---------------------------------------------------------------------------
function ntrim( nVar )
return strTran(alltrim( str( nVar ) ),".",",")
*----------------------------------------------------------




