#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "xbpdev.ch"


*---------------- Fonts nur einmal erzeugen - create fonts only once ------

#define HB_FONT_14Arial         1
#define HB_FONT_12Arial         2
#define HB_FONT_12ArialBold     3

procedure main
local oHBPrinter

SET CHARSET TO OEM

*    nur fr Tests - only for debugging

#ifdef __WIN32__
   set alternate to log.txt
#else
   set alternate to log2.txt
#endif
set alternate on


? "Test-BOLD.EXE - Printertest"
?
? "Eine Zeilen in mehreren Teilen drucken ..."
?

oHBPrinter := MyHBPrinter():New():create()

if oHBPrinter:IsPrinterError()             // Fehler verhindern, avoid errors
   ?
   ? "Standarddrucker ist nicht verfgbar !"
   ? "Standardprinter is not ready !"
   ?
   ? "Status: ",oHBPrinter:printerStatus(),"=",cPrinterStatus(oHBPrinter:printerStatus())
   ?
   ?
   wait


else

   oHBPrinter:addFont("14.Arial")
   oHBPrinter:addFont("12.Arial")
   oHBPrinter:addFont({"Arial",12,.t.,.f.})       // Passender Bold Font !
   oHBPrinter:SpoolJobName := "TEST-BOLD - Probeausdruck 2"
   ?
   ? "Liste der Schriften - List of used fonts"
   aeval(oHBPrinter:aFontList,{| oFont| qout(oFont:compoundname,oFont:nominalPointSize) })
   ?
   ? "Aus Ihrem Programmheraus starten Sie nun den :PrintingDialog() , egal wie !"
   ? "From your program you start the :PrintingDialog() , any way is possible !"

   wait

   oHBPrinter:PrintingDialog( .t. ,;   // ESC -> close
                              .t. ,;   // ALT+Enter and Enter will Print
                              xbeK_ALT_P)  // ALT+P will print

endif

? "Wieder zurck im Programm"
wait


quit


return




*-----------------------------------------------------------------------------------------------------



CLASS  MyHBPrinter from HBPrinter

   EXPORTED:
      METHOD Print                 // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                   // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                   // all variable output is defined in this method. If necessary it will call
                                   // ::NewPage(), increase the PageNo and calls ::PrintForm()
      METHOD PrintForm             // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                   // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                   // all fix output - don't care where on page - is defined in this method.
                                   // Never call ::NewPage() inside.
ENDCLASS




*-------------------------------------------------------------
* die folgenden Methoden anpassen - folowing methods has to be modified
*-------------------------------------------------------------
METHOD MyHBPrinter:PrintForm()        // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                      // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                      // all fix output - don't care where on page - is defined in this method.
                                      // Never call ::NewPage() inside.
   local altFont, x


   ::HBPrinter:PrintForm()           // falls Vorgabeformulare bentigt werden - if you need previous forms
                                      // sonst kann es weggelassen werden       - otherwise its ok to igore it

   * in abgeleiteten Klasse - in derived classes

   altFont := ::SetFont(HB_FONT_14Arial)
   ::PrintText( 200,150, "Drucker: "+::devname ,,, "_" )
   ::PrintText( 200,2800, "Seite:"+str(::nPageNo),,, "box" )  // Text fr alle Seiten - text for all pages

   do case
      case ::nPageNo = 1
        ::PrintText( 800,2800, "first Page",,,"-")                    // Text fr alle Seiten - text for all pages
      otherwise
        ::PrintText( 800,2800, "another page"+str(::nPageNo))         // Text je nach Seite   - spezialtext for page
   endcase

   for x := 1 to 6
       if ! IsNil(::oPrinterPS:device()) .and. ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          ::PrintText(800,1000+x*50, "PaperSize["+ntrim(x)+"]: "+ntrim(::oPrinterPS:device():PaperSize()[x]) )
       else
          ::PrintText(800,1000+x*50, "PaperSize["+ntrim(x)+"]: ?" )
       endif
   next

   ::SetFont(HB_FONT_12Arial)
   ::PrintText(1500,1050, "::nPaperSizeX:     "+ntrim(::nPaperSizeX) )
   ::PrintText(1500,1100, "::nPaperSizeY:     "+ntrim(::nPaperSizeY) )
   ::PrintText(1500,1150, "::nLeftMarginDC:   "+ntrim(::nLeftMarginDC) )
   ::PrintText(1500,1200, "::nBottomMarginDC: "+ntrim(::nBottomMarginDC) )
   ::PrintText(1500,1250, "::nRightMarginDC:  "+ntrim(::nRightMarginDC) )
   ::PrintText(1500,1300, "::nTopMarginDC:    "+ntrim(::nTopMarginDC) )
   ::SetFont(altFont)
return self

*-------------------------------------------------------------
METHOD MyHBPrinter:Print()            // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                      // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                      // all variable output is defined in this method. If necessary it will call
                                      // ::NewPage(), increase the PageNo and calls ::PrintForm()
   local PosX, PosY

   ::nPageNo := 1
   ::lFirstPageForm := .f.         // Formular 1. Seite noch nicht gedruckt - form 1. page not printed

   * Hier folgt ihr Code
   ::HBPrinter:Print()      // mglich, aber eigentlich unntig - it's possible, but I think useless

   * in abgeleiteten Klasse - in derived classes

   ::nFirstLine := 500
   PosX := 200
   PosY := ::nFirstLine

   ::SetFont(HB_FONT_12Arial)

   ::PrintForm()      // erste Seite Formular drucken

   ::PrintText( PosX,PosY, "Start einer Textzeile mit ")

   ::SetFont(HB_FONT_12ArialBold)

   ::PrintText(  ,   ,     "fettem Einschub")

   ::SetFont(HB_FONT_12Arial)

   ::PrintText(  ,  ,      " in der Textzeile")

return self





*--------------------- allgemeine Funktionen - einmalig im Programm --------------------------
*                      used functions, usefull for other Programms too



Function ErrBox(uText,cTitel)
   local cText,x,xMax
   DEFAULT cTitel TO "Fehlermeldung"
   do case
      case valtype(uText) = "A"
           cText := uText[1]
           xMax  := len(uText)
           for x := 2 to xMax
               cText += chr(13) + uText[x]
           next
      case valtype(uText) = "C"
           cText := uText
      otherwise
           cText := "ErrBox wurde mit falschem Parameter "+;
                    " uText  aufgerufen ! Type "+valtype(uText)+;
                    " statt C oder A"+chr(13)+;
                    "Bitte diesen Fehler melden."
   endcase
   MsgBox(cText,cTitel)
return NIL

*---------------------------------------------------------------------------
function ntrim( nVar )
return strTran(alltrim( str( nVar ) ),".",",")



