#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"

#define CRLF chr(13)+chr(10)

procedure main
local oHBPrinter, cFile, cNTX
field NAME, DRU_ADR

SET DATE TO SYSTEM
SET CHARSET TO OEM

* Programm erstellt ein Adressbuch zum Ausschneiden.
* Die Adressen stehen in ADR_PRIV.DBF

* This program prints a adressbook.
* The adressdate is stored in ADR_PRIV.DBF

oHBPrinter := HBPrintAdress():New():create()
if oHBPrinter:IsPrinterError()             // Fehler verhindern, avoid errors
   msgbox("Standarddrucker ist nicht verfgbar !"+CRLF+;
          "Standardprinter is not ready !"+CRLF+;
          "Status: "+ntrim(oHBPrinter:printerStatus())+" = "+cPrinterStatus(oHBPrinter:printerStatus()),;
          "Error")
else
   oHBPrinter:cTitle1 := "Adressbuch"
   oHBPrinter:cTitle2 := "von Hubert Brandel"
   oHBPrinter:addFont("8.Arial")
   oHBPrinter:addFont("10.Arial")
   oHBPrinter:addFont("20.Times New Roman")

   #define TextNorm 1
   #define TextBold 2
   #define Title1   3
   #define Title2   1

   cls

   do case
      case file("d:\data\ADR_PRIV.DBF")
           cFile := "d:\data\ADR_PRIV.DBF"
      case file("g:\ADR_PRIV.DBF")
           cFile := "g:\ADR_PRIV.DBF"
      case file("ADR_PRIV.DBF")
           cFile := "ADR_PRIV.DBF"
      otherwise
           cFile := ""
           msgbox("Datei ADR_PRIV.DBF wurde nicht gefunden !"+CRLF+;
                  "File not found: ADR_PRIV.DBF !","Fehler - Error")
   end case

   if ! empty(cFile)
      use (cFile) readonly shared alias ADR
      if neterr()
         msgbox("Datei ADR_PRIV.DBF konnte nicht geffnet werden !"+CRLF+;
                "NETERR() while USE ADR_PRIV.DBF !","NETERR() - Fehler - Error")
      else
         cNTX := "TempIndex.NTX"
         // Anstatt Filter ! - better than a filter
         index on upper(NAME) to (cNTX) FOR upper(DRU_ADR)=="J"

         oHBPrinter:nAlias := select()
         oHBPrinter:PrintingDialog()    // druckerauswahl - print select

         CLOSE ADR
         delete file (cNTX)      // clean all

      endif
   endif
endif
return

*-----------------------------------------------------------------------------------------------------



CLASS  HBPrintAdress from HBPrinter

   EXPORTED:
      VAR nLabelSizeX, nLabelSizeY
      VAR cTitle1, cTitle2
      VAR nRow,nMaxRow
      VAR nCol,nMaxCol
      VAR nAdr,nMaxAdr
      VAR nLabelLeftMargin
      VAR nLabelTopMargin
      VAR nLabelAdrHeight
      VAR nAlias

      METHOD Print                 // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                   // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                   // all variable output is defined in this method. If necessary it will call
                                   // ::NewPage(), increase the PageNo and calls ::PrintForm()
      METHOD PrintForm             // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                   // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                   // all fix output - don't care where on page - is defined in this method.
                                   // Never call ::NewPage() inside.
      METHOD PrintAdress
      METHOD PrintTitel
ENDCLASS




*-------------------------------------------------------------
* die folgenden Methoden anpassen - folowing methods has to be modified
*-------------------------------------------------------------
METHOD HBPrintAdress:PrintForm()        // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                      // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                      // all fix output - don't care where on page - is defined in this method.
                                      // Never call ::NewPage() inside.
   local x, y, nX1, nX2, nY1, nY2
   ::HBPrinter:PrintForm()            // falls Vorgabeformulare bentigt werden - if you need previous forms
                                      // sonst kann es weggelassen werden       - otherwise its ok to igore it

   * in abgeleiteten Klasse - in derived classes
   // Column-Lines
   nY1    := ::SetTopMargin()
   nY2    := nY1 + (::nMaxRow*::nLabelSizeY)
   nX1    := ::SetLeftMargin()
   for x  := 1 to ::nMaxCol+1
       ::PrintLine(nX1,nY1,nX1,nY2)
       nX1 += ::nLabelSizeX
   next
   // Row-Lines
   nY1    := ::SetTopMargin()
   nX1    := ::SetLeftMargin()
   nX2    := nX1 + (::nMaxCol*::nLabelSizeX)
   for y  := 1 to ::nMaxCol+1
       ::PrintLine(nX1,nY1,nX2,nY1)
       nY1 += ::nLabelSizeY
   next

return self

*-------------------------------------------------------------
METHOD HBPrintAdress:Print()            // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                      // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                      // all variable output is defined in this method. If necessary it will call
                                      // ::NewPage(), increase the PageNo and calls ::PrintForm()
   local nMax, nMin, nSeite, nX, nY

   ::nPageNo := 1
   ::lFirstPageForm := .f.         // Formular 1. Seite noch nicht gedruckt - form 1. page not printed

   DEFAULT ::cTitle1          TO "Adressbuch"
   DEFAULT ::cTitle2          TO ""
   DEFAULT ::nLabelSizeX      TO 610
   DEFAULT ::nLabelSizeY      TO 870
   DEFAULT ::nLabelLeftMargin TO  80
   DEFAULT ::nLabelTopMargin  TO  80
   DEFAULT ::nLabelAdrHeight  TO 260

   if IsNil(::nAlias)
      errbox("nAlias ist NIL !")
      return self
   endif
   if ! Used(::nAlias)
      errbox("Keine Datendatei !")
      return self
   endif

   (::nAlias)->(dbGotop())

   ::nRow    := 1
   ::nCol    := 1
   ::nAdr    := 1
   ::nMaxAdr := 3
   nSeite    := 1
   nMax      := max(::nRightMarginDC, ::nLeftMarginDC ) // sicher ist sicher
   nMin      := min(::nRightMarginDC, ::nLeftMarginDC ) // sicher ist sicher
   ::nMaxCol := int((nMax-nMin) / ::nLabelSizeX )
   nMax      := max(::nTopMarginDC, ::nBottomMarginDC ) // sicher ist sicher
   nMin      := min(::nTopMarginDC, ::nBottomMarginDC ) // sicher ist sicher
   ::nMaxRow := int((nMax-nMin) / ::nLabelSizeY )

   ::SetTopMargin( min(100,int((::nPaperSizeY-(::nMaxRow * ::nLabelSizeY))/2)-20) )
*   ::SetBottomMargin(nHB_Pos)
   ::SetLeftMargin(min(100,int((::nPaperSizeX-(::nMaxCol * ::nLabelSizeX))/2)-20) )
*   ::SetRightMargin(nHB_Pos)
   ::nFirstLine := ::SetTopMargin()

   * Hier folgt ihr Code
   ::HBPrinter:Print()      // mglich, aber eigentlich unntig - it's possible, but I think useless
   ::setFont(TextBold)      // TextNorm, TextBold, Title1

   do while .t.

      if ::nRow == 1 .and. ::nCol == 1 .and. ::nAdr == 1
         ::PrintForm()                      // print fix text
      endif

      * Print one Adress - we know there is enouth place

      ::PrintAdress()
      (::nAlias)->(dbskip())

      * Zuerst den nchsten Druckpunkt ermitteln, auch bei EOF !

      ::nAdr++

      if ::nAdr > ::nMaxAdr .or. (::nAlias)->(eof())
         ::nAdr := 1
         nX := ::SetLeftMargin()+(::nCol-1)*::nLabelSizeX+::nLabelSizeX/2
         nY := ::SetTopMargin() +(::nRow)  *::nLabelSizeY-20
        ::setFont(TextNorm)      // TextNorm, TextBold, Title1
        ::PrintText( nX,nY, "- "+ntrim(nSeite)+" -","C" )
         nSeite++
         ::nRow++
      endif

      if ::nRow > ::nMaxRow
         ::nRow := 1
         ::nCol++
      endif

      if ::nCol > ::nMaxCol
         ::nRow := 1
         ::nCol := 1
         ::newPage()
      endif

      if (::nAlias)->(eof())
         exit
      endif

   enddo

   // Title
   ::PrintTitel()

return self
*-------------------------------------------------------------
METHOD HBPrintAdress:PrintAdress()
   local nX, nY, nMaxLen
   nX := ::SetLeftMargin()+(::nCol-1)*::nLabelSizeX+::nLabelLeftMargin
   nY := ::SetTopMargin() +(::nRow-1)*::nLabelSizeY+::nLabelTopMargin+;
                           (::nAdr-1)*::nLabelAdrHeight
   nMaxLen := ::nLabelSizeX-::nLabelLeftMargin-10
   ::setFont(TextBold)      // TextNorm, TextBold, Title1
   ::PrintText( nX,nY, alltrim((::nAlias)->NAME) ,,nMaxLen  )
   nY += ::Linefeed()
   ::setFont(TextNorm)      // TextNorm, TextBold, Title1
   ::PrintText( nX,nY, alltrim((::nAlias)->STRASSE) ,,nMaxLen)
   nY += ::Linefeed()
   ::PrintText( nX,nY, alltrim((::nAlias)->PLZ+" "+(::nAlias)->ORT) ,,nMaxLen)
   nY += ::Linefeed()
   if ! empty((::nAlias)->GEB_DAT)
      ::PrintText( nX,nY, alltrim("Geburtstag: "+dtoc((::nAlias)->GEB_DAT)) ,,nMaxLen)
      nY += ::Linefeed()
   endif
   ::PrintText( nX,nY, alltrim((::nAlias)->INFO1) ,,nMaxLen)
   nY += ::Linefeed()
   ::PrintText( nX,nY, alltrim((::nAlias)->INFO2) ,,nMaxLen)
   nY += ::Linefeed()
   ::PrintText( nX,nY, alltrim((::nAlias)->INFO3) ,,nMaxLen)
   nY += ::Linefeed()

return self
*-------------------------------------------------------------
METHOD HBPrintAdress:PrintTitel()
   local nX, nY
   nX := ::SetLeftMargin()+(::nCol-1)*::nLabelSizeX+::nLabelLeftMargin
   nY := ::SetTopMargin() +(::nRow-1)*::nLabelSizeY+int(::nLabelSizeY*1/3)
   ::setFont(Title1)      // TextNorm, TextBold, Title1
   ::PrintText( nX,nY, ::cTitle1)
   ::setFont(Title2)      // TextNorm, TextBold, Title1
   nY := ::SetTopMargin() +(::nRow-1)*::nLabelSizeY+int(::nLabelSizeY/2)
   if ! empty(::cTitle2)
      ::PrintText( nX,nY, ::cTitle2)
      nY += 50
   endif
   ::PrintText( nX,nY, "Stand: "+dtoc(date()) )
return self


*--------------------- allgemeine Funktionen - einmalig im Programm --------------------------
*                      used functions, usefull for other Programms too



Function ErrBox(uText,cTitel)
   local cText,x,xMax
   DEFAULT cTitel TO "Fehlermeldung"
   do case
      case valtype(uText) = "A"
           cText := uText[1]
           xMax  := len(uText)
           for x := 2 to xMax
               cText += chr(13) + uText[x]
           next
      case valtype(uText) = "C"
           cText := uText
      otherwise
           cText := "ErrBox wurde mit falschem Parameter "+;
                    " uText  aufgerufen ! Type "+valtype(uText)+;
                    " statt C oder A"+chr(13)+;
                    "Bitte diesen Fehler melden."
   endcase
   MsgBox(cText,cTitel)
return NIL

*---------------------------------------------------------------------------
function ntrim( nVar )
return strTran(alltrim( str( nVar ) ),".",",")

