#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "XBPDEV.ch"

*---------------- Fonts nur einmal erzeugen - create fonts only once ------
procedure main
local oHBP, nPosY, nLR, nSpaNr, x, aDaten, cWindowsDruckerObjekt

SET CHARSET TO OEM

msgbox("This app will print 1 page with lines, then 3 lines on the next page and try to abort the print !"+chr(13)+chr(13)+;
       "Das Programm druckt eine Seite, und beginnt mit 3 Zeilen auf der nchsten Seite bevor der Abbruch versucht wird.")


// Netzwerkdrucker haben nicht immer den erwarteten Namen, GetPrinterName() zeigt wie man diesen finden kann.
// If the printer is attached over a network the name looks different:
// "Canon iP4500 series" on "\\server" will need "\\server\Canon iP4500 series"
// the function GetPrinterName() shows how to get the right printer out of the list.


cWindowsDruckerObjekt := GetPrinterName( "Canon iP7200 series" )

oHBP := HBPrinter():New():create(cWindowsDruckerObjekt) // :create() nutzt Standarddrucker

if oHBP:IsPrinterError()             // Fehler verhindern, avoid errors
   msgbox("Drucker ist nicht verfgbar !")
else
   oHBP:addFont("10.Arial") // hier werden alle bentigten Fonts in ein internes Array geladen
   oHBP:setFont(1)  // hier wird der gewnschte Font gewhlt
   oHBP:StartDoc("Drucktest")  // ein LASER wird dies im Display anzeigen, ein PDF Druckertreiber wird es als Dateinamen verwenden.
   nPosY  :=  200   // 2 cm von oberer Papierkante - Einheit 1/10 mm => 1 mm == 10, 1cm = 100
   nLR    :=  200   // 2 cm von linker Papierkante
   oHBP:PrintText( nLR  , nPosY, "Printer: "+cWindowsDruckerObjekt )

   nPosY  :=  300
   for x := 1 to 50
       //  :PrintText( nPosX, nPosY, xData, cAusrichtung, nMaxLen, cArt, nFarbe, nDrehen ) - das hilft immer ;-)
       oHBP:PrintText( nLR  , nPosY, "Zeile: "+str(x,4) ) // Standardausrichtung in Drucklnge, nicht gedreht ...
       nPosY += oHBP:LineFeed()  // eine Zeile weiter (0,0 ist linke obere Papierkante) mit Standardabstand. 50 wren 5 mm ... wie man will.
   next

   oHBP:NewPage()

   nPosY  :=  300
   for x := 1 to 50
       oHBP:PrintText( nLR  , nPosY, "Zeile: "+str(x,4) ) // Standardausrichtung in Drucklnge, nicht gedreht ...
       if x > 3

          msgbox("Bitte im Druckerobjekt nach dem Druckjob sehen"+chr(13)+;
                 "Please open the printer monitor and look for the printjob")       // without this line, nothing is realy printed !
                                                          // Ohne diese Schleife wird die Ausgabe noch vor der ersten Seite abgebrochen !

          oHBP:abort()  // the 2. Page will noch be printed, die zweite Seite wird nicht gedruckt !
          exit
       endif
       nPosY += oHBP:LineFeed()  // eine Zeile weiter (0,0 ist linke obere Papierkante) mit Standardabstand. 50 wren 5 mm ... wie man will.
   next
   oHBP:EndDoc()
endif
msgbox("OK")
return

function GetPrinterName( cWindowsDruckerObjekt )
   static cPrinterName := NIL
   local oP, aL, cD, i := 0
   if cPrinterName = NIL
      oP := XbpPrinter():new()
      if oP = NIL
         msgbox("Druckerobjekt konnte nicht erzeugt werden - no Print object","GetPrinterName()")
         quit
      else
         aL := oP:list()
         i := AScan( aL, {|x| lower(x) == lower(cWindowsDruckerObjekt) } )    // genau
         if i = 0
            i := AScan( aL, {|x| lower(cWindowsDruckerObjekt) $ lower(x) } )  // einiger Maen, z.B. bei Netzwerkdrucker
         endif
      endif
      if i > 0
         cPrinterName := aL[i]
      else
         msgbox("Drucker konnte nicht gefunden werden - no such printer","GetPrinterName()")
         quit
      endif
   endif
return cPrinterName
