********************************************************
*
*  HBPrinter fr Xbase++
*
*  Version:  1.41 - 2015-11-27
*
*  aktuelle Untersttzung fr    Xbase++ fr Win32  1.90.355 (supported)
*                                            und    1.90.331 (supported)
*          mit Abstrichen                           1.82.294 (still available)
*  grundstzlich lauffhig ab                       1.30.212 (not available)
*
*  ursprnglich entwickelt mit   Xbase++ fr OS/2   1.20.183 (not available)
*
*  ltere Versionen - test it, change it ... I don't care ;-)
*
********************************************************
*
*  Neueste Versionen auf / newest versions at
*
*  www.familie-brandel.de
*
*  Deutsche Anfragen zu HBPrinter bitte hier stellen:
*
*  http://www.xbaseforum.de/viewtopic.php?f=25&t=1174
*
********************************************************

/*  Entwicklung

   1.41 -  2015-11-27
           ::PrintMemo() ignorierte nderungen von ::nFirstLine, verbessert.

   1.40 -  2015-03-13
           NEU  ::PrinterList()        => XbpPrinter():List()
           NEU  ::GetDefaultPrinter()  => XbpPrinter():New():Create():devName
           NEU  ::IgnoreBusy           => ::IsPrinterError() ignoriert XBPPRN_STATUS_BUSY
                  - ermglicht das Drucken obwohl der Drucker auf BUSY steht.
                  - IgnoreBusy DEFAULT .f. => Fehler auch bei BUSY
                  - IgnoreBusy         .t. => KEIN Fehler bei BUSY
           NEU  ::IgnorePaused         => ::IsPrinterError() ignoriert XBPPRN_STATUS_PAUSED

   1.39 -  15.11.2013  (= 2013-11-15)
           NEU  ::PrintMemoLineMaxLen  speichert die lngste Zeile des zuletzt aufgerufenen ::PrintMemo(), ::PrintMemoPage()
           NEU  ::PrintArtBoxOffsetX   legt den Abstand Links/Rechts der cArt="B" Box zum Text fest, bisher fix 10 = 1 mm
           NEU  ::PrintArtBoxOffsetY   legt den Abstand Oben/Unten   der cArt="B" Box zum Text fest, bisher fix 10 = 1 mm

   1.38 -  14.11.2013  (= 2013-11-14)
           HBPRINTD.PRG - NTRIM() als STATIC FUNCTION ergnzt, ERRBOX() => MSGBOX()

   1.37 -  04.04.2013  (= 2013-04-04)
                ::PrintMemo()  Fehler bei Seitenumbruch, gemeldet von <Werner_Bayern>
           NEU  ::abort()      Abbruch des Druckjobs, erstellt von <Werner_Bayern> aus dem Forum.
           NEU  ::PrintMemoCountLines(cMemoText,nMaxLineLen) ermittelt wieviele Zeilen ::PrintMemo() bentigen wird, ohne tatschlich zu drucken.

   1.36 -  29.01.2012  (= 2012-01-29)
                ::PrintMemoLinePosX und ::PrintMemoLinePosY waren NIL bei einzeiligen Texten
                ::PrintMemo() druckte keine Zeilen mit nur einem Zeichen
           NEU: ::PrintMemoPage() druckt den Text der in den Bereich passt und gibt den Rest zurck

   1.35 -  20.05.2011  (= 2011-05-20)
           ::PrintMemo() speichert nun die Anzahl der gedruckten Zeilen in ::PrintMemoLineCount
           ::PrintMemo() speichert nun die GRA-Position der letzten gedruckten Zeilen in ::PrintMemoLinePosX und ::PrintMemoLinePosY

   1.34 -  16.09.2010  (= 2010-09-16)
           * ::PrintText() ndert ::PrintTextAlltrim GLOBAL bei cAusrichtung # "L"
             anstatt es nur lokal zu ignorieren. - verbessert.
           * cTxt -> xData, nun sind auch andere Datentypen erlaubt,
             diese werden intern nach Text umgesetzt.

   1.33   -  13.09.2009  (= 2009-09-13)
           .t. = NIL Fehler beseitigt.

   1.32   -  13.09.2009  (= 2009-09-13)
           NEU: ::say(nRow,nCol,xData,cAlign,nCPI,nLPI) // min == 1,1
                Diese Methode bernimmt die Positionsparameter (Zeile,Spalte)
                wie der   @z,s SAY ...   Befehl, um solche Migrationen zu vereinfachen.
           NEU: XbpPrinterDialog() kann als Druckerauswahl benutzt werden
           NEU: XbpPrinterD.PRG enthlt nun #defines fr die Texte, sodass
                diese leichter zu bersetzen sind.
           ::PrintText() setze ::PrintTextAlltrim bei cAusrichtung == "L"
                statt wie beschrieben bei cAusrichtung # "L"
                // nur bei linksbndig erlaubt // only when left - adjustment

   1.31   -  10.12.2008  (= 2008-12-10)
           Fehler beseitigt:
           PrintText( NIL, NIL, ...) druckte nicht in gleiche Zeile
           PrintText(,, cTxt ) druckt alltrim(cTxt)+" ", was meist richtig ist,
              aber ab und zu nicht passt (z.B. bei Fettdruck in Wort).
              Neue Variable ermglicht die Steuerung dieses Verhaltens.
              ::PrintTextAlltrim := .t. == altes Verhalten == alltrim(cTxt)+" "
              ::PrintTextAlltrim := .f. == der String wird nicht verndert !
           HBPrintDialog - ENTER oder doppelklick auf Drucker druckte nicht -> nun OK.
           ::spoolJobName ==> siehe / like 1.90.337
           ::icon         ==> hier kann ein ICON fr den Druckerdialog festgelegt werden.

   1.30   -  31.01.2006  (= 2006-01-31)
           Die Routinen wurden getestet und freigegeben.
           Der Barcode-Quelltext wurde nun im ZIP aufgenommen, ist aber
           weiterhin unabhngig und auch nicht ntig.

   1.20b2 -  15.12.2005  (= 2005-12-15)    (BETA)
           Einige PDF-Printer ndern den curdrive() und curdir() Pfad nach der
           Speicherdateiauswahl. :StartDoc() mu dies korrigieren und auf den
           alten Pfad zurcksetzen.

   1.20b1 -  05.08.2004  (= 2004-08-05)    (BETA)

           oHBPrinter:PrintingDialog( IsEscClose,IsEnterPrint,nPrintHotKey)
           ohne Parameter bleibt es bei den alten Einstellungen !
           nun kann man aber den Printdialog mit Hotkeys ausstatten:
           IsEscClose = NIL or .f. -> default = wie bisher
                      = .t.        -> ESC schliet den Printerdialog
           IsEnterPrint = NIL or .f. -> default = wie bisher
                        = .t.      -> Enter oder Return drucken auf den
                                      ausgewhlten Drucker.
                                      ACHTUNG: leider funktioniert das nicht
                                      solange die LISTBOX Druckerauswahl
                                      aktiv ist, da diese den Event verschluckt.
                                   -> ALT+Enter und ALT+Return funktionieren immer.
           nPrintHotKey = NIL or 0 = xbe_None -> default = wie bisher
                        = ALT_KEYCODE -> diese Kombination wird zum Hotkey

   1.13 -  12.01.2004  (= 2004-01-12)

           PrintMemo Fehler bei Quer druck beseitigen, neu: 180 und 270  - TESTEN !!!

   1.12 -  23.09.2003  (= 2003-09-23)

           Fehler bei Ausrichtung von Querausdrucken in PrintText().

           * TO DO

           PrintMemo Fehler wenn quer druck
           neue Static function und alte Methode berechnen Textbreite !!! vereinheitlichen
           viele direkte GRATEXTBOX Abfragen -> umstellen auf methoden bzw. funktion

   1.11 -  29.05.2003  (= 2003-05-29)
           Bei nicht verfgbaren Druckern (Netzwerkdrucker oder 'angehalten')
           fhrte die Abfrage nach dem Printerstatus / Printerfehler zu
           Fehlermeldungen bei lteren Compilern bzw. bei der Vorschaufunktion

           *** Wichtig ***

           Nach MyHBPrinter:Create() mu in Ihrem Programm
           IsPrinterError() abgeprft werden. Bei .T. mssen Sie eine
           Fehlermeldung anzeigen und drfen nicht drucken.
           Wenn Sie den HBPrinterDialog verwenden geschieht dies im
           Hintergrund und Sie brauchen sich nicht darum zu kmmern.
           Es schadet nie eine BEGIN SEQUENCE - END SEQUENCE um den
           Druckjob zu legen.

   1.10 -  20.05.2003  (= 2003-05-20)
           :PrintBarCodeEan13() -> hierzu wird meine Barcode-Funktion bentigt
           :StartDoc(cText, [nStartPageNo] ) -> nun kann die erste Seitennummer
                                                vorgegeben werden
           Neue Druckereinstellungen von Xpp 1.70 ff - nur fr Win32
           IsPrinterError() .f. / .t. -> Druckerobject ist fehlerhaft
                        *** Prfen nach CREATE vor erster Druckausgabe !
           PrintBMP     erst experimentell, parameter knnen sich ndern
                        Uwe Hackenberg - HBPrinterX User - sandte seine Implementierung
           IsSpaceOnPage(nPrintPosY,[nLines],[nBottomMargin])
                           - .t. falls die gewnschte Anzahl auf Seite pat
           nLineLen  VAR PROTECTED -> VAR EXPORTED
           GetTextLen(cTxt) ermittelt die Lnge (Breite) eines Strings im aktuellen Font
           HBPRINT.PRG kann nun auch wieder ohne HBPRINTD.PRG genutzt werden.
           PrintMemo hatte Probleme mit Worten, welche lnger waren
           als der erlaubte Druckbereich. Diese werden nun zerschnitten
           und umgebrochen. Blanks werden natrlich weiterhin bevorzugt !

   1.02 -  16.09.2001  (= 2001-09-16)
           Leere Seiten wurden gedruckt, wenn Seitenauswahl auf Drucker
           ohne Druckoptimierung ausgefhrt wurde.
           ::IsThisLastPage()   // kein Vorschub bei letzter Seite, wegen enddoc()
           ::SetAttr...   besere Erklrung der Parameter
           ::ReSetAttr... ::SetAttr kann seinen Rckgabewert nicht verarbeiten, da dort
                          mehr als 2 Elemente im 1. SubArray geliefert werden.
                          mit den ReSetAttr... Methoden kann der gespeicherte Zustand
                          wieder hergestellt werden.
           ::PrintLine    Linien sind zu dnn gezeichnet !

   1.01 -  06.09.2000  (= 2000-09-06)  kleinere Fehler beseitig

   1.0  -  04.09.2000  (= 2000-09-04)

*/

/*  History

   1.41 -  2015-11-27
           fixed ::PrintMemo(), now reads changed ::nFirstLine values

   1.40 -  2015-03-13
           NEW  ::PrinterList()        => XbpPrinter():List()
           NEW  ::GetDefaultPrinter()  => XbpPrinter():New():Create():devName
           NEW  ::IgnoreBusy           => ::IsPrinterError() don't care of XBPPRN_STATUS_BUSY
                  - printing is possible even the printer is BUSY
                  - IgnoreBusy DEFAULT .f. => ERROR    if BUSY
                  - IgnoreBusy         .t. => NO ERROR if BUSY
           NEU  ::IgnorePaused         => ::IsPrinterError() don't care of XBPPRN_STATUS_PAUSED

   1.38 -  2013-11-14
           HBPRINTD.PRG => new: NTRIM() as STATIC FUNCTION, ERRBOX() => MSGBOX()

   1.37 -  2013-04-04
                ::PrintMemo()  has an error with ::PrintMemoLinePosX and ::PrintMemoLinePosY  after NewPage()
           NEW  ::abort()      deletes the printjob without printing, if the printerdriver support this.
           NEW  ::PrintMemoCountLines(cMemoText,nMaxLineLen) counts the needed lines from ::PrintMemo() without printing.

   1.36 -  2012-01-29
                ::PrintMemoLinePosX and ::PrintMemoLinePosY was NIL if the text has only one line
                ::PrintMemo() did not print lines with only one character
           NEU: ::PrintMemoPage() will now print into the given margins but will not use new page. Will give back the rest.

   1.35 -  2011-05-20
           ::PrintMemo() will now save the number of printed lines in ::PrintMemoLineCount
           ::PrintMemo() will now save the GRA-Pos of the last printed line in ::PrintMemoLinePosX and ::PrintMemoLinePosY

   1.34 -  2010-09-16
           * ::PrintText() changed ::PrintTextAlltrim GLOBAL if cAusrichtung # "L"
             but it should only ignore it lokal. - fixed.
           * cTxt -> xData, the data parameter could now be not only a string.
             All datatypes will be internal converted to a string now.

   1.33 -  2009-09-23
           .t. = NIL Error fixed.

   1.32 -  2009-09-13
           New: ::say(nRow,nCol,xData,cAlign,nCPI,nLPI)  // min 1,1 !
                This method uses the position like the old clipper @z,s SAY ...
           New: XbpPrinterDialog() could be used for printer selection
           NEU: XbpPrinterD.PRG is now using #defines vor the text.
                This makes it easier to translate, and there is a english translation too.
                *** IF I USED A BAD TRANSLATION, PLEASE SEND A EMAIL TO ME !
           ::PrintText() cAusrichtung == "L" instead of cAusrichtung # "L"
                // nur bei linksbndig erlaubt // only when left - adjustment

   1.31 -  2008-12-10
           Fehler beseitigt:
           PrintText( NIL, NIL, ...) did not use the right pen position to print
           PrintText(,, cTxt ) prints a 'alltrim(cTxt)+" "', normaly OK,
              but sometimes not (needed trailing blanks or bold in a word).
              The new variable let you chouse how to do:
              ::PrintTextAlltrim := .t. == like befor == alltrim(cTxt)+" "
              ::PrintTextAlltrim := .f. == don't change the string !
           HBPrintDialog - ENTER and dubbleclick did not print -> now OK.
           ::spoolJobName ==> have a look at 1.90.337
           ::icon         ==> optional to define the icon for HBPrintDialog()

   1.30 -  2006-01-31
           I have tested and used these routines now long enough to release it.
           I have put the Barcode-Routines into this ZIP, but the are not needed
           and can be used standalone too.

   1.20b2 - 2005-12-15 (BETA)
           Some PDF-Printer change the curdrive() and curdir() after
           File selection. :StartDoc() have to reset to the old path !

   1.20b1 - 2004-08-05

           oHBPrinter:PrintingDialog( IsEscClose,IsEnterPrint,nPrintHotKey)
           without parameters no change needed.
           with parameters you can assign hotkeys to the printingdialog()
           IsEscClose = NIL or .f. -> default = as it was in 1.13
                      = .t.        -> ESC will close the printigndialog()
           IsEnterPrint = NIL or .f. -> default = as it was in 1.13
                        = .t.      -> Enter or Return will start printing, but
                                      ATTENTION: if the LISTBOX Druckerauswahl
                                      is aktiv it will not give the event to
                                      the keyboard method of the window.
                                   -> ALT+Enter und ALT+Return will work perfect
           nPrintHotKey = NIL or 0 = xbe_None -> default = as it was in 1.13
                        = ALT_KEYCODE -> you can define your own hotkey with
                                      the 3. parameter. But think, that many
                                      STRG+Key are still in use, so use
                                      ALT+Key

   1.13 -  2004-01-12

           PrintMemo error in landscape printing, new: 180 und 270

   1.12 -  2003-09-23

           Error in alignment with landscape printing PrintText()

   1.11 -  2003-05-29
           If the printer was not ready (halted or networkprinter)
           and you tried to get the printerstatus / IsPrinterError
           then the code run in an error - with older XPP versions or
           if preview was aktiv.

           *** ATTENTION ***

           After MyHBPrinter:Create() you have to test IsPrinterError()
           If there was one (.T.) you have to pop up an error message in
           your code and must not use the Object.
           If you use my HBPrinterDialog this is done by my routine and you
           don't have to care about it.
           But it is a good idea to BEGIN SEQUENCE - END SEQUENCE your printjob routine.

   1.10 -  2003-05-20
           :PrintBarCodeEan13() -> needs my Barcode-funktion
           :StartDoc(cText, [nStartPageNo] ) -> now you can set the first pageno
           New features from Xpp 1.70 ff - only Win32
           IsPrinterError() .f. / .t. -> printerobject is not ok
                        *** test this after CREATE bevor your first printoutput !
           PrintBMP     erst experimentell, parameter knnen sich ndern
                        Uwe Hackenberg - HBPrinterX User - sandte seine Implementierung
           IsSpaceOnPage(nPrintPosY,[nLines],[nBottomMargin])
                                - .t. if nLines can be printed on this page
           nLineLen  VAR PROTECTED -> VAR EXPORTED
           GetTextLen(cTxt) gives back the length (width) of a string with the active font
           HBPRINT.PRG can now be used without HBPRINTD.PRG
           PrintMemo had trouble if one word was bigger then the
           printing area width. Now the word ist cut into 2 lines.

   1.02 -  2001-09-16
           empty pages befor wanted pages, on several printers
           ::IsThisLastPage()   // no NewPage an last page, because of enddoc()
           ::SetAttr...   examples of parameters
           ::ReSetAttr... ::SetAttr can't use its own aOldValue because this array
                          has 4 elements in the first SubArray.
                          Use ReSetAttr... methods to reset an saved an aOldValue.
           ::PrintLine    lines have been to thin !

   1.01 -  2000-09-06  only bugs killed

   1.0  -  2000-09-04

*/


********************************************************
*
*  English translation is following.
*
*  WICHTIG:
*
*  HBPrinter ist KEINE Ableitung von XbpPrinter,
*  eher entspricht es einem PresentationSpace, aber
*  es ist eine vllig eigene Klasse, welche Druckausgaben
*  einfach definieren lsst und dann in die Xpp Gra...
*  Funktionen auflst. So kann man z.B. Memofelder mit
*  einer Methode direkt drucken, wobei der automatische
*  Zeilen und Seitenumbruch gewhrleistet ist.
*  Erst so werden vererbte Formulare mglich.
*  Um Hardwarernder braucht man sich nicht zu kmmern.
*  Man kann sofort auf den Standarddrucker drucken oder
*  aber eine Druckerauswahl anbieten.
*
*  Autor: Hubert Brandel, Hubert.Brandel@gmx.de
*                         Hubert.Brandel@web.de
*
*  Kurzer Rckblick:
*
*  Fr VisualObjects 1.0 entwickelte ich damals den
*  HBPrinter, da VO nicht hardware unabhngig drucken
*  konnte. Ja man glaubt es kaum, eine Druckausgabe auf
*  einem 300 dpi Drucker entwickelt, war auf einem 600 dpi
*  Drucker nur noch halb so gro. Der PresentationSpace
*  war nicht vorhanden. Aber auch die Angabe in Pixel oder
*  anderen Maen rissen mich nicht vom Hocker. Schlielich
*  konnte ich mich nie mit Reportgeneratoren anfreunden.
*  Dies wahrscheinlich auch deshalb, da ich selten einfache
*  Reports drucke, sondern meist aufwendige Formulare generiere.
*  Serienbriefe aber lagere ich in die Textverarbeitung aus.
*  Ein netter VO 2.x Anwender passte HBPrinter an VO 2.x an.
*
*  Xbase++ ist fr das Drucken wesentlich besser ausgestattet,
*  hat aber - meiner Meinung nach - einige Schnheitsfehler,
*  welche einem das Leben schwer machen.
*  Einer ist der Koordinatenursprung links unten statt
*  links oben, fr Mathe ganz nett, sonst nichts als schrott.
*  0,0 ist nun links oben.
*  Wer es dennoch bentigt, kann natrlich auch GRA_ Funktionen
*  untermischen mit den Xbase++ Eigenheiten.
*
*  Die GRA-Funktionen sind zwar ganz ntzlich, aber nur ein
*  Objektmodell lt Vererbung zu. Und die braucht man, wenn
*  man eine Dokumenthierarchie aufbauen will. Weiterhin
*  spart man sich im tglichen Einsatz viel Hirnschmalz,
*  wenn man die Klassen einmal richtig gemacht hat.
*
*  Ich hoffe meinen eigenen Vorgaben gerecht zu werden. ;-)
*
*  Ach ja zu den Lizenzbestimmungen:
*
*  Jeder darf diesen Quellcode nutzen und fr eigene Zwecke
*  abwandeln, solange niemand meine Urheberschaft anzweifelt.
*  Ich freue mich natrlich ber jede Aufmerksamkeit und
*  seien es auch nur nette Worte.
*  Diese habe ich fr HBPrinter VO viel erhalten.
*  Und ein paar gute Tafeln Schokolade aus der Schweiz :-) .
*  Sollte jemand den HBPrinter in ein Programm einbinden,
*  mit dem er ordentlich Geld verdient, fnde ich es schon
*  schn etwas davon zu bekommen, nicht dass ich mit etwas
*  rechnen wrde.
*
*  Zu guter letzt:      ICH HAFTE FR NICHTS !!!!
*
*  Danke an alle, welche mir schon geholfen haben.
*  Tsch
*  Hubert Brandel
*
********************************************************
*  Hallo, my english is poor, so I am happy if someone
*  tells me mistakes in the translation or to less or
*  wrong explanations in the code.
********************************************************
*
*  IMPORTANT:
*
*  HBPrinter is NOT a inheritance from XbpPrinter,
*  it behaves as a PresentationSpace, but it is
*  a new (my own) class, to easier program
*  print output as with Xpp Gra... funktions.
*  It is possible to print memofields (or large text)
*  with one method call. And this method cares about
*  the soft margins and if nessesary it will use a
*  new page.
*  You don't have to care about hardware margins
*  This is needed if you want inherit forms.
*  You can print directly on the default printer
*  or show a printerselection screen with preview.
*  0,0 is in HB_Printer left top of Page.
*
*  Author: Hubert Brandel, Hubert.Brandel@gmx.de
*                          Hubert.Brandel@web.de
*
*  History:
*
*  I made the first HBPrinter for  VisualObjects 1.0
*  Years ago. Because VO was not deviceindependent.
*  Unbelieveable: a printoutput programed for a
*  300 dpi printer, and printed on a 600 dpi printer
*  was ziped together only 1/2 of the orignal.
*  Thats ok for Windowsscreens but not for printoutput.
*  There was no presentationspace.
*  OK all World is using reportgenerators, but I
*  don't want them. I have to program very complex
*  Forms and it is easier for ME to program it with
*  Xbase++ and HBPrinter.
*  A nice guy translated HBPrinter 1.0 from VO 1.0
*  to VO 2.x - I was now on Xbase++
*
*  Licence:
*
*  Everyone can use and modify the code for his needs.
*  But HBPrinter is my product.
*  It would be nice to here responce and if someone
*  earns money with a program printing with hpprinter
*  it would be very nice, to get a little tip.
*  Not that I am waiting for <g>.
*
*  DISCLAIMER: I am NOT responciple for any damage or whatever !!!!
*
*  Thanks and bye
*  Hubert Brandel
*

/*

**********************************************************************
*                                                                    *
*     0 , 0   ist in der oberen linken Ecke - is TOP-LEFT-Corner     *
*                                                                    *
**********************************************************************

Kurze Erklrung der Methoden - short expanation
bitte auch in den Code sehen - look in the code...


* hier wird die Druckausgabe programmiert - here you define the print output !

MyHBPrinter             ableiten von - inherit from :   CLASS HBPrinter
                        siehe unten  - see examble following
                        fr jedes Dokument eines ! - for each different print output
                        Siehe hierzu - have a look to :  TEST.PRG

MyHBPrinter:PrintForm() Hier den fixen Text definieren (Seitennummer,
                        Fu- / Kopfzeilen etc. Eventuell eine do case
                        Verschachtelung je nach Seitennummer.
                        define here the fix text (page number, head and
                        feedlines etc.
                        Siehe hierzu - have a look to :  TEST.PRG

MyHBPrinter:Print()     Diese Methode wird vom Druckerdialog aufgerufen.
                        Sie druckt die variablen Teile, berwacht
                        Seitenwechsel und ruft PrintForm() auf.
                        This method is called from the HBPrinterdialog.
                        All variable printoutput is defined here.
                        This method have to care about pagebreak and
                        calls PrintForm().
                        Siehe hierzu - have a look to :  TEST.PRG, HBPrintD.PRG
IsAfterLastPage()       wenn .t. in print(), kann Druckausgabe beendet werden -> shortcut
                        if .t. in print(), print output ist done -> shortcut
                        Siehe hierzu - have a look to :  TEST.PRG, HBPrintD.PRG

* falls eine Druckerauswahl mit preview gewnscht wird
* if preview is used

MyHBPrinter:PrintingDialog   Druckerauswahl und Prieview - Printerdialog and preview -> calls ::PRINT()

* diese methoden bzw. Variablen knnen (z.B. in Print(), Printform() aber auch direkt ! ) benutzt werden
* those methods and membarvariables can be used (in Print(), Printform() or direkt ! )

* Ausgabe - output

PrintArc( nLeftX, nTopY, nRadius, aEllipse,nStartAngle,nSweepAngle,nFill )
PrintBMP                erst experimentell, parameter knnen sich ndern
                        Uwe Hackenberg - HBPrinterX User - sandte seine Implementierung
                        Uwe Hackenberg - HBPrinterX user - send his code to me
                        * no errors by now.
PrintBox(nLeftX,nTopY,nSizeX, nSizeY,cRelativAbsolut,nFill, nHRadius, nVRadius)
PrintLine(nPos1X,nPos1Y,nPos2X,nPos2Y)
PrintMarker(nPos1X,nPos1Y)
PrintMemo( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, cHochQuer, nMaxBis,nLineFeed )
PrintMemoPage( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, cHochQuer, nMaxBis,nLineFeed )

PrintSpline( aPointsHB, lPenPos )
PrintText( nPosX, nPosY, xData, cAusrichtung, nMaxLen, cArt, nFarbe, nDrehen )
::PrintTextAlltrim := .t. -> alltrim(cTxt)+" "
::PrintTextAlltrim := .f. -> cTxt ohne nderung drucken

::say(nRow,nCol,xData,cAlign,nCPI,nLPI) -> @nRow,nCol SAY ...
          // The fonts are not exactly the same size, and may depend on the printer
          // or printersetting (:setFontMode( [<nMode>] )
          // Die Fontgre sind nicht genau gleich. Auerdem knnen Sie vom
          // Druckermodell bzw. der Druckereinstellung abhngen (:setFontMode( [<nMode>] )
          // 10 CPI -> 12. -> 6 lines per inch = nLPI
          // 12 CPI -> 10. -> 8 lines per inch = nLPI
          // 17 CPI ->  7.

PrintBarCodeEan13()     -> hierzu wird meine Barcode-Funktion bentigt
                        -> needs my Barcode-funktion


* Zeilenvorschub - linefeed or move

LineFeedMM( nValue )
LineFeed( nLines, nDistance )
MoveTo(nX,nY)
GetTextLen(cTxt)        ermittelt die Lnge (Breite) eines Strings im aktuellen Font
                        gives back the length (width) of a string with the active font


* logische Seitenrnder setzen - user defined margins

nFirstLine              am Anfang der Routine definieren und in PRINT nach Seitenumbruch
                        nZeilenZhler := nFirstLine setzen
                        define once and use it in PRINT() after formfeed (newpage)
                        nZeilenZhler := nFirstLine
SetBottomMargin(nHB_Pos)
SetLeftMargin(nHB_Pos)
SetRightMargin(nHB_Pos)
SetTopMargin(nHB_Pos)

* Neue Druckereinstellungen von Xpp 1.70 ff - nur fr Win32, siehe Xpp-Dokumentation XbpPrinter
  New features from Xpp 1.70 ff - only Win32, have a look to Xpp-dokumentation XbpPrinter

comment
devPort
location

getHDC()
forms()
paperBins()
printerStatus()
resolutions()

setCollationMode( <nMode> )
setColorMode( <nMode> )
setDuplexMode( <nMode> )
setFontMode( <nMode> )
setFormSize( <nFormID> )
setNumCopies( <nNumCopies> )
setOrientation( <nOrientation> )
setPaperBin( <nBin> )
setPrintFile( [<cFileName>] )
setResolution( <aResolution> )
setupDialog()                     // earlier Versions too

* Info nur lesen ! - just for information. READ ONLY

IsSpaceOnPage(nPrintPosY,[nLines],[nBottomMargin])
                        - .t. falls die gewnschte Anzahl auf Seite pat
                        - .t. if nLines can be printed on this page
                        [nLines]        default to 0
                        [nBottomMargin] default to ::nBottomMargin


nPageNo                 Seitennummer der Druckseite - page number of printed page
                        leicht nderbar, aufpassen - its easier this way, but be carefull
DevName                 Druckername - Printername
nPaperSizeX, nPaperSizeY
nLeftMarginDC           Hardware Druckerrnder - not printable printer margins
nTopMarginDC
nBottomMarginDC         all - alle ....DC -> ### XPP coordinates ###
nRightMarginDC


* Schriftenverwaltung siehe Test.prg - font management look at test.prg

aFontList               bentigte Fonts jeweils einmal erzeugen und dann speichern
                        create your needed fonts once and store for further use
                        Siehe hierzu - have a look to :  TEST.PRG
AddFont(uFont)
SetFont(uFont)

* Verschiedens - rest...

PosHBtoXPP(nHBX, nHBY)  Umrechnen der Koordinaten nach Xpp - transform the coordiantes to Xpp

SetAttrArea             bitte im Handbuch nachsehen - have a look to onlinehelp
SetAttrLine             Parameter:   {  {  Type , Value } , ...  }
                        aOldValue := ::SetAttrLine( { { GRA_AL_WIDTH , GRA_LINEWIDTH_NORMAL }    ,;
                                                      { GRA_AL_TYPE  , GRA_LINETYPE_SOLID   } }  )
                        zurcksetzen mit / reset with
                        ::ReSetAttrLine( aOldValue )   oder / or  GraSetAttrLine( ::oPS, aOldValue )

SetAttrMarker           -> GRA....
SetAttrString

ReSetAttrMarker( aAttribAlt )                 // VER 1.02
ReSetAttrLine( aAttribAlt )                   // VER 1.02
ReSetAttrArea( aAttribAlt )                   // VER 1.02
ReSetAttrString( aAttribAlt )                 // VER 1.02

SetColor( nColorFront, nColorBack )




* nicht benutzen, wenn HBPrintDialog benutzt wird, dann steuert dieser diese Werte
* don't use this methods if HBPrintDialog is used.

PreviewDrawIsActive     aktuelles Print wurde durch PreviewDraw aufgerufen - Previewdraw starts print
SetPrintPages()
StartDoc()
EndDoc()
NewPage()
PrinterPS()
DestroyPS()
Destroy()
Clear_oPS                _oPS := NIL + destroy device

* Intern, aber ntig wenn GRA Funktionen eingemischt werden
* Internal, but usefull wenn you need GRA functions

GetPos                   Return -> GraPos()
oPS                      Internes Presentationspaceobject, kann benutzt werden aber aufpassen
                         internal presentationspaceobject, you can use it
* wie immer - like xpp normaly

Init
Create

*/
***************************** CODE ********************

#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "XBPDEV.ch"

#ifndef CRLF
   #define CRLF chr(13)+chr(10)
#endif

*-----------------------------------------------------------
CLASS HBPrinter from _HBPrinter
   PROTECTED:
      VAR    lFirstPageForm        // Wurde Formular auf 1. Seite gedruckt - is form printed on 1. page ?
   EXPORTED:


      METHOD Print                 // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                   // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                   // all variable output is defined in this method. If necessary it will call
                                   // ::NewPage(), increase the PageNo and calls ::PrintForm()
      METHOD PrintForm             // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                   // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                   // all fix output - don't care where on page - is defined in this method.
                                   // Never call ::NewPage() inside.
ENDCLASS

*-------------------------------------------------------------
* die folgenden Methoden anpassen - folowing methods has to be modified
*-------------------------------------------------------------
METHOD HBPrinter:PrintForm()       // Alle fixen Bestandteile einer Seite, egal ob unten oder oben werden hier definiert,
                                   // hier wird KEIN Seitenumbruch aufgerufen, denn der knnte unntig sein (1.Seite).
                                   // all fix output - don't care where on page - is defined in this method.
                                   // Never call ::NewPage() inside.
   ::lFirstPageForm := .t.

   * ::HBPrinter:PrintForm()       // in abgeleiteten Klassen aufrufen - call in derived class
   * Hier folgt ihr Code in einer abgeleiteten Klasse - your code in a derived class

return self

*-------------------------------------------------------------
METHOD HBPrinter:Print()           // Alle variablen Druckausgaben werden hier definiert, wenn ntig wird ein
                                   // Seitenwechsel durchgefhrt, der Seitenzhler erhht und ::PrintForm() aufgerufen.
                                   // all variable output is defined in this method. If necessary it will call
                                   // ::NewPage(), increase the PageNo and calls ::PrintForm()

   ::nPageNo := 1
   ::lFirstPageForm := .f.         // Formular 1. Seite noch nicht gedruckt - form 1. page not printed

   * ::HBPrinter:Print()           // in abgeleiteten Klassen aufrufen - call in derived class
   * Hier folgt ihr Code in einer abgeleiteten Klasse - your code in a derived class

return self







*--------------------------------------------------------------------------------------------------
* Normalerweise gibt es hier nichts zu ndern - normaly don't change following lines
*--------------------------------------------------------------------------------------------------

CLASS  _HBPrinter

   PROTECTED:
      VAR    _oPS                  // Falls Druckerauswahl benutzt wird, kann hier auch ein Preview oPS genutzt werden
                                   // Diese Variable wird an alle internen Aufrufe von GRA - Funktionen bergeben.
                                   // if the PrinterSelectionSreen is used, a window oPS can show a preview
                                   // this variable will be used as parameter for all internal calls of GRA - funtions.
      VAR    oPrinterPS            // Hier wird vom Druckerauswahlbildschirm immer das Drucker oPS gespeichert,
                                   // welches in der Listbox ausgewhlt wurde.
      VAR    oUseXbpPrinter        // XbpPrinterDialog() -> oXbpPrinter
                                   //         -> HBPrinter():New(oXbpPrinter)
      VAR    _oHBPrintDialog
      VAR    _cPrinterShowText     // Parameter merken von ::StartDoc(cText) - store cText parameter
      VAR    _IsOpenStartDoc       // .t. after Startdoc(), .f. after Enddoc()
      VAR    _PrinterCreateErr

      VAR    nLeftMargin           // HB Koordinaten - links/oben ist 0,0 - HB coordinates - left/top is 0,0
      VAR    nTopMargin            // diese Werte werden von verschiedenen    - vor use in several routines
      VAR    nBottomMargin         // Routinen benutzt. z.B. PrintMemo()      - e.g. PrintMemo()
      VAR    nRightMargin          // in die Rnder kann dennoch gedruckt werden  - but you can print in margins
      VAR    nBreite               // Breite zwischen Hardwarerndern - width  between hardwaremargins
      VAR    nHoehe                // Hoehe  zwischen Hardwarerndern - heigth between hardwaremargins

      VAR    cPrintPages           // NIL or empty -> alles drucken - print all
                                   // *1*2*3*4 ... -> "*"+ntrim(::PageNo)+"*" $ cPrintPages !!! --> METHOD SetPrintPages
                                   // SetPrintPages() ist flexibler, erlaubte Parametertypen:      1, "1", "*1*2*3*"
                                   //        "        use the function, it takes Parameters like:        "
                                   // IsPageToPrint() fragt die Variable ab - is used in my routines for: print or skip
      METHOD SetInternalPageVars   // set nLeftMargin, nTopMargin, nBottomMargin, nRightMargin,
                                   // nBreite, nHoehe

      METHOD IsPageToPrint
      METHOD IsThisLastPage        // kein Vorschub bei letzter Seite, wegen
                                   // no NewPage an last page, because of
                                   // enddoc()
      VAR    nLineFeed             // method LineFeed(6) -> 6 * nLineFeed = Zeilenvorschub - line feed
                                   // nLineFeed wird mit dem Standardabstand des aktuellen Font geladen !
                                   //  "        will be set to the font hight of the standard font
                                   //   -> SetFont
      VAR    nPosY                 // Feinabstimmung, Ausgabe in y-Achse verschieben - if it will not fit, ... move
      VAR    nPosX                 // Feinabstimmung, Ausgabe in x-Achse verschieben - if it will not fit, ... move
      VAR    IsPrintMemoCountLines // blockiert den Ausdruck wenn PrintMemoCountLines() aktiv ist.

   EXPORTED:
      VAR    cVorgabeSeiten        // Vorgabetext fr HBPrintDialog - Seitenauswahl
                                   // default settings for HBPrintDialog - page selection
      VAR    Icon
      VAR    nPageNo               // leicht nderbar, aufpassen - its easier this way, but be carefull
      VAR    nFirstLine
      VAR    nLineLen
      VAR    aFontList             // bentigte Fonts jeweils einmal erzeugen und dann speichern
                                   // create your needed fonts once and store for further use
      VAR    nPaperSizeX, nPaperSizeY
      VAR    nLeftMarginDC         // Hardware Druckerrnder - not printable printer margins ### XPP coordinates ###
      VAR    nTopMarginDC          //
      VAR    nBottomMarginDC       //
      VAR    nRightMarginDC        //
      VAR    PreviewDrawIsActive   // aktuelles Print wurde durch PreviewDraw aufgerufen - Previewdraw starts print
      VAR    PrintTextAlltrim      // Steuert ::PrintText(), siehe dort -> ::PrintText()
      VAR    cTextYes, cTextNo     // ::PrintText(,, .t. ) -> cTextYes, ::PrintText(,, .f. ) -> cTextNo
      VAR    cPreViewPrinter
      VAR    IgnoreBusy            // => IsPrinterError
      VAR    IgnorePaused          // => IsPrinterError


      METHOD Init
      METHOD Create

      METHOD PrintingDialog
      METHOD IsPrinterError
      METHOD PrinterList           // => XbpPrinter():List()
      METHOD GetDefaultPrinter     // => XbpPrinter():New():Create():devName
      ACCESS METHOD DevName

      ACCESS ASSIGN METHOD oPS     //
      ACCESS ASSIGN METHOD SpoolJobName

      METHOD Clear_oPS             // _oPS := NIL + destroy device

      METHOD LineFeedMM            // setzt GraPos() um nWert in mm weiter und gibt die Distanz in 1/10mm zurck
                                   // move nValue mm to bottom and give the distance in 1/10mm back
      METHOD LineFeed              // setzt GraPos() um AnzahlZeilen * nLineFeed weiter und gibt die Distanz zurck
                                   // move nRowCount * nLineFeed to bottom and give the distance in 1/10mm back
      METHOD MoveTo                // Verschieben um X oder Y oder X+Y - move X or Y or X+Y
                                   // Return -> GraPos()
      METHOD GetPos                // Return -> GraPos()
      METHOD GetTextLen            // ermittelt die Lnge (Breite) eines Strings im aktuellen Font
                                   // gives back the length (width) of a string with the active font
      METHOD PosHBtoXPP            // Umrechnen der Koordinaten nach Xpp - transform the coordiantes to Xpp
      METHOD PrintArc
      METHOD PrintBMP              // erst experimentell !! Parameter knnen sich ndern !
*      METHOD PrintGraph
      METHOD PrintBox
      METHOD PrintLine
      METHOD PrintMarker
      METHOD PrintMemo
      METHOD PrintMemoPage         // VER 1.36
      METHOD PrintMemoCountLines   // VER 1.37

      VAR    PrintMemoLineCount    // VER 1.35
      VAR    PrintMemoLinePosX     // VER 1.35
      VAR    PrintMemoLinePosY     // VER 1.35
      VAR    PrintMemoLineMaxLen   // VER 1.39
      VAR    PrintArtBoxOffsetX    // VER 1.39
      VAR    PrintArtBoxOffsetY    // VER 1.39

      METHOD PrintSpline
      METHOD PrintText             // Text drucken mit Ausrichtung - printing text with adjustment
      METHOD SAY                   // ::say(nRow,nCol,xData,cAlign,nCPI,nLPI) -> @nRow,nCol SAY ...
      METHOD PrintBarCodeEan13
      METHOD SetAttrArea
      METHOD SetAttrLine
      METHOD SetAttrMarker
      METHOD SetAttrString
      METHOD ReSetAttrMarker       // VER 1.02
      METHOD ReSetAttrLine         // VER 1.02
      METHOD ReSetAttrArea         // VER 1.02
      METHOD ReSetAttrString       // VER 1.02

      METHOD SetBottomMargin
      METHOD SetColor
      METHOD SetFont
      METHOD AddFont
      METHOD SetLeftMargin
      METHOD SetPrintPages
      METHOD SetRightMargin
      METHOD SetTopMargin
      METHOD StartDoc
      METHOD EndDoc
      METHOD NewPage
      METHOD PrinterPS
      METHOD DestroyPS
      METHOD Destroy
      METHOD IsAfterLastPage
      METHOD IsSpaceOnPage

      * Neue Druckereinstellungen von Xpp 1.70 ff - nur fr Win32, siehe Xpp-Dokumentation XbpPrinter
      *  New features from Xpp 1.70 ff - only Win32, have a look to Xpp-dokumentation XbpPrinter

      #IFDEF XPPVER
      #IF XPPVER > 170              // Falls etwas schon frher mglich war, bitte mitteilen
                                    // please tell me, if one of those was early evalable

          METHOD ABORT              // 1.37 - depends on printer !

          ACCESS METHOD comment
          ACCESS METHOD devPort
          ACCESS METHOD location

          METHOD getHDC             // test not at end
          METHOD forms
          METHOD paperBins
          METHOD printerStatus
          METHOD resolutions        // test not at end

          /*
          * ACHTUNG * ATTENTION *

          Diese set... Funktionen knnen auch innerhalb eines mehrseitigen Dokumentes
          verwendet werden, ABER immer direkt nach dem Seitenumbruch VOR den anderen Einstellungen.
          Da intern der Druckkanal immer neu geffnet werden mu (Startdoc, Enddoc, configure etc.)
          Sollten Schriften und andere Attribute neue gesetzt werden.
          Wenn Sie es knnen, sollten Sie selbst vor dem Aufruf mit Enddoc() den Kanal schlieen,
          alle gewnschten set... Funktionen aufrufen und mit Startdoc() neu beginnen.
          Die Seitennummer mssen Sie dann aber selbst erhhen und Startdoc() als 2. Parameter bergeben.
          Es kann nicht ausgeschlossen werden, dass die Funktionen sich sonst gegenseitig beeinflussen.


          You can use this set... functions at any page within a printjob, BUT you have to
          use it direktly after the ::NewPage(). Internal I have to close the printjob and
          open it again (Startdoc, Enddoc, configure etc.) so maybe you have to set all
          attributs (fonts etc.) new.
          If possible you should call enddoc() from your code, then call the needed set...
          functions. After all you have to call startdoc() with the correct pageno as second
          parameter.
          Otherwisecould
          */

          METHOD setCollationMode   // test not at end
          METHOD setColorMode       // test not at end
          METHOD setDuplexMode      // test not at end
          METHOD setFontMode        // test not at end
          METHOD setFormSize        // test not at end
          METHOD setNumCopies
          METHOD setOrientation
          METHOD setPaperBin
          METHOD setPrintFile
          METHOD setResolution      // test not at end

      #ENDIF
      #ENDIF

      METHOD setupDialog()          // Dies immer als erstes aufrufen !
                                    // This have to be called bevor all other methods after Create()
ENDCLASS

*-------------------------------------------------------------
METHOD _HBPrinter:init(oXbpPrinter)  // hier noch keine Druckerfestlegung - no printer selection here
                                     // erst bei create                   - create will build the printer
   ::oUseXbpPrinter      := oXbpPrinter
   ::_oPS                := NIL
   ::_IsOpenStartDoc     := .F.
   ::oPrinterPS          := NIL
   ::PreviewDrawIsActive := .f.
   ::nPaperSizeX         := 2100
   ::nPaperSizeY         := 2970
   ::nLeftMargin         := 200           // 2cm Rand ist Standard  - default 2 cm margins
   ::nTopMargin          := 200
   ::nFirstLine          := ::nTopMargin - 400
   ::nBottomMargin       := ::nPaperSizeY - 200    // alles bezogen auf die linke obere Ecke.
   ::nRightMargin        := ::nPaperSizeX - 200    // origin is the corner in left top
   ::nLineLen            := ::nRightMargin - ::nLeftMargin
   ::nPosY               := 0
   ::nPosX               := 0
   ::cPrintPages         := ""            // empty(cPrintPages) -> alles drucken - print all
   ::aFontList           := {}
   ::PrintTextAlltrim    := .t.
   ::cTextYes            := "Ja"
   ::cTextNo             := "Nein"
   ::cVorgabeSeiten      := ""
   ::icon                := 0             // Xbase Standard Icon
   ::IsPrintMemoCountLines := .f.
   ::PrintMemoLineCount  := 0
   ::PrintMemoLinePosX   := 0
   ::PrintMemoLinePosY   := 0
   ::cPreViewPrinter     := "PreView"
   ::PrintMemoLineMaxLen := 0
   ::PrintArtBoxOffsetX  := 10
   ::PrintArtBoxOffsetY  := 10
   ::IgnoreBusy          := .f.
   ::IgnorePaused        := .f.

   ::nPageNo             := 1

return self
*-------------------------------------------------------------
METHOD _HBPrinter:destroy()
   ::destroyPS(::_oPS)
   ::destroyPS(::oPrinterPS)
return self
*-------------------------------------------------------------
METHOD _HBPrinter:create(cPrinterName)

   if IsNil(::_oPS)
      ::_oPS             := ::PrinterPS(cPrinterName)
      ::oPrinterPS       := ::_oPS
   endif

   ::nLineFeed           := 49 // laut AmiPro hat 12 Punkt Times new Roman genau 4.9 mm Abstand.
                               // a 12 point Times New Roman in AmiPro (my favorite textprogram) has exactly 4.9 mm linefeed

return self

*-------------------------------------------------------------
METHOD _HBPrinter:IsPrinterError(oDC)
   local lIsPrinterError
   DEFAULT oDC TO ::oPS:device()
   do case
      case ::_PrinterCreateErr               // error at create -> there could be nothing
           lIsPrinterError := .t.            // Fehler schon bei create -> da kann nichts sein
      case IsNil(oDC)
           lIsPrinterError := .t.            // NIL !
      case oDC:isDerivedFrom( "XbpPrinter" ) .and. IsMethod(oDC,"printerStatus")
           if (oDC:printerStatus() = XBPPRN_STATUS_READY                       ) .or. ;
              (oDC:printerStatus() = XBPPRN_STATUS_BUSY   .and. ::IgnoreBusy   ) .or. ;
              (oDC:printerStatus() = XBPPRN_STATUS_PAUSED .and. ::IgnorePaused )

              lIsPrinterError := .f.
           else
              lIsPrinterError := .t.
           endif
   endcase
return lIsPrinterError
*-------------------------------------------------------------
METHOD _HBPrinter:PrintingDialog(IsEscClose,IsEnterPrint,nPrintHotKey) //
   ::_oHBPrintDialog := &("HBPrintDialog():new()")       // Sonst wre HBPrintD.PRG immer ntig, obwohl
   ::_oHBPrintDialog:oHBPrinter := SELF                  // keine Dialog angezeigt werden soll.
   ::_oHBPrintDialog:icon       := ::icon
   ::_oHBPrintDialog:create()                            // without &() there would be an linkerror if
   if Valtype(IsEnterPrint) = "L"
      ::_oHBPrintDialog:IsEnterPrint := IsEnterPrint
   endif
   if Valtype(IsEscClose)   = "L"
      ::_oHBPrintDialog:IsEscClose   := IsEscClose
   endif
   if Valtype(nPrintHotKey) = "N"
      ::_oHBPrintDialog:nPrintHotKey := nPrintHotKey
   endif
   if ! empty(::cVorgabeSeiten)
      ::_oHBPrintDialog:chbAlleSeiten:setData(.f.)
      ::_oHBPrintDialog:sleSeiten:setData(::cVorgabeSeiten)
   endif
   ::_oHBPrintDialog:EventLoop()                         // don't need to use HBPrintD.PRG with it.
return self
*-------------------------------------------------------------
METHOD _HBPrinter:SetPrintPages(uPrintPages)
   local cReturn

   DEFAULT uPrintPages TO " "                        // alles drucken - print all
   cReturn := ::cPrintPages                          // Rckgabe wie bei anderen Setxxx Funktionen
                                                     // (NIL) aktueller Wert, sonst alter Wert
                                                     // return value behaves like other Setxxx functions
                                                     // (NIL) actual value, other parameter old value
   if ! IsNil(uPrintPages)
      if valtype(uPrintPages) = "N"                  // nur eine Seite als Nummer - only on page as number
         uPrintPages := alltrim(str(uPrintPages,5,0))// print( 1 )   -> OK -> "1"   fr preview oder eine seite -
                                                     //                             for preview or one page
      endif
      if empty( uPrintPages )
         ::cPrintPages := " "
      else
         ::cPrintPages := "*"+uPrintPages+"*"       // print( "1" ) -> OK -> "*1*" fr preview oder eine seite -
      endif                                         //                             for preview or one page
   endif                                            // Print("*1")  -> OK -> "**1**" macht nichts - no problem

return cReturn
*-------------------------------------------------------------
METHOD _HBPrinter:IsPageToPrint(nPageNo)            // Zielseite nPageNo kann bergeben werden
   local lPrintPage                                 // user can direkt check for a single page
   DEFAULT nPageNo TO ::nPageNo
   do case
      case IsNil(::cPrintPages) .or. empty(::cPrintPages)
           lPrintPage := .t.                        // ausgeben und bewegen - print and move
      case "*"+alltrim(str(nPageNo,5,0))+"*" $ ::cPrintPages
           lPrintPage := .t.                        // ausgeben und bewegen - print and move
      otherwise
           lPrintPage := .f.                        // NUR bewegen          - ONLY move
   endcase
return lPrintPage
*-------------------------------------------------------------
METHOD _HBPrinter:IsThisLastPage(nPageNo)           // Zielseite nPageNo kann bergeben werden
   local lPrintPage, cPrintPages                    // user can direkt check for a single page
   DEFAULT nPageNo     TO ::nPageNo

   do case
      case IsNil(::cPrintPages) .or. empty(::cPrintPages)
           lPrintPage  := .f.                       // ausgeben und bewegen - print and move
      otherwise                                     // Gibt es eine Druckseite nach aktueller Seite?
           lPrintPage  := .t.                       // is there a printpage after this page?
           cPrintPages := ::cPrintPages
           do while ! empty(cPrintPages)
              do while left(cPrintPages,1)="*"
                 cPrintPages := substr(cPrintPages,2)
              enddo
              if nPageNo < val(cPrintPages)         // Nein es gibt noch Folgeseiten - No there are more
                 lPrintPage := .f.
                 exit
              else
                 cPrintPages := substr(cPrintPages,at("*",cPrintPages))
              endif
           enddo
   endcase
return lPrintPage
*-------------------------------------------------------------
METHOD _HBPrinter:IsAfterLastPage()
   local lAfterLastPage, cLastPrintPage, nLastPrintPage, x

   lAfterLastPage := .f.             // Standard: alles drucken kein schnelles ende - normaly no short cut

   if ! ( IsNil(::cPrintPages) .or. empty(::cPrintPages) )  // OK - shortcut testen
      cLastPrintPage := ::cPrintPages                       // letzte Druckseite als Zahl ermitteln
      do while right(cLastPrintPage,1)="*"                  // get last page to print as numeric val
         cLastPrintPage := left(cLastPrintPage, len(cLastPrintPage)-1)
      enddo
      x := rat("*",cLastPrintPage)
      if x > 0
         cLastPrintPage := substr(cLastPrintPage,x+1)
         nLastPrintPage := val(cLastPrintPage)
         if ::nPageNo > nLastPrintPage
            lAfterLastPage := .t.                           // shortcut ist mglich - is possible
         endif
      endif
   endif
RETURN lAfterLastPage

*-------------------------------------------------------------
METHOD _HBPrinter:LineFeedMM( nValue ) // setzt GraPos() um nWert in mm weiter und gibt die Distanz in 1/10mm zurck
                                       // move nValue mm to bottom and give the distance in 1/10mm back
    local aPos
    DEFAULT nValue TO 0
    nValue := int( (nValue * 10) )     // mm/10 * 10 -> mm
    aPos   := GraPos(::oPS )
    GraPos(::oPS,{aPos[1],aPos[2]-nValue})
RETURN nValue
*-------------------------------------------------------------
METHOD _HBPrinter:LineFeed( nLines, nDistance )   // setzt GraPos() um AnzahlZeilen * nLineFeed weiter und gibt die Distanz zurck
                                                  // move nLines * nLineFeed to bottom and give the distance in 1/10mm back
    local aPos, nValue
    DEFAULT nLines    TO 1
    DEFAULT nDistance TO ::nLineFeed
    nValue := int(nLines * nDistance)
    aPos   := GraPos(::oPS )
    GraPos(::oPS,{aPos[1],aPos[2]-nValue})

RETURN nValue
*-------------------------------------------------------------
METHOD _HBPrinter:PrintMemoCountLines( cTxt, nMaxLen )
    local nLineCount := 0
    local nOldPrintMemoLinePosX, nOldPrintMemoLinePosY, nOldPrintMemoLineCount
    // save old values - alte Inhalte speichern
    nOldPrintMemoLinePosX   :=  ::PrintMemoLinePosX
    nOldPrintMemoLinePosY   :=  ::PrintMemoLinePosY
    nOldPrintMemoLineCount  :=  ::PrintMemoLineCount
    ::IsPrintMemoCountLines := .t.
    ::PrintMemo( 1,1, cTxt,, nMaxLen ) // just calc
    nLineCount := ::PrintMemoLineCount
    ::PrintMemoLinePosX     :=  nOldPrintMemoLinePosX
    ::PrintMemoLinePosY     :=  nOldPrintMemoLinePosY
    ::PrintMemoLineCount    :=  nOldPrintMemoLineCount
    ::IsPrintMemoCountLines := .f.
return nLineCount
*-------------------------------------------------------------
METHOD _HBPrinter:PrintMemo( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, cHochQuer, nMaxBis,nLineFeed )
    local lSuccess := .t., nPos, lNeedNewPage, nDrehen, cOrgAusrichtung, lNeedBox := .f.
    local aPosTopLeft, aPosBottomRight, nOrgPosX, nOrgPosY, nTextOffsetOben, nTextOffsetUnten, aPoints

    DEFAULT cHochQuer to "H"
    DEFAULT nMaxLen  to 0  // maximale Zeilenbreite dieser Zeile - max lenght of this line
    DEFAULT cAusrichtung to "L"

    // wichtig fr Einzeilige Memofelder, needed for text with only one line, and box
    ::PrintMemoLinePosX := nOrgPosX := nPosX
    ::PrintMemoLinePosY := nOrgPosY := nPosY

    ::PrintMemoLineMaxLen := 0 // reset

    lNeedBox := .f.

    if ! empty(cArt)
       cArt := alltrim(upper(cArt))
       if cArt="B"         // BOX zeichnen
          lNeedBox := .t.
       endif
       cArt  := NIL        // fr PrintText() sperren
    endif

    lNeedNewPage := .f.
    ::PrintMemoLineCount := 1

    if left(cHochQuer,1) $ "QLH"
       cHochQuer := upper(left(cHochQuer,1))
    endif

    do case
       case cHochQuer == "H"
            nDrehen   := NIL     // Hochformat, Portrait  -> nicht drehen -> 0
            DEFAULT nMaxBis   to ::nBottomMargin
            if empty(nMaxLen)
               nMaxLen :=   ::nRightMargin - nPosX
            endif

       case cHochQuer == "Q" .or. cHochQuer == "L" .or. cHochQuer == "90"
            cHochQuer := "Q"
            nDrehen   := 90      // Querformat, Landscape -> 90 drehen
            DEFAULT nMaxBis   to ::nRightMargin
            if empty(nMaxLen)
               nMaxLen :=   nPosY - ::nTopMargin
            endif

       case cHochQuer == "180"
            nDrehen   := 180
            DEFAULT nMaxBis   to ::nTopMargin
            if empty(nMaxLen)
               nMaxLen :=   nPosX - ::nLeftMargin    /// ######### stimmt das ???
            endif

       case cHochQuer == "270"
            cHochQuer := "270"
            nDrehen   := 270
            DEFAULT nMaxBis   to ::nLeftMargin
            if empty(nMaxLen)
               nMaxLen :=   ::nBottomMargin - nPosY   /// ######### stimmt das ???
            endif

       otherwise

            nDrehen   := NIL     // Hochformat, Portrait  -> nicht drehen -> 0
            DEFAULT nMaxBis   to ::nBottomMargin
            if empty(nMaxLen)
               nMaxLen :=   ::nRightMargin - nPosX
            endif
            cTxt := "Fehler: cHochQuer='"+cHochQuer+"'"

    endcase

    cOrgAusrichtung := upper(left(cAusrichtung,1))        // sichern - save old value

    cTxt := NoSoftCR(cTxt)

    do while ! empty( cTxt )

       nPos := WordWrapAt(::oPS,nMaxLen,cTxt )            // nPos ist die gekrzte String lnge !

       if cOrgAusrichtung="B" .and. ( nPos >= len(cTxt) .or. substr(cTxt,nPos+1,1) $ CRLF )
          // niemals Blocksatz am Absatzende ! - Never format with B when only one line left.
          // der bergabeText kann mehrere Abstze enthalten - The MEMO can have multible paragraphs.
          cAusrichtung := "L"
       else
          cAusrichtung := cOrgAusrichtung
       endif

       if nPos > 0 .and. ! ::IsPrintMemoCountLines
          // wenn nur eine Leerzeile gedruckt werden soll, braucht man PrintText nicht aufrufen.
          lSuccess := lSuccess .and. ;
                   ::PrintText( nPosX, nPosY, left(cTxt,nPos), cAusrichtung, nMaxLen , cArt, nFarbe, nDrehen )
       endif

       if substr(cTxt,nPos+1) = " "    // Falls nach diesen String ein Blank kommt (Trennzeichen), lschen.
          nPos++
       endif

       cTxt := WordWrapCut(cTxt,nPos+1)

       if ! empty( cTxt )
          do case
             case ::IsPrintMemoCountLines
                  // no LineFeed()
             case cHochQuer == "H"
                  nPosY += ::LineFeed(1,nLineFeed)
                  if nPosY > nMaxBis
                     lNeedNewPage := .t.
                     nPosY := ::nFirstLine
                  endif
             case cHochQuer == "Q"
                  nPosX += ::LineFeed(1,nLineFeed)
                  if nPosX > nMaxBis
                     lNeedNewPage := .t.
                     nPosX := ::nLeftMargin
                  endif
             case cHochQuer == "180"
                  nPosY -= ::LineFeed(1,nLineFeed)
                  if nPosY < nMaxBis                   // ######### stimmt das ???
                     lNeedNewPage := .t.
                     nPosY := ::nFirstLine
                  endif
             case cHochQuer == "270"
                  nPosX -= ::LineFeed(1,nLineFeed)
                  if nPosX < nMaxBis                   // ######### stimmt das ???
                     lNeedNewPage := .t.
                     nPosX := ::nLeftMargin
                  endif
          endcase

          ::PrintMemoLineCount++

          if ! ::IsPrintMemoCountLines
             if lNeedNewPage
                ::NewPage()
                ::PrintForm()
                lNeedNewPage := .f.
                nPosY := ::nFirstLine  // WM 04.11.2015 , <Werner_Bayern>
             endif
             // Thanks to <Werner_Bayern>, set after NewPage ...
             ::PrintMemoLinePosX := nPosX
             ::PrintMemoLinePosY := nPosY
          endif

       endif
    enddo

    // BOX malen, wenn kein Seitenumbruch stattfand !
    if lNeedBox .and. ! lNeedNewPage

       /* Abstand Auenkante zu Druckpositon von Text
       aPoints := { { nXleft , nYtop    }, ;  // linke obere Ecke
                    { nXleft , nYbottom }, ;  // linke untere Ecke
                    { nXright, nYtop    }, ;  // rechte obere Ecke
                    { nXright, nYbottom }, ;  // rechte untere Ecke
                    { nXpen  , nYpen    }  }  // Pen-Position
       */
       aPoints          := GraQueryTextBox(::oPS, "Abj")
       nTextOffsetOben  := abs(max(aPoints[1,2],aPoints[3,2]))
       nTextOffsetUnten := abs(max(aPoints[2,2],aPoints[4,2]))

       aPosTopLeft      := ::PosHBtoXPP( nOrgPosX - ::PrintArtBoxOffsetX , ;
                                         nOrgPosY - nTextOffsetOben - ::PrintArtBoxOffsetY )

       aPosBottomRight  := ::PosHBtoXPP( nOrgPosX + ::PrintMemoLineMaxLen + ::PrintArtBoxOffsetX , ;
                                         ::PrintMemoLinePosY + nTextOffsetUnten + ::PrintArtBoxOffsetY )

       GraBox(::oPS, aPosTopLeft , aPosBottomRight )

    endif

return lSuccess
*-------------------------------------------------------------
METHOD _HBPrinter:PrintMemoPage( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, nFarbe, cHochQuer, nMaxBis,nLineFeed )
    local nPos, nDrehen, cOrgAusrichtung, lNeedBox := .f.
    local aPosTopLeft, aPosBottomRight, nOrgPosX, nOrgPosY, nTextOffsetOben, nTextOffsetUnten, aPoints

    DEFAULT cHochQuer to "H"
    DEFAULT nMaxLen  to 0  // maximale Zeilenbreite dieser Zeile - max lenght of this line
    DEFAULT cAusrichtung to "L"

    // wichtig fr Einzeilige Memofelder, needed for text with only one line
    ::PrintMemoLinePosX := nOrgPosX := nPosX
    ::PrintMemoLinePosY := nOrgPosY := nPosY

    ::PrintMemoLineMaxLen := 0 // reset

    lNeedBox := .f.

    if ! empty(cArt)
       cArt := alltrim(upper(cArt))
       if cArt="B"         // BOX zeichnen
          lNeedBox := .t.
       endif
       cArt  := NIL        // fr PrintText() sperren
    endif

    ::PrintMemoLineCount := 1

    if left(cHochQuer,1) $ "QLH"
       cHochQuer := upper(left(cHochQuer,1))
    endif

    do case
       case cHochQuer == "H"
            nDrehen   := NIL     // Hochformat, Portrait  -> nicht drehen -> 0
            DEFAULT nMaxBis   to ::nBottomMargin
            if empty(nMaxLen)
               nMaxLen :=   ::nRightMargin - nPosX
            endif

       case cHochQuer == "Q" .or. cHochQuer == "L" .or. cHochQuer == "90"
            cHochQuer := "Q"
            nDrehen   := 90      // Querformat, Landscape -> 90 drehen
            DEFAULT nMaxBis   to ::nRightMargin
            if empty(nMaxLen)
               nMaxLen :=   nPosY - ::nTopMargin
            endif

       case cHochQuer == "180"
            nDrehen   := 180
            DEFAULT nMaxBis   to ::nTopMargin
            if empty(nMaxLen)
               nMaxLen :=   nPosX - ::nLeftMargin    /// ######### stimmt das ???
            endif

       case cHochQuer == "270"
            cHochQuer := "270"
            nDrehen   := 270
            DEFAULT nMaxBis   to ::nLeftMargin
            if empty(nMaxLen)
               nMaxLen :=   ::nBottomMargin - nPosY   /// ######### stimmt das ???
            endif

       otherwise

            nDrehen   := NIL     // Hochformat, Portrait  -> nicht drehen -> 0
            DEFAULT nMaxBis   to ::nBottomMargin
            if empty(nMaxLen)
               nMaxLen :=   ::nRightMargin - nPosX
            endif
            cTxt := "Fehler: cHochQuer='"+cHochQuer+"'"

    endcase

    cOrgAusrichtung := upper(left(cAusrichtung,1))        // sichern - save old value

    cTxt := NoSoftCR(cTxt)

    do while ! empty( cTxt )

       nPos := WordWrapAt(::oPS,nMaxLen,cTxt )            // nPos ist die gekrzte String lnge !

       if cOrgAusrichtung="B" .and. ( nPos >= len(cTxt) .or. substr(cTxt,nPos+1,1) $ CRLF )
          // niemals Blocksatz am Absatzende ! - Never format with B when only one line left.
          // der bergabeText kann mehrere Abstze enthalten - The MEMO can have multible paragraphs.
          cAusrichtung := "L"
       else
          cAusrichtung := cOrgAusrichtung
       endif

       if nPos > 0  // wenn nur eine Leerzeile gedruckt werden soll, braucht man PrintText nicht aufrufen.
          ::PrintText( nPosX, nPosY, left(cTxt,nPos), cAusrichtung, nMaxLen , cArt, nFarbe, nDrehen )
       endif

       if substr(cTxt,nPos+1) = " "    // Falls nach diesen String ein Blank kommt (Trennzeichen), lschen.
          nPos++
       endif

       cTxt := WordWrapCut(cTxt,nPos+1)

       if ! empty( cTxt )
          do case
             case cHochQuer == "H"
                  nPosY += ::LineFeed(1,nLineFeed)
                  if nPosY > nMaxBis
                     exit
                  endif
             case cHochQuer == "Q"
                  nPosX += ::LineFeed(1,nLineFeed)
                  if nPosX > nMaxBis
                     exit
                  endif
             case cHochQuer == "180"
                  nPosY -= ::LineFeed(1,nLineFeed)
                  if nPosY < nMaxBis                   // ######### stimmt das ???
                     exit
                  endif
             case cHochQuer == "270"
                  nPosX -= ::LineFeed(1,nLineFeed)
                  if nPosX < nMaxBis                   // ######### stimmt das ???
                     exit
                  endif

          endcase
          ::PrintMemoLineCount++
          ::PrintMemoLinePosX := nPosX
          ::PrintMemoLinePosY := nPosY
       endif
    enddo

    // BOX malen
    if lNeedBox

       /* Abstand Auenkante zu Druckpositon von Text
       aPoints := { { nXleft , nYtop    }, ;  // linke obere Ecke
                    { nXleft , nYbottom }, ;  // linke untere Ecke
                    { nXright, nYtop    }, ;  // rechte obere Ecke
                    { nXright, nYbottom }, ;  // rechte untere Ecke
                    { nXpen  , nYpen    }  }  // Pen-Position
       */
       aPoints          := GraQueryTextBox(::oPS, "Abj")
       nTextOffsetOben  := abs(max(aPoints[1,2],aPoints[3,2]))
       nTextOffsetUnten := abs(max(aPoints[2,2],aPoints[4,2]))

       aPosTopLeft      := ::PosHBtoXPP( nOrgPosX - ::PrintArtBoxOffsetX , ;
                                         nOrgPosY - nTextOffsetOben - ::PrintArtBoxOffsetY )

       aPosBottomRight  := ::PosHBtoXPP( nOrgPosX + ::PrintMemoLineMaxLen + ::PrintArtBoxOffsetX , ;
                                         ::PrintMemoLinePosY + nTextOffsetUnten + ::PrintArtBoxOffsetY )

       GraBox(::oPS, aPosTopLeft , aPosBottomRight )

    endif


return cTxt
*-------------------------------------------------------------
METHOD _HBPrinter:PrintBarCodeEan13(nPosX, nPosY,uEAN13_Nr,nPerCent,lBox,cErrTxt,nRotate)
   local lSuccess,cbBarCodeEAN13, aPos

   aPos := ::PosHBtoXPP(nPosX, nPosY)                 // keine Anpassung - no change

   cbBarCodeEAN13 := &("{|oPS,aPos,nPerCent,uEAN13_Nr,lBox,cErrTxt,nRotate| "+;
                       "GraBarcodeEAN13(oPS,aPos,nPerCent,uEAN13_Nr,lBox,cErrTxt,nRotate)}")
                       // GraBarcodeEAN13() ist nicht immer da !
                       // GraBarcodeEAN13() ist additional

   if IsFunction("GraBarcodeEAN13")
      lSuccess := eval(cbBarCodeEAN13,::oPS,aPos,nPerCent,uEAN13_Nr,lBox,cErrTxt,nRotate)
   else
      lSuccess := .f.
      ::PrintText( nPosX, nPosY, "Function: GraBarcodeEAN13() is missing !" )
   endif
return lSuccess


*-------------------------------------------------------------
METHOD _HBPrinter:PrintText( nPosX, nPosY, xData, cAusrichtung, nMaxLen, cArt, nFarbe, nDrehen )
   local aPos, nTxtLen, lSuccess, aTextBox, nY, aAltColor, aAltAttr := NIL , aAttribNeu :=  {}
   local aBlockSatzWort,aNoBlank, nLenNoBlank, nBlockWordCount, x, nBlankOffset
   local aNewPenPos, cTxt, IsPrintTextAlltrim

   DEFAULT cAusrichtung to "L"                      // mgliche Werte      - possible values
   #define PrintTextAusrichtung  "LCZMRB"           // L = links - left    - adjustment
                                                    // C = center, Z=zentriert, M=mittig
                                                    // R = rechts - right
                                                    // B = Blocksatz - left and right
                                                    //   -> braucht nMaxLen fr Zeilenbreite zum Ausrichten oder ::nRightMargin
                                                    //   -> needs   nMaxLen for width of line to adjust or       ::nRightMargin
   DEFAULT cArt         to " "                      // mgliche Werte      - possible values
                                                    // B = BOX um Text     - box around the text
                                                    // U = unterstreichen  - underline
                                                    // _ =   "                 "
                                                    // - = durchgestrichen - strike through
   * nFarbe                                         // -> GRA_CLR_... -> GraSetColor()
   if ! IsNil(nMaxLen)                              // hufiger Fehler Parameter nMaxLen wird vergessen
      if ValType(nMaxLen) = "C"                     // nMaxLen used, but want cArt -> parameter mismatch
         cArt := nMaxLen                            // nMaxLen = maximale lnge der Druckausgabe
         nMaxLen := NIL                             //           only print nMaxLen length output
      endif
   endif

   do case
      case IsNil(nPosX) .or. IsNil(nPosY)           // ::PrintTextAlltrim sollte .f. gesetzt werden, bevor man automatisch Positionieren will !
           IsPrintTextAlltrim := .f.
      case cAusrichtung == "L"
           IsPrintTextAlltrim := ::PrintTextAlltrim
      otherwise
           IsPrintTextAlltrim := .t.
   end

   do case
      case empty(xData)
           cTxt := ""
      case ValType(xData)="D"
           cTxt := dtoc(xData)
      case ValType(xData)="N"
           cTxt := alltrim(str(xData))
      case ValType(xData)="L"
           cTxt := iif( xData , ::cTextYes , ::cTextNo )
      case ValType(xData) $ "CM"
           if IsPrintTextAlltrim
              cTxt := alltrim(xData)
           else
              cTxt := xData
           endif
      otherwise
           cTxt := alltrim(var2char(xData))
   end

   if ! IsNil(nDrehen)
      aadd(aAttribNeu, { GRA_AS_ANGLE , HbGradToXppArray(nDrehen,100) } )
   endif
   if ! IsNil(nFarbe)
      aAltColor := GraSetColor(::oPS,nFarbe)        // So nur den Fordergrund bestimmen - only foreground color
   endif

   if ! Empty( aAttribNeu )
      aAltAttr   := ::SetAttrString( aAttribNeu )
   endif

   lSuccess     := .t.

   cAusrichtung := upper(left(cAusrichtung,1))
   if ! cAusrichtung $ PrintTextAusrichtung         // mgliche Werte      - possible values
      cAusrichtung := "L"
      cArt         := "-"                           // Fehler markieren    - mark the text as error
   endif
   cArt         := upper(left(cArt,1))

   if ::IsPageToPrint()

      aTextBox  := GraQueryTextBox(::oPS, cTxt)
      nTxtLen   := GetTxtLen(aTextBox, nDrehen)

      if ! IsNil(nMaxLen)

         do while .t.                      // nMaxLen beachten !
            if nTxtLen > nMaxLen .and. ! empty(cTxt)
               cTxt := left(cTxt, len(cTxt)-1 )
               aTextBox := GraQueryTextBox(::oPS,cTxt)
               nTxtLen  := GetTxtLen(aTextBox, nDrehen)
            else
               exit
            endif
         enddo
      endif

      do case
         case IsNil(nPosX) .or. IsNil(nPosY)              // an aktueller Position ausgeben - use pen position for next output
              aPos := GraPos(::oPS)
         case cAusrichtung = "L" .or. empty(cTxt)         // links, left  oder emty(cTxt)
              aPos := ::PosHBtoXPP(nPosX, nPosY)                 // keine Anpassung - no change
         case cAusrichtung $ "CZM"                        // zentrieren, mittig, center
              do case
                 case nDrehen = 0 .or. nDrehen = 180
                    aPos := ::PosHBtoXPP(nPosX-nTxtLen/2, nPosY)     // rechts - right
                 case nDrehen = 90 .or. nDrehen = 270
                    aPos := ::PosHBtoXPP(nPosX, nPosY+nTxtLen/2)     // rechts - right
                 otherwise                                           // noch nicht richtig !
                                                                     // not correct yet.
                 aPos := ::PosHBtoXPP(nPosX-nTxtLen/2, nPosY)        // zentrieren      - center
              end case
         case cAusrichtung = "R"                          // rechts, right
              do case
                 case nDrehen = 0 .or. nDrehen = 180
                    aPos := ::PosHBtoXPP(nPosX-nTxtLen, nPosY)       // rechts - right
                 case nDrehen = 90 .or. nDrehen = 270
                    aPos := ::PosHBtoXPP(nPosX, nPosY+nTxtLen)       // rechts - right
                 otherwise                                           // noch nicht richtig !
                                                                     // not correct yet.
                    aPos := ::PosHBtoXPP(nPosX-nTxtLen, nPosY)       // rechts - right
              end case
         case cAusrichtung = "B"                          // Blocksatz, left and right
              if IsNil(nMaxLen)
                 nMaxLen := ::nRightMargin - nPosX
              endif
              // 1.    Textlnge ohne Blanks - without blanks
              aNoBlank    := GraQueryTextBox(::oPS, strtran(cTxt," ","") )
              nLenNoBlank := aNoBlank[3,1] - aNoBlank[2,1]
              // 2.    nMaxLen   soll nachher erreicht werden - the string should be so width.
              // 3.    Worte suchen und merken  -  search and store all words.
              aBlockSatzWort := {}
              do while "  " $ cTxt
                 cTxt := strtran(cTxt,"  ", " ")
              enddo
              do while ! empty(cTxt)                // alle Worte merken, store all words.
                 x := at(" ",cTxt)
                 if X > 0
                    aadd(aBlockSatzWort,left(cTxt,x-1) )
                    cTxt := substr(cTxt,x+1)
                 else
                    aadd(aBlockSatzWort,cTxt )
                    cTxt := ""
                 endif
              enddo
              nBlockWordCount := len(aBlockSatzWort)
              // Breite eines Blanks = ( nMaxLen - Textlnge ohne Blanks ) / (Wortanzahl -1)
              // width of a blank    = ( nMaxLen - textlength without blanks) / (word count - 1)
              nBlankOffset := ( nMaxLen - nLenNoBlank ) / (nBlockWordCount - 1)
              lSuccess     := .t.
              // 4.    Wort fr Wort ausgeben - print each word
              for x := 1 to len(aBlockSatzWort)
                  if x = 1
                     aPos := ::PosHBtoXPP(nPosX, nPosY)                 // keine Anpassung - no change
                  else
                     aPos := { GraPos(::oPS)[1] + nBlankOffset, GraPos(::oPS)[2] }
                  endif
                  lSuccess := lSuccess  .and. GraStringAt(::oPS, aPos, aBlockSatzWort[x])
              next

      endcase

      // fr MemoPrint die tatschliche Druckzeilenbreite merken
      //
      if cAusrichtung = "B" // Blocksatz, left and right
         ::PrintMemoLineMaxLen := nMaxLen
      else
         ::PrintMemoLineMaxLen := max( ::PrintMemoLineMaxLen , nTxtLen )
      endif

      if cAusrichtung $ "LCZMR"         // cTxt ausgeben - print cTxt
         if IsPrintTextAlltrim          // wird auch von automatischer Positionierung bentigt.
            lSuccess   := GraStringAt(::oPS, aPos, cTxt+" " )
         else
            lSuccess   := GraStringAt(::oPS, aPos, cTxt )
         endif
      endif

      aNewPenPos := GraPos(::oPS)

      do case
         case empty(cArt)
              * keine Hervorhebungen - nothing to do
         case cArt = "B"
              GraBox(::oPS,{aPos[1]-::PrintArtBoxOffsetX,aPos[2]-abs(aTextBox[2,2])-::PrintArtBoxOffsetY },;
                           {aPos[1]+nTxtLen+::PrintArtBoxOffsetX,aPos[2]+aTextBox[3,2]+::PrintArtBoxOffsetY })
         case cArt $ "U_"
              nY := int(max( abs(aTextBox[2,2]) , abs(aTextBox[4,2]) ) / 3 * 2 )
              GraLine(::oPS,{aPos[1],aPos[2]-nY},{aPos[1]+nTxtLen,aPos[2]-nY})
         case cArt = "-"
              nY := int(max( abs(aTextBox[1,2]) , abs(aTextBox[3,2]) ) / 3 )
              GraLine(::oPS,{aPos[1],aPos[2]+nY},{aPos[1]+nTxtLen,aPos[2]+nY})
      endcase
      // die Pen-Position wurde hier aus dem alten Wert aTextBox[5] genommen
      // wrong setting of the pen-position to old value aTextBox[5]
      GraPos(::oPS, aNewPenPos )       // zurck zu neuer Textposition              - back to new text position

   endif

   if ! IsNil(aAltAttr)
      GraSetAttrString(::oPS,aAltAttr )
   endif

   if ! IsNil(nFarbe)
      GraSetColor(::oPS,aAltColor[1],aAltColor[2])        // zurcksetzen - set old value
   endif

return lSuccess

*-------------------------------------------------------------
METHOD _HBPrinter:say(nRow,nCol,xData,cAusrichtung,nCPI,nLPI) // -> @nRow,nCol SAY ...
   local cTxt,nPosX,nPosY, uReturn, lAltPrintTextAlltrim
   if IsNil(nCPI) .or. nCPI < 10
      nCPI := 10     // normal 10, 12, 16
   endif
   if IsNil(nLPI) .or. nLPI < 1
      nLPI :=  6     // normal 6 or 8
   endif
   nPosY := nRow * (254/nLPI)  // 2.54 cm -> 1/10 mm => 254 // +1 wegen Unterkante
   if cAusrichtung == "R"
      nPosX :=  nCol * (254/nCPI)  // 2.54 cm -> 1/10 mm => 254 // rechts vom Zeichen.
   else
      nPosX := (nCol-1) * (254/nCPI)  // 2.54 cm -> 1/10 mm => 254 // links vom Zeichen.
   endif

   do case
      case IsNil(xData)
           cTxt := "NIL"
      case ValType(xData) $ "CM"
           cTxt := xData
      case ValType(xData) $ "N"  // BESSER MIT TRANSFORM() // better use Transform()
           cTxt := alltrim(str(xData))
      case ValType(xData) $ "L"
           cTxt := iif(xData," Ja ","Nein")
      otherwise
           cTxt := Var2Char(xData)
   endcase
   lAltPrintTextAlltrim := ::PrintTextAlltrim
   ::PrintTextAlltrim   := .f.   // Blanks mitdrucken !
   uReturn := ::PrintText( nPosX, nPosY,cTxt, cAusrichtung)
   ::PrintTextAlltrim   :=  lAltPrintTextAlltrim
return uReturn
*-------------------------------------------------------------

METHOD _HBPrinter:GetTextLen(cTxt)      // ermittelt die Lnge (Breite) eines Strings im aktuellen Font
                                        // gives back the length (width) of a string with the active font
   local aSize,nLen
   aSize := GraQueryTextBox(::oPS, cTxt )
   nLen  := aSize[3,1] - aSize[2,1]

Return nLen
*-------------------------------------------------------------
METHOD _HBPrinter:PrintArc( nLeftX, nTopY, nRadius, aEllipse,nStartAngle,nSweepAngle,nFill )
    local lSuccess := .t.
    if ::IsPageToPrint()
       lSuccess := GraArc( ::oPS,::PosHBtoXPP(nLeftX,nTopY),nRadius, aEllipse,nStartAngle,nSweepAngle,nFill )
    endif
return lSuccess
*-------------------------------------------------------------
METHOD _HBPrinter:PrintSpline( aPointsHB, lPenPos )
    local aPointsXpp := {} , lSuccess := .t.
    if ::IsPageToPrint()
       aeval(aPointsHB,{|a2PointsHB| aadd(aPointsXpp,::PosHBtoXPP(a2PointsHB[1],a2PointsHB[2])) } )
       lSuccess := GraSpline( ::oPS, aPointsXpp, lPenPos )
    endif
return lSuccess
*-------------------------------------------------------------
METHOD _HBPrinter:PrintBox(nLeftX,nTopY,nSizeX, nSizeY,cRelativAbsolut,nFill, nHRadius, nVRadius)
    local lSuccess := .t.
    if ::IsPageToPrint()
       DEFAULT cRelativAbsolut to "R"  // Relativ: nSizeX and nSizeY are the length and width relative to
                                       //          nLeftX and nTopY
                                       // Absolut: Just the right, bottom Values as used in GraBox
                                       // nFill, nHRadius, nVRadius -> in Onlinehilfe nachsehen - look in Manual for GraBox

       cRelativAbsolut := upper(left(cRelativAbsolut,1))

       if cRelativAbsolut = "R"
          nSizeX += nLeftX
          nSizeY += nTopY
       endif

       lSuccess := GraBox( ::oPS,::PosHBtoXPP(nLeftX,nTopY),::PosHBtoXPP(nSizeX,nSizeY),nFill,nHRadius,nVRadius)
    endif
return lSuccess
*-------------------------------------------------------------
METHOD _HBPrinter:PrintMarker(nPos1X,nPos1Y)
    local lSuccess := .t.
    if ::IsPageToPrint()
       if IsNil(nPos1X) .or. IsNil(nPos1Y)
          lSuccess := GraMarker( ::oPS )
       else
          lSuccess := GraMarker( ::oPS,::PosHBtoXPP(nPos1X,nPos1Y) )
       endif
    endif
return lSuccess
*-------------------------------------------------------------
METHOD _HBPrinter:PrintLine(nPos1X,nPos1Y,nPos2X,nPos2Y)
    local lSuccess := .t.
    if ::IsPageToPrint()
       lSuccess := GraLine( ::oPS,::PosHBtoXPP(nPos1X,nPos1Y),::PosHBtoXPP(nPos2X, nPos2Y) )
                   GraLine( ::oPS,::PosHBtoXPP(nPos1X,nPos1Y-1),::PosHBtoXPP(nPos2X, nPos2Y-1) )  // VER 1.02
                   GraLine( ::oPS,::PosHBtoXPP(nPos1X,nPos1Y+1),::PosHBtoXPP(nPos2X, nPos2Y+1) )  // VER 1.02
    endif          // Linien sind zu dnn gezeichnet, lines have been to thin !
return lSuccess
*-------------------------------------------------------------
METHOD _HBPrinter:MoveTo(nX,nY)
    local aPos

    do case
       case IsNil(nX) .and. IsNil(nY)
            aPos := NIL
       case IsNil(nX)
            aPos := { GraPos(::oPS)[1] , ::PosHBtoXPP(1,nY)[2] }
       case IsNil(nY)
            aPos := { ::PosHBtoXPP(nX,1)[1],GraPos(::oPS)[2] }
       otherwise
            aPos := ::PosHBtoXPP(nX,nY)
    end case

return GraPos( ::oPS,aPos )
*-------------------------------------------------------------
METHOD _HBPrinter:GetPos()
return GraPos(::oPS)
*-------------------------------------------------------------
METHOD _HBPrinter:PosHBtoXPP(nHBX, nHBY)
   local nXppX, nXppY

   nXppX := nHBX                                   // und umrechnen oben links 0,0 change to left top
   nXppY := ::nPaperSizeY - nHBY

   if ! ::PreviewDrawIsActive                      // beim Drucken  -  only when printing
      nXppX -= ::nLeftMarginDC                     // Hardwarerand abziehen - none printable device margin
      nXppY -= ::nBottomMarginDC                   // Hardwarerand abziehen - none printable device margin
   endif

return { nXppX, nXppY }

*-------------------------------------------------------------
METHOD _HBPrinter:DevName
    local uReturn := ""
    if ! ::_PrinterCreateErr
       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():devName
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():devName
          endif
       endif
    endif
    if ::PreviewDrawIsActive .and. empty(uReturn)
       uReturn := ::cPreViewPrinter
    endif
return uReturn
*-------------------------------------------------------------
METHOD _HBPrinter:PrinterList() // => XbpPrinter():list()
    local aList := NIL, oXbp := nil
    if ! ::_PrinterCreateErr
       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          aList := ::oPS:device():list()
       endif
       if aList = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             aList := ::oPrinterPS:device():list()
          endif
       endif
    endif
    if ::PreviewDrawIsActive .and. empty(aList)
       oXbp := XbpPrinter():new()
       if oXbp # NIL
          aList := oXbp:list()
          oXbp:destroy()
       endif
    endif
return aList
*-------------------------------------------------------------
METHOD _HBPrinter:GetDefaultPrinter()
    local oP := NIL, cdevName := ""
    oP := XbpPrinter():new():create()
    if oP # NIL
       cdevName := oP:devName
    endif
return cdevName
*-------------------------------------------------------------
METHOD _HBPrinter:StartDoc(cText,nSetPageNo)
    local cAltDrive, cAltDir, cResetDir
    local uReturn := SELF
    DEFAULT cText TO ::SpoolJobName
    DEFAULT nSetPageNo TO 1
    cAltDrive := curdrive()
    cAltDir   := curdir()
    ::nPageNo := nSetPageNo
    ::_IsOpenStartDoc := .t.
    ::_cPrinterShowText := cText
    if IsMethod(::oPS:device(),"StartDoc")
       uReturn := ::oPS:device():StartDoc(cText)
    endif
    if cAltDrive # curdrive() .or. cAltDir # curdir()
       cResetDir := cAltDrive +":\"+ cAltDir
       curdrive(cAltDrive)
       curdir(cResetDir)
    endif
return uReturn
*-------------------------------------------------------------
METHOD _HBPrinter:EndDoc()
    local uReturn := SELF
    ::_IsOpenStartDoc := .f.
    if IsMethod(::oPS:device(),"EndDoc")
       uReturn := ::oPS:device():EndDoc()
    endif
return uReturn
*-------------------------------------------------------------
METHOD _HBPrinter:NewPage()
    local uReturn := SELF
    if IsMethod(::oPS:device(),"NewPage")
       if ::IsPageToPrint() .and. ! ::IsThisLastPage() // kein Vorschub bei letzter Seite, wegen
          uReturn := ::oPS:device():NewPage()          // no NewPage an last page, because of
       endif                                           // enddoc()
    endif
    ::nPageNo++
return uReturn
*-------------------------------------------------------------
METHOD _HBPrinter:oPS( oPS )
   if valtype(oPS) = "O"
      ::_oPS := oPS
      if oPS:device():isDerivedFrom( "XbpPrinter" )
         ::oPrinterPS := oPS
      endif
   endif
return  ::_oPS
*-------------------------------------------------------------
METHOD _HBPrinter:SpoolJobName(cSpoolJobName)
   static cAktivSpoolJobName := NIL
   do case
      case ! IsNil(cSpoolJobName)   // Setzen !
           cAktivSpoolJobName := cSpoolJobName
           if ::_oPS:device():isDerivedFrom( "XbpPrinter" ) .and. ;
              IsMemberVar( ::_oPS:device(), "SpoolJobName" )
              ::_oPS:device():SpoolJobName := cSpoolJobName
           endif
      case IsNil(cAktivSpoolJobName)
           cAktivSpoolJobName := "HB-Printer"
           if ::_oPS:device():isDerivedFrom( "XbpPrinter" ) .and. ;
              IsMemberVar( ::_oPS:device(), "SpoolJobName" )
              ::_oPS:device():SpoolJobName := cSpoolJobName
           endif
      otherwise
           if ::_oPS:device():isDerivedFrom( "XbpPrinter" ) .and. ;
              IsMemberVar( ::_oPS:device(), "SpoolJobName" )
              cSpoolJobName := ::_oPS:device():SpoolJobName
           endif
   endcase
return cAktivSpoolJobName
*-------------------------------------------------------------
METHOD _HBPrinter:Clear_oPS()
   if ! IsNil(::_oPS)
      ::_oPS := NIL
   endif
return  NIL
*-------------------------------------------------------------
METHOD _HBPrinter:SetFont(uFont)
   local oFont := NIL, uReturn
   do case
      case valtype(uFont) = "N" .and. ! Empty(::aFontList) .and. uFont <= len(::aFontList)
           oFont := ::aFontList[uFont]
      case valtype(uFont) = "O"
           oFont := uFont
   end case

   If IsNil(oFont)
      uReturn := ::oPS:SetFont()
   else
      uReturn := ::oPS:SetFont(oFont)
#ifdef __OS2__
   PDR734( ::oPS, oFont )
#endif

      do case
         case oFont:nominalPointSize <= 14
              ::nLineFeed := round((oFont:nominalPointSize + 1.95)*2.54*100/72,0)
         case oFont:nominalPointSize  = 15
              ::nLineFeed := round((oFont:nominalPointSize + 2.05)*2.54*100/72,0)
         case oFont:nominalPointSize  = 16
              ::nLineFeed := round((oFont:nominalPointSize + 2.25)*2.54*100/72,0)
         case oFont:nominalPointSize <= 17
              ::nLineFeed := round((oFont:nominalPointSize + 2.45)*2.54*100/72,0)
         case oFont:nominalPointSize <= 19
              ::nLineFeed := round((oFont:nominalPointSize + 2.65)*2.54*100/72,0)
         case oFont:nominalPointSize <= 21
              ::nLineFeed := round((oFont:nominalPointSize + 2.85)*2.54*100/72,0)
         case oFont:nominalPointSize <= 22
              ::nLineFeed := round((oFont:nominalPointSize + 3.25)*2.54*100/72,0)
         case oFont:nominalPointSize <= 24
              ::nLineFeed := round((oFont:nominalPointSize + 3.45)*2.54*100/72,0)
         case oFont:nominalPointSize <= 25
              ::nLineFeed := round((oFont:nominalPointSize + 3.60)*2.54*100/72,0)
         case oFont:nominalPointSize <= 27
              ::nLineFeed := round((oFont:nominalPointSize + 3.80)*2.54*100/72,0)
         case oFont:nominalPointSize <= 28
              ::nLineFeed := round((oFont:nominalPointSize + 4.20)*2.54*100/72,0)
         case oFont:nominalPointSize <= 30
              ::nLineFeed := round((oFont:nominalPointSize + 4.40)*2.54*100/72,0)
         case oFont:nominalPointSize <= 32
              ::nLineFeed := round((oFont:nominalPointSize + 4.55)*2.54*100/72,0)
         case oFont:nominalPointSize <= 33
              ::nLineFeed := round((oFont:nominalPointSize + 4.75)*2.54*100/72,0)
         case oFont:nominalPointSize <= 34
              ::nLineFeed := round((oFont:nominalPointSize + 4.95)*2.54*100/72,0)
         case oFont:nominalPointSize <= 35
              ::nLineFeed := round((oFont:nominalPointSize + 5.15)*2.54*100/72,0)
         case oFont:nominalPointSize <= 36
              ::nLineFeed := round((oFont:nominalPointSize + 5.35)*2.54*100/72,0)
         otherwise
              ::nLineFeed := round((oFont:nominalPointSize*1.148)*2.54*100/72,0)

      endcase

   endif

return uReturn
*-------------------------------------------------------------
METHOD _HBPrinter:AddFont(uFont)
   local oFont := NIL
#ifdef __OS2__
   local nFontPointSize, cFontName
#endif
   do case
      case valtype(uFont) = "C"
#ifdef __WIN32__
           oFont := XbpFont():new(::oPS):create(uFont)
#endif
#ifdef __OS2__
           if "." $ uFont                // Immer auf der sichern Seite - keep it secure
              nFontPointSize := int(val(uFont))
              cFontName      := alltrim(substr(uFont,at(".",uFont)+1))
           else
              nFontPointSize := 12
              cFontName      := alltrim(uFont)
           endif
           oFont := FontWahl( cFontName, nFontPointSize )
   PDR734( ::oPS, oFont )
#endif
      case valtype(uFont) = "O"
           oFont := uFont
      case valtype(uFont) = "A"
           do while len(uFont) < 4
              aadd(uFont, NIL )
           enddo
           oFont := FontWahl( uFont[1],  uFont[2], uFont[3],uFont[4], ::oPS )
                 // FontWahl( cFontName, nFontHoehe, lBold, lItalic)
   end case

   aadd(::aFontList,oFont)

return self
*-------------------------------------------------------------
METHOD _HBPrinter:SetAttrMarker( aAttribNeu )
   local aAttrib, aAttribAlt
   aAttrib := Array( GRA_AM_COUNT )
   aeval(aAttribNeu,{|aAttNeuWert| aAttrib[(aAttNeuWert[1])] := (aAttNeuWert[2]) } )
   aAttribAlt := GraSetAttrMarker( ::oPS, aAttrib )
return aAttribAlt
*-------------------------------------------------------------
METHOD _HBPrinter:SetAttrLine( aAttribNeu )
   local aAttrib, aAttribAlt
   aAttrib := Array( GRA_AL_COUNT )
   aeval(aAttribNeu,{|aAttNeuWert| aAttrib[(aAttNeuWert[1])] := (aAttNeuWert[2]) } )
   aAttribAlt := GraSetAttrLine( ::oPS, aAttrib )
return aAttribAlt
*-------------------------------------------------------------
METHOD _HBPrinter:SetAttrArea( aAttribNeu )
   local aAttrib, aAttribAlt
   aAttrib := Array( GRA_AA_COUNT )
   aeval(aAttribNeu,{|aAttNeuWert| aAttrib[(aAttNeuWert[1])] := (aAttNeuWert[2]) } )
   aAttribAlt := GraSetAttrArea( ::oPS, aAttrib )
return aAttribAlt
*-------------------------------------------------------------
METHOD _HBPrinter:SetAttrString( aAttribNeu )
   local aAttrib, aAttribAlt
   aAttrib := Array( GRA_AS_COUNT )
   aeval(aAttribNeu,{|aAttNeuWert| aAttrib[aAttNeuWert[1]] := aAttNeuWert[2] } )
   aAttribAlt := GraSetAttrString( ::oPS, aAttrib )
return aAttribAlt
*-------------------------------------------------------------
METHOD _HBPrinter:ReSetAttrMarker( aAttribAlt )                 // VER 1.02
return GraSetAttrMarker( ::oPS, aAttribAlt )
*-------------------------------------------------------------
METHOD _HBPrinter:ReSetAttrLine( aAttribAlt )                   // VER 1.02
return GraSetAttrLine( ::oPS, aAttribAlt )
*-------------------------------------------------------------
METHOD _HBPrinter:ReSetAttrArea( aAttribAlt )                   // VER 1.02
return GraSetAttrArea( ::oPS, aAttribAlt )
*-------------------------------------------------------------
METHOD _HBPrinter:ReSetAttrString( aAttribAlt )                 // VER 1.02
return GraSetAttrString( ::oPS, aAttribAlt )

*-------------------------------------------------------------
METHOD _HBPrinter:SetColor(nForeground, nBackground)
return ::oPS:SetColor(nForeground, nBackground)
*-------------------------------------------------------------
METHOD _HBPrinter:SetLeftMargin(nHB_Pos)
    local nReturn
    nReturn := ::nLeftMargin
    if ! IsNil(nHB_Pos)
       ::nLeftMargin := nHB_Pos
    endif
return nReturn
*-------------------------------------------------------------
METHOD _HBPrinter:SetTopMargin(nHB_Pos)
    local nReturn
    nReturn := ::nTopMargin
    if ! IsNil(nHB_Pos)
       ::nTopMargin := nHB_Pos
    endif
return nReturn
*-------------------------------------------------------------
METHOD _HBPrinter:SetBottomMargin(nHB_Pos)
    local nReturn
    nReturn := ::nBottomMargin
    if ! IsNil(nHB_Pos)
       ::nBottomMargin := nHB_Pos
    endif
return nReturn
*-------------------------------------------------------------
METHOD _HBPrinter:SetRightMargin(nHB_Pos)
    local nReturn
    nReturn := ::nRightMargin
    if ! IsNil(nHB_Pos)
       ::nRightMargin := nHB_Pos
    endif
return nReturn
*-------------------------------------------------------------
METHOD _HBPrinter:PrinterPS(cPrinterName)
    LOCAL oPS, oDC, nBreite,nHoehe,aPaperSize, IsPrinterVorgabe

    IsPrinterVorgabe := .f.

    if IsNil(::oPrinterPS)              // erster Aufruf - first Time
       if IsNil(::oUseXbpPrinter)       // keine Vorgabe - no preselection
          oPS := XbpPresSpace():New()
          oDC := XbpPrinter():New()
       else
          oPS := XbpPresSpace():New()
          oDC := ::oUseXbpPrinter
          IsPrinterVorgabe := .t.
       endif
    else

       oPS := ::oPrinterPS
       oDC := oPS:device()
       oPS:configure()                  // oDC freigeben - release oDC
       if IsNil(oDC)
          oDC := XbpPrinter():New()
       endif
       if oDC:Status() = XBP_STAT_CREATE  // dann zurcksetzen
          oDC:destroy()
       endif
       if oPS:Status() = XBP_STAT_CREATE  // dann zurcksetzen
          oPS:destroy()
       endif
    endif

    if ! IsPrinterVorgabe
       * Nun haben wir leere Objecte
       oDC:Create(cPrinterName)
       ::oUseXbpPrinter := oDC
    endif

    if IsNil(oDC) .or. oDC:Status() = XBP_STAT_FAILURE
       ::_PrinterCreateErr := .t.
    else
       ::_PrinterCreateErr := .f.
    endif

    if ! ::_PrinterCreateErr

       aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
       nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
       nHoehe  := aPaperSize[6] - aPaperSize[4]
       oPS:Create( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )

       ::SetInternalPageVars(oPS)

    endif

RETURN oPS
*-------------------------------------------------------------------
METHOD _HBPrinter:DestroyPS( oPS )
    LOCAL oDC := oPS:device()
    IF oDC <> NIL
       oPS:configure()
       if oDC:Status() = XBP_STAT_CREATE
          oDC:destroy()
       endif
       if oPS:Status() = XBP_STAT_CREATE
          oPS:destroy()
       endif
    ENDIF
RETURN SELF
*-------------------------------------------------------------------
METHOD _HBPrinter:IsSpaceOnPage(nPrintPosY,nLines,nBottomMargin)
                        // - .t. falls die gewnschte Anzahl auf Seite pat
                        // - .t. if nLines can be printed on this page
   local lIsSpaceOnPageFornLines

   DEFAULT nLines TO 0
   DEFAULT nBottomMargin TO ::nBottomMargin

   if nPrintPosY + 10 + ::LineFeed(nLines) > nBottomMargin   // 1 mm Mindesabstand von unten
      * kein Platz mehr auf Seite - the lines will not fit on page
      lIsSpaceOnPageFornLines := .f.
   else
      lIsSpaceOnPageFornLines := .t.
   endif

return lIsSpaceOnPageFornLines

*-------------------------------------------------------------------
METHOD _HBPrinter:PrintBmp(nX,nY,nXSize,nYSize,cFileName,nID)
   local oBitmap,lSuccess:=.t.,aPos1:={}, lIsLoaded := .f.
   // infos zum Drehen ???
   /*
      Drehen mit linke obere und rechte untere Ecke vertauscht ????
   */
   // nx=xKoordinate, ny=yKoordinate, cFileName
   // nXSize=Breite in X, nYSize=Hhe in Y
   aPos1 := ::PosHBtoXPP(nX,nY)
   oBitmap := XbpBitmap():new():create( ::oPS )

   if IsNil(nID)    // Dateiname der Bitmap wurde bergeben
      lIsLoaded := oBitmap:loadFile( cFileName )
   else             // Resource wurde angegeben, benutzen  HB
      lIsLoaded := oBitmap:load( cFileName , nID )   // hier kann cFileName fr DLL verwendet werden
   endif

   if lIsLoaded
      if ::IsPageToPrint()
         *
         * ein Parameter NIL, der andere nicht dann proportional vergrern
         * Rechtsbndig drucken
         * drehen ... ########################
         DEFAULT nXSize TO oBitmap:xSize
         DEFAULT nYSize TO oBitmap:ySize
         lSuccess:= oBitmap:draw( ::oPS, {aPos1[1],aPos1[2],aPos1[1]+nXSIZE,aPos1[2]+nySize} )
      endif
   else
      lSuccess := .f.
      if ::IsPageToPrint()
         GraStringAT(::oPS, {aPos1[1],aPos1[2]},"Kein Bild")
      endif
   endif
return lSuccess

*-------------------------------------------------------------------
METHOD _HBPrinter:SetInternalPageVars(oPS)    // after Create, PrinterPS, configure, SetPaperBin ...
   DEFAULT oPS TO ::oPS
   if ! ::_PrinterCreateErr
      ::nPaperSizeX         := oPS:device():PaperSize()[1]
      ::nPaperSizeY         := oPS:device():PaperSize()[2]
      ::nLeftMarginDC       := oPS:device():PaperSize()[3]
      ::nBottomMarginDC     := oPS:device():PaperSize()[4]
      ::nRightMarginDC      := oPS:device():PaperSize()[5]
      ::nTopMarginDC        := oPS:device():PaperSize()[6]
   endif
return nil


********************** Methods available depends on Xpp version ************************

#if XPPVER > 170              // Falls etwas schon frher mglich war, bitte mitteilen
                              // please tell me, if one of those was early evalable


    *-------------------------------------------------------------
    // von / from <Werner_Bayern> - Thanks.
    METHOD _HBPrinter:abort()

       local uReturn := NIL
       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():abort()
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():abort()
          endif
       endif

    return uReturn

    *-------------------------------------------------------------
    METHOD _HBPrinter:comment
       local uReturn := NIL

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():comment
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():comment
          endif
       endif
    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:devPort
       local uReturn := NIL

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():devPort
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():devPort
          endif
       endif
    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:location
       local uReturn := NIL

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():location
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():location
          endif
       endif
    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:getHDC()
       local uReturn := NIL

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():getHDC()
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():getHDC()
          endif
       endif
    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:forms()
       local uReturn := NIL

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():forms()
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():forms()
          endif
       endif
    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:paperBins()
       local uReturn := NIL

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():paperBins()
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():paperBins()
          endif
       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:printerStatus()
       local uReturn := NIL, oDC

       oDC := ::oPS:device()
       DEFAULT oDC TO ::oPrinterPS:device()   // if ::oPS:device() = NIL

       do case
          case ::_PrinterCreateErr
               uReturn := XBPPRN_STATUS_NA
          case IsNil(oDC)
               uReturn := XBPPRN_STATUS_NA
          case oDC:isDerivedFrom( "XbpPrinter" )
               uReturn := ::oPS:device():printerStatus()
       endcase

       if IsNil(uReturn)  // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():printerStatus()
          endif
       endif

       if IsNil(uReturn)  // last chance
          uReturn := XBPPRN_STATUS_NA
       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:resolutions()
       local uReturn := NIL

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          uReturn := ::oPS:device():resolutions()
       endif

       if uReturn = NIL    // zur Zeit PreviewPS kein Drucker angeschlossen ! - PreviewPS is active
          if ::oPrinterPS:isDerivedFrom( "XbpPrinter" )
             uReturn := ::oPrinterPS:device():resolutions()
          endif
       endif
    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setCollationMode( nMode )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setCollationMode( nMode )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif

       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setColorMode( nMode )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setColorMode( nMode )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif

       endif
    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setDuplexMode( nMode )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setDuplexMode( nMode )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif

       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setFontMode( nMode )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setFontMode( nMode )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif

       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setFormSize( nFormID )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setFormSize( nFormID )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif

       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setNumCopies( nNumCopies )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setNumCopies( nNumCopies )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif

       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setOrientation( nOrientation )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setOrientation( nOrientation )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif

       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setPaperBin( nBin )            // dieses Papier knnte andere Gre haben !
                                                     // this bin could have different pagesize !
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ! IsNil(::oPS:device()) .and. ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setPaperBin( nBin )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif
       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setPrintFile( cFileName )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setPrintFile( cFileName )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif
       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setResolution( aResolution )
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setResolution( aResolution )
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif
       endif

    return uReturn
    *-------------------------------------------------------------
    METHOD _HBPrinter:setupDialog()
       local uReturn := NIL, oDC, nBreite,nHoehe,aPaperSize

       if ::oPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPS:device()       // xbpPrinter object
       elseif ::oPrinterPS:device():isDerivedFrom( "XbpPrinter" )
          oDC := ::oPrinterPS:device()
       endif

       if ! IsNil(oDC) .and. oDC:isDerivedFrom( "XbpPrinter" )

          if ::_IsOpenStartDoc                       // ::StartDoc() ist aktiv / is active
             oDC:enddoc()                            // print
          endif
          uReturn := oDC:setupDialog()
          aPaperSize := oDC:PaperSize()               // hier kommen nur 6 Elemente
          nBreite := aPaperSize[5] - aPaperSize[3]    // laut DOKU sollten es 8 sein.
          nHoehe  := aPaperSize[6] - aPaperSize[4]
          ::oPS:Configure( oDC, {nBreite,nHoehe} , GRA_PU_LOMETRIC )
          ::SetInternalPageVars()
          if ::_IsOpenStartDoc                       // neu ffnen - open again
             oDC:startdoc(::_cPrinterShowText)
          endif

       endif

    return uReturn

#endif












******************** FUNCTIONS ****************************************************


*-------------------------------------------------------------------
function FontWahl( cFontName, nFontHoehe, lBold, lItalic, oWinPS )
    local oFont, _cFontName , ResetWinPS

    DEFAULT cFontName       TO "Times New Roman"
    DEFAULT nFontHoehe      TO 12
    DEFAULT lBold           TO .f.
    DEFAULT lItalic         TO .f.

    if IsNil( oWinPS )
       if SetAppWindow():isDerivedFrom( "XbpDialog" )
          oWinPS := SetAppWindow():lockPS()
       endif
       if SetAppWindow():isDerivedFrom( "XbpCrt" )
          oWinPS := SetAppWindow():presSpace()
       endif
       ResetWinPS := .t.
    else
       ResetWinPS := .f.
    endif

    oFont := XbpFont():new(oWinPS)  // Fontobject erzeugen
    oFont:generic := .t.
    oFont:vector  := .t.

#ifdef __WIN32__
    if upper(cFontName)  = "HELV"  // beeinhaltet Helvetica
       cFontName := "Arial"
    endif
#endif

#ifdef __OS2__
    if upper(cFontName)  = "ARIAL"
       cFontName := "Helv"
    endif
#endif

    _cFontName := cFontName

#ifdef __OS2__
    IF lBold
      _cFontName := _cFontName + " Bold"
    ENDIF
    IF lItalic
      _cFontName := _cFontName + " Italic"
    ENDIF
#else
    IF lBold
      _cFontName := _cFontName + " Fett"
    ENDIF
    IF lItalic
      _cFontName := _cFontName + " Kursiv"
    ENDIF
#endif

#ifdef __OS2__
    oFont:nominalPointSize := 0
    oFont:create( "0."+_cFontName )
    oFont:nominalPointSize := nFontHoehe
#else
    oFont:nominalPointSize := nFontHoehe
    oFont:create( alltrim(str(nFontHoehe))+"."+_cFontName )
    oFont:nominalPointSize := nFontHoehe
#endif

    if ResetWinPS
       if SetAppWindow():isDerivedFrom( "XbpDialog" )
          SetAppWindow():unlockPS(oWinPS)
       endif
    endif
return oFont
*----------------------------------------------------------------------------------------
FUNCTION WordWrapAt(oPS,nLen,cTxt )   // Wortumbruch finden, damit maximale Zeilenbreite nicht
                                      // berschritten wird !
                                       // Rckgabewert ist fr LEFT und SUBSTR geeignet.
                                       // Rckgabewert ist das letzte Zeichen, das noch in die Zeile pat !
                                       // bis 1.02 war dies anders !
                                       // Falls das Zeichen nach nPos ein Blank ist, wird genau dieses eine
                                       // im aufrufenden PrintMemo() gelscht. Meist ist dies der Fall, weshalb
                                       // die bisherige Methode funktionierte, aber wenn ein String lnger
                                       // als die erlaubte Zeichenbreite ist, gab es Fehler.
                                       // Es darf hier auf keinen Fall mit lTrim gelscht werden,
                                       // sonst stimmt der Offset nicht
                                       // Da cTxt gendert wird darf auf keinen Fall @cTxt bergeben werden !
   * oPS   -> PresentationsSpaceObject, kennt den Font !
   * nLen  -> Breite des Ausgabebereiches, in der Standartwerteinheit von oPS, bei mir immer 0.1 mm
   * cTxt -> Text, der ausgegeben werden soll. Falls dieser nicht krzbar ist, wird len(cTxt) zurck-
   *          gegeben. Damit wird auf jeden Fall etwas gedruckt.
   *          wenn cTxt CRLF enthlt, wird nur die erste Zeile (text vor CRLF) ausgewertet.
   *          Das aufrufende Programm mu also den cTxt selbst krzen um die weiteren Teile drucken
   *          zu knnen. Achtung !!!! hierbei auf CRLF achten
   local nPOS


   cTxt := rtrim(cTxt)

   if CRLF $ cTxt                     // bei Memo bzw. mehrzeiligen Texten immer nur 1. Zeile untersuchen.
      nPOS  := at(CRLF, cTxt)
      cTxt := left(cTxt,nPOS-1)
   endif

   if chr(13) $ cTxt                  // unter Windows kann dies passieren
      nPOS  := at(chr(13), cTxt)
      cTxt := left(cTxt,nPOS-1)
   endif

   if chr(10) $ cTxt                  // unter Windows kann dies passieren
      nPOS  := at(chr(10), cTxt)
      cTxt := left(cTxt,nPOS-1)
   endif
   nPos := len(cTxt)

   do while GraQueryTextBox(oPS,cTxt)[3,1] > nLen .and. ! empty(cTxt) .and. " " $ cTxt
      nPos := rat(" ",cTxt)
      cTxt := left(cTxt,nPos-1)
   enddo

   do while GraQueryTextBox(oPS,cTxt)[3,1] > nLen .and. ! empty(cTxt) // wer hier ankommt, hat mehr Text in einem Wort als erlaubt.
      nPos := len(cTxt)
      cTxt := left(cTxt,nPos-1)
   enddo

   nPos := len(cTxt)

RETURN nPos
*-------------------------------------------------------------------
FUNCTION NoSoftCR(cTxt)  // Diese Funktion mu verwendet werden, wenn Memoedit im Spiel war
    cTxt := strtran(cTxt,chr(141)+chr(10)," ") // +LF ist Softumbruch !
return cTxt
*-------------------------------------------------------------------
FUNCTION WordWrapCut(cTxt,nPos)
   cTxt := substr(cTxt,nPos)
   cTxt := alltrim(cTxt)
   do case
      case left(cTxt,2) = CRLF
           cTxt := substr(cTxt,3)   // Zeichen fr Zeichen lschen egal wie lang.
      case left(cTxt,1) = chr(13)
           cTxt := substr(cTxt,2)   // Zeichen fr Zeichen lschen egal wie lang.
      case left(cTxt,1) = chr(10)
           cTxt := substr(cTxt,2)   // Zeichen fr Zeichen lschen egal wie lang.
   endcase
RETURN cTxt

*----------------------------------------------------------
function HbGradToXppArray(nDrehen,nFaktor)         // noch nicht perfekt ########### prfen !!!"
   local nX, nY, aCosSin, nDrehenInt

   DEFAULT nFaktor TO 1                            // Werte zwischen -1 und 1, fr Ausgabe in Bildpunkten sind diese Werte zu klein
                                                   // ber Faktor kann die Lnge bestimmt werden:   1 = 1/10mm, 10 = 1 mm etc.
                                                   // Valuerange is -1 to 1, for printtext etc. are the values to low
                                                   // the length could be defined with nFaktor:   1 = 1/10mm, 10 = 1 mm etc.

   aCosSin :=  { {1.0000000000000000,0.0000000000000000} , ;   // 0 Grad -> nDrehenInt+1 -> 1. Element
                 {0.9998476951563913,0.0174524064372835} , ;   // 1 Grad -> nDrehenInt+1 -> 2. Element
                 {0.9993908270190958,0.0348994967025010} , ;
                 {0.9986295347545739,0.0523359562429438} , ;
                 {0.9975640502598243,0.0697564737441253} , ;
                 {0.9961946980917455,0.0871557427476582} , ;   // Falls jemand eine bessere Funktion wei, bitte mitteilen.
                 {0.9945218953682733,0.1045284632676535} , ;   // if someone knows a better (fast) way, let me know.
                 {0.9925461516413220,0.1218693434051475} , ;
                 {0.9902680687415704,0.1391731009600654} , ;
                 {0.9876883405951378,0.1564344650402309} , ;
                 {0.9848077530122080,0.1736481776669303} , ;
                 {0.9816271834476640,0.1908089953765448} , ;
                 {0.9781476007338058,0.2079116908177593} , ;
                 {0.9743700647852353,0.2249510543438650} , ;
                 {0.9702957262759965,0.2419218955996677} , ;
                 {0.9659258262890683,0.2588190451025208} , ;
                 {0.9612616959383189,0.2756373558169992} , ;
                 {0.9563047559630355,0.2923717047227367} , ;
                 {0.9510565162951535,0.3090169943749474} , ;
                 {0.9455185755993169,0.3255681544571567} , ;
                 {0.9396926207859084,0.3420201433256687} , ;
                 {0.9335804264972018,0.3583679495453003} , ;
                 {0.9271838545667874,0.3746065934159120} , ;
                 {0.9205048534524404,0.3907311284892738} , ;
                 {0.9135454576426009,0.4067366430758001} , ;
                 {0.9063077870366499,0.4226182617406994} , ;
                 {0.8987940462991670,0.4383711467890774} , ;
                 {0.8910065241883679,0.4539904997395468} , ;
                 {0.8829475928589270,0.4694715627858908} , ;
                 {0.8746197071393958,0.4848096202463371} , ;
                 {0.8660254037844388,0.4999999999999999} , ;
                 {0.8571673007021124,0.5150380749100541} , ;
                 {0.8480480961564260,0.5299192642332049} , ;
                 {0.8386705679454240,0.5446390350150271} , ;
                 {0.8290375725550418,0.5591929034707468} , ;
                 {0.8191520442889918,0.5735764363510460} , ;
                 {0.8090169943749475,0.5877852522924731} , ;
                 {0.7986355100472929,0.6018150231520483} , ;
                 {0.7880107536067219,0.6156614753256583} , ;
                 {0.7771459614569709,0.6293203910498374} , ;
                 {0.7660444431189780,0.6427876096865393} , ;
                 {0.7547095802227720,0.6560590289905073} , ;
                 {0.7431448254773943,0.6691306063588583} , ;
                 {0.7313537016191706,0.6819983600624985} , ;
                 {0.7193398003386513,0.6946583704589973} , ;
                 {0.7071067811865476,0.7071067811865475} , ;
                 {0.6946583704589973,0.7193398003386511} , ;
                 {0.6819983600624985,0.7313537016191705} , ;
                 {0.6691306063588583,0.7431448254773941} , ;
                 {0.6560590289905073,0.7547095802227720} , ;
                 {0.6427876096865394,0.7660444431189780} , ;
                 {0.6293203910498375,0.7771459614569709} , ;
                 {0.6156614753256583,0.7880107536067219} , ;
                 {0.6018150231520484,0.7986355100472929} , ;
                 {0.5877852522924731,0.8090169943749475} , ;
                 {0.5735764363510461,0.8191520442889918} , ;
                 {0.5591929034707468,0.8290375725550418} , ;
                 {0.5446390350150272,0.8386705679454240} , ;
                 {0.5299192642332049,0.8480480961564260} , ;
                 {0.5150380749100544,0.8571673007021123} , ;
                 {0.5000000000000001,0.8660254037844386} , ;
                 {0.4848096202463371,0.8746197071393958} , ;
                 {0.4694715627858909,0.8829475928589269} , ;
                 {0.4539904997395468,0.8910065241883678} , ;
                 {0.4383711467890774,0.8987940462991670} , ;
                 {0.4226182617406994,0.9063077870366499} , ;
                 {0.4067366430758002,0.9135454576426009} , ;
                 {0.3907311284892737,0.9205048534524404} , ;
                 {0.3746065934159122,0.9271838545667874} , ;
                 {0.3583679495453004,0.9335804264972018} , ;
                 {0.3420201433256688,0.9396926207859084} , ;
                 {0.3255681544571568,0.9455185755993168} , ;
                 {0.3090169943749474,0.9510565162951535} , ;
                 {0.2923717047227368,0.9563047559630354} , ;
                 {0.2756373558169992,0.9612616959383189} , ;
                 {0.2588190451025208,0.9659258262890683} , ;
                 {0.2419218955996677,0.9702957262759965} , ;
                 {0.2249510543438652,0.9743700647852353} , ;
                 {0.2079116908177595,0.9781476007338056} , ;
                 {0.1908089953765449,0.9816271834476640} , ;
                 {0.1736481776669304,0.9848077530122080} , ;
                 {0.1564344650402309,0.9876883405951378} , ;
                 {0.1391731009600655,0.9902680687415704} , ;
                 {0.1218693434051475,0.9925461516413220} , ;
                 {0.1045284632676535,0.9945218953682733} , ;
                 {0.0871557427476581,0.9961946980917455} , ;
                 {0.0697564737441255,0.9975640502598243} , ;
                 {0.0523359562429440,0.9986295347545739} , ;
                 {0.0348994967025011,0.9993908270190958} , ;
                 {0.0174524064372836,0.9998476951563913} , ;
                 {0.0000000000000000,1.0000000000000000} }

   nDrehenInt  := int(nDrehen)                          // 23.123 -> aCosSin[23, X/Y ]

   do case
      case nDrehenInt >=  0 .and. nDrehenInt <= 90
           nX := aCosSin[nDrehenInt+1,1]
           nY := aCosSin[nDrehenInt+1,2]
      case nDrehenInt >  90 .and. nDrehenInt <=180
           nDrehenInt := 180-nDrehenInt
           nX := aCosSin[nDrehenInt+1,1] * -1
           nY := aCosSin[nDrehenInt+1,2]
      case nDrehenInt > 180 .and. nDrehenInt<=270
           nDrehenInt -= 180
           nX := aCosSin[nDrehenInt+1,1] * -1
           nY := aCosSin[nDrehenInt+1,2] * -1
      case nDrehenInt > 270 .and. nDrehenInt<=360
           nDrehenInt := 360-nDrehenInt
           nX := aCosSin[nDrehenInt+1,1]
           nY := aCosSin[nDrehenInt+1,2] * -1
   endcase

return {nX*nFaktor,nY*nFaktor}
*-----------------------------------------------------------------------
function cPrinterStatus(nStatus)
   local cReturn
   do case
      case nStatus = XBPPRN_STATUS_PAUSED
           cReturn := "XBPPRN_STATUS_PAUSED"
      case nStatus = XBPPRN_STATUS_READY
           cReturn := "XBPPRN_STATUS_READY"
      case nStatus = XBPPRN_STATUS_BUSY
           cReturn := "XBPPRN_STATUS_BUSY"
      case nStatus = XBPPRN_STATUS_SERVICE
           cReturn := "XBPPRN_STATUS_SERVICE"
      case nStatus = XBPPRN_STATUS_NOPAPER
           cReturn := "XBPPRN_STATUS_NOPAPER"
      case nStatus = XBPPRN_STATUS_NOT_READY
           cReturn := "XBPPRN_STATUS_NOT_READY"
      case nStatus = XBPPRN_STATUS_NA
           cReturn := "XBPPRN_STATUS_NA"
      case nStatus = XBPPRN_STATUS_ERROR
           cReturn := "XBPPRN_STATUS_ERROR"
      case nStatus = XBPPRN_STATUS_OFFLINE
           cReturn := "XBPPRN_STATUS_OFFLINE"
   endcase
return cReturn
*------------------------------------------------
static function GetTxtLen(aTextBox, nDrehen)
   local nTxtLen

   if nDrehen = 90 .or. nDrehen = 270           // Drehwinkel beachten - rotated ?
      nTxtLen   := aTextBox[4,2] - aTextBox[1,2]
   else   // nur richtig fr 0 und 180 , only correct for 0 and 180 
      nTxtLen   := aTextBox[3,1] - aTextBox[2,1]
   endif

return nTxtLen
*------------------------------------------------
#ifdef __OS2__                                  // PDR trifft nur auf OS/2 Version zu
function PDR734( oPS, oFont )
   local nBox, aAttr := Array ( GRA_AS_COUNT )
   // $VS
   // Workaround fr PDR 734
   //
   // Die Fontgroesse ist nicht ganz korrekt, wenn ein Font
   // auf einem Drucker Presentation Space selektiert wird.
   //
   // Hinweis: falls andere Einheiten als GRA_LU_LOMETRIC verwendet
   //          werden, ist der letzte Wert ensprechend anzupassen
   //
   // Character Box
   //       PtSize in 1/72 Inch   1 Inch == 2.54 cm  1/10mm Einheiten im PS
   nBox := ( oFont:NominalPointSize *       2.54 *             100 ) / 72
   aAttr[GRA_AS_BOX] := ARRAY ( 2 )
   aAttr[GRA_AS_BOX, 1] := nBox
   aAttr[GRA_AS_BOX, 2] := nBox
   GraSetAttrString ( oPS, aAttr )
return NIL
#endif

*---------------------------------------------------------------------------
static function ntrim( nVar )
return strTran(alltrim( str( nVar ) ),".",",")
*----------------------------------------------------------
