*#### ANSI .t.    !!!!
#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "XBPDEV.ch"

*---------------- Fonts nur einmal erzeugen - create fonts only once ------
procedure main
local oHBP, cMemo, cWindowsDruckerObjekt
local nLR, nPosY, nMaxLen, nLines

SET CHARSET TO ANSI

TEXT INTO cMemo WRAP
     1. Dies ist ein Test fr MemoPrint() und MemoPrintCountLines()
     2.
     3. Dieser Text zhlt die Zeilen durch, wobei lange Abstze zum Umbruch und damit neuen Zeilen fhren.
     4.
     5. This is a test for MemoPrint() and MemoPrintCountLines()
     6.
     7. The text has line numbers in front, but the long lines will be splitted into two ...
     8.
     9. ENDE / END  j y
ENDTEXT

// Netzwerkdrucker haben nicht immer den erwarteten Namen, so kann man diesen suchen
cWindowsDruckerObjekt := "" // GetPrinterName( "Canon iP7200 series" )


oHBP := HBPrinter():New():create(cWindowsDruckerObjekt) // :create() nutzt Standarddrucker
if oHBP:IsPrinterError()             // Fehler verhindern, avoid errors
   msgbox("Drucker ist nicht verfgbar !")
else
   oHBP:addFont("10.Arial") // hier werden alle bentigten Fonts in ein internes Array geladen
   oHBP:setFont(1)  // hier wird der gewnschte Font gewhlt
   oHBP:StartDoc("Drucktest")  // ein LASER wird dies im Display anzeigen, ein PDF Druckertreiber wird es als Dateinamen verwenden.
   nMaxLen := 1500
   nPosY   :=  200   // 2 cm von oberer Papierkante - Einheit 1/10 mm => 1 mm == 10, 1cm = 100
   nLR     :=  200   // 2 cm von linker Papierkante
   //   PrintText( nPosX, nPosY, xData,                           cAusrichtung, nMaxLen, cArt, nFarbe, nDrehen )
   oHBP:PrintText( nLR  , nPosY, "Printer: "+cWindowsDruckerObjekt,           ,        , "B" )
   nPosY += oHBP:LineFeed(2)  // 2 Zeilen weiter
   oHBP:PrintText( nLR  , nPosY, "OldPos:  "+padr(oHBP:PrintMemoLinePosX,10)+padr(oHBP:PrintMemoLinePosY,10)+padr(oHBP:PrintMemoLineCount,10) )
   nLines := oHBP:PrintMemoCountLines(cMemo, nMaxLen)
   nPosY += oHBP:LineFeed(2)  // 2 Zeilen weiter
   oHBP:PrintText( nLR  , nPosY, "NewPos:  "+padr(oHBP:PrintMemoLinePosX,10)+padr(oHBP:PrintMemoLinePosY,10)+padr(oHBP:PrintMemoLineCount,10) )
   nPosY += oHBP:LineFeed(2)  // 2 Zeilen weiter
   oHBP:PrintText( nLR  , nPosY, "Zeilen/lines in cMemo: "+ntrim(nLines) )
   nPosY += oHBP:LineFeed(2)  // 2 Zeilen weiter
   //  :PrintMemo( nPosX, nPosY, cTxt , cAusrichtung, nMaxLen, cArt, nFarbe, cHochQuer, nMaxBis,nLineFeed )
   oHBP:PrintMemo( nLR  , nPosY, cMemo, "L"         , nMaxLen, "B" )
   nPosY := oHBP:PrintMemoLinePosY + oHBP:LineFeed(2)  // 2 Zeilen weiter
   oHBP:PrintText( nLR  , nPosY, "NewPos:  "+padr(oHBP:PrintMemoLinePosX,10)+padr(oHBP:PrintMemoLinePosY,10)+padr(oHBP:PrintMemoLineCount,10) )
   oHBP:EndDoc()
endif
msgbox("gedruckt Umlaute ")
return

function GetPrinterName( cWindowsDruckerObjekt )
   static cPrinterName := NIL
   local oP, aL, cD, i := 0
   if cPrinterName = NIL
      oP := XbpPrinter():new()
      if oP = NIL
         msgbox("Druckerobjekt konnte nicht erzeugt werden - no Print object","GetPrinterName()")
         quit
      else
         aL := oP:list()
         i := AScan( aL, {|x| lower(x) == lower(cWindowsDruckerObjekt) } )    // genau
         if i = 0
            i := AScan( aL, {|x| lower(cWindowsDruckerObjekt) $ lower(x) } )  // einiger Maen, z.B. bei Netzwerkdrucker
         endif
      endif
      if i > 0
         cPrinterName := aL[i]
      else
         msgbox("Drucker konnte nicht gefunden werden - no such printer","GetPrinterName()")
         quit
      endif
   endif
return cPrinterName

function ntrim(n)
return alltrim(str(n))

