*#### ANSI .t.    !!!!
* XPP GRA Funktionen fr EAN13 Druck
* Infos: www.barcodeisland.com/ean13.phtml  - just for info - not from me !
*
* BEST RESULTS ON LASER PRINTER !
* BESTE ERGEBNISSE MIT LASER DRUCKERN !

/*

* Versionen - Versions

  1.0  2003-05-16
       erste Ausgabe - first release

* Author:

  Hubert Brandel
  Leipziger Str. 6
  D - 76726 Germersheim

  Hubert.Brandel@gmx.de
  Hubert@familie-brandel.de

  www.familie-brandel.de

  * Lizenzbestimmungen - german:

  Jeder darf diesen Quellcode nutzen und fr eigene Zwecke
  abwandeln, solange niemand meine Urheberschaft anzweifelt.
  Ich freue mich natrlich ber jede Aufmerksamkeit und
  seien es auch nur nette Worte.
  Falls Sie diesen Code verwenden, bitte ich Sie mir
  dies per eMail mitzuteilen - nur wer will !
  Dies dient nur meiner Info, ob ich bei nderungen auf
  andere Rcksicht nehmen sollte.
  Wer den Code in ein kommerzielles Produkt einbaut,
  sollte mir fairer Weise ein Taschengeld zukommen lassen.
  Falls Sie dies mchten, mailen Sie micht einfach an.
  Natrlich geniesen solche VIPs dann natrlich schnellere
  eMail - Reaktionszeiten.

  Zu guter letzt:      ICH HAFTE FR NICHTS !!!!


  Licence - english:

  Everyone can use and modify the code for his needs.
  But HB_XPP_Barcode_EAN13 is my product.
  Please - you don't have to - send me a email, if you use
  this code - with the info if you wanted news about it.
  This is just for my personaly interrest !
  If you find it usefull and earn money with it, it would
  be nice if you send me a little tip - ask me for conditions.
  Its your free decition - i answer your emails faster than :-)

  DISCLAIMER: I am NOT responciple for any damage or whatever !!!!

  Thanks and bye
  Hubert Brandel




*/


* #define __TEST__                     // nur aktivieren whrend der Testphase
                                     // do you want the test programm ?
                                     // deaktivate this if you put it into your programm

#define  ERR_LANG_GERMAN             // NUR dies aktivieren fr deutsche Hilfetexte
* #define  ERR_LANG_ENGLISH          // ONLY activate this for english errormessages


#ifndef __HB_XPP_Barcode_EAN13__
#define __HB_XPP_Barcode_EAN13__

#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"

#define  Box_Size_Y_100_Percent 263   // 16.26 mm kleinste Einheit 0.1mm
#define  Box_Size_X_100_Percent 373   // 37.29 mm


#ifdef   ERR_LANG_GERMAN
   #define  ERR_EAN13_NR_MISSING           "uEAN13_Nr mu definiert werden !"
   #define  ERR_EAN13_DATATYPE             "uEAN13_Nr -> Datentypfehler -> char oder num"
   #define  ERR_EAN13_PARAMETER_LEN        "uEAN13_Nr -> 12 oder 13 Stellen mssen bergeben werden"
   #define  ERR_EAN13_oPS_MISSING          "oPS mu definiert werden !"
   #define  ERR_EAN13_nRotate_WRONG_VALUE  "nRotate darf nur 0, 90, 180 oder 270 sein !"
   #define  ERR_EAN13_BOX_BOTTOM           "Fehler bei lBox - GraBox unten"
   #define  ERR_EAN13_BOX_LEFT             "Fehler bei lBox - GraBox links"
   #define  ERR_EAN13_BOX_TOP              "Fehler bei lBox - GraBox oben"
   #define  ERR_EAN13_BOX_RIGHT            "Fehler bei lBox - GraBox rechts"
   #define  ERR_EAN13_RES_NOT_OK           "Falsche UNIT bei XbpPresSpace"
#endif

#ifdef   ERR_LANG_ENGLISH
   #define  ERR_EAN13_NR_MISSING           "uEAN13_Nr is missing"
   #define  ERR_EAN13_DATATYPE             "uEAN13_Nr -> datatyp error -> char or num"
   #define  ERR_EAN13_PARAMETER_LEN        "uEAN13_Nr -> len have to be 12 or 13"
   #define  ERR_EAN13_oPS_MISSING          "oPS is missing"
   #define  ERR_EAN13_nRotate_WRONG_VALUE  "nRotate can be 0, 90, 180 or 270"
   #define  ERR_EAN13_BOX_BOTTOM           "Error in lBox printing - bottom line"
   #define  ERR_EAN13_BOX_LEFT             "Error in lBox printing - left line"
   #define  ERR_EAN13_BOX_TOP              "Error in lBox printing - top line"
   #define  ERR_EAN13_BOX_RIGHT            "Error in lBox printing - right line"
   #define  ERR_EAN13_RES_NOT_OK           "Wrong UNIT by XbpPresSpace"
#endif


#ifdef  __TEST__

function main()
    local cArt,cEAN13_Nr, cErrTxt := "", oPS, nPerCent, oFont, nSpalten
    local nZeilen, getlist := {}, aPosXpp, nFirstLabelBaseX, nFirstLabelBaseY
    local nLabelOffsetX, nLabelOffsetY, nZeile, nSpalte, nPosX, nPosY


    set color to "n/bg,w+/n,,,n/w"
    cls

    cArt       := "D"
    cEAN13_Nr  := space(13)
    nSpalten   := 3                 // Zweckform 3669 - Labels
    nZeilen    := 5
    nFirstLabelBaseX := 150         // von linker Papierkante  - from paper left end
    nFirstLabelBaseY :=2350         // von unterer Papierkante - from paper bottom end
    nLabelOffsetX    := 700
    nLabelOffsetY    := 500
    nPerCent         := 100

    do while .t.

       @ 1,1 say "Aktion:  P=Prfziffer berechnen   D=drucken  A=Teste alle "  get cArt      picture "!"
       @ 2,1 say "action:  P=calculate 13. Digit    D=Print    A=Test all   "
       @ 3,1 say "EAN13-code:"                                     get cEAN13_Nr picture "9999999999999"
       @ 3,30 say "if len()=12 then autocalc 13. digit" color "w+/bg"
       @ 5,1 say "Papiereinstellungen - paperinfo:"
       @ 6,1 say "Labels pro Zeile    - lables per row:      "     get nSpalten         when cArt="D"
       @ 7,1 say "Labels pro Spalte   - lables per col:      "     get nZeilen          when cArt="D"
       @ 8,1 say "Unterkante 1. Label - Baseline Y  1. label:"     get nFirstLabelBaseY when cArt="D"
       @ 9,1 say "Linkerrand 1. Label - left margin 1. label:"     get nFirstLabelBaseX when cArt="D"
       @10,1 say "Breite pro Label    - label width:         "     get nLabelOffsetX    when cArt="D"
       @11,1 say "Hhe pro Label      - label height:        "     get nLabelOffsetY    when cArt="D"
       @12,1 say "Barcode size:    min: 82 max: 197 all in % "     get nPerCent         when cArt="D"

       @ 7,57 say "LOMETRIC  HIENGLISH"
       @ 8,57 say "1/10 mm - 1/1000 Inch"
       @ 9,57 say "1/10 mm - 1/1000 Inch"
       @10,57 say "1/10 mm - 1/1000 Inch"
       @11,57 say "1/10 mm - 1/1000 Inch"
       @12,57 say "HIMETRIC * 10"

       set cursor on
       read
       set cursor off

       @13,0 clear to 24,79

       do case
          case lastkey() = 27 .or. empty(cArt)
               exit
          case cArt="P"
               @14,1 say "Prfziffer 'C' ist:  "+GraBarcodeEAN13_CalcCheckDigit(left(cEAN13_Nr,12))
               @14, 30 say "13. Digit in char mode"
               @15,1 say "Prfziffer 'N' ist:  "+GraBarcodeEAN13_CalcCheckDigit(val(left(cEAN13_Nr,12)))
               @15, 30 say "13. Digit in number mode"

          case cArt="D"

               @14,1 say "errechnete Prfziffer:      "+GraBarcodeEAN13_CalcCheckDigit(cEAN13_Nr)
               @14,40 say "calculated 13. Digit"

               // Presentation-Space fr Standard-Drucker erzeugen  all in 1/10 mm
               oPS := PrinterPS()
               oFont    := XbpFont():new(oPS):create("10.Arial")
               GraSetFont( oPS, oFont )         // Font installieren

               nPosX := nFirstLabelBaseX - oPS:device():PaperSize()[3]  // Hardwarernder abziehen
               nPosY := nFirstLabelBaseY - oPS:device():PaperSize()[4]  // - hardwaremargins

               // Spooler aktivieren
               oPS:device():startDoc()

               for nZeile := 0 to nZeilen-1

                   for nSpalte := 0 to nSpalten-1

                       aPosXpp := { nPosX + nSpalte * nLabelOffsetX ,; // X
                                    nPosY - nZeile  * nLabelOffsetY }  // Y

                       GraBarcodeEAN13(oPS,aPosXpp,nPerCent,cEAN13_Nr,.t.,@cErrTxt,0)

                       if ! empty(cErrTxt)
                          @24,1 say "Error: "
                          ?? cErrTxt
                       endif

                   next

               next

               oPS:device():endDoc()
               DestroyDevice( oPS )

          case cArt="A"

               // Presentation-Space fr Standard-Drucker erzeugen
               oPS := PrinterPS()
               oFont    := XbpFont():new(oPS):create("10.Arial")
               GraSetFont( oPS, oFont )         // Font installieren

               // Spooler aktivieren
               oPS:device():startDoc()

               GraStringAt(oPS, {10,2800}, "EAN13 - 100 %" )

               GraBarcodeEAN13(oPS,{10,2500},,cEAN13_Nr,.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{20  ,2100},,"011111111111",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,2100},,"111111111111",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,2100},,"211111111111",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,2100},,"311111111111",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1700},,"411111111111",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1700},,"511111111111",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,1700},,"611111111111",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,1700},,"711111111111",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1300},,"811111111111",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1300},,"911111111111",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 900},,"022222222222",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 900},,"122222222222",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 900},,"222222222222",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 900},,"322222222222",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 500},,"422222222222",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 500},,"522222222222",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 500},,"622222222222",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 500},,"722222222222",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 100},,"822222222222",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 100},,"922222222222",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{1500,1}   ,,"7501031311309",.t.,@cErrTxt,0)

               oPS:device():newPage()

               GraStringAt(oPS, {10,2800}, "100 %" )

               GraBarcodeEAN13(oPS,{20  ,2100},,"033333333333",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,2100},,"133333333333",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,2100},,"233333333333",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,2100},,"333333333333",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1700},,"433333333333",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1700},,"533333333333",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,1700},,"633333333333",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,1700},,"733333333333",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1300},,"833333333333",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1300},,"933333333333",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 900},,"044444444444",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 900},,"144444444444",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 900},,"244444444444",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 900},,"344444444444",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 500},,"444444444444",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 500},,"544444444444",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 500},,"644444444444",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 500},,"744444444444",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 100},,"844444444444",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 100},,"944444444444",.t.,@cErrTxt,0)

               oPS:device():newPage()

               GraStringAt(oPS, {10,2800}, "100 %" )

               GraBarcodeEAN13(oPS,{20  ,2100},,"055555555555",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,2100},,"155555555555",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,2100},,"255555555555",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,2100},,"355555555555",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1700},,"455555555555",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1700},,"555555555555",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,1700},,"655555555555",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,1700},,"755555555555",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1300},,"855555555555",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1300},,"955555555555",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 900},,"066666666666",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 900},,"166666666666",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 900},,"266666666666",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 900},,"366666666666",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 500},,"466666666666",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 500},,"566666666666",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 500},,"666666666666",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 500},,"766666666666",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 100},,"866666666666",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 100},,"966666666666",.t.,@cErrTxt,0)

               oPS:device():newPage()

               GraStringAt(oPS, {10,2800}, "100 %" )

               GraBarcodeEAN13(oPS,{20  ,2100},,"077777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,2100},,"177777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,2100},,"277777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,2100},,"377777777777",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1700},,"477777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1700},,"577777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,1700},,"677777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,1700},,"777777777777",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1300},,"877777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1300},,"977777777777",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 900},,"088888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 900},,"188888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 900},,"288888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 900},,"388888888888",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 500},,"488888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 500},,"588888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 500},,"688888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 500},,"788888888888",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 100},,"888888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 100},,"988888888888",.t.,@cErrTxt,0)

               oPS:device():newPage()

               GraBarcodeEAN13(oPS,{20  ,2100},,"099999999999",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,2100},,"199999999999",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,2100},,"299999999999",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,2100},,"399999999999",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1700},,"499999999999",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1700},,"599999999999",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,1700},,"699999999999",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,1700},,"799999999999",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1300},,"899999999999",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1300},,"999999999999",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 900},,"000000000000",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 900},,"100000000000",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 900},,"200000000000",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 900},,"300000000000",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 500},,"400000000000",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 500},,"500000000000",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 500},,"600000000000",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 500},,"700000000000",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 100},,"800000000000",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 100},,"900000000000",.t.,@cErrTxt,0)

               oPS:device():newPage()

               nPerCent := 82

               GraStringAt(oPS, {10,2800}, "82 % - minimal Size")

               GraBarcodeEAN13(oPS,{20  ,2100},nPerCent,"077777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,2100},nPerCent,"177777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,2100},nPerCent,"277777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,2100},nPerCent,"377777777777",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1700},nPerCent,"477777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1700},nPerCent,"577777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,1700},nPerCent,"677777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620,1700},nPerCent,"777777777777",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  ,1300},nPerCent,"877777777777",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 ,1300},nPerCent,"977777777777",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 900},nPerCent,"088888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 900},nPerCent,"188888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 900},nPerCent,"288888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 900},nPerCent,"388888888888",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 500},nPerCent,"488888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 500},nPerCent,"588888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 500},nPerCent,"688888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1620, 500},nPerCent,"788888888888",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 100},nPerCent,"888888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{550 , 100},nPerCent,"988888888888",.t.,@cErrTxt,0)

               oPS:device():newPage()

               nPerCent := 1.97    // thats ok too

               GraStringAt(oPS, {10,2800}, "197 % - maxi Size" )

               GraBarcodeEAN13(oPS,{20  ,2100},nPerCent,"088888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,2100},nPerCent,"188888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{20,  1300},nPerCent,"288888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,1300},nPerCent,"388888888888",.t.,@cErrTxt,0)

               GraBarcodeEAN13(oPS,{20  , 500},nPerCent,"488888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080, 500},nPerCent,"588888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{20,     0},nPerCent,"688888888888",.t.,@cErrTxt,0)
               GraBarcodeEAN13(oPS,{1080,   0},nPerCent,"788888888888",.t.,@cErrTxt,0)

               oPS:device():endDoc()
               DestroyDevice( oPS )

               nPerCent         := 100


       endcase

    enddo

    set color to "w/n"

return nil



FUNCTION PrinterPS( cPrinterObjectName )

   LOCAL oPS, oDC := XbpPrinter():New()
   LOCAL aSize

   oDC:Create( cPrinterObjectName )

   oPS   := XbpPresSpace():New()
   aSize := oDC:paperSize()

   // Gre des bedruckbaren Bereichs GRA_PU_LOMETRIC
   aSize := { aSize[5] - aSize[3], ;
              aSize[6] - aSize[4]  }

   oPS:Create( oDC, aSize, GRA_PU_LOMETRIC )  // 0.1 mm

   // if you try   GRA_PU_HIENGLISH    you have to take 1000 per INCH, not 100 ???
   // GRA_PU_LOENGLISH did NOT work on my printer !

RETURN oPS

PROCEDURE DestroyDevice( oPS )
   LOCAL oDC := oPS:device()
   IF oDC <> NIL
      oPS:configure()
      oDC:destroy()
   ENDIF

RETURN

#endif

// Schnittstellen  der Funktionen




// Implementierung der Funktionen - exportiert

function GraBarcodeEAN13(oPS,aPos,nPerCent,uEAN13_Nr,lBox,cErrTxt,nRotate)
   local lFehler := .f., cBarCodeBlock,nBarCodeBlockLen, cFirstDigit, nFaktor
   local nSizeX, nSizeY, nSwap, nUnits
   local nBoxLineDim, nBarLineDim,nBarLineDimPrint, nBarLeftBlankLines, oFont, x, y, z
   local nStringOffset, nBarLongLineOffset, nBarShortLineOffset, nBarTopMargin
   local oAltFont

   * Standardvorgaben, welche wahlweise angegeben werden knnen.
   DEFAULT aPos     TO {10,10}
   DEFAULT nPerCent TO 100
   DEFAULT lBox     TO .f.
   DEFAULT cErrTxt  TO ""
   DEFAULT nRotate  TO 0

   if nPerCent <= 3                                 // not % this is the factor
      nFaktor := nPerCent
   else
      nFaktor := nPerCent / 100                     // 100 -> factor 1
   endif

   if nFaktor >= 0.99 .and. nFaktor <= 1.01         // Toleranzen ausgleichen
      nFaktor   := 1
   endif

   if nFaktor < 0.82                                // minimal
      nFaktor   := 0.82
   endif

   if nFaktor > 1.97                                // maximal
      nFaktor   := 1.97
   endif

   // Alle diese Werte wurden unter GRA_PU_LOMETRIC ermittelt !
   // All values are represents the dimensions in  GRA_PU_LOMETRIC

   nSizeX    := Box_Size_X_100_Percent * nFaktor
   nSizeY    := Box_Size_Y_100_Percent * nFaktor

   nBoxLineDim := 5             // Standart 0.5 mm Strichstrke  - box line size
   nBarLineDim := 3.3 * nFaktor // Standart 0.33 mm Strichstrke - bar line size
   nBarLeftBlankLines := 10     // linker Rand nBarLeftBlankLines * nBarLineDim
                                // left margin nBarLeftBlankLines * nBarLineDim
   nStringOffset := 10          // Abstand Rahmen zu Textbeginn (Ziffern haben keine Unterlnge!)
                                // distance from box to first digit
   nBarLongLineOffset := 20     // Abstand der langen Linien von unten (Trennlinien)
                                // length of short bar lines
   nBarShortLineOffset:= 40     // Abstand der kurzen Linien von unten (Datenlinien)
                                // length of long bar lines
   nBarTopMargin := 20          // Abstand der Linien zur oberen Kante
                                // distance top margin bar lines to top box line

   * Pflichtangaben
   do case
      case IsNil(uEAN13_Nr)          // ohne Nummer geht es nicht - nothing without it
           lFehler := .t.
           cErrTxt := ERR_EAN13_NR_MISSING
      case Valtype(uEAN13_Nr)="N"
           uEAN13_Nr := alltrim(str(uEAN13_Nr,15,0))
      case Valtype(uEAN13_Nr)="C"
           uEAN13_Nr := alltrim(uEAN13_Nr)
      otherwise
           lFehler := .t.
           cErrTxt := ERR_EAN13_DATATYPE
   endcase

   * nun ist uEAN13_Nr ein String !
   do case
      case len(uEAN13_Nr) = 12                  // Prfziffer anhngen - calculate 13. digit
           uEAN13_Nr += GraBarcodeEAN13_CalcCheckDigit(uEAN13_Nr)
      case len(uEAN13_Nr) = 13                  // Prfziffer wurde bergeben - take it as it is
           // Prfziffer ungeprft belassen !
      otherwise
           lFehler := .t.
           cErrTxt := ERR_EAN13_PARAMETER_LEN
   endcase

   * oPS mu bei GUI bergeben werden !
   do case
      case IsNil(oPS) .and. SetAppWindow():isDerivedFrom( "XbpCrt" )
           oPS := SetAppWindow():presSpace()
           // Bildschirmauflsung ist viel grober als Drucker
           // if you want it on a XbpCrt, you have to change the units, NOT USEFULL !
           nSizeY := nSizeY / 3
           nSizeX := nSizeX / 3
           nBoxLineDim := 1            // Standart 1 Pixel
           nBarLineDim := 1            // Standart 1 Pixel
           nStringOffset := 3
           nBarLongLineOffset := nBarLongLineOffset / 3
           nBarShortLineOffset:= nBarShortLineOffset / 3
           nBarTopMargin      := nBarTopMargin / 3
      case IsNil(oPS)
           lFehler := .t.
           cErrTxt := ERR_EAN13_oPS_MISSING
   endcase

   * nRotate darf nur 0, 90, 180, oder 270 betragen  // noch nicht implementiert !##########
   do case
      case nRotate > 360 .or. nRotate = 0
           nRotate := 0
           // nichts zu ndern
      case nRotate = 90   // links gekippt
           nSwap  := nSizeY
           nSizeY := nSizeX
           nSizeX := nSwap
      case nRotate =180   // auf dem Kopf
      case nRotate =270   // rechts gekippt
           nSwap  := nSizeY
           nSizeY := nSizeX
           nSizeX := nSwap
      otherwise
           lFehler := .t.
           cErrTxt := ERR_EAN13_nRotate_WRONG_VALUE
   endcase


   if ! lFehler    // teste Grafikeinheit - test grafik units

      // Wenn GRA_PU_HIMETRIC  verwendet wurde, alle internen Werte * 10
      // If   GRA_PU_HIMETRIC  have been used,  all internal values * 10
      // Wenn GRA_PU_HIENGLISH verwendet wurde, alle internen Werte / .254
      // If   GRA_PU_HIENGLISH have been used,  all internal values / .254

      nUnits := oPS:setPageSize()[2]

      do case
         case nUnits = GRA_PU_LOMETRIC         // standard
              * Rest OK
              nBarLineDimPrint := int(nBarLineDim - 1)
              // wenn die Linien zu dick werden kann man hier
              // etwas nachhelfen
              // if the bars are to thick and you get 1 instead of 2
              // correct this value
         case nUnits = GRA_PU_HIMETRIC
              nSizeX               *= 10
              nSizeY               *= 10
              nBoxLineDim          *= 10
              nBarLineDim          *= 10
              nBarLineDimPrint     := int(nBarLineDim)
              // nBarLeftBlankLines   nicht ndern, enthlt keine Strichstrke, sondern Anzahl
              //                      don't change, no messure inside, but linecount
              nStringOffset        *= 10
              nBarLongLineOffset   *= 10
              nBarShortLineOffset  *= 10
              nBarTopMargin        *= 10

         case nUnits = GRA_PU_LOENGLISH        // did NOT work on my printer
              nSizeX               /= 2.54     // lines are too thick or
              nSizeY               /= 2.54     // not printed ! -> HIENGLISH
              nBoxLineDim          /= 2.54
              nBarLineDim          /= 2.54
              nBarLineDimPrint     := int(nBarLineDim * 0.8)
              // nBarLeftBlankLines   nicht ndern, enthlt keine Strichstrke, sondern Anzahl
              //                      don't change, no messure inside, but linecount
              nStringOffset        /= 2.54
              nBarLongLineOffset   /= 2.54
              nBarShortLineOffset  /= 2.54
              nBarTopMargin        /= 2.54

         case nUnits = GRA_PU_HIENGLISH
              nSizeX               /= .254
              nSizeY               /= .254
              nBoxLineDim          /= .254
              nBarLineDim          /= .254
              nBarLineDimPrint     := int(nBarLineDim)
              // nBarLeftBlankLines   nicht ndern, enthlt keine Strichstrke, sondern Anzahl
              //                      don't change, no messure inside, but linecount
              nStringOffset        /= .254
              nBarLongLineOffset   /= .254
              nBarShortLineOffset  /= .254
              nBarTopMargin        /= .254

         otherwise
              lFehler := .t.
              cErrTxt := ERR_EAN13_RES_NOT_OK
      endcase
   endif

   if ! lFehler

      // Startblock  start sentinel - linker Anfang
      cBarCodeBlock := "101"
      // 1. Stelle EAN13 wird nicht verschlsselt,                      LAND 1. Stelle
      //    sondern entscheidet odd/even Folge bei LEFT-HAND !
      cFirstDigit := left(uEAN13_Nr,1)
      // 2. Stelle EAN13 wird immer ODD verschlsselt                   LAND 2. Stelle
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("L"+substr(uEAN13_Nr,2,1)+"O")
      // 3. - 7 Stelle EAN13                                            Manufakturer 5 Ziffern
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("L"+substr(uEAN13_Nr,3,1)+ ;
                       GraBarcodeEAN13_Parity2EncodingTable(cFirstDigit,1))
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("L"+substr(uEAN13_Nr,4,1)+ ;
                       GraBarcodeEAN13_Parity2EncodingTable(cFirstDigit,2))
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("L"+substr(uEAN13_Nr,5,1)+ ;
                       GraBarcodeEAN13_Parity2EncodingTable(cFirstDigit,3))
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("L"+substr(uEAN13_Nr,6,1)+ ;
                       GraBarcodeEAN13_Parity2EncodingTable(cFirstDigit,4))
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("L"+substr(uEAN13_Nr,7,1)+ ;
                       GraBarcodeEAN13_Parity2EncodingTable(cFirstDigit,5))
      // Mittlerer Trennblock   CENTER GUARD BARS
      cBarCodeBlock += "01010"
      // 8. - 12. Stelle EAN13                                          PRODUKT 5 Ziffern
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("R"+substr(uEAN13_Nr,8,1))
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("R"+substr(uEAN13_Nr,9,1))
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("R"+substr(uEAN13_Nr,10,1))
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("R"+substr(uEAN13_Nr,11,1))
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("R"+substr(uEAN13_Nr,12,1))
      // 13. Stelle CheckDigit immer als RightHand verschlsseln
      cBarCodeBlock += GraBarcodeEAN13_EncodingTable("R"+substr(uEAN13_Nr,13,1))
      // Endeblock   RIGHT GUARD BARS
      cBarCodeBlock += "101"

      if lBox
         // der Box-Befehl hat sehr unterschiedliche Strichstrken, daher wird
         // die Box aus mehreren gefllten Boxen (Linien wren auch unzuverlssig)
         // je .5 mm Strickstrke    unten oben links rechts
         if ! GraBox( oPS, {aPos[1]-nBoxLineDim,aPos[2]-nBoxLineDim},;
                           {aPos[1]+nSizeX+nBoxLineDim,aPos[2]},GRA_FILL  )
            lFehler := .t.
            cErrTxt := ERR_EAN13_BOX_BOTTOM
         endif
         if ! GraBox( oPS, {aPos[1]-nBoxLineDim,aPos[2]+nSizeY},;
                           {aPos[1]+nSizeX+nBoxLineDim,aPos[2]+nSizeY+nBoxLineDim},GRA_FILL  )
            lFehler := .t.
            cErrTxt := ERR_EAN13_BOX_TOP
         endif
         if ! GraBox( oPS, {aPos[1]-nBoxLineDim,aPos[2]-nBoxLineDim},;
                           {aPos[1],aPos[2]+nSizeY+nBoxLineDim},GRA_FILL  )
            lFehler := .t.
            cErrTxt := ERR_EAN13_BOX_LEFT
         endif
         if ! GraBox( oPS, {aPos[1]+nSizeX,aPos[2]-nBoxLineDim},;
                           {aPos[1]+nSizeX+nBoxLineDim,aPos[2]+nSizeY+nBoxLineDim},GRA_FILL  )
            lFehler := .t.
            cErrTxt := ERR_EAN13_BOX_RIGHT
         endif
      endif
   endif
   if ! lFehler
      * Ausdrucken - Print

      oFont    := XbpFont():new(oPS):create("8.Arial")
      oAltFont := GraSetFont( oPS, oFont )         // Font installieren und alten merken

      do case
         case nRotate = 0
              x := aPos[1] + nBarLineDim * 4
              y := aPos[2] + nBarShortLineOffset + (nBarShortLineOffset-nBarLongLineOffset)/2
              GraStringAt(oPS, {x,y}, left(uEAN13_Nr,1) )

              //  2. Text beginnt: linker Rand + 3 Startsequenz + 7 Linien
              x := aPos[1] + nBarLineDim * (nBarLeftBlankLines+3+7)
              y := aPos[2] + nStringOffset
              GraStringAt(oPS, {x,y}, substr(uEAN13_Nr,2,6) )

              //  3. Text beginnt: linker Rand + 3 Startsequenz + 6*7 Linien + 5 Mitte + 4
              x := aPos[1] + nBarLineDim * (nBarLeftBlankLines+3+6*7+5+4)
              y := aPos[2] + nStringOffset
              GraStringAt(oPS, {x,y}, substr(uEAN13_Nr,8,6) )

              nBarCodeBlockLen := len(cBarCodeBlock)

              // print the bars !

              for z := 1 to nBarCodeBlockLen
                  if substr(cBarCodeBlock,z,1)="1"    // drucken
                     //   Anzahl Striche vor diesem   * Strichbreite = Startwert fr aktuellen Strich
                     x := aPos[1] + (nBarLeftBlankLines + z-1 ) * nBarLineDim
                     if z <= 3 .or. (z > 3+6*7 .and. z <= 3+6*7+5) .or. z > 3+6*7+5+6*7
                        // Strich ist ein langer Strich da kein Datenbereich
                        y := aPos[2] + nBarLongLineOffset
                     else
                        // Datenbereich, kurzer Strich
                        Y := aPos[2] + nBarShortLineOffset
                     endif
                     if z = nBarCodeBlockLen .or. substr(cBarCodeBlock,z+1,1)="1"
                        GraBox( oPS, {x,y}, {x+nBarLineDim,aPos[2]+nSizeY-nBarTopMargin},GRA_FILL  )
                     else
                        GraBox( oPS, {x,y}, {x+nBarLineDimPrint,aPos[2]+nSizeY-nBarTopMargin},GRA_FILL  )
                     endif
                  endif
              next

         case nRotate = 90   // links gekippt
              * not yet
         case nRotate =180   // auf dem Kopf
              * not yet
         case nRotate =270   // rechts gekippt
              * not yet
      endcase

      GraSetFont( oPS, oAltFont )   // alte Werte einstellen

      oFont:destroy()

   endif

return ! lFehler

*------------------------------------------------------------------------------------------
function GraBarcodeEAN13_CalcCheckDigit(uEAN13_Nr) // gibt die CheckDigit als String zurck
                                                   // wegen fhrender 0 besser als String !
   local x, lFehler := .f., nSummOdd, nSummEven, cOddEven, nCheckSummValue,;
         cCheckSummValue, cCheckSummDigit,nCheckSummDigit

   do case
      case Valtype(uEAN13_Nr)="N"
           uEAN13_Nr := left(alltrim(str(uEAN13_Nr,15,0)),12)
      case Valtype(uEAN13_Nr)="C"
           uEAN13_Nr := left(alltrim(uEAN13_Nr,15),12)
      otherwise
           cCheckSummDigit := ERR_EAN13_DATATYPE
           lFehler := .t.
   endcase

   if len(uEAN13_Nr) < 12 .and. ! lFehler // noch keine Fehlermeldung erhalten,
      cCheckSummDigit := ERR_EAN13_PARAMETER_LEN
      lFehler := .t.
   endif

   if ! lFehler
      nSummOdd  := 0
      nSummEven := 0
      cOddEven  := "E" // erste Position des EAN13 Strings ist per Definition EVEN !

      for x := 1 to 12
          if cOddEven = "E"
             nSummEven += val(substr(uEAN13_Nr,x,1))
             cOddEven  := "O"
          else
             nSummOdd  += val(substr(uEAN13_Nr,x,1))
             cOddEven  := "E"
          endif
      next

      // CheckSummDigit ist der Unterschied von nCheckSummValue zum nchsten vollen 10er.

      nCheckSummValue := nSummEven + nSummOdd * 3 // Gewichtung der Odd Position mit 3

      cCheckSummValue := right(alltrim(str(nCheckSummValue,15,0)),1) // letzte Position ermitteln

      nCheckSummDigit := 10 - val(cCheckSummValue) // von 0->0 1->9 2->8 etc.

      cCheckSummDigit := right(alltrim(str(nCheckSummDigit,3,0)),1)

   endif

return cCheckSummDigit

// Implementierung der Funktionen - interne Funktionen
*------------------------------------------------------------------------------------------
static function GraBarcodeEAN13_EncodingTable(cEncodeID)
   local cReturnCode, x
   // aCodeTable = Verschlsselungstabelle fr Links Odd/Even und Rechts je Ziffer
   static aCodeTable := { { "L0O","0001101" } ,;
                          { "L0E","0100111" } ,;
                          { "L1O","0011001" } ,;
                          { "L1E","0110011" } ,;
                          { "L2O","0010011" } ,;
                          { "L2E","0011011" } ,;
                          { "L3O","0111101" } ,;
                          { "L3E","0100001" } ,;
                          { "L4O","0100011" } ,;
                          { "L4E","0011101" } ,;
                          { "L5O","0110001" } ,;
                          { "L5E","0111001" } ,;
                          { "L6O","0101111" } ,;
                          { "L6E","0000101" } ,;
                          { "L7O","0111011" } ,;
                          { "L7E","0010001" } ,;
                          { "L8O","0110111" } ,;
                          { "L8E","0001001" } ,;
                          { "L9O","0001011" } ,;
                          { "L9E","0010111" } ,;
                          { "R0" ,"1110010" } ,;
                          { "R1" ,"1100110" } ,;
                          { "R2" ,"1101100" } ,;
                          { "R3" ,"1000010" } ,;
                          { "R4" ,"1011100" } ,;
                          { "R5" ,"1001110" } ,;
                          { "R6" ,"1010000" } ,;
                          { "R7" ,"1000100" } ,;
                          { "R8" ,"1001000" } ,;
                          { "R9" ,"1110100" }   }  // nur einmal erzeugen spart Zeit.

   cEncodeID := upper(alltrim(cEncodeID))

   x := AScan( aCodeTable, {|cTmp| cTmp[1] == cEncodeID }  )

   if x = 0
      cReturnCode := "'cEncodeID'='"+cEncodeID+"' ist ungltig !"
   else
      cReturnCode := aCodeTable[x,2]
   endif
return cReturnCode

*------------------------------------------------------------------------------------------
static function GraBarcodeEAN13_Parity2EncodingTable(cFirstDigit,nManufakturerStelle)
   local cReturnCode, x
   // aCodeTable = Verschlsselungstabelle fr Links Odd/Even und Rechts je Ziffer
   static aCodeTable := { { "0","O","O","O","O","O" } ,;
                          { "1","O","E","O","E","E" } ,;
                          { "2","O","E","E","O","E" } ,;
                          { "3","O","E","E","E","O" } ,;
                          { "4","E","O","O","E","E" } ,;
                          { "5","E","E","O","O","E" } ,;
                          { "6","E","E","E","O","O" } ,;
                          { "7","E","O","E","O","E" } ,;
                          { "8","E","O","E","E","O" } ,;
                          { "9","E","E","O","E","O" }    }  // nur einmal erzeugen spart Zeit.

   x := AScan( aCodeTable, {|cTmp| cTmp[1] == cFirstDigit }  )

   if x = 0
      cReturnCode := "'cFirstDigit'='"+cFirstDigit+"' ist ungltig !"
   else
      cReturnCode := aCodeTable[x,nManufakturerStelle+1]  // +1, da die ID auf 1. Stelle sitzt
   endif
return cReturnCode

#endif
