*#### ANSI .t.    !!!!
///////////////////////////////////////////////////////////////////////////////
//
//  Vom Xbase++ FormDesigner generierter Klassen Code
//    Erstellt am: 12.06.00 Zeit: 23.56.35
//
//  Contents  :
//    Diese Datei enthlt das Gerst zur Implementierung der Nutzungsebene.
//    Daher kann und soll diese Datei verndert werden.
//
///////////////////////////////////////////////////////////////////////////////

#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "xbpdev.ch"

#define HBPD_LANG_DE
*#define HBPD_LANG_EN

#IFDEF  HBPD_LANG_DE

   // Vorgabetexte deutsch - change the text for different languages
   #define HBPD_TITLE                 "Druckdialog"
   #define HBPD_PREVIEW_NEXTPAGE      "Seite ->"
   #define HBPD_PREVIEW_PREVIOUSPAGE  "<- Seite"
   #define HBPD_GRP_STATUSINFO        " Statusanzeige "
   #define HBPD_GRP_KOPIEN            " Kopien "
   #define HBPD_GRP_SEITEN            " Seitenauswahl "
   #define HBPD_GRP_DRUCKER           " Druckerauswahl "
   #define HBPD_FT_DRUCKER            "Name:"
   #define HBPD_FT_SEITEN             "Seiten:"
   #define HBPD_FT_SEI_HILFE          "Eingabe 1,5;7-9  druckt  1+5+7+8+9"
   #define HBPD_FT_KOPIEN             "Kopien:"
   #define HBPD_FT_KOP_INFO           "sortiert nach Dokumenten"
   #define HBPD_PB_PRINT              "Drucken"
   #define HBPD_PB_PREVIEW_1          "Vorschau ein"
   #define HBPD_PB_PREVIEW_0          "Vorschau aus"
   #define HBPD_CHKB_ALL_PAGE         "alle"
   #define HBPD_PB_CLOSE              "Schlieen"
   #define HBPD_SETINFO_ALL_DONE      "alles erledigt."
   #define HBPD_SETINFO_PRINT_TO      "drucken auf "
   #define HBPD_SETINFO_PRINT_WAIT    ", bitte warten ..."
   #define HBPD_SETINFO_KOPIE_AKT     "Kopie "
   #define HBPD_SETINFO_KOPIE_FROM    " von "
   #define HBPD_SETINFO_KOPIE_TOTAL   " wird gedruckt, bitte warten ..."
   #define HBPD_SETINFO_PREVIEW_WAIT  "Bitte warten, Seite "
   #define HBPD_SETINFO_PREVIEW_PAGE  " wird erzeugt..."
   #define HBPD_SETINFO_PREVIEW_SHOW1 "Vorschau Seite "
   #define HBPD_SETINFO_PREVIEW_SHOW2 " wird angezeigt."
   #define HBPD_ERR_NO_HBP_OBJ        "oHBPrinter in HBPrintDialog wurde nicht bergeben"
   #define HBPD_ERR_INFO_2_AUTOR      "Programmfehler an Autor melden" // NOT Hubert Brandel !
   #define HBPD_ERR_PRINTER_NOT_READY "Bitte Drucker berprfen !"

#ENDIF

#IFDEF  HBPD_LANG_EN

   // Vorgabetexte englisch - change the text for different languages
   #define HBPD_TITLE                 "Printdialog"
   #define HBPD_PREVIEW_NEXTPAGE      "Page ->"
   #define HBPD_PREVIEW_PREVIOUSPAGE  "<- Page"
   #define HBPD_GRP_STATUSINFO        " Statusinfo "
   #define HBPD_GRP_KOPIEN            " Copies "
   #define HBPD_GRP_SEITEN            " Select pages "
   #define HBPD_GRP_DRUCKER           " Select Printer "
   #define HBPD_FT_DRUCKER            "Name:"
   #define HBPD_FT_SEITEN             "Pages:"
   #define HBPD_FT_SEI_HILFE          "Input 1,5;7-9  will print  1+5+7+8+9"
   #define HBPD_FT_KOPIEN             "Copies:"
   #define HBPD_FT_KOP_INFO           "sorted by documents"
   #define HBPD_PB_PRINT              "Print"
   #define HBPD_PB_PREVIEW_1          "Preview on"
   #define HBPD_PB_PREVIEW_0          "Preview off"
   #define HBPD_CHKB_ALL_PAGE         "all"
   #define HBPD_PB_CLOSE              "Close"
   #define HBPD_SETINFO_ALL_DONE      "all done."
   #define HBPD_SETINFO_PRINT_TO      "print to "
   #define HBPD_SETINFO_PRINT_WAIT    ", please wait ..."
   #define HBPD_SETINFO_KOPIE_AKT     "Copy "
   #define HBPD_SETINFO_KOPIE_FROM    " from "
   #define HBPD_SETINFO_KOPIE_TOTAL   " printing, please wait ..."
   #define HBPD_SETINFO_PREVIEW_WAIT  "Please wait, page "
   #define HBPD_SETINFO_PREVIEW_PAGE  " creating ..."
   #define HBPD_SETINFO_PREVIEW_SHOW1 "Preview page "
   #define HBPD_SETINFO_PREVIEW_SHOW2 ""
   #define HBPD_ERR_NO_HBP_OBJ        "missing parameter oHBPrinter in HBPrintDialog"
   #define HBPD_ERR_INFO_2_AUTOR      "Program error, send info to programmer" // NOT Hubert Brandel !
   #define HBPD_ERR_PRINTER_NOT_READY "The printer is not ready !"

#ENDIF




******************************************************************************
* Von der Darstellungsklasse abgeleitete Klasse zur Implementierung der
* Programmlogik. Die Instanzvariablen der einzelnen Objekte sind in der
* Klasse _HBPrintDialog deklariert.
******************************************************************************
CLASS HBPrintDialog FROM _HBPrintDialog
   PROTECTED:
      VAR    aPrinterList
      VAR    nDefaultPrinter
      VAR    lPreviewOn
      VAR    nPreviewOffsetY     // SetPos()[2] + nPreviewOffsetY -> oXbp anpassen - modifiy
      VAR    nPreviewDivisor     // A4 Seite / nPreviewDivisor      -> Preview Size
      VAR    aPreviewSize
      VAR    aPreviewZoomFaktor
      VAR    aPreviewPageSize
      VAR    aPreviewPos
      VAR    nPreviewPage
      METHOD SetNextPreviewPage  // je nach Parameter 0=erste, 1=nchste oder -1=vorhergehende nPreviewPage bestimmen
                                 // depend on parameter set nPreviewPage, 0=first, 1=next, -1=previous page
      VAR    aMoveXbp
      VAR    aHideXbp

      VAR    dlgPreview
      VAR    pbPreviewNextPage
      VAR    pbPreviewPreviousPage
      VAR    oPreviewPS

      METHOD CenterDialog

   EXPORTED:
      VAR    oHBPrinter          // wird von der aufrufenden HBPrinter Klasse geladen
                                 // dieser kann alles mit HBPrinter:Print drucken,
                                 // aber es fehlt der PresentationSpace,
                                 // -> Drucken  -> fgt Drucker oPS in HBPrint:oPS ein
                                 // -> Vorschau -> fgt Window  oPS in HBPrint:oPS ein
                                 // HBPrinter:Print bergibt HBPrint:oPS an intern
                                 // an die GRA... Funktionen
      VAR    nPreviewSegID
      VAR    IsEnterPrint        // if .t. ENTER will print; default .f.
      VAR    IsEscClose          // if .t. ESC   will close; default .f.
      VAR    nPrintHotKey        // Print mit hotkey / with hotkey

      METHOD init
      METHOD close
      METHOD create
      METHOD print
      METHOD PreviewDraw
      METHOD preview
      METHOD GetPrintPages       // 1,3-5 -> "*1*3*4*5" -> ntrim(::nPageNo) $ GetPrintPages ...
      METHOD EventLoop
      METHOD PreviewRefresh
      METHOD PreviewShowNextPage
      METHOD PreviewShowPreviousPage
      METHOD SetInfo
      METHOD keyBoard
      METHOD GetSelectedPrinter

ENDCLASS

******************************************************************************
* Formular initialisieren
******************************************************************************
METHOD HBPrintDialog:init( oParent, oOwner, aPos, aSize, aPP, lVisible )
   local nDisplayX

   aSize := {425,360}

   * Methode der Superklasse rufen
   ::_HBPrintDialog:init( oParent, oOwner, aPos, aSize, aPP, lVisible )
   ::XbpDialog:title       := HBPD_TITLE
   ::XbpDialog:border      := XBPDLG_DLGBORDER
   ::XbpDialog:minButton   := .f.
   ::XbpDialog:maxButton   := .f.
   ::XbpDialog:hideButton  := .f.

   * Eigene Controls und Werte berechnen

   ::IsEnterPrint := .f.
   ::IsEscClose   := .f.
   ::nPrintHotKey := xbe_None     // appevent.ch

   ::lPreviewOn            := .f.
   nDisplayX := AppDesktop():currentSize()[1]
   do case
      case nDisplayX > 1024
           ::nPreviewDivisor       := 4
      case nDisplayX = 1024
           ::nPreviewDivisor       := 5
      otherwise
           ::nPreviewDivisor       := 6
   endcase
   ::nPreviewSegID         := NIL
   ::nPreviewPage          := NIL   // ermitteln beim Preview einschalten - calculate when preview starts
   ::aPreviewZoomFaktor    := 1     // noch nicht untersttzt - not used now
   * ::aPreviewSize        -> wird in create berechnet - calculate in ::create
   * ::aPreviewPageSize    -> wird in create berechnet - calculate in ::create
   * ::aPreviewPos         -> wird in create berechnet - calculate in ::create
   * ::nPreviewOffsetY     -> wird in create berechnet - calculate in ::create
   * ::aMoveXbp            ->  in ::create
   * ::aHideXbp            ->  in ::create


   ::dlgPreview := XbpDialog():new()  // Werte in create bergeben, da erst dort alle vorhanden
   ::dlgPreview:taskList   := .f.
   ::dlgPreview:titlebar   := .f.
   ::dlgPreview:maxButton  := .F.
   ::dlgPreview:minButton  := .F.
   ::dlgPreview:hideButton := .F.
   ::dlgPreview:sysMenu    := .F.
   ::dlgPreview:border     := XBPDLG_RAISEDBORDERTHIN_FIXED
   ::dlgPreview:title      := ""
   ::dlgPreview:clipParent := .F.
   ::dlgPreview:visible    := .F.

   ::pbPreviewNextPage     := XbpPushButton():new(::drawingArea)       // nheres in create - more info in create
   ::pbPreviewNextPage:caption := HBPD_PREVIEW_NEXTPAGE
   ::pbPreviewNextPage:clipParent := .T.
   ::pbPreviewNextPage:clipSiblings := .T.
   ::pbPreviewNextPage:pointerFocus := .F.
   ::pbPreviewNextPage:visible      := .F.
   ::pbPreviewNextPage:activate := {|| ::PreviewShowNextPage()}

   ::pbPreviewPreviousPage     := XbpPushButton():new(::drawingArea)   // nheres in create - more info in create
   ::pbPreviewPreviousPage:caption := HBPD_PREVIEW_PREVIOUSPAGE
   ::pbPreviewPreviousPage:clipParent := .T.
   ::pbPreviewPreviousPage:clipSiblings := .T.
   ::pbPreviewPreviousPage:pointerFocus := .F.
   ::pbPreviewPreviousPage:visible      := .F.
   ::pbPreviewPreviousPage:activate := {|| ::PreviewShowPreviousPage() }

   ::grpStatusinfo:caption := HBPD_GRP_STATUSINFO
   ::grpKopien:caption     := HBPD_GRP_KOPIEN
   ::grpSeiten:caption     := HBPD_GRP_SEITEN
   ::grpDrucker:caption    := HBPD_GRP_DRUCKER
   ::ftDrucker:caption     := HBPD_FT_DRUCKER
   ::ftSeiten:caption      := HBPD_FT_SEITEN
   ::ftSeitenHilfe:caption := HBPD_FT_SEI_HILFE
   ::ftKopien:caption      := HBPD_FT_KOPIEN
   ::ftKopienInfo:caption  := HBPD_FT_KOP_INFO
   ::pbPrint:caption       := HBPD_PB_PRINT
   ::pbPreview:caption     := HBPD_PB_PREVIEW_1
   ::chbAlleSeiten:caption := HBPD_CHKB_ALL_PAGE
   ::pbClose:caption       := HBPD_PB_CLOSE

   ::pbPrint:pointerFocus  := .f.
   ::pbPreview:pointerFocus:= .f.
   ::pbClose:pointerFocus  := .f.

   * set Pushbuttons

   ::pbPrint:activate      := {|| ::print()   }
   ::pbPreview:activate    := {|| ::preview() }
   ::pbClose:activate      := {|| PostAppEvent( xbeP_Close, , , self ) }

   ::sleSeiten:keyboard       := {|uP1,uP2,oSle| ::chbAlleSeiten:setData(Empty(oSle:editbuffer())) }

RETURN self

******************************************************************************
* Systemresourcen anfordern
******************************************************************************
METHOD HBPrintDialog:create( oParent, oOwner, aPos, aSize, aPP, lVisible )
   local cSearchPrinter
   * Methode der Superklasse rufen
   aPos := {-10000,-10000}
   ::_HBPrintDialog:create( oParent, oOwner, aPos , aSize, aPP, lVisible )

   // Infos vom vorhandenen Druckerobjekt verwenden !
   // Now use the existing printer object to get the infos
   ::aPrinterList := ::oHBPrinter:Printerlist()
   cSearchPrinter := ::oHBPrinter:devName
   ::aPreviewPageSize:= { ::oHBPrinter:nPaperSizeX, ::oHBPrinter:nPaperSizeY }

   ::nDefaultPrinter := ascan(::aPrinterList,{|cPrinterName| cPrinterName == cSearchPrinter })
                        // bei 1.01 kam es zu Fehlern, wenn Druckernamen von links gleich aber krzer waren,
                        // da standardmig der = Operator verwendet wird.

   aeval(::aPrinterList,{|cTxt|::lbDrucker:additem(cTxt)})
   ::lbDrucker:setData({::nDefaultPrinter},.t.)
   ::oHBPrinter:cPreViewPrinter := ::GetSelectedPrinter()
   ::lbDrucker:itemSelected := {| uNIL1, uNIL2, oXbp | ::print() }
   ::lbDrucker:itemMarked   := {| uNIL1, uNIL2, oXbp | ::oHBPrinter:cPreViewPrinter := ::GetSelectedPrinter(), ::PreviewRefresh() }

   * set default values
   ::sleKopien:setData("1")
   ::SetInfo()

   ::aPreviewSize    := { int(::aPreviewPageSize[1] / ::nPreviewDivisor) ,;
                          int(::aPreviewPageSize[2] / ::nPreviewDivisor)       }
                        // Vorlufig die Rnder des Standarddruckers verwenden
                        // In this release we will use the margins of default printer

   ::nPreviewOffsetY := int(::aPreviewSize[2] + ::grpStatusinfo:currentPos()[2] - ;
                            ::pbClose:currentPos()[2] - ::pbClose:currentSize()[2] )

   ::aPreviewPos     := { (::grpStatusinfo:currentPos()[1] + ::grpStatusinfo:currentSize()[1] + 7 ) ,;
                           ::grpStatusinfo:currentPos()[2] }

   * Preview Kontrolls - preview controls
   ::dlgPreview:create( ::drawingArea, ::drawingArea , {-10000,-10000}, ::aPreviewSize,;
                       { { XBP_PP_BGCLR, GRA_CLR_WHITE }, { XBP_PP_FGCLR, GRA_CLR_BLACK } } )

   ::pbPreviewPreviousPage:create(::drawingArea, ,{4,4} , {100,30})
   ::pbPreviewNextPage:create(::drawingArea, ,{::pbPreviewPreviousPage:currentPos()[1]+110,4} , {100,30})

   ::dlgPreview:drawingArea:paint := {|| ::PreviewDraw() }   // SEHR WICHTIG !!! VERY IMPORTANT !!!

   ::oPreviewPS := XbpPresSpace():new():create( ::dlgPreview:drawingArea:winDevice(),; // Devicecontext retten
                                                ::aPreviewPageSize ,GRA_PU_LOMETRIC )

   ::oPreviewPS:setViewPort( {0,0,::aPreviewSize[1]*::aPreviewZoomFaktor,::aPreviewSize[2]*::aPreviewZoomFaktor} )


   ::aMoveXbp        := { ::grpStatusinfo,::grpKopien,::grpSeiten,::grpDrucker,::ftDrucker,::ftSeiten,;
                          ::ftSeitenHilfe,::ftKopien,::ftKopienInfo,::pbPrint,::pbPreview,::lbDrucker,;
                          ::chbAlleSeiten,::sleSeiten,::sleKopien,::sleInfo,::pbClose }
                        // alle zu verschiebenden oXbp eintragen

   ::aHideXbp        := { ::dlgPreview, ::pbPreviewNextPage, ::pbPreviewPreviousPage }
                        // alle zu versteckenden oXbp eintragen


   * Formular zentrieren

   ::CenterDialog()

   * Formular anzeigen
   ::show()
   SetAppFocus(self)
   SetAppFocus(::lbDrucker)

RETURN self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:close()
   ::oHBPrinter:destroy()
   ::destroy()
return self
*----------------------------------------------------------------------------
METHOD HBPrintDialog:keyBoard(nKeyCode)

   do case
      case (::IsEnterPrint .and. ;
             ( nKeyCode = xbeK_ENTER     .or. nKeyCode = xbeK_RETURN .or. ;
               nKeyCode = xbeK_ALT_ENTER .or. nKeyCode = xbeK_ALT_RETURN   ) ;
           ) .or. nKeyCode = ::nPrintHotKey
           ::print()
      case nKeyCode = xbeK_ESC   .and. ::IsEscClose
           PostAppEvent( xbeP_Close, , , self )
      otherwise                                 // Rest nicht vergessen - for the REST
           ::_HBPrintDialog:keyBoard(nKeyCode)
   endcase

return self
*-------------------------------------------------------------
METHOD HBPrintDialog:EventLoop()
   local nEvent,mp1,mp2,oXbp
   mp1 := mp2 := oXbp := NIL     // keine Fehlermeldung bei /Wx... - no warnings with /Wx...
   nEvent := xbe_None
   DO WHILE nEvent != xbeP_Close
      nEvent := AppEvent( @mp1, @mp2, @oXbp )
      oXbp:handleEvent( nEvent, mp1, mp2 )
   ENDDO
return self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:CenterDialog()
   ::setPos( { (appDesktop():currentSize()[1] - ::currentSize()[1]) / 2 ,;
               (appDesktop():currentSize()[2] - ::currentSize()[2]) / 2 } )
return self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:SetNextPreviewPage(nDirection)   // "*4*2*3*1*" -> {1,2,3,4}
   local aPrintPages, cPrintPages, nPos, nPage

   DEFAULT nDirection to 0

   aPrintPages := {}
   cPrintPages := ::GetPrintPages()                   // "*4*2*3*1*" -> {4,2,3,1}
   do while ! empty( cPrintPages )
      do while left(cPrintPages,1)="*"
         cPrintPages := substr(cPrintPages,2)
      enddo
      if ! empty(cPrintPages)
         nPage := val(cPrintPages)
         if nPage > 0
            aadd(aPrintPages, nPage)
         endif
         if "*" $ cPrintPages
            cPrintPages := substr(cPrintPages,at("*",cPrintPages)+1)
         else
            cPrintPages := ""
         endif
      endif
   enddo
   aPrintPages := aSort(aPrintPages)

   if ! IsNil(::nPreviewPage)
      nPos := max(1,aScan(aPrintPages,::nPreviewPage))
   endif

   do case
      case nDirection < 0
           if empty(aPrintPages)
              ::nPreviewPage := max(1,::nPreviewPage-1)
           else
              ::nPreviewPage := max(1,aPrintPages[max(1,nPos-1)])
           endif
      case nDirection = 0
           if empty(aPrintPages)
              ::nPreviewPage := 1
           else
              ::nPreviewPage := max(1,aPrintPages[1])
           endif
      case nDirection > 0
           if empty(aPrintPages)
              ::nPreviewPage++
           else
              ::nPreviewPage := aPrintPages[min(len(aPrintPages),nPos+1)]
           endif
   endcase

return ::nPreviewPage

*-------------------------------------------------------------------------------
METHOD HBPrintDialog:PreviewShowNextPage()
   ::nPreviewSegID := NIL
   ::SetNextPreviewPage(1)
   ::PreviewDraw()
return self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:PreviewShowPreviousPage()
   ::nPreviewSegID := NIL
   ::SetNextPreviewPage(-1)
   ::PreviewDraw()
return self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:SetInfo(cTxt)
   local cAltTxt
   DEFAULT cTxt TO HBPD_SETINFO_ALL_DONE
   cAltTxt := ::sleInfo:getData(cTxt)
   ::sleInfo:setData(cTxt)
return cAltTxt
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:GetPrintPages()  // 1,3-5 -> "*1*3*4*5" -> ntrim(::nPageNo) $ GetPrintPages ...
   local cReturn, cTxt
   local aNum, cNum, nNum, cZei, nVon, nBis, x


   if ::chbAlleSeiten:getData() .or. empty(::sleSeiten:getData())
      cReturn := " "                                               // alle drucken - print all
   else
      cTxt    := alltrim(::sleSeiten:getData())
      cTxt    := strTran(cTxt," ","")     // Blanks entfernen - remove blanks
      do while ".." $ cTxt
         cTxt := strTran(cTxt,"..","-")   // Syntax von Tab.Kalk. auch erlauben - .. is like -
      enddo
      do while "--" $ cTxt
         cTxt := strTran(cTxt,"--","-")   // Syntax von Tab.Kalk. auch erlauben
      enddo
      cTxt := strTran(cTxt,";",",")    // Syntax von MS Word   - ; is like ,
      cTxt := strTran(cTxt,".",",")    // Flexibel bleiben     - . is like ,
      cTxt := strTran(cTxt,"/",",")    // Flexibel bleiben     - / is like ,
      cTxt := strTran(cTxt,"*",",")    // Flexibel bleiben
      cTxt := strTran(cTxt,"|",",")    // Flexibel bleiben
      do while ",," $ cTxt
         cTxt := strTran(cTxt,",,",",")   // Suche verkrzen.
      enddo
      cNum := ""
      aNum := {}

      do while .t.
         cZei := left(cTxt,1)
         if cZei $ "0123456789" .and. ! cZei == ""
            cNum += cZei
            cTxt := substr(cTxt,2)
         else
            nNum := val(cNum)
            cNum := ""
            if ! empty(nNum)
               aadd(aNum,nNum)              // BGnr merken
            endif
            do case
               case cZei == ""
                    // alles eingelesen und gespeichert, Schleife verlassen
                    exit
               case cZei = ","
                    // diese Zahl ist eingelesen, gespeichert
                    cTxt := substr(cTxt,2)                   // Trennzeichen entfernen
               case cZei = "-"
                    cTxt := substr(cTxt,2)                   // Trennzeichen entfernen
                    // auffllen
                    nVon := nNum + 1
                    nBis := val(cTxt)-1
                    for x := nVon to nBis
                        aadd(aNum,x)
                    next
               otherwise
                    cZei := ""
                    cTxt := substr(cTxt,2)                   // Trennzeichen entfernen
            endcase
         endif
      enddo

      aNum := aSort(aNum)                   // Wichtig:   Aufsteigende Seitenzahlen wegen IsPageToPrint
                            // Important: Right sequenze from low to high numbers because
                            //            of IsPageToPrint

      cReturn := "*"
      aeval(aNum,{|nSeite| cReturn += (alltrim(str(nSeite,5,0))+"*") } )

   endif

RETURN cReturn
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:print()
   local cDruckername, nKopien, x, oNeuPS
   if isnil(::oHBPrinter)
      msgbox(HBPD_ERR_NO_HBP_OBJ , HBPD_ERR_INFO_2_AUTOR ) // NOT HUBERT BRANDEL !!!!
      setAppFocus(self)
   endif

   cDruckername    := ::GetSelectedPrinter()
   nKopien         := MAX(1,val(::sleKopien:getData()))

   ::SetInfo(HBPD_SETINFO_PRINT_TO + cDruckername + HBPD_SETINFO_PRINT_WAIT )

   oNeuPS          := ::oHBPrinter:PrinterPS(cDruckername)

   if ::oHBPrinter:IsPrinterError(oNeuPS:device())
      msgbox( HBPD_ERR_PRINTER_NOT_READY )
      setAppFocus(self)
   else

      ::oHBPrinter:oPS := oNeuPS
      ::oHBPrinter:SetPrintPages( ::GetPrintPages() )             // Druckseiten festlegen - define pages to print

      for x := 1 to nKopien
          if nKopien > 1
             ::SetInfo( HBPD_SETINFO_KOPIE_AKT  + ntrim(x) +;
                        HBPD_SETINFO_KOPIE_FROM + ntrim(nKopien) +;
                        HBPD_SETINFO_KOPIE_TOTAL )
          endif
          ::oHBPrinter:startdoc()
          ::oHBPrinter:print()
          ::oHBPrinter:enddoc()
      next
   endif

   ::SetInfo()

   if ::lPreviewOn                             // Preview aktiv, oPS setzen - // Preview aktiv, set oPS
      ::oHBPrinter:oPS := ::oPreviewPS         // HBPrinter mit Preview verbinden - connect HBPrinter with Preview
   endif

RETURN self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:preview()
   local nPreviewOffsetY
   static aPreviewOffSize:=NIL, aPreviewOnSize:=NIL

   nPreviewOffsetY := ::nPreviewOffsetY  // ::nPreviewOffsetY ist protected, kann also nicht in Codeblock verwendet werden
                                         // ::nPreviewOffsetY is protected, no access to it in a codeblock
   if isnil(::oHBPrinter)
      msgbox(HBPD_ERR_NO_HBP_OBJ , HBPD_ERR_INFO_2_AUTOR ) // NOT HUBERT BRANDEL !!!!
      setAppFocus(self)
   endif

   if IsNil(::nPreviewPage)
      ::SetNextPreviewPage( 0 ) // 1. Preview Page festlegen - set first preview page
   endif

   ::hide()                   // Flackern verhindern - don't flicker on screen

   if ::lPreviewOn            // Preview ist an und soll aus geschaltet werden - from ON to OFF
      ::lPreviewOn := .f.
      ::pbPreview:setCaption( HBPD_PB_PREVIEW_1 )

      ::setSize(aPreviewOffSize)
      aeval(::aMoveXbp,{|oXbp| oXbp:setPos({oXbp:currentPos()[1],oXbp:currentPos()[2]-nPreviewOffsetY}) } )
      aeval(::aHideXbp,{|oXbp| oXbp:hide() } )
   else                      // Preview ist aus und soll angeschaltet werden.
      if IsNil(aPreviewOffSize)
         aPreviewOffSize := ::currentSize()
      endif
      if IsNil(aPreviewOnSize)
         aPreviewOnSize  := { aPreviewOffSize[1]+::aPreviewSize[1]+10, aPreviewOffSize[2]+nPreviewOffsetY }
      endif
      ::lPreviewOn := .t.
      ::pbPreview:SetCaption( HBPD_PB_PREVIEW_0 )
      ::setSize(aPreviewOnSize)
      aeval(::aMoveXbp,{|oXbp| oXbp:setPos({oXbp:currentPos()[1],oXbp:currentPos()[2]+nPreviewOffsetY}) } )
      ::dlgPreview:setPos(::aPreviewPos)
      * ::dlgPreview:setSize(::aPreviewSize)
      aeval(::aHideXbp,{|oXbp| oXbp:show() } )
   endif

   ::CenterDialog()
   ::show()                  // Flackern verhindern - don't flicker on screen

RETURN self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:PreviewDraw()
   local nSegID, aAreaAttr, aOldAttr
   if ::lPreviewOn

      ::SetInfo(HBPD_SETINFO_PREVIEW_WAIT + ;
                ntrim(::nPreviewPage) + ;
                HBPD_SETINFO_PREVIEW_PAGE )

      if IsNil(::nPreviewSegID)                // noch nicht gespeichert - not stored
         ::oHBPrinter:oPS := ::oPreviewPS      // HBPrinter mit Preview verbinden - connect HBPrinter with Preview
         nSegID := GraSegOpen(::oHBPrinter:oPS)
         aAreaAttr := Array( GRA_AA_COUNT )        // alten Inhalt lschen - clear old contens
         aAreaAttr[GRA_AA_COLOR] := GRA_CLR_WHITE
         aOldAttr := ::oPreviewPS:setAttrArea(aAreaAttr)
         GraBox(::oPreviewPS,{0,0},::aPreviewPageSize,GRA_FILL )
         ::oPreviewPS:setAttrArea(aOldAttr)

         ::oHBPrinter:SetPrintPages( ::nPreviewPage )  // Preview Seite festlegen - define next page for preview
         ::oHBPrinter:PreviewDrawIsActive := .t.
         ::oHBPrinter:print()
         ::oHBPrinter:PreviewDrawIsActive := .f.

         GraSegClose(::oHBPrinter:oPS)
         ::nPreviewSegID := nSegID
      else
         GraSegDraw(::oPreviewPS,::nPreviewSegID)      // ::oPreviewPS da ::oHBPrinter:oPS evenuell schon gendert wurde
                                                       // ::oPreviewPS could be changed to PrinterPS
      endif
      if ::nPreviewPage >  ::oHBPrinter:nPageNo
         ::nPreviewPage := ::oHBPrinter:nPageNo +1
      endif

      ::SetInfo(HBPD_SETINFO_PREVIEW_SHOW1 + ;
                ntrim(::nPreviewPage)+;
                HBPD_SETINFO_PREVIEW_SHOW2 )

   endif
RETURN self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:PreviewRefresh()
   ::nPreviewSegID := NIL
   ::PreviewDraw()
RETURN self
*-------------------------------------------------------------------------------
METHOD HBPrintDialog:GetSelectedPrinter()
   local cPrinterName, aWahl
   cPrinterName := ""
   aWahl := ::lbDrucker:getData()
   if len(aWahl) > 0
      cPrinterName := ::aPrinterList[aWahl[1]]
   endif
return cPrinterName


*---------------------------------------------------------------------------
static function ntrim( nVar )
return strTran(alltrim( str( nVar ) ),".",",")

