#include "Xbp.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "gra.ch"
#include "hbprintpdf.ch"

// ANSI Text ! 

proc main
   local oHBPDF
   local cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe"
   local cPDF  := "BoxTest.pdf"
   local cPfad := cAppPath()  // ot4xb
   local cBarCode, nY, nX, nStart, x, y, nSleep := 0, nRow := 3
   local cNormFont     := "Verdana", ;
         cBoldFont     := "Verdana [Bold]", ;
         cItalicFont   := "Verdana [Italic]", ;
         nNormalFont   := 0, ;
         nBoldFont     := 0, ;
         nUnderscoreFont := 0
   Local aBoxAttr := {}, ;
         nOffset  := NIL , ;
         nDrawOptions := NIL
   cls
   delete file (cPDF)
   ? "Teste HBPrintPDF - SetFillColor"
   ?
   ? "bitte Taste drcken"

   inkey(0)


   oHBPDF := HBPrintPDF():new():create(GetQuickPDFLizenzKey()) // GetQuickPDFLizenzKey() / cKey
   if oHBPDF:IsOK
      oHBPDF:SetPageSize("A4")
      oHBPDF:SetPageSize("A4 Landscape")
      nBoldFont := oHBPDF:AddTrueTypeFont(cBoldFont,0)
      nUnderscoreFont := oHBPDF:AddTrueTypeFont(cItalicFont,0)
      nNormalFont := oHBPDF:AddTrueTypeFont(cNormFont,0)
      oHBPDF:SetTextCpi(20)
      oHBPDF:SetCPI(20)
      nDrawOptions := DRAWOPTIONS_FILL // DRAWOPTIONS_ALL

      aBoxAttr := oHBPDF:GetColorRGB(GRA_CLR_PALEGRAY)
      oHBPDF:SetFillColor(aBoxAttr[1], aBoxAttr[2], aBoxAttr[3])
      oHBPDF:SayBox(nRow,10,nRow+5,45,nOffset,nDrawOptions)
      nRow += 10
      aBoxAttr := {222, 184, 135}
      oHBPDF:SetFillColorRGB(aBoxAttr[1], aBoxAttr[2], aBoxAttr[3])
      oHBPDF:SayBox(nRow,10,nRow+5,45,nOffset,nDrawOptions)

      oHBPDF:SaveToFile(cPfad+cPDF)
      oHBPDF:destroy()
      ? "destroy - 10 Sekunden warten, oder Taste drcken"
      inkey(10)


      if file(cPfad+cPDF)
         if ! file(cAcrobat)
            cAcrobat := GetStandardProgramm(cPDF, cPfad)
         endif
         runshell(cPfad+cPDF,cAcrobat,.t.)
      endif
   endif   // isOK


return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)   // cPath force to EXE
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if empty(cPath)
      cPath := cAppDir()
   endif
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe
*--------------------------------------------------------------------------
function GetQuickPDFLizenzKey()
   local cKey := GetEnv("QUICKPDF_08_REGKEY")
return cKey

