// HBPrintPDF8 => QuickPDFDLL08xx.dll  (8.xx)
//
// Version 8.10 - 2013-11-13

#include "Xbp.ch"
#include "gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "directry.ch"
#include "HBPrintPDF.CH"

#define MIN_DLL_VERSION 814 // 8.14
#define MAX_DLL_VERSION 899 // 8.99

// ANSI QUELLCODE !!!

/*
******************************************************************************

   deutsch / german / english will follow

   HBPrintPDF ist freeware und darf ohne Einschrnkung verwendet werden.

   bentigt          QuickPdf DLL    QuickPDFDLL08xx.dll  (8.14ff)
              Lizenzschlssel von    www.QuickPDF.com

                        OT4XB.DLL >= 001.005.012.021   from   www.xbwin.com

   Ohne Pablo Botella Navaro und seine OT4XB wre dies nicht mglich gewesen.
   Ich habe die Methoden aus seiner TQuickPdf wrapper class kopiert und
   nur die Rckgabewerte angepasst wo es ntig war. Das hat viel Zeit gespart.
   *HB* markiert genderte TQuickPdf Methoden

   Da die Lizenz fr die Hauptversion 8.xx gilt wird diese Klasse immer
   auf die neueste Version angepasst. Man kann eine ltere DLL benutzen
   solange man sich auf deren Methoden beschrnkt.
   Die Hauptversionsnummer von HBPrintPDF wurde auf die ntige QuickPDF Hauptversion gendert.

   Neue Versionen:    www.familie-brandel.de
                      www.xbaseforum.de          (nur in deutsch)

  ------------------------------------------------------------
    TQuickPdf wrapper class over the QuickPDFDLL0719.dll
          -> http://www.quickpdflibrary.com
    Author: Pablo Botella Navarro ( http://www.xbwin.com ) -
          -> http://www.xbwin.com.php?ng=/ot4xb.examples/36
  ------------------------------------------------------------

   WICHTIG ! Es gilt die Beschreibung der DLL (PDF) mit folgenden Ausnahmen:
             1. Der Parameter InstanceID wird intern verwendet, also NIE angeben.
             2. Die Namen der Methoden entsprechen denen der ActiveX Beschreibung,
                enthalten also NICHT den Vorsatz   QuickPDF... siehe unten
             3. In Basic und Delphi wird in IF Abfragen eine 0 als .f.
                und <> 0 als .t. verarbeitet. Wenn eine Methode diesen
                QuickPDF Rckgabewert nicht von numerisch auf logisch umsetzt,
                muss man o:IsFalse(...) und o:IsTrue(...) verwenden.
                Beispiel:   if o:IsTrue(o:QuickPDFFunction()) entspricht o:QuickPDFFunction()#0
                :IsFalse(...) und :IsTrue(...) stimmen immer.
             4. Sollten Sie Fehler finden, bitte ich um Mitteilung und ein kleines Beispiel.
                Ich bemhe mich diese schnell zu beseitigen.
             5. In der Beschreibung kann man Funktionen sehen, die zwar char * oder string etc.
                zurckgeben, aber tatschlich nur binre Daten (8bit) enthalten.
                Diese werden nicht mit ::ReadString() in OEM/ANSI bersetzt und mssen
                als BINR Daten verwendet werden. Ich habe dafr bis jetzt keine
                Verwendung und somit auch keinen Test oder Beispiele.
                Falls Sie welche freigeben mchten, nur her damit.
                Ihr Name als Autor knnen Sie oben eintragen ich werde diesen nicht entfernen.
             6. HBPrintPDF:SetAnsiMode(...) gibt immer den eingestellten iAnsiMode zurck.

   Version 8.00 - 2012-07-31

   * QuickPDF 8.x nutzt normalerweise nur noch UNICODE (WIDESTRING) mit 16-Bit (=> UTF-16)
     Da Xbase++ dies nicht direkt untersttzt und auch kompatible A-Functionen (ANSI-Format)
     angeboten werden, verwende ich diese. Die QuickPDF-DLL regelt die Konvertierung ber die Funktion:

     SetAnsiMode(NewAnsiMode) 0 = Aktuelle (Ansi) codepage wird verwendet.       *** Standard ***
                              1 = Unicode Strings mssen UTF-8 codiert werden.

     Wer bisher die Standardeinstellung verwendet hat ( ::UseAutoConvUTF8 := .t. mit Xbase++ Strings),
     braucht sich um nichts zu kmmern. Die Vorgabe (::UseAutoConvUTF8 := .t. und ::SetAnsiMode(0) )
     wandelt Xbase++ Strings automatisch in den ntigen Unicode String um.
     Wer bisher ::UseAutoConvUTF8 := .f. verwendet hat und teilweise UTF8 bergeben hat, muss
     nun alles in UTF8 bergeben. Die Zeichen chr(0) bis chr(127) sind in OEM / ANSI / UTF8 identisch
     und knnen somit ohne nderung weiter bergeben werden, ansonsten muss man richtig kodieren.
     ::ForceUTF8() und ::ReadUTF8() knnen nun unabhngig von der ::UseAutoConvUTF8 Einstellung
     genutzt werden um OEM/ANSI Strings nach UTF8 und umgekehrt umzusetzen.
     Die durchgngige Verwendung von Ansi (SET CHARSET TO ANSI) im Programm und Richtung DLL
     vermeidet Umsetzungen und somit eventuelle Probleme.
     ::SetAnsiMode(0) => ::UseAutoConvUTF8 := .t.
     ::SetAnsiMode(1) => ::UseAutoConvUTF8 := .f.
     ::SetAnsiMode()  => 0 oder 1 je nach ::UseAutoConvUTF8 - in der DLL kann man den Zustand nicht abfragen
     UTF8 sollte man nur verwenden wenn es unbedingt ntig ist !

   * Grundstzlich sollte die Bibliothek schon immer mit OEM und ANSI Einstellung (SET CHARSET) funktionieren.
     Durch einen Fehler war dies bisher bei SET CHARSET TO OEM und Umlauten bisher nicht der Fall.
     Dies wurde nun korrigiert: ForceAnsi(), ReadString()

   * ACHTUNG, genderte Parameter ==> ExtractFilePages(), LoadFromFile(..., password) etc.
     Die Vorgehensweise bei der Verwendung von Passwrtern wurde gendert:
     neue Parameter  =>  LoadFromFile(..., password) ...
     leider in einem Fall auch so, dass der neue Parameter zwischen bestehende kommt:
     ExtractFilePages(..., password, ...) *** ACHTUNG ***
     LoadFromFile() etc. liefert jetzt .t./.f. statt einem numerischen Fehler zurck.
     Wenn Sie Passwrter oder ExtractFilePages() verwendet haben, mssen Sie ihr Programm anpassen !

   * Einige Funktionen wurden umbenannt. Fr neue Programme sollte man die neuen Funktionen verwenden, aber
     HBPrintPDF untersttzt auch weiterhin die alten Namen (diese rufen die neuen Funktionen auf).

   * Es gibt ein Dokument von Denebu mit Hinweisen  ==>  Quick PDF Library 8 Upgrade Warnings.pdf
     ==> http://www.quickpdflibrary.com/docs/Quick%20PDF%20Library%208%20Upgrade%20Warnings.pdf
     Das meiste macht meine Klasse aber intern und braucht daher nicht beachtet zu werden.

   * Genderte Methoden im Detail:
     - GetPrinterNameA(cPrinters)               =>  GetPrinterNameA() kann nun auch der Rckgabewert von GetLatestPrinterNames() bergeben werden.
     - LoadFromFile(..., password) und LoadFromString(..., password) => 8.x: .t. / .f.  statt 7.x: 0=error, 1=OK, 2=PW error
     - ExtractFilePages(..., password, ...)     *** neuer Parameter auf 2. Stelle, new parameter as 2. parameter :-(   *** Anpassung ntig *** need changes ***
     - GetFileMetadata(..., password)
     - SetAdvancePassword() wurde entfernt, bitte Programme anpassen *** SetAdvancePassword() has been removed, change your program. ==> LoadFromFile(..., password)
     - GetObjectSource        => GetObjectToString
     - SetObjectSource        => SetObjectFromString
     - GetPageContent         => GetPageContentToString
     - SetPageContent         => SetPageContentFromString
     - DAGetPageContent       => DAGetPageContentToString
     - DAGetObjectSource      => DAGetObjectToString
     - ExtractFilePageContent => ExtractFilePageContentToString
     - SetLayerOptional       => SetContentStreamOptional
     - LayerCount             => ContentStreamCount
     - CombineLayers          => CombineContentStreams
     - NewLayer               => NewContentStream
     - SelectLayer            => SelectContentStream
     - EditableLayer          => EditableContentStream
     - MoveLayer              => MoveContentStream
     - DeleteLayer            => DeleteContentStream
     - LayerSafe              => ContentStreamSafe
     - UseUnsafeLayers        => UseUnsafeContentStreams
     - EncapsulateLayer       => EncapsulateContentStream
     - RemoveSharedLayers     => RemoveSharedContentStreams

    * Neue Methoden von QuickPDF werden hier nicht mehr aufgezhlt und in der Klassendefinition werden alle Methoden jeweils sortiert.
      In der PDF kann man nach neuen Methoden suchen z.B. nach "8." oder "8.16".

      SetTextColorXB(nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
      GetErrorText(nErrorCode)   // QuickPDF Fehlermeldungen, aktuell nur in englisch ...
      nCharSet                   // ::nCharSet := set(_SET_CHARSET) // diese PRG Datei in Ansi codiert !
      Points2Unit()              // Points in aktuelle Einheit (::nDefaultMeasurementUnits) umrechnen
      GetUnitText()              // Aktuelle Einheit (::nDefaultMeasurementUnits) ausgeben 0 = points, 1 = mm, 2 = inch
      PathFormatPdf              // c:\myPath\myDoc.pfd ==> /c/myPath/myDoc.pfd

   Version 8.10 - 2013-11-12

    * ExtractFilePages(sInputFileName, sOutputFileName, sRangeList) => ExtractFilePages(sInputFileName, sPassword, sOutputFileName, sRangeList)

      if pcount()=3 // alte Syntax, old syntax
         sRangeList      := sOutputFileName
         sOutputFileName := sPassword
         sPassword       := ""
      endif

    * ...FromString() and ...ToString() parameter verbessert ByteArray statt String !


******************************************************************************

   englisch / english

   needs             QuickPdf DLL    QuickPDFDLL08xx.dll  (8.14ff.)
                 Licence key from    www.QuickPDF.com

                        OT4XB.DLL >= 001.005.012.021   from   www.xbwin.com

   HBPrintPDF is freeware.

   Thanks to Pablo Botella Navaro and his OT4XB and the TQuickPdf wrapper class
   I used his methods to save time and changed the return values where
   we need arrays or logical return values.
   *HB* will mark the changed TQuickPdf Methods

   The license key is valid for versions 8.xx, so this class will be always
   changed to the newest version from 8.xx. You can use it with a older DLL
   as long as you don't use the new functions.
   I changed the HBPrintPDF mainversion to the needed QuickPDF mainversion.

   new version:  www.familie-brandel.de

  ------------------------------------------------------------
    TQuickPdf wrapper class over the QuickPDFDLL0719.dll
          -> http://www.quickpdflibrary.com
    Author: Pablo Botella Navarro ( http://www.xbwin.com ) -
          -> http://www.xbwin.com/forum.php?ng=/ot4xb.examples/36
  ------------------------------------------------------------

   IMPORTANT !  Please use the quickpdf reference guide (PDF) for info and help.
                These things are different:
             1. Ignore the parameter InstanceID, the class will handle it inside.
             2. The method names are the same as those from ActiveX.
                No leading QuickPDF... just use the function name. See the code ...
             3. Basic and Delphi use numeric parameters instead of logical in Xbase
                They use values as 0 = False and <> 0 is True.
                I changed the QuickPDF return value in this case in .t. / .f. ...
                If the method in this class does not change the return value, you
                have to use these methods:     o:IsFalse(...) or o:IsTrue(...)
                Example:  if o:IsTrue(o:QuickPDFFunction()) is equal to o:QuickPDFFunction()#0
             4. If you find errors, please let me know and I will correct them.
             5. While all text parameters in 8.x now use widestring, there are still
                some char * or string types. These are binary (8bit) values
                and not real strings. They have to be handled with care and
                not translatet with ::ReadString() into OEM/ANSI.
                I did never use these and have no examples, if you will offer
                something for free, let me know. You can put your name etc.
                in the code if you want, I will not remove it.
             6. HBPrintPDF:SetAnsiMode(...) will allways return the iAnsiMode.

   Version 8.00 - 2012-07-31

   * QuickPDF 8.x normaly use UNICODE (WIDESTRING) with 16-Bit (=> UTF-16)
     Xbase++ use Ansi or OEM format, so I call the A-functions (ANSI-format).
     The QuickPDF-DLL use this function to control the conversion:

     SetAnsiMode(NewAnsiMode)    0 = Conversion using the current code page *** default ***
                                 1 = Conversion using UTF-8 encoding

     If you have used the default values ( ::UseAutoConvUTF8 := .t. with Xbase++ Strings),
     you don't have to care about it, its OK.
     The default values (::UseAutoConvUTF8 := .t. und ::SetAnsiMode(0) ) take your
     Xbase++ strings and convert it to the widestrings.
     If you changed to ::UseAutoConvUTF8 := .f. and used UTF8 strings, than you have
     to convert all strings (not 8-Bit data buffers) to UTF8.
     If your strings only use chr(0) to chr(127) there is no problem,
     because these chars are the same in  OEM / ANSI / UTF8.
     ::ForceUTF8() and ::ReadUTF8() now convert without care about ::UseAutoConvUTF8 setting.
     You can use both to force the conversation to and from UTF8.
     If you don't realy need UTF8, then use ANSI (SET CHARSET TO ANSI) in your program
     and in HBPrintPDF, this prefents from conversation problems.
     ::SetAnsiMode(0) => ::UseAutoConvUTF8 := .t.
     ::SetAnsiMode(1) => ::UseAutoConvUTF8 := .f.
     ::SetAnsiMode()  => 0 or 1 depends on ::UseAutoConvUTF8 - in the QuickPDF-DLL you can not call without parameter.
     UTF8 should only be used if you realy need it.

   * HBPrintPDF should support OEM and ANSI (SET CHARSET) programs, but with
     SET CHARSET TO OEM and chr(128) ff. (german umlauts etc.) this was not true.
     This error is now fixed, ForceAnsi(), ReadString() will handle both correct.

   * ATTENTION, changed parameters ==> ExtractFilePages(), LoadFromFile(..., password) etc.
     If you have used PDF with password or ExtractFilePages() than you have to change
     your code, because the changed the way to handle and have now new parameters.
     One between old ones =>  LoadFromFile(..., password) ...
     ExtractFilePages(..., password, ...) *** ATTENTION ***
     ::LoadFromFile() now returns .t. or .f.

   * Some functions have been renamed. I do support both names in HBPrintPDF.
     So you don't have to change old code because of these, but can use the new
     names in new code.

   * Have a look into the  "Quick PDF Library 8 Upgrade Warnings.pdf"
     ==> http://www.quickpdflibrary.com/docs/Quick%20PDF%20Library%208%20Upgrade%20Warnings.pdf
     Most of the changes are internaly handled in HBPrintPDF.

   * Changes in detail:
     - GetPrinterNameA(cPrinters)               =>  GetPrinterNameA() the new parameter kann now use GetLatestPrinterNames() to offer a default printer.
     - LoadFromFile(..., password) und LoadFromString(..., password) => 8.x: .t. / .f.  was 7.x: 0=error, 1=OK, 2=PW error
     - ExtractFilePages(..., password, ...)     *** new parameter as 2. parameter :-(   *** need changes ***
     - GetFileMetadata(..., password)
     - SetAdvancePassword()                     *** has been removed, change your program. ==> LoadFromFile(..., password)
     - GetObjectSource        => GetObjectToString
     - SetObjectSource        => SetObjectFromString
     - GetPageContent         => GetPageContentToString
     - SetPageContent         => SetPageContentFromString
     - DAGetPageContent       => DAGetPageContentToString
     - DAGetObjectSource      => DAGetObjectToString
     - ExtractFilePageContent => ExtractFilePageContentToString
     - SetLayerOptional       => SetContentStreamOptional
     - LayerCount             => ContentStreamCount
     - CombineLayers          => CombineContentStreams
     - NewLayer               => NewContentStream
     - SelectLayer            => SelectContentStream
     - EditableLayer          => EditableContentStream
     - MoveLayer              => MoveContentStream
     - DeleteLayer            => DeleteContentStream
     - LayerSafe              => ContentStreamSafe
     - UseUnsafeLayers        => UseUnsafeContentStreams
     - EncapsulateLayer       => EncapsulateContentStream
     - RemoveSharedLayers     => RemoveSharedContentStreams

    * I don't list new QuickPDF methods here. All methods are sorted in the class definition.
      Please search in the PDF about "8." or "8.16" to find new functions.

      SetTextColorXB(nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
      GetErrorText(nErrorCode)   // QuickPDF errortext
      nCharSet                   // ::nCharSet := set(_SET_CHARSET) // this PRG file is in Ansi codepage !
      Points2Unit()              // calculate from points to the current unit (::nDefaultMeasurementUnits)
      GetUnitText()              // returns the text for the current unit (::nDefaultMeasurementUnits) 0 = points, 1 = mm, 2 = inch

   Version 8.10 - 2013-11-13

    * ExtractFilePages(sInputFileName, sOutputFileName, sRangeList) => ExtractFilePages(sInputFileName, sPassword, sOutputFileName, sRangeList)

      if pcount()=3 // alte Syntax, old syntax
         sRangeList      := sOutputFileName
         sOutputFileName := sPassword
         sPassword       := ""
      endif

    * ...FromString() and ...ToString() parameter verbessert ByteArray statt String !

******************************************************************************

   Beispiel / Example


   cQuickPDFKey := "............." or read from .CH

   // Standard DLL von TQuickPdf                // use the standard DLL from TQuickPdf
   oHBPrintPDF  := HBPrintPDF():new():create(cQuickPDFKey)
   if oHBPrintPDF:IsOK                          **** wichtig ! Important
      ...

   // oder eigene festlegen                     // or define your own DLL
   oHBPrintPDF  := HBPrintPDF():new()
   oHBPrintPDF:cDLLName := "QuickPDFDLL????.dll" // TESTED:  QuickPDFDLL0816.dll ff.
   ...
   oHBPrintPDF:create(cQuickPDFKey)
   if oHBPrintPDF:IsOK                          **** wichtig ! Important
      oHBPrintPDF:DrawText(20,30, "Hello world with HBPrintPDF (QuickPDF)")
      // Speichern, SAVE ?
      oHBPrintPDF:SaveToFile(cPfad+cPDF)
      // Drucken, Printing ?
      oHBPrintPDF:PrintDocument(cPrinterName, 1, oHBPrintPDF:PageCount())
      // Variablen zurcksetzen, aber QuickPDF wird erst beim Programmende entladen.
      // Reset vars, but the QuickPDF will not give back the memory until EXE quits.
      oHBPrintPDF:destroy()
   endif

   Have fun :-)

   Hubert

*/

******** QuickPDF Lizenz Key / License Key ********* HOW TO *****
*
* entweder bei CREATE( cLizenzKey ) angeben, oder eine Funktion wie GetQuickPDFLizenzKey()
* nutzen um ihn zu ermitteln und zurckzugeben.
*
* first option CREATE( cLicenseKey ) or use a function like GetQuickPDFLizenzKey() to
* get a valid key. More infos about it in the Quick PDF Helpfile => UnlockKey(LicenseKey)
*
/*
oHBPrintPDF:create(GetQuickPDFLizenzKey())
...
function GetQuickPDFLizenzKey()
   local cKey := "...."
   // OR ...
   cKey := GetEnv("QUICKPDF_08_REGKEY")
return cKey
...
oHBPrintPDF:create(GetEnv("QUICKPDF_08_REGKEY"))

*/

//-----------------------------------------------------------------------------------------
function MsgFunctionRemoved(cName)
   DEFAULT cName TO "???"
   msgbox("Fehler: '"+cName+"' existiert nicht mehr, bitte Fehler an Autor melden."+CRLF+;
          "Error:  '"+cName+"' has been removed, program have to be changed.", "Programmfehler / Programerror")
return NIL
//-----------------------------------------------------------------------------------------

CLASS HBPrintPDF

   PROTECTED

   VAR    nLineFeed             // method LineFeed(6) -> 6 * nLineFeed = Zeilenvorschub - line feed
                                // nLineFeed wird mit dem Standardabstand des aktuellen Font geladen !
                                //  "        will be set to the font hight of the standard font
                                // ->  ::SetTextSize()  ->  ::nLineFeed  in mm, points or inch
   VAR    nLineWidth, nDefaultLineWidth
   VAR    nLPI, nCPI
   VAR    nAlign                // speichert aktuelle Ausrichtung, save the current Alignment
   VAR    _hdll_                // DLL handle
   VAR    _id_                  // InstanceID
   VAR    nPageNo               // internal Pagenumber !
   VAR    aImageID              // Array zum Speichern von ImagesID und Name (z.B. Dateiname)
                                // array to save ImageID and name
   VAR    nAktiveFillColorRed, nAktiveFillColorGreen, nAktiveFillColorBlue
   VAR    nOldTextColorRed, nOldTextColorGreen, nOldTextColorBlue  // SetTextColor() -> save 1 Time !
   VAR    nOldTextUnderlineColorRed, nOldTextUnderlineColorGreen, nOldTextUnderlineColorBlue
   VAR    nOldTextHighlightColorRed, nOldTextHighlightColorGreen, nOldTextHighlightColorBlue

   VAR    nTextUnderline        // SetTextUnderline(nOption) nTextUnderline := nOption
   VAR    nCharSet              // ::nCharSet := set(_SET_CHARSET)


   EXPORTED

   VAR IsOK                     // *** Nach Create testen  // TEST after Create !!!

   VAR cErrorLanguage, cErrorNoInstance, cErrorLoadDll, cErrorNoLicenseOK, cErrorNoLicenseKey, cErrorNotMinVerOT4XB
   VAR SayOrigin0

   VAR cQuickPdfDllName
   VAR nDefaultPageSize
   VAR nDefaultMeasurementUnits
   VAR nPageDefaultOrigin
   VAR cDLLName
   VAR nDefaultStandardFontSize
   VAR nDefaultStandardFont     // -> AddStandardFont()
   VAR nDefaultStandardFontID
   VAR nDefaultBoldFont
   VAR nDefaultBoldFontID
   VAR nDefaultItalicFont
   VAR nDefaultItalicFontID
   VAR nDefaultItalicBoldFont
   VAR nDefaultItalicBoldFontID

   // use for :SAY(...)
   VAR nDefaultLPI, nDefaultCPI, nFirstLine,nLastLine,nFirstRow,nLastRow
   VAR cDefaultYes, cDefaultNo, cDefaultNumFormat

   // UTF8 <=> OEM / ANSI
   VAR UseAutoConvUTF8          // default True, but if you convert yourself to UTF-8, than set False
                                // Standard = True, aber wenn man alle Strings mit UTF8 bergibt, braucht man False

   INLINE METHOD ForceAnsi( cString ) // The DLL needs ANSI Parameters, if not UTF8 !
          DEFAULT cString TO ""
          if ::UseAutoConvUTF8  // string parameter == ANSI/OEM
             if ::nCharSet = 1    // OEM => ANSI
                cString := ConvToAnsiCP(cString)
             endif              // OK ANSI
          else
             // wenn ! ::UseAutoConvUTF8, muss man selbst UTF8 liefern, z.b. mit ::forceUTF8() beim Aufruf.
             // string parameter HAS TO BE UTF8, force it !
          endif
          Return cString

   INLINE METHOD ReadString( cString ) // The DLL needs ANSI Parameters, if not UTF8 !
          DEFAULT cString TO ""
          if ::UseAutoConvUTF8  // string parameter == ANSI/OEM
             if ::nCharSet = 1    // ANSI => OEM
                cString := ConvToOemCP(cString)
             endif              // OK OEM
          else
             // wenn ! ::UseAutoConvUTF8, erhlt man UTF8, verwenden mit z.b. ReadUTF8()
             // return value is UTF8, use it !
          endif
          Return cString

   INLINE METHOD ForceUTF8( cString ) // cXbaseString => OEM or ANSI
          DEFAULT cString TO ""
          do case
             case ::nCharSet = 0 // set charset to Ansi
                  cString := cAnsiToUtf8(cString)
             case ::nCharSet = 1 // set charset to OEM
                  cString := cOemToUtf8(cString)
             otherwise
                  msgbox("ERROR: SET CHARSET # ANSI # OEM ?","ERROR in ForceUTF8()")
          end
          Return cString

   INLINE METHOD ReadUTF8( cString ) // UTF-8 => OEM or ANSI
          DEFAULT cString TO ""
          do case
             case ::nCharSet = 0 // set charset to Ansi
                 cString := cUtf8ToAnsi(cString)
             case ::nCharSet = 1 // set charset to OEM
                 cString := cUtf8ToOem(cString)
             otherwise
                  msgbox("ERROR: SET CHARSET # ANSI # OEM ?","ERROR in ReadUTF8()")
          end
          Return cString

   INLINE METHOD PathFormatPdf(cFile)                      // c:\myPath\myDoc.pfd ==> /c/myPath/myDoc.pfd
          DEFAULT cFile TO ""
          if substr(cFile,2,1)==":"                        //  ^
             cFile := "/"+left(cFile,1)+substr(cFile,3)    // /c\myPath\myDoc.pfd ==> /c/myPath/myDoc.pfd
          endif
          cFile := lower(strTran(cFile,"\","/"))
          Return cFile

   METHOD INIT
   METHOD CREATE
   METHOD DESTROY
   METHOD IsTrue, IsFalse       // 0 / #0  ->  .f. / .t.

   INLINE METHOD Points2Unit(nPoints)
          do case
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
                  return nPoints / 72 * 25.4
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
                  return nPoints / 72
          end
          return nPoints

   INLINE METHOD GetUnitText(lShowShort)
          DEFAULT lShowShort TO .t.
          do case
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
                  return "mm"
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
                  return "inch"
          end
          return iif(lShowShort,"pt","points")

   METHOD GetTextUnderline      // return ::nTextUnderline
   METHOD GetPageSizeX          // -> QuickPDFPageWidth,   PageWidth
   METHOD GetPageSizeY          // -> QuickPDFPageHeight,  PageHeight
   METHOD GetPrinterBinA        // :GetPrinterBins()  -> String -> Array
   METHOD GetPrinterNameA       // :GetPrinterNames() -> CSV String -> Array
   METHOD GetTextAlign          // aktuelle Einstellung abfragen, Rckgabewert ist numerisch und entspricht letzter SetTextAlign(nWert) Festlegung
                                // get the current value, this is the same as the last numeric setting from SetTextAlign(nValue)
   METHOD GetColorRGB           // Xbase++ color -> {r,g,b} || nRGB -> 1=red, 2=green, 3 = blue

   // Bilder einfacher handhaben / help with images
   METHOD AddImageID            // AddImageID(nImageID,cName)       -> aadd(aImageID,{nImageID,cName}) -> OK ? .f. = Name exists, 1 ID n Names is OK.
   METHOD RemoveImageID         // RemoveImageID(nImageID)          -> aRemove(aImageID,... )          -> OK ? .f. = Parameter error
   METHOD GetImageIDByName      // GetImageIDByName(cName)          -> nImageID
   METHOD SelectImageByName     // SelectImageByName(cName) -(nImageID)-> SelectImage(nImageID) -> OK ?
   METHOD AddImageFile          // AddImageFile(cFileName,O) | AddImageFromFile(...) -(nImageID)-> AddImageID(...) -> nImageID
   METHOD DrawImageFile         // -> AddImageFile(cFileName,O) | AddImageFromFile(...) -(nImageID)-> AddImageID(...) -> FitImage...
   METHOD AddImageResource      // AddImageResource(nResourceID,O) | AddImageFromString(...) -(nImageID)-> AddImageID(...) -> nImageID
   METHOD DrawImageResource     // -> AddImageResource(nResourceID,O) -> String  | AddImageFromString(...) -(nImageID)-> AddImageID(...) -> FitImage...
   METHOD AddImageFromXbpBMP(cSetBufferString) // dem Rckgabewert bei BMPs fehlen die 14 Bytes des DateiHeader. NUR FR BMP !!!
   // needed for @...say migration
   METHOD SAY(nRow,nCol,xData,cAlign,nCPI,nLPI) // min == 1,1
   Method SayLine(nRow1,nCol1,nRow2,nCol2,cAlign1,cAlign2,nOffset,nCPI,nLPI) // Basisausrichtung der Linien/basic alignment: cAlign // nOffset +/- n
   Method SayBox(nRowTop,nColLeft,nRowBottom,nColRight,nOffset,nDrawOptions,nCPI,nLPI)
   Method SayImage(nRowTop,nColLeft,nRowBottom,nColRight,nRotateLeft,nCPI,nLPI,lRatio)   // Image in Grenzen von SayBox einpassen.

   METHOD SetLPI, GetLPI        // -> ::nLPI    *** will NOT change the FONT SIZE  !  // To CHANGE the fontsize use  ::SetTextCpi(n)
   METHOD SetCPI, GetCPI        // -> ::nCPI    *** Font Gre wird NICHT gendert !  // Zum ndern der Textgre -> ::SetTextCpi(n)
                                // beides ist NUR fr die Berechnung der SAY Position
                                // both will only be used to calculate the SAY position
                                // =>  SetTextCpi(n), GetTextCpi()

   METHOD SetSayLineFeed,GetSayLineFeed         // Zeilenhhe direkt angeben, berechnet -> ::nLPI / calculate ::nLPI from the parameter
   METHOD SetSayLinesPerPage,GetSayLinesPerPage // Zeilen je Seite direkt angeben, berechnet -> ::nLPI / lines per page calculate ::nLPI
   METHOD SetSayRowsPerPage,GetSayRowsPerPage   // Spalten je Seite direkt angeben, berechnet -> ::nCPI / rows per page calculate ::nCPI
   METHOD GetRowsPerInch                        // SetSayRowsPerPage( nRowsPerPage ) => SetTextCpi(GetRowsPerInch()) => correct font

   METHOD GetCPICharWidth(nCPI) // Breite eines Zeichens mit nCPI
   METHOD nRowToPosY(), nColToPosX()  // @say(nRow,nPos) -> x,y





   // HBPrinter() Methods

*   METHOD PrintMemo( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, xColor, cHochQuer, nMaxBis,nLineFeed )
   VAR PrintTextAlltrim
   METHOD PrintText( nPosX, nPosY, xData, cAusrichtung, nMaxLen, cArt, xColor, nDrehen )
   METHOD PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit  ) // -> lSuccess
   METHOD PrintCheckBox( nLeft, nTop, nSize, cType )  // nSize auen/outline , cType="B" eckig/Box, "R" .or. "C" rund/circle
   METHOD LineFeed()            // Neue Y Position ermitteln / calculate new Y value
   VAR    DrawTextBoxNextTop    // nTop + ::nLineFeed( ::DrawTextBox(nLeft, nTop, ... -> next nTop
   METHOD nBaselineToTop()      // nPosY - ::GetTextBound(GETTEXTBOUND_TOP)
   METHOD nTopToBaseline()      // nTop  + ::GetTextBound(GETTEXTBOUND_TOP)
   METHOD CalcCheckDigit(uEAN13_Nr) // EAN13 -> 12 + checkDigit -> 13
   METHOD getPageNo()           // ::getPageNo() -> ::nPageNo (integer) / ::getPageNo("C") -> alltrim(str(::nPageNo))
   METHOD PrintPageNo()         // PrintText(x,y,"- "+::getPageNo("C")+" -"

   // from Pablo per eMail // does not need XbpBitmap
   INLINE METHOD cLoadResource( hMod , res_id , res_type , lang_id , lAddBmfh)
          local hrs,hgr,cb,p,cc,cch
          if Valtype( res_id  ) == "N"
             res_id := MAKEINTRESOURCE(res_id)
          elseif Valtype( res_id  ) != "C" ; RETURN NIL ; end
          DEFAULT res_type := 2     // BITMAP
          DEFAULT lang_id  := MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL )
          DEFAULT hMod := AppInstance()
          hrs := @kernel32:FindResourceExA(hMod,res_type , res_id , lang_id )
          if Empty(hrs) ; RETURN NIL ; end
          hgr := @kernel32:LoadResource(hMod,hrs)
          if Empty(hgr) ; RETURN NIL ; end
          p  := @kernel32:LockResource(hgr)
          if Empty(p) ; RETURN NIL ; end
          cb := @kernel32:SizeofResource( hMod, hrs )
          cc := PeekStr(p,0,cb)
          if ! Empty(lAddBmFh)
             cch := ::cBmpGenFileHeader( p , cb )
             if cch == NIL ; RETURN cch ; end // error
             return cch + cc
          end
          return cc
   INLINE METHOD cBmpGenFileHeader( p , cb ) // p can be a string or a memory pointer
          local cbh,nbbc,nPalSize,nn
          if cb < 16 ; RETURN NIL ; end  // invalid bitmap
          cbh := PeekDWord(p)
          if cbh == 12    ; nn := 3  // OS2 bitmaps BITMAPCOREINFO  using RGBTRIPLE color table
          elseif cbh < 40 ; RETURN NIL  // invalid BITMAPINFO
          else           ; nn := 4 // BITMAPINFO using RGBQUAD color table
          end
          nbbc := PeekWord(p,0x0E)
          nPalSize := 0
          if     nbbc ==  1 ; nPalSize :=   2 * nn
          elseif nbbc ==  4 ; nPalSize :=  16 * nn
          elseif nbbc ==  8 ; nPalSize := 256 * nn
          elseif nbbc == 16 ; nPalSize := 0
          elseif nbbc == 24 ; nPalSize := 0
          elseif nbbc == 32 ; nPalSize := 0
          else              ; RETURN NIL  // invalid bbc entry
          end
          return __i16(0x4D42) + __i32( 14 + cb ,  0 , 14 + cbh + nPalSize )

   INLINE METHOD _b(cc,ptb,n) // n = Positon von CC im Puffer von PTP, beim Aufruf ::_b(,1), ::_b(,2), ::_b(,3),...
                              // PTP genug Speicher reservieren:
                              // local ptb := _xgrab(32);PokeDWord(ptb,, nAnzahl der Parameter + 1 ) // MAX-pCount() 1 => 2
                              // 1 Parameter per _b() bergeben, dann 1 als letzten Parameter von _b(,1) verwenden.
                              // 2 Parameter per _b() bergeben, dann _b(,1), _b(,2) ... etc. verwenden.
          local cb,p
          if !(Valtype(cc) $ "CM") ; RETURN cc ; end
          cb := Len(cc) ; if cb == 0; RETURN cc ; end
          p  := ::CreateBuffer(cb)
          ::AddToBuffer(p,cc,cb)
          PokeDWord(ptb,n*4,p)
          return p

   INLINE METHOD _ptb_free_( result , ptb )
          AEval( PeekDWord(ptb,4,PeekDWord(ptb)) , {|p| _xfree(p) } )
          _xfree(ptb)
          return result

   INLINE METHOD _str_result_(p)
       local cb
       if Empty(p) ; RETURN "" ; end
       cb := ::AnsiStringResultLength()  // !!!!!!
       return PeekStr(p,0,cb)

   INLINE METHOD SetTextCpi(n) ; RETURN ::SetTextSize( 120 / n ) // tatschliche Font Gre, unabhngig von ::nCPI
   INLINE METHOD GetTextCpi()  ; RETURN (::GetTextSize() / 120)  // depend on the real font size, but not from ::nCPI

**********************************************************************************************************************
*  Erleichterungen bei Farben - use easy color values 0-255 0x00-0xFF
**********************************************************************************************************************

   INLINE METHOD HB_RGB2double(nR,nG,nB)  // PER REFERENZ AUFRUFEN - USE @ !!!
      if empty(nR) .or. empty(nG) .or. empty(nB)
         nR := nG := nB := 0
      else
         nR /= 255
         nG /= 255
         nB /= 255
      endif
      return nil

   // sortiert nach Name - sorted by name
   METHOD AddArcToPath
   METHOD AddCJKFont
   METHOD AddCurveToPath
   METHOD AddEmbeddedFile
   METHOD AddFileAttachment
   METHOD AddFormFieldSub
   METHOD AddFormFont
   METHOD AddGlobalJavaScript
   METHOD AddImageFromFile
   METHOD AddImageFromFileOffset
   METHOD AddImageFromString
   METHOD AddLGIDictToPage
   METHOD AddLineToPath
   METHOD AddLinkToDestination
   METHOD AddLinkToEmbeddedFile
   METHOD AddLinkToFile
   METHOD AddLinkToJavaScript
   METHOD AddLinkToLocalFile
   METHOD AddLinkToPage
   METHOD AddLinkToWeb
   METHOD AddNoteAnnotation
   METHOD AddOpenTypeFontFromFile
   METHOD AddPageLabels
   METHOD AddSVGAnnotationFromFile
   METHOD AddSWFAnnotationFromFile
   METHOD AddSeparationColor
   METHOD AddStandardFont
   METHOD AddSubsettedFont
   METHOD AddTextMarkupAnnotation
   METHOD AddToBuffer
   METHOD AddToFileList
   METHOD AddTrueTypeFont
   METHOD AddTrueTypeFontFromFile
   METHOD AddTrueTypeSubsettedFont
   METHOD AddType1Font
   METHOD AddU3DAnnotationFromFile
   METHOD AnalyseFile
   METHOD AnnotationCount
   METHOD AnsiStringResultLength
   METHOD AppendSpace
   METHOD AppendTableColumns
   METHOD AppendTableRows
   METHOD AppendText
   METHOD ApplyStyle
   METHOD AttachAnnotToForm
   METHOD BeginPageUpdate
   METHOD CapturePage
   METHOD CapturePageEx
   METHOD CharWidth
   METHOD CheckFileCompliance
   METHOD CheckObjects
   METHOD CheckPageAnnots
   METHOD ClearFileList
   METHOD ClearImage
   METHOD ClearPageLabels
   METHOD ClearTextFormatting
   METHOD CloneOutlineAction
   METHOD ClonePages
   METHOD CloseOutline
   METHOD ClosePath
   METHOD CombineContentStreams
   METHOD CombineLayers                                 // CombineLayers          => CombineContentStreams
   METHOD CompareOutlines
   METHOD CompressContent
   METHOD CompressFonts
   METHOD CompressImages
   METHOD CompressPage
   METHOD ContentStreamCount
   METHOD ContentStreamSafe
   METHOD CopyPageRanges
   METHOD CreateBuffer
   METHOD CreateNewObject
   METHOD CreateTable
   METHOD DAAppendFile
   METHOD DACapturePage
   METHOD DACapturePageEx
   METHOD DACloseFile
   METHOD DADrawCapturedPage
   METHOD DADrawRotatedCapturedPage
   METHOD DAEmbedFileStreams
   METHOD DAExtractPageText
   METHOD DAFindPage
   METHOD DAGetAnnotationCount
   METHOD DAGetFormFieldCount
   METHOD DAGetFormFieldTitle
   METHOD DAGetFormFieldValue
   METHOD DAGetImageDataToString
   METHOD DAGetImageDblProperty
   METHOD DAGetImageIntProperty
   METHOD DAGetImageListCount
   METHOD DAGetInformation
   METHOD DAGetObjectCount
   METHOD DAGetObjectSource         // DAGetObjectSource      => DAGetObjectToString
   METHOD DAGetObjectToString
   METHOD DAGetPageBox
   METHOD DAGetPageContent          // DAGetPageContent       => DAGetPageContentToString
   METHOD DAGetPageContentToString
   METHOD DAGetPageCount
   METHOD DAGetPageHeight
   METHOD DAGetPageImageList
   METHOD DAGetPageWidth
   METHOD DAHasPageBox
   METHOD DAHidePage
   METHOD DAMovePage
   METHOD DANewPage
   METHOD DANewPages
   METHOD DAOpenFile
   METHOD DAOpenFileReadOnly
   METHOD DAPageRotation
   METHOD DAReleaseImageList
   METHOD DARemoveUsageRights
   METHOD DARenderPageToDC
   METHOD DARenderPageToFile
   METHOD DARenderPageToString
   METHOD DARotatePage
   METHOD DASaveAsFile
   METHOD DASaveImageDataToFile
   METHOD DASetInformation
   METHOD DASetPageBox
   METHOD DASetPageSize
   METHOD DASetTextExtractionArea
   METHOD DASetTextExtractionOptions
   METHOD DASetTextExtractionScaling
   METHOD DASetTextExtractionWordGap
   METHOD Decrypt
   METHOD DecryptFile
   METHOD DeleteAnalysis
   METHOD DeleteAnnotation
   METHOD DeleteContentStream
   METHOD DeleteFormField
   METHOD DeleteLayer
   METHOD DeleteOptionalContentGroup
   METHOD DeletePageLGIDict
   METHOD DeletePages
   METHOD DocJavaScriptAction
   METHOD DocumentCount
   METHOD DrawArc
   METHOD DrawBarcode
   METHOD DrawBox
   METHOD DrawCapturedPage
   METHOD DrawCircle
   METHOD DrawDataMatrixSymbol
   METHOD DrawEllipse
   METHOD DrawEllipticArc
   METHOD DrawHTMLText
   METHOD DrawHTMLTextBox
   METHOD DrawImage
   METHOD DrawImageMatrix
   METHOD DrawIntelligentMailBarcode
   METHOD DrawLine
   METHOD DrawMultiLineText
   METHOD DrawPDF417Symbol
   METHOD DrawPath
   METHOD DrawPathEvenOdd
   METHOD DrawPostScriptXObject
   METHOD DrawRotatedBox
   METHOD DrawRotatedCapturedPage
   METHOD DrawRotatedImage
   METHOD DrawRotatedMultiLineText
   METHOD DrawRotatedText
   METHOD DrawRotatedTextBox
   METHOD DrawRoundedBox
   METHOD DrawScaledImage
   METHOD DrawSpacedText
   METHOD DrawTableRows
   METHOD DrawText
   METHOD DrawTextArc
   METHOD DrawTextBox
   METHOD DrawWrappedText
   METHOD EditableContentStream
   METHOD EditableLayer                  // EditableLayer          => EditableContentStream
   METHOD EmbedFile
   METHOD EmbeddedFileCount
   METHOD EncapsulateContentStream
   METHOD EncapsulateLayer               // EncapsulateLayer       => EncapsulateContentStream
   METHOD EncodePermissions
   METHOD Encrypt
   METHOD EncryptFile
   METHOD EncryptWithFingerprint
   METHOD EncryptionAlgorithm
   METHOD EncryptionStatus
   METHOD EncryptionStrength
   METHOD EndPageUpdate
   METHOD ExtractFilePageContent          // ExtractFilePageContent => ExtractFilePageContentToString
   METHOD ExtractFilePageContentToString
   METHOD ExtractFilePageText
   METHOD ExtractFilePages
   METHOD ExtractPageRanges
   METHOD ExtractPages
   METHOD FileListCount
   METHOD FileListItem
   METHOD FindFonts
   METHOD FindFormFieldByTitle
   METHOD FindImages
   METHOD FitImage
   METHOD FitRotatedTextBox
   METHOD FitTextBox
   METHOD FlattenFormField
   METHOD FontCount
   METHOD FontFamily
   METHOD FontHasKerning
   METHOD FontName
   METHOD FontReference
   METHOD FontSize
   METHOD FontType
   METHOD FormFieldCount
   METHOD FormFieldHasParent
   METHOD FormFieldJavaScriptAction
   METHOD FormFieldWebLinkAction
   METHOD GetActionDest
   METHOD GetActionType
   METHOD GetActionURL
   METHOD GetAnalysisInfo
   METHOD GetAnnotActionID
   METHOD GetAnnotDblProperty
   METHOD GetAnnotDest
   METHOD GetAnnotIntProperty
   METHOD GetAnnotQuadCount
   METHOD GetAnnotQuadPoints
   METHOD GetAnnotStrProperty
   METHOD GetBarcodeWidth
   METHOD GetBaseURL
   METHOD GetCSDictEPSG
   METHOD GetCSDictType
   METHOD GetCSDictWKT
   METHOD GetCanvasDC
   METHOD GetCatalogInformation
   METHOD GetContentStreamToString
   METHOD GetCustomInformation
   METHOD GetCustomKeys
   METHOD GetDefaultPrinterName
   METHOD GetDestName
   METHOD GetDestPage
   METHOD GetDestType
   METHOD GetDestValue
   METHOD GetDocJavaScript
   METHOD GetDocumentFileName
   METHOD GetDocumentFileSize
   METHOD GetDocumentID
   METHOD GetDocumentIdentifier
   METHOD GetDocumentMetadata
   METHOD GetDocumentResourceList
   METHOD GetEmbeddedFileContentToFile
   METHOD GetEmbeddedFileContentToString
   METHOD GetEmbeddedFileID
   METHOD GetEmbeddedFileIntProperty
   METHOD GetEmbeddedFileStrProperty
   METHOD GetEncryptionFingerprint
   METHOD GetErrorText
   METHOD GetFileMetadata
   METHOD GetFirstChildOutline
   METHOD GetFirstOutline
   METHOD GetFontEncoding
   METHOD GetFontID
   METHOD GetFontObjectNumber
   METHOD GetFormFieldActionID
   METHOD GetFormFieldAlignment
   METHOD GetFormFieldAnnotFlags
   METHOD GetFormFieldBackgroundColor
   METHOD GetFormFieldBorderColor
   METHOD GetFormFieldBorderProperty
   METHOD GetFormFieldBorderStyle
   METHOD GetFormFieldBound
   METHOD GetFormFieldCaption
   METHOD GetFormFieldChildTitle
   METHOD GetFormFieldChoiceType
   METHOD GetFormFieldColor
   METHOD GetFormFieldComb
   METHOD GetFormFieldDefaultValue
   METHOD GetFormFieldDescription
   METHOD GetFormFieldFlags
   METHOD GetFormFieldFontName
   METHOD GetFormFieldJavaScript
   METHOD GetFormFieldKidCount
   METHOD GetFormFieldMaxLen
   METHOD GetFormFieldNoExport
   METHOD GetFormFieldPage
   METHOD GetFormFieldPrintable
   METHOD GetFormFieldReadOnly
   METHOD GetFormFieldRequired
   METHOD GetFormFieldRotation
   METHOD GetFormFieldSubCount
   METHOD GetFormFieldSubName
   METHOD GetFormFieldSubTempIndex
   METHOD GetFormFieldTabOrder
   METHOD GetFormFieldTextFlags
   METHOD GetFormFieldTextSize
   METHOD GetFormFieldTitle
   METHOD GetFormFieldType
   METHOD GetFormFieldValue
   METHOD GetFormFieldValueByTitle
   METHOD GetFormFieldVisible
   METHOD GetFormFieldWebLink
   METHOD GetFormFontCount
   METHOD GetFormFontName
   METHOD GetGlobalJavaScript
   METHOD GetHTMLTextHeight
   METHOD GetHTMLTextLineCount
   METHOD GetHTMLTextWidth
   METHOD GetImageID
   METHOD GetImageListCount
   METHOD GetImageListItemDataToString
   METHOD GetImageListItemDblProperty
   METHOD GetImageListItemIntProperty
   METHOD GetImageMeasureDict
   METHOD GetImagePageCount
   METHOD GetImagePageCountFromString
   METHOD GetImagePtDataDict
   METHOD GetInformation
   METHOD GetInstalledFontsByCharset
   METHOD GetInstalledFontsByCodePage
   METHOD GetKerning
   METHOD GetLatestPrinterNames
   METHOD GetMaxObjectNumber
   METHOD GetMeasureDictBoundsCount
   METHOD GetMeasureDictBoundsItem
   METHOD GetMeasureDictCoordinateSystem
   METHOD GetMeasureDictDCSDict
   METHOD GetMeasureDictGCSDict
   METHOD GetMeasureDictGPTSCount
   METHOD GetMeasureDictGPTSItem
   METHOD GetMeasureDictLPTSCount
   METHOD GetMeasureDictLPTSItem
   METHOD GetMeasureDictPDU
   METHOD GetNamedDestination
   METHOD GetNextOutline
   METHOD GetObjectCount
   METHOD GetObjectSource                            // GetObjectSource => GetObjectToString
   METHOD GetObjectToString
   METHOD GetOpenActionDestination
   METHOD GetOpenActionJavaScript
   METHOD GetOptionalContentConfigCount
   METHOD GetOptionalContentConfigLocked
   METHOD GetOptionalContentConfigOrderCount
   METHOD GetOptionalContentConfigOrderItemID
   METHOD GetOptionalContentConfigOrderItemLabel
   METHOD GetOptionalContentConfigOrderItemLevel
   METHOD GetOptionalContentConfigOrderItemType
   METHOD GetOptionalContentConfigState
   METHOD GetOptionalContentGroupID
   METHOD GetOptionalContentGroupName
   METHOD GetOptionalContentGroupPrintable
   METHOD GetOptionalContentGroupVisible
   METHOD GetOrigin
   METHOD GetOutlineActionID
   METHOD GetOutlineColor
   METHOD GetOutlineDest
   METHOD GetOutlineID
   METHOD GetOutlineJavaScript
   METHOD GetOutlineObjectNumber
   METHOD GetOutlineOpenFile
   METHOD GetOutlinePage
   METHOD GetOutlineStyle
   METHOD GetOutlineWebLink
   METHOD GetPageBox
   METHOD GetPageColorSpaces
   METHOD GetPageContent                        // GetPageContent         => GetPageContentToString
   METHOD GetPageContentToString
   METHOD GetPageImageList
   METHOD GetPageJavaScript
   METHOD GetPageLGIDictContent
   METHOD GetPageLGIDictCount
   METHOD GetPageLabel
   METHOD GetPageLayout
   METHOD GetPageMode
   METHOD GetPageText
   METHOD GetPageViewPortCount
   METHOD GetPageViewPortID
   METHOD GetParentOutline
   METHOD GetPrevOutline
   METHOD GetPrinterBins
   METHOD GetPrinterDevModeToString
   METHOD GetPrinterMediaTypes
   METHOD GetPrinterNames
   METHOD GetRenderScale
   METHOD GetStringListCount
   METHOD GetStringListItem
   METHOD GetSubsetString
   METHOD GetTableCellDblProperty
   METHOD GetTableCellIntProperty
   METHOD GetTableCellStrProperty
   METHOD GetTableColumnCount
   METHOD GetTableLastDrawnRow
   METHOD GetTableRowCount
   METHOD GetTempPath
   METHOD GetTextAscent
   METHOD GetTextBound
   METHOD GetTextDescent
   METHOD GetTextHeight
   METHOD GetTextSize
   METHOD GetTextWidth
   METHOD GetUnicodeCharactersFromEncoding
   METHOD GetViewPortBBox
   METHOD GetViewPortMeasureDict
   METHOD GetViewPortName
   METHOD GetViewPortPtDataDict
   METHOD GetViewerPreferences
   METHOD GetWrappedText
   METHOD GetWrappedTextBreakString
   METHOD GetWrappedTextHeight
   METHOD GetWrappedTextLineCount
   METHOD GetXFAFormFieldCount
   METHOD GetXFAFormFieldName
   METHOD GetXFAFormFieldNames
   METHOD GetXFAFormFieldValue
   METHOD GetXFAToString
   METHOD GlobalJavaScriptCount
   METHOD GlobalJavaScriptPackageName
   METHOD HasFontResources
   METHOD HasPageBox
   METHOD HidePage
   METHOD ImageCount
   METHOD ImageFillColor
   METHOD ImageHeight
   METHOD ImageHorizontalResolution
   METHOD ImageResolutionUnits
   METHOD ImageType
   METHOD ImageVerticalResolution
   METHOD ImageWidth
   METHOD ImportEMFFromFile
   METHOD InsertPages
   METHOD InsertTableColumns
   METHOD InsertTableRows
   METHOD IsAnnotFormField
   METHOD LastErrorCode
   METHOD LastRenderError
   METHOD LayerCount                           // LayerCount             => ContentStreamCount
   METHOD LayerSafe                            // LayerSafe              => ContentStreamSafe
   METHOD LibraryVersion
   METHOD LicenseInfo
   METHOD Linearized
   METHOD LoadFromCanvasDC
   METHOD LoadFromFile
   METHOD LoadFromString
   METHOD LoadState
   METHOD MergeDocument
   METHOD MergeFileList
   METHOD MergeFileListFast
   METHOD MergeFiles
   METHOD MergeTableCells
   METHOD MoveContentStream
   METHOD MoveLayer                            // MoveLayer              => MoveContentStream
   METHOD MoveOutlineAfter
   METHOD MoveOutlineBefore
   METHOD MovePage
   METHOD MovePath
   METHOD MultiplyScale
   METHOD NewChildFormField
   METHOD NewContentStream
   METHOD NewCustomPrinter
   METHOD NewDestination
   METHOD NewDocument
   METHOD NewFormField
   METHOD NewLayer                              // NewLayer               => NewContentStream
   METHOD NewNamedDestination
   METHOD NewOptionalContentGroup
   METHOD NewOutline
   METHOD NewPage
   METHOD NewPageFromCanvasDC
   METHOD NewPages
   METHOD NewPostScriptXObject
   METHOD NewRGBAxialShader
   METHOD NewStaticOutline
   METHOD NewTilingPatternFromCapturedPage
   METHOD NoEmbedFontListAdd
   METHOD NoEmbedFontListCount
   METHOD NoEmbedFontListGet
   METHOD NoEmbedFontListRemoveAll
   METHOD NoEmbedFontListRemoveIndex
   METHOD NoEmbedFontListRemoveName
   METHOD NormalizePage
   METHOD OpenOutline
   METHOD OptionalContentGroupCount
   METHOD OutlineCount
   METHOD OutlineTitle
   METHOD PageCount
   METHOD PageHeight
   METHOD PageJavaScriptAction
   METHOD PageRotation
   METHOD PageWidth
   METHOD PrintDocument
   METHOD PrintDocumentToFile
   METHOD PrintOptions
   METHOD ReleaseBuffer
   METHOD ReleaseImage
   METHOD ReleaseImageList
   METHOD ReleaseLibrary
   METHOD RemoveAppearanceStream
   METHOD RemoveCustomInformation
   METHOD RemoveDocument
   METHOD RemoveEmbeddedFile
   METHOD RemoveFormFieldBorderColor
   METHOD RemoveGlobalJavaScript
   METHOD RemoveOutline
   METHOD RemoveSharedContentStreams
   METHOD RemoveSharedLayers                  // RemoveSharedLayers     => RemoveSharedContentStreams
   METHOD RemoveStyle
   METHOD RemoveUsageRights
   METHOD RemoveXFAEntries
   METHOD RenderDocumentToFile
   METHOD RenderPageToDC
   METHOD RenderPageToFile
   METHOD RenderPageToString
   METHOD ReplaceFonts
   METHOD ReplaceImage
   METHOD ReplaceTag
   METHOD RequestPrinterStatus
   METHOD RetrieveCustomDataToFile
   METHOD RetrieveCustomDataToString
   METHOD ReverseImage
   METHOD RotatePage
   METHOD SaveFontToFile
   METHOD SaveImageListItemDataToFile
   METHOD SaveImageToFile
   METHOD SaveImageToString
   METHOD SaveState
   METHOD SaveStyle
   METHOD SaveToFile
   METHOD SaveToString
   METHOD SecurityInfo
   METHOD SelectContentStream
   METHOD SelectDocument
   METHOD SelectFont
   METHOD SelectImage
   METHOD SelectLayer                                // SelectLayer            => SelectContentStream
   METHOD SelectPage
   METHOD SelectRenderer
   METHOD SelectedDocument
   METHOD SelectedFont
   METHOD SelectedImage
   METHOD SelectedPage
   METHOD SetActionURL
   METHOD SetAdvancePassword
   METHOD SetAnnotBorderColor
   METHOD SetAnnotBorderColorRGB
   METHOD SetAnnotBorderColorXB                // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetAnnotBorderStyle
   METHOD SetAnnotContents
   METHOD SetAnnotIntProperty
   METHOD SetAnnotQuadPoints
   METHOD SetAnnotStrProperty
   METHOD SetAnsiMode
   METHOD SetBaseURL
   METHOD SetBlendMode
   METHOD SetBreakString
   METHOD SetCSDictEPSG
   METHOD SetCSDictType
   METHOD SetCSDictWKT
   METHOD SetCairoFileName
   METHOD SetCapturedPageOptional
   METHOD SetCapturedPageTransparencyGroup
   METHOD SetCatalogInformation
   METHOD SetCharWidth
   METHOD SetClippingPath
   METHOD SetClippingPathEvenOdd
   METHOD SetCompatibility
   METHOD SetContentStreamFromString
   METHOD SetContentStreamOptional
   METHOD SetCropBox
   METHOD SetCustomInformation
   METHOD SetCustomLineDash
   METHOD SetDestProperties
   METHOD SetDestValue
   METHOD SetDocumentMetadata
   METHOD SetEmbeddedFileStrProperty
   METHOD SetFillColor
   METHOD SetFillColorCMYK
   METHOD SetFillColorRGB
   METHOD SetFillColorSep
   METHOD SetFillColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFillShader
   METHOD SetFillTilingPattern
   METHOD SetFindImagesMode
   METHOD SetFontEncoding
   METHOD SetFontFlags
   METHOD SetFormFieldAlignment
   METHOD SetFormFieldAnnotFlags
   METHOD SetFormFieldBackgroundColor
   METHOD SetFormFieldBackgroundColorCMYK
   METHOD SetFormFieldBackgroundColorRGB
   METHOD SetFormFieldBackgroundColorSep
   METHOD SetFormFieldBackgroundColorXB        // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldBorderColor
   METHOD SetFormFieldBorderColorCMYK
   METHOD SetFormFieldBorderColorRGB
   METHOD SetFormFieldBorderColorSep
   METHOD SetFormFieldBorderColorXB            // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldBorderStyle
   METHOD SetFormFieldBounds
   METHOD SetFormFieldCalcOrder
   METHOD SetFormFieldCaption
   METHOD SetFormFieldCheckStyle
   METHOD SetFormFieldChildTitle
   METHOD SetFormFieldChoiceType
   METHOD SetFormFieldColor
   METHOD SetFormFieldColorCMYK
   METHOD SetFormFieldColorRGB
   METHOD SetFormFieldColorSep
   METHOD SetFormFieldColorXB                  // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldComb
   METHOD SetFormFieldDefaultValue
   METHOD SetFormFieldDescription
   METHOD SetFormFieldFlags
   METHOD SetFormFieldFont
   METHOD SetFormFieldHighlightMode
   METHOD SetFormFieldIcon
   METHOD SetFormFieldIconStyle
   METHOD SetFormFieldMaxLen
   METHOD SetFormFieldNoExport
   METHOD SetFormFieldOptional
   METHOD SetFormFieldPage
   METHOD SetFormFieldPrintable
   METHOD SetFormFieldReadOnly
   METHOD SetFormFieldRequired
   METHOD SetFormFieldRotation
   METHOD SetFormFieldStandardFont
   METHOD SetFormFieldSubmitAction
   METHOD SetFormFieldTabOrder
   METHOD SetFormFieldTextFlags
   METHOD SetFormFieldTextSize
   METHOD SetFormFieldValue
   METHOD SetFormFieldValueByTitle
   METHOD SetFormFieldVisible
   METHOD SetGDIPlusFileName
   METHOD SetGDIPlusOptions
   METHOD SetHTMLBoldFont
   METHOD SetHTMLBoldItalicFont
   METHOD SetHTMLItalicFont
   METHOD SetHTMLNormalFont
   METHOD SetImageAsMask
   METHOD SetImageMask
   METHOD SetImageMaskCMYK
   METHOD SetImageMaskFromImage
   METHOD SetImageOptional
   METHOD SetImageResolution
   METHOD SetInformation
   METHOD SetJPEGQuality
   METHOD SetJavaScriptMode
   METHOD SetKerning
   METHOD SetLayerOptional                          // SetLayerOptional       => SetContentStreamOptional
   METHOD SetLineCap
   METHOD SetLineColor
   METHOD SetLineColorCMYK
   METHOD SetLineColorRGB
   METHOD SetLineColorSep
   METHOD SetLineColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetLineDash
   METHOD SetLineDashEx
   METHOD SetLineJoin
   METHOD SetLineShader
   METHOD SetLineWidth
   METHOD SetMarkupAnnotStyle
   METHOD SetMeasureDictBoundsCount
   METHOD SetMeasureDictBoundsItem
   METHOD SetMeasureDictCoordinateSystem
   METHOD SetMeasureDictGPTSCount
   METHOD SetMeasureDictGPTSItem
   METHOD SetMeasureDictLPTSCount
   METHOD SetMeasureDictLPTSItem
   METHOD SetMeasureDictPDU
   METHOD SetMeasurementUnits
   METHOD SetNeedAppearances
   METHOD SetObjectFromString
   METHOD SetObjectSource                            // SetObjectSource => SetObjectFromString
   METHOD SetOpenActionDestination
   METHOD SetOpenActionDestinationFull
   METHOD SetOpenActionJavaScript
   METHOD SetOpenActionMenu
   METHOD SetOptionalContentConfigLocked
   METHOD SetOptionalContentConfigState
   METHOD SetOptionalContentGroupPrintable
   METHOD SetOptionalContentGroupVisible
   METHOD SetOrigin
   METHOD SetOutlineColor
   METHOD SetOutlineColorRGB
   METHOD SetOutlineColorXB                    // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetOutlineDestination
   METHOD SetOutlineDestinationFull
   METHOD SetOutlineDestinationZoom
   METHOD SetOutlineJavaScript
   METHOD SetOutlineNamedDestination
   METHOD SetOutlineOpenFile
   METHOD SetOutlineRemoteDestination
   METHOD SetOutlineStyle
   METHOD SetOutlineTitle
   METHOD SetOutlineWebLink
   METHOD SetOverprint
   METHOD SetPDFAMode
   METHOD SetPNGTransparencyColor
   METHOD SetPageActionMenu
   METHOD SetPageBox
   METHOD SetPageContent                   // SetPageContent         => SetPageContentFromString
   METHOD SetPageContentFromString
   METHOD SetPageDimensions
   METHOD SetPageLayout
   METHOD SetPageMode
   METHOD SetPageSize
   METHOD SetPageThumbnail
   METHOD SetPageTransparencyGroup
   METHOD SetPassword
   METHOD SetPrecision
   METHOD SetPrinterDevModeFromString
   METHOD SetRenderCropType
   METHOD SetRenderDCErasePage
   METHOD SetRenderDCOffset
   METHOD SetRenderScale
   METHOD SetScale
   METHOD SetTableBorderColor
   METHOD SetTableBorderColorCMYK
   METHOD SetTableBorderColorRGB
   METHOD SetTableBorderColorXB                // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableBorderWidth
   METHOD SetTableCellAlignment
   METHOD SetTableCellBackgroundColor
   METHOD SetTableCellBackgroundColorCMYK
   METHOD SetTableCellBackgroundColorRGB
   METHOD SetTableCellBackgroundColorXB        // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellBorderColor
   METHOD SetTableCellBorderColorCMYK
   METHOD SetTableCellBorderColorRGB
   METHOD SetTableCellBorderColorXB            // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellBorderWidth
   METHOD SetTableCellContent
   METHOD SetTableCellPadding
   METHOD SetTableCellTextColor
   METHOD SetTableCellTextColorCMYK
   METHOD SetTableCellTextColorRGB
   METHOD SetTableCellTextColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellTextSize
   METHOD SetTableColumnWidth
   METHOD SetTableRowHeight
   METHOD SetTableThinBorders
   METHOD SetTableThinBordersCMYK
   METHOD SetTempFile
   METHOD SetTempPath
   METHOD SetTextAlign
   METHOD SetTextCharSpacing
   METHOD SetTextColor
   METHOD SetTextColorCMYK
   METHOD SetTextColorRGB
   METHOD SetTextColorSep
   METHOD SetTextColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextExtractionArea
   METHOD SetTextExtractionOptions
   METHOD SetTextExtractionScaling
   METHOD SetTextExtractionWordGap
   METHOD SetTextHighlight
   METHOD SetTextHighlightColor
   METHOD SetTextHighlightColorCMYK
   METHOD SetTextHighlightColorRGB
   METHOD SetTextHighlightColorSep
   METHOD SetTextHighlightColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextMode
   METHOD SetTextRise
   METHOD SetTextScaling
   METHOD SetTextShader
   METHOD SetTextSize
   METHOD SetTextSpacing
   METHOD SetTextUnderline
   METHOD SetTextUnderlineColor
   METHOD SetTextUnderlineColorCMYK
   METHOD SetTextUnderlineColorRGB
   METHOD SetTextUnderlineColorSep
   METHOD SetTextUnderlineColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextUnderlineCustomDash
   METHOD SetTextUnderlineDash
   METHOD SetTextUnderlineDistance
   METHOD SetTextUnderlineWidth
   METHOD SetTextWordSpacing
   METHOD SetTransparency
   METHOD SetViewerPreferences
   METHOD SetXFAFormFieldAccess
   METHOD SetXFAFormFieldBorderColor
   METHOD SetXFAFormFieldBorderColorRGB
   METHOD SetXFAFormFieldBorderColorXB         // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetXFAFormFieldBorderPresence
   METHOD SetXFAFormFieldBorderWidth
   METHOD SetXFAFormFieldValue
   METHOD SetXFAFromString
   METHOD SetupCustomPrinter
   METHOD SignFile
   METHOD SplitPageText
   METHOD StartPath
   METHOD StoreCustomDataFromFile
   METHOD StoreCustomDataFromString
   METHOD StringResultLength
   METHOD TestTempPath
   METHOD UnlockKey
   METHOD Unlocked
   METHOD UpdateAppearanceStream
   METHOD UseKerning
   METHOD UseUnsafeContentStreams
   METHOD UseUnsafeLayers                                // UseUnsafeLayers        => UseUnsafeContentStreams

ENDCLASS
*---------------------------------------------------
METHOD HBPrintPDF:INIT(cDefaultLanguage)
   ::_hdll_                      := 0
   ::_id_                        := 0
   ::nCharSet                    := set(_SET_CHARSET)
   ::aImageID                    := {}
   ::nLineWidth                  := ::nDefaultLineWidth := 0.3     // DrawLine etc.()
   ::nOldTextColorRed            := 0                              // 0 = Schwarz, black
   ::nOldTextColorGreen          := 0
   ::nOldTextColorBlue           := 0
   ::nOldTextHighlightColorRed   := 0
   ::nOldTextHighlightColorGreen := 0
   ::nOldTextHighlightColorBlue  := 0
   ::nOldTextUnderlineColorRed   := 0
   ::nOldTextUnderlineColorGreen := 0
   ::nOldTextUnderlineColorBlue  := 0
   ::nAktiveFillColorRed         := 0
   ::nAktiveFillColorGreen       := 0
   ::nAktiveFillColorBlue        := 0
   ::cQuickPdfDllName            := "QuickPDFDLL0816.dll" // ==> :create() sucht eine vorhandene Datei, wenn diese nicht geladen werden kann.
   ::nDefaultPageSize            := "A4"
   ::nDefaultMeasurementUnits    := MEASUREMENTUNITS_MM
   ::nPageDefaultOrigin          := PAGE_ORIGIN_TOP_LEFT
   ::nDefaultStandardFont        := STANDARDFONTID_ARIAL
   ::nDefaultBoldFont            := STANDARDFONTID_ARIALBOLD
   ::nDefaultItalicFont          := STANDARDFONTID_ARIALITALIC
   ::nDefaultItalicBoldFont      := STANDARDFONTID_ARIALBOLDITALIC
   ::nDefaultStandardFontSize    := 12 // 12 Punkt
   if cDefaultLanguage==NIL
      ::cErrorLanguage           := "DE"      // 2 Bytes => UPPER( ISO 639-1 ) es = espania, en = english, fr = french, de = germany
   else
      ::cErrorLanguage           := upper(alltrim(cDefaultLanguage))
   endif
   do case
      case "*"+::cErrorLanguage+"*" $ "*D*DE*"
         ::cErrorLanguage        := "DE"
         ::cErrorLoadDll         := "Fehler beim Laden von Quick PDF DLL ("+::cQuickPdfDllName+" ff). Ist diese vorhanden ?"
         ::cErrorNoInstance      := "Quick PDF DLL konnte nicht initialisiert werden !"
         ::cErrorNoLicenseOK     := "Lizenz Key wurde nicht akzeptiert !"
         ::cErrorNoLicenseKey    := "Parameter cKey (Lizenz Key) wurde nicht bergeben !"
         ::cErrorNotMinVerOT4XB  := "Version 1.5.12.21 oder hher von ot4xb wird bentigt. www.xbwin.com"

         ::cDefaultYes           := "Ja"
         ::cDefaultNo            := "Nein"

      case "*"+::cErrorLanguage+"*" $ "*ES*"
         ::cErrorLoadDll         := "No se ha podido cargar la DLL Quick PDF ("+::cQuickPdfDllName+" ff). Probablemente no se ha podido hallar."
         ::cErrorNoInstance      := "No se ha podido inicializar una nueva instancia de la DLL Quick PDF"
         ::cErrorNoLicenseOK     := "La licencia no ha sido aceptada !"
         ::cErrorNoLicenseKey    := "Falta el parmetro cKey, la clave de la licencia no est definida"
         ::cErrorNotMinVerOT4XB  := "Se requiere ot4xb 1.5.12.21 o superior, busca en  www.xbwin.com"

         ::cDefaultYes           := "Si"
         ::cDefaultNo            := "No"

      otherwise     // Englisch / english
         ::cErrorLoadDll         := "Could not load Quick PDF DLL ("+::cQuickPdfDllName+" ff). Maybe not found ?"
         ::cErrorNoInstance      := "The instance of Quick PDF Library could not be created !"
         ::cErrorNoLicenseOK     := "License key was not accepted !"
         ::cErrorNoLicenseKey    := "Missing Parameter cKey, license key was not defined !"
         ::cErrorNotMinVerOT4XB  := "ot4xb 1.5.12.21 or higher required, see www.xbwin.com"

         ::cDefaultYes           := "Yes"
         ::cDefaultNo            := "No"

   end

   if ::nCharSet = 1    // ANSI => OEM
      ::cErrorLoadDll          := ConvToOemCP(::cErrorLoadDll)
      ::cErrorNoInstance       := ConvToOemCP(::cErrorNoInstance)
      ::cErrorNoLicenseOK      := ConvToOemCP(::cErrorNoLicenseOK)
      ::cErrorNoLicenseKey     := ConvToOemCP(::cErrorNoLicenseKey)
      ::cErrorNotMinVerOT4XB   := ConvToOemCP(::cErrorNotMinVerOT4XB)
   endif              // OK OEM

   ::cDefaultNumFormat         := "999,999,999.99"

   ::nDefaultLPI               :=  6         //  6 lines per inch            // Zeilen  pro Zoll
   ::nDefaultCPI               := 10         // 10 chars per inch            // Zeichen pro Zoll
   ::nFirstLine                :=  4         //  3 lines TOP margin, first line in 4
   ::nLastLine                 := 67         //  3 lines BOTTOM margin, 70 Lines per Page in A4, last print line on 67
   ::nFirstRow                 :=  9         //  8 chars left margin  2 cm
   ::nLastRow                  := 78         //  4 chars right margin 1 cm
   ::nCPI                      := ::nDefaultCPI
   ::nLPI                      := ::nDefaultLPI
   ::nAlign                    := TEXT_ALIGN_LEFT
   ::PrintTextAlltrim          := .t.
   ::nPageNo                   := 1
   ::nTextUnderline            := TEXTUNDERLINE_NONE
   ::SayOrigin0                := .f.

   ::UseAutoConvUTF8           := .t.        // Vorgabe *** default

return self
*---------------------------------------------------
Method HBPrintPDF:Create(cKey)
   local aDLL, cDll, nDllVersion
   ::IsOK := .f.
   DEFAULT cKey TO GetEnv("QUICKPDF_08_REGKEY")
   do case
      case empty(cKey)
           msgbox(::cErrorNoLicenseKey,"HBPrintPDF():Create(cKey)")
      case ot4xb() < "001.005.012.021"
           MsgBox(::cErrorNotMinVerOT4XB,"HBPrintPDF():Create(cKey)")
      otherwise
           // mit dem richtigen Namen kann die DLL auch im Pfad liegen, aber zu viele Anfragen ...
           // with this syntax the DLL could be found in a directory in the path, but don't ask too much.
           ::_hdll_ := dllLoad(::cQuickPdfDllName)
           if empty(::_hdll_)                          // hchste Version suchen - look newest version
              for nDllVersion := MAX_DLL_VERSION TO MIN_DLL_VERSION step -1
                  cDll := "QuickPDFDLL"+strZero(nDllVersion,4)+".dll"
                  ::_hdll_ := dllLoad(cDll)
                  if ! empty(::_hdll_)                          // hchste Version suchen - look newest version
                     exit
                  endif
              next
           endif
           if empty(::_hdll_)
              msgbox(::cErrorLoadDll,"HPPrintPDF() - dllLoad()")
           else
              ::_id_ := FpQCall( {::_hdll_,"QuickPDFCreateLibrary"} ,"__sl__sl",::_id_)
              if empty(::_id_)
                 msgbox(::cErrorNoInstance,"HBPrintPDF():Create(cKey)")
              else
                 if ::UnlockKey(cKey)
                    if ::UseAutoConvUTF8
                       ::SetAnsiMode(0)                            // 0 = Ansi ist Standard, aber sicherheitshalber erzwingen.
                    else
                       ::SetAnsiMode(1)                            // 1 = UTF8
                    endif
                    ::IsOK := .t.
                    ::SetPageSize(::nDefaultPageSize)
                    ::SetMeasurementUnits(::nDefaultMeasurementUnits)
                    ::SetLineWidth(::nDefaultLineWidth)
                    ::SetOrigin(::nPageDefaultOrigin)
                    ::nDefaultStandardFontID       := ::AddStandardFont(::nDefaultStandardFont)
                    ::nDefaultBoldFontID           := ::AddStandardFont(::nDefaultBoldFont)
                    ::nDefaultItalicFontID         := ::AddStandardFont(::nDefaultItalicFont)
                    ::nDefaultItalicBoldFontID     := ::AddStandardFont(::nDefaultItalicBoldFont)
                    ::SetHTMLNormalFont("Default",    ::nDefaultStandardFontID  )
                    ::SetHTMLBoldFont("Default",      ::nDefaultBoldFontID      )
                    ::SetHTMLItalicFont("Default",    ::nDefaultItalicFontID    )
                    ::SetHTMLBoldItalicFont("Default",::nDefaultItalicBoldFontID)
                    ::SelectFont(::nDefaultStandardFontID)
                    ::SetTextSize(::nDefaultStandardFontSize)         // setzt auch ::nLineFeed / calculates ::nLineFeed
                 else
                    msgbox(::cErrorNoLicenseOK,"HBPrintPDF():Create(cKey)")
                    ::destroy()
                 endif
              endif
           endif
   end

return SELF
*---------------------------------------------------
Method HBPrintPDF:Destroy()
   if ::ReleaseLibrary()
      ::_id_   := 0
      ::_hdll_ := 0
   endif
return NIL
*---------------------------------------------------
Method HBPrintPDF:GetTextUnderline()
return ::nTextUnderline
*---------------------------------------------------
Method HBPrintPDF:GetPageSizeX()
return ::PageWidth()
*---------------------------------------------------
Method HBPrintPDF:GetPageSizeY()
return ::PageHeight()
*---------------------------------------------------
Method HBPrintPDF:SetLPI(nLPI)
  local nReturn
  if nLPI==NIL
     ::nLPI  := ::nDefaultLPI
     nReturn := ::nLPI
  else
     nReturn := ::nLPI
     ::nLPI  := nLPI
  endif
return nReturn
*---------------------------------------------------
Method HBPrintPDF:GetLPI()
return ::nLPI
*---------------------------------------------------
Method HBPrintPDF:SetCPI(nCPI)
  local nReturn
  if nCPI==NIL
     ::nCPI  := ::nDefaultCPI
     nReturn := ::nCPI
  else
     nReturn := ::nCPI
     ::nCPI  := nCPI
  endif
return nReturn
*---------------------------------------------------
Method HBPrintPDF:GetCPI()
return ::nCPI
*---------------------------------------------------
Method HBPrintPDF:SetSayLineFeed(nLineHeight)
   DEFAULT nLineHeight TO ::GetTextHeight()       // Standardhhe von Font / fonts standard height
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           ::nLPI := 25.4 / nLineHeight
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           ::nLPI :=  1.0 / nLineHeight
      otherwise  // Points = 1/72 Inch
           ::nLPI := 72.0 / nLineHeight
   end
return ::GetSayLineFeed()
*---------------------------------------------------
Method HBPrintPDF:GetSayLineFeed()
   local nLineHeight
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nLineHeight := 25.4 / ::nLPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nLineHeight :=  1.0 / ::nLPI
      otherwise  // Points = 1/72 Inch
           nLineHeight := 72.0 / ::nLPI
   end
return nLineHeight
*---------------------------------------------------
Method HBPrintPDF:SetSayLinesPerPage(nLinesPerPage)
   if nLinesPerPage==NIL
      ::SetSayLineFeed() // standard font size
   else
      ::SetSayLineFeed(::PageHeight()/nLinesPerPage)
   endif
return ::GetSayLinesPerPage()
*---------------------------------------------------
Method HBPrintPDF:GetSayLinesPerPage()
return ::PageHeight()/::GetSayLineFeed()
*---------------------------------------------------
Method HBPrintPDF:SetSayRowsPerPage(nRowsPerPage)
   local nPageWidthInInch  // Papierbreite in Inch
   do case
      case nRowsPerPage==NIL
           ::GetSayRowsPerPage()
      case  80 <= nRowsPerPage .and. nRowsPerPage <=  82
           ::SetCpi(10)
      case  96 <= nRowsPerPage .and. nRowsPerPage <=  98
           ::SetCpi(12)
      case 136 <= nRowsPerPage .and. nRowsPerPage <= 140
           ::SetCpi(17)
      otherwise
           do case
              case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
                   nPageWidthInInch := ::PageWidth() / 25.4
              case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
                   nPageWidthInInch := 1.0
              otherwise  // Points = 1/72 Inch
                   nPageWidthInInch := ::PageWidth() / 72.0
           end
           // 1 inch / nRowWidth in Inch
           ::SetCpi( 1 / (nPageWidthInInch/nRowsPerPage) )
   end
return ::GetSayRowsPerPage()
*---------------------------------------------------
Method HBPrintPDF:GetSayRowsPerPage()
return int(::PageWidth()/::GetCPICharWidth())
*---------------------------------------------------
Method HBPrintPDF:GetRowsPerInch()
return ::nCPI
*---------------------------------------------------
Method HBPrintPDF:GetCPICharWidth(nCPI) // Breite eines Zeichens mit nCPI
   local nSizeX
   DEFAULT nCPI TO ::GetCPI()
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nSizeX := 25.4 / nCPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nSizeX :=  1.0 / nCPI
      otherwise  // Points = 1/72 Inch
           nSizeX := 72.0 / nCPI
   end
return nSizeX
*---------------------------------------------------
Method HBPrintPDF:SAY(nRow,nCol,xData,cAlign,nCPI,nLPI) // min == 1,1
   local cTxt := "", nAlign
   do case
      case ValType(xData)=="D"
           cTxt := dtoc(xData)
      case ValType(xData)=="L"
           cTxt := iif(xData,::cDefaultYes,::cDefaultNo)
      case ValType(xData)=="N"
           cTxt := TransForm(xData,::cDefaultNumFormat)
           DEFAULT cAlign TO "R"
      case ValType(xData)=="C"
           cTxt := xData
      otherwise
           cTxt := var2char(xData)
   end
   DEFAULT cAlign TO "L"
   cAlign := upper(left(alltrim(cAlign)+"L",1))
   nAlign := ::GetTextAlign()  // alte Einstellung speichern, save old value
   do case
      case cAlign == "L"
           ::SetTextAlign(TEXT_ALIGN_LEFT)
      case cAlign == "R"
           ::SetTextAlign(TEXT_ALIGN_RIGHT)
      case cAlign == "C" .or. cAlign == "M" .or. cAlign == "Z"
           ::SetTextAlign(TEXT_ALIGN_CENTER)
   end
   ::DrawText(::nColToPosX(nCol,nCPI),::nRowToPosY(nRow,nLPI), cTxt )
   ::SetTextAlign(nAlign)
return self
*---------------------------------------------------
Method HBPrintPDF:SayLine(nRowTop,nColLeft,nRowBottom,nColRight,cAlign1,cAlign2,nOffset,nCPI,nLPI)
   local nStartX, nStartY, nEndX, nEndY, nSizeX, nSizeY,nOffsetX,nOffsetY

   DEFAULT nRowTop    TO 0
   DEFAULT nRowBottom TO 0
   DEFAULT nColLeft   TO 0
   DEFAULT nColRight  TO 0

   nStartY := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nStartX := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)

   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()

   if valtype(cAlign1)<>"C" .or. len(cAlign1) <> 2
      cAlign1 := NIL
   endif
   if valtype(cAlign2)<>"C" .or. len(cAlign2) <> 2
      cAlign2 := NIL
   endif

   DEFAULT nOffset TO 0

   do case
      case nRowTop == nRowBottom
           DEFAULT cAlign1 TO SAYLINE_ALIGN_MIDDLE_LEFT
           DEFAULT cAlign2 TO SAYLINE_ALIGN_MIDDLE_RIGHT
           nOffsetX := 0
           nOffsetY := nOffset
      case nColLeft == nColRight
           DEFAULT cAlign1 TO SAYLINE_ALIGN_TOP_CENTER
           DEFAULT cAlign2 TO SAYLINE_ALIGN_BOTTOM_CENTER
           nOffsetX := nOffset
           nOffsetY := 0
      otherwise
           DEFAULT cAlign1 TO SAYLINE_ALIGN_MIDDLE_CENTER // SAYLINE_ALIGN_TOP_LEFT
           DEFAULT cAlign2 TO SAYLINE_ALIGN_MIDDLE_CENTER // SAYLINE_ALIGN_BOTTOM_RIGHT
           nOffsetX := 0
           nOffsetY := 0
   end

   do case
      case cAlign1[1] == SAYLINE_ALIGN_LEFT
           // nStartX is OK
      case cAlign1[1] == SAYLINE_ALIGN_CENTER
           nStartX += nSizeX/2
      case cAlign1[1] == SAYLINE_ALIGN_RIGHT
           nStartX += nSizeX
   end

   do case
      case cAlign2[1] == SAYLINE_ALIGN_LEFT
           // nEndX is OK
      case cAlign2[1] == SAYLINE_ALIGN_CENTER
           nEndX += nSizeX/2
      case cAlign2[1] == SAYLINE_ALIGN_RIGHT
           nEndX += nSizeX
   end

   do case
      case cAlign1[2] == SAYLINE_ALIGN_TOP
           nStartY -= ::GetTextBound(GETTEXTBOUND_TOP)
      case cAlign1[2] == SAYLINE_ALIGN_MIDDLE
           nStartY -= ::GetTextBound(GETTEXTBOUND_TOP) - nSizeY/2
      case cAlign1[2] == SAYLINE_ALIGN_BASELINE
           // all OK
      case cAlign1[2] == SAYLINE_ALIGN_BOTTOM
           nStartY += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   end

   do case
      case cAlign2[2] == SAYLINE_ALIGN_TOP
           nEndY -= ::GetTextBound(GETTEXTBOUND_TOP)
      case cAlign2[2] == SAYLINE_ALIGN_MIDDLE
           nEndY -= ::GetTextBound(GETTEXTBOUND_TOP) - nSizeY/2
      case cAlign2[2] == SAYLINE_ALIGN_BASELINE
           // nEndY is OK
      case cAlign2[2] == SAYLINE_ALIGN_BOTTOM
           nEndY += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   end

   ::DrawLine(nStartX+nOffsetX, nStartY+nOffsetY, nEndX+nOffsetX, nEndY+nOffsetY)

return self
*---------------------------------------------------
Method HBPrintPDF:SayBox(nRowTop,nColLeft,nRowBottom,nColRight,nOffset,nDrawOptions,nCPI,nLPI)
   local nLeft, nTop, nWidth, nHeight, nEndY, nEndX, nSizeX, nSizeY, nMax, nMin
   DEFAULT nOffset TO 0
   DEFAULT nDrawOptions TO DRAWOPTIONS_OUTLINE
   DEFAULT nRowTop    TO 0
   DEFAULT nRowBottom TO 0
   DEFAULT nColLeft   TO 0
   DEFAULT nColRight  TO 0

   if nRowTop > nRowBottom .or. nColLeft > nColRight // Fehler vermeiden
      nMax := max(nRowTop,nRowBottom)
      nMin := min(nRowTop,nRowBottom)
      nRowTop    := nMin
      nRowBottom := nMax
      nMax := max(nColLeft,nColRight)
      nMin := min(nColLeft,nColRight)
      nColLeft   := nMin
      nColRight  := nMax
   endif

   // char -> mm
   nTop    := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nLeft   := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)

   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()

   nTop    -= ::GetTextBound(GETTEXTBOUND_TOP)
   nEndY   += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   nWidth  := nEndX - nLeft + nSizeX
   nHeight := nEndY - nTop

   ::DrawBox(nLeft-nOffset, nTop-nOffset, nWidth+nOffset*2, nHeight+nOffset*2, nDrawOptions)

return self
*---------------------------------------------------
Method HBPrintPDF:SayImage(nRowTop,nColLeft,nRowBottom,nColRight,nRotate,nCPI,nLPI,lRatio)
   local nLeft, nTop, nWidth, nHeight, nEndY, nEndX, nSizeX, nSizeY, nMax, nMin, IsOK
   local nSizeBmpX,nSizeBmpY, nFaktor := 1
   DEFAULT nRowTop     TO 0
   DEFAULT nRowBottom  TO 0
   DEFAULT nColLeft    TO 0
   DEFAULT nColRight   TO 0
   DEFAULT lRatio      TO .t.

   if nRowTop > nRowBottom .or. nColLeft > nColRight // Fehler vermeiden
      nMax := max(nRowTop,nRowBottom)
      nMin := min(nRowTop,nRowBottom)
      nRowTop    := nMin
      nRowBottom := nMax
      nMax := max(nColLeft,nColRight)
      nMin := min(nColLeft,nColRight)
      nColLeft   := nMin
      nColRight  := nMax
   endif

   // char -> mm
   nTop    := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nLeft   := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)
   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()
   nTop    -= ::GetTextBound(GETTEXTBOUND_TOP)
   nEndY   += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   nWidth  := nEndX - nLeft + nSizeX
   nHeight := nEndY - nTop

   if lRatio
           // ::PrintBmp(    nPosX,  nPosY,   nXSize,    nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit  ) // -> lSuccess
      IsOK := ::PrintBMP(  nLeft+1, nTop+1, nWidth-2, nHeight-2,            ,    ,        ,        , nRotate, NIL , NIL )
   else
           // ::DrawImage(   nLeft, nTop  , nWidth  , nHeight  )    // druckt auch verzerrt - not fine, but fit in place.           // -> lSuccess
      IsOK := ::DrawImage( nLeft+1, nTop+1, nWidth-2, nHeight-2)
   endif
return IsOK
*---------------------------------------------------
Method HBPrintPDF:nColToPosX(nCol,nCPI)                  // -> :say(nCol,
   local nCharWidth, nPosX
   DEFAULT nCol TO ::nFirstRow
   DEFAULT nCPI TO ::nCPI
   if ::SayOrigin0                                       // Clipper Top Left 0,0
      nCol++
   endif
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nCharWidth := 25.4 / nCPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nCharWidth :=  1.0 / nCPI
      otherwise  // Points = 1/72 Inch
           nCharWidth := 72.0 / nCPI
   end
   nCol--  // nCol soll gedruckt werden ...
   nPosX := max(1,   nCol * nCharWidth )
return nPosX
*---------------------------------------------------
Method HBPrintPDF:nRowToPosY(nRow,nLPI)                  // -> :say(,nRow
   local nPageY, nLineHeight, nPosY
   DEFAULT nRow TO ::nFirstLine
   DEFAULT nLPI TO ::nLPI
   if ::SayOrigin0                                       // Clipper Top Left 0,0
      nRow++
   endif
   nPageY := ::PageHeight()
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nLineHeight := 25.4 / nLPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nLineHeight :=  1.0 / nLPI
      otherwise  // Points = 1/72 Inch
           nLineHeight := 72.0 / nLPI
   end
   if ::GetOrigin()==PAGE_ORIGIN_TOP_LEFT
      nPosY := max(1, nRow * nLineHeight)
   else
      nPosY := max(1, nPageY - (nRow * nLineHeight))
   endif
return nPosY
*---------------------------------------------------
Method HBPrintPDF:GetColorRGB(nXbaseGraColorConstant,nRGB )           // Xbase++ color -> {r,g,b} || nRGB -> 1=red-part, 2=green-part, 3 = blue-part
   local xReturn,x
   static aColorTable :=  { { GRA_CLR_WHITE     , {   1,   1,   1 } } ,;            // RGB  0 - 255 => 0.0000000 - 1.0000000
                            { GRA_CLR_BLACK     , {   0,   0,   0 } } ,;
                            { GRA_CLR_BLUE      , {   0,   0,   1 } } ,;
                            { GRA_CLR_RED       , {   1,   0,   0 } } ,;
                            { GRA_CLR_PINK      , {   1,   0,   1 } } ,;
                            { GRA_CLR_GREEN     , {   0,   1,   0 } } ,;
                            { GRA_CLR_CYAN      , {   0,   1,   1 } } ,;
                            { GRA_CLR_YELLOW    , {   1,   1,   0 } } ,;
                            { GRA_CLR_DARKGRAY  , { 0.5, 0.5, 0.5 } } ,;
                            { GRA_CLR_DARKBLUE  , {   0,   0, 0.5 } } ,;
                            { GRA_CLR_DARKRED   , { 0.8,   0,   0 } } ,;
                            { GRA_CLR_DARKPINK  , { 0.6,   0, 0.6 } } ,;
                            { GRA_CLR_DARKGREEN , {   0, 0.6,   0 } } ,;
                            { GRA_CLR_DARKCYAN  , {   0, 0.6, 0.6 } } ,;
                            { GRA_CLR_BROWN     , { 0.5, 0.25,  0 } } ,;
                            { GRA_CLR_PALEGRAY  , { 0.7, 0.7 ,0.7 } } }
   DEFAULT nXbaseGraColorConstant TO GRA_CLR_BLACK
   DEFAULT nRGB TO 0
   x := aScan(aColorTable,{|aC| aC[1]==nXbaseGraColorConstant })
   do case
      case empty(x) .and. empty(nRGB)
           xReturn := {0,0,0}
      case empty(x)
           xReturn := 0
      case empty(nRGB)
           xReturn := aColorTable[x,2]
      otherwise
           xReturn := aColorTable[x,2,nRGB]
   end
return xReturn
*---------------------------------------------------
METHOD HBPrintPDF:getPageNo(cDataType)
   local uReturn
   if cDataType==NIL
      cDataType := "N"
   else
      cDataType := upper(alltrim(cDataType))
   endif
   do case
      case cDataType == "N"
           uReturn := ::nPageNo
      case cDataType == "C"
           uReturn := alltrim(str(::nPageNo))
   end
return uReturn
*---------------------------------------------------
METHOD HBPrintPDF:PrintPageNo(nPosX, nPosY, cMask, cAlign, xColor)
   DEFAULT nPosX  TO ::PageWidth()/2
   DEFAULT nPosY  TO ::PageHeight()-12
   DEFAULT cMask  TO "- #PN -"
   DEFAULT cAlign TO "C"
   cMask := strTran(cMask,"#PN",::getPageNo("C"))
   cMask := strTran(cMask,"#PC",alltrim(str(::PageCount())))
return ::PrintText( nPosX, nPosY, cMask, cAlign,,, xColor)
*---------------------------------------------------
METHOD HBPrintPDF:PrintText( nPosX, nPosY, xData, cAlign, nMaxLen, cArt, xColor, nDrehen )
                        //old              cTxt   cAusrichtung     n/a   nFarbe
   local cTxt := "", nAlign, lAppendText, lColorChanged := .f., aResetColor

   DEFAULT cAlign  TO " "
   DEFAULT nDrehen TO 0
   // :AppendText() .or. :DrawText() ?
   lAppendText := ( nPosX == NIL .or. nPosY == NIL )
   // xData -> String
   do case
      case ValType(xData)=="D"
           cTxt := dtoc(xData)
      case ValType(xData)=="L"
           cTxt := iif(xData,::cDefaultYes,::cDefaultNo)
      case ValType(xData)=="N"
           cTxt := TransForm(xData,::cDefaultNumFormat)
           DEFAULT cAlign TO "R"
      case ValType(xData)=="C"
           cTxt := xData
      otherwise
           cTxt := var2char(xData)
   end
   // cAlign / cAusrichtung
   nAlign := ::GetTextAlign()  // alte Einstellung speichern, save old value
   do case
      case lAppendText
           cAlign  := " "
           nDrehen := 0
      case cAlign == "L"
           ::SetTextAlign(TEXT_ALIGN_LEFT)
      case cAlign == "R"
           ::SetTextAlign(TEXT_ALIGN_RIGHT)
      case cAlign == "C" .or. cAlign == "M" .or. cAlign == "Z"
           ::SetTextAlign(TEXT_ALIGN_CENTER)
   end
   // lnger als nMaxLen ? / too long ?
   if ValType(nMaxLen)=="N" .and. ! empty(nMaxLen)
      do while ::GetTextWidth(cTxt) > nMaxLen .and. ! empty(cTxt)
         cTxt := left(cTxt,len(cTxt)-1)
      enddo
   endif

   if xColor == NIL
      // don't change the color
      lColorChanged := .f.
   else
      if ValType(xColor)=="A"  // RGB Array !
         // don't change xColor !
      else
         // get the RGB Array out of the Xbase++ color number
         xColor := ::GetColorRGB(xColor,0) // xColor := {r,g,b}
      endif
      // save the last set colors
      aResetColor := { ::nOldTextColorRed , ::nOldTextColorGreen , ::nOldTextColorBlue }
      ::SetTextColor(xColor[1],xColor[2],xColor[3]) // change the values of ::nOldTextColorRed, ::nOldTextColorGreen, ::nOldTextColorBlue
      lColorChanged := .t.
   endif

   // Append, Rotate, normal ?
   do case
      case lAppendText
           ::AppendText(cTxt)
      case ValType(nDrehen)=="N" .and. ! empty(nDrehen)
           ::DrawRotatedText(nPosX, nPosY,nDrehen,cTxt )
      otherwise
           ::DrawText(nPosX, nPosY, cTxt )
           if ! empty(cAlign)
              ::SetTextAlign(nAlign)
           endif
   end

   // Reset color
   if lColorChanged
      ::SetTextColor(aResetColor[1], aResetColor[2], aResetColor[3])
   endif

return .t.
*---------------------------------------------------
METHOD HBPrintPDF:PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit )
   local nImageID, lFehler := .f., cErrTxt, nDLL, nOldLineWidth, nOldImage           // cFileNameID = C or N ...

   DEFAULT nHAlign TO 0
   DEFAULT nVAlign TO 0
   DEFAULT nRotate TO 0
   DEFAULT nBox    TO 0      //  nBox > 0 zeichnet eine Box auf die Auenkante
                             //  nBox > 0 draw a box outside the image

   do case
      case nRotate ==  90    // Passend zu SayImage()
           nRotate :=   1    //  90 degrees anti-clockwise
      case nRotate == 180    // Passend zu SayImage()
           nRotate :=   3    // 180 degrees
      case nRotate == 270    // Passend zu SayImage()
           nRotate :=   2    //  90 degrees clockwise
      otherwise
           nRotate :=   0    //  normal
   endcase

   // wird nur verwendet, wenn nXSize, nYSize nicht angegeben sind.
   // if nXSize, nYSize are nil, this parameter will scale the bitmap
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           DEFAULT nDotsPerUnit TO       5 // 5 Punkte pro mm, 5 dots per mm            100 => 20mm, 160 => 32 mm
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           DEFAULT nDotsPerUnit TO     128 // 128 dots per Inch ( 5 * 25.6 mm = 128 )
      otherwise  // Points = 1/72 Inch
           DEFAULT nDotsPerUnit TO       1.7778 // dots per point
   end

   nOldImage := ::SelectedImage()

   do case
      case nID==NIL .and. empty(cFileNameID)
           // Keine Resource, Kein Dateiname, Kein Stringpuffer => aktuell selektierte Grafik benutzen !
           // NO resource, NO filename, NO Stringbuffer         => use selected image
           if nOldImage # 0
              // OK
           else
              cErrTxt := "NO IMAGE SELECTED"
              lFehler := .t.
           endif
      case nID==NIL .and. valtype(cFileNameID)=="C"
           // Dateiname !
           nImageID := ::AddImageFile(cFileNameID,0)
           if nImageID > 0
              // OK
           else
              cErrTxt := "FILENAME NOT VALID"
              lFehler := .t.
           endif
      case nID==NIL .and. valtype(cFileNameID)=="N"
           // Image ID  !
           if ::SelectImage(cFileNameID)
              // OK
           else
              cErrTxt := "IMAGEID NOT VALID"
              lFehler := .t.
           endif
      case nID==NIL
           // ERROR
           cErrTxt := "PARAMETER ERROR ID"
           lFehler := .t.
      case nID == -1          // XbpBitmap SetBuffer() String
           if valtype(cFileNameID)=="C" .and. ! empty(cFileNameID)
              nImageID := ::AddImageFromXbpBMP(cFileNameID)
              if nImageID > 0
                 ::AddImageID(nImageID,"PBMP"+alltrim(str(seconds())))
              else
                 cErrTxt := "BMP-BUFFER NOT VALID"
                 lFehler := .t.
              endif
           else
              cErrTxt := "BMP-BUFFER NOT VALID"
              lFehler := .t.
           endif
      case nID > 0            // RESOURCE ID
           if valtype(cFileNameID)=="C" .and. ! empty(cFileNameID) // IN DLL
              nDLL := DllLoad(cFileNameID)
           else
              nDLL := NIL
           endif
           nImageID := ::AddImageResource(nID,0,nDLL)
           if nImageID > 0
              // OK
           else
              cErrTxt := "RESOURCE-ID NOT VALID"
              lFehler := .t.
           endif
      otherwise
           // ERROR
           cErrTxt := "PARAMETER ERROR"
           lFehler := .t.
   end

   if empty(nXSize) .or. empty(nYSize)
      if nRotate==1 .or. nRotate==2 // 90 oder 270
         nYSize := ::ImageWidth()  / nDotsPerUnit
         nXSize := ::ImageHeight() / nDotsPerUnit
      else
         nXSize := ::ImageWidth()  / nDotsPerUnit
         nYSize := ::ImageHeight() / nDotsPerUnit
      endif
      if empty(nXSize) .or. empty(nYSize)
         cErrTxt := "IMAGE SIZE 0"
         lFehler := .t.
      endif
   endif

   if lFehler
      ::PrintText( nPosX, nPosY, cErrTxt )
   else
      if ::FitImage(nPosX, nPosY, nXSize, nYSize, nHAlign, nVAlign, nRotate)
         if nBox < 0
            nBox := ::nDefaultLineWidth
         endif
         // OK
         if nBox > 0
            nOldLineWidth := ::SetLineWidth(nBox)
            ::DrawBox(nPosX, nPosY, nXSize, nYSize, 0) // outline
            ::SetLineWidth(nOldLineWidth)
         endif
      else
         ::PrintText( nPosX, nPosY, "IMAGE PRINT ERROR" )
         lFehler := .t.
      endif
   endif

   if nOldImage <> ::SelectedImage()
      ::SelectImage(nOldImage)
   endif

return ! lFehler
*---------------------------------------------------
Method HBPrintPDF:IsTrue(nWert)
Return nWert # 0
*---------------------------------------------------
Method HBPrintPDF:IsFalse(nWert)
Return nWert == 0
*---------------------------------------------------
Method HBPrintPDF:GetTextAlign()
return ::nAlign
*---------------------------------------------------
Method HBPrintPDF:LineFeed( nLines, nDistance )
    local nValue
    DEFAULT nLines       TO 1
    DEFAULT ::nLineFeed  TO ::GetTextHeight()
    DEFAULT nDistance    TO ::nLineFeed
    nValue := nLines * nDistance
RETURN nValue
*---------------------------------------------------
Method HBPrintPDF:nBaselineToTop(nPosY)
return nPosY - ::GetTextBound(GETTEXTBOUND_TOP)
*---------------------------------------------------
Method HBPrintPDF:nTopToBaseline(nTop)
return nTop  + ::GetTextBound(GETTEXTBOUND_TOP)
*---------------------------------------------------
Method HBPrintPDF:GetPrinterBinA(p1)
   local aBin := {}
   DEFAULT p1 TO ::GetDefaultPrinterName()
   aBin := tokenize(alltrim(::GetPrinterBins(p1)),CRLF)  // {[1,"Name 1"]CRLF[2,"Name 2"]CRLF...} -> {[1,"Name 1"],[2,"Name 2"],...}
   aeval(aBin,{|cZeile,i| aBin[i] := &("{"+cZeile+"}")}) // {[1,"Name 1"],[2,"Name 2"],...}       -> {{1,"Name 1"},{2,"Name 2"},...}
return aBin
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterNameA(cPrinters)      // cPrinters := ::GetLatestPrinterNames() / ::GetPrinterNames()  ==> Array
   local aPrinter := {}, cDelim
   if empty(cPrinters)
      DEFAULT cPrinters TO ::GetPrinterNames()                   // -> ["Printer 1","Printer 2","Printer 3"]
   endif
   aPrinter  := &("{"+cPrinters+"}")        // -> [{"Printer 1","Printer 2","Printer 3"}] -> {"Printer 1","Printer 2","Printer 3"}
return aPrinter
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageID(nImageID,cName)
   local lError := .f.
   do case
      case nImageID==NIL .or. cName==NIL .or. ValType(nImageID)#"N" .or. ValType(cName)#"C"
           lError := .t.
      case empty(nImageID) .or. empty(cName)
           lError := .t.
      otherwise
           cName := upper(alltrim(cName))
           do case
              case 0 # aScan(::aImageID,{|aZ| aZ[1]==nImageID .and. aZ[2]==cName })
                   // OK !
              case 0 # aScan(::aImageID,{|aZ| aZ[2]==cName })
                   lError := .t.        // cName muss einmalig sein / cName have to be unique
              otherwise
                   aadd(::aImageID,{nImageID,cName})
           end
   end
return ! lError
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveImageID(xVal)
   local lError := .f., x, bSeek
   do case
      case xVal==NIL .or. ! valtype(xVal) $ "CN" .or. empty(xVal)
           lError := .t.
      case valtype(xVal) == "C"
           xVal  := upper(alltrim(xVal))
           bSeek := {|aZ| aZ[2]==xVal }

      case valtype(xVal) == "N"
           bSeek := {|aZ| aZ[1]==xVal }
   end
   if bSeek # NIL
      do while .t.
         x := aScan(::aImageID,bSeek)
         if x == 0
            exit
         else
            aRemove(::aImageID,x)
         endif
      enddo
   endif
return ! lError
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageIDByName(cName)
   local nImageID := 0  // not found, error !
   if valtype(cName)="C" .and. ! empty(cName)
      cName    := upper(alltrim(cName))
      nImageID := aScan(::aImageID,{|aZ| aZ[2]==cName })
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectImageByName(cName)
   local nImageID
   nImageID := ::GetImageIDByName(cName)
return ::SelectImage(nImageID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFile(cFileName, nOptions)  // -> QuickPDFAddImageFromFile(int InstanceID, char * FileName, int Options)
   local nImageID
   nImageID := ::GetImageIDByName(cFileName)                  // ist die Datei schon enthalten / only once
   if nImageID == 0
      nImageID := ::AddImageFromFile(cFileName, nOptions)
      if nImageID > 0 // OK !
         ::AddImageID(nImageID,cFileName)
      endif
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageFile(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate,cFileName,nOptions)
                                // -> QuickPDFAddImageFromFile(int InstanceID, char * FileName, int Options)
                                // -> QuickPDFFitImage(Left, Top, Width, Height: Double; HAlign, VAlign, Rotate: Integer): Integer;
   local nImageID, lOK := .f.
   nImageID := ::AddImageFile(cFileName, nOptions)
   if nImageID > 0
      lOK := ::FitImage(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate)
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageResource(nResourceID,nOptions,nDLL)          // ONLY / NUR    BMP BITMAP RESOURCEN !!!
   LOCAL nImageID, cImageName
   DEFAULT nResourceID TO 0
   if nResourceID > 0
      cImageName := "RES_ID_"+alltrim(str(nResourceID))
      // schon vorhanden ?
      nImageID := ::GetImageIDByName(cImageName)                  // ist das Image schon enthalten / only once
      if nImageID == 0
         nImageID := ::AddImageFromString(  ::cLoadResource(nDLL,nResourceID, 2, , .t. ) , nOptions )
         if nImageID > 0 // OK !
            ::AddImageID(nImageID,cImageName)
         endif
      endif
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageResource(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate,nResourceID,nOptions)
   local nImageID, lOK := .f.
   nImageID := ::AddImageResource(nResourceID,nOptions)
   if nImageID > 0
      lOK := ::FitImage(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate)
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromXbpBMP(cBMP) // NUR BEI BMP fr Rckgabewert von XbpBitmap():setBuffer()   !!! *.BMP !!!
                                           // ONLY with BMP and return value from XbpBitmap():setBuffer()!!! *.BMP !!!
   if left(cBMP,2) # "BM"
      cBMP := "BM"+U2BIN(len(cBMP)+14)+W2BIN(0)+W2BIN(0)+U2BIN(BIN2U(left(cBMP,4))+14)+cBMP
   endif
return ::AddImageFromString(cBMP,0)        // !!! *.BMP !!!
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintCheckBox( nLeft, nPosY, nSize, cType )  // nSize auen/outline , cType="B" eckig/Box, "R" .or. "C" rund/circle
   local lOK, nTop
   DEFAULT nLeft TO 10
   DEFAULT nPosY TO 10
   DEFAULT nSize TO  3
   DEFAULT cType TO "B"

   nTop := nPosY - nSize   // auf die / on the baseline

   cType := upper(left(alltrim(cType)+"B",1))
   if cType=="B"
      lOK := ::DrawBox(nLeft+0.5, nTop, nSize, nSize, 0) // outline
   else
      lOK := ::DrawCircle(nLeft+0.5, nTop, nSize, 0) // outline
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CalcCheckDigit(uEAN13_Nr) // EAN13 -> 12 + checkDigit -> 13
   local x, lFehler := .f., nSummOdd, nSummEven, cOddEven, nCheckSummValue,;
         cCheckSummValue, cCheckSummDigit,nCheckSummDigit
   do case
      case Valtype(uEAN13_Nr)="N"
           uEAN13_Nr := left(alltrim(str(uEAN13_Nr,15,0)),12)
      case Valtype(uEAN13_Nr)="C"
           uEAN13_Nr := left(alltrim(uEAN13_Nr,15),12)
      otherwise
           cCheckSummDigit := "X"
           lFehler := .t.
   endcase
   if len(uEAN13_Nr) < 12 .and. ! lFehler // noch keine Fehlermeldung erhalten,
      cCheckSummDigit := "X" // -> error
      lFehler := .t.
   endif
   if ! lFehler
      nSummOdd  := 0
      nSummEven := 0
      cOddEven  := "E" // erste Position des EAN13 Strings ist per Definition EVEN !

      for x := 1 to 12
          if cOddEven = "E"
             nSummEven += val(substr(uEAN13_Nr,x,1))
             cOddEven  := "O"
          else
             nSummOdd  += val(substr(uEAN13_Nr,x,1))
             cOddEven  := "E"
          endif
      next

      // CheckSummDigit ist der Unterschied von nCheckSummValue zum nchsten vollen 10er.
      nCheckSummValue := nSummEven + nSummOdd * 3 // Gewichtung der Odd Position mit 3
      cCheckSummValue := right(alltrim(str(nCheckSummValue,15,0)),1) // letzte Position ermitteln
      nCheckSummDigit := 10 - val(cCheckSummValue) // von 0->0 1->9 2->8 etc.
      cCheckSummDigit := right(alltrim(str(nCheckSummDigit,3,0)),1)
   endif
return cCheckSummDigit
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateNewObject()
return FpQCall( {::_hdll_,"QuickPDFCreateNewObject"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetBaseURL()
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetBaseURLA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupPrintable(iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetOptionalContentGroupPrintable"} ,"__sl__sl__sl",::_id_,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupVisible(iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetOptionalContentGroupVisible"} ,"__sl__sl__sl",::_id_,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetAnnotBorderColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFillColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldBackgroundColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldBorderColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetLineColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColorRGB(nID,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetOutlineColor(nID,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorRGB(nTableID,nBorderIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableBorderColor(nTableID,nBorderIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellBackgroundColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellBorderColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellTextColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextHighlightColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextUnderlineColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColorRGB(cXFAFieldName,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetXFAFormFieldBorderColor(cXFAFieldName,nR/255,nG/255,nB/255)

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColorXB(nIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetAnnotBorderColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorXB(nXbColor)          // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFillColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorXB(nIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldBackgroundColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorXB(nIndex,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldBorderColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorXB(nIndex,nXbColor)       // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorXB(nXbColor)                   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetLineColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColorXB(nID,nXbColor)             // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetOutlineColor(nID,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorXB(nTableID,nBorderIndex,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableBorderColor(nTableID,nBorderIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellBackgroundColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellBorderColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellTextColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorXB(nXbColor)        // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorXB(nXbColor)     // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextHighlightColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorXB(nXbColor)     // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextUnderlineColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColorXB(cXFAFieldName,nXbColor)    // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetXFAFormFieldBorderColor(cXFAFieldName,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARemoveUsageRights(iFileHandle)
return 0 # FpQCall( {::_hdll_,"QuickPDFDARemoveUsageRights"} ,"__sl__sl__sl",::_id_,iFileHandle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageMatrix(dM11, dM12, dM21, dM22, dMDX, dMDY)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawImageMatrix"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,dM11,dM12,dM21,dM22,dMDX,dMDY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileID(iIndex)
return FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileID"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NormalizePage(iNormalizeOptions)
return FpQCall( {::_hdll_,"QuickPDFNormalizePage"} ,"__sl__sl__sl",::_id_,iNormalizeOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveUsageRights()
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveUsageRights"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldSubmitAction(iIndex, sActionType, sLink)
   sActionType := ::ForceAnsi(sActionType)
   sLink       := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldSubmitActionA"} ,"__sl__sl__sl__pt__pt",::_id_,iIndex,sActionType,sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMarkupAnnotStyle(iIndex, dRed, dGreen, dBlue, dTransparency)
return FpQCall( {::_hdll_,"QuickPDFSetMarkupAnnotStyle"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,iIndex,dRed,dGreen,dBlue,dTransparency)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderDCErasePage(iNewErasePage)
return FpQCall( {::_hdll_,"QuickPDFSetRenderDCErasePage"} ,"__sl__sl__sl",::_id_,iNewErasePage)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAEmbedFileStreams(iFileHandle, sRootPath)
   sRootPath := ::ForceAnsi(sRootPath)
return FpQCall( {::_hdll_,"QuickPDFDAEmbedFileStreamsA"} ,"__sl__sl__sl__pt",::_id_,iFileHandle,sRootPath)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldNoExport(iIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetFormFieldNoExport"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldRequired(iIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetFormFieldRequired"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveCustomInformation(sKey)
   sKey := ::ForceAnsi(sKey)
return FpQCall( {::_hdll_,"QuickPDFRemoveCustomInformationA"} ,"__sl__sl__pt",::_id_,sKey)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderStyle(iIndex, dWidth, iStyle, dDashOn, dDashOff)
return FpQCall( {::_hdll_,"QuickPDFSetAnnotBorderStyle"} ,"__sl__sl__sl__f8__sl__f8__f8",::_id_,iIndex,dWidth,iStyle,dDashOn,dDashOff)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldChoiceType(iIndex, iChoiceType)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldChoiceType"} ,"__sl__sl__sl__sl",::_id_,iIndex,iChoiceType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldNoExport(iIndex, iNoExport)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldNoExport"} ,"__sl__sl__sl__sl",::_id_,iIndex,iNoExport)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldRequired(iIndex, iRequired)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldRequired"} ,"__sl__sl__sl__sl",::_id_,iIndex,iRequired)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DADrawRotatedCapturedPage(iFileHandle, iDACaptureID, iDestPageRef, dPntLeft, dPntBottom, dPntWidth, dPntHeight, dAngle)
return 0 # FpQCall( {::_hdll_,"QuickPDFDADrawRotatedCapturedPage"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8__f8",::_id_,iFileHandle,iDACaptureID,iDestPageRef,dPntLeft,dPntBottom,dPntWidth,dPntHeight,dAngle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageBox(iFileHandle, iPageRef, iBoxIndex, iDimension)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageBox"} ,"__f8__sl__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef,iBoxIndex,iDimension)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAHasPageBox(iFileHandle, iPageRef, iBoxIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFDAHasPageBox"} ,"__sl__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef,iBoxIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPageFromCanvasDC(iDPI, iOptions)
return 0 # FpQCall( {::_hdll_,"QuickPDFNewPageFromCanvasDC"} ,"__sl__sl__sl__sl",::_id_,iDPI,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListAdd(sFontName)
   sFontName := ::ForceAnsi(sFontName)
return 0 # FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListAddA"} ,"__sl__sl__pt",::_id_,sFontName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListCount()
return FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListGet(iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListGetA"} ,"__pt__sl__sl",::_id_,iIndex)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveAll()
return FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListRemoveAll"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveIndex(iIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListRemoveIndex"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveName(sFontName)
   sFontName := ::ForceAnsi(sFontName)
return 0 # FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListRemoveNameA"} ,"__sl__sl__pt",::_id_,sFontName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveImageToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFSaveImageToString"} ,"__pt__sl",::_id_))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToDestination(dLeft, dTop, dWidth, dHeight, iDestID, iOptions)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToDestination"} ,"__sl__sl__f8__f8__f8__f8__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,iDestID,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompareOutlines(iFirstOutlineID, iSecondOutlineID)
return 0 # FpQCall( {::_hdll_,"QuickPDFCompareOutlines"} ,"__sl__sl__sl__sl",::_id_,iFirstOutlineID,iSecondOutlineID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetPageBox(iFileHandle, iPageRef, iBoxIndex, dX1, dY1, dX2, dY2)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetPageBox"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iFileHandle,iPageRef,iBoxIndex,dX1,dY1,dX2,dY2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestName(iDestID)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetDestNameA"} ,"__pt__sl__sl",::_id_,iDestID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontEncoding()
return FpQCall( {::_hdll_,"QuickPDFGetFontEncoding"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineObjectNumber(iOutlineID)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineObjectNumber"} ,"__sl__sl__sl",::_id_,iOutlineID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetRenderScale()
return FpQCall( {::_hdll_,"QuickPDFGetRenderScale"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewDestination(iDestPage, iZoom, iDestType, dLeft, dTop, dRight, dBottom)
return FpQCall( {::_hdll_,"QuickPDFNewDestination"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iDestPage,iZoom,iDestType,dLeft,dTop,dRight,dBottom)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewNamedDestination(sDestName, iDestID)
   sDestName := ::ForceAnsi(sDestName)
return FpQCall( {::_hdll_,"QuickPDFNewNamedDestinationA"} ,"__sl__sl__pt__sl",::_id_,sDestName,iDestID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFindImagesMode(iNewFindImagesMode)
return FpQCall( {::_hdll_,"QuickPDFSetFindImagesMode"} ,"__sl__sl__sl",::_id_,iNewFindImagesMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageResolution(iHorizontal, iVertical, iUnits)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetImageResolution"} ,"__sl__sl__sl__sl__sl",::_id_,iHorizontal,iVertical,iUnits)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineNamedDestination(iOutlineID, sDestName)
   sDestName := ::ForceAnsi(sDestName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineNamedDestinationA"} ,"__sl__sl__sl__pt",::_id_,iOutlineID,sDestName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineRemoteDestination(iOutlineID, sFileName, iOpenPage, iZoom, iDestType, dPntLeft, dPntTop, dPntRight, dPntBottom, iNewWindow)
   sFileName := ::ForceAnsi(sFileName)
   sFileName := ::PathFormatPdf(sFileName)
return FpQCall( {::_hdll_,"QuickPDFSetOutlineRemoteDestinationA"} ,"__sl__sl__sl__pt__sl__sl__sl__f8__f8__f8__f8__sl",::_id_,iOutlineID,sFileName,iOpenPage,iZoom,iDestType,dPntLeft,dPntTop,dPntRight,dPntBottom,iNewWindow)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOverprint(iStrokingOverprint, iOtherOverprint, iOverprintMode)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOverprint"} ,"__sl__sl__sl__sl__sl",::_id_,iStrokingOverprint,iOtherOverprint,iOverprintMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderDCOffset(iNewOffsetX, iNewOffsetY)
return FpQCall( {::_hdll_,"QuickPDFSetRenderDCOffset"} ,"__sl__sl__sl__sl",::_id_,iNewOffsetX,iNewOffsetY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderScale(dNewScale)
return FpQCall( {::_hdll_,"QuickPDFSetRenderScale"} ,"__sl__sl__f8",::_id_,dNewScale)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTextMarkupAnnotation(iMarkupType, dLeft, dTop, dWidth, dHeight)
return FpQCall({::_hdll_,"QuickPDFAddTextMarkupAnnotation"},"__sl__sl__sl__f8__f8__f8__f8",::_id_,iMarkupType, dLeft, dTop, dWidth, dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearImage(iImageID)
return 0 # FpQCall({::_hdll_,"QuickPDFClearImage"},"__sl__sl__sl",::_id_,iImageID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetAnnotationCount(iFileHandle,iPageRef)
return FpQCall({::_hdll_,"QuickPDFDAGetAnnotationCount"},"__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionDest(iActionID)
return FpQCall({::_hdll_,"QuickPDFGetActionDest"},"__sl__sl__sl",::_id_,iActionID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionURL(iActionID)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetActionURLA"} ,"__pt__sl__sl",::_id_,iActionID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotDest(iIndex)
return FpQCall({::_hdll_,"QuickPDFGetAnnotDest"},"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotQuadCount(iIndex)
return FpQCall({::_hdll_,"QuickPDFGetAnnotQuadCount"},"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotQuadPoints(iIndex,iQuadNumber,iPointNumber)
return FpQCall({::_hdll_,"QuickPDFGetAnnotQuadCount"},"__f8__sl__sl__sl__sl",::_id_,iIndex,iQuadNumber,iPointNumber)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentFileSize()
return FpQCall({::_hdll_,"QuickPDFGetDocumentFileSize"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldActionID(iIndex,sTriggerEvent)
   DEFAULT iIndex        TO 1
   sTriggerEvent := ::ForceAnsi(sTriggerEvent)
return FpQCall({::_hdll_,"QuickPDFGetFormFieldActionIDA"},"__sl__sl__sl__pt",::_id_,iIndex,sTriggerEvent)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInstalledFontsByCharset( iCharsetIndex, iOptions)
   DEFAULT iCharsetIndex TO 2 // default Charset=2, ANSI=1 ??
   DEFAULT iOptions      TO 1 // CSV Rckgabe
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetInstalledFontsByCharsetA"} ,"__pt__sl__sl__sl",::_id_,iCharsetIndex, iOptions)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInstalledFontsByCodePage( iCodePage, iOptions )
   DEFAULT iCodePage TO 1252
   DEFAULT iOptions      TO 1 // CSV Rckgabe
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetInstalledFontsByCodePageA"} ,"__pt__sl__sl__sl",::_id_,iCodePage, iOptions)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMaxObjectNumber()
return FpQCall({::_hdll_,"QuickPDFGetMaxObjectNumber"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigCount()
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigCount"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderCount(iOptionalContentConfigID)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigOrderCount"},"__sl__sl__sl",::_id_,iOptionalContentConfigID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemID(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigOrderItemID"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemLabel(iOptionalContentConfigID, iItemIndex)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOptionalContentConfigOrderItemLabelA"} ,"__pt__sl__sl__sl",::_id_,iOptionalContentConfigID, iItemIndex)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemLevel(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigOrderItemLevel"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemType(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigOrderItemType"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigState(iOptionalContentConfigID,iOptionalContentGroupID)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigState"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveXFAEntries(iOptions)
   DEFAULT iOptions TO 0 // PDF ->  Reserved for future use, should be set to 0.
return FpQCall({::_hdll_,"QuickPDFRemoveXFAEntries"},"__sl__sl__sl",::_id_,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetActionURL(iActionID, sNewURL)
   sNewURL := ::ForceAnsi(sNewURL)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetActionURLA"} ,"__sl__sl__sl__pt",::_id_,iActionID, sNewURL)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotQuadPoints(iIndex, iQuadNumber,dX1,dY1,dX2,dY2,dX3,dY3,dX4,dY4)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetAnnotQuadPoints"} ,"__sl__sl__sl__f8__f8__f8__f8__f8__f8__f8__f8",::_id_,iIndex,iQuadNumber,dX1,dY1,dX2,dY2,dX3,dY3,dX4,dY4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionWordGap(dNewWordGap)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextExtractionWordGap"} ,"__sl__sl__f8",::_id_,dNewWordGap)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToLocalFile(nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall({::_hdll_,"QuickPDFAddLinkToLocalFileA"},"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImagePageCountFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall({::_hdll_,"QuickPDFGetImagePageCountFromString"},"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveEmbeddedFile(p1)
return 0 # FpQCall({::_hdll_,"QuickPDFRemoveEmbeddedFile"},"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveGlobalJavaScript(PackageName)
   PackageName := ::ForceAnsi(PackageName)
return 0 # FpQCall({::_hdll_,"QuickPDFRemoveGlobalJavaScriptA"},"__sl__sl__pt",::_id_,PackageName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RequestPrinterStatus(p1)
return FpQCall({::_hdll_,"QuickPDFRequestPrinterStatus"},"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                           // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return FpQCall({::_hdll_,"QuickPDFSetAnnotBorderColor"},"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCompatibility(p1,p2)
return 0 # FpQCall({::_hdll_,"QuickPDFSetCompatibility"},"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetEmbeddedFileStrProperty(nIndex, nTag, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return FpQCall({::_hdll_,"QuickPDFSetEmbeddedFileStrPropertyA"},"__sl__sl__sl__sl__pt",::_id_, nIndex, nTag, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddArcToPath(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFAddArcToPath"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddCJKFont(p1)
return FpQCall( {::_hdll_,"QuickPDFAddCJKFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddCurveToPath(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFAddCurveToPath"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddEmbeddedFile(sFileName,sMIMEType)
   sFileName := ::ForceAnsi(sFileName)
   sMIMEType := ::ForceAnsi(sMIMEType)
return FpQCall( {::_hdll_,"QuickPDFAddEmbeddedFileA"} ,"__sl__sl__pt__pt",::_id_,sFileName,sMIMEType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFileAttachment(sTitle, nEmbeddedFileID)
   sTitle := ::ForceAnsi(sTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddFileAttachmentA"} ,"__sl__sl__pt__sl",::_id_,sTitle, nEmbeddedFileID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFormFieldSub(nI,sSubName)
   sSubName := ::ForceAnsi(sSubName)
return FpQCall( {::_hdll_,"QuickPDFAddFormFieldSubA"} ,"__sl__sl__sl__pt",::_id_,nI,sSubName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFormFont(p1)
return FpQCall( {::_hdll_,"QuickPDFAddFormFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddGlobalJavaScript(sPackageName,sJavaScript)
   sPackageName := ::ForceAnsi(sPackageName)
   sJavaScript  := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddGlobalJavaScriptA"} ,"__sl__sl__pt__pt",::_id_,sPackageName,sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromFile(sFileName,nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFAddImageFromFileA"} ,"__sl__sl__pt__sl",::_id_,sFileName,nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromFileOffset(sFileName,nOffset,nDataLength,nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFAddImageFromFileOffsetA"} ,"__sl__sl__pt__sl__sl__sl",::_id_,sFileName,nOffset,nDataLength,nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromString(iSource, nOptions)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
return ::_ptb_free_( FpQCall({::_hdll_,"QuickPDFAddImageFromString"},"__sl__sl__pt__sl",::_id_,::_b(iSource,ptb,1),nOptions) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLGIDictToPage(sDictContent)
   sDictContent := ::ForceAnsi(sDictContent)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLGIDictToPageA"} ,"__sl__sl__pt",::_id_,sDictContent)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLineToPath(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFAddLineToPath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToEmbeddedFile(nLeft, nTop, nWidth, nHeight, nEmbeddedFileID, sTitle, nOptions)
   sTitle := ::ForceAnsi(sTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToEmbeddedFileA"} ,"__sl__sl__f8__f8__f8__f8__sl__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, nEmbeddedFileID, sTitle, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToFile(nLeft, nTop, nWidth, nHeight, sFileName, nPage, nPosition, nNewWindow, nOptions)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__f8__sl__sl",::_id_,;
                                       nLeft, nTop, nWidth, nHeight, sFileName, nPage, nPosition, nNewWindow, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToJavaScript(nLeft, nTop, nWidth, nHeight, sJavaScript, nOptions)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToJavaScriptA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sJavaScript, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToPage(p1,p2,p3,p4,p5,p6,p7)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToPage"} ,"__sl__sl__f8__f8__f8__f8__sl__f8__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToWeb(nLeft, nTop, nWidth, nHeight, sLink, nOptions)
   sLink := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToWebA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sLink, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddNoteAnnotation(nLeft, nTop, nAnnotType, nPopupLeft, nPopupTop, nPopupWidth,;
                                    nPopupHeight, sTitle, sContents, nRed, nGreen, nBlue, nOpen)
   sTitle    := ::ForceAnsi(sTitle)
   sContents := ::ForceAnsi(sContents)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddNoteAnnotationA"} ,"__sl__sl__f8__f8__sl__f8__f8__f8__f8__pt__pt__f8__f8__f8__sl",::_id_,;
                                    nLeft, nTop, nAnnotType, nPopupLeft, nPopupTop, nPopupWidth,;
                                    nPopupHeight, sTitle, sContents, nRed, nGreen, nBlue, nOpen)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddPageLabels(nStart, nStyle, nOffset, sPrefix)
   sPrefix := ::ForceAnsi(sPrefix)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddPageLabelsA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nStart, nStyle, nOffset, sPrefix)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSeparationColor(sColorName, nC, nM, nY, nK, nOptions)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddSeparationColorA"} ,"__sl__sl__pt__f8__f8__f8__f8__sl",::_id_,sColorName, nC, nM, nY, nK, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddStandardFont(p1)
return FpQCall( {::_hdll_,"QuickPDFAddStandardFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSubsettedFont(sFontName, nCharsetIndex, sSubsetChars)
   sFontName    := ::ForceAnsi(sFontName)
   sSubsetChars := ::ForceAnsi(sSubsetChars)
return FpQCall( {::_hdll_,"QuickPDFAddSubsettedFontA"} ,"__sl__sl__pt__sl__pt",::_id_,sFontName, nCharsetIndex, sSubsetChars)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSVGAnnotationFromFile(nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFAddSVGAnnotationFromFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddToBuffer(Buffer, Source, nSourceLength) // intern, nichts ndern => _b()
return FpQCall( {::_hdll_,"QuickPDFAddToBuffer"} ,"__sl__sl__pt__pt__sl",::_id_, Buffer, Source, nSourceLength) // OK !
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddToFileList(sListName,sFileName)
   sListName := ::ForceAnsi(sListName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFAddToFileListA"} ,"__sl__sl__pt__pt",::_id_,sListName,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeFont(sFontName, nEmbed)
   sFontName := ::ForceAnsi(sFontName)
return FpQCall( {::_hdll_,"QuickPDFAddTrueTypeFontA"} ,"__sl__sl__pt__sl",::_id_,sFontName, nEmbed)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeFontFromFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFAddTrueTypeFontFromFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddType1Font(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFAddType1FontA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddU3DAnnotationFromFile(nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFAddU3DAnnotationFromFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AnalyseFile(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"QuickPDFAnalyseFileA"} ,"__sl__sl__pt__pt",::_id_,sFileName, sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AnnotationCount()
return FpQCall( {::_hdll_,"QuickPDFAnnotationCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendSpace(p1)
return FpQCall( {::_hdll_,"QuickPDFAppendSpace"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendTableColumns(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFAppendTableColumns"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendTableRows(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFAppendTableRows"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendText(sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFAppendTextA"} ,"__sl__sl__pt",::_id_,sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ApplyStyle(sStyleName)
   sStyleName := ::ForceAnsi(sStyleName)
return 0 # FpQCall( {::_hdll_,"QuickPDFApplyStyleA"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AttachAnnotToForm(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFAttachAnnotToForm"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:BeginPageUpdate()
return FpQCall( {::_hdll_,"QuickPDFBeginPageUpdate"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CapturePage(p1)
return FpQCall( {::_hdll_,"QuickPDFCapturePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CapturePageEx(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFCapturePageEx"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CharWidth(p1)
return FpQCall( {::_hdll_,"QuickPDFCharWidth"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckObjects()
return FpQCall( {::_hdll_,"QuickPDFCheckObjects"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckPageAnnots()
return FpQCall( {::_hdll_,"QuickPDFCheckPageAnnots"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearFileList(sListName)
   sListName := ::ForceAnsi(sListName)
return 0 # FpQCall( {::_hdll_,"QuickPDFClearFileListA"} ,"__sl__sl__pt",::_id_,sListName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearPageLabels()
return FpQCall( {::_hdll_,"QuickPDFClearPageLabels"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearTextFormatting()
return FpQCall( {::_hdll_,"QuickPDFClearTextFormatting"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CloneOutlineAction(p1)
return FpQCall( {::_hdll_,"QuickPDFCloneOutlineAction"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClonePages(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"QuickPDFClonePages"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CloseOutline(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFCloseOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClosePath()
return FpQCall( {::_hdll_,"QuickPDFClosePath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressContent()
return 0 # FpQCall( {::_hdll_,"QuickPDFCompressContent"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressFonts(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFCompressFonts"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressImages(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFCompressImages"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressPage()
return 0 # FpQCall( {::_hdll_,"QuickPDFCompressPage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CopyPageRanges(nDocumentID,sRangeList)
   sRangeList := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"QuickPDFCopyPageRangesA"} ,"__sl__sl__sl__pt",::_id_,nDocumentID,sRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateBuffer(nBufferLength) // intern, nichts ndern => _b() => gibt Pointer auf Buffer zurck.
return FpQCall({::_hdll_,"QuickPDFCreateBuffer"},"__pt__sl__sl",::_id_,nBufferLength) // OK ! *** don't change ***
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateTable(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFCreateTable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAAppendFile(p1)
return FpQCall( {::_hdll_,"QuickPDFDAAppendFile"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACapturePage(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDACapturePage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACapturePageEx(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFDACapturePageEx"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACloseFile(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFDACloseFile"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DADrawCapturedPage(p1,p2,p3,p4,p5,p6,p7)
return 0 # FpQCall( {::_hdll_,"QuickPDFDADrawCapturedPage"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAExtractPageText(p1,p2,p3)
Return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAExtractPageTextA"} ,"__pt__sl__sl__sl__sl",::_id_,p1,p2,p3)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAFindPage(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAFindPage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldCount(p1)
return FpQCall( {::_hdll_,"QuickPDFDAGetFormFieldCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldTitle(p1,p2)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetFormFieldTitleA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldValue(p1,p2)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetFormFieldValueA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageDataToString(p1,p2,p3)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetImageDataToString"} ,"__pt__sl__sl__sl__sl",::_id_,p1,p2,p3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageDblProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFDAGetImageDblProperty"} ,"__f8__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageIntProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFDAGetImageIntProperty"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageListCount(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAGetImageListCount"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetInformation(nFileHandle, sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetInformationA"} ,"__pt__sl__sl__pt",::_id_,nFileHandle, sKey)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetObjectCount(p1)
return FpQCall( {::_hdll_,"QuickPDFDAGetObjectCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageCount(p1)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageHeight(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageHeight"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageImageList(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageImageList"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageWidth(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageWidth"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAHidePage(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFDAHidePage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAMovePage(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"QuickPDFDAMovePage"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DANewPage(p1)
return FpQCall( {::_hdll_,"QuickPDFDANewPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DANewPages(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDANewPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAOpenFile(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"QuickPDFDAOpenFileA"} ,"__sl__sl__pt__pt",::_id_,sFileName, sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAOpenFileReadOnly(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"QuickPDFDAOpenFileReadOnlyA"} ,"__sl__sl__pt__pt",::_id_,sFileName, sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAPageRotation(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAPageRotation"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToDC(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"QuickPDFDARenderPageToDC"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToFile(nFileHandle, nPageRef, nOptions, nDPI, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFDARenderPageToFileA"} ,"__sl__sl__sl__sl__sl__sl__pt",::_id_,nFileHandle, nPageRef, nOptions, nDPI, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToString(p1,p2,p3,p4)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDARenderPageToString"} ,"__pt__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARotatePage(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"QuickPDFDARotatePage"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASaveAsFile(nFileHandle, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASaveAsFileA"} ,"__sl__sl__sl__pt",::_id_,nFileHandle, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASaveImageDataToFile(nFileHandle, nImageListID, nImageIndex, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFDASaveImageDataToFileA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nFileHandle, nImageListID, nImageIndex, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetInformation(nFileHandle, sKey, sNewValue)
   sKey      := ::ForceAnsi(sKey)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetInformationA"} ,"__sl__sl__sl__pt__pt",::_id_,nFileHandle, sKey, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetPageSize(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetPageSize"} ,"__sl__sl__sl__sl__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Decrypt()
return 0 # FpQCall( {::_hdll_,"QuickPDFDecrypt"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DecryptFile(sInputFileName, sOutputFileName, sPassword)
   sInputFileName  := ::ForceAnsi(sInputFileName)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
   sPassword       := ::ForceAnsi(sPassword)
return 0 # FpQCall( {::_hdll_,"QuickPDFDecryptFileA"} ,"__sl__sl__pt__pt__pt",::_id_,sInputFileName, sOutputFileName, sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteAnalysis(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteAnalysis"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteAnnotation(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteAnnotation"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteFormField(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteLayer()
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteLayer"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteOptionalContentGroup(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteOptionalContentGroup"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeletePageLGIDict(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFDeletePageLGIDict"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeletePages(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFDeletePages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DocJavaScriptAction(sActionType,sJavaScript)
   sActionType := ::ForceAnsi(sActionType)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFDocJavaScriptActionA"} ,"__sl__sl__pt__pt",::_id_,sActionType,sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DocumentCount()
return FpQCall( {::_hdll_,"QuickPDFDocumentCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawArc(p1,p2,p3,p4,p5,p6,p7)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawArc"} ,"__sl__sl__f8__f8__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawBarcode(nLeft, nTop, nWidth, nHeight, sText, nBarcode, nOptions)
   sText := ::ForceAnsi(sText)
   if nBarcode == 2 // EAN13
      if len(sText)==12
         sText += ::CalcCheckDigit(sText)
      endif
   endif
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawBarcodeA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nBarcode, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawBox(p1,p2,p3,p4,p5)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawBox"} ,"__sl__sl__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawCapturedPage(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawCapturedPage"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawCircle(p1,p2,p3,p4)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawCircle"} ,"__sl__sl__f8__f8__f8__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawDataMatrixSymbol(nLeft, nTop, nModuleSize, sText, nEncoding, nSymbolSize, nOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawDataMatrixSymbolA"} ,"__sl__sl__f8__f8__f8__pt__sl__sl__sl",::_id_,;
                                                                nLeft, nTop, nModuleSize, sText, nEncoding, nSymbolSize, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawEllipse(p1,p2,p3,p4,p5)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawEllipse"} ,"__sl__sl__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawEllipticArc(p1,p2,p3,p4,p5,p6,p7,p8)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawEllipticArc"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawHTMLText(nLeft, nTop, nWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawHTMLTextA"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nLeft, nTop, nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawHTMLTextBox(nLeft, nTop, nWidth, nHeight, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFDrawHTMLTextBoxA"} ,"__pt__sl__f8__f8__f8__f8__pt",::_id_,nLeft, nTop, nWidth, nHeight, sHTMLText)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImage(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawImage"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawLine(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFDrawLine"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawMultiLineText(nXPos, nYPos, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawMultiLineTextA"} ,"__sl__sl__f8__f8__pt__pt",::_id_,nXPos, nYPos, sDelimiter, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPath(p1)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"QuickPDFDrawPath"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPathEvenOdd(p1)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"QuickPDFDrawPathEvenOdd"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPostScriptXObject(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawPostScriptXObject"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedCapturedPage(p1,p2,p3,p4,p5,p6)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawRotatedCapturedPage"} ,"__sl__sl__sl__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedImage(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawRotatedImage"} ,"__sl__sl__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedText(nXPos, nYPos, nAngle, sText)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawRotatedTextA"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nAngle, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedTextBox(nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawRotatedTextBoxA"} ,"__sl__sl__f8__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRoundedBox(p1,p2,p3,p4,p5,p6)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"QuickPDFDrawRoundedBox"} ,"__sl__sl__f8__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawScaledImage(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawScaledImage"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawSpacedText(nXPos, nYPos, nSpacing, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawSpacedTextA"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nSpacing, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTableRows(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFDrawTableRows"} ,"__f8__sl__sl__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawText(nXPos, nYPos, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawTextA"} ,"__sl__sl__f8__f8__pt",::_id_,nXPos, nYPos, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTextArc(nXPos, nYPos, nRadius, nAngle, sText, nDrawOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawTextArcA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nXPos, nYPos, nRadius, nAngle, sText, nDrawOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTextBox(nLeft, nTop, nWidth, nHeight, sText, nOptions)                  // *HB*
       local nPrintedLines
       ::DrawTextBoxNextTop := nTop
       sText := ::ForceAnsi(sText)
       nPrintedLines := FpQCall( {::_hdll_,"QuickPDFDrawTextBoxA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nOptions)
       ::DrawTextBoxNextTop += ::LineFeed(nPrintedLines)
return nPrintedLines
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawWrappedText(nXPos, nYPos, nWidth, sText)
       sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawWrappedTextA"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EmbeddedFileCount()
return FpQCall( {::_hdll_,"QuickPDFEmbeddedFileCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EmbedFile(sTitle, sFileName, sMIMEType)
   sTitle    := ::ForceAnsi(sTitle)
   sFileName := ::ForceAnsi(sFileName)
   sMIMEType := ::ForceAnsi(sMIMEType)
return 0 # FpQCall( {::_hdll_,"QuickPDFEmbedFileA"} ,"__sl__sl__pt__pt__pt",::_id_,sTitle, sFileName, sMIMEType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncodePermissions(p1,p2,p3,p4,p5,p6,p7,p8)
return FpQCall( {::_hdll_,"QuickPDFEncodePermissions"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Encrypt(sOwner, sUser, nStrength, nPermissions)
   sOwner := ::ForceAnsi(sOwner)
   sUser  := ::ForceAnsi(sUser)
return 0 # FpQCall( {::_hdll_,"QuickPDFEncryptA"} ,"__sl__sl__pt__pt__sl__sl",::_id_,sOwner, sUser, nStrength, nPermissions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptFile(sInputFileName, sOutputFileName, sOwner, sUser, nStrength, nPermissions)
   sInputFileName  := ::ForceAnsi(sInputFileName)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
   sOwner          := ::ForceAnsi(sOwner)
   sUser           := ::ForceAnsi(sUser)
return 0 # FpQCall( {::_hdll_,"QuickPDFEncryptFileA"} ,"__sl__sl__pt__pt__pt__pt__sl__sl",::_id_,sInputFileName, sOutputFileName, sOwner, sUser, nStrength, nPermissions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionAlgorithm()
return FpQCall( {::_hdll_,"QuickPDFEncryptionAlgorithm"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionStatus()
return FpQCall( {::_hdll_,"QuickPDFEncryptionStatus"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionStrength()
return FpQCall( {::_hdll_,"QuickPDFEncryptionStrength"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptWithFingerprint(sFingerprint)
   sFingerprint := ::ForceAnsi(sFingerprint)
return 0 # FpQCall( {::_hdll_,"QuickPDFEncryptWithFingerprintA"} ,"__sl__sl__pt",::_id_,sFingerprint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EndPageUpdate()
return FpQCall( {::_hdll_,"QuickPDFEndPageUpdate"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePages(sInputFileName, sPassword, sOutputFileName, sRangeList)
   if pcount()=3 // alte Syntax, old syntax
      sRangeList      := sOutputFileName
      sOutputFileName := sPassword
      sPassword       := ""
   endif
   sInputFileName  := ::ForceAnsi(sInputFileName)
   sPassword       := ::ForceAnsi(sPassword)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
   sRangeList      := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"QuickPDFExtractFilePagesA"} ,"__sl__sl__pt__pt__pt__pt",::_id_, sInputFileName, sPassword, sOutputFileName, sRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePageText(sFileName, sPassword, nPage, nOptions)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
RETURN ::ReadString( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFExtractFilePageTextA"} ,"__pt__sl__pt__pt__sl__sl",::_id_,sFileName, sPassword, nPage, nOptions)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractPageRanges(sRangeList)
   sRangeList := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"QuickPDFExtractPageRangesA"} ,"__sl__sl__pt",::_id_,sRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractPages(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFExtractPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FileListCount(sListName)
   sListName := ::ForceAnsi(sListName)
return FpQCall( {::_hdll_,"QuickPDFFileListCountA"} ,"__sl__sl__pt",::_id_,sListName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FileListItem(sListName, nIndex)
   sListName := ::ForceAnsi(sListName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFFileListItemA"} ,"__pt__sl__pt__sl",::_id_,sListName, nIndex)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindFonts()
return FpQCall( {::_hdll_,"QuickPDFFindFonts"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindFormFieldByTitle(sTitle)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"QuickPDFFindFormFieldByTitleA"} ,"__sl__sl__pt",::_id_,sTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindImages()
return FpQCall( {::_hdll_,"QuickPDFFindImages"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitImage(p1,p2,p3,p4,p5,p6,p7)
return 0 # FpQCall( {::_hdll_,"QuickPDFFitImage"} ,"__sl__sl__f8__f8__f8__f8__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitRotatedTextBox(nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFFitRotatedTextBoxA"} ,"__sl__sl__f8__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitTextBox(nLeft, nTop, nWidth, nHeight, sText, nOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFFitTextBoxA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FlattenFormField(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFFlattenFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontCount()
return FpQCall( {::_hdll_,"QuickPDFFontCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontFamily()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFFontFamilyA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontHasKerning()
return 0 # FpQCall( {::_hdll_,"QuickPDFFontHasKerning"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontName()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFFontNameA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontReference()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFFontReferenceA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontSize()
return FpQCall( {::_hdll_,"QuickPDFFontSize"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontType()
return FpQCall( {::_hdll_,"QuickPDFFontType"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldCount()
return FpQCall( {::_hdll_,"QuickPDFFormFieldCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldHasParent(p1)
return FpQCall( {::_hdll_,"QuickPDFFormFieldHasParent"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldJavaScriptAction(nIndex, sActionType, sJavaScript)
   sActionType := ::ForceAnsi(sActionType)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFFormFieldJavaScriptActionA"} ,"__sl__sl__sl__pt__pt",::_id_,nIndex, sActionType, sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldWebLinkAction(nIndex, sActionType, sLink)
   sActionType := ::ForceAnsi(sActionType)
   sLink       := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"QuickPDFFormFieldWebLinkActionA"} ,"__sl__sl__sl__pt__pt",::_id_,nIndex, sActionType, sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionType(nActionID)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetActionTypeA"} ,"__pt__sl__sl",::_id_,nActionID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnalysisInfo(nAnalysisID,nAnalysisItem)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetAnalysisInfoA"} ,"__pt__sl__sl__sl",::_id_,nAnalysisID,nAnalysisItem)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotActionID(nIndex)
return FpQCall( {::_hdll_,"QuickPDFGetAnnotActionID"} ,"__sl__sl__sl",::_id_,nIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotDblProperty(nIndex, nTag)
return FpQCall( {::_hdll_,"QuickPDFGetAnnotDblProperty"} ,"__f8__sl__sl__sl",::_id_,nIndex, nTag)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotIntProperty(nIndex, nTag)
return FpQCall( {::_hdll_,"QuickPDFGetAnnotIntProperty"} ,"__sl__sl__sl__sl",::_id_,nIndex, nTag)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotStrProperty(nIndex, nTag)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetAnnotStrPropertyA"} ,"__pt__sl__sl__sl",::_id_,nIndex, nTag)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetBarcodeWidth(nNominalWidth, sText, nBarcode)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFGetBarcodeWidthA"} ,"__f8__sl__f8__pt__sl",::_id_,nNominalWidth, sText, nBarcode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCanvasDC(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetCanvasDC"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCatalogInformation(sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetCatalogInformationA"} ,"__pt__sl__pt",::_id_,sKey)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCustomInformation(sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetCustomInformationA"} ,"__pt__sl__pt",::_id_,sKey)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCustomKeys(nLocation)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetCustomKeysA"} ,"__pt__sl__sl",::_id_,nLocation)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDefaultPrinterName()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDefaultPrinterNameA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestPage(p1)
return FpQCall( {::_hdll_,"QuickPDFGetDestPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestType(p1)
return FpQCall( {::_hdll_,"QuickPDFGetDestType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestValue(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetDestValue"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocJavaScript(sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocJavaScriptA"} ,"__pt__sl__pt",::_id_,sActionType)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentFileName()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocumentFileNameA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetDocumentID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentIdentifier(p1,p2)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocumentIdentifierA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentMetadata()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocumentMetadataA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentResourceList()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocumentResourceListA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileContentToFile(nIndex, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileContentToFileA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileContentToString(nIndex)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileContentToString"} ,"__pt__sl__sl",::_id_,nIndex))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileIntProperty(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileIntProperty"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileStrProperty(p1,p2)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileStrPropertyA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEncryptionFingerprint()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetEncryptionFingerprintA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFileMetadata(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFileMetadataA"} ,"__pt__sl__pt__pt",::_id_,sFileName, sPassword)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFirstChildOutline(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFirstChildOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFirstOutline()
return FpQCall( {::_hdll_,"QuickPDFGetFirstOutline"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFontID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontObjectNumber()
return FpQCall( {::_hdll_,"QuickPDFGetFontObjectNumber"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldAlignment(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldAlignment"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldAnnotFlags(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldAnnotFlags"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBackgroundColor(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBackgroundColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderColor(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBorderColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderProperty(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBorderProperty"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderStyle(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBorderStyle"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBound(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBound"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldCaption(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldCaptionA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldChildTitle(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldChildTitleA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldChoiceType(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldChoiceType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldColor(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldComb(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldComb"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldDefaultValue(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldDefaultValueA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldDescription(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldDescriptionA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldFlags(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldFlags"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldFontName(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldFontNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldJavaScript(nIndex, sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldJavaScriptA"} ,"__pt__sl__sl__pt",::_id_,nIndex, sActionType)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldKidCount(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldKidCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldMaxLen(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldMaxLen"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldPage(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldPrintable(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldPrintable"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldReadOnly(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldReadOnly"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldRotation(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldRotation"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubCount(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldSubCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubName(p1,p2)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldSubNameA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubTempIndex(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldSubTempIndex"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTabOrder(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldTabOrder"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTextFlags(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldTextFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTextSize(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldTextSize"} ,"__f8__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTitle(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldTitleA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldType(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldValue(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldValueA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldValueByTitle(sTitle)
   sTitle := ::ForceAnsi(sTitle)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldValueByTitleA"} ,"__pt__sl__pt",::_id_,sTitle)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldVisible(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldVisible"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldWebLink(nIndex, sActionType)
   sActionType := ::ForceAnsi(sActionType)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldWebLinkA"} ,"__pt__sl__sl__pt",::_id_,nIndex, sActionType)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFontCount()
return FpQCall( {::_hdll_,"QuickPDFGetFormFontCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFontName(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFontNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetGlobalJavaScript(sPackageName)
   sPackageName := ::ForceAnsi(sPackageName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetGlobalJavaScriptA"} ,"__pt__sl__pt",::_id_,sPackageName)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextHeight(nWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"QuickPDFGetHTMLTextHeightA"} ,"__f8__sl__f8__pt",::_id_,nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextLineCount(nWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"QuickPDFGetHTMLTextLineCountA"} ,"__sl__sl__f8__pt",::_id_,nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextWidth(nMaxWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"QuickPDFGetHTMLTextWidthA"} ,"__f8__sl__f8__pt",::_id_,nMaxWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetImageID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImagePageCount(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFGetImagePageCountA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInformation(nInstanceID)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetInformationA"} ,"__pt__sl__sl",::_id_,nInstanceID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetKerning(sCharPair)
   sCharPair := ::ForceAnsi(sCharPair)
return FpQCall( {::_hdll_,"QuickPDFGetKerningA"} ,"__sl__sl__pt",::_id_,sCharPair)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetNamedDestination(sDestName)
   sDestName := ::ForceAnsi(sDestName)
return FpQCall( {::_hdll_,"QuickPDFGetNamedDestinationA"} ,"__sl__sl__pt",::_id_,sDestName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetNextOutline(p1)
return FpQCall( {::_hdll_,"QuickPDFGetNextOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetObjectCount()
return FpQCall( {::_hdll_,"QuickPDFGetObjectCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOpenActionDestination()
return FpQCall( {::_hdll_,"QuickPDFGetOpenActionDestination"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOpenActionJavaScript()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOpenActionJavaScriptA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOptionalContentGroupID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupName(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOptionalContentGroupNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOrigin()
return FpQCall( {::_hdll_,"QuickPDFGetOrigin"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineActionID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineActionID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineColor(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineDest(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineDest"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineJavaScript(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOutlineJavaScriptA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineOpenFile(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOutlineOpenFileA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlinePage(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlinePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineStyle(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineStyle"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineWebLink(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOutlineWebLinkA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageBox(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetPageBox"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageJavaScript(sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageJavaScriptA"} ,"__pt__sl__pt",::_id_,sActionType)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLabel(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageLabelA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLayout()
return FpQCall( {::_hdll_,"QuickPDFGetPageLayout"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLGIDictContent(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageLGIDictContentA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLGIDictCount()
return FpQCall( {::_hdll_,"QuickPDFGetPageLGIDictCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageMode()
return FpQCall( {::_hdll_,"QuickPDFGetPageMode"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageText(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageTextA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetParentOutline(p1)
return FpQCall( {::_hdll_,"QuickPDFGetParentOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrevOutline(p1)
return FpQCall( {::_hdll_,"QuickPDFGetPrevOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterBins(sPrinterName)                                   // ==> ::GetPrinterBinA(p1) ==> Array
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()                                                   // HB 2.00
   sPrinterName := ::ForceAnsi(sPrinterName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPrinterBinsA"} ,"__pt__sl__pt",::_id_,sPrinterName)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterNames()                                              // ==> ::GetPrinterNameA()  ==> Array
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPrinterNamesA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetSubsetString(sInputStr)
   sInputStr := ::ForceAnsi(sInputStr)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetSubsetString"} ,"__pt__sl__pt",::_id_,sInputStr)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellDblProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFGetTableCellDblProperty"} ,"__f8__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellIntProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFGetTableCellIntProperty"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellStrProperty(p1,p2,p3,p4)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetTableCellStrPropertyA"} ,"__pt__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableColumnCount(p1)
return FpQCall( {::_hdll_,"QuickPDFGetTableColumnCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableLastDrawnRow(p1)
return FpQCall( {::_hdll_,"QuickPDFGetTableLastDrawnRow"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableRowCount(p1)
return FpQCall( {::_hdll_,"QuickPDFGetTableRowCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTempPath()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetTempPathA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextAscent()
return FpQCall( {::_hdll_,"QuickPDFGetTextAscent"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBound(p1)
return FpQCall( {::_hdll_,"QuickPDFGetTextBound"} ,"__f8__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextDescent()
return FpQCall( {::_hdll_,"QuickPDFGetTextDescent"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextHeight()
return FpQCall( {::_hdll_,"QuickPDFGetTextHeight"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextSize()
return FpQCall( {::_hdll_,"QuickPDFGetTextSize"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextWidth(sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFGetTextWidthA"} ,"__f8__sl__pt",::_id_,sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewerPreferences(p1)
return FpQCall( {::_hdll_,"QuickPDFGetViewerPreferences"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedText(nWidth, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetWrappedTextA"} ,"__pt__sl__f8__pt__pt",::_id_,nWidth, sDelimiter, sText)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextBreakString(nWidth, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetWrappedTextBreakStringA"} ,"__pt__sl__f8__pt__pt",::_id_,nWidth, sDelimiter, sText)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextHeight(nWidth, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFGetWrappedTextHeightA"} ,"__f8__sl__f8__pt",::_id_,nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextLineCount(nWidth, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFGetWrappedTextLineCountA"} ,"__sl__sl__f8__pt",::_id_,nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldCount()
return FpQCall( {::_hdll_,"QuickPDFGetXFAFormFieldCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldName(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetXFAFormFieldNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldNames(sDelimiter)
   sDelimiter := ::ForceAnsi(sDelimiter)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetXFAFormFieldNamesA"} ,"__pt__sl__pt",::_id_,sDelimiter)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldValue(sXFAFieldName)
   sXFAFieldName:= ::ForceAnsi(sXFAFieldName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetXFAFormFieldValueA"} ,"__pt__sl__pt",::_id_,sXFAFieldName)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GlobalJavaScriptCount()
return FpQCall( {::_hdll_,"QuickPDFGlobalJavaScriptCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GlobalJavaScriptPackageName(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGlobalJavaScriptPackageNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HasFontResources()
return 0 # FpQCall( {::_hdll_,"QuickPDFHasFontResources"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HasPageBox(p1)
return FpQCall( {::_hdll_,"QuickPDFHasPageBox"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HidePage()
return FpQCall( {::_hdll_,"QuickPDFHidePage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageCount()
return FpQCall( {::_hdll_,"QuickPDFImageCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageFillColor()
return FpQCall( {::_hdll_,"QuickPDFImageFillColor"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageHeight()
return FpQCall( {::_hdll_,"QuickPDFImageHeight"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageHorizontalResolution()
return FpQCall( {::_hdll_,"QuickPDFImageHorizontalResolution"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageResolutionUnits()
return FpQCall( {::_hdll_,"QuickPDFImageResolutionUnits"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageType()
return FpQCall( {::_hdll_,"QuickPDFImageType"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageVerticalResolution()
return FpQCall( {::_hdll_,"QuickPDFImageVerticalResolution"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageWidth()
return FpQCall( {::_hdll_,"QuickPDFImageWidth"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImportEMFFromFile(sFileName, nFontOptions, nGeneralOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFImportEMFFromFileA"} ,"__sl__sl__pt__sl__sl",::_id_,sFileName, nFontOptions, nGeneralOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertPages(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFInsertPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertTableColumns(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFInsertTableColumns"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertTableRows(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFInsertTableRows"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:IsAnnotFormField(p1)
return FpQCall( {::_hdll_,"QuickPDFIsAnnotFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LastErrorCode()
return FpQCall( {::_hdll_,"QuickPDFLastErrorCode"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LastRenderError()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFLastRenderErrorA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LibraryVersion()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFLibraryVersionA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LicenseInfo()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFLicenseInfoA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Linearized()
return 0 # FpQCall( {::_hdll_,"QuickPDFLinearized"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromCanvasDC(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFLoadFromCanvasDC"} ,"__sl__sl__f8__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromFile(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return 0 # FpQCall( {::_hdll_,"QuickPDFLoadFromFileA"} ,"__sl__sl__pt__pt",::_id_,sFileName,sPassword) // changed in 8.x
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromString(iSource, sPassword)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
   sPassword := ::ForceAnsi(sPassword)
return  0 # ::_ptb_free_( FpQCall({::_hdll_,"QuickPDFLoadFromStringA"},"__sl__sl__pt__pt",::_id_,::_b(iSource,ptb,1),sPassword) ,ptb) // changed in 8.x
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadState()
return FpQCall( {::_hdll_,"QuickPDFLoadState"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeDocument(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFMergeDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFileList(sListName, sFileName)
   sListName := ::ForceAnsi(sListName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFMergeFileListA"} ,"__sl__sl__pt__pt",::_id_,sListName, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFileListFast(sListName, sFileName)
   sListName := ::ForceAnsi(sListName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFMergeFileListFastA"} ,"__sl__sl__pt__pt",::_id_,sListName, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFiles(sFirstFileName, sSecondFileName, sOutputFileName)
   sFirstFileName  := ::ForceAnsi(sFirstFileName)
   sSecondFileName := ::ForceAnsi(sSecondFileName)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFMergeFilesA"} ,"__sl__sl__pt__pt__pt",::_id_,sFirstFileName, sSecondFileName, sOutputFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeTableCells(p1,p2,p3,p4,p5)
return FpQCall( {::_hdll_,"QuickPDFMergeTableCells"} ,"__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveOutlineAfter(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFMoveOutlineAfter"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveOutlineBefore(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFMoveOutlineBefore"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MovePage(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFMovePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MovePath(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFMovePath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MultiplyScale(p1)
return FpQCall( {::_hdll_,"QuickPDFMultiplyScale"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewChildFormField(nIndex, sTitle, nFieldType)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"QuickPDFNewChildFormFieldA"} ,"__sl__sl__sl__pt__sl",::_id_,nIndex, sTitle, nFieldType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewCustomPrinter(sOriginalPrinterName)
   DEFAULT sOriginalPrinterName TO ::GetDefaultPrinterName()                                                   // HB 1.30
   // wenn sOriginalPrinterName ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if sOriginalPrinterName is not valid, the next line will cause a "internal data corrupted" error
   sOriginalPrinterName := ::ForceAnsi(sOriginalPrinterName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFNewCustomPrinterA"} ,"__pt__sl__pt",::_id_,sOriginalPrinterName)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewDocument()
return FpQCall( {::_hdll_,"QuickPDFNewDocument"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewFormField(sTitle, nFieldType)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"QuickPDFNewFormFieldA"} ,"__sl__sl__pt__sl",::_id_,sTitle, nFieldType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewOptionalContentGroup(sGroupName)
   sGroupName := ::ForceAnsi(sGroupName)
return FpQCall( {::_hdll_,"QuickPDFNewOptionalContentGroupA"} ,"__sl__sl__pt",::_id_,sGroupName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewOutline(nParent, sTitle, nDestPage, nDestPosition)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"QuickPDFNewOutlineA"} ,"__sl__sl__sl__pt__sl__f8",::_id_,nParent, sTitle, nDestPage, nDestPosition)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPage()                                                 // *HB* return 0==Error else set ::nPageNo
   local nReturn
   nReturn := FpQCall( {::_hdll_,"QuickPDFNewPage"} ,"__sl__sl",::_id_)
   if nReturn > 0
      ::nPageNo := nReturn
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPages(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFNewPages"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPostScriptXObject(sPS)
   sPS := ::ForceAnsi(sPS)
return FpQCall( {::_hdll_,"QuickPDFNewPostScriptXObjectA"} ,"__sl__sl__pt",::_id_,sPS)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewRGBAxialShader(sShaderName, nStartX, nStartY, nStartRed, nStartGreen, nStartBlue, nEndX, nEndY, nEndRed, nEndGreen, nEndBlue, nExtend)
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"QuickPDFNewRGBAxialShaderA"} ,"__sl__sl__pt__f8__f8__f8__f8__f8__f8__f8__f8__f8__f8__sl",::_id_,;
                              sShaderName, nStartX, nStartY, nStartRed, nStartGreen, nStartBlue, nEndX, nEndY, nEndRed, nEndGreen, nEndBlue, nExtend)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewStaticOutline(nParent, sTitle)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"QuickPDFNewStaticOutlineA"} ,"__sl__sl__sl__pt",::_id_,nParent, sTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OpenOutline(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFOpenOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OptionalContentGroupCount()
return FpQCall( {::_hdll_,"QuickPDFOptionalContentGroupCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OutlineCount()
return FpQCall( {::_hdll_,"QuickPDFOutlineCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OutlineTitle(nOutlineID)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFOutlineTitleA"} ,"__pt__sl__sl",::_id_,nOutlineID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageCount()
return FpQCall( {::_hdll_,"QuickPDFPageCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageHeight()
return FpQCall( {::_hdll_,"QuickPDFPageHeight"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageJavaScriptAction(sActionType,sJavaScript)
    sActionType := ::ForceAnsi(sActionType)
    sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFPageJavaScriptActionA"} ,"__sl__sl__pt__pt",::_id_,sActionType,sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageRotation()
return FpQCall( {::_hdll_,"QuickPDFPageRotation"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageWidth()
return FpQCall( {::_hdll_,"QuickPDFPageWidth"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintDocument(sPrinterName, nStartPage, nEndPage, nOptions)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()                                          // HB 1.30
   // wenn sPrinterName ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if sPrinterName is not a valid, the next line will cause a "internal data corrupted" error
   sPrinterName := ::ForceAnsi(sPrinterName)
return 0 # FpQCall( {::_hdll_,"QuickPDFPrintDocumentA"} ,"__sl__sl__pt__sl__sl__sl",::_id_,sPrinterName, nStartPage, nEndPage, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintDocumentToFile(sPrinterName, nStartPage, nEndPage, nOptions, sFileName)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()                                                    // HB 1.30
   // wenn cPrinterName ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if cPrinterName is not valid, the next line will cause an "internal data corrupted" error
   sPrinterName := ::ForceAnsi(sPrinterName)
   sFileName    := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFPrintDocumentToFileA"} ,"__sl__sl__pt__sl__sl__sl__pt",::_id_,sPrinterName, nStartPage, nEndPage, nOptions, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintOptions(nPageScaling, nAutoRotateCenter, sTitle)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"QuickPDFPrintOptionsA"} ,"__sl__sl__sl__sl__pt",::_id_,nPageScaling, nAutoRotateCenter, sTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseBuffer(p1)
return 0 = FpQCall( {::_hdll_,"QuickPDFReleaseBuffer"} ,"__sl__sl__pt",::_id_,p1)     // intern, don't change !!! OK !!!
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseLibrary()                                                        // NEW *HB* return .t. / .f.
   local lOK
   if empty(::_id_)
      lOK := .t.
   else
      if 0 # FpQCall( {::_hdll_,"QuickPDFReleaseLibrary"} ,"__sl__sl",::_id_)
         lOK := .t.
         ::_id_ := 0
      else
         lOK := .f.
      endif
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveAppearanceStream(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveAppearanceStream"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveDocument(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveOutline(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveStyle(sStyleName)
   sStyleName := ::ForceAnsi(sStyleName)
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveStyleA"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderDocumentToFile(nDPI, nStartPage, nEndPage, nOptions, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFRenderDocumentToFileA"} ,"__sl__sl__sl__sl__sl__sl__pt",::_id_,nDPI, nStartPage, nEndPage, nOptions, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToDC(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"QuickPDFRenderPageToDC"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToFile(nDPI, nPage, nOptions, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFRenderPageToFileA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nDPI, nPage, nOptions, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToString(p1,p2,p3)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
RETURN ::_str_result_(FpQCall( {::_hdll_,"QuickPDFRenderPageToString"} ,"__pt__sl__sl__sl__sl",::_id_,p1,p2,p3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceFonts()
return FpQCall( {::_hdll_,"QuickPDFReplaceFonts"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceImage(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFReplaceImage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceTag(sTag, sNewValue)
   sTag      := ::ForceAnsi(sTag)
   sNewValue := ::ForceAnsi(sNewValue)
return FpQCall( {::_hdll_,"QuickPDFReplaceTagA"} ,"__sl__sl__pt__pt",::_id_,sTag, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RetrieveCustomDataToFile(sKey, sFileName, nLocation)
   sKey      := ::ForceAnsi(sKey)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFRetrieveCustomDataToFileA"} ,"__sl__sl__pt__pt__sl",::_id_,sKey, sFileName, nLocation)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RetrieveCustomDataToString(cKey, nLocation) // cKey == ASCIIZ == OK !  // ########### Anfrage an Support.
   cKey := ::ForceAnsi(cKey)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
RETURN ::_str_result_(FpQCall( {::_hdll_,"QuickPDFRetrieveCustomDataToString"} ,"__pt__sl__pt__sl",::_id_,cKey, nLocation))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReverseImage(p1)
return FpQCall( {::_hdll_,"QuickPDFReverseImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RotatePage(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFRotatePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveFontToFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSaveFontToFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveImageToFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSaveImageToFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveState()
return FpQCall( {::_hdll_,"QuickPDFSaveState"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveStyle(sStyleName)
   sStyleName := ::ForceAnsi(sStyleName)
return FpQCall( {::_hdll_,"QuickPDFSaveStyleA"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveToFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSaveToFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
RETURN ::_str_result_(FpQCall( {::_hdll_,"QuickPDFSaveToString"} ,"__pt__sl",::_id_))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SecurityInfo(p1)
return FpQCall( {::_hdll_,"QuickPDFSecurityInfo"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectDocument(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSelectDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedDocument()
return FpQCall( {::_hdll_,"QuickPDFSelectedDocument"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedFont()
return FpQCall( {::_hdll_,"QuickPDFSelectedFont"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedImage()
return FpQCall( {::_hdll_,"QuickPDFSelectedImage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedPage()
return FpQCall( {::_hdll_,"QuickPDFSelectedPage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectFont(p1)
   DEFAULT p1 TO ::nDefaultStandardFontID
return 0 # FpQCall( {::_hdll_,"QuickPDFSelectFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectImage(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSelectImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectPage(p1)
   local lOK
   lOK := 0 # FpQCall( {::_hdll_,"QuickPDFSelectPage"} ,"__sl__sl__sl",::_id_,p1)
   if lOK
      ::nPageNo := p1
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAdvancePassword()
   MsgFunctionRemoved("SetAdvancePassword()")
return .f.
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotContents(nIndex, sNewContents)
   sNewContents := ::ForceAnsi(sNewContents)
return FpQCall( {::_hdll_,"QuickPDFSetAnnotContentsA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewContents)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotStrProperty(nIndex, nTag, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return FpQCall( {::_hdll_,"QuickPDFSetAnnotStrPropertyA"} ,"__sl__sl__sl__sl__pt",::_id_,nIndex, nTag, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBaseURL(sNewBaseURL)
   sNewBaseURL := ::ForceAnsi(sNewBaseURL)
return FpQCall( {::_hdll_,"QuickPDFSetBaseURLA"} ,"__sl__sl__pt",::_id_,sNewBaseURL)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBlendMode(p1)
return FpQCall( {::_hdll_,"QuickPDFSetBlendMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBreakString(sNewBreakString)
   sNewBreakString := ::ForceAnsi(sNewBreakString)
return FpQCall( {::_hdll_,"QuickPDFSetBreakStringA"} ,"__sl__sl__pt",::_id_,sNewBreakString)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCapturedPageOptional(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCapturedPageOptional"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCatalogInformation(sKey, sNewValue)
   sKey      := ::ForceAnsi(sKey)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCatalogInformationA"} ,"__sl__sl__pt__pt",::_id_,sKey, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCharWidth(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCharWidth"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetClippingPath()
return FpQCall( {::_hdll_,"QuickPDFSetClippingPath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetClippingPathEvenOdd()
return FpQCall( {::_hdll_,"QuickPDFSetClippingPathEvenOdd"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCropBox(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetCropBox"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCustomInformation(sKey, sNewValue)
   sKey      := ::ForceAnsi(sKey)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCustomInformationA"} ,"__sl__sl__pt__pt",::_id_,sKey,sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCustomLineDash(sDashPattern, nDashPhase)
   sDashPattern := ::ForceAnsi(sDashPattern)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCustomLineDashA"} ,"__sl__sl__pt__f8",::_id_,sDashPattern, nDashPhase)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDocumentMetadata(sXMP)
   sXMP := ::ForceAnsi(sXMP)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetDocumentMetadataA"} ,"__sl__sl__pt",::_id_,sXMP)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColor(nR,nG,nB)                                          // *HB* DrawText change this color !
   if nR==NIL .or. nG==NIL .or. nB==NIL                                                       // 1.54
      nR := ::nAktiveFillColorRed
      nG := ::nAktiveFillColorGreen
      nB := ::nAktiveFillColorBlue
   else
      if nR>1 .or. nG>1 .or. nB>1
         ::HB_RGB2double(@nR,@nG,@nB)
      endif
      ::nAktiveFillColorRed    :=  nR
      ::nAktiveFillColorGreen  :=  nG
      ::nAktiveFillColorBlue   :=  nB
   endif
return FpQCall( {::_hdll_,"QuickPDFSetFillColor"} ,"__sl__sl__f8__f8__f8",::_id_,nR,nG,nB)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetFillColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorSep(sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFillColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillShader(sShaderName)
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFillShaderA"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFontEncoding(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFontEncoding"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFontFlags(p1,p2,p3,p4,p5,p6,p7,p8)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFontFlags"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldAlignment(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldAlignment"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldAnnotFlags(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldAnnotFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBackgroundColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorCMYK(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBackgroundColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorSep(nIndex, sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBackgroundColorSepA"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBorderColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorCMYK(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBorderColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorSep(nIndex, sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBorderColorSepA"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderStyle(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBorderStyle"} ,"__sl__sl__sl__f8__sl__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBounds(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBounds"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCalcOrder(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldCalcOrder"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCaption(nIndex, sNewCaption)
   sNewCaption := ::ForceAnsi(sNewCaption)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldCaptionA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewCaption)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCheckStyle(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldCheckStyle"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldChildTitle(nInteger, sNewTitle)
   sNewTitle := ::ForceAnsi(sNewTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldChildTitleA"} ,"__sl__sl__sl__pt",::_id_,nInteger, sNewTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorCMYK(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorSep(nIndex, sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldColorSepA"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldComb(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetFormFieldComb"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldDefaultValue(nIndex, sNewDefaultValue)
   sNewDefaultValue := ::ForceAnsi(sNewDefaultValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldDefaultValueA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewDefaultValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldDescription(nIndex, sNewDescription)
   sNewDescription := ::ForceAnsi(sNewDescription)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldDescriptionA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewDescription)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldFlags(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldFont(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldFont"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldHighlightMode(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldHighlightMode"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldIcon(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldIcon"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldIconStyle(p1,p2,p3,p4,p5,p6)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldIconStyle"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldMaxLen(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldMaxLen"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldOptional(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldOptional"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldPage(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldPage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldPrintable(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldPrintable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldReadOnly(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldReadOnly"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldRotation(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldRotation"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldStandardFont(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetFormFieldStandardFont"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTabOrder(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldTabOrder"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTextFlags(p1,p2,p3,p4,p5,p6)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldTextFlags"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTextSize(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldTextSize"} ,"__sl__sl__sl__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldValue(nIndex, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldValueA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldValueByTitle(sTitle, sNewValue)
   sTitle := ::ForceAnsi(sTitle)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldValueByTitleA"} ,"__sl__sl__pt__pt",::_id_, sTitle, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldVisible(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldVisible"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetGDIPlusFileName(sDLLFileName)
   sDLLFileName := ::ForceAnsi(sDLLFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetGDIPlusFileNameA"} ,"__sl__sl__pt",::_id_,sDLLFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetGDIPlusOptions(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetGDIPlusOptions"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLBoldFont(sFontSet, nFontID)
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetHTMLBoldFontA"} ,"__sl__sl__pt__sl",::_id_, sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLBoldItalicFont(sFontSet, nFontID)
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetHTMLBoldItalicFontA"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLItalicFont(sFontSet, nFontID)
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetHTMLItalicFontA"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLNormalFont(sFontSet, nFontID)
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetHTMLNormalFontA"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageAsMask(p1)
return FpQCall( {::_hdll_,"QuickPDFSetImageAsMask"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMask(p1,p2,p3,p4,p5,p6)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetImageMask"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMaskCMYK(p1,p2,p3,p4,p5,p6,p7,p8)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetImageMaskCMYK"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMaskFromImage(p1)
return FpQCall( {::_hdll_,"QuickPDFSetImageMaskFromImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageOptional(p1)
return FpQCall( {::_hdll_,"QuickPDFSetImageOptional"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetInformation(nKey, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetInformationA"} ,"__sl__sl__sl__pt",::_id_,nKey, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetJavaScriptMode(p1)
return FpQCall( {::_hdll_,"QuickPDFSetJavaScriptMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetJPEGQuality(p1)
return FpQCall( {::_hdll_,"QuickPDFSetJPEGQuality"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetKerning(sCharPair, nAdjustment)
   sCharPair := ::ForceAnsi(sCharPair)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetKerningA"} ,"__sl__sl__pt__sl",::_id_,sCharPair, nAdjustment)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineCap(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineCap"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColor(p1,p2,p3)
   DEFAULT p1 TO 0
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetLineColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetLineColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorSep(sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineDash(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetLineDash"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineJoin(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineJoin"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineShader(sShaderName)
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineShaderA"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineWidth(p1)                                                        // *HB* return current value
   local nReturn
   if valtype(P1)="N" .and. p1==0  // setze Standardwert, set default value
      p1 := ::nDefaultLineWidth
   endif
   nReturn := ::nLineWidth         // aktuellen Wert zurckgeben, return current value
   if P1 # NIL                     // neuen Wert setzen, set new value
      if 0 # FpQCall( {::_hdll_,"QuickPDFSetLineWidth"} ,"__sl__sl__f8",::_id_,p1)
         ::nLineWidth := p1
      endif
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasurementUnits(p1)
return FpQCall( {::_hdll_,"QuickPDFSetMeasurementUnits"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetNeedAppearances(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetNeedAppearances"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionDestination(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOpenActionDestination"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionDestinationFull(p1,p2,p3,p4,p5,p6,p7)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOpenActionDestinationFull"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionJavaScript(sJavaScript)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOpenActionJavaScriptA"} ,"__sl__sl__pt",::_id_,sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionMenu(sMenuItem)
   sMenuItem := ::ForceAnsi(sMenuItem)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOpenActionMenuA"} ,"__sl__sl__pt",::_id_,sMenuItem)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentGroupPrintable(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetOptionalContentGroupPrintable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentGroupVisible(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetOptionalContentGroupVisible"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOrigin(p1)
return FpQCall( {::_hdll_,"QuickPDFSetOrigin"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestination(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineDestination"} ,"__sl__sl__sl__sl__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestinationFull(p1,p2,p3,p4,p5,p6,p7,p8)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineDestinationFull"} ,"__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestinationZoom(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineDestinationZoom"} ,"__sl__sl__sl__sl__f8__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineJavaScript(nOutlineID, sJavaScript)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineJavaScriptA"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineOpenFile(nOutlineID, sFileName)
   sFileName := ::ForceAnsi(sFileName)
   sFileName := ::PathFormatPdf(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineOpenFileA"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineStyle(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineStyle"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineTitle(nOutlineID, sNewTitle)
   sNewTitle := ::ForceAnsi(sNewTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineTitleA"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sNewTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineWebLink(nOutlineID, sLink)
   sLink := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineWebLinkA"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageActionMenu(sMenuItem)
   sMenuItem := ::ForceAnsi(sMenuItem)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageActionMenuA"} ,"__sl__sl__pt",::_id_,sMenuItem)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageBox(p1,p2,p3,p4,p5)
return FpQCall( {::_hdll_,"QuickPDFSetPageBox"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageDimensions(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageDimensions"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageLayout(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageLayout"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageMode(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageSize(sPaperName)
   sPaperName := ::ForceAnsi(sPaperName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageSizeA"} ,"__sl__sl__pt",::_id_,sPaperName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageThumbnail()
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageThumbnail"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageTransparencyGroup(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFSetPageTransparencyGroup"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPassword()
   MsgFunctionRemoved("SetPassword()")
return .f.
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPNGTransparencyColor(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFSetPNGTransparencyColor"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPrecision(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPrecision"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetScale(p1)
return FpQCall( {::_hdll_,"QuickPDFSetScale"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColor(p1,p2,p3,p4,p5)
   DEFAULT p3 TO 0                                                                            // 1.54
   DEFAULT p4 TO 0
   DEFAULT p5 TO 0
   if p3>1 .or. p4>1 .or. p5>1
      ::HB_RGB2double(@p3,@p4,@p5)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetTableBorderColor"} ,"__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorCMYK(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFSetTableBorderColorCMYK"} ,"__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderWidth(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFSetTableBorderWidth"} ,"__sl__sl__sl__sl__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellAlignment(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellAlignment"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColor(p1,p2,p3,p4,p5,p6,p7,p8)
   DEFAULT p6 TO 0                                                                            // 1.54
   DEFAULT p7 TO 0
   DEFAULT p8 TO 0
   if p6>1 .or. p7>1 .or. p8>1
      ::HB_RGB2double(@p6,@p7,@p8)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBackgroundColor"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBackgroundColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColor(p1,p2,p3,p4,p5,p6,p7,p8,p9)
   DEFAULT p7 TO 0                                                                            // 1.54
   DEFAULT p8 TO 0
   DEFAULT p9 TO 0
   if p7>1 .or. p8>1 .or. p9>1
      ::HB_RGB2double(@p7,@p8,@p9)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBorderColor"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBorderColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderWidth(p1,p2,p3,p4,p5,p6,p7)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBorderWidth"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellContent(nTableID, nRowNumber, nColumnNumber, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellContentA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nTableID, nRowNumber, nColumnNumber, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellPadding(p1,p2,p3,p4,p5,p6,p7)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellPadding"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColor(p1,p2,p3,p4,p5,p6,p7,p8)
   DEFAULT p6 TO 0                                                                            // 1.54
   DEFAULT p7 TO 0
   DEFAULT p8 TO 0
   if p6>1 .or. p7>1 .or. p8>1
      ::HB_RGB2double(@p6,@p7,@p8)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetTableCellTextColor"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellTextColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextSize(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellTextSize"} ,"__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableColumnWidth(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTableColumnWidth"} ,"__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableRowHeight(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTableRowHeight"} ,"__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTempFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTempFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTempPath(sNewPath)
   sNewPath := ::ForceAnsi(sNewPath)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTempPathA"} ,"__sl__sl__pt",::_id_,sNewPath)
// -------------------------------------------------------------------------------------------------------------------
Method HBPrintPDF:SetTextAlign(xAlign)             // *HB*
   local nReturn
   if xAlign == NIL .or. ! ValType(xAlign) $ "CN"  // Error
      nReturn := 0
   else
      do case
         case ValType(xAlign) == "N"
              // xAlign is ok
         case xAlign == "L"
              xAlign := TEXT_ALIGN_LEFT
         case xAlign == "R"
              xAlign := TEXT_ALIGN_RIGHT
         case xAlign == "C" .or. xAlign == "Z"
              xAlign := TEXT_ALIGN_CENTER
         case xAlign == "B"
              xAlign := TEXT_ALIGN_BLOCK_NORMAL
      end
      nReturn := FpQCall( {::_hdll_,"QuickPDFSetTextAlign"} ,"__sl__sl__sl",::_id_,xAlign)
      if ::IsTrue(nReturn)
         ::nAlign := xAlign
      endif
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextCharSpacing(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextCharSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColor(p1,p2,p3)     // <-
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextColorGreen    := p2
   ::nOldTextColorBlue     := p3
return FpQCall( {::_hdll_,"QuickPDFSetTextColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTextColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorSep(sColorName, nTint)
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlight(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextHighlight"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColor(p1,p2,p3)
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextHighlightColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextHighlightColorGreen    := p2
   ::nOldTextHighlightColorBlue     := p3
return FpQCall( {::_hdll_,"QuickPDFSetTextHighlightColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTextHighlightColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorSep(sColorName, nTint)
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextHighlightColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextMode(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextRise(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextRise"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextScaling(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextScaling"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextShader(sShaderName)
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextShaderA"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
Method HBPrintPDF:SetTextSize(nFontSize)
   local lOK
   DEFAULT nFontSize TO ::nDefaultStandardFontSize
   lOK := 0 # FpQCall( {::_hdll_,"QuickPDFSetTextSize"} ,"__sl__sl__f8",::_id_,nFontSize)
   ::nLineFeed  := ::GetTextHeight()
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextSpacing(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderline(p1)                                                        // *HB*
       DEFAULT p1 TO TEXTUNDERLINE_NONE
       ::nTextUnderline := p1
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColor(p1,p2,p3)
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextUnderlineColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextUnderlineColorGreen    := p2
   ::nOldTextUnderlineColorBlue     := p3
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorSep(sColorName, nTint)
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineDash(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineDash"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextWordSpacing(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextWordSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTransparency(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTransparency"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetupCustomPrinter(sCustomPrinterName, nSetting, nNewValue)
   sCustomPrinterName := ::ForceAnsi(sCustomPrinterName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetupCustomPrinterA"} ,"__sl__sl__pt__sl__sl",::_id_,sCustomPrinterName, nSetting, nNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetViewerPreferences(p1,p2)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetViewerPreferences"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldAccess(sXFAFieldName, nNewAccess)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldAccessA"} ,"__sl__sl__pt__sl",::_id_,sXFAFieldName, nNewAccess)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColor(sXFAFieldName, nRed, nGreen, nBlue)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldBorderColorA"} ,"__sl__sl__pt__f8__f8__f8",::_id_,sXFAFieldName, nRed, nGreen, nBlue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderPresence(sXFAFieldName, nNewPresence)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldBorderPresenceA"} ,"__sl__sl__pt__sl",::_id_,sXFAFieldName, nNewPresence)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderWidth(sXFAFieldName, nBorderWidth)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldBorderWidthA"} ,"__sl__sl__pt__f8",::_id_,sXFAFieldName, nBorderWidth)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldValue(sXFAFieldName,sNewValue)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
   sNewValue     := ::ForceAnsi(sNewValue)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldValueA"} ,"__sl__sl__pt__pt",::_id_,sXFAFieldName,sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SignFile(sInputFileName, sOpenPassword, sSignatureFieldName, sOutputFileName, sPFXFileName, sPFXPassword, sReason, sLocation, sContactInfo)
       sInputFileName      := ::ForceAnsi(sInputFileName)
       sOpenPassword       := ::ForceAnsi(sOpenPassword)
       sSignatureFieldName := ::ForceAnsi(sSignatureFieldName)
       sOutputFileName     := ::ForceAnsi(sOutputFileName)
       sPFXFileName        := ::ForceAnsi(sPFXFileName)
       sPFXPassword        := ::ForceAnsi(sPFXPassword)
       sReason             := ::ForceAnsi(sReason)
       sLocation           := ::ForceAnsi(sLocation)
       sContactInfo        := ::ForceAnsi(sContactInfo)
return FpQCall( {::_hdll_,"QuickPDFSignFileA"} ,"__sl__sl__pt__pt__pt__pt__pt__pt__pt__pt__pt",::_id_,sInputFileName,;
                                                sOpenPassword, sSignatureFieldName, sOutputFileName, sPFXFileName, sPFXPassword, sReason, sLocation, sContactInfo)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SplitPageText(p1)
return FpQCall( {::_hdll_,"QuickPDFSplitPageText"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StartPath(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFStartPath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StoreCustomDataFromFile(sKey, sFileName, nLocation, nOptions)
   sKey      := ::ForceAnsi(sKey)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFStoreCustomDataFromFileA"} ,"__sl__sl__pt__pt__sl__sl",::_id_,sKey, sFileName, nLocation, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StoreCustomDataFromString(cKey, cNewValue, nLocation, nOptions) // cKey OK!
  local ptb := _xgrab(32);PokeDWord(ptb,,5) // Funktion mit 4 Parameter, daher 5 !
return 0 # ::_ptb_free_( FpQCall({::_hdll_,"QuickPDFStoreCustomDataFromString"},"__sl__sl__pt__pt__sl__sl",::_id_,cKey,::_b(cNewValue,ptb,1),nLocation, nOptions) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StringResultLength()
return FpQCall( {::_hdll_,"QuickPDFStringResultLength"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:TestTempPath()
return 0 # FpQCall( {::_hdll_,"QuickPDFTestTempPath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Unlocked()
return 0 # FpQCall( {::_hdll_,"QuickPDFUnlocked"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UnlockKey(sLicenseKey)
   sLicenseKey := ::ForceAnsi(sLicenseKey)
return 0 # FpQCall( {::_hdll_,"QuickPDFUnlockKeyA"} ,"__sl__sl__pt",::_id_,sLicenseKey)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UpdateAppearanceStream(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFUpdateAppearanceStream"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UseKerning(p1)
return FpQCall( {::_hdll_,"QuickPDFUseKerning"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddOpenTypeFontFromFile(sFileName, iOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"QuickPDFAddOpenTypeFontFromFileA"} ,"__sl__sl__pt__sl",::_id_,sFileName,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSWFAnnotationFromFile(dLeft, dTop, dWidth, dHeight, sFileName, sTitle, iOptions)
   sFileName := ::ForceAnsi(sFileName)
   sTitle := ::ForceAnsi(sTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddSWFAnnotationFromFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__pt__sl",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,sTitle,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeSubsettedFont(sFontName, sSubsetChars, iOptions)
   DEFAULT iOptions TO 0    // ###### 8.16 => Options Reserved for future use. Should be set to 0.
   sFontName := ::ForceAnsi(sFontName)
   sSubsetChars := ::ForceAnsi(sSubsetChars)
return FpQCall( {::_hdll_,"QuickPDFAddTrueTypeSubsettedFontA"} ,"__sl__sl__pt__pt__sl",::_id_,sFontName,sSubsetChars,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AnsiStringResultLength()
return FpQCall( {::_hdll_,"QuickPDFAnsiStringResultLength"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckFileCompliance(sInputFileName, sPassword, iComplianceTest, iOptions)
   sInputFileName := ::ForceAnsi(sInputFileName)
   sPassword      := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"QuickPDFCheckFileComplianceA"} ,"__sl__sl__pt__pt__sl__sl",::_id_,sInputFileName,sPassword,iComplianceTest,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CombineLayers() ; RETURN ::CombineContentStreams() // alt / old
METHOD HBPrintPDF:CombineContentStreams()
return 0 # FpQCall( {::_hdll_,"QuickPDFCombineContentStreams"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LayerCount() ; RETURN ::ContentStreamCount() // alt / old
METHOD HBPrintPDF:ContentStreamCount()
return FpQCall( {::_hdll_,"QuickPDFContentStreamCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LayerSafe() ; RETURN ::ContentStreamSafe()  // alt / old
METHOD HBPrintPDF:ContentStreamSafe()
return 0 # FpQCall( {::_hdll_,"QuickPDFContentStreamSafe"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetObjectSource(p1,p2); RETURN ::DAGetObjectToString(p1,p2)  // alt / old
METHOD HBPrintPDF:DAGetObjectToString(iFileHandle, iObjectNumber)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFDAGetObjectToString"} ,"__pt__sl__sl__sl",::_id_,iFileHandle,iObjectNumber) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageContent(p1,p2); RETURN ::DAGetPageContentToString(p1,p2)  // alt / old
METHOD HBPrintPDF:DAGetPageContentToString(iFileHandle, iPageRef)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFDAGetPageContentToString"} ,"__pt__sl__sl__sl",::_id_,iFileHandle,iPageRef) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAReleaseImageList(iFileHandle, iImageListID)
return 0 # FpQCall( {::_hdll_,"QuickPDFDAReleaseImageList"} ,"__sl__sl__sl__sl",::_id_,iFileHandle,iImageListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetTextExtractionArea(dLeft, dTop, dWidth, dHeight)
return FpQCall( {::_hdll_,"QuickPDFDASetTextExtractionArea"} ,"__sl__sl__f8__f8__f8__f8",::_id_,dLeft,dTop,dWidth,dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetTextExtractionOptions(iOptionID, iNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetTextExtractionOptions"} ,"__sl__sl__sl__sl",::_id_,iOptionID,iNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetTextExtractionScaling(iOptions, dHorizontal, dVertical)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetTextExtractionScaling"} ,"__sl__sl__sl__f8__f8",::_id_,iOptions,dHorizontal,dVertical)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetTextExtractionWordGap(dNewWordGap)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetTextExtractionWordGap"} ,"__sl__sl__f8",::_id_,dNewWordGap)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteContentStream()
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawIntelligentMailBarcode(dLeft, dTop, dBarWidth, dFullBarHeight, dTrackerHeight, dSpaceWidth, sBarcodeData, iOptions)
   sBarcodeData := ::ForceAnsi(sBarcodeData)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawIntelligentMailBarcodeA"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__pt__sl",::_id_,dLeft,dTop,dBarWidth,dFullBarHeight,dTrackerHeight,dSpaceWidth,sBarcodeData,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPDF417Symbol(dLeft, dTop, sText, iOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawPDF417SymbolA"} ,"__sl__sl__f8__f8__pt__sl",::_id_,dLeft,dTop,sText,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedBox(dLeft, dBottom, dWidth, dHeight, dAngle, iDrawOptions)
return FpQCall( {::_hdll_,"QuickPDFDrawRotatedBox"} ,"__sl__sl__f8__f8__f8__f8__f8__sl",::_id_,dLeft,dBottom,dWidth,dHeight,dAngle,iDrawOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedMultiLineText(dXPos, dYPos, dAngle, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawRotatedMultiLineTextA"} ,"__sl__sl__f8__f8__f8__pt__pt",::_id_,dXPos,dYPos,dAngle,sDelimiter,sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EditableLayer() ; RETURN ::EditableContentStream() // alt / old
METHOD HBPrintPDF:EditableContentStream()
return 0 # FpQCall( {::_hdll_,"QuickPDFEditableContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncapsulateLayer() ; RETURN ::EncapsulateContentStream() // alt / old
METHOD HBPrintPDF:EncapsulateContentStream()
return FpQCall( {::_hdll_,"QuickPDFEncapsulateContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePageContent(sInputFileName, sPassword, iPage); RETURN ::ExtractFilePageContentToString(sInputFileName, sPassword, iPage) // alt / old
METHOD HBPrintPDF:ExtractFilePageContentToString(sInputFileName, sPassword, iPage)
   sInputFileName := ::ForceAnsi(sInputFileName)
   sPassword := ::ForceAnsi(sPassword)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFExtractFilePageContentToStringA"} ,"__pt__sl__pt__pt__sl",::_id_,sInputFileName,sPassword,iPage) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCSDictEPSG(iCSDictID)
return FpQCall( {::_hdll_,"QuickPDFGetCSDictEPSG"} ,"__sl__sl__sl",::_id_,iCSDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCSDictType(iCSDictID)
return FpQCall( {::_hdll_,"QuickPDFGetCSDictType"} ,"__sl__sl__sl",::_id_,iCSDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCSDictWKT(iCSDictID)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetCSDictWKTA"} ,"__pt__sl__sl",::_id_,iCSDictID) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetContentStreamToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetContentStreamToString"} ,"__pt__sl",::_id_) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListCount(iImageListID)
return FpQCall( {::_hdll_,"QuickPDFGetImageListCount"} ,"__sl__sl__sl",::_id_,iImageListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListItemDataToString(iImageListID, iImageIndex, iOptions)
   // KEIN ::ReadString(), da hier ein 8 Bit Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), Returns the image data of the specified image list item as a string of 8-bit bytes.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetImageListItemDataToString"} ,"__pt__sl__sl__sl__sl",::_id_,iImageListID,iImageIndex,iOptions) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListItemDblProperty(iImageListID, iImageIndex, iPropertyID)
return FpQCall( {::_hdll_,"QuickPDFGetImageListItemDblProperty"} ,"__f8__sl__sl__sl__sl",::_id_,iImageListID,iImageIndex,iPropertyID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListItemIntProperty(iImageListID, iImageIndex, iPropertyID)
return FpQCall( {::_hdll_,"QuickPDFGetImageListItemIntProperty"} ,"__sl__sl__sl__sl__sl",::_id_,iImageListID,iImageIndex,iPropertyID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageMeasureDict()
return FpQCall( {::_hdll_,"QuickPDFGetImageMeasureDict"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImagePtDataDict()
return FpQCall( {::_hdll_,"QuickPDFGetImagePtDataDict"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetLatestPrinterNames()                                        // ==> ::GetPrinterNameA()  ==> Array
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetLatestPrinterNamesA"} ,"__pt__sl",::_id_) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictBoundsCount(iMeasureDictID)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictBoundsCount"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictBoundsItem(iMeasureDictID, iItemIndex)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictBoundsItem"} ,"__f8__sl__sl__sl",::_id_,iMeasureDictID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictCoordinateSystem(iMeasureDictID)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictCoordinateSystem"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictDCSDict(iMeasureDictID)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictDCSDict"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictGCSDict(iMeasureDictID)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictGCSDict"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictGPTSCount(iMeasureDictID)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictGPTSCount"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictGPTSItem(iMeasureDictID, iItemIndex)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictGPTSItem"} ,"__f8__sl__sl__sl",::_id_,iMeasureDictID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictLPTSCount(iMeasureDictID)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictLPTSCount"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictLPTSItem(iMeasureDictID, iItemIndex)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictLPTSItem"} ,"__f8__sl__sl__sl",::_id_,iMeasureDictID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictPDU(iMeasureDictID, iUnitIndex)
return FpQCall( {::_hdll_,"QuickPDFGetMeasureDictPDU"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iUnitIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetObjectSource(nObjectNumber); RETURN ::GetObjectToString(nObjectNumber) // alt / old
METHOD HBPrintPDF:GetObjectToString(iObjectNumber)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetObjectToString"} ,"__pt__sl__sl",::_id_,iObjectNumber) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigLocked(iOptionalContentConfigID, iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetOptionalContentConfigLocked"} ,"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageColorSpaces(iOptions)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetPageColorSpacesA"} ,"__pt__sl__sl",::_id_,iOptions) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageContent(); RETURN ::GetPageContentToString()                       // alt / old
METHOD HBPrintPDF:GetPageContentToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetPageContentToString"} ,"__pt__sl",::_id_) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageImageList(iOptions)
return FpQCall( {::_hdll_,"QuickPDFGetPageImageList"} ,"__sl__sl__sl",::_id_,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageViewPortCount()
return FpQCall( {::_hdll_,"QuickPDFGetPageViewPortCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageViewPortID(iIndex)
return FpQCall( {::_hdll_,"QuickPDFGetPageViewPortID"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterDevModeToString(sPrinterName)
   sPrinterName := ::ForceAnsi(sPrinterName)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
   // Returns a binary string containing the DEVMODE structure for the specified printer.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetPrinterDevModeToStringA"} ,"__pt__sl__pt",::_id_,sPrinterName) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterMediaTypes(sPrinterName)
   sPrinterName := ::ForceAnsi(sPrinterName)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetPrinterMediaTypesA"} ,"__pt__sl__pt",::_id_,sPrinterName) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetStringListCount(iStringListID)
return FpQCall( {::_hdll_,"QuickPDFGetStringListCount"} ,"__sl__sl__sl",::_id_,iStringListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetStringListItem(iStringListID, iItemIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetStringListItemA"} ,"__pt__sl__sl__sl",::_id_,iStringListID,iItemIndex) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetUnicodeCharactersFromEncoding(iEncoding)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetUnicodeCharactersFromEncodingA"} ,"__pt__sl__sl",::_id_,iEncoding) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewPortBBox(iViewPortID, iDimension)
return FpQCall( {::_hdll_,"QuickPDFGetViewPortBBox"} ,"__f8__sl__sl__sl",::_id_,iViewPortID,iDimension)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewPortMeasureDict(iViewPortID)
return FpQCall( {::_hdll_,"QuickPDFGetViewPortMeasureDict"} ,"__sl__sl__sl",::_id_,iViewPortID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewPortName(iViewPortID)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetViewPortNameA"} ,"__pt__sl__sl",::_id_,iViewPortID) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewPortPtDataDict(iViewPortID)
return FpQCall( {::_hdll_,"QuickPDFGetViewPortPtDataDict"} ,"__sl__sl__sl",::_id_,iViewPortID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAToString(iOptions)
   DEFAULT iOptions TO 0
   // KEIN ::ReadString(), da hier XML Daten geliefert wird.
   // NO   ::ReadString(), return XML data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetXFAToString"} ,"__pt__sl__sl",::_id_,iOptions) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveLayer(p1,p2) ; RETURN ::MoveContentStream(p1,p2) // alt / old
METHOD HBPrintPDF:MoveContentStream(iFromPosition, iToPosition)
return 0 # FpQCall( {::_hdll_,"QuickPDFMoveContentStream"} ,"__sl__sl__sl__sl",::_id_,iFromPosition,iToPosition)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewLayer() ; RETURN ::NewContentStream() // alt / old
METHOD HBPrintPDF:NewContentStream()
return FpQCall( {::_hdll_,"QuickPDFNewContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewTilingPatternFromCapturedPage(sPatternName, iCaptureID)
   sPatternName := ::ForceAnsi(sPatternName)
return 0 # FpQCall( {::_hdll_,"QuickPDFNewTilingPatternFromCapturedPageA"} ,"__sl__sl__pt__sl",::_id_,sPatternName,iCaptureID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseImage(iImageID)
return 0 # FpQCall( {::_hdll_,"QuickPDFReleaseImage"} ,"__sl__sl__sl",::_id_,iImageID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseImageList(iImageListID)
return 0 # FpQCall( {::_hdll_,"QuickPDFReleaseImageList"} ,"__sl__sl__sl",::_id_,iImageListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveFormFieldBorderColor(iIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveFormFieldBorderColor"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveSharedLayers(); RETURN ::RemoveSharedContentStreams() // alt / old
METHOD HBPrintPDF:RemoveSharedContentStreams()
return FpQCall( {::_hdll_,"QuickPDFRemoveSharedContentStreams"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveImageListItemDataToFile(iImageListID, iImageIndex, iOptions, sImageFileName)
   sImageFileName := ::ForceAnsi(sImageFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSaveImageListItemDataToFileA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,iImageListID,iImageIndex,iOptions,sImageFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectLayer(iNewIndex); RETURN ::SelectContentStream(iNewIndex)
METHOD HBPrintPDF:SelectContentStream(iNewIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFSelectContentStream"} ,"__sl__sl__sl",::_id_,iNewIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectRenderer(iRendererID)
return FpQCall( {::_hdll_,"QuickPDFSelectRenderer"} ,"__sl__sl__sl",::_id_,iRendererID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotIntProperty(iIndex, iTag, iNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetAnnotIntProperty"} ,"__sl__sl__sl__sl__sl",::_id_,iIndex,iTag,iNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnsiMode(iNewAnsiMode)
     if iNewAnsiMode=NIL
        if ::UseAutoConvUTF8
           iNewAnsiMode := 0
        else
           iNewAnsiMode := 1
        endif
     else
        ::UseAutoConvUTF8 := (iNewAnsiMode = 0)
        FpQCall( {::_hdll_,"QuickPDFSetAnsiMode"} ,"__sl__sl__sl",::_id_,iNewAnsiMode)
     endif
return iNewAnsiMode
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCSDictEPSG(iCSDictID, iNewEPSG)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCSDictEPSG"} ,"__sl__sl__sl__sl",::_id_,iCSDictID,iNewEPSG)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCSDictType(iCSDictID, iNewDictType)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCSDictType"} ,"__sl__sl__sl__sl",::_id_,iCSDictID,iNewDictType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCSDictWKT(iCSDictID, sNewWKT)
   sNewWKT := ::ForceAnsi(sNewWKT)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCSDictWKTA"} ,"__sl__sl__sl__pt",::_id_,iCSDictID,sNewWKT)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCairoFileName(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCairoFileNameA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCapturedPageTransparencyGroup(iCaptureID, iCS, iIsolate, iKnockout)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCapturedPageTransparencyGroup"} ,"__sl__sl__sl__sl__sl__sl",::_id_,iCaptureID,iCS,iIsolate,iKnockout)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetContentStreamFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall( {::_hdll_,"QuickPDFSetContentStreamFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLayerOptional(nOptionalContentGroupID) ; RETURN ::SetContentStreamOptional(nOptionalContentGroupID)  // ALT / OLD
METHOD HBPrintPDF:SetContentStreamOptional(iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetContentStreamOptional"} ,"__sl__sl__sl",::_id_,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDestProperties(iDestID, iZoom, iDestType, dLeft, dTop, dRight, dBottom)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetDestProperties"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iDestID,iZoom,iDestType,dLeft,dTop,dRight,dBottom)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDestValue(iDestID, iValueKey, dNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetDestValue"} ,"__sl__sl__sl__sl__f8",::_id_,iDestID,iValueKey,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillTilingPattern(sPatternName)
   sPatternName := ::ForceAnsi(sPatternName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFillTilingPatternA"} ,"__sl__sl__pt",::_id_,sPatternName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineDashEx(sDashValues)
   sDashValues := ::ForceAnsi(sDashValues)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineDashExA"} ,"__sl__sl__pt",::_id_,sDashValues)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictBoundsCount(iMeasureDictID, iNewCount)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetMeasureDictBoundsCount"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iNewCount)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictBoundsItem(iMeasureDictID, iItemIndex, dNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetMeasureDictBoundsItem"} ,"__sl__sl__sl__sl__f8",::_id_,iMeasureDictID,iItemIndex,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictCoordinateSystem(iMeasureDictID, iCoordinateSystemID)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetMeasureDictCoordinateSystem"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iCoordinateSystemID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictGPTSCount(iMeasureDictID, iNewCount)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetMeasureDictGPTSCount"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iNewCount)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictGPTSItem(iMeasureDictID, iItemIndex, dNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetMeasureDictGPTSItem"} ,"__sl__sl__sl__sl__f8",::_id_,iMeasureDictID,iItemIndex,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictLPTSCount(iMeasureDictID, iNewCount)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetMeasureDictLPTSCount"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iNewCount)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictLPTSItem(iMeasureDictID, iItemIndex, dNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetMeasureDictLPTSItem"} ,"__sl__sl__sl__sl__f8",::_id_,iMeasureDictID,iItemIndex,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictPDU(iMeasureDictID, iLinearUnit, iAreaUnit, iAngularUnit)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetMeasureDictPDU"} ,"__sl__sl__sl__sl__sl__sl",::_id_,iMeasureDictID,iLinearUnit,iAreaUnit,iAngularUnit)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetObjectSource(iObjectNumber, sNewObjectSource); RETURN ::SetObjectFromString(iObjectNumber, sNewObjectSource) // alt / old
METHOD HBPrintPDF:SetObjectFromString(iObjectNumber, iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
return 0 # ::_ptb_free_( FpQCall( {::_hdll_,"QuickPDFSetObjectFromString"} ,"__sl__sl__sl__pt",::_id_,iObjectNumber,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentConfigLocked(iOptionalContentConfigID, iOptionalContentGroupID, iNewLocked)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOptionalContentConfigLocked"} ,"__sl__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID,iNewLocked)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentConfigState(iOptionalContentConfigID, iOptionalContentGroupID, iNewState)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOptionalContentConfigState"} ,"__sl__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID,iNewState)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPDFAMode(iNewMode)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPDFAMode"} ,"__sl__sl__sl",::_id_,iNewMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageContent(cNewContent); RETURN ::SetPageContentFromString(cNewContent)       // alt / old
METHOD HBPrintPDF:SetPageContentFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall( {::_hdll_,"QuickPDFSetPageContentFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPrinterDevModeFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall( {::_hdll_,"QuickPDFSetPrinterDevModeFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderCropType(iNewCropType)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetRenderCropType"} ,"__sl__sl__sl",::_id_,iNewCropType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableThinBorders(iTableID, iThinBorders, dRed, dGreen, dBlue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTableThinBorders"} ,"__sl__sl__sl__sl__f8__f8__f8",::_id_,iTableID,iThinBorders,dRed,dGreen,dBlue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableThinBordersCMYK(iTableID, iThinBorders, dC, dM, dY, dK)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTableThinBordersCMYK"} ,"__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iTableID,iThinBorders,dC,dM,dY,dK)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionArea(dLeft, dTop, dWidth, dHeight)
return FpQCall( {::_hdll_,"QuickPDFSetTextExtractionArea"} ,"__sl__sl__f8__f8__f8__f8",::_id_,dLeft,dTop,dWidth,dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionOptions(iOptionID, iNewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextExtractionOptions"} ,"__sl__sl__sl__sl",::_id_,iOptionID,iNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionScaling(iOptions, dHorizontal, dVertical)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextExtractionScaling"} ,"__sl__sl__sl__f8__f8",::_id_,iOptions,dHorizontal,dVertical)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineCustomDash(sDashPattern, dDashPhase)
   sDashPattern := ::ForceAnsi(sDashPattern)
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineCustomDashA"} ,"__sl__sl__pt__f8",::_id_,sDashPattern,dDashPhase)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineDistance(dUnderlineDistance)
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineDistance"} ,"__sl__sl__f8",::_id_,dUnderlineDistance)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineWidth(dUnderlineWidth)
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineWidth"} ,"__sl__sl__f8",::_id_,dUnderlineWidth)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFromString(iSource, iOptions)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
return 0 # ::_ptb_free_( FpQCall( {::_hdll_,"QuickPDFSetXFAFromString"} ,"__sl__sl__pt__sl",::_id_,::_b(iSource,ptb,1),iOptions) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UseUnsafeLayers(p1) ; RETURN ::UseUnsafeContentStreams(p1) // alt/old
METHOD HBPrintPDF:UseUnsafeContentStreams(iSafetyLevel)
return 0 # FpQCall( {::_hdll_,"QuickPDFUseUnsafeContentStreams"} ,"__sl__sl__sl",::_id_,iSafetyLevel)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetErrorText(nErrorCode)
   LOCAL x, cLangID, cTxt     // This PRG use ANSI codepage // diese Datei benutzt die ANSI codepage
   STATIC aErrorText := { ;   // 2 Bytes => ISO 639-1 es = espania, en = english, fr = french, de = germany  LOWER !!!
                        { 101, "en", "The Strength parameter passed to the Encrypt function was invalid" },;
                        { 101, "de", "Der 'Strength'-Parameter der an 'Encrypt' bergeben wurde ist unglig" },;
                        { 102, "en", "The Permissions parameter passed to the Encrypt function was invalid. Use the EncodePermissions function to construct a value for this parameter" },;
                        { 102, "de", "Der 'Permissions'-Parameter der an 'Encrypt' bergeben wurde ist unglig, nutze ::EncodePermissions()" },;
                        { 103, "en", "The Encrypt function was used on a document that was already encrypted" },;
                        { 103, "de", "Die PDF ist schon verschlsselt, ::Encrypt() ist nicht erlaubt." },;
                        { 104, "en", "The Encrypt function failed for an unknown reason" },;
                        { 104, "de", "Bei ::Encrypt() ist ein unbekannter Fehler aufgetreten." },;
                        { 201, "en", "The SetInformation function failed because the document is encrypted" },;
                        { 201, "de", "::SetInformation() kann keine verschlsselten PDF auswerten" },;
                        { 202, "en", "The Key parameter passed to the SetInformation function was out of range" },;
                        { 202, "de", "::SetInformation() wurde ein falscher 'Key'-Parameter bergeben" },;
                        { 301, "en", "An invalid combination of barcode and option was sent to the DrawBarcode function" },;
                        { 301, "de", "Die Kombination von 'barcode' und 'option' bei ::DrawBarcode() war ungltig" },;
                        { 302, "en", "Non-numeric characters were sent to DrawBarcode using EAN-13" },;
                        { 302, "de", "Bei einem EAN-13 Barcode drfen nur Ziffern im String an ::DrawBarcode() bergeben werden." },;
                        { 303, "en", "The EAN-13 barcode has an invalid checksum character" },;
                        { 303, "de", "Die Prfziffer beim EAN-13 Barcode war falsch" },;
                        { 401, "en", "Could not open input file" },;
                        { 401, "de", "Die Quelldatei konnte nicht geffnet werden" },;
                        { 402, "en", "Output file already exists and could not be deleted" },;
                        { 402, "de", "Die Zieldatei existierte bereits und konnte nicht gelscht werden" },;
                        { 403, "en", "Could not open output file" },;
                        { 403, "de", "Die Zieldatei konnte nicht geffnet werden" },;
                        { 404, "en", "Invalid password" },;
                        { 404, "de", "Das Passwort ist ungltig" },;
                        { 405, "en", "Document is not encrypted" },;
                        { 405, "de", "Das Dokument ist nicht verschlsselt" },;
                        { 406, "en", "Document is already encrypted" },;
                        { 406, "de", "Das Dokument ist schon verschlsselt" },;
                        { 407, "en", "Invalid encryption strength" },;
                        { 407, "de", "Die Verschlsselungsstrke ist ungltig (encryption strength)" },;
                        { 408, "en", "Invalid permissions" },;
                        { 408, "de", "Zugriff verweigert" },;
                        { 409, "en", "Invalid file structure, file is damaged" },;
                        { 409, "de", "Ungltige Dateistruktur, Dokument wurde beschdigt" },;
                        { 410, "en", "One of the input files is encrypted" },;
                        { 410, "de", "Eine der Quelldateien ist verschlsselt" },;
                        { 411, "en", "File not found" },;
                        { 411, "de", "Datei wurde nicht gefunden" },;
                        { 412, "en", "Invalid page range list" },;
                        { 412, "de", "Ungltige Seitenangabe" },;
                        { 501, "en", "The specified FileHandle was invalid" },;
                        { 501, "de", "Dateihandle ist ungltig" },;
                        { 999, "en", "The function could not be used because the library is not unlocked" },;
                        { 999, "de", "QuickPDF wurde nicht 'unlocked' - Schlsselfehler" }  }

   x := 0
   DEFAULT nErrorCode TO ::LastErrorCode()
   cLangID := alltrim(left(lower(::cErrorLanguage),2)) // max. 2 Byte

   do case
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode .and.  cLangID == a[2] } ) )
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode .and.  "en" == a[2] } ) )
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode } ) )
   end
   if x > 0
      cTxt := var2char(nErrorCode)+": "+alltrim(aErrorText[x,3])
   else
      cTxt := var2char(nErrorCode)+": unknown, unbekannt"
   endif

   if ::nCharSet = 1    // ANSI => OEM
      cTxt := ConvToOemCP(cTxt)
   endif              // OK OEM

return cTxt
