#include "Xbp.ch"
#include "Gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "HBPrintPDF.ch"
#include "Nls.ch"

*** OEM   

procedure main
   local oHBPrintPDF, cAcrobat, cPDF, cPfad, x, y, nVonCol, nVonRow, nBisCol, nBisRow
   local cAlign1, cAlign2, nOffset,nCPI,nLPI,nDrawOptions, nRow, nCol, nImageID, cImage
   local cBMP, oBMP, oPS, nBMPID, cTxt
   local nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox

   cls

*   set charset to ansi // CMD Box wants OEM ... PDF needs Ansi, don't care, HBPrintPDF will handle this.
   set alternate to test_SAY.txt
   set alternate on

  ? "HBPrintPDF SAY Methode ..."

   cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe"
   cPDF     := "Beispiel_SAY.pdf"
   cPfad    := cAppPath()  // ot4xb
   delete file (cPDF)
   do while file (cPDF)
      msgbox("Die PDF Datei muss zuerst geschlossen werden / close PDF !" )
      delete file (cPDF)
   enddo
   ? "PDF:  '"+cPDF+"'"
   ? "Pfad: '"+cPfad+"'"
   ?
   SetLocale( NLS_SCURRENCY, Chr(213) )
   ? "Euro AUS/NO Chr(213) =", Chr(213)
   inkey(5)
   SetLocale( NLS_ICURRENCYEURO, "1" )
   SetAppWindow():configure()    // load new font
   ? "Euro AN/YES Chr(213) =", Chr(213)
   inkey(5)

   cImage := "HalloWelt.bmp"

   // eine Bitmapgrafik erstellen
   oPS := XbpPresSpace():new()
   oPS:mode := XBPPS_MODE_NORMAL // XBPPS_MODE_HIGH_PRECISION
   oPS:create()
   oBMP:= XbpBitmap():new():create(oPS)
   oBMP:PresSpace(oPS)
   if .f.
      // selbst erzeugen
      oBMP:make( 160 , 100 , , 1 ) // Schwarz auf Wei 160 x 100
      GraSetColor(oPS,GRA_CLR_WHITE)
      GraBox(oPS,{0,0},{oBMP:xSize, oBMP:ySize},GRA_FILL)   // Weier Hintergrund
   else
      // oder laden
      oBMP:loadfile(cPfad+cImage)
   endif
   GraSetColor(oPS,GRA_CLR_BLACK)
   GraStringAt(oPS,{10,10},"Teststring ")
   GraLine(oPS,{10,8},{40,8})

   cBMP := oBMP:setBuffer()   // BMP String ohne Header !

   oBMP:destroy()
   oPS:destroy()

   // *** only for testing *** nur fr den Test ***
   // CURDIR() darf HBPrintPDF nicht stren !
   // HBPrintPDF have to be independend from CURDIR()

   if .f.
      curdrive(left(getenv("TEMP"),1))
      curdir(getenv("TEMP"))
      ? "Current:  ", curdrive(),Curdir()
   endif

   oHBPrintPDF := HBPrintPDF():new():create() // GetQuickPDFLizenzKey() / cKey

   if oHBPrintPDF:IsOK

      ? "DLL-Version:",oHBPrintPDF:LibraryVersion()
      ? "GetInstalledFontsByCharset( 1,1 ) - ANSI Fonts, jeder in einer Zeile"
      ? oHBPrintPDF:GetInstalledFontsByCharset( 1,1 )
      ?
      ? "GetInstalledFontsByCodePage( 1252 ,1 ) - ANSI Fonts, jeder in einer Zeile"
      ? oHBPrintPDF:GetInstalledFontsByCodePage( 1252 ,1 )
      ?

      oHBPrintPDF:SetTextCpi(10)  // Fontgre fr 10 CPI einstellen / change font size to 10 cpi
      oHBPrintPDF:SetCPI(10)      // 10 char per inch / Zeichen pro inch -> SAY
      oHBPrintPDF:SetLPI(6)       //  6 lines per inch / Zeilen pro inch -> SAY

      ? "Erste Seite: 10 CPI, 6 LPI, Anzahl der Zeilen pro Seite:", oHBPrintPDF:GetSayLinesPerPage()
      for x := 1 to oHBPrintPDF:GetSayLinesPerPage()
          oHBPrintPDF:say(x,1,"Zeile "+str(x,4)+" von "+str(oHBPrintPDF:GetSayLinesPerPage(),4)+ "    "+Chr(213))
      next

      do case
         case set(_SET_CHARSET)=0 // ANSI
            cTxt := "EXE in ANSI (0)"
         case set(_SET_CHARSET)=1 // OEM
            cTxt := "EXE in OEM (1)"
         otherwise
            cTxt := "EXE ? ("+alltrim(str(set(_SET_CHARSET),3,0))+")"
      end
      oHBPrintPDF:Say(2,35,cTxt)
      oHBPrintPDF:Say(2,60,"DLL-Version: "+oHBPrintPDF:LibraryVersion())

      nRow :=  5
      nCol := 28
      oHBPrintPDF:SayBox(nRow,nCol,nRow+7,nCol+22)  // eine schne BOX
      nImageID := oHBPrintPDF:AddImageFromFile(cPfad+cImage)
      if nImageID > 0
         oHBPrintPDF:SayImage(nRow,nCol,nRow+7,nCol+22)
      else
         oHBPrintPDF:Say(nRow+1,nCol+1,"Fehler bei Image: "+cImage)
      endif
      nRow := 20
      oHBPrintPDF:SayBox(nRow,nCol,nRow+7,nCol+24)  // eine schne BOX
      nBMPID := oHBPrintPDF:AddImageFromXbpBMP(cBMP)
      if nBMPID > 0
         oHBPrintPDF:AddImageID(nImageID,"XbpBMP")
         oHBPrintPDF:SayImage(nRow,nCol,nRow+7,nCol+24)
         nRow := 30
         oHBPrintPDF:SayBox(  nRow,nCol,nRow+7 ,nCol+40,0.1)
         oHBPrintPDF:SayImage(nRow,nCol,nRow+7 ,nCol+40,180)  // Drehung 180
         oHBPrintPDF:Say(nRow,nCol,"180")
         nRow := 50
         oHBPrintPDF:SayBox(  nRow,nCol,nRow+10,nCol+14,0.2)
         oHBPrintPDF:SayImage(nRow,nCol,nRow+10,nCol+14,90)   // Drehung links 90
         oHBPrintPDF:Say(nRow,nCol,"90")
         nCol := 56
         oHBPrintPDF:SayBox(  nRow,nCol,nRow+10,nCol+14,0.1)
         oHBPrintPDF:SayImage(nRow,nCol,nRow+10,nCol+14,270)  // Drehung links 270
         oHBPrintPDF:Say(nRow,nCol,"270")
      else
         oHBPrintPDF:Say(nRow+1,nCol+1,"Fehler bei Image: "+cImage)
      endif

      // gemischter Aufruf ist auch mglich

      nPosX   := 140
      nPosY   :=  17
      nXSize  := NIL  // Originalgre
      nYSize  := NIL  // image size
      cFileNameID := nImageID
      nID     := NIL
      nHAlign := NIL
      nVAlign := NIL
      nRotate := NIL
      nBox    := 0.1  // in mm, 0.2 mm ist wohl Standard, 2 ist 2 mm dick !

      oHBPrintPDF:PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox  )

      nRotate :=  90
      nPosY   +=  25

      oHBPrintPDF:PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox  )

      nRotate := 270
      nPosX   +=  25

      oHBPrintPDF:PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox  )

      nPosX   := 174
      nPosY   :=  17
      nRotate := 180

      oHBPrintPDF:PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox  )

      nPosX   := 140
      nPosY   :=  80
      nXSize  :=  53  // einpassen
      nYSize  :=  34  // scale
      cFileNameID := NIL // last selected => nBMPID
      nID     := NIL
      nHAlign := NIL
      nVAlign := NIL
      nRotate := NIL
      nBox    := -1  // default

      oHBPrintPDF:PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox  )


      oHBPrintPDF:PrintPageNo()
      oHBPrintPDF:newPage()

      oHBPrintPDF:SetTextCpi(12)  // Fontgre fr 12 CPI einstellen / change font size to 12 cpi
      oHBPrintPDF:SetCPI(12)      // 10 char per inch / Zeichen pro inch -> SAY
      oHBPrintPDF:SetSayLinesPerPage(76) // 76 Zeilen pro Seite

      ? "Zweite Seite: 12 CPI, "+str(oHBPrintPDF:getLpi())+" LPI, Anzahl der Zeilen pro Seite:", oHBPrintPDF:GetSayLinesPerPage()
      for x := 1 to oHBPrintPDF:GetSayLinesPerPage()
          oHBPrintPDF:say(x,1,"Zeile "+str(x,4)+" von "+str(oHBPrintPDF:GetSayLinesPerPage(),4)+"   "+;
                                 "123456789-123456789-123456789-123456789-123456789-123456789-123456789-"+;
                                 "123456789-123456789-123456789-123456789-123456789-123456789-123456789-")
      next
      oHBPrintPDF:PrintPageNo()
      oHBPrintPDF:newPage()

      oHBPrintPDF:SetTextCpi(10)      // Fontgre fr 12 CPI einstellen / change font size to 12 cpi
      oHBPrintPDF:SetCPI(10)          // 10 char per inch / Zeichen pro inch -> SAY
      oHBPrintPDF:SetSayLineFeed(10)  // 10 mm Zeilenabstand

      ? "Dritte Seite: 10 CPI, Zeilenahhe 10 mm, Anzahl der Zeilen pro Seite:", oHBPrintPDF:GetSayLinesPerPage()
      for x := 1 to oHBPrintPDF:GetSayLinesPerPage()
          oHBPrintPDF:say(x,1,"Zeile "+str(x,4)+" von "+str(oHBPrintPDF:GetSayLinesPerPage(),4)+"   "+;
                                 "123456789-123456789-123456789-123456789-123456789-123456789-123456789-")
      next
      oHBPrintPDF:PrintPageNo()
      oHBPrintPDF:newPage()

      oHBPrintPDF:SetTextCpi(10)  // Fontgre fr 10 CPI einstellen / change font size to 10 cpi
      oHBPrintPDF:SetCPI(10)      // 10 char per inch / Zeichen pro inch -> SAY
      oHBPrintPDF:SetLPI(6)       //  6 lines per inch / Zeilen pro inch -> SAY

      oHBPrintPDF:Say(3.5,10,"SAY() + ::SetTextUnderline()")

      for x := 0 to 4
          oHBPrintPDF:SetTextUnderline(x)
          oHBPrintPDF:say(5,10+x*13,"Underline: "+str(x,3))
      next
      oHBPrintPDF:SetTextUnderline(0)

      oHBPrintPDF:AddStandardFont(STANDARDFONTID_COURIER) // nur damit stimmen die Gren // only COURIER is good for CPI alignment

      oHBPrintPDF:SetTextCpi(10)  // Fontgre fr 10 CPI einstellen / change font size to 10 cpi
      oHBPrintPDF:SetCPI(10)      // 10 char per inch / Zeichen pro inch -> SAY
      oHBPrintPDF:SetLPI(6)       //  6 lines per inch / Zeilen pro inch -> SAY




      ? "Vierte Seite: 10 CPI, 6 LPI, Anzahl der Zeilen pro Seite:", oHBPrintPDF:GetSayLinesPerPage()
      ? ":SAY... Befehle"

      nVonCol    := 10
      nVonRow    := 10
      nBisCol    := 20
      nBisRow    := 15
      cAlign1    := NIL
      cAlign2    := NIL
      nOffset    := NIL
      nCPI       := NIL
      nLPI       := NIL

      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"SAY() + SayLine() - nOffset=0 .or. NIL")

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Standardvorgabe - Linien in der Mitte // default line is in the middle

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // waagerecht oben   // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // waagerecht unten  // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // senkrecht links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // senkrecht rechts  // right

      nVonCol    += 25
      nBisCol    += 25

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Auenkante // line outside

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_TOP_RIGHT,nOffset,nCPI,nLPI)     // oben    // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_LEFT ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // unten   // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_BOTTOM_LEFT,nOffset,nCPI,nLPI)   // links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_RIGHT   ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // rechts  // right

      nVonCol    += 25
      nBisCol    += 25

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Innenkante // line inside

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_BOTTOM_LEFT,nOffset,nCPI,nLPI)  // oben    // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_RIGHT    ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // unten   // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_TOP_RIGHT,nOffset,nCPI,nLPI)    // links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_LEFT  ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // rechts  // right

      nVonCol    := 10
      nBisCol    := 20
      nVonRow    += 10
      nBisRow    += 10
      nOffset    :=  3

      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"SAY() + SayLine() - nOffset="+alltrim(str(nOffset))+"mm")

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Standardvorgabe - Linien in der Mitte // default line is in the middle

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // waagerecht oben   // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // waagerecht unten  // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // senkrecht links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // senkrecht rechts  // right

      nVonCol    += 25
      nBisCol    += 25

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Auenkante // line outside

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_TOP_RIGHT,nOffset,nCPI,nLPI)     // oben    // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_LEFT ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // unten   // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_BOTTOM_LEFT,nOffset,nCPI,nLPI)   // links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_RIGHT   ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // rechts  // right

      nVonCol    += 25
      nBisCol    += 25

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Innenkante // line inside

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_BOTTOM_LEFT,nOffset,nCPI,nLPI)  // oben    // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_RIGHT    ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // unten   // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_TOP_RIGHT,nOffset,nCPI,nLPI)    // links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_LEFT  ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // rechts  // right

      nVonCol    := 10
      nBisCol    := 20
      nVonRow    += 10
      nBisRow    += 10
      nOffset    := -3

      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"SAY() + SayLine() - nOffset="+alltrim(str(nOffset))+"mm")

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Standardvorgabe - Linien in der Mitte // default line is in the middle

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // waagerecht oben   // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // waagerecht unten  // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // senkrecht links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,cAlign1,cAlign2,nOffset,nCPI,nLPI)  // senkrecht rechts  // right

      nVonCol    += 25
      nBisCol    += 25

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Auenkante // line outside

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_TOP_RIGHT,nOffset,nCPI,nLPI)     // oben    // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_LEFT ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // unten   // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,SAYLINE_ALIGN_TOP_LEFT    ,SAYLINE_ALIGN_BOTTOM_LEFT,nOffset,nCPI,nLPI)   // links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_RIGHT   ,SAYLINE_ALIGN_BOTTOM_RIGHT,nOffset,nCPI,nLPI)  // rechts  // right

      nVonCol    += 25
      nBisCol    += 25

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      // Innenkante // line inside

      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // schrg            // top left - bottom right
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nVonRow,nBisCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_BOTTOM_LEFT,nOffset,nCPI,nLPI)  // oben    // top
      oHBPrintPDF:SayLine(nBisRow,nVonCol,nBisRow,nBisCol,SAYLINE_ALIGN_TOP_RIGHT    ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // unten   // bottom
      oHBPrintPDF:SayLine(nVonRow,nVonCol,nBisRow,nVonCol,SAYLINE_ALIGN_BOTTOM_RIGHT ,SAYLINE_ALIGN_TOP_RIGHT,nOffset,nCPI,nLPI)    // links   // left
      oHBPrintPDF:SayLine(nVonRow,nBisCol,nBisRow,nBisCol,SAYLINE_ALIGN_BOTTOM_LEFT  ,SAYLINE_ALIGN_TOP_LEFT,nOffset,nCPI,nLPI)     // rechts  // right

      // SayBox()

      nVonCol      := 10
      nBisCol      := 20
      nVonRow      += 10
      nBisRow      += 10
      nOffset      :=  0

      nDrawOptions := NIL

      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"SAY() + SayBox()")

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      oHBPrintPDF:SayBox(nVonRow,nVonCol,nBisRow,nBisCol,nOffset,nDrawOptions,nCPI,nLPI)

      nVonCol    += 25
      nBisCol    += 25

      nOffset    :=  1.5

      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"nOffset="+alltrim(str(nOffset))+"mm")

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      oHBPrintPDF:SayBox(nVonRow,nVonCol,nBisRow,nBisCol,nOffset,nDrawOptions,nCPI,nLPI)

      nVonCol    += 25
      nBisCol    += 25

      nOffset    :=  -3

      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"nOffset="+alltrim(str(nOffset))+"mm")

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      oHBPrintPDF:SayBox(nVonRow,nVonCol,nBisRow,nBisCol,nOffset,nDrawOptions,nCPI,nLPI)

      // SayBox() - mit Farbe - with color

      nVonCol      := 10
      nBisCol      := 20
      nVonRow      += 10
      nBisRow      += 10
      nOffset      :=  0

      ? "SetFillColor(0,1,1)",;
      oHBPrintPDF:SetFillColor(0,1,1)
      ? "SetLineColor(1,0,0)",;
      oHBPrintPDF:SetLineColor(1,0,0) // Rote Linie / red line

      nDrawOptions := DRAWOPTIONS_OUTLINE  // DRAWOPTIONS_FILL // DRAWOPTIONS_ALL

      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"SayBox() + Color()")

      oHBPrintPDF:SayBox(nVonRow,nVonCol,nBisRow,nBisCol,nOffset,nDrawOptions,nCPI,nLPI)

      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      nVonCol    += 25
      nBisCol    += 25

      nDrawOptions := DRAWOPTIONS_FILL // DRAWOPTIONS_ALL

      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"FILL")
      oHBPrintPDF:SayBox(nVonRow,nVonCol,nBisRow,nBisCol,nOffset,nDrawOptions,nCPI,nLPI)
      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      nVonCol    += 25
      nBisCol    += 25

      nDrawOptions := DRAWOPTIONS_ALL
      oHBPrintPDF:Say(nVonRow-1.5,nVonCol,"ALL")
      oHBPrintPDF:SayBox(nVonRow,nVonCol,nBisRow,nBisCol,nOffset,nDrawOptions,nCPI,nLPI)
      oHBPrintPDF:Say(nVonRow,nVonCol,"A")
      oHBPrintPDF:Say(nVonRow,nBisCol,"W")
      oHBPrintPDF:Say(nBisRow,nVonCol,"j")
      oHBPrintPDF:Say(nBisRow,nBisCol,"Z")

      nVonRow := 60
      nVonCol := 40

      // :SAY() mit anderen Methoden mischen

      x := oHBPrintPDF:nColToPosX(nVonCol,nCPI)
      y := oHBPrintPDF:nRowToPosY(nVonRow,nLPI)

      oHBPrintPDF:DrawCircle(x,y,15,2)
      oHBPrintPDF:SelectFont()       // back to default, same as ::SelectFont(::nDefaultStandardFontID)
      oHBPrintPDF:PrintPageNo()
      oHBPrintPDF:SaveToFile(cPfad+cPDF)

      ?
      ? "Dateigre ber GetDocumentFileSize()",oHBPrintPDF:GetDocumentFileSize()
      ?

   endif

   ? "Bitte Taste drcken um PDF anzuzeigen ..."
   inkey(0)

   if file(cPfad+cPDF)
      if ! file(cAcrobat)
         cAcrobat := GetStandardProgramm(cPDF, cPfad)
      endif
      runshell(cPfad+cPDF,cAcrobat,.t.)
   endif


return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe

