#include "Xbp.ch"
#include "Gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "HBPrintPDF.ch"

// ANSI Text ! 

procedure main
   local oHBPrintPDF, cAcrobat, cPDF, cPfad, nWahl, cPrinterName, aPrinter, aBins, aBinTxt
   local cBarCode, nY, nX, nW, nH, nF, cImage, nImageID, x, cTxt
   cls

   set charset to OEM
   set alternate to test_OEM.txt
   set alternate on

   ? "Teste HBPrintPDF"

   cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe"
   cPDF     := "HelloFromDLL_.pdf"
   cPfad    := cAppPath()  // ot4xb
   delete file (cPDF)
   do while file (cPDF)
      msgbox("Die PDF Datei muss zuerst geschlossen werden / close PDF !" )
      delete file (cPDF)
   enddo
   ? "PDF:  '"+cPDF+"'"
   ? "Pfad: '"+cPfad+"'"
   ?
   ? "HBPrintPDF() erzeugen"
   ?

   oHBPrintPDF := HBPrintPDF():new():create() // GetQuickPDFLizenzKey() / cKey

   if oHBPrintPDF:IsOK
      ? "DLL-Version:",oHBPrintPDF:LibraryVersion()
      ? "nach Create - drucken"
      do case
         case set(_SET_CHARSET)=0 // ANSI
            cTxt := "EXE in ANSI (0)"
         case set(_SET_CHARSET)=1 // OEM
            cTxt := "EXE in OEM (1)"
         otherwise
            cTxt := "EXE ? ("+alltrim(str(set(_SET_CHARSET),3,0))+")"
      end
      oHBPrintPDF:Say(2,45,cTxt)
      ? "CHARSET: ",cTxt
      oHBPrintPDF:DrawText(20,30, "HBPrintPDF (QuickPDF) DLL: "+oHBPrintPDF:LibraryVersion())
      ? "Barcodes ..."
      nY       := 80
      nX       := 110
      cBarCode := "12345"
      oHBPrintPDF:DrawText(nX, nY+7,"Code39: "+cBarCode)
      oHBPrintPDF:DrawBarcode(150, nY,40,10,cBarCode,BARCODE_TYPE_Code39,0)
      nY += 20
      oHBPrintPDF:DrawText(nX,nY+7, "Code128: "+cBarCode)
      oHBPrintPDF:DrawBarcode(150, nY,40,10,cBarCode,BARCODE_TYPE_Code128,0)
      nY += 20
      cBarCode := "1234567890128"
      oHBPrintPDF:DrawText(nX,nY+7, "EAN13 NUM + SP:")
      oHBPrintPDF:DrawBarcode(150,nY,40,10,cBarCode,BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_NUMBER_SP)
      nY += 20
      oHBPrintPDF:DrawText(nX,nY+7, "EAN13 NUM: ")
      oHBPrintPDF:DrawBarcode(150,nY,40,10,left(cBarCode,12),BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_ONLY_NUM )
      nY += 20
      cBarCode := "4016138347036"
      oHBPrintPDF:DrawText(nX,nY+7, "EAN13 NUM: ")
      oHBPrintPDF:DrawBarcode(150,nY,40,10,cBarCode,BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_ONLY_NUM )

      nY := 80

      ? "DrawHTMLText" ,;
        oHBPrintPDF:DrawHTMLText(20, nY, 80, "Test <b>bold</b> mit <u>einigen Wrtern</u> um den Umbruch zu testen. "+;
                                             "Neue Zeile und Anfang der Listen:"+;
                                             "<br><br>Einfache Liste, mit Standardzeichen:<br><br>"+;
                                             "<ul><li>Haus: Diese Zeile soll so lang sein, dass ein Umbruch ntig wird <li>Hund<li>Zeit</ul>"+;
                                             "<br><br>Aufzhlung ab 1 :<br>"+;
                                             "<ol><li>B<li>A wenn man will, kann man den Inhalt ja auch vorher sortieren.<li>C<ol>" )
      ? "DrawHTMLText Fehler ?",oHBPrintPDF:LastErrorCode(),oHBPrintPDF:LastRenderError()



      oHBPrintPDF:say(,,"Oben Links")
      for x := 10 to 15
          ? "Append Zeile",x,oHBPrintPDF:say(x,,"Zeile:"+str(x,3))
      next
      oHBPrintPDF:say(10,20,"Gut so 10,20 !")
      oHBPrintPDF:say(11,20,"am "+dtoc(date()))
      oHBPrintPDF:say(12,20,"um "+time())
      x := 50
      oHBPrintPDF:say(x++,30,"Ausrichtung:")
      oHBPrintPDF:say(x++,30,"Left",  "L")
      oHBPrintPDF:say(x++,30,"Center","C")
      oHBPrintPDF:say(x++,30,"Right", "R")
      oHBPrintPDF:say(x++,30,date())
      oHBPrintPDF:say(x++,30,1234.56)
      oHBPrintPDF:say(x++,30,.t.)

      nY :=  20
      nX := 100
      for x := 1 to 10
          oHBPrintPDF:DrawText(nX,nY, "Zeile: "+str(x,3))
          nY += oHBPrintPDF:LineFeed()
      next
      nY :=  20
      nX := 130
      for x := 1 to  5
          oHBPrintPDF:DrawText(nX,nY, "Zeile: "+str(x,3))
          nY += oHBPrintPDF:LineFeed(2)
      next

      nY :=  20
      nX := 160
      for x := 1 to  7
          oHBPrintPDF:DrawText(nX,nY, "Zeile: "+str(x,3))
          ? x, "oHBPrintPDF:GetTextWidth('Zeile: '+str(x,3))  ",oHBPrintPDF:GetTextWidth("Zeile: "+str(x,3))
          oHBPrintPDF:DrawText(nX+oHBPrintPDF:GetTextWidth("Zeile: "+str(x,3)),nY,"<" )

          nY += oHBPrintPDF:LineFeed(1.5)
      next

      oHBPrintPDF:DrawRotatedText(160,250,  0,"Drehen   0 Grad")
      oHBPrintPDF:DrawRotatedText(160,250, 90,"Drehen  90 Grad")
      oHBPrintPDF:DrawRotatedText(160,250,180,"Drehen 180 Grad")
      oHBPrintPDF:DrawRotatedText(160,250,270,"Drehen 270 Grad")
      oHBPrintPDF:DrawRotatedText(170,240,360,"Drehen 360 Grad")

      // QuickPDF Image handling ... should be easier ;-)

      ? ":CompressImages( OPTION_YES ): ", oHBPrintPDF:CompressImages( OPTION_YES )
      cImage   := "BILD.bmp"

      if .f.  // the hard way, don't forget the nImageID ;-)
              // and look to the else for a easier way :-)
              // So sieht es QuickPDF vor (die Anwendung kmmert sich um nImageID
              // im else Zweig zeigen meine Methoden, wie es einfacher geht.

         nImageID := oHBPrintPDF:AddImageFromFile(cImage)

         if nImageID > 0
            oHBPrintPDF:AddImageID(nImageID,cImage)
            ? ":AddImageFromFile(cImage):     ", nImageID, " == nImageID"
            ? "Imageinfo:"
            ? ":ImageResolutionUnits():       ",oHBPrintPDF:ImageResolutionUnits()
            ? ":ImageHeight():                ",oHBPrintPDF:ImageHeight()
            ? ":ImageVerticalResolution():    ",oHBPrintPDF:ImageHorizontalResolution()
            ? ":ImageWidth():                 ",oHBPrintPDF:ImageWidth()
            ? ":ImageHorizontalResolution():  ",oHBPrintPDF:ImageHorizontalResolution()



   *         ? ":SelectImage(nImageID):        ", oHBPrintPDF:SelectImage(nImageID)
            nX := 20
            nY := oHBPrintPDF:PageHeight() - 70 // 42x45 mm image size
   *         ? ":DrawScaledImage(nX,nY,1):     ", oHBPrintPDF:DrawScaledImage(nX,nY,1) // faktor 0.0 to 1 => 0 to 100%
   *         ? ":DrawImage(nX,nY,30,30):       ", oHBPrintPDF:DrawImage(nX,nY,30,30)   // scale fixed size, NOT aspect ratio

            nY := oHBPrintPDF:PageHeight() - 50 // 30x30 mm max image size
            if oHBPrintPDF:ImageWidth() == oHBPrintPDF:ImageHeight()
               nW := 30
               nH := 30
            else
               nF := Min(oHBPrintPDF:ImageWidth(),oHBPrintPDF:ImageHeight())  / ;
                     Max(oHBPrintPDF:ImageWidth(),oHBPrintPDF:ImageHeight())
               if oHBPrintPDF:ImageWidth() > oHBPrintPDF:ImageHeight()
                  nW := 30
                  nH := 30 * nF
               else
                  nW := 30 * nF
                  nH := 30
               endif
            endif
            ? ":DrawImage(nX,nY,30,30):       ", oHBPrintPDF:DrawImage(nX,nY,nW,nH)   // manual scale size, aspect ratio OK

            nX := 50
            nY := oHBPrintPDF:PageHeight() - 50 // 30x30 mm max image size
            ? ":FitImage(nX,nY,30,30):        ", oHBPrintPDF:FitImage(nX,nY,30,30)    // auto scale size, aspect ratio OK
         endif                                                                          // best solution !!!


      else

         nX := 20
         nY := oHBPrintPDF:PageHeight() - 50 // 30x30 mm max image size
         nW := 30                            // auto fit !
         nH := 30

         ? "Imagecount(): ",oHBPrintPDF:ImageCount()," 0 is OK !  OK ?",oHBPrintPDF:ImageCount()==0

         if oHBPrintPDF:DrawImageFile(nX, nY, nW, nH,0,0,0,cImage )     .and. ;
            oHBPrintPDF:DrawImageFile(nX+30, nY, nW, nH,0,0,0,cImage )

            msgbox("Image wurde einmal gespeichert, 2 mal gemalt"+CRLF+;
                   "Image was saved once and drawn twice","OK")

            ? "Imageinfo:"
            ? ":ImageResolutionUnits():       ",oHBPrintPDF:ImageResolutionUnits()
            ? ":ImageHeight():                ",oHBPrintPDF:ImageHeight()
            ? ":ImageVerticalResolution():    ",oHBPrintPDF:ImageHorizontalResolution()
            ? ":ImageWidth():                 ",oHBPrintPDF:ImageWidth()
            ? ":ImageHorizontalResolution():  ",oHBPrintPDF:ImageHorizontalResolution()
            ?
            ? "Imagecount(): ",oHBPrintPDF:ImageCount()," 1 is OK !  OK ?",oHBPrintPDF:ImageCount()==1

         else

            msgbox("Fehler bei DrawImageFile() / Error in DrawImageFile()","ERROR")

         endif

      endif

      // Farbe, Color
      oHBPrintPDF:PrintText(20,190,"Farbe/Color: black ",,,, GRA_CLR_BLACK )
      oHBPrintPDF:PrintText(,,     "blue ",,,, GRA_CLR_BLUE )
      oHBPrintPDF:PrintText(,,     "red " ,,,, GRA_CLR_RED  )
      oHBPrintPDF:PrintText(,,     "pink ",,,, GRA_CLR_PINK )
      oHBPrintPDF:PrintText(,,     "green ",,,, GRA_CLR_GREEN)
      oHBPrintPDF:PrintText(,,     "cyan ",,,, GRA_CLR_CYAN )
      oHBPrintPDF:PrintText(,,     "yellow ",,,, GRA_CLR_YELLOW)
      oHBPrintPDF:PrintText(,,     "palegray ",,,,GRA_CLR_PALEGRAY)
      oHBPrintPDF:PrintText(,,     "black ",,,, GRA_CLR_BLACK )
      oHBPrintPDF:PrintText(,,     "red " ,,,, GRA_CLR_RED  )
      oHBPrintPDF:PrintText(,,     "NIL = active Color " )
      oHBPrintPDF:setTextColor()    // Reset to Black !
      oHBPrintPDF:PrintText(,,     "Reset" )

      oHBPrintPDF:PrintText(20,196,"Farbe/Color: black ",,,, GRA_CLR_BLACK )
      oHBPrintPDF:PrintText(,,     "D-blue ",,,,GRA_CLR_DARKBLUE)
      oHBPrintPDF:PrintText(,,     "D-red " ,,,,GRA_CLR_DARKRED)
      oHBPrintPDF:PrintText(,,     "D-pink ",,,,GRA_CLR_DARKPINK)
      oHBPrintPDF:PrintText(,,     "D-green ",,,,GRA_CLR_DARKGREEN)
      oHBPrintPDF:PrintText(,,     "D-cyan ",,,,GRA_CLR_DARKCYAN)
      oHBPrintPDF:PrintText(,,     "brown ",,,, GRA_CLR_BROWN)
      oHBPrintPDF:PrintText(,,     "D-gray ",,,,GRA_CLR_DARKGRAY)
      oHBPrintPDF:PrintText(,,     "black ",,,, GRA_CLR_BLACK )

      oHBPrintPDF:setTextColor()    // Reset to Black !

      oHBPrintPDF:newPage()

      oHBPrintPDF:PrintPageNo()
      // -> oHBPrintPDF:PrintText(105,285,"- #PN -","C")

      cTxt := "_#_________ ljksdl kflk lsd fjlskjflksjflsk flskjflsk flksj flks flkjs "+;
              "flksjdflkjldkfjs lfslkdfjlksjflksjdfl wersdw sdfsa dfas sadf s sdf  sd "+;
              "flksjdflkjldkfjs lfslkdfjlksjflksjdfl wersdw sdfsa dfas sadf s sdf d "+;
              "flksjdflkjldkfjs lfslkdfjlksjflksjdfl wersdw sdfsa dfas sadf s sdf esd "+;
              "flksjdflkjldkfjs lfslkdfjlksjflksjdfl wersdw sdfsa dfas. "+CRLF+;
              "Umlaute    ~   und EUR _ (c)  (r) "+CRLF+;
              "_LAST LINE_"

      nY := 25  // nTop # nBaseline !!!!

      oHBPrintPDF:SetTextAlign(TEXT_ALIGN_LEFT)
      oHBPrintPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","LEFT"), DRAWTEXTBOX_OPTION_TOP)

      // wohin muss die nchste Zeile ?  Man knnte den Rckgabewert abfragen und selbst rechnen, aber ...
      // ::DrawTextBoxNextTop enthlt den nTop Wert der nchsten freien Zeile.
      // where is the last printed line ?  The function will return the needed lines, but ...
      // ::DrawTextBoxNextTop does now the nTOP position of the next empty line

      oHBPrintPDF:SetTextAlign(TEXT_ALIGN_CENTER)
      nY := oHBPrintPDF:DrawTextBoxNextTop
      oHBPrintPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","CENTER"), DRAWTEXTBOX_OPTION_TOP)

      oHBPrintPDF:SetTextAlign(TEXT_ALIGN_RIGHT)
      nY := oHBPrintPDF:DrawTextBoxNextTop
      oHBPrintPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","RIGHT"), DRAWTEXTBOX_OPTION_TOP)

      oHBPrintPDF:SetTextAlign(TEXT_ALIGN_BLOCK_NORMAL)
      nY := oHBPrintPDF:DrawTextBoxNextTop
      oHBPrintPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","BLOCK_NORMAL"), DRAWTEXTBOX_OPTION_TOP)

      oHBPrintPDF:SetTextAlign(TEXT_ALIGN_LEFT)
      nY := oHBPrintPDF:DrawTextBoxNextTop
      oHBPrintPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","LEFT"), DRAWTEXTBOX_OPTION_TOP)

      // nTop -> nBaseLine
      nY := oHBPrintPDF:nTopToBaseline(oHBPrintPDF:DrawTextBoxNextTop)
      oHBPrintPDF:PrintText(nX,nY, "_NEXT LINE_ by :PrintText()")
      oHBPrintPDF:PrintText(70,nY-oHBPrintPDF:LineFeed(), ":PrintText() print in _LAST LINE _" ,,,,GRA_CLR_DARKRED )


      //------------------- END --- SAVE --- PRINT ------------------

      ? "Save File",oHBPrintPDF:SaveToFile(cPfad+cPDF)
      ? "File ? ",file(cPfad+cPDF)
      ? "Drucken ? "

      nWahl := alert("Dokument drucken ?",{"Nein", "Standarddrucker","Druckerauswahl","UNC-Name"})
      if nWahl==4    // wir brauchen mehr Auswahl !
         nWahl := alert("Druckerfach festlegen ?",{"Nein", "UNC-Name mit Bin","UNC-Name ohne Bin"})
         if nWahl==2 // nur bei 2 Festlegen
            nWahl:=4
         else
            nWahl:=5
         endif
      endif
      cls

      if nWahl > 1
         do case
            case nWahl==2
                 cPrinterName := oHBPrintPDF:GetDefaultPrinterName()
                 ? "Drucken auf Standard Drucker"
            case nWahl==3
                 ? "Druckerliste"
                 ?
                 aPrinter := oHBPrintPDF:GetPrinterNameA()
                 aEval(aPrinter,{|cN,i| qout(i,var2char(cN))} )
                 do while .t.
                    x := aScan(aPrinter,{|cName| "writer" $ lower(cName) .or. "pdf" $ lower(cName) } )
                    if x==0
                       ? "Nur noch richtige Drucker: ",len( aPrinter )
                       aEval(aPrinter,{|cN,i| qout(1,cN)} )
                       exit
                    else
                       aRemove(aPrinter,x)
                    endif
                 enddo
                 cls
                 @1,1 say "Drucker auswhlen:"
                 nWahl := AChoice( 3,20,15,60, aPrinter )
                 if nWahl > 0
                    cPrinterName := aPrinter[nWahl]
                    ? "Drucken auf gewhltem Drucker"
                 else
                    cPrinterName := ""
                 endif
            case nWahl==4
                 cPrinterName := "\\FSA-DC\Samsung CLP-550 Series PS" // anpassen !!!
                 ? "Drucken auf UNC-Drucker",cPrinterName,"Anpassen !"
            case nWahl==5
                 cPrinterName := "\\FSA-DC\Canon iP4500 series" // anpassen !!!
                 ? "Drucken auf UNC-Drucker",cPrinterName,"Anpassen !"

         end
         if ! empty(cPrinterName)
            cls
            ? "Drucker  '"+cPrinterName+"'"
            ? "Verfgbare Fcher: "
            ? "S: ["+oHBPrintPDF:GetPrinterBins(cPrinterName)+"]"
            aBins := oHBPrintPDF:GetPrinterBinA(cPrinterName)
            ? "A: ",var2char(aBins)
            ?
            if nWahl==5
               ? "Drucker meldet diese Fcher, 10 Sekunden warten, oder Taste drcken"
               inkey(10)
            endif
            cls
            @1,1 say "Drucker:   "+cPrinterName
            if nWahl<>5
               cPrinterName := oHBPrintPDF:NewCustomPrinter(cPrinterName)
               @2,1 say "Schacht whlen ..."
               aBinTxt := {}
               aEval(aBins,{|aZ| aadd(aBinTxt,str(aZ[1])+" "+aZ[2])})
               nWahl := 0
               if len(aBinTxt)>1
                  nWahl := AChoice( 3,20,15,60, aBinTxt )
               endif
               if nWahl > 0
                  x := val(aBinTxt[nWahl])
                  ? "Schachtsetzen auf: ",x,"= "+aBinTxt[nWahl] ,oHBPrintPDF:SetupCustomPrinter(cPrinterName,9,x)
               endif
            endif
            nWahl := alert("Welche Seiten drucken ?",{"1","2","3","alle"})
            if nWahl>0
               if nWahl==4
                  nWahl := oHBPrintPDF:PageCount()
               endif
               oHBPrintPDF:PrintDocument(cPrinterName,1,nWahl)
            endif
         endif
      endif
      oHBPrintPDF:destroy()
      ? "destroy - 10 Sekunden warten, oder Taste drcken"
   endif

   inkey(10)

   if file(cPfad+cPDF)
      if ! file(cAcrobat)
         cAcrobat := GetStandardProgramm(cPDF, cPfad)
      endif
      runshell(cPfad+cPDF,cAcrobat,.t.)
   endif


return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe

