#include "Xbp.ch"
#include "Gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "HBPrintPDF.ch"

// ANSI Text ! 

procedure main
   local oPDF, cAcrobat, cPDF, cPfad, nWahl, cPrinterName, aPrinter, aBins, aBinTxt, cUnit
   local cBarCode, nY, nX, nW, nH, nF, cImage, nImageID, x, cTxt, nDestID, nActivePage, cCMD
   cls

   set charset to ansi
   set alternate to test_log.txt
   set alternate on

   ? "Teste HBPrintPDF"

   cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe"
   cPDF     := "HelloFromDLL.pdf"
   cPfad    := cAppPath()  // ot4xb
   delete file (cPDF)
   do while file (cPDF)
      msgbox("Die PDF Datei muss zuerst geschlossen werden / close PDF !" )
      delete file (cPDF)
   enddo
   ? "PDF:  '"+cPDF+"'"
   ? "Pfad: '"+cPfad+"'"
   ?
   ? "HBPrintPDF() erzeugen"
   ?

   oPDF := HBPrintPDF():new():create() // GetQuickPDFLizenzKey() / cKey

   if oPDF:IsOK
      ? "DLL-Version:",oPDF:LibraryVersion()
      /* Key The property to set:
         0 = PDF Version
         1 = Author
         2 = Title
         3 = Subject
         4 = Keywords
         5 = Creator
         6 = Producer
      */
      ? "SetInformation( 1 )", oPDF:SetInformation( 1 , "Hubert Brandel ()" )
      ? "SetInformation( 2 )", oPDF:SetInformation( 2 , "HBPrintPDF - PDF from test.prg" )
      ? "SetInformation( 3 )", oPDF:SetInformation( 3 , "HBPrintPDF - PRG-Example ()" )
      ? "SetInformation( 4 )", oPDF:SetInformation( 4 , "HBPrintPDF, QuickPDF" )
      ? "SetInformation( 5 )", oPDF:SetInformation( 5 , "HBPrintPDF - Xbase++ CLASS for QuickPDF" )
      ? "nach Create - Text ausgeben"
      do case
         case set(_SET_CHARSET)=0 // ANSI
            cTxt := "EXE in ANSI (0)"
         case set(_SET_CHARSET)=1 // OEM
            cTxt := "EXE in OEM (1)"
         otherwise
            cTxt := "EXE ? ("+alltrim(str(set(_SET_CHARSET),3,0))+")"
      end
      oPDF:Say(2,45,cTxt)
      ? "CHARSET: ",cTxt
      oPDF:SetPageLayout(0) // single page
      oPDF:DrawText(20,30, "HBPrintPDF (QuickPDF) DLL: "+oPDF:LibraryVersion())

      do case
         case oPDF:nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
              cUnit := "mm"
         case oPDF:nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
              cUnit := "inch"
         otherwise
              cUnit := "1/72 inch"
      end

      ? "PageHeight():      ",oPDF:PageHeight(),cUnit
      ? "PageWidth ():      ",oPDF:PageWidth (),cUnit
      ? "Barcodes ..."

      nY       := 80
      nX       := 110
      cBarCode := "12345"
      oPDF:DrawText(nX, nY+7,"Code39: "+cBarCode)
      oPDF:DrawBarcode(150, nY,40,10,cBarCode,BARCODE_TYPE_Code39,0)
      nY += 20
      oPDF:DrawText(nX,nY+7, "Code128: "+cBarCode)
      oPDF:DrawBarcode(150, nY,40,10,cBarCode,BARCODE_TYPE_Code128,0)
      nY += 20
      cBarCode := "1234567890128"
      oPDF:DrawText(nX,nY+7, "EAN13 NUM + SP:")
      oPDF:DrawBarcode(150,nY,40,10,cBarCode,BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_NUMBER_SP)
      nY += 20
      oPDF:DrawText(nX,nY+7, "EAN13 NUM: ")
      oPDF:DrawBarcode(150,nY,40,10,left(cBarCode,12),BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_ONLY_NUM )
      nY += 20
      cBarCode := "4016138347036"
      oPDF:DrawText(nX,nY+7, "EAN13 NUM: ")
      oPDF:DrawBarcode(150,nY,40,10,cBarCode,BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_ONLY_NUM )

      nY := 80

      ? "DrawHTMLText" ,;
        oPDF:DrawHTMLText(20, nY, 80, "Test <b>bold</b> mit <u>einigen Wrtern</u> um den Umbruch zu testen. "+;
                                             "Neue Zeile und Anfang der Listen:"+;
                                             "<br><br>Einfache Liste, mit Standardzeichen:<br><br>"+;
                                             "<ul><li>Haus: Diese Zeile soll so lang sein, dass ein Umbruch ntig wird <li>Hund<li>Zeit</ul>"+;
                                             "<br><br>Aufzhlung ab 1 :<br>"+;
                                             "<ol><li>B<li>A wenn man will, kann man den Inhalt ja auch vorher sortieren.<li>C<ol>" )
      ? "DrawHTMLText Fehler ?",oPDF:LastErrorCode(),oPDF:LastRenderError()



      oPDF:say(,,"Oben Links")
      for x := 10 to 15
          ? "Append Zeile",x,oPDF:say(x,,"Zeile:"+str(x,3))
      next
      oPDF:say(10,20,"Gut so 10,20 !")
      oPDF:say(11,20,"am "+dtoc(date()))
      oPDF:say(12,20,"um "+time())
      x := 50
      oPDF:say(x++,30,"Ausrichtung:")
      oPDF:say(x++,30,"Left",  "L")
      oPDF:say(x++,30,"Center","C")
      oPDF:say(x++,30,"Right", "R")
      oPDF:say(x++,30,date())
      oPDF:say(x++,30,1234.56)
      oPDF:say(x++,30,.t.)

      nY :=  20
      nX := 100
      for x := 1 to 10
          oPDF:DrawText(nX,nY, "Zeile: "+str(x,3))
          nY += oPDF:LineFeed()
      next
      nY :=  20
      nX := 130
      for x := 1 to  5
          oPDF:DrawText(nX,nY, "Zeile: "+str(x,3))
          nY += oPDF:LineFeed(2)
      next

      nY :=  20
      nX := 160
      for x := 1 to  7
          oPDF:DrawText(nX,nY, "Zeile: "+str(x,3))
          ? x, "oPDF:GetTextWidth('Zeile: '+str(x,3))  ",oPDF:GetTextWidth("Zeile: "+str(x,3))
          oPDF:DrawText(nX+oPDF:GetTextWidth("Zeile: "+str(x,3)),nY,"<" )

          nY += oPDF:LineFeed(1.5)
      next

      oPDF:DrawRotatedText(160,250,  0,"Drehen   0 Grad")
      oPDF:DrawRotatedText(160,250, 90,"Drehen  90 Grad")
      oPDF:DrawRotatedText(160,250,180,"Drehen 180 Grad")
      oPDF:DrawRotatedText(160,250,270,"Drehen 270 Grad")
      oPDF:DrawRotatedText(170,240,360,"Drehen 360 Grad")

      // QuickPDF Image handling ... should be easier ;-)

      ? ":CompressImages( OPTION_YES ): ", oPDF:CompressImages( OPTION_YES )
      cImage   := "BILD.bmp"

      if .f.  // the hard way, don't forget the nImageID ;-)
              // and look to the else for a easier way :-)
              // So sieht es QuickPDF vor (die Anwendung kmmert sich um nImageID
              // im else Zweig zeigen meine Methoden, wie es einfacher geht.

         nImageID := oPDF:AddImageFromFile(cImage)

         if nImageID > 0
            oPDF:AddImageID(nImageID,cImage)
            ? ":AddImageFromFile(cImage):     ", nImageID, " == nImageID"
            ? "Imageinfo:"
            ? ":ImageResolutionUnits():       ",oPDF:ImageResolutionUnits()
            ? ":ImageHeight():                ",oPDF:ImageHeight()
            ? ":ImageVerticalResolution():    ",oPDF:ImageHorizontalResolution()
            ? ":ImageWidth():                 ",oPDF:ImageWidth()
            ? ":ImageHorizontalResolution():  ",oPDF:ImageHorizontalResolution()



   *         ? ":SelectImage(nImageID):        ", oPDF:SelectImage(nImageID)
            nX := 20
            nY := oPDF:PageHeight() - 70 // 42x45 mm image size
   *         ? ":DrawScaledImage(nX,nY,1):     ", oPDF:DrawScaledImage(nX,nY,1) // faktor 0.0 to 1 => 0 to 100%
   *         ? ":DrawImage(nX,nY,30,30):       ", oPDF:DrawImage(nX,nY,30,30)   // scale fixed size, NOT aspect ratio

            nY := oPDF:PageHeight() - 50 // 30x30 mm max image size
            if oPDF:ImageWidth() == oPDF:ImageHeight()
               nW := 30
               nH := 30
            else
               nF := Min(oPDF:ImageWidth(),oPDF:ImageHeight())  / ;
                     Max(oPDF:ImageWidth(),oPDF:ImageHeight())
               if oPDF:ImageWidth() > oPDF:ImageHeight()
                  nW := 30
                  nH := 30 * nF
               else
                  nW := 30 * nF
                  nH := 30
               endif
            endif
            ? ":DrawImage(nX,nY,30,30):       ", oPDF:DrawImage(nX,nY,nW,nH)   // manual scale size, aspect ratio OK

            nX := 50
            nY := oPDF:PageHeight() - 50 // 30x30 mm max image size
            ? ":FitImage(nX,nY,30,30):        ", oPDF:FitImage(nX,nY,30,30)    // auto scale size, aspect ratio OK
         endif                                                                          // best solution !!!


      else

         nX := 20
         nY := oPDF:PageHeight() - 50 // 30x30 mm max image size
         nW := 30                            // auto fit !
         nH := 30

         ? "Imagecount(): ",oPDF:ImageCount()," 0 is OK !  OK ?",oPDF:ImageCount()==0

         if oPDF:DrawImageFile(nX, nY, nW, nH,0,0,0,cImage )     .and. ;
            oPDF:DrawImageFile(nX+30, nY, nW, nH,0,0,0,cImage )

            msgbox("Image wurde einmal gespeichert, 2 mal gemalt"+CRLF+;
                   "Image was saved once and drawn twice","OK")

            ? "Imageinfo:"
            ? ":ImageResolutionUnits():       ",oPDF:ImageResolutionUnits()
            ? ":ImageHeight():                ",oPDF:ImageHeight()
            ? ":ImageVerticalResolution():    ",oPDF:ImageHorizontalResolution()
            ? ":ImageWidth():                 ",oPDF:ImageWidth()
            ? ":ImageHorizontalResolution():  ",oPDF:ImageHorizontalResolution()
            ?
            ? "Imagecount(): ",oPDF:ImageCount()," 1 is OK !  OK ?",oPDF:ImageCount()==1

         else

            msgbox("Fehler bei DrawImageFile() / Error in DrawImageFile()","ERROR")

         endif

      endif

      // Farbe, Color
      oPDF:setTextColorXB( GRA_CLR_PINK )                                // Alle Textausdrucke einfrben !
      oPDF:PrintText(10,190,"=>")
      oPDF:PrintText(20,190,"Farbe/Color: black ",,,, GRA_CLR_BLACK )    // Farbangabe geht vor ::SetTextColor()
      oPDF:PrintText(,,     "blue ",,,, GRA_CLR_BLUE )                   // define the color for this line, ignore ::SetTextColor()
      oPDF:PrintText(,,     "red " ,,,, GRA_CLR_RED  )
      oPDF:PrintText(,,     "pink ",,,, GRA_CLR_PINK )
      oPDF:PrintText(,,     "green ",,,, GRA_CLR_GREEN)
      oPDF:PrintText(,,     "cyan ",,,, GRA_CLR_CYAN )
      oPDF:PrintText(,,     "yellow ",,,, GRA_CLR_YELLOW)
      oPDF:PrintText(,,     "palegray ",,,,GRA_CLR_PALEGRAY)
      oPDF:PrintText(,,     "black ",,,, GRA_CLR_BLACK )
      oPDF:PrintText(,,     "red " ,,,, GRA_CLR_RED  )
      oPDF:PrintText(,,     "NIL = active Color " )                      // keine Farbangabe / no color for this line, => ::SetTextColor() => GRA_CLR_PINK
      oPDF:setTextColor()    // Reset to Black !
      oPDF:PrintText(,,     "Reset" )

      oPDF:setTextColorXB( GRA_CLR_GREEN )                               // this is the new default color for text !
      oPDF:PrintText(10,196,"=>")
      oPDF:PrintText(20,196,"Farbe/Color: black ",,,, GRA_CLR_BLACK )
      oPDF:PrintText(,,     "D-blue ",,,,GRA_CLR_DARKBLUE)
      oPDF:PrintText(,,     "D-red " ,,,,GRA_CLR_DARKRED)
      oPDF:PrintText(,,     "D-pink ",,,,GRA_CLR_DARKPINK)
      oPDF:PrintText(,,     "D-green ",,,,GRA_CLR_DARKGREEN)
      oPDF:PrintText(,,     "D-cyan ",,,,GRA_CLR_DARKCYAN)
      oPDF:PrintText(,,     "brown ",,,, GRA_CLR_BROWN)
      oPDF:PrintText(,,     "D-gray ",,,,GRA_CLR_DARKGRAY)
      oPDF:PrintText(,,     "black ",,,, GRA_CLR_BLACK )
      oPDF:setTextColor()    // Reset to Black !

      oPDF:newPage()

      oPDF:PrintPageNo()
      // -> oPDF:PrintText(105,285,"- #PN -","C")

      cTxt := "_#_________ ljksdl kflk lsd fjlskjflksjflsk flskjflsk flksj flks flkjs "+;
              "flksjdflkjldkfjs lfslkdfjlksjflksjdfl wersdw sdfsa dfas sadf s sdf  sd "+;
              "flksjdflkjldkfjs lfslkdfjlksjflksjdfl wersdw sdfsa dfas sadf s sdf d "+;
              "flksjdflkjldkfjs lfslkdfjlksjflksjdfl wersdw sdfsa dfas sadf s sdf esd "+;
              "flksjdflkjldkfjs lfslkdfjlksjflksjdfl wersdw sdfsa dfas. "+CRLF+;
              "Umlaute    ~   und EUR  (c)  (r) "+CRLF+;
              "_LAST LINE_"

      nY := 25  // nTop # nBaseline !!!!

      oPDF:SetTextAlign(TEXT_ALIGN_LEFT)
      oPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","LEFT"), DRAWTEXTBOX_OPTION_TOP)

      // wohin muss die nchste Zeile ?  Man knnte den Rckgabewert abfragen und selbst rechnen, aber ...
      // ::DrawTextBoxNextTop enthlt den nTop Wert der nchsten freien Zeile.
      // where is the last printed line ?  The function will return the needed lines, but ...
      // ::DrawTextBoxNextTop does now the nTOP position of the next empty line

      oPDF:SetTextAlign(TEXT_ALIGN_CENTER)
      nY := oPDF:DrawTextBoxNextTop
      oPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","CENTER"), DRAWTEXTBOX_OPTION_TOP)

      oPDF:SetTextAlign(TEXT_ALIGN_RIGHT)
      nY := oPDF:DrawTextBoxNextTop
      oPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","RIGHT"), DRAWTEXTBOX_OPTION_TOP)

      oPDF:SetTextAlign(TEXT_ALIGN_BLOCK_NORMAL)
      nY := oPDF:DrawTextBoxNextTop
      oPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","BLOCK_NORMAL"), DRAWTEXTBOX_OPTION_TOP)

      oPDF:SetTextAlign(TEXT_ALIGN_LEFT)
      nY := oPDF:DrawTextBoxNextTop
      oPDF:drawTextBox(nX,nY,170,270-nY,strTran(cTxt,"#","LEFT"), DRAWTEXTBOX_OPTION_TOP)

      // nTop -> nBaseLine
      nY := oPDF:nTopToBaseline(oPDF:DrawTextBoxNextTop)
      oPDF:PrintText(nX,nY, "_NEXT LINE_ by :PrintText()")

      oPDF:PrintText(70,nY-oPDF:LineFeed(), ":PrintText() print in _LAST LINE _" ,,,,GRA_CLR_DARKRED )

      nY += oPDF:LineFeed(2)    // eine Zeile leer lassen, skip 2 lines
      oPDF:PrintText(nX,nY, "namedDest:   ShowThis1 _" )
      oPDF:DrawText(nX+50,nY, "_("+var2char(nX)+"/"+var2char(nY)+")" )

      ? "Set NewDestination to Page: ", oPDF:GetPageNo() , "  Percent: 100, Type 1 (XYZ) X: " , nX , "Y: ", nY," => ?  "
      nDestID := oPDF:NewDestination(oPDF:GetPageNo(), 100, 1, nX, nY-10, 0, 0 )   // nY-10 => 10mm ber/over baseline
      if nDestID=0
         ?? "Fehler !"
      else
         ?? "ID:",alltrim(str(nDestID))
         ?
         ? "Set NewNamedDestination: ", oPDF:NewNamedDestination("ShowThis1",nDestID)
         ?
         ? "Find ShowThis1:",oPDF:GetNamedDestination("ShowThis1")
         ? "nDestID:       ",nDestID
         ? "GetDestName(): ",oPDF:GetDestName(nDestID)
         ? "GetDestPage(): ",oPDF:GetDestPage(nDestID)
         ? "GetDestType(): ",oPDF:GetDestType(nDestID)
         ? "GetDestValues()"
         ? "   1 (Left):   ", oPDF:GetDestValue(nDestID,1), nX
         ? "   2 (Top):    ", oPDF:GetDestValue(nDestID,2), nY
         ? "   3 (Right):  ", oPDF:GetDestValue(nDestID,3), "    NIL"
         ? "   4 (Bottom): ", oPDF:GetDestValue(nDestID,4), "    NIL"
         ? "   5 (Zoom): "  , oPDF:GetDestValue(nDestID,4), 100
      endif

      nY += oPDF:LineFeed(7)    // eine Zeile leer lassen, skip 2 lines

      oPDF:PrintText(nX,nY, "One Line ... ("+var2char(nX)+"/"+var2char(nY)+")" )


      oPDF:newPage()


      nY := 70
      nX := 50
      oPDF:PrintText(nX,nY, "namedDest:   ShowThis2 _")
      oPDF:DrawText(nX+50,nY, "_("+var2char(nX)+"/"+var2char(nY)+")" )
      ? "Set NewDestination to Page: ", oPDF:GetPageNo() , "  Percent: 100, Type 1 (XYZ) X: " , nX , "Y: ", nY," => ?  "
      nDestID := oPDF:NewDestination(oPDF:GetPageNo(), 100, 1, nX, nY-10, 0, 0 )     // nY-10 => 10mm ber/over baseline
      if nDestID=0
         ?? "Fehler !"
      else
         ?? "ID:",alltrim(str(nDestID))
         ? "Set NewNamedDestination: ", oPDF:NewNamedDestination("ShowThis2",nDestID)
         ? "Find ShowThis2:",oPDF:GetNamedDestination("ShowThis2")
         ? "nDestID:       ",nDestID
         ? "GetDestName(): ",oPDF:GetDestName(nDestID)
         ? "GetDestPage(): ",oPDF:GetDestPage(nDestID)
         ? "GetDestType(): ",oPDF:GetDestType(nDestID)
         ? "GetDestValues()"
         ? "   1 (Left):   ", oPDF:GetDestValue(nDestID,1), nX
         ? "   2 (Top):    ", oPDF:GetDestValue(nDestID,2), nY
         ? "   3 (Right):  ", oPDF:GetDestValue(nDestID,3), "    NIL"
         ? "   4 (Bottom): ", oPDF:GetDestValue(nDestID,4), "    NIL"
         ? "   5 (Zoom): "  , oPDF:GetDestValue(nDestID,4), 100

      endif

      oPDF:DrawText(20,240, "== Unten Seite 3")
      nDestID := oPDF:NewDestination( oPDF:GetPageNo() , 100, 1, 20, 230, 0, 0 )
      if nDestID=0
         ?? "Fehler !"
      else
         ? "set link on page 1 for destination on page 3"
         nActivePage := oPDF:GetPageNo()
         ? "goto Page 1 : ", oPDF:SelectPage( 1 )
         ? "print text :  ", oPDF:DrawText(40,170, "=> Unten Seite 3")
         ? "AddLinkToDestination() => Unten Seite 3 ", oPDF:AddLinkToDestination(30,160,50,20,nDestID,1)
         ? "go back to Page ",nActivePage, " : ", oPDF:SelectPage( nActivePage )
      endif

      //------------------- END --- SAVE --- PRINT ------------------

      ? "Save File",oPDF:SaveToFile(cPfad+cPDF)
      ? "File ? ",file(cPfad+cPDF)
      ? "Drucken ? "

      nWahl := alert("Dokument drucken ?",{"Nein", "Standarddrucker","Druckerauswahl","UNC-Name"})
      if nWahl==4    // wir brauchen mehr Auswahl !
         nWahl := alert("Druckerfach festlegen ?",{"Nein", "UNC-Name mit Bin","UNC-Name ohne Bin"})
         if nWahl==2 // nur bei 2 Festlegen
            nWahl:=4
         else
            nWahl:=5
         endif
      endif
      cls

      if nWahl > 1
         do case
            case nWahl==2
                 cPrinterName := oPDF:GetDefaultPrinterName()
                 ? "Drucken auf Standard Drucker"
            case nWahl==3
                 ? "Druckerliste"
                 ?
                 aPrinter := oPDF:GetPrinterNameA()
                 aEval(aPrinter,{|cN,i| qout(i,var2char(cN))} )
                 do while .t.
                    x := aScan(aPrinter,{|cName| "writer" $ lower(cName) .or. "pdf" $ lower(cName) } )
                    if x==0
                       ? "Nur noch richtige Drucker: ",len( aPrinter )
                       aEval(aPrinter,{|cN,i| qout(1,cN)} )
                       exit
                    else
                       aRemove(aPrinter,x)
                    endif
                 enddo
                 cls
                 @1,1 say "Drucker auswhlen:"
                 nWahl := AChoice( 3,20,15,60, aPrinter )
                 if nWahl > 0
                    cPrinterName := aPrinter[nWahl]
                    ? "Drucken auf gewhltem Drucker"
                 else
                    cPrinterName := ""
                 endif
            case nWahl==4
                 cPrinterName := "\\FSA-DC\Samsung CLP-550 Series PS" // anpassen !!!
                 ? "Drucken auf UNC-Drucker",cPrinterName,"Anpassen !"
            case nWahl==5
                 cPrinterName := "\\FSA-DC\Canon iP4500 series" // anpassen !!!
                 ? "Drucken auf UNC-Drucker",cPrinterName,"Anpassen !"

         end
         if ! empty(cPrinterName)
            cls
            ? "Drucker  '"+cPrinterName+"'"
            ? "Verfgbare Fcher: "
            ? "S: ["+oPDF:GetPrinterBins(cPrinterName)+"]"
            aBins := oPDF:GetPrinterBinA(cPrinterName)
            ? "A: ",var2char(aBins)
            ?
            if nWahl==5
               ? "Drucker meldet diese Fcher, 10 Sekunden warten, oder Taste drcken"
               inkey(10)
            endif
            cls
            @1,1 say "Drucker:   "+cPrinterName
            if nWahl<>5
               cPrinterName := oPDF:NewCustomPrinter(cPrinterName)
               @2,1 say "Schacht whlen ..."
               aBinTxt := {}
               aEval(aBins,{|aZ| aadd(aBinTxt,str(aZ[1])+" "+aZ[2])})
               nWahl := 0
               if len(aBinTxt)>1
                  nWahl := AChoice( 3,20,15,60, aBinTxt )
               endif
               if nWahl > 0
                  x := val(aBinTxt[nWahl])
                  ? "Schachtsetzen auf: ",x,"= "+aBinTxt[nWahl] ,oPDF:SetupCustomPrinter(cPrinterName,9,x)
               endif
            endif
            nWahl := alert("Welche Seiten drucken ?",{"1","1-2","1-3","alle"})
            if nWahl>0
               if nWahl==4
                  nWahl := oPDF:PageCount()
               endif
               oPDF:PrintDocument(cPrinterName,1,nWahl)
            endif
         endif
      endif
      oPDF:destroy()
      ? "destroy - 10 Sekunden warten, oder Taste drcken"
   endif

   inkey(10)

   cCMD := '@echo off'+CRLF+;
           'set AcroReader="'+GetStandardProgramm(cPDF, cPfad)+'"'+CRLF+;
           'set PDF="'+cPfad+cPDF+'"'+CRLF+;
           'echo.'+CRLF+;
           'echo Show PFD with   ShowThis1   ... and close the Reader'+CRLF+;
           '%AcroReader% /A "nameddest=ShowThis1" %PDF%'+CRLF+;
           'pause'+CRLF+;
           'echo.'+CRLF+;
           'echo Show PFD with   ShowThis2   ... and close the Reader'+CRLF+;
           '%AcroReader% /A "nameddest=ShowThis2" %PDF%'+CRLF+;
           'pause'+CRLF+;
           'echo.'+CRLF+;
           'echo Show Page 2  ... and close the Reader'+CRLF+;
           '%AcroReader% /A "page=2" %PDF%'+CRLF+;
           'echo End'+CRLF+;
           'pause'

   lMemoWrite( "ShowNamedDest.cmd" , cCMD)

   if file(cPfad+cPDF)
      if ! file(cAcrobat)
         cAcrobat := GetStandardProgramm(cPDF, cPfad)
      endif
      runshell(cPfad+cPDF,cAcrobat,.t.)
   endif


return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe

