#include "Xbp.ch"
#include "Common.ch"
#include "ot4xb.ch"

// Mehrere PDF mit einer Instanz erzeugen, schneller als MemoryTest.PRG ?
// Many PDF in one instance, faster than MemorTest.PRG ?

proc main
   local oHBPDF
   local cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe"
   local cPDF  := "HelloFromDLL.pdf"
   local cPfad := cAppPath()  // ot4xb
   local cBarCode, nY, nX, nStart, x, y, nSleep := 0, nDocID
   cls
   delete file (cPDF)
   ? "Teste HBPrintPDF - ManyPDF"
   ?
   ? "Pfad: '"+cPfad+"'"
   ?
   ? "bitte Taste drcken"

   inkey(0)
   nStart := seconds()

   oHBPDF := HBPrintPDF():new():create()

   for y := 1 to 10000
       ? time(),"PDF:  '"+cPDF+"'" , y
*       cPDF  := "HelloFromDLL_"+StrZero(y,5)+".pdf"
       if y > 1
          nDocID := oHBPDF:SelectedDocument()
          if empty(nDocID)
             msgbox("Error oHBPDF:SelectedDocument() return 0!")
             quit
          endif
          oHBPDF:NewDocument()
          oHBPDF:RemoveDocument(nDocID)
       endif
       oHBPDF:SetPageSize("A4")
       oHBPDF:SetMeasurementUnits(1) // 0=Points, 1=mm, 2=inch
       oHBPDF:SetOrigin(1)           // 0=Bottom Left, 1=Top Left

       oHBPDF:say(5,20,dtoc(date())+" - "+time())
       oHBPDF:DrawText(20,25, "Hello world with HBQuickPDF" )
       nY       := 100
       nX       := 70
       cBarCode := "12345"
       oHBPDF:DrawText(nX, nY,"Code39: "+cBarCode)
       oHBPDF:DrawBarcode(120, nY,40,10,cBarCode,1,0)
       nY += 20
       oHBPDF:DrawText(nX,nY, "Code128: "+cBarCode)
       oHBPDF:DrawBarcode(120, nY,40,10,cBarCode,3,0)
       nY += 20
       cBarCode := "1234567890128"
       oHBPDF:DrawText(nX,nY, "EAN13 NUMBER SP: "+cBarCode)
       oHBPDF:DrawBarcode(120,nY,40,10,cBarCode, 2, 3 ) // Draw the human-readable numbers, with right spacer
       nY += 20
       oHBPDF:DrawText(nX,nY, "EAN13 NUMBER:    "+cBarCode)
       oHBPDF:DrawBarcode(120,nY,40,10,cBarCode, 2, 2 ) // Draw the human-readable numbers
       nY += 20
       cBarCode := "4016138347036"
       oHBPDF:DrawText(nX,nY, "EAN13 NUMBER:    "+cBarCode)
       oHBPDF:DrawBarcode(120,nY,40,10,cBarCode, 2, 2 ) // Draw the human-readable numbers

       oHBPDF:SaveToFile(cPfad+cPDF)
       ?? "  ->   OK ? ",file( cPfad+cPDF )
       ? "sleep(nSleep), nSleep = ",nSleep
       sleep(nSleep)
   next

   oHBPDF:destroy()

   nStart := seconds() - nStart
   ?
   ? time(),"ENDE"
   ?
   ? "Dauer:",nStart
   ?
   ? "Bitte Taste drcken"
   inkey(0)



return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe
