// HBPrintPDF7 => QuickPDFDLL07xx.dll  (7.xx)
//
// Version 7.00 - 2012-07-31

#include "Xbp.ch"
#include "gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "directry.ch"
#include "HBPrintPDF.CH"

// ANSI QUELLCODE !!!   

/************************************************************************

    deutsch / german

    HB_PrintPDF ist freeware und darf ohne Einschrnkung verwendet werden.

    bentigt          QuickPdf DLL    QuickPDFDLL07xx.dll  (7.18, 7.19, 7.21, ff)
               Lizenzschlssel von    www.QuickPDF.com

                         OT4XB.DLL >= 001.005.012.021   from   www.xbwin.com

    Ohne Pablo Botella Navaro und seine OT4XB wre dies nicht mglich gewesen.
    Ich habe die Methoden aus seiner TQuickPdf wrapper class kopiert und
    nur die Rckgabewerte angepasst wo es ntig war. Das hat viel Zeit gespart.
    *HB* markiert genderte TQuickPdf Methoden

    Da die Lizenz fr die Hauptversion 7.xx gilt, wird diese Klasse immer
    auf die neueste Version angepasst. Man kann eine ltere DLL benutzen,
    solange man sich auf deren Methoden beschrnkt.
    Die Hauptversionsnummer von HBPrintPDF wurde auf die ntige QuickPDF Hauptversion gendert.

    Neue Versionen:    www.familie-brandel.de
                       www.xbaseforum.de          (nur in deutsch)

   ------------------------------------------------------------
     TQuickPdf wrapper class over the QuickPDFDLL0719.dll
           -> http://www.quickpdflibrary.com
     Author: Pablo Botella Navarro ( http://www.xbwin.com ) -
           -> http://www.xbwin.com.php?ng=/ot4xb.examples/36
   ------------------------------------------------------------

    WICHTIG ! Es gilt die Beschreibung der DLL mit folgenden Ausnahmen:
              1. Der Parameter InstanceID wird intern verwendet, also NIE angeben.
              2. Die Namen der Methoden entsprechen denen der ActiveX Beschreibung,
                 enthalten also NICHT den Vorsatz   QuickPDF... siehe unten
              3. In Basic und Delphi wird in IF Abfragen eine 0 als .f.
                 und <> 0 als .t. verarbeitet. Wenn eine Methode diesen
                 QuickPDF Rckgabewert nicht von numerisch auf logisch umsetzt,
                 muss man o:IsFalse(...) und o:IsTrue(...) verwenden.
                 Beispiel:   if o:IsTrue(o:QuickPDFFunction()) entspricht o:QuickPDFFunction()#0
                 Ich werde die logischen Rckgabewerte einbauen, aber
                 man ist auf der sicheren Seite wenn man die Methoden
                 :IsFalse(...) und :IsTrue(...) verwendet, dann stimmt es immer.
              4. Sollten Sie Fehler finden, bitte ich um Mitteilung und ein kleines Beispiel.
                 Ich bemhe mich diese schnell zu beseitigen.

   ***********************************************************************

    englisch / english

    needs             QuickPdf DLL    QuickPDFDLL07xx.dll  (7.18, 7.19, 7.21, ff.)
                  Licence key from    www.QuickPDF.com

                         OT4XB.DLL >= 001.005.012.021   from   www.xbwin.com

    HB_PrintPDF is freeware.

    Thanks to Pablo Botella Navaro and his OT4XB and the TQuickPdf wrapper class
    I used his methods to save time and changed the return values where
    we need arrays or logical return values.
    *HB* will mark the changed TQuickPdf Methods

    The lisence key is valid for versions 7.xx, so this class will be always
    changed to the newest version from 7.xx. You can use it with a older DLL
    as long as you don't use the new functions.
    I changed the HBPrintPDF mainversion to the needed QuickPDF mainversion.

    new version:  www.familie-brandel.de

   ------------------------------------------------------------
     TQuickPdf wrapper class over the QuickPDFDLL0719.dll
           -> http://www.quickpdflibrary.com
     Author: Pablo Botella Navarro ( http://www.xbwin.com ) -
           -> http://www.xbwin.com/forum.php?ng=/ot4xb.examples/36
   ------------------------------------------------------------

    IMPORTANT !  Please use the quickpdf reference guide (PDF) for info and help.
                 These things are different:
              1. Ignore the parameter InstanceID, the class will handle it inside.
              2. The method names are the same as those from ActiveX
                 No leading QuickPDF... just use the function name. See the code ...
              3. Basic and Delphi use numeric parameters instead of logical in Xbase
                 IF 0 is .f., and IF <> 0 is .t.
                 If the method in this class does not change the return value, you
                 have to use these methods:     o:IsFalse(...) or IF o:IsTrue(...)
                 Example:  if o:IsTrue(o:QuickPDFFunction()) is equal to o:QuickPDFFunction()#0
                 I will change the return values to logical, but
                 :IsFalse(...) and :IsTrue(...) will handle both, see the code below ...
              4. If you find errors, please let me know and I will correct them.

/* Beispiel / Example

   cQuickPDFKey := "............." or read from .CH

   // Standard DLL von TQuickPdf                // use the standard DLL from TQuickPdf
   oHBPrintPDF  := HBPrintPDF():new():create(cQuickPDFKey)
   if oHBPrintPDF:IsOK                          **** wichtig ! Important
      ...

   // oder eigene festlegen                     // or define your own DLL
   oHBPrintPDF  := HBPrintPDF():new()
   oHBPrintPDF:cDLLName := "QuickPDFDLL????.dll" // TESTED:  QuickPDFDLL0719.dll
   ...
   oHBPrintPDF:create(cQuickPDFKey)
   if oHBPrintPDF:IsOK                          **** wichtig ! Important
      oHBPrintPDF:DrawText(20,30, "Hello world with HBPrintPDF (QuickPDF)")
      // Speichern, SAVE ?
      oHBPrintPDF:SaveToFile(cPfad+cPDF)
      // Drucken, Printing ?
      oHBPrintPDF:PrintDocument(cPrinterName, 1, oHBPrintPDF:PageCount())
      // Variablen zurcksetzen, aber QuickPDF wird erst beim Programmende entladen.
      // Reset vars, but the QuickPDF will not give back the memory until EXE quits.
      oHBPrintPDF:destroy()
   endif

   Have fun :-)

   Hubert

*/

******** QuickPDF Lizenz Key / License Key ********* HOW TO *****
*
* entweder bei CREATE( cLizenzKey ) angeben, oder eine Funktion wie GetQuickPDFLizenzKey()
* nutzen um ihn zu ermitteln und zurckzugeben.
*
* first option CREATE( cLicenseKey ) or use a function like GetQuickPDFLizenzKey() to
* get a valid key. More infos about it in the Quick PDF Helpfile => UnlockKey(LicenseKey)
*
/*
oHBPrintPDF:create(GetQuickPDFLizenzKey())
...
function GetQuickPDFLizenzKey()
   local cKey := "...."
   // OR ...
   cKey := GetEnv("QUICKPDF_07_REGKEY")
return cKey
...
oHBPrintPDF:create(GetEnv("QUICKPDF_07_REGKEY"))



   Version 7.00 - 2012-07-31

        ************************************************
        *  HBPrintPDF - Version 7.00 ==> QuickPDF 7.x  *
        ************************************************

        *  ForceAnsi(), ReadString()
           Grundstzlich sollte die Bibliothek schon immer mit OEM und ANSI Einstellung (SET CHARSET) funktionieren.
           Durch einen Fehler war dies bisher bei SET CHARSET TO OEM und Umlauten bisher nicht der Fall.
           Dies wurde nun korrigiert: ForceAnsi(), ReadString()

           HBPrintPDF should support OEM and ANSI (SET CHARSET) programs, but with
           SET CHARSET TO OEM and chr(128) ff. (german umlauts etc.) this was not true.
           This error is now fixed, ForceAnsi(), ReadString() will handle both correct.

        *  Erleichterungen bei Farben - easier colors ==> Xbase++    GRA_CLR_*

           NEW: SetAnnotBorderColorXB                // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetFillColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetFormFieldBackgroundColorXB        // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetFormFieldBorderColorXB            // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetFormFieldColorXB                  // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetLineColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetOutlineColorXB                    // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetTableBorderColorXB                // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetTableCellBackgroundColorXB        // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetTableCellBorderColorXB            // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetTableCellTextColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetTextColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetTextHighlightColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetTextUnderlineColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
           NEW: SetXFAFormFieldBorderColorXB         // nXbColor = Xbase++ GRA_CLR_* numeric

        * etc.

           NEW: GetErrorText(nErrorCode)   // QuickPDF errortext
           NEW: nCharSet                   // ::nCharSet := set(_SET_CHARSET) // this PRG file is in Ansi codepage !
           NEW: Points2Unit()              // Points in aktuelle Einheit (::nDefaultMeasurementUnits) umrechnen
                                           // calculate from points to the current unit (::nDefaultMeasurementUnits)
           NEW: GetUnitText()              // Aktuelle Einheit (::nDefaultMeasurementUnits) ausgeben 0 = points, 1 = mm, 2 = inch
                                           // returns the text for the current unit (::nDefaultMeasurementUnits) 0 = points, 1 = mm, 2 = inch
           NEW: PathFormatPdf              // c:\myPath\myDoc.pfd ==> /c/myPath/myDoc.pfd

   Version 1.55  - 2012-01-29

           NEW:   UseAutoConvUTF8             // True erledigt ntige UTF-8 Convertierungen automatisch, wenn man das nicht mchte False setzen.
                                              // True will handle UTF-8 conversation where nessesary, False will not change a parameter
           NEW:   ForceUTF8( cXBaseString )   // OEM or ANSI is OK, UTF-8 => UseAutoConvUTF8 := False
           NEW:   ReadUTF8( cUFT8String )     // UTF-8 => OEM or ANSI is OK, for UTF-8 => UseAutoConvUTF8 := False

      * Funktionen die UNICODE Strings bentigen bzw. umrechnen * these functions use real UNICODE strings, take care of the format

          WARNING:   ToPDFUnicode( cUnicodeString ) ===> This function is deprecated from version 7.17.

      * Parameter oder Rckgabe in UTF-8 codiert                * these functions use UTF-8 strings, the will be handled automaticaly.
        wenn man keine Umlaute nutzt, merkt man keine Fehler.     If you not use special chars, you will not see a difference
        Alle Methoden wurden angepat.                            All these methods have been changed to handle it.

                  AddEmbeddedFile
                  AddFormFieldSub
                  AddGlobalJavaScript
                  AddImageFromFile
                  AddImageFromFileOffset
                  AddLinkToFile
                  AddLinkToJavaScript
                  AddLinkToLocalFile
                  AddPageLabels
                  AddSVGAnnotationFromFile
                  AddToFileList
                  AddTrueTypeFontFromFile
                  AddType1Font
                  AddU3DAnnotationFromFile
                  AnalyseFile
                  DAEmbedFileStreams
                  DAExtractPageText             // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  DAGetFormFieldTitle           // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  DAGetFormFieldValue           // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  DAGetInformation              // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  DAOpenFile
                  DAOpenFileReadOnly
                  DARenderPageToFile
                  DASaveAsFile
                  DASaveImageDataToFile
                  DASetInformation
                  DecryptFile
                  DocJavaScriptAction
                  EmbedFile
                  EncryptFile
                  ExtractFilePageContent
                  ExtractFilePageText           // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  ExtractFilePages
                  FileListItem                  // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  FindFormFieldByTitle
                  FormFieldJavaScriptAction
                  GetAnalysisInfo               // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetAnnotStrProperty           // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetCatalogInformation         // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetCustomInformation          // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetDocJavaScript              // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetDocumentFileName           // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetEmbeddedFileContentToFile
                  GetEmbeddedFileStrProperty    // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetFileMetadata
                  GetFormFieldCaption           // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetFormFieldChildTitle        // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetFormFieldDefaultValue      // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetFormFieldDescription       // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetFormFieldJavaScript        // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetFormFieldTitle             // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetFormFieldValue             // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetFormFieldValueByTitle      // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetGlobalJavaScript           // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetImagePageCount
                  GetInformation                // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetOpenActionJavaScript       // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetOptionalContentGroupName   // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetOutlineJavaScript          // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetPageJavaScript             // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetPageLabel                  // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetPageText                   // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GetTempPath                   // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  GlobalJavaScriptPackageName   // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  ImportEMFFromFile
                  LoadFromFile
                  MergeFileList
                  MergeFileListFast
                  MergeFiles
                  NewChildFormField
                  NewFormField
                  NewOptionalContentGroup
                  NewOutline
                  NewStaticOutline
                  OutlineTitle                  // The result is encoded using UTF-8 in the Delphi and DLL editions of the library.
                  PageJavaScriptAction
                  PrintDocumentToFile
                  RenderDocumentToFile
                  RenderPageToFile
                  RetrieveCustomDataToFile
                  SaveFontToFile
                  SaveImageToFile
                  SaveToFile
                  SetAnnotStrProperty
                  SetCatalogInformation
                  SetCustomInformation
                  SetFormFieldCaption
                  SetFormFieldChildTitle
                  SetFormFieldDefaultValue
                  SetFormFieldDescription
                  SetFormFieldValue
                  SetFormFieldValueByTitle
                  SetGDIPlusFileName
                  SetInformation
                  SetOpenActionJavaScript
                  SetOutlineJavaScript
                  SetOutlineTitle
                  SetTempFile
                  SetTempPath
                  SignFile
                  StoreCustomDataFromFile


    Version 1.54  - 2011-08-15
            Support Quick PDF 7.26
                  color 0 - 255 => 0 - 1 (100%) => nR => 0 - 255, ... => nR/255
            NEW:  ::SetAnnotBorderColorRGB(nIndex,nR,nG,nB)
            NEW:  ::SetFillColorRGB(nR,nG,nB)
            NEW:  ::SetFormFieldBackgroundColorRGB(nIndex,nR,nG,nB)
            NEW:  ::SetFormFieldBorderColorRGB(nIndex,nR,nG,nB)
            NEW:  ::SetFormFieldColorRGB(nIndex,nR,nG,nB)
            NEW:  ::SetLineColorRGB(nR,nG,nB)
            NEW:  ::SetOutlineColorRGB(nID,nR,nG,nB)
            NEW:  ::SetTableBorderColorRGB(nTableID,nBorderIndex,nR,nG,nB)
            NEW:  ::SetTableCellBackgroundColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR,nG,nB)
            NEW:  ::SetTableCellBorderColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nR,nG,nB)
            NEW:  ::SetTableCellTextColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR,nG,nB)
            NEW:  ::SetTextColorRGB(nR,nG,nB)
            NEW:  ::SetTextHighlightColorRGB(nR,nG,nB)
            NEW:  ::SetTextUnderlineColorRGB(nR,nG,nB)
            NEW:  ::SetXFAFormFieldBorderColorRGB(cXFAFieldName,nR,nG,nB)
            NEW:  ::HB_RGB2double(@nR,@nG,@nB)  // PER REFERENZ !!!

            NO CHANGE ::SetPNGTransparencyColor(p1,p2,p3) RedBYTE as long ... => 0 to 255

    Version 1.53  - 2011-06-26
            Support Quick PDF 7.25

    Version 1.52  - 2011-05-02
            Support Quick PDF 7.24

    Version 1.51  - 2011-03-18
            Support Quick PDF 7.?? - flexible: QuickPDFDLL07??.dll - Probleme bei Verzeichniswechsel beseitigt.
                                                                     solved problem with different directories.

    Version 1.50  - 2011-03-08
            Support Quick PDF 7.23

    Version 1.40  - 2011-02-23
            NEW: ::SayOrigin0                      // NIL => .f. => 1,1 ; Standard Clipper + Xbase++ => 0,0 == ::SayOrigin0 := .t.
            NEW: ::SetSayRowsPerPage(nRowsPerPage) // direkt die Anzahl der Spalten festlegen, define directly the number of rows
                                                   // 80-82 => 10 CPI, 96-98 => 12 CPI, 136-140 => 17 CPI; ansonsten krumme Werte | else odd-numbered
            NEW: ::GetSayRowsPerPage()             // Anzahl der Spalten abfragen,             how many rows ?
            NEW: ::GetRowsPerInch()                // SetSayRowsPerPage( nRowsPerPage ) => SetTextCpi(GetRowsPerInch()) => correct font
            EXT: ::SayImage(nRowTop,nColLeft,nRowBottom,nColRight,nRotateLeft,nCPI,nLPI,lRatio ) // DEFAULT lRatio := .t.
                                                   // lRatio: .t. (Standard) proportional einpassen, .f. alles ausfllen
                                                   // lRatio: .t. (default)  change the size of the bitmap proportional or fill all
                                                   // Ich denke lRatio sollte .t. sein, aber wer es anders mche ...
                                                   // Es ist dafr gedacht eine Grafik relativ zu :say() zu drucken,
                                                   // wenn man aber an einer bestimmten Stelle eine Grafik mchte, sollte man
                                                   // I think lRatio should be .t., but if you want ...

    Version 1.30  - 2010-09-17
            Support Quick PDF 7.21 - flexible: QuickPDFDLL07??.dll
            NEW: SayImage(), AddImageFromXbpBMP()
            EXT: ::NewCustomPrinter(p1) + ::PrintDocument(p1,p2,p3,p4) + PrintDocumentToFile(p1,p2,p3,p4,p5)
                  ==> if emtpy(P1) ==> internal error ==> NEW: DEFAULT p1 TO ::GetDefaultPrinterName() // HB 1.30
            EXT: ::AddImageResource(nResourceID,nOptions,   nDLL   )  // NEW PARAMETER, Neuer Parameter   nDLL
            EXT: ::SetLineWidth() -> aktuelle Einstellung, ::SetLineWidth(x) -> alte Einstellung, wie bei Xbase++ blich
                 ::SetLineWidth() -> active value,         ::SetLineWidth(x) -> old value,      so normal Xbase++ ;-)

    Version 1.20  - 2010-06-15

            NEW: SayLine(), SayBox(), GetCPICharWidth(), GetTextUnderline()
                 ::SetFillColor() setzt Farbe in DrawBox(), DrawCircle(), etc. da DrawText() diese lscht.
                 ::SetFillColor() restores the color in DrawBox(), DrawCircle(), etc. because DrawText() deletes them.

    Version 1.10  - 2010-06-10

            NEW: SetSayLineFeed(), GetSayLineFeed(), SetSayLinesPerPage(), GetSayLinesPerPage()

    Version 1.01  - 2010-06-01

*/

CLASS HBPrintPDF

   PROTECTED

   VAR    nLineFeed             // method LineFeed(6) -> 6 * nLineFeed = Zeilenvorschub - line feed
                                // nLineFeed wird mit dem Standardabstand des aktuellen Font geladen !
                                //  "        will be set to the font hight of the standard font
                                // ->  ::SetTextSize()  ->  ::nLineFeed  in mm, points or inch
   VAR    nLineWidth, nDefaultLineWidth
   VAR    nLPI, nCPI
   VAR    nAlign                // speichert aktuelle Ausrichtung, save the current Alignment
   VAR    _hdll_                // DLL handle
   VAR    _id_                  // InstanceID
   VAR    nPageNo               // internal Pagenumber !
   VAR    aImageID              // Array zum Speichern von ImagesID und Name (z.B. Dateiname)
                                // array to save ImageID and name
   VAR    nAktiveFillColorRed, nAktiveFillColorGreen, nAktiveFillColorBlue
   VAR    nOldTextColorRed, nOldTextColorGreen, nOldTextColorBlue  // SetTextColor() -> save 1 Time !
   VAR    nOldTextUnderlineColorRed, nOldTextUnderlineColorGreen, nOldTextUnderlineColorBlue
   VAR    nOldTextHighlightColorRed, nOldTextHighlightColorGreen, nOldTextHighlightColorBlue

   VAR    nTextUnderline        // SetTextUnderline(nOption) nTextUnderline := nOption
   VAR    nCharSet              // ::nCharSet := set(_SET_CHARSET)

   EXPORTED

   VAR IsOK                     // *** Nach Create testen  // TEST after Create !!!

   VAR cErrorLanguage, cErrorNoInstance, cErrorLoadDll, cErrorNoLicenseOK, cErrorNoLicenseKey, cErrorNotMinVerOT4XB
   VAR SayOrigin0

   VAR cQuickPdfDllName
   VAR nDefaultPageSize
   VAR nDefaultMeasurementUnits
   VAR nPageDefaultOrigin
   VAR cDLLName
   VAR nDefaultStandardFontSize
   VAR nDefaultStandardFont     // -> AddStandardFont()
   VAR nDefaultStandardFontID
   VAR nDefaultBoldFont
   VAR nDefaultBoldFontID
   VAR nDefaultItalicFont
   VAR nDefaultItalicFontID
   VAR nDefaultItalicBoldFont
   VAR nDefaultItalicBoldFontID

   // use for :SAY(...)
   VAR nDefaultLPI, nDefaultCPI, nFirstLine,nLastLine,nFirstRow,nLastRow
   VAR cDefaultYes, cDefaultNo, cDefaultNumFormat

   INLINE METHOD ForceAnsi( cString ) // The DLL needs ANSI Parameters, if not UTF8 !
          DEFAULT cString TO ""
          if ::UseAutoConvUTF8  // string parameter == ANSI/OEM
             if ::nCharSet = 1    // OEM => ANSI
                cString := ConvToAnsiCP(cString)
             endif              // OK ANSI
          else
             // wenn ! ::UseAutoConvUTF8, muss man selbst UTF8 liefern, z.b. mit ::forceUTF8() beim Aufruf.
             // string parameter HAS TO BE UTF8, force it !
          endif
          Return cString

   INLINE METHOD ReadString( cString ) // The DLL needs ANSI Parameters, if not UTF8 !
          DEFAULT cString TO ""
          if ::UseAutoConvUTF8  // string parameter == ANSI/OEM
             if ::nCharSet = 1    // ANSI => OEM
                cString := ConvToOemCP(cString)
             endif              // OK OEM
          else
             // wenn ! ::UseAutoConvUTF8, erhlt man UTF8, verwenden mit z.b. ReadUTF8()
             // return value is UTF8, use it !
          endif
          Return cString

   INLINE METHOD PathFormatPdf(cFile)                      // c:\myPath\myDoc.pfd ==> /c/myPath/myDoc.pfd
          DEFAULT cFile TO ""
          if substr(cFile,2,1)==":"                        //  ^
             cFile := "/"+left(cFile,1)+substr(cFile,3)    // /c\myPath\myDoc.pfd ==> /c/myPath/myDoc.pfd
          endif
          cFile := lower(strTran(cFile,"\","/"))
          Return cFile

   // Version 1.55  - 2012-01-29 ...
   VAR UseAutoConvUTF8          // default True, but if you convert yourself to UTF-8, than set False
                                // Standard = True, aber wenn man die betreffenden String schon convertiert hat, dann braucht man False

   METHOD ForceUTF8( cXbaseString ) // OEM or ANSI is OK, UTF-8 => UseAutoConvUTF8 := False
   METHOD ReadUTF8( cUTF8 )         // UTF-8 => OEM or ANSI is OK, for UTF-8 => UseAutoConvUTF8 := False

   // ---

   METHOD INIT
   METHOD CREATE
   METHOD DESTROY
   METHOD IsTrue, IsFalse       // 0 / #0  ->  .f. / .t.

   INLINE METHOD Points2Unit(nPoints)
          do case
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
                  return nPoints / 72 * 25.4
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
                  return nPoints / 72
          end
          return nPoints

   INLINE METHOD GetUnitText(lShowShort)
          DEFAULT lShowShort TO .t.
          do case
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
                  return "mm"
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
                  return "inch"
          end
          return iif(lShowShort,"pt","points")

   METHOD GetTextUnderline      // return ::nTextUnderline
   METHOD GetPageSizeX          // -> QuickPDFPageWidth,   PageWidth
   METHOD GetPageSizeY          // -> QuickPDFPageHeight,  PageHeight
   METHOD GetPrinterBinA        // :GetPrinterBins()  -> String -> Array
   METHOD GetPrinterNameA       // :GetPrinterNames() -> CSV String -> Array
   METHOD GetTextAlign          // aktuelle Einstellung abfragen, Rckgabewert ist numerisch und entspricht letzter SetTextAlign(nWert) Festlegung
                                // get the current value, this is the same as the last numeric setting from SetTextAlign(nValue)
   METHOD GetColorRGB           // Xbase++ color -> {r,g,b} || nRGB -> 1=red, 2=green, 3 = blue

   // Bilder einfacher handhaben / help with images
   METHOD AddImageID            // AddImageID(nImageID,cName)       -> aadd(aImageID,{nImageID,cName}) -> OK ? .f. = Name exists, 1 ID n Names is OK.
   METHOD RemoveImageID         // RemoveImageID(nImageID)          -> aRemove(aImageID,... )          -> OK ? .f. = Parameter error
   METHOD GetImageIDByName      // GetImageIDByName(cName)          -> nImageID
   METHOD SelectImageByName     // SelectImageByName(cName) -(nImageID)-> SelectImage(nImageID) -> OK ?
   METHOD AddImageFile          // AddImageFile(cFileName,O) | AddImageFromFile(...) -(nImageID)-> AddImageID(...) -> nImageID
   METHOD DrawImageFile         // -> AddImageFile(cFileName,O) | AddImageFromFile(...) -(nImageID)-> AddImageID(...) -> FitImage...
   METHOD AddImageResource      // AddImageResource(nResourceID,O) | AddImageFromString(...) -(nImageID)-> AddImageID(...) -> nImageID
   METHOD DrawImageResource     // -> AddImageResource(nResourceID,O) -> String  | AddImageFromString(...) -(nImageID)-> AddImageID(...) -> FitImage...
   METHOD AddImageFromXbpBMP(cSetBufferString) // dem Rckgabewert bei BMPs fehlen die 14 Bytes des DateiHeader. NUR FR BMP !!!
   // needed for @...say migration
   METHOD SAY(nRow,nCol,xData,cAlign,nCPI,nLPI) // min == 1,1
   Method SayLine(nRow1,nCol1,nRow2,nCol2,cAlign1,cAlign2,nOffset,nCPI,nLPI) // Basisausrichtung der Linien/basic alignment: cAlign // nOffset +/- n
   Method SayBox(nRowTop,nColLeft,nRowBottom,nColRight,nOffset,nDrawOptions,nCPI,nLPI)
   Method SayImage(nRowTop,nColLeft,nRowBottom,nColRight,nRotateLeft,nCPI,nLPI,lRatio)   // Image in Grenzen von SayBox einpassen.

   METHOD SetLPI, GetLPI        // -> ::nLPI    *** will NOT change the FONT SIZE  !  // To CHANGE the fontsize use  ::SetTextCpi(n)
   METHOD SetCPI, GetCPI        // -> ::nCPI    *** Font Gre wird NICHT gendert !  // Zum ndern der Textgre -> ::SetTextCpi(n)
                                // beides ist NUR fr die Berechnung der SAY Position
                                // both will only be used to calculate the SAY position
                                // =>  SetTextCpi(n), GetTextCpi()

   METHOD SetSayLineFeed,GetSayLineFeed         // Zeilenhhe direkt angeben, berechnet -> ::nLPI / calculate ::nLPI from the parameter
   METHOD SetSayLinesPerPage,GetSayLinesPerPage // Zeilen je Seite direkt angeben, berechnet -> ::nLPI / lines per page calculate ::nLPI
   METHOD SetSayRowsPerPage,GetSayRowsPerPage   // Spalten je Seite direkt angeben, berechnet -> ::nCPI / rows per page calculate ::nCPI
   METHOD GetRowsPerInch                        // SetSayRowsPerPage( nRowsPerPage ) => SetTextCpi(GetRowsPerInch()) => correct font

   METHOD GetCPICharWidth(nCPI) // Breite eines Zeichens mit nCPI
   METHOD nRowToPosY(), nColToPosX()  // @say(nRow,nPos) -> x,y

   METHOD GetErrorText



   // HBPrinter() Methods

*   METHOD PrintMemo( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, xColor, cHochQuer, nMaxBis,nLineFeed )
   VAR PrintTextAlltrim
   METHOD PrintText( nPosX, nPosY, xData, cAusrichtung, nMaxLen, cArt, xColor, nDrehen )
   METHOD PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit  ) // -> lSuccess
   METHOD PrintCheckBox( nLeft, nTop, nSize, cType )  // nSize auen/outline , cType="B" eckig/Box, "R" .or. "C" rund/circle
   METHOD LineFeed()            // Neue Y Position ermitteln / calculate new Y value
   VAR    DrawTextBoxNextTop    // nTop + ::nLineFeed( ::DrawTextBox(nLeft, nTop, ... -> next nTop
   METHOD nBaselineToTop()      // nPosY - ::GetTextBound(GETTEXTBOUND_TOP)
   METHOD nTopToBaseline()      // nTop  + ::GetTextBound(GETTEXTBOUND_TOP)
   METHOD CalcCheckDigit(uEAN13_Nr) // EAN13 -> 12 + checkDigit -> 13
   METHOD getPageNo()           // ::getPageNo() -> ::nPageNo (integer) / ::getPageNo("C") -> alltrim(str(::nPageNo))
   METHOD PrintPageNo()         // PrintText(x,y,"- "+::getPageNo("C")+" -"

   // from Pablo per eMail // does not need XbpBitmap
   INLINE METHOD cLoadResource( hMod , res_id , res_type , lang_id , lAddBmfh)
          local hrs,hgr,cb,p,cc,cch
          if Valtype( res_id  ) == "N"
             res_id := MAKEINTRESOURCE(res_id)
          elseif Valtype( res_id  ) != "C" ; return NIL ; end
          DEFAULT res_type := 2     // BITMAP
          DEFAULT lang_id  := MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL )
          DEFAULT hMod := AppInstance()
          hrs := @kernel32:FindResourceExA(hMod,res_type , res_id , lang_id )
          if Empty(hrs) ; return NIL ; end
          hgr := @kernel32:LoadResource(hMod,hrs)
          if Empty(hgr) ; return NIL ; end
          p  := @kernel32:LockResource(hgr)
          if Empty(p) ; return NIL ; end
          cb := @kernel32:SizeofResource( hMod, hrs )
          cc := PeekStr(p,0,cb)
          if ! Empty(lAddBmFh)
             cch := ::cBmpGenFileHeader( p , cb )
             if cch == NIL ; return cch ; end // error
             return cch + cc
          end
          return cc
   INLINE METHOD cBmpGenFileHeader( p , cb ) // p can be a string or a memory pointer
          local cbh,nbbc,nPalSize,nn
          if cb < 16 ; return NIL ; end  // invalid bitmap
          cbh := PeekDWord(p)
          if cbh == 12    ; nn := 3  // OS2 bitmaps BITMAPCOREINFO  using RGBTRIPLE color table
          elseif cbh < 40 ; return NIL  // invalid BITMAPINFO
          else           ; nn := 4 // BITMAPINFO using RGBQUAD color table
          end
          nbbc := PeekWord(p,0x0E)
          nPalSize := 0
          if     nbbc ==  1 ; nPalSize :=   2 * nn
          elseif nbbc ==  4 ; nPalSize :=  16 * nn
          elseif nbbc ==  8 ; nPalSize := 256 * nn
          elseif nbbc == 16 ; nPalSize := 0
          elseif nbbc == 24 ; nPalSize := 0
          elseif nbbc == 32 ; nPalSize := 0
          else              ; return NIL  // invalid bbc entry
          end
          return __i16(0x4D42) + __i32( 14 + cb ,  0 , 14 + cbh + nPalSize )

************************************************
*  HBPrintPDF - Version 7.00 ==> QuickPDF 7.x  *
************************************************

*  Erleichterungen bei Farben - easier colors ==> Xbase++    GRA_CLR_*

   METHOD SetAnnotBorderColorXB                // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFillColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldBackgroundColorXB        // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldBorderColorXB            // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldColorXB                  // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetLineColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetOutlineColorXB                    // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableBorderColorXB                // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellBackgroundColorXB        // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellBorderColorXB            // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellTextColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextHighlightColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextUnderlineColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetXFAFormFieldBorderColorXB         // nXbColor = Xbase++ GRA_CLR_* numeric

**********************************************************************************************************************
// neu in 7.26 - PowerBasic INC    7.26
**********************************************************************************************************************

   METHOD CreateNewObject
   METHOD GetBaseURL
   METHOD GetOptionalContentGroupPrintable
   METHOD GetOptionalContentGroupVisible

**********************************************************************************************************************
*  Erleichterungen bei Farben - use easy color values 0-255 0x00-0xFF
**********************************************************************************************************************

   METHOD HB_RGB2double
   METHOD SetAnnotBorderColorRGB
   METHOD SetFillColorRGB
   METHOD SetFormFieldBackgroundColorRGB
   METHOD SetFormFieldBorderColorRGB
   METHOD SetFormFieldColorRGB
   METHOD SetLineColorRGB
   METHOD SetOutlineColorRGB
   METHOD SetTableBorderColorRGB
   METHOD SetTableCellBackgroundColorRGB
   METHOD SetTableCellBorderColorRGB
   METHOD SetTableCellTextColorRGB
   METHOD SetTextColorRGB
   METHOD SetTextHighlightColorRGB
   METHOD SetTextUnderlineColorRGB
   METHOD SetXFAFormFieldBorderColorRGB

**********************************************************************************************************************
// neu in 7.25 - PowerBasic INC    7.25
**********************************************************************************************************************

   METHOD DARemoveUsageRights
   METHOD DrawImageMatrix
   METHOD GetEmbeddedFileID
   METHOD NormalizePage
   METHOD RemoveUsageRights
   METHOD SetFormFieldSubmitAction
   METHOD SetMarkupAnnotStyle
   METHOD SetObjectSource
   METHOD SetRenderDCErasePage

**********************************************************************************************************************
// neu in 7.24 - PowerBasic INC    7.24
**********************************************************************************************************************
   METHOD DAEmbedFileStreams
   METHOD GetFormFieldNoExport
   METHOD GetFormFieldRequired
   METHOD RemoveCustomInformation
   METHOD SetAnnotBorderStyle
   METHOD SetFormFieldChoiceType
   METHOD SetFormFieldNoExport
   METHOD SetFormFieldRequired

**********************************************************************************************************************
// neu in 7.23 - PowerBasic INC    7.23
**********************************************************************************************************************
   METHOD DADrawRotatedCapturedPage
   METHOD DAGetPageBox
   METHOD DAHasPageBox
   METHOD NewPageFromCanvasDC
   METHOD NoEmbedFontListAdd
   METHOD NoEmbedFontListCount
   METHOD NoEmbedFontListGet
   METHOD NoEmbedFontListRemoveAll
   METHOD NoEmbedFontListRemoveIndex
   METHOD NoEmbedFontListRemoveName
   METHOD SaveImageToString

**********************************************************************************************************************
// neu in 7.22 - PowerBasic INC    7.22
**********************************************************************************************************************
   METHOD AddLinkToDestination
   METHOD CompareOutlines
   METHOD DASetPageBox
   METHOD GetDestName
   METHOD GetFontEncoding
   METHOD GetOutlineObjectNumber
   METHOD GetRenderScale
   METHOD NewDestination
   METHOD NewNamedDestination                 // needs 7.26 ...
   METHOD SetFindImagesMode
   METHOD SetImageResolution
   METHOD SetOutlineNamedDestination
   METHOD SetOutlineRemoteDestination
   METHOD SetOverprint
   METHOD SetRenderDCOffset
   METHOD SetRenderScale

**********************************************************************************************************************
// neu in 7.21 - PowerBasic INC    7.21
**********************************************************************************************************************
   METHOD AddTextMarkupAnnotation
   METHOD ClearImage
   METHOD DAGetAnnotationCount
   METHOD GetActionDest
   METHOD GetActionURL
   METHOD GetAnnotDest
   METHOD GetAnnotQuadCount
   METHOD GetAnnotQuadPoints
   METHOD GetDocumentFileSize
   METHOD GetFormFieldActionID
   METHOD GetInstalledFontsByCharset
   METHOD GetInstalledFontsByCodePage
   METHOD GetMaxObjectNumber
   METHOD GetOptionalContentConfigCount
   METHOD GetOptionalContentConfigOrderCount
   METHOD GetOptionalContentConfigOrderItemID
   METHOD GetOptionalContentConfigOrderItemLabel
   METHOD GetOptionalContentConfigOrderItemLevel
   METHOD GetOptionalContentConfigOrderItemType
   METHOD GetOptionalContentConfigState
   METHOD RemoveXFAEntries
   METHOD SetActionURL
   METHOD SetAnnotQuadPoints
   METHOD SetTextExtractionWordGap

**********************************************************************************************************************
// from TQuickPdf wrapper class    7.19
**********************************************************************************************************************
   METHOD AddLinkToLocalFile(nLeft, nTop, nWidth, nHeight, FileName, nOptions)
   METHOD GetImagePageCountFromString(p1)
   METHOD RemoveEmbeddedFile(p1)
   METHOD RemoveGlobalJavaScript(p1)
   METHOD RequestPrinterStatus(p1)
   METHOD SetAnnotBorderColor(p1,p2,p3,p4)
   METHOD SetCompatibility(p1,p2)
   METHOD SetEmbeddedFileStrProperty(p1,p2,p3)
**********************************************************************************************************************
// from TQuickPdf wrapper class    7.18
**********************************************************************************************************************
   INLINE METHOD _b(cc,ptb,n)
          local cb,p
          if !(Valtype(cc) $ "CM") ; return cc ; end
          cb := Len(cc) ; if cb == 0; return cc ; end
          p  := ::CreateBuffer(cb)
          ::AddToBuffer(p,cc,cb)
          PokeDWord(ptb,n*4,p)
          return p

   INLINE METHOD _ptb_free_( result , ptb )
          AEval( PeekDWord(ptb,4,PeekDWord(ptb)) , {|p| _xfree(p) } )
          _xfree(ptb)
          return result

   INLINE METHOD _str_result_(p)
       local cb
       if Empty(p) ; return "" ; end
       cb := ::StringResultLength()
       return PeekStr(p,0,cb)

   INLINE METHOD SetTextCpi(n) ; return ::SetTextSize( 120 / n ) // tatschliche Font Gre, unabhngig von ::nCPI
   INLINE METHOD GetTextCpi()  ; return (::GetTextSize() / 120)  // depend on the real font size, but not from ::nCPI

   METHOD ReleaseLibrary

   METHOD AddArcToPath(p1,p2,p3)
   METHOD AddCJKFont(p1)
   METHOD AddCurveToPath(p1,p2,p3,p4,p5,p6)
   METHOD AddEmbeddedFile(FileName,MIMEType)
   METHOD AddFileAttachment(p1,p2)
   METHOD AddFormFieldSub(nI,SubName)
   METHOD AddFormFont(p1)
   METHOD AddGlobalJavaScript(PackageName,JavaScript)
   METHOD AddImageFromFile(FileName,nOptions)
   METHOD AddImageFromFileOffset(FileName,nOffset,nDataLength,nOptions)
   METHOD AddImageFromString(p1,p2)
   METHOD AddLGIDictToPage(p1)
   METHOD AddLineToPath(p1,p2)
   METHOD AddLinkToEmbeddedFile(p1,p2,p3,p4,p5,p6,p7)
   METHOD AddLinkToFile(nLeft, nTop, nWidth, nHeight, FileName, nPage, nPosition, nNewWindow, nOptions)
   METHOD AddLinkToJavaScript(nLeft, nTop, nWidth, nHeight, JavaScript, nOptions)
   METHOD AddLinkToPage(p1,p2,p3,p4,p5,p6,p7)
   METHOD AddLinkToWeb(p1,p2,p3,p4,p5,p6)
   METHOD AddNoteAnnotation(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13)
   METHOD AddPageLabels(nStart, nStyle, nOffset, Prefix)
   METHOD AddSeparationColor(p1,p2,p3,p4,p5,p6)
   METHOD AddStandardFont(p1)
   METHOD AddSubsettedFont(p1,p2,p3)
   METHOD AddSVGAnnotationFromFile(nLeft, nTop, nWidth, nHeight, FileName, nOptions)
   METHOD AddToBuffer(p1,p2,p3)
   METHOD AddToFileList(cListName,FileName)
   METHOD AddTrueTypeFont(p1,p2)
   METHOD AddTrueTypeFontFromFile(FileName)
   METHOD AddType1Font(FileName)
   METHOD AddU3DAnnotationFromFile(nLeft, nTop, nWidth, nHeight, FileName, nOptions)
   METHOD AnalyseFile(FileName, cPassword)
   METHOD AnnotationCount()
   METHOD AppendSpace(p1)
   METHOD AppendTableColumns(p1,p2)
   METHOD AppendTableRows(p1,p2)
   METHOD AppendText(p1)
   METHOD ApplyStyle(p1)
   METHOD AttachAnnotToForm(p1)
   METHOD BeginPageUpdate()
   METHOD CapturePage(p1)
   METHOD CapturePageEx(p1,p2)
   METHOD CharWidth(p1)
   METHOD CheckObjects()
   METHOD CheckPageAnnots()
   METHOD ClearFileList(p1)
   METHOD ClearPageLabels()
   METHOD ClearTextFormatting()
   METHOD CloneOutlineAction(p1)
   METHOD ClonePages(p1,p2,p3)
   METHOD CloseOutline(p1)
   METHOD ClosePath()
   METHOD CombineLayers()
   METHOD CompressContent()
   METHOD CompressFonts(p1)
   METHOD CompressImages(p1)
   METHOD CompressPage()
   METHOD CopyPageRanges(p1,p2)
   METHOD CreateBuffer(p1)
   METHOD CreateTable(p1,p2)
   METHOD DAAppendFile(p1)
   METHOD DACapturePage(p1,p2)
   METHOD DACapturePageEx(p1,p2,p3)
   METHOD DACloseFile(p1)
   METHOD DADrawCapturedPage(p1,p2,p3,p4,p5,p6,p7)
   METHOD DAExtractPageText(p1,p2,p3)
   METHOD DAFindPage(p1,p2)
   METHOD DAGetFormFieldCount(p1)
   METHOD DAGetFormFieldTitle(p1,p2)
   METHOD DAGetFormFieldValue(p1,p2)
   METHOD DAGetImageDataToString(p1,p2,p3)
   METHOD DAGetImageDblProperty(p1,p2,p3,p4)
   METHOD DAGetImageIntProperty(p1,p2,p3,p4)
   METHOD DAGetImageListCount(p1,p2)
   METHOD DAGetInformation(p1,p2)
   METHOD DAGetObjectCount(p1)
   METHOD DAGetObjectSource(p1,p2)
   METHOD DAGetPageContent(p1,p2)
   METHOD DAGetPageCount(p1)
   METHOD DAGetPageHeight(p1,p2)
   METHOD DAGetPageImageList(p1,p2)
   METHOD DAGetPageWidth(p1,p2)
   METHOD DAHidePage(p1,p2)
   METHOD DAMovePage(p1,p2,p3,p4)
   METHOD DANewPage(p1)
   METHOD DANewPages(p1,p2)
   METHOD DAOpenFile(FileName, cPassword)
   METHOD DAOpenFileReadOnly(FileName, cPassword)
   METHOD DAPageRotation(p1,p2)
   METHOD DARenderPageToDC(p1,p2,p3,p4)
   METHOD DARenderPageToFile(nFileHandle, nPageRef, nOptions, nDPI, FileName)
   METHOD DARenderPageToString(p1,p2,p3,p4)
   METHOD DARotatePage(p1,p2,p3,p4)
   METHOD DASaveAsFile(nFileHandle, FileName)
   METHOD DASaveImageDataToFile(nFileHandle, nImageListID, nImageIndex, FileName)
   METHOD DASetInformation(nFileHandle, cKey, NewValue)
   METHOD DASetPageSize(p1,p2,p3,p4)
   METHOD Decrypt()
   METHOD DecryptFile(InputFileName, OutputFileName, cPassword)
   METHOD DeleteAnalysis(p1)
   METHOD DeleteAnnotation(p1)
   METHOD DeleteFormField(p1)
   METHOD DeleteLayer()
   METHOD DeleteOptionalContentGroup(p1)
   METHOD DeletePageLGIDict(p1)
   METHOD DeletePages(p1,p2)
   METHOD DocJavaScriptAction(cActionType,JavaScript)
   METHOD DocumentCount()
   METHOD DrawArc(p1,p2,p3,p4,p5,p6,p7)
   METHOD DrawBarcode(p1,p2,p3,p4,p5,p6,p7)
   METHOD DrawBox(p1,p2,p3,p4,p5)
   METHOD DrawCapturedPage(p1,p2,p3,p4,p5)
   METHOD DrawCircle(p1,p2,p3,p4)
   METHOD DrawDataMatrixSymbol(p1,p2,p3,p4,p5,p6,p7)
   METHOD DrawEllipse(p1,p2,p3,p4,p5)
   METHOD DrawEllipticArc(p1,p2,p3,p4,p5,p6,p7,p8)
   METHOD DrawHTMLText(p1,p2,p3,p4)
   METHOD DrawHTMLTextBox(p1,p2,p3,p4,p5)
   METHOD DrawImage(p1,p2,p3,p4)
   METHOD DrawLine(p1,p2,p3,p4)
   METHOD DrawMultiLineText(p1,p2,p3,p4)
   METHOD DrawPath(p1)
   METHOD DrawPathEvenOdd(p1)
   METHOD DrawPostScriptXObject(p1)
   METHOD DrawRotatedCapturedPage(p1,p2,p3,p4,p5,p6)
   METHOD DrawRotatedImage(p1,p2,p3,p4,p5)
   METHOD DrawRotatedText(p1,p2,p3,p4)
   METHOD DrawRotatedTextBox(p1,p2,p3,p4,p5,p6,p7)
   METHOD DrawRoundedBox(p1,p2,p3,p4,p5,p6)
   METHOD DrawScaledImage(p1,p2,p3)
   METHOD DrawSpacedText(p1,p2,p3,p4)
   METHOD DrawTableRows(p1,p2,p3,p4,p5,p6)
   METHOD DrawText(p1,p2,p3)
   METHOD DrawTextArc(p1,p2,p3,p4,p5,p6)
   METHOD DrawTextBox(p1,p2,p3,p4,p5,p6)
   METHOD DrawWrappedText(p1,p2,p3,p4)
   METHOD EditableLayer()
   METHOD EmbeddedFileCount()
   METHOD EmbedFile(cTitle, FileName, cMIMEType)
   METHOD EncapsulateLayer()
   METHOD EncodePermissions(p1,p2,p3,p4,p5,p6,p7,p8)
   METHOD Encrypt(p1,p2,p3,p4)
   METHOD EncryptFile(InputFileName, OutputFileName, cOwner, cUser, nStrength, nPermissions)
   METHOD EncryptionAlgorithm()
   METHOD EncryptionStatus()
   METHOD EncryptionStrength()
   METHOD EncryptWithFingerprint(p1)
   METHOD EndPageUpdate()
   METHOD ExtractFilePageContent(FileName,cPassword,nPage)
   METHOD ExtractFilePages(InputFileName, OutputFileName, cRangeList)
   METHOD ExtractFilePageText( FileName, cPassword, nPage, nOptions)
   METHOD ExtractPageRanges(p1)
   METHOD ExtractPages(p1,p2)
   METHOD FileListCount(p1)
   METHOD FileListItem(p1,p2)
   METHOD FindFonts()
   METHOD FindFormFieldByTitle(Title)
   METHOD FindImages()
   METHOD FitImage(p1,p2,p3,p4,p5,p6,p7)
   METHOD FitRotatedTextBox(p1,p2,p3,p4,p5,p6,p7)
   METHOD FitTextBox(p1,p2,p3,p4,p5,p6)
   METHOD FlattenFormField(p1)
   METHOD FontCount()
   METHOD FontFamily()
   METHOD FontHasKerning()
   METHOD FontName()
   METHOD FontReference()
   METHOD FontSize()
   METHOD FontType()
   METHOD FormFieldCount()
   METHOD FormFieldHasParent(p1)
   METHOD FormFieldJavaScriptAction(nIndex, cActionType, JavaScript)
   METHOD FormFieldWebLinkAction(p1,p2,p3)
   METHOD GetActionType(p1)
   METHOD GetAnalysisInfo(p1,p2)
   METHOD GetAnnotActionID(p1)
   METHOD GetAnnotDblProperty(p1,p2)
   METHOD GetAnnotIntProperty(p1,p2)
   METHOD GetAnnotStrProperty(p1,p2)
   METHOD GetBarcodeWidth(p1,p2,p3)
   METHOD GetCanvasDC(p1,p2)
   METHOD GetCatalogInformation(p1)
   METHOD GetCustomInformation(p1)
   METHOD GetCustomKeys(p1)
   METHOD GetDefaultPrinterName()
   METHOD GetDestPage(p1)
   METHOD GetDestType(p1)
   METHOD GetDestValue(p1,p2)
   METHOD GetDocJavaScript(p1)
   METHOD GetDocumentFileName()
   METHOD GetDocumentID(p1)
   METHOD GetDocumentIdentifier(p1,p2)
   METHOD GetDocumentMetadata()
   METHOD GetDocumentResourceList()
   METHOD GetEmbeddedFileContentToFile(nIndex, FileName)
   METHOD GetEmbeddedFileContentToString(p1)
   METHOD GetEmbeddedFileIntProperty(p1,p2)
   METHOD GetEmbeddedFileStrProperty(p1,p2)
   METHOD GetEncryptionFingerprint()
   METHOD GetFileMetadata(FileName)
   METHOD GetFirstChildOutline(p1)
   METHOD GetFirstOutline()
   METHOD GetFontID(p1)
   METHOD GetFontObjectNumber()
   METHOD GetFormFieldAlignment(p1)
   METHOD GetFormFieldAnnotFlags(p1)
   METHOD GetFormFieldBackgroundColor(p1,p2)
   METHOD GetFormFieldBorderColor(p1,p2)
   METHOD GetFormFieldBorderProperty(p1,p2)
   METHOD GetFormFieldBorderStyle(p1)
   METHOD GetFormFieldBound(p1,p2)
   METHOD GetFormFieldCaption(p1)
   METHOD GetFormFieldChildTitle(p1)
   METHOD GetFormFieldChoiceType(p1)
   METHOD GetFormFieldColor(p1,p2)
   METHOD GetFormFieldComb(p1)
   METHOD GetFormFieldDefaultValue(p1)
   METHOD GetFormFieldDescription(p1)
   METHOD GetFormFieldFlags(p1)
   METHOD GetFormFieldFontName(p1)
   METHOD GetFormFieldJavaScript(p1,p2)
   METHOD GetFormFieldKidCount(p1)
   METHOD GetFormFieldMaxLen(p1)
   METHOD GetFormFieldPage(p1)
   METHOD GetFormFieldPrintable(p1)
   METHOD GetFormFieldReadOnly(p1)
   METHOD GetFormFieldRotation(p1)
   METHOD GetFormFieldSubCount(p1)
   METHOD GetFormFieldSubName(p1,p2)
   METHOD GetFormFieldSubTempIndex(p1,p2)
   METHOD GetFormFieldTabOrder(p1)
   METHOD GetFormFieldTextFlags(p1,p2)
   METHOD GetFormFieldTextSize(p1)
   METHOD GetFormFieldTitle(p1)
   METHOD GetFormFieldType(p1)
   METHOD GetFormFieldValue(p1)
   METHOD GetFormFieldValueByTitle(Title)
   METHOD GetFormFieldVisible(p1)
   METHOD GetFormFieldWebLink(p1,p2)
   METHOD GetFormFontCount()
   METHOD GetFormFontName(p1)
   METHOD GetGlobalJavaScript(PackageName)
   METHOD GetHTMLTextHeight(p1,p2)
   METHOD GetHTMLTextLineCount(p1,p2)
   METHOD GetHTMLTextWidth(p1,p2)
   METHOD GetImageID(p1)
   METHOD GetImagePageCount(FileName)
   METHOD GetInformation(p1)
   METHOD GetKerning(p1)
   METHOD GetNamedDestination(p1)
   METHOD GetNextOutline(p1)
   METHOD GetObjectCount()
   METHOD GetObjectSource(p1)
   METHOD GetOpenActionDestination()
   METHOD GetOpenActionJavaScript()
   METHOD GetOptionalContentGroupID(p1)
   METHOD GetOptionalContentGroupName(p1)
   METHOD GetOrigin()
   METHOD GetOutlineActionID(p1)
   METHOD GetOutlineColor(p1,p2)
   METHOD GetOutlineDest(p1)
   METHOD GetOutlineID(p1)
   METHOD GetOutlineJavaScript(p1)
   METHOD GetOutlineOpenFile(p1)
   METHOD GetOutlinePage(p1)
   METHOD GetOutlineStyle(p1)
   METHOD GetOutlineWebLink(p1)
   METHOD GetPageBox(p1,p2)
   METHOD GetPageContent()
   METHOD GetPageJavaScript(p1)
   METHOD GetPageLabel(p1)
   METHOD GetPageLayout()
   METHOD GetPageLGIDictContent(p1)
   METHOD GetPageLGIDictCount()
   METHOD GetPageMode()
   METHOD GetPageText(p1)
   METHOD GetParentOutline(p1)
   METHOD GetPrevOutline(p1)
   METHOD GetPrinterBins(p1)
   METHOD GetPrinterNames()                     // -> :GetPrinterNameA()
   METHOD GetSubsetString(p1)
   METHOD GetTableCellDblProperty(p1,p2,p3,p4)
   METHOD GetTableCellIntProperty(p1,p2,p3,p4)
   METHOD GetTableCellStrProperty(p1,p2,p3,p4)
   METHOD GetTableColumnCount(p1)
   METHOD GetTableLastDrawnRow(p1)
   METHOD GetTableRowCount(p1)
   METHOD GetTempPath()
   METHOD GetTextAscent()
   METHOD GetTextBound(p1)
   METHOD GetTextDescent()
   METHOD GetTextHeight()
   METHOD GetTextSize()
   METHOD GetTextWidth(p1)
   METHOD GetViewerPreferences(p1)
   METHOD GetWrappedText(p1,p2,p3)
   METHOD GetWrappedTextBreakString(p1,p2,p3)
   METHOD GetWrappedTextHeight(p1,p2)
   METHOD GetWrappedTextLineCount(p1,p2)
   METHOD GetXFAFormFieldCount()
   METHOD GetXFAFormFieldName(p1)
   METHOD GetXFAFormFieldNames(p1)
   METHOD GetXFAFormFieldValue(p1)
   METHOD GlobalJavaScriptCount()
   METHOD GlobalJavaScriptPackageName(p1)
   METHOD HasFontResources()
   METHOD HasPageBox(p1)
   METHOD HidePage()
   METHOD ImageCount()
   METHOD ImageFillColor()
   METHOD ImageHeight()
   METHOD ImageHorizontalResolution()
   METHOD ImageResolutionUnits()
   METHOD ImageType()
   METHOD ImageVerticalResolution()
   METHOD ImageWidth()
   METHOD ImportEMFFromFile(FileName, nFontOptions, nGeneralOptions)
   METHOD InsertPages(p1,p2)
   METHOD InsertTableColumns(p1,p2,p3)
   METHOD InsertTableRows(p1,p2,p3)
   METHOD IsAnnotFormField(p1)
   METHOD LastErrorCode()
   METHOD LastRenderError()
   METHOD LayerCount()
   METHOD LayerSafe()
   METHOD LibraryVersion()
   METHOD LicenseInfo()
   METHOD Linearized()
   METHOD LoadFromCanvasDC(p1,p2)
   METHOD LoadFromFile(FileName)
   METHOD LoadFromString(p1)
   METHOD LoadState()
   METHOD MergeDocument(p1)
   METHOD MergeFileList(cListName, FileName)
   METHOD MergeFileListFast(cListName, FileName)
   METHOD MergeFiles(FirstFileName, SecondFileName, OutputFileName)
   METHOD MergeTableCells(p1,p2,p3,p4,p5)
   METHOD MoveLayer(p1,p2)
   METHOD MoveOutlineAfter(p1,p2)
   METHOD MoveOutlineBefore(p1,p2)
   METHOD MovePage(p1)
   METHOD MovePath(p1,p2)
   METHOD MultiplyScale(p1)
   METHOD NewChildFormField(nIndex, Title, nFieldType)
   METHOD NewCustomPrinter(p1)
   METHOD NewDocument()
   METHOD NewFormField(Title, nFieldType)
   METHOD NewLayer()
   METHOD NewOptionalContentGroup(GroupName)
   METHOD NewOutline(nParent, Title, nDestPage, nDestPosition)
   METHOD NewPage()
   METHOD NewPages(p1)
   METHOD NewPostScriptXObject(p1)
   METHOD NewRGBAxialShader(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12)
   METHOD NewStaticOutline(nParent, Title)
   METHOD OpenOutline(p1)
   METHOD OptionalContentGroupCount()
   METHOD OutlineCount()
   METHOD OutlineTitle(p1)
   METHOD PageCount()
   METHOD PageHeight()
   METHOD PageJavaScriptAction(cActionType,JavaScript)
   METHOD PageRotation()
   METHOD PageWidth()
   METHOD PrintDocument(p1,p2,p3,p4)
   METHOD PrintDocumentToFile(cPrinterName, nStartPage, nEndPage, nOptions, FileName)
   METHOD PrintOptions(p1,p2,p3)
   METHOD ReleaseBuffer(p1)
   METHOD RemoveAppearanceStream(p1)
   METHOD RemoveDocument(p1)
   METHOD RemoveOutline(p1)
   METHOD RemoveSharedLayers()
   METHOD RemoveStyle(p1)
   METHOD RenderDocumentToFile(nDPI, nStartPage, nEndPage, nOptions, FileName)
   METHOD RenderPageToDC(p1,p2,p3)
   METHOD RenderPageToFile(nDPI, nPage, nOptions, FileName)
   METHOD RenderPageToString(p1,p2,p3)
   METHOD ReplaceFonts()
   METHOD ReplaceImage(p1,p2)
   METHOD ReplaceTag(p1,p2)
   METHOD RetrieveCustomDataToFile(cKey, FileName, nLocation)
   METHOD RetrieveCustomDataToString(p1,p2)
   METHOD ReverseImage(p1)
   METHOD RotatePage(p1)
   METHOD SaveFontToFile(FileName)
   METHOD SaveImageToFile(FileName)
   METHOD SaveState()
   METHOD SaveStyle(p1)
   METHOD SaveToFile(FileName)
   METHOD SaveToString()
   METHOD SecurityInfo(p1)
   METHOD SelectDocument(p1)
   METHOD SelectedDocument()
   METHOD SelectedFont()
   METHOD SelectedImage()
   METHOD SelectedPage()
   METHOD SelectFont(p1)
   METHOD SelectImage(p1)
   METHOD SelectLayer(p1)
   METHOD SelectPage(p1)
   METHOD SetAdvancePassword(p1)
   METHOD SetAnnotContents(p1,p2)
   METHOD SetAnnotStrProperty(nIndex, nTag, NewValue)
   METHOD SetBaseURL(p1)
   METHOD SetBlendMode(p1)
   METHOD SetBreakString(p1)
   METHOD SetCapturedPageOptional(p1,p2)
   METHOD SetCatalogInformation(cKey, NewValue)
   METHOD SetCharWidth(p1,p2)
   METHOD SetClippingPath()
   METHOD SetClippingPathEvenOdd()
   METHOD SetCropBox(p1,p2,p3,p4)
   METHOD SetCustomInformation(cKey, NewValue)
   METHOD SetCustomLineDash(p1,p2)
   METHOD SetDocumentMetadata(p1)
   METHOD SetFillColor(p1,p2,p3)
   METHOD SetFillColorCMYK(p1,p2,p3,p4)
   METHOD SetFillColorSep(p1,p2)
   METHOD SetFillShader(p1)
   METHOD SetFontEncoding(p1)
   METHOD SetFontFlags(p1,p2,p3,p4,p5,p6,p7,p8)
   METHOD SetFormFieldAlignment(p1,p2)
   METHOD SetFormFieldAnnotFlags(p1,p2)
   METHOD SetFormFieldBackgroundColor(p1,p2,p3,p4)
   METHOD SetFormFieldBackgroundColorCMYK(p1,p2,p3,p4,p5)
   METHOD SetFormFieldBackgroundColorSep(p1,p2,p3)
   METHOD SetFormFieldBorderColor(p1,p2,p3,p4)
   METHOD SetFormFieldBorderColorCMYK(p1,p2,p3,p4,p5)
   METHOD SetFormFieldBorderColorSep(p1,p2,p3)
   METHOD SetFormFieldBorderStyle(p1,p2,p3,p4,p5)
   METHOD SetFormFieldBounds(p1,p2,p3,p4,p5)
   METHOD SetFormFieldCalcOrder(p1,p2)
   METHOD SetFormFieldCaption(nIndex, NewCaption)
   METHOD SetFormFieldCheckStyle(p1,p2,p3)
   METHOD SetFormFieldChildTitle(nInteger, NewTitle)
   METHOD SetFormFieldColor(p1,p2,p3,p4)
   METHOD SetFormFieldColorCMYK(p1,p2,p3,p4,p5)
   METHOD SetFormFieldColorSep(p1,p2,p3)
   METHOD SetFormFieldComb(p1,p2)
   METHOD SetFormFieldDefaultValue(nIndex, NewDefaultValue)
   METHOD SetFormFieldDescription(nIndex, NewDescription)
   METHOD SetFormFieldFlags(p1,p2)
   METHOD SetFormFieldFont(p1,p2)
   METHOD SetFormFieldHighlightMode(p1,p2)
   METHOD SetFormFieldIcon(p1,p2,p3)
   METHOD SetFormFieldIconStyle(p1,p2,p3,p4,p5,p6)
   METHOD SetFormFieldMaxLen(p1,p2)
   METHOD SetFormFieldOptional(p1,p2)
   METHOD SetFormFieldPage(p1,p2)
   METHOD SetFormFieldPrintable(p1,p2)
   METHOD SetFormFieldReadOnly(p1,p2)
   METHOD SetFormFieldRotation(p1,p2)
   METHOD SetFormFieldStandardFont(p1,p2)
   METHOD SetFormFieldTabOrder(p1,p2)
   METHOD SetFormFieldTextFlags(p1,p2,p3,p4,p5,p6)
   METHOD SetFormFieldTextSize(p1,p2)
   METHOD SetFormFieldValue(nIndex, NewValue)
   METHOD SetFormFieldValueByTitle(Title, NewValue)
   METHOD SetFormFieldVisible(p1,p2)
   METHOD SetGDIPlusFileName(DLLFileName)
   METHOD SetGDIPlusOptions(p1,p2)
   METHOD SetHTMLBoldFont(p1,p2)
   METHOD SetHTMLBoldItalicFont(p1,p2)
   METHOD SetHTMLItalicFont(p1,p2)
   METHOD SetHTMLNormalFont(p1,p2)
   METHOD SetImageAsMask(p1)
   METHOD SetImageMask(p1,p2,p3,p4,p5,p6)
   METHOD SetImageMaskCMYK(p1,p2,p3,p4,p5,p6,p7,p8)
   METHOD SetImageMaskFromImage(p1)
   METHOD SetImageOptional(p1)
   METHOD SetInformation(nKey, NewValue)
   METHOD SetJavaScriptMode(p1)
   METHOD SetJPEGQuality(p1)
   METHOD SetKerning(p1,p2)
   METHOD SetLayerOptional(p1)
   METHOD SetLineCap(p1)
   METHOD SetLineColor(p1,p2,p3)
   METHOD SetLineColorCMYK(p1,p2,p3,p4)
   METHOD SetLineColorSep(p1,p2)
   METHOD SetLineDash(p1,p2)
   METHOD SetLineJoin(p1)
   METHOD SetLineShader(p1)
   METHOD SetLineWidth(p1)
   METHOD SetMeasurementUnits(p1)
   METHOD SetNeedAppearances(p1)
   METHOD SetOpenActionDestination(p1,p2)
   METHOD SetOpenActionDestinationFull(p1,p2,p3,p4,p5,p6,p7)
   METHOD SetOpenActionJavaScript(JavaScript)
   METHOD SetOpenActionMenu(p1)
   METHOD SetOptionalContentGroupPrintable(p1,p2)
   METHOD SetOptionalContentGroupVisible(p1,p2)
   METHOD SetOrigin(p1)
   METHOD SetOutlineColor(p1,p2,p3,p4)
   METHOD SetOutlineDestination(p1,p2,p3)
   METHOD SetOutlineDestinationFull(p1,p2,p3,p4,p5,p6,p7,p8)
   METHOD SetOutlineDestinationZoom(p1,p2,p3,p4)
   METHOD SetOutlineJavaScript(nOutlineID, JavaScript)
   METHOD SetOutlineOpenFile(p1,p2)
   METHOD SetOutlineStyle(p1,p2,p3)
   METHOD SetOutlineTitle(nOutlineID, NewTitle)
   METHOD SetOutlineWebLink(p1,p2)
   METHOD SetPageActionMenu(p1)
   METHOD SetPageBox(p1,p2,p3,p4,p5)
   METHOD SetPageContent(p1)
   METHOD SetPageDimensions(p1,p2)
   METHOD SetPageLayout(p1)
   METHOD SetPageMode(p1)
   METHOD SetPageSize(p1)
   METHOD SetPageThumbnail()
   METHOD SetPageTransparencyGroup(p1,p2,p3)
   METHOD SetPassword(p1)
   METHOD SetPNGTransparencyColor(p1,p2,p3)
   METHOD SetPrecision(p1)
   METHOD SetScale(p1)
   METHOD SetTableBorderColor(p1,p2,p3,p4,p5)
   METHOD SetTableBorderColorCMYK(p1,p2,p3,p4,p5,p6)
   METHOD SetTableBorderWidth(p1,p2,p3)
   METHOD SetTableCellAlignment(p1,p2,p3,p4,p5,p6)
   METHOD SetTableCellBackgroundColor(p1,p2,p3,p4,p5,p6,p7,p8)
   METHOD SetTableCellBackgroundColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9)
   METHOD SetTableCellBorderColor(p1,p2,p3,p4,p5,p6,p7,p8,p9)
   METHOD SetTableCellBorderColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
   METHOD SetTableCellBorderWidth(p1,p2,p3,p4,p5,p6,p7)
   METHOD SetTableCellContent(p1,p2,p3,p4)
   METHOD SetTableCellPadding(p1,p2,p3,p4,p5,p6,p7)
   METHOD SetTableCellTextColor(p1,p2,p3,p4,p5,p6,p7,p8)
   METHOD SetTableCellTextColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9)
   METHOD SetTableCellTextSize(p1,p2,p3,p4,p5,p6)
   METHOD SetTableColumnWidth(p1,p2,p3,p4)
   METHOD SetTableRowHeight(p1,p2,p3,p4)
   METHOD SetTempFile(FileName)
   METHOD SetTempPath(NewPath)
   METHOD SetTextAlign(p1)
   METHOD SetTextCharSpacing(p1)
   METHOD SetTextColor(p1,p2,p3)
   METHOD SetTextColorCMYK(p1,p2,p3,p4)
   METHOD SetTextColorSep(p1,p2)
   METHOD SetTextHighlight(p1)
   METHOD SetTextHighlightColor(p1,p2,p3)
   METHOD SetTextHighlightColorCMYK(p1,p2,p3,p4)
   METHOD SetTextHighlightColorSep(p1,p2)
   METHOD SetTextMode(p1)
   METHOD SetTextRise(p1)
   METHOD SetTextScaling(p1)
   METHOD SetTextShader(p1)
   METHOD SetTextSize(p1)
   METHOD SetTextSpacing(p1)
   METHOD SetTextUnderline(p1)
   METHOD SetTextUnderlineColor(p1,p2,p3)
   METHOD SetTextUnderlineColorCMYK(p1,p2,p3,p4)
   METHOD SetTextUnderlineColorSep(p1,p2)
   METHOD SetTextUnderlineDash(p1,p2)
   METHOD SetTextWordSpacing(p1)
   METHOD SetTransparency(p1)
   METHOD SetupCustomPrinter(p1,p2,p3)
   METHOD SetViewerPreferences(p1,p2)
   METHOD SetXFAFormFieldAccess(p1,p2)
   METHOD SetXFAFormFieldBorderColor(p1,p2,p3,p4)
   METHOD SetXFAFormFieldBorderPresence(p1,p2)
   METHOD SetXFAFormFieldBorderWidth(p1,p2)
   METHOD SetXFAFormFieldValue(p1,p2)
   METHOD SignFile(InputFileName, cOpenPassword, SignatureFieldName, OutputFileName, PFXFileName, cPFXPassword, cReason, cLocation, cContactInfo)
   METHOD SplitPageText(p1)
   METHOD StartPath(p1,p2)
   METHOD StoreCustomDataFromFile(cKey, FileName, nLocation, nOptions)
   METHOD StoreCustomDataFromString(p1,p2,p3,p4)
   METHOD StringResultLength()
   METHOD TestTempPath()
   METHOD ToPDFUnicode(cUnicodeString) // This function is deprecated from version 7.17.
   METHOD Unlocked()
   METHOD UnlockKey(p1)
   METHOD UpdateAppearanceStream(p1)
   METHOD UseKerning(p1)
   METHOD UseUnsafeLayers(p1)
   // END from TQuickPdf wrapper class



ENDCLASS
*---------------------------------------------------
METHOD HBPrintPDF:INIT(cDefaultLanguage)
   ::_hdll_                      := 0
   ::_id_                        := 0
   ::nCharSet                    := set(_SET_CHARSET)
   ::aImageID                    := {}
   ::nLineWidth                  := ::nDefaultLineWidth := 0.3     // DrawLine etc.()
   ::nOldTextColorRed            := 0                     // 0 = Schwarz, black
   ::nOldTextColorGreen          := 0
   ::nOldTextColorBlue           := 0
   ::nOldTextHighlightColorRed   := 0
   ::nOldTextHighlightColorGreen := 0
   ::nOldTextHighlightColorBlue  := 0
   ::nOldTextUnderlineColorRed   := 0
   ::nOldTextUnderlineColorGreen := 0
   ::nOldTextUnderlineColorBlue  := 0
   ::nAktiveFillColorRed         := 0
   ::nAktiveFillColorGreen       := 0
   ::nAktiveFillColorBlue        := 0
   ::cQuickPdfDllName            := "QuickPDFDLL0725.dll" // ==> :create() sucht eine vorhandene Datei, wenn diese nicht geladen werden kann.
   ::nDefaultPageSize            := "A4"
   ::nDefaultMeasurementUnits    := MEASUREMENTUNITS_MM
   ::nPageDefaultOrigin          := PAGE_ORIGIN_TOP_LEFT
   ::nDefaultStandardFont        := STANDARDFONTID_ARIAL
   ::nDefaultBoldFont            := STANDARDFONTID_ARIALBOLD
   ::nDefaultItalicFont          := STANDARDFONTID_ARIALITALIC
   ::nDefaultItalicBoldFont      := STANDARDFONTID_ARIALBOLDITALIC
   ::nDefaultStandardFontSize    := 12 // 12 Punkt
   if cDefaultLanguage==NIL
      ::cErrorLanguage           := "DE"      // 2 Bytes => UPPER( ISO 639-1 ) es = espania, en = english, fr = french, de = germany
   else
      ::cErrorLanguage           := upper(alltrim(cDefaultLanguage))
   endif
   do case
      case "*"+::cErrorLanguage+"*" $ "*D*DE*"
         ::cErrorLanguage        := "DE"
         ::cErrorLoadDll         := "Fehler beim Laden von Quick PDF DLL ("+::cQuickPdfDllName+" ff). Ist diese vorhanden ?"
         ::cErrorNoInstance      := "Quick PDF DLL konnte nicht initialisiert werden !"
         ::cErrorNoLicenseOK     := "Lizenz Key wurde nicht akzeptiert !"
         ::cErrorNoLicenseKey    := "Parameter cKey (Lizenz Key) wurde nicht bergeben !"
         ::cErrorNotMinVerOT4XB  := "Version 1.5.12.21 oder hher von ot4xb wird bentigt. www.xbwin.com"

         ::cDefaultYes           := "Ja"
         ::cDefaultNo            := "Nein"

      case "*"+::cErrorLanguage+"*" $ "*ES*"
         ::cErrorLoadDll         := "No se ha podido cargar la DLL Quick PDF ("+::cQuickPdfDllName+" ff). Probablemente no se ha podido hallar."
         ::cErrorNoInstance      := "No se ha podido inicializar una nueva instancia de la DLL Quick PDF"
         ::cErrorNoLicenseOK     := "La licencia no ha sido aceptada !"
         ::cErrorNoLicenseKey    := "Falta el parmetro cKey, la clave de la licencia no est definida"
         ::cErrorNotMinVerOT4XB  := "Se requiere ot4xb 1.5.12.21 o superior, busca en  www.xbwin.com"

         ::cDefaultYes           := "Si"
         ::cDefaultNo            := "No"

      otherwise     // Englisch / english
         ::cErrorLoadDll         := "Could not load Quick PDF DLL ("+::cQuickPdfDllName+" ff). Maybe not found ?"
         ::cErrorNoInstance      := "The instance of Quick PDF Library could not be created !"
         ::cErrorNoLicenseOK     := "License key was not accepted !"
         ::cErrorNoLicenseKey    := "Missing Parameter cKey, license key was not defined !"
         ::cErrorNotMinVerOT4XB  := "ot4xb 1.5.12.21 or higher required, see www.xbwin.com"

         ::cDefaultYes           := "Yes"
         ::cDefaultNo            := "No"

   end

   if ::nCharSet = 1    // ANSI => OEM
      ::cErrorLoadDll          := ConvToOemCP(::cErrorLoadDll)
      ::cErrorNoInstance       := ConvToOemCP(::cErrorNoInstance)
      ::cErrorNoLicenseOK      := ConvToOemCP(::cErrorNoLicenseOK)
      ::cErrorNoLicenseKey     := ConvToOemCP(::cErrorNoLicenseKey)
      ::cErrorNotMinVerOT4XB   := ConvToOemCP(::cErrorNotMinVerOT4XB)
   endif              // OK OEM

   ::cDefaultNumFormat         := "999,999,999.99"

   ::nDefaultLPI               :=  6         //  6 lines per inch            // Zeilen  pro Zoll
   ::nDefaultCPI               := 10         // 10 chars per inch            // Zeichen pro Zoll
   ::nFirstLine                :=  4         //  3 lines TOP margin, first line in 4
   ::nLastLine                 := 67         //  3 lines BOTTOM margin, 70 Lines per Page in A4, last print line on 67
   ::nFirstRow                 :=  9         //  8 chars left margin  2 cm
   ::nLastRow                  := 78         //  4 chars right margin 1 cm
   ::nCPI                      := ::nDefaultCPI
   ::nLPI                      := ::nDefaultLPI
   ::nAlign                    := TEXT_ALIGN_LEFT
   ::PrintTextAlltrim          := .t.
   ::nPageNo                   := 1
   ::nTextUnderline            := TEXTUNDERLINE_NONE
   ::SayOrigin0                := .f.

   ::UseAutoConvUTF8           := .t.

return self
*---------------------------------------------------
Method HBPrintPDF:Create(cKey)
   local aDLL
   ::IsOK := .f.
   DEFAULT cKey TO GetEnv("QUICKPDF_07_REGKEY")
   do case
      case empty(cKey)
           msgbox(::cErrorNoLicenseKey,"HBPrintPDF():Create(cKey)")
      case ot4xb() < "001.005.012.021"
           MsgBox(::cErrorNotMinVerOT4XB,"HBPrintPDF():Create(cKey)")
      otherwise
           // 1.51 ...
           // mit dem richtigen Namen kann die DLL auch im Pfad liegen, aber zu viele Anfragen ...
           // with this syntax the DLL could be found in a directory in the path, but don't ask too much.
           ::_hdll_ := dllLoad(::cQuickPdfDllName)
           if empty(::_hdll_)                          // 7.26
              ::_hdll_ := dllLoad("QuickPDFDLL0726.dll")
           endif
           if empty(::_hdll_)                          // 7.25
              ::_hdll_ := dllLoad("QuickPDFDLL0725.dll")
           endif
           if empty(::_hdll_)                          // 7.24
              ::_hdll_ := dllLoad("QuickPDFDLL0724.dll")
           endif
           if empty(::_hdll_)                          // 7.23
              ::_hdll_ := dllLoad("QuickPDFDLL0723.dll")
           endif
           if empty(::_hdll_)                          // 7.21
              ::_hdll_ := dllLoad("QuickPDFDLL0721.dll")
           endif
           if empty(::_hdll_)                          // 7.19
              ::_hdll_ := dllLoad("QuickPDFDLL0719.dll")
           endif
           if empty(::_hdll_)                          // 7.18
              ::_hdll_ := dllLoad("QuickPDFDLL0718.dll")
           endif
           // eventuell andere DLL suchen ... is there another one ?   HB 1.30
           if empty(::_hdll_)
              aDLL := directory(cAppPath()+"QuickPDFDLL07??.dll")  // in EXE path !
              ASort( aDLL,,, {|a1,a2| a1[ F_NAME ] < a2[ F_NAME ] } )
              if len(aDLL) > 0
                 ::cQuickPdfDllName := aTail(aDLL)[ F_NAME ]
                 ::_hdll_ := dllLoad(::cQuickPdfDllName)
              endif
           endif
           if empty(::_hdll_)
              msgbox(::cErrorLoadDll,"HPPrintPDF() - dllLoad()")
           else
              ::_id_ := FpQCall( {::_hdll_,"QuickPDFCreateLibrary"} ,"__sl__sl",::_id_)
              if empty(::_id_)
                 msgbox(::cErrorNoInstance,"HBPrintPDF():Create(cKey)")
              else
                 if ::UnlockKey(cKey)
                    ::IsOK := .t.
                    ::SetPageSize(::nDefaultPageSize)
                    ::SetMeasurementUnits(::nDefaultMeasurementUnits)
                    ::SetLineWidth(::nDefaultLineWidth)
                    ::SetOrigin(::nPageDefaultOrigin)
                    ::nDefaultStandardFontID       := ::AddStandardFont(::nDefaultStandardFont)
                    ::nDefaultBoldFontID           := ::AddStandardFont(::nDefaultBoldFont)
                    ::nDefaultItalicFontID         := ::AddStandardFont(::nDefaultItalicFont)
                    ::nDefaultItalicBoldFontID     := ::AddStandardFont(::nDefaultItalicBoldFont)
                    ::SetHTMLNormalFont("Default",    ::nDefaultStandardFontID  )
                    ::SetHTMLBoldFont("Default",      ::nDefaultBoldFontID      )
                    ::SetHTMLItalicFont("Default",    ::nDefaultItalicFontID    )
                    ::SetHTMLBoldItalicFont("Default",::nDefaultItalicBoldFontID)
                    ::SelectFont(::nDefaultStandardFontID)
                    ::SetTextSize(::nDefaultStandardFontSize)         // setzt auch ::nLineFeed / calculates ::nLineFeed
                 else
                    msgbox(::cErrorNoLicenseOK,"HBPrintPDF():Create(cKey)")
                    ::destroy()
                 endif
              endif
           endif
   end

return SELF
*---------------------------------------------------
Method HBPrintPDF:Destroy()
   if ::ReleaseLibrary()
      ::_id_   := 0
      ::_hdll_ := 0
   endif
return NIL
*---------------------------------------------------
Method HBPrintPDF:GetTextUnderline()
return ::nTextUnderline
*---------------------------------------------------
Method HBPrintPDF:GetPageSizeX()
return ::PageWidth()
*---------------------------------------------------
Method HBPrintPDF:GetPageSizeY()
return ::PageHeight()
*---------------------------------------------------
Method HBPrintPDF:SetLPI(nLPI)
  local nReturn
  if nLPI==NIL
     ::nLPI  := ::nDefaultLPI
     nReturn := ::nLPI
  else
     nReturn := ::nLPI
     ::nLPI  := nLPI
  endif
return nReturn
*---------------------------------------------------
Method HBPrintPDF:GetLPI()
return ::nLPI
*---------------------------------------------------
Method HBPrintPDF:SetCPI(nCPI)
  local nReturn
  if nCPI==NIL
     ::nCPI  := ::nDefaultCPI
     nReturn := ::nCPI
  else
     nReturn := ::nCPI
     ::nCPI  := nCPI
  endif
return nReturn
*---------------------------------------------------
Method HBPrintPDF:GetCPI()
return ::nCPI
*---------------------------------------------------
Method HBPrintPDF:SetSayLineFeed(nLineHeight)
   DEFAULT nLineHeight TO ::GetTextHeight()       // Standardhhe von Font / fonts standard height
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           ::nLPI := 25.4 / nLineHeight
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           ::nLPI :=  1.0 / nLineHeight
      otherwise  // Points = 1/72 Inch
           ::nLPI := 72.0 / nLineHeight
   end
return ::GetSayLineFeed()
*---------------------------------------------------
Method HBPrintPDF:GetSayLineFeed()
   local nLineHeight
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nLineHeight := 25.4 / ::nLPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nLineHeight :=  1.0 / ::nLPI
      otherwise  // Points = 1/72 Inch
           nLineHeight := 72.0 / ::nLPI
   end
return nLineHeight
*---------------------------------------------------
Method HBPrintPDF:SetSayLinesPerPage(nLinesPerPage)
   if nLinesPerPage==NIL
      ::SetSayLineFeed() // standard font size
   else
      ::SetSayLineFeed(::PageHeight()/nLinesPerPage)
   endif
return ::GetSayLinesPerPage()
*---------------------------------------------------
Method HBPrintPDF:GetSayLinesPerPage()
return ::PageHeight()/::GetSayLineFeed()
*---------------------------------------------------
Method HBPrintPDF:SetSayRowsPerPage(nRowsPerPage)
   local nPageWidthInInch  // Papierbreite in Inch
   do case
      case nRowsPerPage==NIL
           ::GetSayRowsPerPage()
      case  80 <= nRowsPerPage .and. nRowsPerPage <=  82
           ::SetCpi(10)
      case  96 <= nRowsPerPage .and. nRowsPerPage <=  98
           ::SetCpi(12)
      case 136 <= nRowsPerPage .and. nRowsPerPage <= 140
           ::SetCpi(17)
      otherwise
           do case
              case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
                   nPageWidthInInch := ::PageWidth() / 25.4
              case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
                   nPageWidthInInch := 1.0
              otherwise  // Points = 1/72 Inch
                   nPageWidthInInch := ::PageWidth() / 72.0
           end
           // 1 inch / nRowWidth in Inch
           ::SetCpi( 1 / (nPageWidthInInch/nRowsPerPage) )
   end
return ::GetSayRowsPerPage()
*---------------------------------------------------
Method HBPrintPDF:GetSayRowsPerPage()
return int(::PageWidth()/::GetCPICharWidth())
*---------------------------------------------------
Method HBPrintPDF:GetRowsPerInch()
return ::nCPI
*---------------------------------------------------
Method HBPrintPDF:GetCPICharWidth(nCPI) // Breite eines Zeichens mit nCPI
   local nSizeX
   DEFAULT nCPI TO ::GetCPI()
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nSizeX := 25.4 / nCPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nSizeX :=  1.0 / nCPI
      otherwise  // Points = 1/72 Inch
           nSizeX := 72.0 / nCPI
   end
return nSizeX
*---------------------------------------------------
Method HBPrintPDF:SAY(nRow,nCol,xData,cAlign,nCPI,nLPI) // min == 1,1
   local cTxt := "", nAlign
   do case
      case ValType(xData)=="D"
           cTxt := dtoc(xData)
      case ValType(xData)=="L"
           cTxt := iif(xData,::cDefaultYes,::cDefaultNo)
      case ValType(xData)=="N"
           cTxt := TransForm(xData,::cDefaultNumFormat)
           DEFAULT cAlign TO "R"
      case ValType(xData)=="C"
           cTxt := xData
      otherwise
           cTxt := var2char(xData)
   end
   DEFAULT cAlign TO "L"
   cAlign := upper(left(alltrim(cAlign)+"L",1))
   nAlign := ::GetTextAlign()  // alte Einstellung speichern, save old value
   do case
      case cAlign == "L"
           ::SetTextAlign(TEXT_ALIGN_LEFT)
      case cAlign == "R"
           ::SetTextAlign(TEXT_ALIGN_RIGHT)
      case cAlign == "C" .or. cAlign == "M" .or. cAlign == "Z"
           ::SetTextAlign(TEXT_ALIGN_CENTER)
   end
   ::DrawText(::nColToPosX(nCol,nCPI),::nRowToPosY(nRow,nLPI), cTxt )
   ::SetTextAlign(nAlign)
return self
*---------------------------------------------------
Method HBPrintPDF:SayLine(nRowTop,nColLeft,nRowBottom,nColRight,cAlign1,cAlign2,nOffset,nCPI,nLPI)
   local nStartX, nStartY, nEndX, nEndY, nSizeX, nSizeY,nOffsetX,nOffsetY

   DEFAULT nRowTop    TO 0
   DEFAULT nRowBottom TO 0
   DEFAULT nColLeft   TO 0
   DEFAULT nColRight  TO 0

   nStartY := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nStartX := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)

   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()

   if valtype(cAlign1)<>"C" .or. len(cAlign1) <> 2
      cAlign1 := NIL
   endif
   if valtype(cAlign2)<>"C" .or. len(cAlign2) <> 2
      cAlign2 := NIL
   endif

   DEFAULT nOffset TO 0

   do case
      case nRowTop == nRowBottom
           DEFAULT cAlign1 TO SAYLINE_ALIGN_MIDDLE_LEFT
           DEFAULT cAlign2 TO SAYLINE_ALIGN_MIDDLE_RIGHT
           nOffsetX := 0
           nOffsetY := nOffset
      case nColLeft == nColRight
           DEFAULT cAlign1 TO SAYLINE_ALIGN_TOP_CENTER
           DEFAULT cAlign2 TO SAYLINE_ALIGN_BOTTOM_CENTER
           nOffsetX := nOffset
           nOffsetY := 0
      otherwise
           DEFAULT cAlign1 TO SAYLINE_ALIGN_MIDDLE_CENTER // SAYLINE_ALIGN_TOP_LEFT
           DEFAULT cAlign2 TO SAYLINE_ALIGN_MIDDLE_CENTER // SAYLINE_ALIGN_BOTTOM_RIGHT
           nOffsetX := 0
           nOffsetY := 0
   end

   do case
      case cAlign1[1] == SAYLINE_ALIGN_LEFT
           // nStartX is OK
      case cAlign1[1] == SAYLINE_ALIGN_CENTER
           nStartX += nSizeX/2
      case cAlign1[1] == SAYLINE_ALIGN_RIGHT
           nStartX += nSizeX
   end

   do case
      case cAlign2[1] == SAYLINE_ALIGN_LEFT
           // nEndX is OK
      case cAlign2[1] == SAYLINE_ALIGN_CENTER
           nEndX += nSizeX/2
      case cAlign2[1] == SAYLINE_ALIGN_RIGHT
           nEndX += nSizeX
   end

   do case
      case cAlign1[2] == SAYLINE_ALIGN_TOP
           nStartY -= ::GetTextBound(GETTEXTBOUND_TOP)
      case cAlign1[2] == SAYLINE_ALIGN_MIDDLE
           nStartY -= ::GetTextBound(GETTEXTBOUND_TOP) - nSizeY/2
      case cAlign1[2] == SAYLINE_ALIGN_BASELINE
           // all OK
      case cAlign1[2] == SAYLINE_ALIGN_BOTTOM
           nStartY += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   end

   do case
      case cAlign2[2] == SAYLINE_ALIGN_TOP
           nEndY -= ::GetTextBound(GETTEXTBOUND_TOP)
      case cAlign2[2] == SAYLINE_ALIGN_MIDDLE
           nEndY -= ::GetTextBound(GETTEXTBOUND_TOP) - nSizeY/2
      case cAlign2[2] == SAYLINE_ALIGN_BASELINE
           // nEndY is OK
      case cAlign2[2] == SAYLINE_ALIGN_BOTTOM
           nEndY += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   end

   ::DrawLine(nStartX+nOffsetX, nStartY+nOffsetY, nEndX+nOffsetX, nEndY+nOffsetY)

return self
*---------------------------------------------------
Method HBPrintPDF:SayBox(nRowTop,nColLeft,nRowBottom,nColRight,nOffset,nDrawOptions,nCPI,nLPI)
   local nLeft, nTop, nWidth, nHeight, nEndY, nEndX, nSizeX, nSizeY, nMax, nMin
   DEFAULT nOffset TO 0
   DEFAULT nDrawOptions TO DRAWOPTIONS_OUTLINE
   DEFAULT nRowTop    TO 0
   DEFAULT nRowBottom TO 0
   DEFAULT nColLeft   TO 0
   DEFAULT nColRight  TO 0

   if nRowTop > nRowBottom .or. nColLeft > nColRight // Fehler vermeiden
      nMax := max(nRowTop,nRowBottom)
      nMin := min(nRowTop,nRowBottom)
      nRowTop    := nMin
      nRowBottom := nMax
      nMax := max(nColLeft,nColRight)
      nMin := min(nColLeft,nColRight)
      nColLeft   := nMin
      nColRight  := nMax
   endif

   // char -> mm
   nTop    := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nLeft   := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)

   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()

   nTop    -= ::GetTextBound(GETTEXTBOUND_TOP)
   nEndY   += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   nWidth  := nEndX - nLeft + nSizeX
   nHeight := nEndY - nTop

   ::DrawBox(nLeft-nOffset, nTop-nOffset, nWidth+nOffset*2, nHeight+nOffset*2, nDrawOptions)

return self
*---------------------------------------------------
Method HBPrintPDF:SayImage(nRowTop,nColLeft,nRowBottom,nColRight,nRotate,nCPI,nLPI,lRatio)
   local nLeft, nTop, nWidth, nHeight, nEndY, nEndX, nSizeX, nSizeY, nMax, nMin, IsOK
   local nSizeBmpX,nSizeBmpY, nFaktor := 1
   DEFAULT nRowTop     TO 0
   DEFAULT nRowBottom  TO 0
   DEFAULT nColLeft    TO 0
   DEFAULT nColRight   TO 0
   DEFAULT lRatio      TO .t.

   if nRowTop > nRowBottom .or. nColLeft > nColRight // Fehler vermeiden
      nMax := max(nRowTop,nRowBottom)
      nMin := min(nRowTop,nRowBottom)
      nRowTop    := nMin
      nRowBottom := nMax
      nMax := max(nColLeft,nColRight)
      nMin := min(nColLeft,nColRight)
      nColLeft   := nMin
      nColRight  := nMax
   endif

   // char -> mm
   nTop    := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nLeft   := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)
   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()
   nTop    -= ::GetTextBound(GETTEXTBOUND_TOP)
   nEndY   += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   nWidth  := nEndX - nLeft + nSizeX
   nHeight := nEndY - nTop

   if lRatio
           // ::PrintBmp(    nPosX,  nPosY,   nXSize,    nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit  ) // -> lSuccess
      IsOK := ::PrintBMP(  nLeft+1, nTop+1, nWidth-2, nHeight-2,            ,    ,        ,        , nRotate, NIL , NIL )
   else
           // ::DrawImage(   nLeft, nTop  , nWidth  , nHeight  )    // druckt auch verzerrt - not fine, but fit in place.           // -> lSuccess
      IsOK := ::DrawImage( nLeft+1, nTop+1, nWidth-2, nHeight-2)
   endif
return IsOK
*---------------------------------------------------
Method HBPrintPDF:nColToPosX(nCol,nCPI)                  // -> :say(nCol,
   local nCharWidth, nPosX
   DEFAULT nCol TO ::nFirstRow
   DEFAULT nCPI TO ::nCPI
   if ::SayOrigin0                                       // Clipper Top Left 0,0
      nCol++
   endif
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nCharWidth := 25.4 / nCPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nCharWidth :=  1.0 / nCPI
      otherwise  // Points = 1/72 Inch
           nCharWidth := 72.0 / nCPI
   end
   nCol--  // nCol soll gedruckt werden ...
   nPosX := max(1,   nCol * nCharWidth )
return nPosX
*---------------------------------------------------
Method HBPrintPDF:nRowToPosY(nRow,nLPI)                  // -> :say(,nRow
   local nPageY, nLineHeight, nPosY
   DEFAULT nRow TO ::nFirstLine
   DEFAULT nLPI TO ::nLPI
   if ::SayOrigin0                                       // Clipper Top Left 0,0
      nRow++
   endif
   nPageY := ::PageHeight()
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nLineHeight := 25.4 / nLPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nLineHeight :=  1.0 / nLPI
      otherwise  // Points = 1/72 Inch
           nLineHeight := 72.0 / nLPI
   end
   if ::GetOrigin()==PAGE_ORIGIN_TOP_LEFT
      nPosY := max(1, nRow * nLineHeight)
   else
      nPosY := max(1, nPageY - (nRow * nLineHeight))
   endif
return nPosY
*---------------------------------------------------
Method HBPrintPDF:GetColorRGB(nXbaseGraColorConstant,nRGB )           // Xbase++ color -> {r,g,b} || nRGB -> 1=red-part, 2=green-part, 3 = blue-part
   local xReturn,x
   static aColorTable :=  { { GRA_CLR_WHITE     , {   1,   1,   1 } } ,;            // RGB  0 - 255 => 0.0000000 - 1.0000000
                            { GRA_CLR_BLACK     , {   0,   0,   0 } } ,;
                            { GRA_CLR_BLUE      , {   0,   0,   1 } } ,;
                            { GRA_CLR_RED       , {   1,   0,   0 } } ,;
                            { GRA_CLR_PINK      , {   1,   0,   1 } } ,;
                            { GRA_CLR_GREEN     , {   0,   1,   0 } } ,;
                            { GRA_CLR_CYAN      , {   0,   1,   1 } } ,;
                            { GRA_CLR_YELLOW    , {   1,   1,   0 } } ,;
                            { GRA_CLR_DARKGRAY  , { 0.5, 0.5, 0.5 } } ,;
                            { GRA_CLR_DARKBLUE  , {   0,   0, 0.5 } } ,;
                            { GRA_CLR_DARKRED   , { 0.8,   0,   0 } } ,;
                            { GRA_CLR_DARKPINK  , { 0.6,   0, 0.6 } } ,;
                            { GRA_CLR_DARKGREEN , {   0, 0.6,   0 } } ,;
                            { GRA_CLR_DARKCYAN  , {   0, 0.6, 0.6 } } ,;
                            { GRA_CLR_BROWN     , { 0.5, 0.25,  0 } } ,;
                            { GRA_CLR_PALEGRAY  , { 0.7, 0.7 ,0.7 } } }
   DEFAULT nXbaseGraColorConstant TO GRA_CLR_BLACK
   DEFAULT nRGB TO 0
   x := aScan(aColorTable,{|aC| aC[1]==nXbaseGraColorConstant })
   do case
      case empty(x) .and. empty(nRGB)
           xReturn := {0,0,0}
      case empty(x)
           xReturn := 0
      case empty(nRGB)
           xReturn := aColorTable[x,2]
      otherwise
           xReturn := aColorTable[x,2,nRGB]
   end
return xReturn
*---------------------------------------------------
METHOD HBPrintPDF:getPageNo(cDataType)
   local uReturn
   if cDataType==NIL
      cDataType := "N"
   else
      cDataType := upper(alltrim(cDataType))
   endif
   do case
      case cDataType == "N"
           uReturn := ::nPageNo
      case cDataType == "C"
           uReturn := alltrim(str(::nPageNo))
   end
return uReturn
*---------------------------------------------------
METHOD HBPrintPDF:PrintPageNo(nPosX, nPosY, cMask, cAlign, xColor)
   DEFAULT nPosX  TO ::PageWidth()/2
   DEFAULT nPosY  TO ::PageHeight()-12
   DEFAULT cMask  TO "- #PN -"
   DEFAULT cAlign TO "C"
   cMask := strTran(cMask,"#PN",::getPageNo("C"))
   cMask := strTran(cMask,"#PC",alltrim(str(::PageCount())))
return ::PrintText( nPosX, nPosY, cMask, cAlign,,, xColor)
*---------------------------------------------------
METHOD HBPrintPDF:PrintText( nPosX, nPosY, xData, cAlign, nMaxLen, cArt, xColor, nDrehen )
                        //old              cTxt   cAusrichtung     n/a   nFarbe
   local cTxt := "", nAlign, lAppendText, lColorChanged := .f., aResetColor

   DEFAULT cAlign  TO " "
   DEFAULT nDrehen TO 0
   // :AppendText() .or. :DrawText() ?
   lAppendText := ( nPosX == NIL .or. nPosY == NIL )
   // xData -> String
   do case
      case ValType(xData)=="D"
           cTxt := dtoc(xData)
      case ValType(xData)=="L"
           cTxt := iif(xData,::cDefaultYes,::cDefaultNo)
      case ValType(xData)=="N"
           cTxt := TransForm(xData,::cDefaultNumFormat)
           DEFAULT cAlign TO "R"
      case ValType(xData)=="C"
           cTxt := xData
      otherwise
           cTxt := var2char(xData)
   end
   // cAlign / cAusrichtung
   nAlign := ::GetTextAlign()  // alte Einstellung speichern, save old value
   do case
      case lAppendText
           cAlign  := " "
           nDrehen := 0
      case cAlign == "L"
           ::SetTextAlign(TEXT_ALIGN_LEFT)
      case cAlign == "R"
           ::SetTextAlign(TEXT_ALIGN_RIGHT)
      case cAlign == "C" .or. cAlign == "M" .or. cAlign == "Z"
           ::SetTextAlign(TEXT_ALIGN_CENTER)
   end
   // lnger als nMaxLen ? / too long ?
   if ValType(nMaxLen)=="N" .and. ! empty(nMaxLen)
      do while ::GetTextWidth(cTxt) > nMaxLen .and. ! empty(cTxt)
         cTxt := left(cTxt,len(cTxt)-1)
      enddo
   endif

   if xColor == NIL
      // don't change the color
      lColorChanged := .f.
   else
      if ValType(xColor)=="A"  // RGB Array !
         // don't change xColor !
      else
         // get the RGB Array out of the Xbase++ color number
         xColor := ::GetColorRGB(xColor,0) // xColor := {r,g,b}
      endif
      // save the last set colors
      aResetColor := { ::nOldTextColorRed , ::nOldTextColorGreen , ::nOldTextColorBlue }
      ::SetTextColor(xColor[1],xColor[2],xColor[3]) // change the values of ::nOldTextColorRed, ::nOldTextColorGreen, ::nOldTextColorBlue
      lColorChanged := .t.
   endif

   // Append, Rotate, normal ?
   do case
      case lAppendText
           ::AppendText(cTxt)
      case ValType(nDrehen)=="N" .and. ! empty(nDrehen)
           ::DrawRotatedText(nPosX, nPosY,nDrehen,cTxt )
      otherwise
           ::DrawText(nPosX, nPosY, cTxt )
           if ! empty(cAlign)
              ::SetTextAlign(nAlign)
           endif
   end

   // Reset color
   if lColorChanged
      ::SetTextColor(aResetColor[1], aResetColor[2], aResetColor[3])
   endif

return .t.
*---------------------------------------------------


//*---------------------------------------------------
//METHOD HBPrintPDF:PrintText( nPosX, nPosY, xData, cAlign, nMaxLen, cArt, xColor, nDrehen )  // 1.55
//                        //old              cTxt   cAusrichtung     n/a   nFarbe
//   local cTxt := "", nAlign, lAppendText, lColorChanged
//
//   DEFAULT cAlign  TO " "
//   DEFAULT nDrehen TO 0
//   // :AppendText() .or. :DrawText() ?
//   lAppendText := ( nPosX == NIL .or. nPosY == NIL )
//   // xData -> String
//   do case
//      case ValType(xData)=="D"
//           cTxt := dtoc(xData)
//      case ValType(xData)=="L"
//           cTxt := iif(xData,::cDefaultYes,::cDefaultNo)
//      case ValType(xData)=="N"
//           cTxt := TransForm(xData,::cDefaultNumFormat)
//           DEFAULT cAlign TO "R"
//      case ValType(xData)=="C"
//           cTxt := xData
//      otherwise
//           cTxt := var2char(xData)
//   end
//   // cAlign / cAusrichtung
//   nAlign := ::GetTextAlign()  // alte Einstellung speichern, save old value
//   do case
//      case lAppendText
//           cAlign  := " "
//           nDrehen := 0
//      case cAlign == "L"
//           ::SetTextAlign(TEXT_ALIGN_LEFT)
//      case cAlign == "R"
//           ::SetTextAlign(TEXT_ALIGN_RIGHT)
//      case cAlign == "C" .or. cAlign == "M" .or. cAlign == "Z"
//           ::SetTextAlign(TEXT_ALIGN_CENTER)
//   end
//   // lnger als nMaxLen ? / too long ?
//   if ValType(nMaxLen)=="N" .and. ! empty(nMaxLen)
//      do while ::GetTextWidth(cTxt) > nMaxLen .and. ! empty(cTxt)
//         cTxt := left(cTxt,len(cTxt)-1)
//      enddo
//   endif
//   //
//   do case
//      case xColor == NIL
//           // don't change
//           lColorChanged := .f.
//      case ValType(xColor)=="A"  // RGB Array !
//           // don't change
//           lColorChanged := .f.
//      otherwise
//           // nXbaseGraColorConstant -> GRA.CH
//           lColorChanged := .t.
//           // alter Vorgnger in lokalen Variablen speichern
//           // save last color lokal
//           xColor := ::GetColorRGB(xColor,0) // xColor := {r,g,b}
//           ::SetTextColor(xColor[1],xColor[2],xColor[3])
//   end
//
//   // Append, Rotate, normal ?
//   do case
//      case lAppendText
//           ::AppendText(cTxt)
//      case ValType(nDrehen)=="N" .and. ! empty(nDrehen)
//           ::DrawRotatedText(nPosX, nPosY,nDrehen,cTxt )
//      otherwise
//           ::DrawText(nPosX, nPosY, cTxt )
//           if ! empty(cAlign)
//              ::SetTextAlign(nAlign)
//           endif
//   end
//
//   // Reset color
//   if lColorChanged
//      ::SetTextColor(::nOldTextColorRed, ::nOldTextColorGreen, ::nOldTextColorBlue)
//   endif
//
//return .t.
*---------------------------------------------------
METHOD HBPrintPDF:PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit )
   local nImageID, lFehler := .f., cErrTxt, nDLL, nOldLineWidth, nOldImage           // cFileNameID = C or N ...

   DEFAULT nHAlign TO 0
   DEFAULT nVAlign TO 0
   DEFAULT nRotate TO 0
   DEFAULT nBox    TO 0      //  nBox > 0 zeichnet eine Box auf die Auenkante
                             //  nBox > 0 draw a box outside the image

   do case
      case nRotate ==  90    // Passend zu SayImage()
           nRotate :=   1    //  90 degrees anti-clockwise
      case nRotate == 180    // Passend zu SayImage()
           nRotate :=   3    // 180 degrees
      case nRotate == 270    // Passend zu SayImage()
           nRotate :=   2    //  90 degrees clockwise
      otherwise
           nRotate :=   0    //  normal
   endcase

   // wird nur verwendet, wenn nXSize, nYSize nicht angegeben sind.
   // if nXSize, nYSize are nil, this parameter will scale the bitmap
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           DEFAULT nDotsPerUnit TO       5 // 5 Punkte pro mm, 5 dots per mm            100 => 20mm, 160 => 32 mm
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           DEFAULT nDotsPerUnit TO     128 // 128 dots per Inch ( 5 * 25.6 mm = 128 )
      otherwise  // Points = 1/72 Inch
           DEFAULT nDotsPerUnit TO       1.7778 // dots per point
   end

   nOldImage := ::SelectedImage()

   do case
      case nID==NIL .and. empty(cFileNameID)
           // Keine Resource, Kein Dateiname, Kein Stringpuffer => aktuell selektierte Grafik benutzen !
           // NO resource, NO filename, NO Stringbuffer         => use selected image
           if nOldImage # 0
              // OK
           else
              cErrTxt := "NO IMAGE SELECTED"
              lFehler := .t.
           endif
      case nID==NIL .and. valtype(cFileNameID)=="C"
           // Dateiname !
           nImageID := ::AddImageFile(cFileNameID,0)
           if nImageID > 0
              // OK
           else
              cErrTxt := "FILENAME NOT VALID"
              lFehler := .t.
           endif
      case nID==NIL .and. valtype(cFileNameID)=="N"
           // Image ID  !
           if ::SelectImage(cFileNameID)
              // OK
           else
              cErrTxt := "IMAGEID NOT VALID"
              lFehler := .t.
           endif
      case nID==NIL
           // ERROR
           cErrTxt := "PARAMETER ERROR ID"
           lFehler := .t.
      case nID == -1          // XbpBitmap SetBuffer() String
           if valtype(cFileNameID)=="C" .and. ! empty(cFileNameID)
              nImageID := ::AddImageFromXbpBMP(cFileNameID)
              if nImageID > 0
                 ::AddImageID(nImageID,"PBMP"+alltrim(str(seconds())))
              else
                 cErrTxt := "BMP-BUFFER NOT VALID"
                 lFehler := .t.
              endif
           else
              cErrTxt := "BMP-BUFFER NOT VALID"
              lFehler := .t.
           endif
      case nID > 0            // RESOURCE ID
           if valtype(cFileNameID)=="C" .and. ! empty(cFileNameID) // IN DLL
              nDLL := DllLoad(cFileNameID)
           else
              nDLL := NIL
           endif
           nImageID := ::AddImageResource(nID,0,nDLL)
           if nImageID > 0
              // OK
           else
              cErrTxt := "RESOURCE-ID NOT VALID"
              lFehler := .t.
           endif
      otherwise
           // ERROR
           cErrTxt := "PARAMETER ERROR"
           lFehler := .t.
   end

   if empty(nXSize) .or. empty(nYSize)
      if nRotate==1 .or. nRotate==2 // 90 oder 270
         nYSize := ::ImageWidth()  / nDotsPerUnit
         nXSize := ::ImageHeight() / nDotsPerUnit
      else
         nXSize := ::ImageWidth()  / nDotsPerUnit
         nYSize := ::ImageHeight() / nDotsPerUnit
      endif
      if empty(nXSize) .or. empty(nYSize)
         cErrTxt := "IMAGE SIZE 0"
         lFehler := .t.
      endif
   endif

   if lFehler
      ::PrintText( nPosX, nPosY, cErrTxt )
   else
      if ::FitImage(nPosX, nPosY, nXSize, nYSize, nHAlign, nVAlign, nRotate)
         if nBox < 0
            nBox := ::nDefaultLineWidth
         endif
         // OK
         if nBox > 0
            nOldLineWidth := ::SetLineWidth(nBox)
            ::DrawBox(nPosX, nPosY, nXSize, nYSize, 0) // outline
            ::SetLineWidth(nOldLineWidth)
         endif
      else
         ::PrintText( nPosX, nPosY, "IMAGE PRINT ERROR" )
         lFehler := .t.
      endif
   endif

   if nOldImage <> ::SelectedImage()
      ::SelectImage(nOldImage)
   endif

return ! lFehler
*---------------------------------------------------
Method HBPrintPDF:IsTrue(nWert)
Return nWert # 0
*---------------------------------------------------
Method HBPrintPDF:IsFalse(nWert)
Return nWert == 0
*---------------------------------------------------
Method HBPrintPDF:GetTextAlign()
return ::nAlign
*---------------------------------------------------
Method HBPrintPDF:LineFeed( nLines, nDistance )
    local nValue
    DEFAULT nLines       TO 1
    DEFAULT ::nLineFeed  TO ::GetTextHeight()
    DEFAULT nDistance    TO ::nLineFeed
    nValue := nLines * nDistance
RETURN nValue
*---------------------------------------------------
Method HBPrintPDF:nBaselineToTop(nPosY)
return nPosY - ::GetTextBound(GETTEXTBOUND_TOP)
*---------------------------------------------------
Method HBPrintPDF:nTopToBaseline(nTop)
return nTop  + ::GetTextBound(GETTEXTBOUND_TOP)
*---------------------------------------------------
Method HBPrintPDF:GetPrinterBinA(p1)
   local aBin := {}
   DEFAULT p1 TO ::GetDefaultPrinterName()
   aBin := tokenize(alltrim(::GetPrinterBins(p1)),CRLF)  // {[1,"Name 1"]CRLF[2,"Name 2"]CRLF...} -> {[1,"Name 1"],[2,"Name 2"],...}
   aeval(aBin,{|cZeile,i| aBin[i] := &("{"+cZeile+"}")}) // {[1,"Name 1"],[2,"Name 2"],...}       -> {{1,"Name 1"},{2,"Name 2"},...}
return aBin
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterNameA()
   local cPrinters, aPrinter := {}, cDelim
   cPrinters := ::GetPrinterNames()                   // -> ["Printer 1","Printer 2","Printer 3"]
*  with tokenize from ot4xb
*   cPrinters := substr(cPrinters,2,len(cPrinters)-2)  // ->  [Printer 1","Printer 2","Printer 3]
*   cDelim    := chr(34)+","+chr(34)                   // -> [","]
*   aPrinter  := tokenize(cPrinters,cDelim)            // -> {"Printer 1","Printer 2","Printer 3"}
*  with macro ...
   aPrinter  := &("{"+::GetPrinterNames()+"}")        // -> [{"Printer 1","Printer 2","Printer 3"}] -> {"Printer 1","Printer 2","Printer 3"}
return aPrinter
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageID(nImageID,cName)
   local lError := .f.
   do case
      case nImageID==NIL .or. cName==NIL .or. ValType(nImageID)#"N" .or. ValType(cName)#"C"
           lError := .t.
      case empty(nImageID) .or. empty(cName)
           lError := .t.
      otherwise
           cName := upper(alltrim(cName))
           do case
              case 0 # aScan(::aImageID,{|aZ| aZ[1]==nImageID .and. aZ[2]==cName })
                   // OK !
              case 0 # aScan(::aImageID,{|aZ| aZ[2]==cName })
                   lError := .t.        // cName muss einmalig sein / cName have to be unique
              otherwise
                   aadd(::aImageID,{nImageID,cName})
           end
   end
return ! lError
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveImageID(xVal)
   local lError := .f., x, bSeek
   do case
      case xVal==NIL .or. ! valtype(xVal) $ "CN" .or. empty(xVal)
           lError := .t.
      case valtype(xVal) == "C"
           xVal  := upper(alltrim(xVal))
           bSeek := {|aZ| aZ[2]==xVal }

      case valtype(xVal) == "N"
           bSeek := {|aZ| aZ[1]==xVal }
   end
   if bSeek # NIL
      do while .t.
         x := aScan(::aImageID,bSeek)
         if x == 0
            exit
         else
            aRemove(::aImageID,x)
         endif
      enddo
   endif
return ! lError
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageIDByName(cName)
   local nImageID := 0  // not found, error !
   if valtype(cName)="C" .and. ! empty(cName)
      cName    := upper(alltrim(cName))
      nImageID := aScan(::aImageID,{|aZ| aZ[2]==cName })
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectImageByName(cName)
   local nImageID
   nImageID := ::GetImageIDByName(cName)
return ::SelectImage(nImageID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFile(cFileName, nOptions)  // -> QuickPDFAddImageFromFile(int InstanceID, char * FileName, int Options)
   local nImageID
   nImageID := ::GetImageIDByName(cFileName)                  // ist die Datei schon enthalten / only once
   if nImageID == 0
      nImageID := ::AddImageFromFile(cFileName, nOptions)
      if nImageID > 0 // OK !
         ::AddImageID(nImageID,cFileName)
      endif
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageFile(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate,cFileName,nOptions)
                                // -> QuickPDFAddImageFromFile(int InstanceID, char * FileName, int Options)
                                // -> QuickPDFFitImage(Left, Top, Width, Height: Double; HAlign, VAlign, Rotate: Integer): Integer;
   local nImageID, lOK := .f.
   nImageID := ::AddImageFile(cFileName, nOptions)
   if nImageID > 0
      lOK := ::FitImage(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate)
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageResource(nResourceID,nOptions,nDLL)          // ONLY / NUR    BMP BITMAP RESOURCEN !!!
   LOCAL nImageID, cImageName
   DEFAULT nResourceID TO 0
   if nResourceID > 0
      cImageName := "RES_ID_"+alltrim(str(nResourceID))
      // schon vorhanden ?
      nImageID := ::GetImageIDByName(cImageName)                  // ist das Image schon enthalten / only once
      if nImageID == 0
         nImageID := ::AddImageFromString(  ::cLoadResource(nDLL,nResourceID, 2, , .t. ) , nOptions )
         if nImageID > 0 // OK !
            ::AddImageID(nImageID,cImageName)
         endif
      endif
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageResource(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate,nResourceID,nOptions)
   local nImageID, lOK := .f.
   nImageID := ::AddImageResource(nResourceID,nOptions)
   if nImageID > 0
      lOK := ::FitImage(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate)
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromXbpBMP(cBMP) // NUR BEI BMP fr Rckgabewert von XbpBitmap():setBuffer()   !!! *.BMP !!!
                                           // ONLY with BMP and return value from XbpBitmap():setBuffer()!!! *.BMP !!!
   if left(cBMP,2) # "BM"
      cBMP := "BM"+U2BIN(len(cBMP)+14)+W2BIN(0)+W2BIN(0)+U2BIN(BIN2U(left(cBMP,4))+14)+cBMP
   endif
return ::AddImageFromString(cBMP,0)        // !!! *.BMP !!!
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintCheckBox( nLeft, nPosY, nSize, cType )  // nSize auen/outline , cType="B" eckig/Box, "R" .or. "C" rund/circle
   local lOK, nTop
   DEFAULT nLeft TO 10
   DEFAULT nPosY TO 10
   DEFAULT nSize TO  3
   DEFAULT cType TO "B"

   nTop := nPosY - nSize   // auf die / on the baseline

   cType := upper(left(alltrim(cType)+"B",1))
   if cType=="B"
      lOK := ::DrawBox(nLeft+0.5, nTop, nSize, nSize, 0) // outline
   else
      lOK := ::DrawCircle(nLeft+0.5, nTop, nSize, 0) // outline
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CalcCheckDigit(uEAN13_Nr) // EAN13 -> 12 + checkDigit -> 13
   local x, lFehler := .f., nSummOdd, nSummEven, cOddEven, nCheckSummValue,;
         cCheckSummValue, cCheckSummDigit,nCheckSummDigit
   do case
      case Valtype(uEAN13_Nr)="N"
           uEAN13_Nr := left(alltrim(str(uEAN13_Nr,15,0)),12)
      case Valtype(uEAN13_Nr)="C"
           uEAN13_Nr := left(alltrim(uEAN13_Nr,15),12)
      otherwise
           cCheckSummDigit := "X"
           lFehler := .t.
   endcase
   if len(uEAN13_Nr) < 12 .and. ! lFehler // noch keine Fehlermeldung erhalten,
      cCheckSummDigit := "X" // -> error
      lFehler := .t.
   endif
   if ! lFehler
      nSummOdd  := 0
      nSummEven := 0
      cOddEven  := "E" // erste Position des EAN13 Strings ist per Definition EVEN !

      for x := 1 to 12
          if cOddEven = "E"
             nSummEven += val(substr(uEAN13_Nr,x,1))
             cOddEven  := "O"
          else
             nSummOdd  += val(substr(uEAN13_Nr,x,1))
             cOddEven  := "E"
          endif
      next

      // CheckSummDigit ist der Unterschied von nCheckSummValue zum nchsten vollen 10er.
      nCheckSummValue := nSummEven + nSummOdd * 3 // Gewichtung der Odd Position mit 3
      cCheckSummValue := right(alltrim(str(nCheckSummValue,15,0)),1) // letzte Position ermitteln
      nCheckSummDigit := 10 - val(cCheckSummValue) // von 0->0 1->9 2->8 etc.
      cCheckSummDigit := right(alltrim(str(nCheckSummDigit,3,0)),1)
   endif
return cCheckSummDigit
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ForceUTF8( cString ) // OEM or ANSI is OK, UTF-8 => UseAutoConvUTF8 := False
   if ::UseAutoConvUTF8
      do case
         case ::nCharSet = 0 // set charset to Ansi
             cString := cAnsiToUtf8(cString)
         case ::nCharSet = 1 // set charset to OEM
             cString := cOemToUtf8(cString)
      endcase
   endif
Return cString
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReadUTF8( cString ) // UTF-8 => OEM or ANSI is OK, for UTF-8 => UseAutoConvUTF8 := False
   if ::UseAutoConvUTF8
      do case
         case ::nCharSet = 0 // set charset to Ansi
             cString := cUtf8ToAnsi(cString)
         case ::nCharSet = 1 // set charset to OEM
             cString := cUtf8ToOem(cString)
      endcase
   endif
Return cString


************************************************
*  HBPrintPDF - Version 7.00 ==> QuickPDF 7.x  *
************************************************

*  Erleichterungen bei Farben - easier colors ==> Xbase++    GRA_CLR_*

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColorXB(nIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetAnnotBorderColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorXB(nXbColor)          // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFillColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorXB(nIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldBackgroundColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorXB(nIndex,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldBorderColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorXB(nIndex,nXbColor)       // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorXB(nXbColor)                   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetLineColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColorXB(nID,nXbColor)             // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetOutlineColor(nID,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorXB(nTableID,nBorderIndex,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableBorderColor(nTableID,nBorderIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellBackgroundColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellBorderColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellTextColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorXB(nXbColor)        // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorXB(nXbColor)     // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextHighlightColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorXB(nXbColor)     // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextUnderlineColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColorXB(cXFAFieldName,nXbColor)    // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetXFAFormFieldBorderColor(cXFAFieldName,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))

**********************************************************************************************************************
// neu in 7.26 - PowerBasic INC    7.26
**********************************************************************************************************************

*** Die meisten Funktionen habe ich noch nie benutzt, daher auch nicht getestet, bitte melden Sie mir Fehler.
*** I don't need many of the new functions, so I did not test them. Please eMail errors to me.

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateNewObject()
return FpQCall( {::_hdll_,"QuickPDFCreateNewObject"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetBaseURL()
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetBaseURL"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupPrintable(iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetOptionalContentGroupPrintable"} ,"__sl__sl__sl",::_id_,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupVisible(iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetOptionalContentGroupVisible"} ,"__sl__sl__sl",::_id_,iOptionalContentGroupID)

**********************************************************************************************************************
*  Erleichterungen bei Farben - use easy color values 0-255 0x00-0xFF
**********************************************************************************************************************
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HB_RGB2double(nR,nG,nB)  // PER REFERENZ AUFRUFEN - USE @ !!!
   if empty(nR) .or. empty(nG) .or. empty(nB)
      nR := nG := nB := 0
   else
      nR /= 255
      nG /= 255
      nB /= 255
   endif
return nil
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetAnnotBorderColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFillColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldBackgroundColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldBorderColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetLineColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColorRGB(nID,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetOutlineColor(nID,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorRGB(nTableID,nBorderIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableBorderColor(nTableID,nBorderIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellBackgroundColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellBorderColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellTextColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextHighlightColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextUnderlineColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColorRGB(cXFAFieldName,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetXFAFormFieldBorderColor(cXFAFieldName,nR/255,nG/255,nB/255)

**********************************************************************************************************************
// neu in 7.25 - PowerBasic INC    7.25
**********************************************************************************************************************

*** Die meisten Funktionen habe ich noch nie benutzt, daher auch nicht getestet, bitte melden Sie mir Fehler.
*** I don't need many of the new functions, so I did not test them. Please eMail errors to me.

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARemoveUsageRights(iFileHandle)
return 0 # FpQCall( {::_hdll_,"QuickPDFDARemoveUsageRights"} ,"__sl__sl__sl",::_id_,iFileHandle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageMatrix(dM11, dM12, dM21, dM22, dMDX, dMDY)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawImageMatrix"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,dM11,dM12,dM21,dM22,dMDX,dMDY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileID(iIndex)
return FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileID"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NormalizePage(iNormalizeOptions)
return FpQCall( {::_hdll_,"QuickPDFNormalizePage"} ,"__sl__sl__sl",::_id_,iNormalizeOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveUsageRights()
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveUsageRights"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldSubmitAction(iIndex, sActionType, sLink)
   sActionType := ::ForceAnsi(sActionType)
   sLink       := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldSubmitAction"} ,"__sl__sl__sl__pt__pt",::_id_,iIndex,sActionType,sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMarkupAnnotStyle(iIndex, dRed, dGreen, dBlue, dTransparency)
return FpQCall( {::_hdll_,"QuickPDFSetMarkupAnnotStyle"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,iIndex,dRed,dGreen,dBlue,dTransparency)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetObjectSource(iObjectNumber, sNewObjectSource)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetObjectSource"} ,"__sl__sl__sl__pt",::_id_,iObjectNumber,sNewObjectSource)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderDCErasePage(iNewErasePage)
return FpQCall( {::_hdll_,"QuickPDFSetRenderDCErasePage"} ,"__sl__sl__sl",::_id_,iNewErasePage)

**********************************************************************************************************************
// neu in 7.24 - PowerBasic INC    7.24
**********************************************************************************************************************

*** Die meisten Funktionen habe ich noch nie benutzt, daher auch nicht getestet, bitte melden Sie mir Fehler.
*** I don't need many of the new functions, so I did not test them. Please eMail errors to me.

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAEmbedFileStreams(iFileHandle, sRootPath)
   sRootPath := ::ForceUTF8(sRootPath)
return FpQCall( {::_hdll_,"QuickPDFDAEmbedFileStreams"} ,"__sl__sl__sl__pt",::_id_,iFileHandle,sRootPath)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldNoExport(iIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetFormFieldNoExport"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldRequired(iIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetFormFieldRequired"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveCustomInformation(sKey)
   sKey := ::ForceAnsi(sKey)
return FpQCall( {::_hdll_,"QuickPDFRemoveCustomInformation"} ,"__sl__sl__pt",::_id_,sKey)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderStyle(iIndex, dWidth, iStyle, dDashOn, dDashOff)
return FpQCall( {::_hdll_,"QuickPDFSetAnnotBorderStyle"} ,"__sl__sl__sl__f8__sl__f8__f8",::_id_,iIndex,dWidth,iStyle,dDashOn,dDashOff)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldChoiceType(iIndex, iChoiceType)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldChoiceType"} ,"__sl__sl__sl__sl",::_id_,iIndex,iChoiceType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldNoExport(iIndex, iNoExport)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldNoExport"} ,"__sl__sl__sl__sl",::_id_,iIndex,iNoExport)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldRequired(iIndex, iRequired)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldRequired"} ,"__sl__sl__sl__sl",::_id_,iIndex,iRequired)

**********************************************************************************************************************
// neu in 7.23 - PowerBasic INC    7.23
**********************************************************************************************************************

*** Die meisten Funktionen habe ich noch nie benutzt, daher auch nicht getestet, bitte melden Sie mir Fehler.
*** I don't need many of the new functions, so I did not test them. Please eMail errors to me.

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DADrawRotatedCapturedPage(iFileHandle, iDACaptureID, iDestPageRef, dPntLeft, dPntBottom, dPntWidth, dPntHeight, dAngle)
return 0 # FpQCall( {::_hdll_,"QuickPDFDADrawRotatedCapturedPage"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8__f8",::_id_,iFileHandle,iDACaptureID,iDestPageRef,dPntLeft,dPntBottom,dPntWidth,dPntHeight,dAngle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageBox(iFileHandle, iPageRef, iBoxIndex, iDimension)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageBox"} ,"__f8__sl__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef,iBoxIndex,iDimension)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAHasPageBox(iFileHandle, iPageRef, iBoxIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFDAHasPageBox"} ,"__sl__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef,iBoxIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPageFromCanvasDC(iDPI, iOptions)
return 0 # FpQCall( {::_hdll_,"QuickPDFNewPageFromCanvasDC"} ,"__sl__sl__sl__sl",::_id_,iDPI,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListAdd(sFontName)
   sFontName := ::ForceAnsi(sFontName)
return 0 # FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListAdd"} ,"__sl__sl__pt",::_id_,sFontName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListCount()
return FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListGet(iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListGet"} ,"__pt__sl__sl",::_id_,iIndex)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveAll()
return FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListRemoveAll"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveIndex(iIndex)
return 0 # FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListRemoveIndex"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveName(sFontName)
   sFontName := ::ForceAnsi(sFontName)
return 0 # FpQCall( {::_hdll_,"QuickPDFNoEmbedFontListRemoveName"} ,"__sl__sl__pt",::_id_,sFontName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveImageToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"QuickPDFSaveImageToString"} ,"__pt__sl",::_id_))

**********************************************************************************************************************
// neu in 7.22 - PowerBasic INC    7.22
**********************************************************************************************************************

*** Die meisten Funktionen habe ich noch nie benutzt, daher auch nicht getestet, bitte melden Sie mir Fehler.
*** I don't need many of the new functions, so I did not test them. Please eMail errors to me.

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToDestination(dLeft, dTop, dWidth, dHeight, iDestID, iOptions)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToDestination"} ,"__sl__sl__f8__f8__f8__f8__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,iDestID,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompareOutlines(iFirstOutlineID, iSecondOutlineID)
return 0 # FpQCall( {::_hdll_,"QuickPDFCompareOutlines"} ,"__sl__sl__sl__sl",::_id_,iFirstOutlineID,iSecondOutlineID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetPageBox(iFileHandle, iPageRef, iBoxIndex, dX1, dY1, dX2, dY2)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetPageBox"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iFileHandle,iPageRef,iBoxIndex,dX1,dY1,dX2,dY2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestName(iDestID)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"QuickPDFGetDestName"} ,"__pt__sl__sl",::_id_,iDestID)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontEncoding()
return FpQCall( {::_hdll_,"QuickPDFGetFontEncoding"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineObjectNumber(iOutlineID)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineObjectNumber"} ,"__sl__sl__sl",::_id_,iOutlineID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetRenderScale()
return FpQCall( {::_hdll_,"QuickPDFGetRenderScale"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewDestination(iDestPage, iZoom, iDestType, dLeft, dTop, dRight, dBottom)
return FpQCall( {::_hdll_,"QuickPDFNewDestination"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iDestPage,iZoom,iDestType,dLeft,dTop,dRight,dBottom)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewNamedDestination(sDestName, iDestID)
   sDestName := ::ForceAnsi(sDestName)
return FpQCall( {::_hdll_,"QuickPDFNewNamedDestination"} ,"__sl__sl__pt__sl",::_id_,sDestName,iDestID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFindImagesMode(iNewFindImagesMode)
return FpQCall( {::_hdll_,"QuickPDFSetFindImagesMode"} ,"__sl__sl__sl",::_id_,iNewFindImagesMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageResolution(iHorizontal, iVertical, iUnits)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetImageResolution"} ,"__sl__sl__sl__sl__sl",::_id_,iHorizontal,iVertical,iUnits)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineNamedDestination(iOutlineID, sDestName)
   sDestName := ::ForceAnsi(sDestName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineNamedDestination"} ,"__sl__sl__sl__pt",::_id_,iOutlineID,sDestName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineRemoteDestination(iOutlineID, sFileName, iOpenPage, iZoom, iDestType, dPntLeft, dPntTop, dPntRight, dPntBottom, iNewWindow)
   sFileName := ::ForceAnsi(sFileName)
   sFileName := ::PathFormatPdf(sFileName)
return FpQCall( {::_hdll_,"QuickPDFSetOutlineRemoteDestination"} ,"__sl__sl__sl__pt__sl__sl__sl__f8__f8__f8__f8__sl",::_id_,iOutlineID,sFileName,iOpenPage,iZoom,iDestType,dPntLeft,dPntTop,dPntRight,dPntBottom,iNewWindow)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOverprint(iStrokingOverprint, iOtherOverprint, iOverprintMode)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOverprint"} ,"__sl__sl__sl__sl__sl",::_id_,iStrokingOverprint,iOtherOverprint,iOverprintMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderDCOffset(iNewOffsetX, iNewOffsetY)
return FpQCall( {::_hdll_,"QuickPDFSetRenderDCOffset"} ,"__sl__sl__sl__sl",::_id_,iNewOffsetX,iNewOffsetY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderScale(dNewScale)
return FpQCall( {::_hdll_,"QuickPDFSetRenderScale"} ,"__sl__sl__f8",::_id_,dNewScale)

**********************************************************************************************************************
// neu in 7.21 - PowerBasic INC    7.21
**********************************************************************************************************************

*** Die meisten Funktionen habe ich noch nie benutzt, daher auch nicht getestet, bitte melden Sie mir Fehler.
*** I don't need many of the new functions, so I did not test them. Please eMail errors to me.

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTextMarkupAnnotation(iMarkupType, dLeft, dTop, dWidth, dHeight)
return FpQCall({::_hdll_,"QuickPDFAddTextMarkupAnnotation"},"__sl__sl__sl__f8__f8__f8__f8",::_id_,iMarkupType, dLeft, dTop, dWidth, dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearImage(iImageID)                                                        // *HB* return .t. / .f.
return 0 # FpQCall({::_hdll_,"QuickPDFClearImage"},"__sl__sl__sl",::_id_,iImageID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetAnnotationCount(iFileHandle,iPageRef)
return FpQCall({::_hdll_,"QuickPDFDAGetAnnotationCount"},"__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionDest(iActionID)
return FpQCall({::_hdll_,"QuickPDFGetActionDest"},"__sl__sl__sl",::_id_,iActionID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionURL(iActionID)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetActionURL"} ,"__pt__sl__sl",::_id_,iActionID)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotDest(iIndex)
return FpQCall({::_hdll_,"QuickPDFGetAnnotDest"},"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotQuadCount(iIndex)
return FpQCall({::_hdll_,"QuickPDFGetAnnotQuadCount"},"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotQuadPoints(iIndex,iQuadNumber,iPointNumber)
return FpQCall({::_hdll_,"QuickPDFGetAnnotQuadCount"},"__f8__sl__sl__sl__sl",::_id_,iIndex,iQuadNumber,iPointNumber)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentFileSize()
return FpQCall({::_hdll_,"QuickPDFGetDocumentFileSize"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldActionID(iIndex,sTriggerEvent)
   DEFAULT iIndex TO 1
   sTriggerEvent := ::ForceAnsi(sTriggerEvent)
return FpQCall({::_hdll_,"QuickPDFGetFormFieldActionID"},"__sl__sl__sl__pt",::_id_,iIndex,sTriggerEvent)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInstalledFontsByCharset( iCharsetIndex, iOptions)
   DEFAULT iCharsetIndex TO 2 // default Charset=2, ANSI=1 ??
   DEFAULT iOptions      TO 1 // CSV Rckgabe
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetInstalledFontsByCharset"} ,"__pt__sl__sl__sl",::_id_,iCharsetIndex, iOptions)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInstalledFontsByCodePage( iCodePage, iOptions )
   DEFAULT iCodePage TO 1252
   DEFAULT iOptions      TO 1 // CSV Rckgabe
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetInstalledFontsByCodePage"} ,"__pt__sl__sl__sl",::_id_,iCodePage, iOptions)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMaxObjectNumber()
return FpQCall({::_hdll_,"QuickPDFGetMaxObjectNumber"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigCount()
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigCount"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderCount(iOptionalContentConfigID)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigOrderCount"},"__sl__sl__sl",::_id_,iOptionalContentConfigID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemID(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigOrderItemID"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemLabel(iOptionalContentConfigID, iItemIndex)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOptionalContentConfigOrderItemLabel"} ,"__pt__sl__sl__sl",::_id_,iOptionalContentConfigID, iItemIndex)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemLevel(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigOrderItemLevel"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemType(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigOrderItemType"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigState(iOptionalContentConfigID,iOptionalContentGroupID)
return FpQCall({::_hdll_,"QuickPDFGetOptionalContentConfigState"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveXFAEntries(iOptions)
   DEFAULT iOptions TO 0 // PDF ->  Reserved for future use, should be set to 0.
return FpQCall({::_hdll_,"QuickPDFRemoveXFAEntries"},"__sl__sl__sl",::_id_,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetActionURL(iActionID, sNewURL)                                            // *HB* return .t. / .f.
   sNewURL := ::ForceAnsi(sNewURL)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetActionURL"} ,"__sl__sl__sl__pt",::_id_,iActionID, sNewURL)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotQuadPoints(iIndex, iQuadNumber,dX1,dY1,dX2,dY2,dX3,dY3,dX4,dY4)     // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetAnnotQuadPoints"} ,"__sl__sl__sl__f8__f8__f8__f8__f8__f8__f8__f8",::_id_,iIndex,;
                                                     iQuadNumber,dX1,dY1,dX2,dY2,dX3,dY3,dX4,dY4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionWordGap(dNewWordGap)                                       // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextExtractionWordGap"} ,"__sl__sl__f8",::_id_,dNewWordGap)


**********************************************************************************************************************
// from TQuickPdf wrapper class    7.19
**********************************************************************************************************************

*** Viele dieser Funktionen habe ich noch nie benutzt, daher auch nicht getestet, bitte melden Sie mir Fehler.
*** Pablo's TQuickPdf Klasse stellt jedoch die richtige Parameter definition sicher.
*** I don't need many of these functions, so I did not test them. Please eMail errors to me.
*** Pablo's TQuickPdf class defines the correct parameter count and interface.

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToLocalFile(nLeft, nTop, nWidth, nHeight, FileName, nOptions)
   FileName := ::ForceUTF8(FileName)
return FpQCall({::_hdll_,"QuickPDFAddLinkToLocalFile"},"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, FileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImagePageCountFromString(p1)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // 1 param => 2 OK !
return ::_ptb_free_(FpQCall({::_hdll_,"QuickPDFGetImagePageCountFromString"},"__sl__sl__pt",::_id_,::_b(p1,ptb,1)),ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveEmbeddedFile(p1)                                                      // *HB* return .t. / .f.
return 0 # FpQCall({::_hdll_,"QuickPDFRemoveEmbeddedFile"},"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveGlobalJavaScript(PackageName)                                         // *HB* return .t. / .f.
   PackageName := ::ForceAnsi(PackageName)
return 0 # FpQCall({::_hdll_,"QuickPDFRemoveGlobalJavaScript"},"__sl__sl__pt",::_id_,PackageName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RequestPrinterStatus(p1)
return FpQCall({::_hdll_,"QuickPDFRequestPrinterStatus"},"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                           // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return FpQCall({::_hdll_,"QuickPDFSetAnnotBorderColor"},"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCompatibility(p1,p2)                                                     // *HB* return .t. / .f.
return 0 # FpQCall({::_hdll_,"QuickPDFSetCompatibility"},"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetEmbeddedFileStrProperty(nIndex, nTag, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return FpQCall({::_hdll_,"QuickPDFSetEmbeddedFileStrProperty"},"__sl__sl__sl__sl__pt",::_id_,nIndex, nTag, sNewValue)

**********************************************************************************************************************
// from TQuickPdf wrapper class    7.18
**********************************************************************************************************************

*** Viele dieser Funktionen habe ich noch nie benutzt, daher auch nicht getestet, bitte melden Sie mir Fehler.
*** Pablo's TQuickPdf Klasse stellt jedoch die richtige Parameter definition sicher.
*** I don't need many of these functions, so I did not test them. Please eMail errors to me.
*** Pablo's TQuickPdf class defines the correct parameter count and interface.

METHOD HBPrintPDF:AddArcToPath(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFAddArcToPath"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddCJKFont(p1)
return FpQCall( {::_hdll_,"QuickPDFAddCJKFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddCurveToPath(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFAddCurveToPath"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddEmbeddedFile(FileName,MIMEType)
   FileName := ::ForceUTF8(FileName)
   MIMEType := ::ForceAnsi(MIMEType)
return FpQCall( {::_hdll_,"QuickPDFAddEmbeddedFile"} ,"__sl__sl__pt__pt",::_id_,FileName,MIMEType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFileAttachment(sTitle, nEmbeddedFileID)                                  // *HB* return .t. / .f.
   sTitle := ::ForceAnsi(sTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddFileAttachment"} ,"__sl__sl__pt__sl",::_id_,sTitle, nEmbeddedFileID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFormFieldSub(nI,SubName)
   SubName := ::ForceUTF8(SubName)
return FpQCall( {::_hdll_,"QuickPDFAddFormFieldSub"} ,"__sl__sl__sl__pt",::_id_,nI,SubName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFormFont(p1)
return FpQCall( {::_hdll_,"QuickPDFAddFormFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddGlobalJavaScript(PackageName,JavaScript)                                 // *HB* return .t. / .f.
   PackageName := ::ForceUTF8(PackageName)
   JavaScript  := ::ForceUTF8(JavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddGlobalJavaScript"} ,"__sl__sl__pt__pt",::_id_,PackageName,JavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromFile(FileName,nOptions)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFAddImageFromFile"} ,"__sl__sl__pt__sl",::_id_,FileName,nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromFileOffset(FileName,nOffset,nDataLength,nOptions)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFAddImageFromFileOffset"} ,"__sl__sl__pt__sl__sl__sl",::_id_,FileName,nOffset,nDataLength,nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromString(p1,p2)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // 2 param => 3 OK !
return ::_ptb_free_(FpQCall({::_hdll_,"QuickPDFAddImageFromString"},"__sl__sl__pt__sl",::_id_,::_b(p1,ptb,1),p2),ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLGIDictToPage(sDictContent)                                              // *HB* return .t. / .f.
   sDictContent := ::ForceAnsi(sDictContent)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLGIDictToPage"} ,"__sl__sl__pt",::_id_,sDictContent)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLineToPath(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFAddLineToPath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToEmbeddedFile(nLeft, nTop, nWidth, nHeight, nEmbeddedFileID, sTitle, nOptions) // *HB* return .t. / .f.
   sTitle := ::ForceAnsi(sTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToEmbeddedFile"} ,"__sl__sl__f8__f8__f8__f8__sl__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, nEmbeddedFileID, sTitle, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToFile(nLeft, nTop, nWidth, nHeight, FileName, nPage, nPosition, nNewWindow, nOptions) // *HB* return .t. / .f.  DOKU ?
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToFile"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__f8__sl__sl",::_id_,;
                                       nLeft, nTop, nWidth, nHeight, FileName, nPage, nPosition, nNewWindow, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToJavaScript(nLeft, nTop, nWidth, nHeight, JavaScript, nOptions)     // *HB* return .t. / .f.  DOKU ?
   JavaScript := ::ForceUTF8(JavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToJavaScript"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, JavaScript, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToPage(p1,p2,p3,p4,p5,p6,p7)                                         // *HB* return .t. / .f.  DOKU ?
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToPage"} ,"__sl__sl__f8__f8__f8__f8__sl__f8__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToWeb(nLeft, nTop, nWidth, nHeight, sLink, nOptions)           // *HB* return .t. / .f.  DOKU ?
   sLink := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddLinkToWeb"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sLink, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddNoteAnnotation(nLeft, nTop, nAnnotType, nPopupLeft, nPopupTop, nPopupWidth,;
                                    nPopupHeight, sTitle, sContents, nRed, nGreen, nBlue, nOpen)  // *HB* return .t. / .f.  DOKU ?
   sTitle    := ::ForceAnsi(sTitle)
   sContents := ::ForceAnsi(sContents)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddNoteAnnotation"} ,"__sl__sl__f8__f8__sl__f8__f8__f8__f8__pt__pt__f8__f8__f8__sl",::_id_,;
                                    nLeft, nTop, nAnnotType, nPopupLeft, nPopupTop, nPopupWidth,;
                                    nPopupHeight, sTitle, sContents, nRed, nGreen, nBlue, nOpen)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddPageLabels(nStart, nStyle, nOffset, Prefix)                              // *HB* return .t. / .f.  DOKU ?
   Prefix := ::ForceUTF8(Prefix)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddPageLabels"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nStart, nStyle, nOffset, Prefix)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSeparationColor(sColorName, nC, nM, nY, nK, nOptions)                    // *HB* return .t. / .f.  DOKU ?
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFAddSeparationColor"} ,"__sl__sl__pt__f8__f8__f8__f8__sl",::_id_,sColorName, nC, nM, nY, nK, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddStandardFont(p1)
return FpQCall( {::_hdll_,"QuickPDFAddStandardFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSubsettedFont(sFontName, nCharsetIndex, sSubsetChars)
   sFontName    := ::ForceAnsi(sFontName)
   sSubsetChars := ::ForceAnsi(sSubsetChars)
return FpQCall( {::_hdll_,"QuickPDFAddSubsettedFont"} ,"__sl__sl__pt__sl__pt",::_id_,sFontName, nCharsetIndex, sSubsetChars)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSVGAnnotationFromFile(nLeft, nTop, nWidth, nHeight, FileName, nOptions)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFAddSVGAnnotationFromFile"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, FileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddToBuffer(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFAddToBuffer"} ,"__sl__sl__pt__pt__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddToFileList(ListName,FileName)
   ListName := ::ForceAnsi(ListName)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFAddToFileList"} ,"__sl__sl__pt__pt",::_id_,ListName,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeFont(sFontName, nEmbed)
   sFontName := ::ForceAnsi(sFontName)
return FpQCall( {::_hdll_,"QuickPDFAddTrueTypeFont"} ,"__sl__sl__pt__sl",::_id_,sFontName, nEmbed)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeFontFromFile(FileName)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFAddTrueTypeFontFromFile"} ,"__sl__sl__pt",::_id_,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddType1Font(FileName)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFAddType1Font"} ,"__sl__sl__pt",::_id_,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddU3DAnnotationFromFile(nLeft, nTop, nWidth, nHeight, FileName, nOptions)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFAddU3DAnnotationFromFile"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, FileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AnalyseFile(FileName, Password)
   FileName := ::ForceUTF8(FileName)
   Password := ::ForceAnsi(Password)
return FpQCall( {::_hdll_,"QuickPDFAnalyseFile"} ,"__sl__sl__pt__pt",::_id_,FileName, Password)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AnnotationCount()
return FpQCall( {::_hdll_,"QuickPDFAnnotationCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendSpace(p1)
return FpQCall( {::_hdll_,"QuickPDFAppendSpace"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendTableColumns(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFAppendTableColumns"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendTableRows(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFAppendTableRows"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendText(sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFAppendText"} ,"__sl__sl__pt",::_id_,sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ApplyStyle(sStyleName)                                                      // *HB* return .t. / .f.
   sStyleName := ::ForceAnsi(sStyleName)
return 0 # FpQCall( {::_hdll_,"QuickPDFApplyStyle"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AttachAnnotToForm(p1)                                                       // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFAttachAnnotToForm"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:BeginPageUpdate()
return FpQCall( {::_hdll_,"QuickPDFBeginPageUpdate"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CapturePage(p1)
return FpQCall( {::_hdll_,"QuickPDFCapturePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CapturePageEx(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFCapturePageEx"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CharWidth(p1)
return FpQCall( {::_hdll_,"QuickPDFCharWidth"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckObjects()
return FpQCall( {::_hdll_,"QuickPDFCheckObjects"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckPageAnnots()
return FpQCall( {::_hdll_,"QuickPDFCheckPageAnnots"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearFileList(sListName)                                                    // *HB* return .t. / .f.
   sListName := ::ForceAnsi(sListName)
return 0 # FpQCall( {::_hdll_,"QuickPDFClearFileList"} ,"__sl__sl__pt",::_id_,sListName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearPageLabels()
return FpQCall( {::_hdll_,"QuickPDFClearPageLabels"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearTextFormatting()
return FpQCall( {::_hdll_,"QuickPDFClearTextFormatting"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CloneOutlineAction(p1)
return FpQCall( {::_hdll_,"QuickPDFCloneOutlineAction"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClonePages(p1,p2,p3)                                                        // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFClonePages"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CloseOutline(p1)                                                            // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFCloseOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClosePath()
return FpQCall( {::_hdll_,"QuickPDFClosePath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CombineLayers()                                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFCombineLayers"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressContent()                                                           // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFCompressContent"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressFonts(p1)                                                           // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFCompressFonts"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressImages(p1)                                                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFCompressImages"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressPage()                                                              // *HB* return .t. / .f. DOKU ?
return 0 # FpQCall( {::_hdll_,"QuickPDFCompressPage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CopyPageRanges(nDocumentID,sRangeList)                                      // *HB* return .t. / .f.
   sRangeList := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"QuickPDFCopyPageRanges"} ,"__sl__sl__sl__pt",::_id_,nDocumentID,sRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateBuffer(p1)
return FpQCall({::_hdll_,"QuickPDFCreateBuffer"},"__pt__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateTable(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFCreateTable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAAppendFile(p1)
return FpQCall( {::_hdll_,"QuickPDFDAAppendFile"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACapturePage(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDACapturePage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACapturePageEx(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFDACapturePageEx"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACloseFile(p1)                                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDACloseFile"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DADrawCapturedPage(p1,p2,p3,p4,p5,p6,p7)                                    // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDADrawCapturedPage"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAExtractPageText(p1,p2,p3)
Return ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAExtractPageText"} ,"__pt__sl__sl__sl__sl",::_id_,p1,p2,p3)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAFindPage(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAFindPage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldCount(p1)
return FpQCall( {::_hdll_,"QuickPDFDAGetFormFieldCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldTitle(p1,p2)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetFormFieldTitle"} ,"__pt__sl__sl__sl",::_id_,p1,p2)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldValue(p1,p2)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetFormFieldValue"} ,"__pt__sl__sl__sl",::_id_,p1,p2)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageDataToString(p1,p2,p3)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetImageDataToString"} ,"__pt__sl__sl__sl__sl",::_id_,p1,p2,p3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageDblProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFDAGetImageDblProperty"} ,"__f8__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageIntProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFDAGetImageIntProperty"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageListCount(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAGetImageListCount"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetInformation(nFileHandle, sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetInformation"} ,"__pt__sl__sl__pt",::_id_,nFileHandle, sKey)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetObjectCount(p1)
return FpQCall( {::_hdll_,"QuickPDFDAGetObjectCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetObjectSource(p1,p2)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetObjectSource"} ,"__pt__sl__sl__sl",::_id_,p1,p2))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageContent(p1,p2)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDAGetPageContent"} ,"__pt__sl__sl__sl",::_id_,p1,p2))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageCount(p1)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageHeight(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageHeight"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageImageList(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageImageList"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageWidth(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAGetPageWidth"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAHidePage(p1,p2)                                                           // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDAHidePage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAMovePage(p1,p2,p3,p4)                                                     // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDAMovePage"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DANewPage(p1)
return FpQCall( {::_hdll_,"QuickPDFDANewPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DANewPages(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDANewPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAOpenFile(FileName, cPassword)
   FileName := ::ForceUTF8(FileName)
   cPassword := ::ForceAnsi(cPassword)
return FpQCall( {::_hdll_,"QuickPDFDAOpenFile"} ,"__sl__sl__pt__pt",::_id_,FileName, cPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAOpenFileReadOnly(FileName, cPassword)
   FileName := ::ForceUTF8(FileName)
   cPassword := ::ForceAnsi(cPassword)
return FpQCall( {::_hdll_,"QuickPDFDAOpenFileReadOnly"} ,"__sl__sl__pt__pt",::_id_,FileName, cPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAPageRotation(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFDAPageRotation"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToDC(p1,p2,p3,p4)                                               // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDARenderPageToDC"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToFile(nFileHandle, nPageRef, nOptions, nDPI, FileName)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFDARenderPageToFile"} ,"__sl__sl__sl__sl__sl__sl__pt",::_id_,nFileHandle, nPageRef, nOptions, nDPI, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToString(p1,p2,p3,p4)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFDARenderPageToString"} ,"__pt__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARotatePage(p1,p2,p3,p4)                                                   // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDARotatePage"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASaveAsFile(nFileHandle, FileName)                                         // *HB* return .t. / .f.
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASaveAsFile"} ,"__sl__sl__sl__pt",::_id_,nFileHandle, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASaveImageDataToFile(nFileHandle, nImageListID, nImageIndex, FileName)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFDASaveImageDataToFile"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nFileHandle, nImageListID, nImageIndex, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetInformation(nFileHandle, cKey, NewValue)                               // *HB* return .t. / .f.
   cKey     := ::ForceAnsi(cKey)
   NewValue := ::ForceUTF8(NewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetInformation"} ,"__sl__sl__sl__pt__pt",::_id_,nFileHandle, cKey, NewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetPageSize(p1,p2,p3,p4)                                                  // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDASetPageSize"} ,"__sl__sl__sl__sl__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Decrypt()                                                                   // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDecrypt"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DecryptFile(InputFileName, OutputFileName, cPassword)                       // *HB* return .t. / .f.
   InputFileName  := ::ForceUTF8(InputFileName)
   OutputFileName := ::ForceUTF8(OutputFileName)
   cPassword      := ::ForceAnsi(cPassword)
return 0 # FpQCall( {::_hdll_,"QuickPDFDecryptFile"} ,"__sl__sl__pt__pt__pt",::_id_,InputFileName, OutputFileName, cPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteAnalysis(p1)                                                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteAnalysis"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteAnnotation(p1)                                                        // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteAnnotation"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteFormField(p1)                                                         // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteLayer()                                                               // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteLayer"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteOptionalContentGroup(p1)                                              // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDeleteOptionalContentGroup"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeletePageLGIDict(p1)                                                       // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDeletePageLGIDict"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeletePages(p1,p2)                                                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDeletePages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DocJavaScriptAction(cActionType,JavaScript)                                 // *HB* return .t. / .f.
   cActionType := ::ForceAnsi(cActionType)
   JavaScript  := ::ForceUTF8(JavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFDocJavaScriptAction"} ,"__sl__sl__pt__pt",::_id_,cActionType,JavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DocumentCount()
return FpQCall( {::_hdll_,"QuickPDFDocumentCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawArc(p1,p2,p3,p4,p5,p6,p7)                                               // *HB* return .t. / .f.
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawArc"} ,"__sl__sl__f8__f8__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawBarcode(nLeft, nTop, nWidth, nHeight, sText, nBarcode, nOptions)        // *HB* return .t. / .f.
   sText := ::ForceAnsi(sText)
   if nBarcode == 2 // EAN13
      if len(sText)==12
         sText += ::CalcCheckDigit(sText)
      endif
   endif
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawBarcode"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nBarcode, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawBox(p1,p2,p3,p4,p5)                                                     // *HB* return .t. / .f.
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawBox"} ,"__sl__sl__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawCapturedPage(p1,p2,p3,p4,p5)                                            // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawCapturedPage"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawCircle(p1,p2,p3,p4)                                                     // *HB* return .t. / .f.
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawCircle"} ,"__sl__sl__f8__f8__f8__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawDataMatrixSymbol(nLeft, nTop, nModuleSize, sText, nEncoding, nSymbolSize, nOptions)  // *HB* return .t. / .f.
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawDataMatrixSymbol"} ,"__sl__sl__f8__f8__f8__pt__sl__sl__sl",::_id_,nLeft, nTop, nModuleSize, sText, nEncoding, nSymbolSize, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawEllipse(p1,p2,p3,p4,p5)                                                 // *HB* return .t. / .f.
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawEllipse"} ,"__sl__sl__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawEllipticArc(p1,p2,p3,p4,p5,p6,p7,p8)                                    // *HB* return .t. / .f.
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawEllipticArc"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawHTMLText(nLeft, nTop, nWidth, sHTMLText)                                // *HB* return .t. / .f.
   sHTMLText := ::ForceAnsi(sHTMLText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawHTMLText"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nLeft, nTop, nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawHTMLTextBox(nLeft, nTop, nWidth, nHeight, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFDrawHTMLTextBox"} ,"__pt__sl__f8__f8__f8__f8__pt",::_id_,nLeft, nTop, nWidth, nHeight, sHTMLText)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImage(p1,p2,p3,p4)                                                      // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawImage"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawLine(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFDrawLine"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawMultiLineText(nXPos, nYPos, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawMultiLineText"} ,"__sl__sl__f8__f8__pt__pt",::_id_,nXPos, nYPos, sDelimiter, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPath(p1)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"QuickPDFDrawPath"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPathEvenOdd(p1)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"QuickPDFDrawPathEvenOdd"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPostScriptXObject(p1)                                                   // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawPostScriptXObject"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedCapturedPage(p1,p2,p3,p4,p5,p6)                                  // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawRotatedCapturedPage"} ,"__sl__sl__sl__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedImage(p1,p2,p3,p4,p5)                                            // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawRotatedImage"} ,"__sl__sl__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedText(nXPos, nYPos, nAngle, sText)                                // *HB* return .t. / .f.
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawRotatedText"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nAngle, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedTextBox(nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawRotatedTextBox"} ,"__sl__sl__f8__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRoundedBox(p1,p2,p3,p4,p5,p6)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"QuickPDFDrawRoundedBox"} ,"__sl__sl__f8__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawScaledImage(p1,p2,p3)                                                   // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawScaledImage"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawSpacedText(nXPos, nYPos, nSpacing, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawSpacedText"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nSpacing, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTableRows(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFDrawTableRows"} ,"__f8__sl__sl__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawText(nXPos, nYPos, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawText"} ,"__sl__sl__f8__f8__pt",::_id_,nXPos, nYPos, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTextArc(nXPos, nYPos, nRadius, nAngle, sText, nDrawOptions)             // *HB* return .t. / .f.
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFDrawTextArc"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nXPos, nYPos, nRadius, nAngle, sText, nDrawOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTextBox(nLeft, nTop, nWidth, nHeight, sText, nOptions)                  // *HB*
       local nPrintedLines
       ::DrawTextBoxNextTop := nTop
       sText := ::ForceAnsi(sText)
       nPrintedLines := FpQCall( {::_hdll_,"QuickPDFDrawTextBox"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nOptions)
       ::DrawTextBoxNextTop += ::LineFeed(nPrintedLines)
return nPrintedLines
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawWrappedText(nXPos, nYPos, nWidth, sText)
       sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFDrawWrappedText"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EditableLayer()                                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFEditableLayer"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EmbeddedFileCount()
return FpQCall( {::_hdll_,"QuickPDFEmbeddedFileCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EmbedFile(cTitle, FileName, cMIMEType)                                      // *HB* return .t. / .f.
   cTitle    := ::ForceAnsi(cTitle)
   FileName  := ::ForceUTF8(FileName)
   cMIMEType := ::ForceAnsi(cMIMEType)
return 0 # FpQCall( {::_hdll_,"QuickPDFEmbedFile"} ,"__sl__sl__pt__pt__pt",::_id_,cTitle, FileName, cMIMEType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncapsulateLayer()
return FpQCall( {::_hdll_,"QuickPDFEncapsulateLayer"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncodePermissions(p1,p2,p3,p4,p5,p6,p7,p8)
return FpQCall( {::_hdll_,"QuickPDFEncodePermissions"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Encrypt(sOwner, sUser, nStrength, nPermissions)                             // *HB* return .t. / .f.
   sOwner := ::ForceAnsi(sOwner)
   sUser  := ::ForceAnsi(sUser)
return 0 # FpQCall( {::_hdll_,"QuickPDFEncrypt"} ,"__sl__sl__pt__pt__sl__sl",::_id_,sOwner, sUser, nStrength, nPermissions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptFile(InputFileName, OutputFileName, cOwner, cUser, nStrength, nPermissions) // *HB* return .t. / .f.
   InputFileName  := ::ForceUTF8(InputFileName)
   OutputFileName := ::ForceUTF8(OutputFileName)
   cOwner         := ::ForceAnsi(cOwner)
   cUser          := ::ForceAnsi(cUser)
return 0 # FpQCall( {::_hdll_,"QuickPDFEncryptFile"} ,"__sl__sl__pt__pt__pt__pt__sl__sl",::_id_,InputFileName, OutputFileName, cOwner, cUser, nStrength, nPermissions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionAlgorithm()
return FpQCall( {::_hdll_,"QuickPDFEncryptionAlgorithm"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionStatus()
return FpQCall( {::_hdll_,"QuickPDFEncryptionStatus"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionStrength()
return FpQCall( {::_hdll_,"QuickPDFEncryptionStrength"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptWithFingerprint(sFingerprint)                                        // *HB* return .t. / .f.
   sFingerprint := ::ForceAnsi(sFingerprint)
return 0 # FpQCall( {::_hdll_,"QuickPDFEncryptWithFingerprint"} ,"__sl__sl__pt",::_id_,sFingerprint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EndPageUpdate()
return FpQCall( {::_hdll_,"QuickPDFEndPageUpdate"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePageContent(FileName,cPassword,nPage)
   FileName  := ::ForceUTF8(FileName)
   cPassword := ::ForceAnsi(cPassword)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFExtractFilePageContent"} ,"__pt__sl__pt__pt__sl",::_id_,FileName,cPassword,nPage))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePages(InputFileName, OutputFileName, cRangeList)                 // *HB* return .t. / .f.
   InputFileName  := ::ForceUTF8(InputFileName)
   OutputFileName := ::ForceUTF8(OutputFileName)
   cRangeList     := ::ForceAnsi(cRangeList)
return 0 # FpQCall( {::_hdll_,"QuickPDFExtractFilePages"} ,"__sl__sl__pt__pt__pt",::_id_, InputFileName, OutputFileName, cRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePageText(FileName, cPassword, nPage, nOptions)
   FileName  := ::ForceUTF8(FileName)
   cPassword := ::ForceAnsi(cPassword)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFExtractFilePageText"} ,"__pt__sl__pt__pt__sl__sl",::_id_,FileName, cPassword, nPage, nOptions)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractPageRanges(sRangeList)                                     // *HB* return .t. / .f.
   sRangeList := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"QuickPDFExtractPageRanges"} ,"__sl__sl__pt",::_id_,sRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractPages(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFExtractPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FileListCount(sListName)
   sListName := ::ForceAnsi(sListName)
return FpQCall( {::_hdll_,"QuickPDFFileListCount"} ,"__sl__sl__pt",::_id_,sListName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FileListItem(sListName, nIndex)
   sListName := ::ForceAnsi(sListName)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFFileListItem"} ,"__pt__sl__pt__sl",::_id_,sListName, nIndex)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindFonts()
return FpQCall( {::_hdll_,"QuickPDFFindFonts"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindFormFieldByTitle(Title)
   Title := ::ForceUTF8(Title)
return FpQCall( {::_hdll_,"QuickPDFFindFormFieldByTitle"} ,"__sl__sl__pt",::_id_,Title)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindImages()
return FpQCall( {::_hdll_,"QuickPDFFindImages"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitImage(p1,p2,p3,p4,p5,p6,p7)                                              // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFFitImage"} ,"__sl__sl__f8__f8__f8__f8__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitRotatedTextBox(nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)    // *HB* return .t. / .f.
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFFitRotatedTextBox"} ,"__sl__sl__f8__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitTextBox(nLeft, nTop, nWidth, nHeight, sText, nOptions)                   // *HB* return .t. / .f.
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"QuickPDFFitTextBox"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FlattenFormField(p1)                                                        // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFFlattenFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontCount()
return FpQCall( {::_hdll_,"QuickPDFFontCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontFamily()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFFontFamily"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontHasKerning()                                                            // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFFontHasKerning"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontName()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFFontName"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontReference()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFFontReference"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontSize()
return FpQCall( {::_hdll_,"QuickPDFFontSize"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontType()
return FpQCall( {::_hdll_,"QuickPDFFontType"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldCount()
return FpQCall( {::_hdll_,"QuickPDFFormFieldCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldHasParent(p1)
return FpQCall( {::_hdll_,"QuickPDFFormFieldHasParent"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldJavaScriptAction(nIndex, cActionType, JavaScript)                  // *HB* return .t. / .f.
   cActionType := ::ForceAnsi(cActionType)
   JavaScript  := ::ForceUTF8(JavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFFormFieldJavaScriptAction"} ,"__sl__sl__sl__pt__pt",::_id_,nIndex, cActionType, JavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldWebLinkAction(nIndex, sActionType, sLink)                          // *HB* return .t. / .f.
   sActionType := ::ForceAnsi(sActionType)
   sLink       := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"QuickPDFFormFieldWebLinkAction"} ,"__sl__sl__sl__pt__pt",::_id_,nIndex, sActionType, sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionType(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetActionType"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnalysisInfo(p1,p2)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetAnalysisInfo"} ,"__pt__sl__sl__sl",::_id_,p1,p2)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotActionID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetAnnotActionID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotDblProperty(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetAnnotDblProperty"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotIntProperty(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetAnnotIntProperty"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotStrProperty(p1,p2)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetAnnotStrProperty"} ,"__pt__sl__sl__sl",::_id_,p1,p2)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetBarcodeWidth(nNominalWidth, sText, nBarcode)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFGetBarcodeWidth"} ,"__f8__sl__f8__pt__sl",::_id_,nNominalWidth, sText, nBarcode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCanvasDC(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetCanvasDC"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCatalogInformation(sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetCatalogInformation"} ,"__pt__sl__pt",::_id_,sKey)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCustomInformation(sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetCustomInformation"} ,"__pt__sl__pt",::_id_,sKey)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCustomKeys(nLocation)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetCustomKeys"} ,"__pt__sl__sl",::_id_,nLocation)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDefaultPrinterName()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDefaultPrinterName"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestPage(p1)
return FpQCall( {::_hdll_,"QuickPDFGetDestPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestType(p1)
return FpQCall( {::_hdll_,"QuickPDFGetDestType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestValue(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetDestValue"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocJavaScript(sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocJavaScript"} ,"__pt__sl__pt",::_id_,sActionType)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentFileName()
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocumentFileName"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetDocumentID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentIdentifier(p1,p2)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocumentIdentifier"} ,"__pt__sl__sl__sl",::_id_,p1,p2)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentMetadata()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocumentMetadata"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentResourceList()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetDocumentResourceList"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileContentToFile(nIndex, FileName)                              // *HB* return .t. / .f.
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileContentToFile"} ,"__sl__sl__sl__pt",::_id_,nIndex, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileContentToString(p1)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileContentToString"} ,"__pt__sl__sl",::_id_,p1))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileIntProperty(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileIntProperty"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileStrProperty(p1,p2)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetEmbeddedFileStrProperty"} ,"__pt__sl__sl__sl",::_id_,p1,p2)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEncryptionFingerprint()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetEncryptionFingerprint"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFileMetadata(FileName)
   FileName := ::ForceUTF8(FileName)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFileMetadata"} ,"__pt__sl__pt",::_id_,FileName)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFirstChildOutline(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFirstChildOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFirstOutline()
return FpQCall( {::_hdll_,"QuickPDFGetFirstOutline"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFontID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontObjectNumber()
return FpQCall( {::_hdll_,"QuickPDFGetFontObjectNumber"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldAlignment(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldAlignment"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldAnnotFlags(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldAnnotFlags"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBackgroundColor(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBackgroundColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderColor(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBorderColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderProperty(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBorderProperty"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderStyle(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBorderStyle"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBound(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldBound"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldCaption(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldCaption"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldChildTitle(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldChildTitle"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldChoiceType(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldChoiceType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldColor(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldComb(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldComb"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldDefaultValue(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldDefaultValue"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldDescription(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldDescription"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldFlags(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldFlags"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldFontName(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldFontName"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldJavaScript(nIndex, sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldJavaScript"} ,"__pt__sl__sl__pt",::_id_,nIndex, sActionType)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldKidCount(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldKidCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldMaxLen(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldMaxLen"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldPage(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldPrintable(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldPrintable"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldReadOnly(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldReadOnly"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldRotation(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldRotation"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubCount(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldSubCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubName(p1,p2)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldSubName"} ,"__pt__sl__sl__sl",::_id_,p1,p2)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubTempIndex(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldSubTempIndex"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTabOrder(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldTabOrder"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTextFlags(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldTextFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTextSize(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldTextSize"} ,"__f8__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTitle(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldTitle"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldType(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldValue(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldValue"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldValueByTitle(Title)
   Title := ::ForceUTF8(Title)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldValueByTitle"} ,"__pt__sl__pt",::_id_,Title)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldVisible(p1)
return FpQCall( {::_hdll_,"QuickPDFGetFormFieldVisible"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldWebLink(nIndex, sActionType)
   sActionType := ::ForceAnsi(sActionType)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFieldWebLink"} ,"__pt__sl__sl__pt",::_id_,nIndex, sActionType)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFontCount()
return FpQCall( {::_hdll_,"QuickPDFGetFormFontCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFontName(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetFormFontName"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetGlobalJavaScript(PackageName)
   PackageName := ::ForceUTF8(PackageName)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetGlobalJavaScript"} ,"__pt__sl__pt",::_id_,PackageName)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextHeight(nWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"QuickPDFGetHTMLTextHeight"} ,"__f8__sl__f8__pt",::_id_,nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextLineCount(nWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"QuickPDFGetHTMLTextLineCount"} ,"__sl__sl__f8__pt",::_id_,nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextWidth(nMaxWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"QuickPDFGetHTMLTextWidth"} ,"__f8__sl__f8__pt",::_id_,nMaxWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetImageID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImagePageCount(FileName)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFGetImagePageCount"} ,"__sl__sl__pt",::_id_,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInformation(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetInformation"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetKerning(sCharPair)
   sCharPair := ::ForceAnsi(sCharPair)
return FpQCall( {::_hdll_,"QuickPDFGetKerning"} ,"__sl__sl__pt",::_id_,sCharPair)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetNamedDestination(sDestName)
   sDestName := ::ForceAnsi(sDestName)
return FpQCall( {::_hdll_,"QuickPDFGetNamedDestination"} ,"__sl__sl__pt",::_id_,sDestName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetNextOutline(p1)
return FpQCall( {::_hdll_,"QuickPDFGetNextOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetObjectCount()
return FpQCall( {::_hdll_,"QuickPDFGetObjectCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetObjectSource(p1)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetObjectSource"} ,"__pt__sl__sl",::_id_,p1))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOpenActionDestination()
return FpQCall( {::_hdll_,"QuickPDFGetOpenActionDestination"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOpenActionJavaScript()
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOpenActionJavaScript"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOptionalContentGroupID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupName(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOptionalContentGroupName"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOrigin()
return FpQCall( {::_hdll_,"QuickPDFGetOrigin"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineActionID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineActionID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineColor(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineDest(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineDest"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineID(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineJavaScript(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOutlineJavaScript"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineOpenFile(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOutlineOpenFile"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlinePage(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlinePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineStyle(p1)
return FpQCall( {::_hdll_,"QuickPDFGetOutlineStyle"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineWebLink(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetOutlineWebLink"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageBox(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFGetPageBox"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageContent()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageContent"} ,"__pt__sl",::_id_))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageJavaScript(sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageJavaScript"} ,"__pt__sl__pt",::_id_,sActionType)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLabel(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageLabel"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLayout()
return FpQCall( {::_hdll_,"QuickPDFGetPageLayout"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLGIDictContent(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageLGIDictContent"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLGIDictCount()
return FpQCall( {::_hdll_,"QuickPDFGetPageLGIDictCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageMode()
return FpQCall( {::_hdll_,"QuickPDFGetPageMode"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageText(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPageText"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetParentOutline(p1)
return FpQCall( {::_hdll_,"QuickPDFGetParentOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrevOutline(p1)
return FpQCall( {::_hdll_,"QuickPDFGetPrevOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterBins(sPrinterName)                                   // ==> ::GetPrinterBinA(p1) ==> Array
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()
   sPrinterName := ::ForceAnsi(sPrinterName)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPrinterBins"} ,"__pt__sl__pt",::_id_,sPrinterName)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterNames()                                                         // -> ::GetPrinterNameA()  -> Array
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetPrinterNames"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetSubsetString(sInputStr)
   sInputStr := ::ForceAnsi(sInputStr)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetSubsetString"} ,"__pt__sl__pt",::_id_,sInputStr)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellDblProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFGetTableCellDblProperty"} ,"__f8__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellIntProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFGetTableCellIntProperty"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellStrProperty(p1,p2,p3,p4)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetTableCellStrProperty"} ,"__pt__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableColumnCount(p1)
return FpQCall( {::_hdll_,"QuickPDFGetTableColumnCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableLastDrawnRow(p1)
return FpQCall( {::_hdll_,"QuickPDFGetTableLastDrawnRow"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableRowCount(p1)
return FpQCall( {::_hdll_,"QuickPDFGetTableRowCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTempPath()
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetTempPath"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextAscent()
return FpQCall( {::_hdll_,"QuickPDFGetTextAscent"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBound(p1)
return FpQCall( {::_hdll_,"QuickPDFGetTextBound"} ,"__f8__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextDescent()
return FpQCall( {::_hdll_,"QuickPDFGetTextDescent"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextHeight()
return FpQCall( {::_hdll_,"QuickPDFGetTextHeight"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextSize()
return FpQCall( {::_hdll_,"QuickPDFGetTextSize"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextWidth(sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFGetTextWidth"} ,"__f8__sl__pt",::_id_,sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewerPreferences(p1)
return FpQCall( {::_hdll_,"QuickPDFGetViewerPreferences"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedText(nWidth, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetWrappedText"} ,"__pt__sl__f8__pt__pt",::_id_,nWidth, sDelimiter, sText)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextBreakString(nWidth, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetWrappedTextBreakString"} ,"__pt__sl__f8__pt__pt",::_id_,nWidth, sDelimiter, sText)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextHeight(nWidth, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFGetWrappedTextHeight"} ,"__f8__sl__f8__pt",::_id_,nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextLineCount(nWidth, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"QuickPDFGetWrappedTextLineCount"} ,"__sl__sl__f8__pt",::_id_,nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldCount()
return FpQCall( {::_hdll_,"QuickPDFGetXFAFormFieldCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldName(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetXFAFormFieldName"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldNames(sDelimiter)
   sDelimiter := ::ForceAnsi(sDelimiter)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetXFAFormFieldNames"} ,"__pt__sl__pt",::_id_,sDelimiter)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldValue(sXFAFieldName)
   sXFAFieldName:= ::ForceAnsi(sXFAFieldName)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFGetXFAFormFieldValue"} ,"__pt__sl__pt",::_id_,sXFAFieldName)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GlobalJavaScriptCount()
return FpQCall( {::_hdll_,"QuickPDFGlobalJavaScriptCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GlobalJavaScriptPackageName(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFGlobalJavaScriptPackageName"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HasFontResources()                                                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFHasFontResources"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HasPageBox(p1)
return FpQCall( {::_hdll_,"QuickPDFHasPageBox"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HidePage()
return FpQCall( {::_hdll_,"QuickPDFHidePage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageCount()
return FpQCall( {::_hdll_,"QuickPDFImageCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageFillColor()
return FpQCall( {::_hdll_,"QuickPDFImageFillColor"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageHeight()
return FpQCall( {::_hdll_,"QuickPDFImageHeight"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageHorizontalResolution()
return FpQCall( {::_hdll_,"QuickPDFImageHorizontalResolution"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageResolutionUnits()
return FpQCall( {::_hdll_,"QuickPDFImageResolutionUnits"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageType()
return FpQCall( {::_hdll_,"QuickPDFImageType"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageVerticalResolution()
return FpQCall( {::_hdll_,"QuickPDFImageVerticalResolution"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageWidth()
return FpQCall( {::_hdll_,"QuickPDFImageWidth"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImportEMFFromFile(FileName, nFontOptions, nGeneralOptions)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFImportEMFFromFile"} ,"__sl__sl__pt__sl__sl",::_id_,FileName, nFontOptions, nGeneralOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertPages(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFInsertPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertTableColumns(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFInsertTableColumns"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertTableRows(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFInsertTableRows"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:IsAnnotFormField(p1)
return FpQCall( {::_hdll_,"QuickPDFIsAnnotFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LastErrorCode()
return FpQCall( {::_hdll_,"QuickPDFLastErrorCode"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LastRenderError()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFLastRenderError"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LayerCount()
return FpQCall( {::_hdll_,"QuickPDFLayerCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LayerSafe()                                                                 // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFLayerSafe"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LibraryVersion()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFLibraryVersion"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LicenseInfo()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFLicenseInfo"} ,"__pt__sl",::_id_)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Linearized()                                                                // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFLinearized"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromCanvasDC(p1,p2)                                                     // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFLoadFromCanvasDC"} ,"__sl__sl__f8__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromFile(FileName)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFLoadFromFile"} ,"__sl__sl__pt",::_id_,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromString(p1)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // 1 param => 2 OK !
return ::_ptb_free_(FpQCall({::_hdll_,"QuickPDFLoadFromString"},"__sl__sl__pt",::_id_,::_b(p1,ptb,1)),ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadState()
return FpQCall( {::_hdll_,"QuickPDFLoadState"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeDocument(p1)                                                           // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFMergeDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFileList(cListName, FileName)
   cListName := ::ForceAnsi(cListName)
   FileName  := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFMergeFileList"} ,"__sl__sl__pt__pt",::_id_,cListName, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFileListFast(cListName, FileName)
   cListName := ::ForceAnsi(cListName)
   FileName  := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFMergeFileListFast"} ,"__sl__sl__pt__pt",::_id_,cListName, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFiles(FirstFileName, SecondFileName, OutputFileName)                   // *HB* return .t. / .f.
   FirstFileName  := ::ForceUTF8(FirstFileName)
   SecondFileName := ::ForceUTF8(SecondFileName)
   OutputFileName := ::ForceUTF8(OutputFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFMergeFiles"} ,"__sl__sl__pt__pt__pt",::_id_,FirstFileName, SecondFileName, OutputFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeTableCells(p1,p2,p3,p4,p5)
return FpQCall( {::_hdll_,"QuickPDFMergeTableCells"} ,"__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveLayer(p1,p2)                                                            // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFMoveLayer"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveOutlineAfter(p1,p2)                                                     // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFMoveOutlineAfter"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveOutlineBefore(p1,p2)                                                    // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFMoveOutlineBefore"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MovePage(p1)                                                                // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFMovePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MovePath(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFMovePath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MultiplyScale(p1)
return FpQCall( {::_hdll_,"QuickPDFMultiplyScale"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewChildFormField(nIndex, Title, nFieldType)
   Title := ::ForceUTF8(Title)
return FpQCall( {::_hdll_,"QuickPDFNewChildFormField"} ,"__sl__sl__sl__pt__sl",::_id_,nIndex, Title, nFieldType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewCustomPrinter(p1)
   DEFAULT p1 TO ::GetDefaultPrinterName()                                                   // HB 1.30
   // wenn P1 ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if P1 is not a valid, the next line will cause a "internal data corrupted" error
   p1 := ::ForceAnsi(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFNewCustomPrinter"} ,"__pt__sl__pt",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewDocument()
return FpQCall( {::_hdll_,"QuickPDFNewDocument"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewFormField(Title, nFieldType)
   Title := ::ForceUTF8(Title)
return FpQCall( {::_hdll_,"QuickPDFNewFormField"} ,"__sl__sl__pt__sl",::_id_,Title, nFieldType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewLayer()
return FpQCall( {::_hdll_,"QuickPDFNewLayer"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewOptionalContentGroup(GroupName)
   GroupName := ::ForceUTF8(GroupName)
return FpQCall( {::_hdll_,"QuickPDFNewOptionalContentGroup"} ,"__sl__sl__pt",::_id_,GroupName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewOutline(nParent, Title, nDestPage, nDestPosition)
   Title := ::ForceUTF8(Title)
return FpQCall( {::_hdll_,"QuickPDFNewOutline"} ,"__sl__sl__sl__pt__sl__f8",::_id_,nParent, Title, nDestPage, nDestPosition)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPage()                                                 // *HB* return 0==Error else set ::nPageNo
   local nReturn
   nReturn := FpQCall( {::_hdll_,"QuickPDFNewPage"} ,"__sl__sl",::_id_)
   if nReturn > 0
      ::nPageNo := nReturn
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPages(p1)                                                                // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFNewPages"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPostScriptXObject(sPS)
   sPS := ::ForceAnsi(sPS)
return FpQCall( {::_hdll_,"QuickPDFNewPostScriptXObject"} ,"__sl__sl__pt",::_id_,sPS)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewRGBAxialShader(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12)                   // *HB* return .t. / .f.
   p1 := ::ForceAnsi(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFNewRGBAxialShader"} ,"__sl__sl__pt__f8__f8__f8__f8__f8__f8__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewStaticOutline(nParent, Title)
   Title := ::ForceUTF8(Title)
return FpQCall( {::_hdll_,"QuickPDFNewStaticOutline"} ,"__sl__sl__sl__pt",::_id_,nParent, Title)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OpenOutline(p1)                                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFOpenOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OptionalContentGroupCount()
return FpQCall( {::_hdll_,"QuickPDFOptionalContentGroupCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OutlineCount()
return FpQCall( {::_hdll_,"QuickPDFOutlineCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OutlineTitle(p1)
RETURN ::ReadUTF8( ::_str_result_(FpQCall( {::_hdll_,"QuickPDFOutlineTitle"} ,"__pt__sl__sl",::_id_,p1)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageCount()
return FpQCall( {::_hdll_,"QuickPDFPageCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageHeight()
return FpQCall( {::_hdll_,"QuickPDFPageHeight"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageJavaScriptAction(cActionType,JavaScript)                                // *HB* return .t. / .f.
    cActionType := ::ForceAnsi(cActionType)
    JavaScript  := ::ForceUTF8(JavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFPageJavaScriptAction"} ,"__sl__sl__pt__pt",::_id_,cActionType,JavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageRotation()
return FpQCall( {::_hdll_,"QuickPDFPageRotation"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageWidth()
return FpQCall( {::_hdll_,"QuickPDFPageWidth"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintDocument(p1,p2,p3,p4)                                                  // *HB* return .t. / .f.
   DEFAULT p1 TO ::GetDefaultPrinterName()                                                    // HB 1.30
   // wenn P1 ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if P1 is not a valid, the next line will cause a "internal data corrupted" error
   p1 := ::ForceAnsi(p1)
return 0 # FpQCall( {::_hdll_,"QuickPDFPrintDocument"} ,"__sl__sl__pt__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintDocumentToFile(cPrinterName, nStartPage, nEndPage, nOptions, FileName)
   DEFAULT cPrinterName TO ::GetDefaultPrinterName()                                                    // HB 1.30
   FileName := ::ForceUTF8(FileName)
   cPrinterName := ::ForceAnsi(cPrinterName)
   // wenn cPrinterName ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if cPrinterName is not valid, the next line will cause an "internal data corrupted" error
return FpQCall( {::_hdll_,"QuickPDFPrintDocumentToFile"} ,"__sl__sl__pt__sl__sl__sl__pt",::_id_,cPrinterName, nStartPage, nEndPage, nOptions, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintOptions(nPageScaling, nAutoRotateCenter, sTitle)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"QuickPDFPrintOptions"} ,"__sl__sl__sl__sl__pt",::_id_,nPageScaling, nAutoRotateCenter, sTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseBuffer(p1)                                                           // *HB* return .t. / .f.
return 0 = FpQCall( {::_hdll_,"QuickPDFReleaseBuffer"} ,"__sl__sl__pt",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseLibrary()                                                        // NEW *HB* return .t. / .f.
   local lOK
   if empty(::_id_)
      lOK := .t.
   else
      if 0 # FpQCall( {::_hdll_,"QuickPDFReleaseLibrary"} ,"__sl__sl",::_id_)
         lOK := .t.
         ::_id_ := 0
      else
         lOK := .f.
      endif
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveAppearanceStream(p1)                                                  // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveAppearanceStream"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveDocument(p1)                                                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveOutline(p1)                                                           // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveSharedLayers()
return FpQCall( {::_hdll_,"QuickPDFRemoveSharedLayers"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveStyle(sStyleName)                                                     // *HB* return .t. / .f.
   sStyleName := ::ForceAnsi(sStyleName)
return 0 # FpQCall( {::_hdll_,"QuickPDFRemoveStyle"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderDocumentToFile(nDPI, nStartPage, nEndPage, nOptions, FileName)        // *HB* return .t. / .f.
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFRenderDocumentToFile"} ,"__sl__sl__sl__sl__sl__sl__pt",::_id_,nDPI, nStartPage, nEndPage, nOptions, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToDC(p1,p2,p3)                                                    // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFRenderPageToDC"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToFile(nDPI, nPage, nOptions, FileName)
   FileName := ::ForceUTF8(FileName)
return FpQCall( {::_hdll_,"QuickPDFRenderPageToFile"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nDPI, nPage, nOptions, FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToString(p1,p2,p3)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFRenderPageToString"} ,"__pt__sl__sl__sl__sl",::_id_,p1,p2,p3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceFonts()
return FpQCall( {::_hdll_,"QuickPDFReplaceFonts"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceImage(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFReplaceImage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceTag(sTag, sNewValue)
   sTag      := ::ForceAnsi(sTag)
   sNewValue := ::ForceAnsi(sNewValue)
return FpQCall( {::_hdll_,"QuickPDFReplaceTag"} ,"__sl__sl__pt__pt",::_id_,sTag, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RetrieveCustomDataToFile(cKey, FileName, nLocation)                         // *HB* return .t. / .f.
   cKey     := ::ForceAnsi(cKey)
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFRetrieveCustomDataToFile"} ,"__sl__sl__pt__pt__sl",::_id_,cKey, FileName, nLocation)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RetrieveCustomDataToString(cKey, nLocation)
   cKey := ::ForceAnsi(cKey)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"QuickPDFRetrieveCustomDataToString"} ,"__pt__sl__pt__sl",::_id_,cKey, nLocation)) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReverseImage(p1)
return FpQCall( {::_hdll_,"QuickPDFReverseImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RotatePage(p1)                                                              // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFRotatePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveFontToFile(FileName)                                                    // *HB* return .t. / .f.
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSaveFontToFile"} ,"__sl__sl__pt",::_id_,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveImageToFile(FileName)                                                   // *HB* return .t. / .f.
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSaveImageToFile"} ,"__sl__sl__pt",::_id_,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveState()
return FpQCall( {::_hdll_,"QuickPDFSaveState"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveStyle(sStyleName)
   sStyleName := ::ForceAnsi(sStyleName)
return FpQCall( {::_hdll_,"QuickPDFSaveStyle"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveToFile(FileName)                                                        // *HB* return .t. / .f.
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSaveToFile"} ,"__sl__sl__pt",::_id_,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFSaveToString"} ,"__pt__sl",::_id_))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SecurityInfo(p1)
return FpQCall( {::_hdll_,"QuickPDFSecurityInfo"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectDocument(p1)                                                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSelectDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedDocument()
return FpQCall( {::_hdll_,"QuickPDFSelectedDocument"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedFont()
return FpQCall( {::_hdll_,"QuickPDFSelectedFont"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedImage()
return FpQCall( {::_hdll_,"QuickPDFSelectedImage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedPage()
return FpQCall( {::_hdll_,"QuickPDFSelectedPage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectFont(p1)                                                              // *HB* return .t. / .f.
   DEFAULT p1 TO ::nDefaultStandardFontID
return 0 # FpQCall( {::_hdll_,"QuickPDFSelectFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectImage(p1)                                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSelectImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectLayer(p1)                                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSelectLayer"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectPage(p1)                                                // *HB* return .t. / .f. set ::nPageNo
   local lOK
   lOK := 0 # FpQCall( {::_hdll_,"QuickPDFSelectPage"} ,"__sl__sl__sl",::_id_,p1)
   if lOK
      ::nPageNo := p1
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAdvancePassword(p1)
   p1 := ::ForceAnsi(p1)
return FpQCall( {::_hdll_,"QuickPDFSetAdvancePassword"} ,"__sl__sl__pt",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotContents(nIndex, sNewContents)
   sNewContents := ::ForceAnsi(sNewContents)
return FpQCall( {::_hdll_,"QuickPDFSetAnnotContents"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewContents)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotStrProperty(nIndex, nTag, NewValue)
   NewValue := ::ForceUTF8(NewValue)
return FpQCall( {::_hdll_,"QuickPDFSetAnnotStrProperty"} ,"__sl__sl__sl__sl__pt",::_id_,nIndex, nTag, NewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBaseURL(sNewBaseURL)
   sNewBaseURL := ::ForceAnsi(sNewBaseURL)
return FpQCall( {::_hdll_,"QuickPDFSetBaseURL"} ,"__sl__sl__pt",::_id_,sNewBaseURL)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBlendMode(p1)
return FpQCall( {::_hdll_,"QuickPDFSetBlendMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBreakString(sNewBreakString)
   sNewBreakString := ::ForceAnsi(sNewBreakString)
return FpQCall( {::_hdll_,"QuickPDFSetBreakString"} ,"__sl__sl__pt",::_id_,sNewBreakString)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCapturedPageOptional(p1,p2)                                              // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCapturedPageOptional"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCatalogInformation(cKey, NewValue)                                       // *HB* return .t. / .f.
   cKey     := ::ForceAnsi(cKey)
   NewValue := ::ForceUTF8(NewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCatalogInformation"} ,"__sl__sl__pt__pt",::_id_,cKey, NewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCharWidth(p1,p2)                                                         // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCharWidth"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetClippingPath()
return FpQCall( {::_hdll_,"QuickPDFSetClippingPath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetClippingPathEvenOdd()
return FpQCall( {::_hdll_,"QuickPDFSetClippingPathEvenOdd"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCropBox(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetCropBox"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCustomInformation(cKey, NewValue)                                        // *HB* return .t. / .f.
   cKey     := ::ForceAnsi(cKey)
   NewValue := ::ForceUTF8(NewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCustomInformation"} ,"__sl__sl__pt__pt",::_id_,cKey, NewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCustomLineDash(sDashPattern, nDashPhase)
   sDashPattern := ::ForceAnsi(sDashPattern)                                                    // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetCustomLineDash"} ,"__sl__sl__pt__f8",::_id_,sDashPattern, nDashPhase)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDocumentMetadata(sXMP)
   sXMP := ::ForceAnsi(sXMP)                                                     // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetDocumentMetadata"} ,"__sl__sl__pt",::_id_,sXMP)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColor(nR,nG,nB)                                          // *HB* DrawText change this color !
   if nR==NIL .or. nG==NIL .or. nB==NIL                                                       // 1.54
      nR := ::nAktiveFillColorRed
      nG := ::nAktiveFillColorGreen
      nB := ::nAktiveFillColorBlue
   else
      if nR>1 .or. nG>1 .or. nB>1
         ::HB_RGB2double(@nR,@nG,@nB)
      endif
      ::nAktiveFillColorRed    :=  nR
      ::nAktiveFillColorGreen  :=  nG
      ::nAktiveFillColorBlue   :=  nB
   endif
return FpQCall( {::_hdll_,"QuickPDFSetFillColor"} ,"__sl__sl__f8__f8__f8",::_id_,nR,nG,nB)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetFillColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorSep(sColorName, nTint)                                          // *HB* return .t. / .f.
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFillColorSep"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillShader(sShaderName)                                                  // *HB* return .t. / .f.
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFillShader"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFontEncoding(p1)                                                         // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFontEncoding"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFontFlags(p1,p2,p3,p4,p5,p6,p7,p8)                                       // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFontFlags"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldAlignment(p1,p2)                                                // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldAlignment"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldAnnotFlags(p1,p2)                                               // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldAnnotFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColor(p1,p2,p3,p4)                                    // *HB* return .t. / .f.
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBackgroundColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorCMYK(p1,p2,p3,p4,p5)                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBackgroundColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorSep(nIndex, sColorName, nTint)                   // *HB* return .t. / .f.
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBackgroundColorSep"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColor(p1,p2,p3,p4)                                        // *HB* return .t. / .f.
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBorderColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorCMYK(p1,p2,p3,p4,p5)                                 // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBorderColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorSep(nIndex, sColorName, nTint)                       // *HB* return .t. / .f.
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBorderColorSep"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderStyle(p1,p2,p3,p4,p5)                                     // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBorderStyle"} ,"__sl__sl__sl__f8__sl__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBounds(p1,p2,p3,p4,p5)                                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldBounds"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCalcOrder(p1,p2)                                                // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldCalcOrder"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCaption(nIndex, NewCaption)                                     // *HB* return .t. / .f.
   NewCaption := ::ForceUTF8(NewCaption)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldCaption"} ,"__sl__sl__sl__pt",::_id_,nIndex, NewCaption)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCheckStyle(p1,p2,p3)                                            // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldCheckStyle"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldChildTitle(nInteger, NewTitle)                                  // *HB* return .t. / .f.
   NewTitle := ::ForceUTF8(NewTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldChildTitle"} ,"__sl__sl__sl__pt",::_id_,nInteger, NewTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColor(p1,p2,p3,p4)                                              // *HB* return .t. / .f.
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorCMYK(p1,p2,p3,p4,p5)                                       // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorSep(nIndex, sColorName, nTint)                             // *HB* return .t. / .f.
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldColorSep"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldComb(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetFormFieldComb"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldDefaultValue(nIndex, NewDefaultValue)                           // *HB* return .t. / .f.
   NewDefaultValue := ::ForceUTF8(NewDefaultValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldDefaultValue"} ,"__sl__sl__sl__pt",::_id_,nIndex, NewDefaultValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldDescription(nIndex, NewDescription)                             // *HB* return .t. / .f.
   NewDescription := ::ForceUTF8(NewDescription)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldDescription"} ,"__sl__sl__sl__pt",::_id_,nIndex, NewDescription)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldFlags(p1,p2)                                                    // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldFont(p1,p2)                                                     // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldFont"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldHighlightMode(p1,p2)                                            // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldHighlightMode"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldIcon(p1,p2,p3)                                                  // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldIcon"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldIconStyle(p1,p2,p3,p4,p5,p6)                                    // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldIconStyle"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldMaxLen(p1,p2)                                                   // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldMaxLen"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldOptional(p1,p2)                                                 // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldOptional"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldPage(p1,p2)                                                     // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldPage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldPrintable(p1,p2)                                                // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldPrintable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldReadOnly(p1,p2)                                                 // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldReadOnly"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldRotation(p1,p2)                                                 // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldRotation"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldStandardFont(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetFormFieldStandardFont"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTabOrder(p1,p2)                                                 // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldTabOrder"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTextFlags(p1,p2,p3,p4,p5,p6)                                    // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldTextFlags"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTextSize(p1,p2)                                                 // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldTextSize"} ,"__sl__sl__sl__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldValue(nIndex, NewValue)                                         // *HB* return .t. / .f.
   NewValue := ::ForceUTF8(NewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldValue"} ,"__sl__sl__sl__pt",::_id_,nIndex, NewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldValueByTitle(Title, NewValue)                                   // *HB* return .t. / .f.
   Title := ::ForceUTF8(Title)
   NewValue := ::ForceUTF8(NewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldValueByTitle"} ,"__sl__sl__pt__pt",::_id_,Title, NewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldVisible(p1,p2)                                                  // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetFormFieldVisible"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetGDIPlusFileName(DLLFileName)                                             // *HB* return .t. / .f.
   DLLFileName := ::ForceUTF8(DLLFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetGDIPlusFileName"} ,"__sl__sl__pt",::_id_,DLLFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetGDIPlusOptions(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetGDIPlusOptions"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLBoldFont(sFontSet, nFontID)                                          // *HB* return .t. / .f.
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetHTMLBoldFont"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLBoldItalicFont(sFontSet, nFontID)                                    // *HB* return .t. / .f.
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetHTMLBoldItalicFont"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLItalicFont(sFontSet, nFontID)                                        // *HB* return .t. / .f.
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetHTMLItalicFont"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLNormalFont(sFontSet, nFontID)                                        // *HB* return .t. / .f.
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetHTMLNormalFont"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageAsMask(p1)
return FpQCall( {::_hdll_,"QuickPDFSetImageAsMask"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMask(p1,p2,p3,p4,p5,p6)                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetImageMask"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMaskCMYK(p1,p2,p3,p4,p5,p6,p7,p8)                                   // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetImageMaskCMYK"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMaskFromImage(p1)
return FpQCall( {::_hdll_,"QuickPDFSetImageMaskFromImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageOptional(p1)
return FpQCall( {::_hdll_,"QuickPDFSetImageOptional"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetInformation(nKey, NewValue)                                              // *HB* return .t. / .f.
   NewValue := ::ForceUTF8(NewValue)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetInformation"} ,"__sl__sl__sl__pt",::_id_,nKey, NewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetJavaScriptMode(p1)
return FpQCall( {::_hdll_,"QuickPDFSetJavaScriptMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetJPEGQuality(p1)
return FpQCall( {::_hdll_,"QuickPDFSetJPEGQuality"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetKerning(sCharPair, nAdjustment)                                          // *HB* return .t. / .f.
   sCharPair := ::ForceAnsi(sCharPair)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetKerning"} ,"__sl__sl__pt__sl",::_id_,sCharPair, nAdjustment)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLayerOptional(p1)                                                        // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLayerOptional"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineCap(p1)                                                              // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineCap"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColor(p1,p2,p3)
   DEFAULT p1 TO 0
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetLineColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetLineColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorSep(sColorName, nTint)                                          // *HB* return .t. / .f.
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineColorSep"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineDash(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetLineDash"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineJoin(p1)                                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineJoin"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineShader(sShaderName)                                                  // *HB* return .t. / .f.
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetLineShader"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineWidth(p1)                                                        // *HB* return current value
   local nReturn
   if valtype(P1)="N" .and. p1==0  // setze Standardwert, set default value
      p1 := ::nDefaultLineWidth
   endif
   nReturn := ::nLineWidth         // aktuellen Wert zurckgeben, return current value
   if P1 # NIL                     // neuen Wert setzen, set new value
      if 0 # FpQCall( {::_hdll_,"QuickPDFSetLineWidth"} ,"__sl__sl__f8",::_id_,p1)
         ::nLineWidth := p1
      endif
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasurementUnits(p1)
return FpQCall( {::_hdll_,"QuickPDFSetMeasurementUnits"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetNeedAppearances(p1)                                                      // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetNeedAppearances"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionDestination(p1,p2)                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOpenActionDestination"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionDestinationFull(p1,p2,p3,p4,p5,p6,p7)                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOpenActionDestinationFull"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionJavaScript(JavaScript)                                         // *HB* return .t. / .f.
   JavaScript := ::ForceUTF8(JavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOpenActionJavaScript"} ,"__sl__sl__pt",::_id_,JavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionMenu(sMenuItem)                                                // *HB* return .t. / .f.
   sMenuItem := ::ForceAnsi(sMenuItem)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOpenActionMenu"} ,"__sl__sl__pt",::_id_,sMenuItem)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentGroupPrintable(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetOptionalContentGroupPrintable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentGroupVisible(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetOptionalContentGroupVisible"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOrigin(p1)
return FpQCall( {::_hdll_,"QuickPDFSetOrigin"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColor(p1,p2,p3,p4)                                                // *HB* return .t. / .f.
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestination(p1,p2,p3)                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineDestination"} ,"__sl__sl__sl__sl__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestinationFull(p1,p2,p3,p4,p5,p6,p7,p8)                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineDestinationFull"} ,"__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestinationZoom(p1,p2,p3,p4)                                      // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineDestinationZoom"} ,"__sl__sl__sl__sl__f8__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineJavaScript(nOutlineID, JavaScript)                                // *HB* return .t. / .f.
   JavaScript := ::ForceUTF8(JavaScript)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineJavaScript"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, JavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineOpenFile(nOutlineID, sFileName)                                   // *HB* return .t. / .f.
   sFileName := ::ForceAnsi(sFileName)
   sFileName := ::PathFormatPdf(sFileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineOpenFile"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineStyle(p1,p2,p3)                                                   // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineStyle"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineTitle(nOutlineID, NewTitle)                                       // *HB* return .t. / .f.
   NewTitle := ::ForceUTF8(NewTitle)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineTitle"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, NewTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineWebLink(nOutlineID, sLink)                                        // *HB* return .t. / .f.
   sLink := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetOutlineWebLink"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageActionMenu(sMenuItem)                                                // *HB* return .t. / .f.
   sMenuItem := ::ForceAnsi(sMenuItem)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageActionMenu"} ,"__sl__sl__pt",::_id_,sMenuItem)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageBox(p1,p2,p3,p4,p5)
return FpQCall( {::_hdll_,"QuickPDFSetPageBox"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageContent(p1)
return FpQCall( {::_hdll_,"QuickPDFSetPageContent"} ,"__sl__sl__pt",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageDimensions(p1,p2)                                                    // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageDimensions"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageLayout(p1)                                                           // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageLayout"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageMode(p1)                                                             // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageSize(sPaperName)                                                     // *HB* return .t. / .f.
   sPaperName := ::ForceAnsi(sPaperName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageSize"} ,"__sl__sl__pt",::_id_,sPaperName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageThumbnail()                                                          // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPageThumbnail"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageTransparencyGroup(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFSetPageTransparencyGroup"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPassword(sPassword)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"QuickPDFSetPassword"} ,"__sl__sl__pt",::_id_,sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPNGTransparencyColor(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFSetPNGTransparencyColor"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPrecision(p1)                                                            // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetPrecision"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetScale(p1)
return FpQCall( {::_hdll_,"QuickPDFSetScale"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColor(p1,p2,p3,p4,p5)
   DEFAULT p3 TO 0                                                                            // 1.54
   DEFAULT p4 TO 0
   DEFAULT p5 TO 0
   if p3>1 .or. p4>1 .or. p5>1
      ::HB_RGB2double(@p3,@p4,@p5)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetTableBorderColor"} ,"__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorCMYK(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFSetTableBorderColorCMYK"} ,"__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderWidth(p1,p2,p3)
return FpQCall( {::_hdll_,"QuickPDFSetTableBorderWidth"} ,"__sl__sl__sl__sl__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellAlignment(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellAlignment"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColor(p1,p2,p3,p4,p5,p6,p7,p8)
   DEFAULT p6 TO 0                                                                            // 1.54
   DEFAULT p7 TO 0
   DEFAULT p8 TO 0
   if p6>1 .or. p7>1 .or. p8>1
      ::HB_RGB2double(@p6,@p7,@p8)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBackgroundColor"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBackgroundColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColor(p1,p2,p3,p4,p5,p6,p7,p8,p9)
   DEFAULT p7 TO 0                                                                            // 1.54
   DEFAULT p8 TO 0
   DEFAULT p9 TO 0
   if p7>1 .or. p8>1 .or. p9>1
      ::HB_RGB2double(@p7,@p8,@p9)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBorderColor"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBorderColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderWidth(p1,p2,p3,p4,p5,p6,p7)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellBorderWidth"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellContent(nTableID, nRowNumber, nColumnNumber, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellContent"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nTableID, nRowNumber, nColumnNumber, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellPadding(p1,p2,p3,p4,p5,p6,p7)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellPadding"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColor(p1,p2,p3,p4,p5,p6,p7,p8)
   DEFAULT p6 TO 0                                                                            // 1.54
   DEFAULT p7 TO 0
   DEFAULT p8 TO 0
   if p6>1 .or. p7>1 .or. p8>1
      ::HB_RGB2double(@p6,@p7,@p8)
   endif
return FpQCall( {::_hdll_,"QuickPDFSetTableCellTextColor"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellTextColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextSize(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"QuickPDFSetTableCellTextSize"} ,"__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableColumnWidth(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTableColumnWidth"} ,"__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableRowHeight(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTableRowHeight"} ,"__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTempFile(FileName)                                                       // *HB* return .t. / .f.
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTempFile"} ,"__sl__sl__pt",::_id_,FileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTempPath(NewPath)                                                             // *HB* return .t. / .f.
   NewPath := ::ForceUTF8(NewPath)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTempPath"} ,"__sl__sl__pt",::_id_,NewPath)
// -------------------------------------------------------------------------------------------------------------------
Method HBPrintPDF:SetTextAlign(xAlign)             // *HB*
   local nReturn
   if xAlign == NIL .or. ! ValType(xAlign) $ "CN"  // Error
      nReturn := 0
   else
      do case
         case ValType(xAlign) == "N"
              // xAlign is ok
         case xAlign == "L"
              xAlign := TEXT_ALIGN_LEFT
         case xAlign == "R"
              xAlign := TEXT_ALIGN_RIGHT
         case xAlign == "C" .or. xAlign == "Z"
              xAlign := TEXT_ALIGN_CENTER
         case xAlign == "B"
              xAlign := TEXT_ALIGN_BLOCK_NORMAL
      end
      nReturn := FpQCall( {::_hdll_,"QuickPDFSetTextAlign"} ,"__sl__sl__sl",::_id_,xAlign)
      if ::IsTrue(nReturn)
         ::nAlign := xAlign
      endif
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextCharSpacing(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextCharSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColor(p1,p2,p3)     // <-
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextColorGreen    := p2
   ::nOldTextColorBlue     := p3
return FpQCall( {::_hdll_,"QuickPDFSetTextColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTextColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorSep(sColorName, nTint)                                          // *HB* return .t. / .f.
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextColorSep"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlight(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextHighlight"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColor(p1,p2,p3)
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextHighlightColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextHighlightColorGreen    := p2
   ::nOldTextHighlightColorBlue     := p3
return FpQCall( {::_hdll_,"QuickPDFSetTextHighlightColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTextHighlightColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorSep(sColorName, nTint)                                 // *HB* return .t. / .f.
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextHighlightColorSep"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextMode(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextRise(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextRise"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextScaling(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextScaling"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextShader(sShaderName)                                                  // *HB* return .t. / .f.
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextShader"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
Method HBPrintPDF:SetTextSize(nFontSize)                                                      // *HB* return .t. / .f.
   local lOK
   DEFAULT nFontSize TO ::nDefaultStandardFontSize
   lOK := 0 # FpQCall( {::_hdll_,"QuickPDFSetTextSize"} ,"__sl__sl__f8",::_id_,nFontSize)
   ::nLineFeed  := ::GetTextHeight()
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextSpacing(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderline(p1)                                                        // *HB*
       DEFAULT p1 TO TEXTUNDERLINE_NONE
       ::nTextUnderline := p1
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColor(p1,p2,p3)
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextUnderlineColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextUnderlineColorGreen    := p2
   ::nOldTextUnderlineColorBlue     := p3
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorSep(sColorName, nTint)                                 // *HB* return .t. / .f.
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineColorSep"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineDash(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFSetTextUnderlineDash"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextWordSpacing(p1)
return FpQCall( {::_hdll_,"QuickPDFSetTextWordSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTransparency(p1)                                                         // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetTransparency"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetupCustomPrinter(sCustomPrinterName, nSetting, nNewValue)                 // *HB* return .t. / .f.
   sCustomPrinterName := ::ForceAnsi(sCustomPrinterName)
return 0 # FpQCall( {::_hdll_,"QuickPDFSetupCustomPrinter"} ,"__sl__sl__pt__sl__sl",::_id_,sCustomPrinterName, nSetting, nNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetViewerPreferences(p1,p2)                                                 // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFSetViewerPreferences"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldAccess(sXFAFieldName, nNewAccess)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldAccess"} ,"__sl__sl__pt__sl",::_id_,sXFAFieldName, nNewAccess)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColor(sXFAFieldName, nRed, nGreen, nBlue)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldBorderColor"} ,"__sl__sl__pt__f8__f8__f8",::_id_,sXFAFieldName, nRed, nGreen, nBlue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderPresence(sXFAFieldName, nNewPresence)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldBorderPresence"} ,"__sl__sl__pt__sl",::_id_,sXFAFieldName, nNewPresence)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderWidth(sXFAFieldName, nBorderWidth)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldBorderWidth"} ,"__sl__sl__pt__f8",::_id_,sXFAFieldName, nBorderWidth)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldValue(sXFAFieldName,sNewValue)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
   sNewValue     := ::ForceAnsi(sNewValue)
return FpQCall( {::_hdll_,"QuickPDFSetXFAFormFieldValue"} ,"__sl__sl__pt__pt",::_id_,sXFAFieldName,sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SignFile(InputFileName, cOpenPassword, SignatureFieldName, OutputFileName, PFXFileName, cPFXPassword, cReason, cLocation, cContactInfo)
   InputFileName      := ::ForceUTF8(InputFileName)
   SignatureFieldName := ::ForceUTF8(SignatureFieldName)
   OutputFileName     := ::ForceUTF8(OutputFileName)
   PFXFileName        := ::ForceUTF8(PFXFileName)
   cOpenPassword      := ::ForceAnsi(cOpenPassword)
   cPFXPassword       := ::ForceAnsi(cPFXPassword)
   cReason            := ::ForceAnsi(cReason)
   cLocation          := ::ForceAnsi(cLocation)
   cContactInfo       := ::ForceAnsi(cContactInfo)
return FpQCall( {::_hdll_,"QuickPDFSignFile"} ,"__sl__sl__pt__pt__pt__pt__pt__pt__pt__pt__pt",::_id_,InputFileName,;
                           cOpenPassword, SignatureFieldName, OutputFileName, PFXFileName, cPFXPassword, cReason, cLocation, cContactInfo)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SplitPageText(p1)
return FpQCall( {::_hdll_,"QuickPDFSplitPageText"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StartPath(p1,p2)
return FpQCall( {::_hdll_,"QuickPDFStartPath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StoreCustomDataFromFile(cKey, FileName, nLocation, nOptions)                // *HB* return .t. / .f.
   cKey     := ::ForceAnsi(cKey)
   FileName := ::ForceUTF8(FileName)
return 0 # FpQCall( {::_hdll_,"QuickPDFStoreCustomDataFromFile"} ,"__sl__sl__pt__pt__sl__sl",::_id_,cKey, FileName, nLocation, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StoreCustomDataFromString(p1,p2,p3,p4)                                      // *HB* return .t. / .f.
  local ptb := _xgrab(32);PokeDWord(ptb,,5)
return 0 # ::_ptb_free_(FpQCall({::_hdll_,"QuickPDFStoreCustomDataFromString"},"__sl__sl__pt__pt__sl__sl",::_id_,p1,::_b(p2,ptb,2),p3,p4),ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StringResultLength()
return FpQCall( {::_hdll_,"QuickPDFStringResultLength"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:TestTempPath()                                                              // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFTestTempPath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ToPDFUnicode(cUnicodeString)                        // This function is deprecated from version 7.17.
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return binary data, no change !
return ::_str_result_(FpQCall( {::_hdll_,"QuickPDFToPDFUnicode"} ,"__pt__sl__pt",::_id_,cUnicodeString))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Unlocked()                                                                  // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFUnlocked"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UnlockKey(sLicenseKey)                                                      // *HB* return .t. / .f.
   sLicenseKey := ::ForceAnsi(sLicenseKey)
return 0 # FpQCall( {::_hdll_,"QuickPDFUnlockKey"} ,"__sl__sl__pt",::_id_,sLicenseKey)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UpdateAppearanceStream(p1)                                                  // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFUpdateAppearanceStream"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UseKerning(p1)
return FpQCall( {::_hdll_,"QuickPDFUseKerning"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UseUnsafeLayers(p1)                                                         // *HB* return .t. / .f.
return 0 # FpQCall( {::_hdll_,"QuickPDFUseUnsafeLayers"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
// END from TQuickPdf wrapper class

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetErrorText(nErrorCode)
   LOCAL x, cLangID, cTxt     // This PRG use ANSI codepage // diese Datei benutzt die ANSI codepage
   STATIC aErrorText := { ;   // 2 Bytes => ISO 639-1 es = espania, en = english, fr = french, de = germany  LOWER !!!
                        { 101, "en", "The Strength parameter passed to the Encrypt function was invalid" },;
                        { 101, "de", "Der 'Strength'-Parameter der an 'Encrypt' bergeben wurde ist unglig" },;
                        { 102, "en", "The Permissions parameter passed to the Encrypt function was invalid. Use the EncodePermissions function to construct a value for this parameter" },;
                        { 102, "de", "Der 'Permissions'-Parameter der an 'Encrypt' bergeben wurde ist unglig, nutze ::EncodePermissions()" },;
                        { 103, "en", "The Encrypt function was used on a document that was already encrypted" },;
                        { 103, "de", "Die PDF ist schon verschlsselt, ::Encrypt() ist nicht erlaubt." },;
                        { 104, "en", "The Encrypt function failed for an unknown reason" },;
                        { 104, "de", "Bei ::Encrypt() ist ein unbekannter Fehler aufgetreten." },;
                        { 201, "en", "The SetInformation function failed because the document is encrypted" },;
                        { 201, "de", "::SetInformation() kann keine verschlsselten PDF auswerten" },;
                        { 202, "en", "The Key parameter passed to the SetInformation function was out of range" },;
                        { 202, "de", "::SetInformation() wurde ein falscher 'Key'-Parameter bergeben" },;
                        { 301, "en", "An invalid combination of barcode and option was sent to the DrawBarcode function" },;
                        { 301, "de", "Die Kombination von 'barcode' und 'option' bei ::DrawBarcode() war ungltig" },;
                        { 302, "en", "Non-numeric characters were sent to DrawBarcode using EAN-13" },;
                        { 302, "de", "Bei einem EAN-13 Barcode drfen nur Ziffern im String an ::DrawBarcode() bergeben werden." },;
                        { 303, "en", "The EAN-13 barcode has an invalid checksum character" },;
                        { 303, "de", "Die Prfziffer beim EAN-13 Barcode war falsch" },;
                        { 401, "en", "Could not open input file" },;
                        { 401, "de", "Die Quelldatei konnte nicht geffnet werden" },;
                        { 402, "en", "Output file already exists and could not be deleted" },;
                        { 402, "de", "Die Zieldatei existierte bereits und konnte nicht gelscht werden" },;
                        { 403, "en", "Could not open output file" },;
                        { 403, "de", "Die Zieldatei konnte nicht geffnet werden" },;
                        { 404, "en", "Invalid password" },;
                        { 404, "de", "Das Passwort ist ungltig" },;
                        { 405, "en", "Document is not encrypted" },;
                        { 405, "de", "Das Dokument ist nicht verschlsselt" },;
                        { 406, "en", "Document is already encrypted" },;
                        { 406, "de", "Das Dokument ist schon verschlsselt" },;
                        { 407, "en", "Invalid encryption strength" },;
                        { 407, "de", "Die Verschlsselungsstrke ist ungltig (encryption strength)" },;
                        { 408, "en", "Invalid permissions" },;
                        { 408, "de", "Zugriff verweigert" },;
                        { 409, "en", "Invalid file structure, file is damaged" },;
                        { 409, "de", "Ungltige Dateistruktur, Dokument wurde beschdigt" },;
                        { 410, "en", "One of the input files is encrypted" },;
                        { 410, "de", "Eine der Quelldateien ist verschlsselt" },;
                        { 411, "en", "File not found" },;
                        { 411, "de", "Datei wurde nicht gefunden" },;
                        { 412, "en", "Invalid page range list" },;
                        { 412, "de", "Ungltige Seitenangabe" },;
                        { 501, "en", "The specified FileHandle was invalid" },;
                        { 501, "de", "Dateihandle ist ungltig" },;
                        { 999, "en", "The function could not be used because the library is not unlocked" },;
                        { 999, "de", "QuickPDF wurde nicht 'unlocked' - Schlsselfehler" }  }

   x := 0
   DEFAULT nErrorCode TO ::LastErrorCode()
   cLangID := alltrim(left(lower(::cErrorLanguage),2)) // max. 2 Byte

   do case
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode .and.  cLangID == a[2] } ) )
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode .and.  "en" == a[2] } ) )
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode } ) )
   end
   if x > 0
      cTxt := var2char(nErrorCode)+": "+alltrim(aErrorText[x,3])
   else
      cTxt := var2char(nErrorCode)+": unknown, unbekannt"
   endif

   if ::nCharSet = 1    // ANSI => OEM
      cTxt := ConvToOemCP(cTxt)
   endif              // OK OEM

return cTxt
