///////////////////////////////////////////////////////////////////////////////
//
//  Class code created by the Xbase++ FormDesigner
//    Creation date: 13.11.2013 Creation time: 08:52:24
//
//  Contents  :
//    This file contains the basic structure for the utilization-level of
//    a form. It may (and should) be modified.
//
///////////////////////////////////////////////////////////////////////////////

#include "Gra.ch"
#include "Xbp.ch"
#include "Common.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "HBPrintPDF.ch"
#include "ot4xb.ch" // www.xbwin.com => www.xbwin.com/ot4xbXHlp/

#pragma library("XppUi2")

// ANSI Text ! 


******************************************************************************
* Main procedure to test a form
******************************************************************************
PROCEDURE Main

   LOCAL nEvent, oXbp := nil, mp1 := nil, mp2 := nil, oDlg

   SET CHARSET to ansi

   oDlg := TestGui():New():Create()

   SetAppWindow(oDlg)

   nEvent := xbe_None
   WHILE nEvent != xbeP_Close
      nEvent := AppEvent ( @mp1, @mp2, @oXbp )
      oXbp:HandleEvent ( nEvent, mp1, mp2 )
      IF nEvent == xbeP_Quit
         QUIT   // AppQuit()
      ENDIF
   ENDDO

RETURN
// no CRT Window.
procedure appsys()
return


******************************************************************************
* This class is derived from the implementation-level class of the form.
* Instance variables are declared in the _TestGui class.
******************************************************************************
CLASS TestGui FROM _TestGui

   EXPORTED:

      VAR    cPDF, oBMP, oPS, cActivePrinter

      METHOD init
      METHOD create
      METHOD SelectPDF // get filename and show Infos
      METHOD Print
      METHOD Preview
      METHOD ShowBMP

ENDCLASS

******************************************************************************
* Initialize form
******************************************************************************
METHOD TestGui:init( oParent, oOwner, aPos, aSize, aPP, lVisible )

   * Execute method of the super class
   ::_TestGui:init( oParent, oOwner, aPos, aSize, aPP, lVisible )
   ::border := XBPDLG_DLGBORDER

   ::pbFileSelect:activate := {|| ::SelectPDF() }
   ::pbPrint:activate      := {|| ::Print() }
   ::pbPreview:activate    := {|| ::Preview() }

   ::cActivePrinter        := ""
   ::stPreview:autosize    := .f.


RETURN self


******************************************************************************
* Request system resources
******************************************************************************
METHOD TestGui:create( oParent, oOwner, aPos, aSize, aPP, lVisible )

   * Execute method of the super class
   ::_TestGui:create( oParent, oOwner, aPos, aSize, aPP, lVisible )

   ::stPreview:setParent(::stPreviewBox)
   ::stPreview:setColorBG( GRA_CLR_WHITE )
   ::stPreview:options  := XBPSTATIC_BITMAP_SCALED
   ::stPreview:setSize({210,297}) // A4 cm => pixel

   centerControl(::stPreview)

   ::oPS  := XbpPresSpace():new():create( ::stPreview:winDevice() )
   ::oBmp := XbpBitmap():new():create(::oPS)
   ::oBmp:loadFile("bild.bmp")
   ::ShowBMP()

   * Display the form
   ::show()

RETURN self
//-----------------------------------------------------------------------------------
METHOD TestGui:SelectPDF() // get filename and show Infos
   local cFile, oPDF, oBmp, bBmpData, cTxt
   cFile := GetFilenameOpen("PDF-Datei suchen / open file",.t.,cAppPath()+"*.PDF") // cAppPath() => ot4xb
   if empty(cFile)
      ::cPDF := ""
      ::mleBox:setData("No PDF")
      ::ShowBMP()
   else
      cTxt := "PDF: "+cFile+CRLF
      oBmp := NIL
      ::cPDF := cFile
      ::sleInfo:setData(cFile)
      oPDF := HBPrintPDF():new():create( GetQuickPDFLizenzKey() ) // GetQuickPDFLizenzKey() / cKey
      if oPDF:IsOK
         oPDF:LoadFromFile(cFile)
         if empty(::cActivePrinter)
            ::cActivePrinter := oPDF:GetDefaultPrinterName()
         endif
         cTxt += "QuickPDF Version: "+oPDF:LibraryVersion()+CRLF+CRLF+;
                 "PDF-Infos:"+CRLF+;
                 "PDF Version:    "+chr(9)+oPDF:GetInformation(0)+CRLF+;  // 0 = PDF Version
                 "Author:         "+chr(9)+oPDF:GetInformation(1)+CRLF+;  // 1 = Author
                 "Title:          "+chr(9)+oPDF:GetInformation(2)+CRLF+;  // 2 = Title
                 "Subject:        "+chr(9)+oPDF:GetInformation(3)+CRLF+;  // 3 = Subject, 4 = Keywords, 5 = Creator, 6 = Producer
                 "Creation date:  "+chr(9)+oPDF:GetInformation(7)+CRLF+;  // 7 = Creation date
                 "Edit date:      "+chr(9)+oPDF:GetInformation(8)+CRLF+;  // 8 = Modification date
                 "Page count:     "+chr(9)+ntrim(oPDF:PageCount())+CRLF+CRLF+;
                 "Default printer:"+chr(9)+oPDF:GetDefaultPrinterName()+CRLF+;
                 "Active printer: "+chr(9)+::cActivePrinter+CRLF



         oBmp := XbpBitmap():new():create(::oPS)
         // Test only
         * bBmpData := memoread("BILD.bmp")
         // new in  9.16 => BMP with 14 header bytes
         * bBmpData := oPDF:GetPrintPreviewBitmapToString(,1,,300) // max size 300 pixel
         * str2Disk("_TestPrintPreview.bmp",bBmpData)
         // new in  9.16 => BMP without the 14 header bytes
         *bBmpData := oPDF:GetPrintPreviewBitmapToSetBuffer(,1,,300) //  NUR FR XbpBitmap():SetBuffer() !
         // old way
         bBmpData := oPDF:RenderPageToString( 50, 1, 0) // 50 DPI, Page 1, 0 = BMP
         if left(bBmpData,2)="BM" // mit Header
            oBmp:setBuffer(substr(bBmpData,15)) // mit Header
         else
            oBmp:setBuffer(bBmpData) // mit Header
         endif
         oPDF:destroy()
      endif
      ::mleBox:setData(cTxt)
      ::ShowBMP(oBmp)
   endif
   SetAppFocus(::pbFileSelect)
return self
//-----------------------------------------------------------------------------------
METHOD TestGui:Print()
   local aPrinter, oXbp, aAuswahl, IsCancel := .f., oPDF
   oXbp := XbpPrinter():New()
   do case
      case empty(::cPDF)
            msgbox("PDF auswhlen | select a PDF")
      case empty(oXbp)
           msgbox("Error with XbpPrinter():New()")
      otherwise
           aPrinter := oXbp:list()
           if len(aPrinter)=0
              msgbox("no printer found")
           else
              aAuswahl := Auswahlliste(aPrinter,"Drucker whlen / select printer",,.f.,, @IsCancel )
              if IsCancel .or. empty(aAuswahl) .or. len(aAuswahl)=0
                 ::cActivePrinter := ""
              else
                 ::cActivePrinter := aAuswahl[1]
                 oPDF := HBPrintPDF():new():create() // GetQuickPDFLizenzKey() / cKey
                 if oPDF:IsOK
                    oPDF:LoadFromFile(::cPDF)
                    oPDF:PrintDocument(::cActivePrinter,1,1) // nur eine Seite
                    msgbox("1. Seite drucken / print 1. page => "+::cActivePrinter )
                    oPDF:destroy()
                 endif
              endif
           endif

   end

RETURN self
//-----------------------------------------------------------------------------------
METHOD TestGui:Preview()
   local oPDF, oBmp, bBmpData
   if empty(::cPDF)
      msgbox("PDF auswhlen | select a PDF")
   else
      oBmp := NIL
      oPDF := HBPrintPDF():new():create() // GetQuickPDFLizenzKey() / cKey
      if oPDF:IsOK
         oPDF:LoadFromFile(::cPDF)
         if empty(::cActivePrinter)
            ::cActivePrinter := oPDF:GetDefaultPrinterName()
         endif
         oBmp := XbpBitmap():new():create(::oPS)
         if val(oPDF:LibraryVersion()) < 9.16 // ONLY OLD WAY
            msgbox("GetPrintPreviewBitmapToString() needs 9.16, use old way")
            // old way
            bBmpData := oPDF:RenderPageToString( 50, 1, 0) // 50 DPI, Page 1, 0 = BMP
         else
            // new in  9.16 => BMP with 14 header bytes
            bBmpData := oPDF:GetPrintPreviewBitmapToString(,1,,300) // max size 300 pixel
            // log on BMP file
            str2Disk("_TestPrintPreview.bmp",bBmpData)
         endif
         if left(bBmpData,2)="BM" // mit Header
            oBmp:setBuffer(substr(bBmpData,15)) // mit Header
         else
            oBmp:setBuffer(bBmpData) // mit Header
         endif
         oPDF:destroy()
      endif
      ::ShowBMP(oBmp)
   endif
   SetAppFocus(::pbPreview)
RETURN self
//-----------------------------------------------------------------------------------
METHOD TestGui:ShowBMP(oBmp)
   if empty(oBmp)
      ::stPreview:autosize := .t.
      ::stPreview:configure()
      ::stPreview:setCaption(::oBmp)
   else
      ::stPreview:autosize := .f.
      ::stPreview:configure()
      ::stPreview:setCaption(oBmp)
   endif
   centerControl(::stPreview)
RETURN self

*-------------------------------------------------------------
FUNCTION GetFilenameOpen(cTitle,lCenter,cFilter,aFileFilters) // aFileFilters nur Win32
   local oFileDlg, cFile, cAltCurDir, cAltCurDrive, cFilterOhnePfad

   DEFAULT cTitle  TO "ffnen / Open ..."
   DEFAULT lCenter TO .t.
   DEFAULT cFilter TO "*.*"
   do case
      case "\" $ cFilter
           cFilterOhnePfad := substr(cFilter,rat("\",cFilter)+1 )
      case ":" $ cFilter
           cFilterOhnePfad := substr(cFilter,rat(":",cFilter)+1 )
      otherwise
           cFilterOhnePfad := cFilter
   endcase
   DEFAULT aFileFilters TO     { { cFilterOhnePfad , cFilterOhnePfad } }

   cAltCurDrive  := CurDrive()
   cAltCurDir    := CurDir()

   oFileDlg := XbpFileDialog():new()
   oFileDlg:center      := lCenter
   oFileDlg:title       := cTitle
   oFileDlg:FileFilters := aFileFilters
   oFileDlg:create()

   cFile := oFileDlg:open(cFilter)

   oFileDlg:destroy()

   CurDrive(cAltCurDrive)
   CurDir(cAltCurDrive+":\"+cAltCurDir)

return cFile
//----------------------------------------------------
function ntrim(n);return alltrim(str(n))
*---------------------------------------------------------------------------------------------
function Str2Disk(cFile,cTxt)             // memowrit() fgt ein chr(26) an die Datei an, was strt !
   local nResult, nHandle, nByte

   nResult := 0                           // wird schon alles gut gehen ...
   nHandle := FCreate(cFile)
   if nHandle = -1
      nResult := FError()
   else
      nByte := FWrite( nHandle, cTxt )
      if len(cTxt) # nByte
         nResult := FError()
      endif
   endif
   FClose(nHandle)
return nResult

//EOF
/////
