#include "Xbp.ch"
#include "Gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "HBPrintPDF.ch"

// ANSI Text ! 

procedure main
   local oPDF, cAcrobat, cPDF, cPfad, nWahl, cPrinterName, aPrinter, aBins, aBinTxt, cUnit
   local nY, nX, nW, nH, nF, x, cTxt, nFeldNr, nActivePage, cCMD, cKey, r
   cls

   set charset to ansi
   set alternate to Test_Felder.txt
   set alternate on

   // write your license key here, or SET QUICKPDF_11_REGKEY = ...
   // cKey := " your License key as Variable in your code !"
   cKey := GetQuickPDFLizenzKey()

   ? "Teste HBPrintPDF"

   cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe" // or find the standard !
   cPDF     := "Test_Felder.pdf"
   cPfad    := cAppPath()  // ot4xb
   delete file (cPDF)
   do while file (cPDF)
      msgbox("Die PDF Datei muss zuerst geschlossen werden / close PDF !" )
      delete file (cPDF)
   enddo
   ? "PDF:  '"+cPDF+"'"
   ? "Pfad: '"+cPfad+"'"
   ?
   ? "HBPrintPDF() erzeugen"
   ?

altd()

   oPDF := HBPrintPDF():new():create(cKey) // GetQuickPDFLizenzKey() / cKey

   if oPDF:IsOK
      ? "DLL-Version:",oPDF:LibraryVersion()
      /* Key The property to set:
         0 = PDF Version
         1 = Author
         2 = Title
         3 = Subject
         4 = Keywords
         5 = Creator
         6 = Producer
      */
      ? "SetInformation( 1 )", oPDF:SetInformation( 1 , "Hubert Brandel ()" )
      ? "SetInformation( 2 )", oPDF:SetInformation( 2 , "HBPrintPDF - Form Fields by QuickPDF" )
      ? "SetInformation( 3 )", oPDF:SetInformation( 3 , "HBPrintPDF - PRG-Example ()" )
      ? "SetInformation( 4 )", oPDF:SetInformation( 4 , "HBPrintPDF, QuickPDF" )
      ? "SetInformation( 5 )", oPDF:SetInformation( 5 , "HBPrintPDF - Xbase++ CLASS for QuickPDF" )
      ? "SetInformation( 6 )", oPDF:SetInformation( 6 , "HBPrintPDF and QuickPDF" )

      ? "nach Create - Text ausgeben"
      do case
         case set(_SET_CHARSET)=0 // ANSI
            cTxt := "EXE in ANSI (0)"
         case set(_SET_CHARSET)=1 // OEM
            cTxt := "EXE in OEM (1)"
         otherwise
            cTxt := "EXE ? ("+alltrim(str(set(_SET_CHARSET),3,0))+")"
      end
      oPDF:Say(2,45,cTxt)
      ? "CHARSET: ",cTxt
      oPDF:SetPageLayout(0) // single page
      oPDF:DrawText(20,30, "HBPrintPDF (QuickPDF) DLL: "+oPDF:LibraryVersion())

      do case
         case oPDF:nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
              cUnit := "mm"
         case oPDF:nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
              cUnit := "inch"
         otherwise
              cUnit := "1/72 inch"
      end
      ? "PageHeight():      ",oPDF:PageHeight(),cUnit
      ? "PageWidth ():      ",oPDF:PageWidth (),cUnit
      ?
      if val(oPDF:LibraryVersion()) >= 9.16
         ? "SetHeaderCommentsFromString: ", oPDF:SetHeaderCommentsFromString("Hubert's Kommentar")
      else
         ? "SetHeaderCommentsFromString: ",oPDF:LibraryVersion(),"< 9.16"
      endif

      ? "Text einfgen"
      oPDF:DrawText(20, 40, "This is new Text, Form Fields should follow ..." )

      ? "FormFieldCount  ", oPDF:FormFieldCount()

      nFeldNr := oPDF:NewFormField("TextInput", 1 ) // 1 = Textbox
      if nFeldNr > 0
         ? "new TextInput = ", nFeldNr , "0=Error, otherwise index number"
         ? " - bounds ...   ", oPDF:SetFormFieldBounds(nFeldNr , 20, 50, 100, 15)
         ? " - colours ...  ", oPDF:SetFormFieldBorderColor(nFeldNr , 1, 0, 0)
         ? " - background   ", oPDF:SetFormFieldBackgroundColorGray(nFeldNr , 0.9 )
         ? " - title        ", oPDF:SetFormFieldTitle(nFeldNr , "FormField Text - Title" )
      endif

      nFeldNr := oPDF:NewFormField("CheckBox",  3 )
      if nFeldNr > 0
         ? "new CheckBox    ", nFeldNr
         ? " - bounds ...   ", oPDF:SetFormFieldBounds(nFeldNr , 20, 70, 10, 10 )
         ? " - colours ...  ", oPDF:SetFormFieldBorderColor(nFeldNr , 1, 0, 0)
         ? " - background   ", oPDF:SetFormFieldBackgroundColorGray(nFeldNr , 1 )
         ? " - title        ", oPDF:SetFormFieldTitle(nFeldNr , "FormField CheckBox - Title" )
         ? " - caption      ", oPDF:SetFormFieldCaption(nFeldNr , "CheckBox Caption" )
         ? " - CheckStyle   ", oPDF:SetFormFieldCheckStyle(nFeldNr , 1 , 1 )
      endif

      nFeldNr := oPDF:NewFormField("RadioParent", 4)  // Radiobuttongroup !
      if nFeldNr > 0
          ? "RadioButtonGroup is a RadioParent",nFeldNr     // Gruppen Parent

          r := { 0, 0, 0 }

          FOR x = 1 TO 3
             r[x] := oPDF:AddFormFieldSub( nFeldNr , "Radio"+STR(x,2))
             ? " - option "+STR(x,2),r[x]
             ? " - bounds ...   ", oPDF:SetFormFieldBounds(      r[x] , 20, (x-1)*15+90, 10, 10 )
             ? " - caption ...  ", oPDF:SetFormFieldCaption(     r[x] , "Option "+STR(x,2) )
             ? " - colours ...  ", oPDF:SetFormFieldBorderColor( r[x] , 1, 0, 0)
             ? " - CheckStyle   ", oPDF:SetFormFieldCheckStyle(  r[x] , 2 , 1 ) // Radio, Centred
          NEXT

          ? "Set Radiobutton ", oPDF:SetFormFieldValue(nFeldNr , "Radio 2" ) // *** "Radio"+STR(x,2) in example needs a blank between Radio and 2 ;-)
          ? "FormFieldCount: ", oPDF:FormFieldCount()
      endif

      //------------------- END --- SAVE --- PRINT ------------------

      ? "Save File",oPDF:SaveToFile(cPfad+cPDF)
      ? "File ? ",file(cPfad+cPDF)

      inkey(10)



   endif



   if file(cPfad+cPDF)
      if ! file(cAcrobat)
         cAcrobat := GetStandardProgramm(cPDF, cPfad)
      endif
      runshell(cPfad+cPDF,cAcrobat,.t.)
   endif


return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)   // cPath force to EXE
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if empty(cPath)
      cPath := cAppDir()
   endif
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe

