#include "Xbp.ch"
#include "Gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "HBPrintPDF.ch"

// ANSI Text ! 

procedure main
   local oPDF, cFileIn1, cFileIn2, cPDF, cAcrobat, cPfad
   cls

   set charset to ansi
   set alternate to test_MergeFile.txt
   set alternate on

   ? "Teste HBPrintPDF MergeFile"

   cAcrobat := "" // use the Standard-EXE
   cPDF     := "NewMergedPDF.pdf"
   cPfad    := cAppPath()  // ot4xb
   cFileIn1 := "Beispiel_SAY.pdf"  // build by Beispiel_SAY.EXE
   cFileIn2 := "BoxTest.pdf"       // build by BoxTest.EXE
   delete file (cPDF)
   do while file (cPDF)
      msgbox("Die PDF Datei muss zuerst geschlossen werden / close PDF !" )
      delete file (cPDF)
   enddo

   if ! file(cFileIn1)
      msgbox("File "+cFileIn1+" is missing, please create or change NAME !"+chr(10)+;
             "Datei "+cFileIn1+" fehlt, bitte erzeugen oder NAME ndern !" )
      quit
   endif

   if ! file(cFileIn2)
      msgbox("File "+cFileIn2+" is missing, please create or change NAME !"+chr(10)+;
             "Datei "+cFileIn2+" fehlt, bitte erzeugen oder NAME ndern !" )
      quit
   endif

   ? "Merge       ",cFileIn1,"and",cFileIn2," TO ",cPDF
   ? "Pfad/Path: '"+cPfad+"'"
   ?
   ? "HBPrintPDF() erzeugen"
   ?

altd()

   oPDF := HBPrintPDF():new():create() // GetQuickPDFLizenzKey() / cKey

   if oPDF:IsOK
      ? "DLL-Version:",oPDF:LibraryVersion()
      /* Key The property to set:
         0 = PDF Version
         1 = Author
         2 = Title
         3 = Subject
         4 = Keywords
         5 = Creator
         6 = Producer
      */
      if oPDF:MergeFiles(cPfad+cFileIn1, cPfad+cFileIn2, cPfad+cPDF)
         if fexists(cPfad+cPDF)
            msgbox("DLL say OK and File is on disk, now start Acrobat")
            if ! file(cAcrobat)
               cAcrobat := GetStandardProgramm(cPDF, cPfad)
            endif
            runshell(cPfad+cPDF,cAcrobat,.t.)

         else
            msgbox("DLL say OK but NO File on disk")
         endif
      else
         msgbox("DLL say ERROR ! ")

      endif
      oPDF:destroy()
   endif

return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)   // cPath force to EXE
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if empty(cPath)
      cPath := cAppDir()
   endif
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe
*--------------------------------------------------------------------------
function ntrim(x);return alltrim(str(x))

