#include "Xbp.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "gra.ch"
#include "hbprintpdf.ch"

// ANSI Text ! 

proc main
   local oHBPDF
   local cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe"
   local cPDF  := "BoxTest.pdf"
   local cPfad := cAppPath()  // ot4xb
   local cBarCode, nY, nX, nLF, nStart, x, y, nSleep := 0, nRow := 3
   local cTitleFont    := "Calibri", ;
         cNormalFont   := "Verdana", ;
         cBoldFont     := "Verdana [Bold]", ;
         cItalicFont   := "Verdana [Italic]", ;
         nTitlefont    := 0,;
         nNormalFont   := 0, ;
         nBoldFont     := 0, ;
         nItalicFont := 0
   Local aBoxAttr := {}, ;
         nOffset  := NIL , ;
         nDrawOptions := NIL
   local cKey := GetQuickPDFLizenzKey()
   cls
   delete file (cPDF)
   ? "Teste HBPrintPDF - SetFillColor"
   ?
   ? "KEY: ",cKey
   ?
   ? "bitte Taste drcken"


   inkey(0)

   oHBPDF := HBPrintPDF():new():create(cKey)
   if oHBPDF:IsOK
      oHBPDF:SetPageSize("A4")
      oHBPDF:SetPageSize("A4 Landscape")

      // Lade Schriften in PDF, add fonts to pdf

      nTitlefont := oHBPDF:AddTrueTypeFont(cTitleFont,0)
      if empty(nTitlefont)
         msgbox("Could not load: "+cTitleFont )
      endif

      nBoldFont  := oHBPDF:AddTrueTypeFont(cBoldFont,0)
      if empty(nBoldFont)
         msgbox("Could not load: "+cBoldFont )
      endif

      nNormalFont := oHBPDF:AddTrueTypeFont(cNormalFont,0)
      if empty(nNormalFont)
         msgbox("Could not load: "+cNormalFont )
      endif

      nItalicFont  := oHBPDF:AddTrueTypeFont(cItalicFont,0)
      if empty(nItalicFont)
         msgbox("Could not load: "+cItalicFont )
      endif

      // NUR FR / ONLY FOR *** :SAY...() Methods
      // Textgre in Chars Per Inch (seltsam)
      // Fontsize in Chars Per Inch (strange)
      oHBPDF:SetTextCpi(20)
      // Rechengre fr :SAY...() Methoden
      // Only for the :SAY...() methods pos calculation
      oHBPDF:SetCPI(20)

      nDrawOptions := DRAWOPTIONS_FILL // DRAWOPTIONS_ALL

      aBoxAttr := oHBPDF:GetColorRGB(GRA_CLR_PALEGRAY)
      oHBPDF:SetFillColor(aBoxAttr[1], aBoxAttr[2], aBoxAttr[3])
      oHBPDF:SayBox(nRow,10,nRow+5,45,nOffset,nDrawOptions)
      nRow += 10
      aBoxAttr := {222, 184, 135}
      oHBPDF:SetFillColorRGB(aBoxAttr[1], aBoxAttr[2], aBoxAttr[3])
      oHBPDF:SayBox(nRow,10,nRow+5,45,nOffset,nDrawOptions)

      // Standard Vorgehen fr Schriftwahl und Schriftgre
      // The standard way to use fonts and fontsize (TextSize)

      if ! oHBPDF:SelectFont(nTitleFont)
         msgbox("Error with: "+cTitleFont )
         quit
      endif

      oHBPDF:SetTextSize(20) // 20 Points !

      oHBPDF:DrawText(100,50, "TEST with boxes")

      if ! oHBPDF:SelectFont(nBoldFont)
         msgbox("Error with: "+cBoldFont )
         quit
      endif

      oHBPDF:SetTextSize(12) // 12 Points !
                     // x  y  text
      oHBPDF:DrawText(100,70, "This is BOLD text")

      if ! oHBPDF:SelectFont(nNormalFont)
         msgbox("Error with: "+cNormalFont )
         quit
      endif

      oHBPDF:SetTextSize(12) // 12 Points !

      nY  := 100
      nX  := 100
      nLF := oHBPDF:GetTextHeight()

      for x := 1 to 5
          oHBPDF:DrawText(nX,nY, "This is NORMAL text, line "+str(x,3))
          nY += nLF
      next

      oHBPDF:SetTextSize(10) // 10 Points !

      oHBPDF:DrawText(100,150, "This is SMALLER text")


      oHBPDF:SaveToFile(cPfad+cPDF)
      oHBPDF:destroy()
      ? "destroy - 10 Sekunden warten, oder Taste drcken"
      inkey(10)


      if file(cPfad+cPDF)
         if ! file(cAcrobat)
            cAcrobat := GetStandardProgramm(cPDF, cPfad)
         endif
         runshell(cPfad+cPDF,cAcrobat,.t.)
      endif
   endif   // isOK


return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)   // cPath force to EXE
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if empty(cPath)
      cPath := cAppDir()
   endif
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe
//-----------------------------------------------------------------------------------------
function GetQuickPDFLizenzKey()
   local cKey := "" // Hier in Anwendungsprogrammen Key eintragen ! fill in your key for your apps.
   // OR ...
   if empty(cKey)
      cKey := GetEnv("QUICKPDF_11_REGKEY")
   endif
return cKey
