// HBPrintPDF11 => DebenuPDFLibraryDLL11xx.dll  (11.xx)
//
// Version 11.15b - 2016-08-31

#include "Xbp.ch"
#include "gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "directry.ch"
#include "HBPrintPDF.CH"

#define MIN_DLL_VERSION 1111 // 11.11
#define MAX_DLL_VERSION 1199 // 11.99

// ANSI QUELLCODE !!!

/*
******************************************************************************

   deutsch / german / english will follow

   HBPrintPDF ist freeware und darf ohne Einschrnkung verwendet werden.

   bentigt          QuickPdf DLL    DebenuPDFLibraryDLL1111.dll  (11.11ff)
              Lizenzschlssel von    www.QuickPDF.com

                        OT4XB.DLL >= 001.005.012.021   from   www.xbwin.com

   Ohne Pablo Botella Navaro und seine OT4XB wre dies nicht mglich gewesen.
   Ich habe die Methoden aus seiner TQuickPdf wrapper class kopiert und
   nur die Rckgabewerte angepasst wo es ntig war. Das hat viel Zeit gespart.
   *HB* markiert genderte TQuickPdf Methoden

   Da die Lizenz fr die Hauptversion 10.xx gilt wird diese Klasse immer
   auf die neueste Version angepasst. Man kann eine ltere DLL benutzen
   solange man sich auf deren Methoden beschrnkt.
   Die Hauptversionsnummer von HBPrintPDF wurde auf die ntige QuickPDF Hauptversion gendert.

   Neue Versionen:    www.familie-brandel.de
                      www.xbaseforum.de          (nur in deutsch)

  ------------------------------------------------------------
    TQuickPdf wrapper class over the QuickPDFDLL0719.dll
          -> http://www.quickpdflibrary.com
    Author: Pablo Botella Navarro ( http://www.xbwin.com ) -
          -> http://www.xbwin.com.php?ng=/ot4xb.examples/36
  ------------------------------------------------------------

   WICHTIG ! Es gilt die Beschreibung der DLL (PDF) mit folgenden Ausnahmen:
             1. Der Parameter InstanceID wird intern verwendet, also NIE angeben.
             2. Die Namen der Methoden entsprechen denen der ActiveX Beschreibung,
                enthalten also NICHT den Vorsatz   QuickPDF... siehe unten
             3. In Basic und Delphi wird in IF Abfragen eine 0 als .f.
                und <> 0 als .t. verarbeitet. Wenn eine Methode diesen
                QuickPDF Rckgabewert nicht von numerisch auf logisch umsetzt,
                muss man o:IsFalse(...) und o:IsTrue(...) verwenden.
                Beispiel:   if o:IsTrue(o:QuickPDFFunction()) entspricht o:QuickPDFFunction()#0
                :IsFalse(...) und :IsTrue(...) stimmen immer.
             4. Sollten Sie Fehler finden, bitte ich um Mitteilung und ein kleines Beispiel.
                Ich bemhe mich diese schnell zu beseitigen.
             5. In der Beschreibung kann man Funktionen sehen, die zwar char * oder string etc.
                zurckgeben, aber tatschlich nur binre Daten (8bit) enthalten.
                Diese werden nicht mit ::ReadString() in OEM/ANSI bersetzt und mssen
                als BINR Daten verwendet werden. Ich habe dafr bis jetzt keine
                Verwendung und somit auch keinen Test oder Beispiele.
                Falls Sie welche freigeben mchten, nur her damit.
                Ihr Name als Autor knnen Sie oben eintragen ich werde diesen nicht entfernen.
             6. HBPrintPDF:SetAnsiMode(...) gibt immer den eingestellten iAnsiMode zurck.






// Version 11.12 - 2014-10-27
                        2
   * Neue Funktionen, siehe ganz unten ... "neu in 11.11" ff.
   * Untersttzung der DebenuPDFLibraryDLL1112.dll

// Version 11.15 - 2015-12-16

   * Neue Funktionen, siehe ganz unten ... "neu in 11.14" ff.
   * Untersttzung der DebenuPDFLibraryDLL1115.dll

// Version 11.15b - 2016-08-31

   * Fehler im Funktionsnamen:
     "DPLSetSignProcessCustomSubFilter" => "DPLSetSignProcessCustomSubFilterA" // Fixed 'A' for Ansi at end.


******************************************************************************

   englisch / english

   needs             QuickPdf DLL    DebenuPDFLibraryDLL1111.dll  (11.11ff)
                 Licence key from    www.QuickPDF.com

                        OT4XB.DLL >= 001.005.012.021   from   www.xbwin.com

   HBPrintPDF is freeware.

   Thanks to Pablo Botella Navaro and his OT4XB and the TQuickPdf wrapper class
   I used his methods to save time and changed the return values where
   we need arrays or logical return values.
   *HB* will mark the changed TQuickPdf Methods

   The license key is valid for versions 8.xx, so this class will be always
   changed to the newest version from 8.xx. You can use it with a older DLL
   as long as you don't use the new functions.
   I changed the HBPrintPDF mainversion to the needed QuickPDF mainversion.

   new version:  www.familie-brandel.de

  ------------------------------------------------------------
    TQuickPdf wrapper class over the QuickPDFDLL0719.dll
          -> http://www.quickpdflibrary.com
    Author: Pablo Botella Navarro ( http://www.xbwin.com ) -
          -> http://www.xbwin.com/forum.php?ng=/ot4xb.examples/36
  ------------------------------------------------------------

   IMPORTANT !  Please use the quickpdf reference guide (PDF) for info and help.
                These things are different:
             1. Ignore the parameter InstanceID, the class will handle it inside.
             2. The method names are the same as those from ActiveX.
                No leading QuickPDF... just use the function name. See the code ...
             3. Basic and Delphi use numeric parameters instead of logical in Xbase
                They use values as 0 = False and <> 0 is True.
                I changed the QuickPDF return value in this case in .t. / .f. ...
                If the method in this class does not change the return value, you
                have to use these methods:     o:IsFalse(...) or o:IsTrue(...)
                Example:  if o:IsTrue(o:QuickPDFFunction()) is equal to o:QuickPDFFunction()#0
             4. If you find errors, please let me know and I will correct them.
             5. While all text parameters in 8.x now use widestring, there are still
                some char * or string types. These are binary (8bit) values
                and not real strings. They have to be handled with care and
                not translatet with ::ReadString() into OEM/ANSI.
                I did never use these and have no examples, if you will offer
                something for free, let me know. You can put your name etc.
                in the code if you want, I will not remove it.
             6. HBPrintPDF:SetAnsiMode(...) will allways return the iAnsiMode.


// Version 11.12 - 2014-10-27

   * New functions, search for 11.11
   * now support DebenuPDFLibraryDLL1112.dll

// Version 11.15 - 2015-12-16

   * New functions, search for 11.14
   * now support DebenuPDFLibraryDLL1115.dll

// Version 11.15b - 2016-08-31

   * Fixed the missing A in function name:
     "DPLSetSignProcessCustomSubFilter" => "DPLSetSignProcessCustomSubFilterA" // Fixed 'A' for Ansi at end.



******************************************************************************

   Beispiel / Example


   cQuickPDFKey := "............." or read from .CH

   // Standard DLL von TQuickPdf                // use the standard DLL from TQuickPdf
   oHBPrintPDF  := HBPrintPDF():new():create(cQuickPDFKey)
   if oHBPrintPDF:IsOK                          **** wichtig ! Important
      ...

   // oder eigene festlegen                     // or define your own DLL
   oHBPrintPDF  := HBPrintPDF():new()
   oHBPrintPDF:cDLLName := "DebenuPDFLibraryDLL10??.dll" // TESTED:  DebenuPDFLibraryDLL1011.dll ff.
   ...
   oHBPrintPDF:create(cQuickPDFKey)
   if oHBPrintPDF:IsOK                          **** wichtig ! Important
      oHBPrintPDF:DrawText(20,30, "Hello world with HBPrintPDF (QuickPDF)")
      // Speichern, SAVE ?
      oHBPrintPDF:SaveToFile(cPfad+cPDF)
      // Drucken, Printing ?
      oHBPrintPDF:PrintDocument(cPrinterName, 1, oHBPrintPDF:PageCount())
      // Variablen zurcksetzen, aber QuickPDF wird erst beim Programmende entladen.
      // Reset vars, but the QuickPDF will not give back the memory until EXE quits.
      oHBPrintPDF:destroy()
   endif

   Have fun :-)

   Hubert

*/

******** QuickPDF Lizenz Key / License Key ********* HOW TO *****
*
* entweder bei CREATE( cLizenzKey ) angeben, oder eine Funktion wie GetQuickPDFLizenzKey()
* nutzen um ihn zu ermitteln und zurckzugeben.
*
* first option CREATE( cLicenseKey ) or use a function like GetQuickPDFLizenzKey() to
* get a valid key. More infos about it in the Quick PDF Helpfile => UnlockKey(LicenseKey)
*
/*
oHBPrintPDF:create(GetQuickPDFLizenzKey())
...
//-----------------------------------------------------------------------------------------
function GetQuickPDFLizenzKey()
   local cKey := "" // Hier in Anwendungsprogrammen Key eintragen ! fill in your key for your apps.
   // OR ...
   if empty(cKey)
      cKey := GetEnv("QUICKPDF_11_REGKEY")
   endif
return cKey
...
oHBPrintPDF:create(GetEnv("QUICKPDF_11_REGKEY"))

*/

//-----------------------------------------------------------------------------------------
function MsgFunctionRemoved(cName)
   DEFAULT cName TO "???"
   msgbox("Fehler: '"+cName+"' existiert nicht mehr, bitte Fehler an Autor melden."+CRLF+;
          "Error:  '"+cName+"' has been removed, program have to be changed.", "Programmfehler / Programerror")
return NIL
//-----------------------------------------------------------------------------------------

CLASS HBPrintPDF

   PROTECTED

   VAR    nLineFeed             // method LineFeed(6) -> 6 * nLineFeed = Zeilenvorschub - line feed
                                // nLineFeed wird mit dem Standardabstand des aktuellen Font geladen !
                                //  "        will be set to the font hight of the standard font
                                // ->  ::SetTextSize()  ->  ::nLineFeed  in mm, points or inch
   VAR    nLineWidth, nDefaultLineWidth
   VAR    nLPI, nCPI
   VAR    nAlign                // speichert aktuelle Ausrichtung, save the current Alignment
   VAR    _hdll_                // DLL handle
   VAR    _id_                  // InstanceID
   VAR    nPageNo               // internal Pagenumber !
   VAR    aImageID              // Array zum Speichern von ImagesID und Name (z.B. Dateiname)
                                // array to save ImageID and name
   VAR    nAktiveFillColorRed, nAktiveFillColorGreen, nAktiveFillColorBlue
   VAR    nOldTextColorRed, nOldTextColorGreen, nOldTextColorBlue  // SetTextColor() -> save 1 Time !
   VAR    nOldTextUnderlineColorRed, nOldTextUnderlineColorGreen, nOldTextUnderlineColorBlue
   VAR    nOldTextHighlightColorRed, nOldTextHighlightColorGreen, nOldTextHighlightColorBlue

   VAR    nTextUnderline        // SetTextUnderline(nOption) nTextUnderline := nOption
   VAR    nCharSet              // ::nCharSet := set(_SET_CHARSET)


   EXPORTED

   VAR IsOK                     // *** NUR Nach Create testen  // TEST ONCE after Create !!!

   VAR cErrorLanguage, cErrorNoInstance, cErrorLoadDll, cErrorNoLicenseOK, cErrorNoLicenseKey, cErrorNotMinVerOT4XB
   VAR SayOrigin0

   VAR cQuickPdfDllName
   VAR nDefaultPageSize
   VAR nDefaultMeasurementUnits
   VAR nPageDefaultOrigin
   VAR cDLLName
   VAR nDefaultStandardFontSize
   VAR nDefaultStandardFont     // -> AddStandardFont()
   VAR nDefaultStandardFontID
   VAR nDefaultBoldFont
   VAR nDefaultBoldFontID
   VAR nDefaultItalicFont
   VAR nDefaultItalicFontID
   VAR nDefaultItalicBoldFont
   VAR nDefaultItalicBoldFontID

   // use for :SAY(...)
   VAR nDefaultLPI, nDefaultCPI, nFirstLine,nLastLine,nFirstRow,nLastRow
   VAR cDefaultYes, cDefaultNo, cDefaultNumFormat

   // UTF8 <=> OEM / ANSI
   VAR UseAutoConvUTF8          // default True, but if you convert yourself to UTF-8, than set False
                                // Standard = True, aber wenn man alle Strings mit UTF8 bergibt, braucht man False

   INLINE METHOD ForceAnsi( cString ) // The DLL needs ANSI Parameters, if not UTF8 !
          DEFAULT cString TO ""
          if ::UseAutoConvUTF8  // string parameter == ANSI/OEM
             if ::nCharSet = 1    // OEM => ANSI
                cString := ConvToAnsiCP(cString)
             endif              // OK ANSI
          else
             // wenn ! ::UseAutoConvUTF8, muss man selbst UTF8 liefern, z.b. mit ::forceUTF8() beim Aufruf.
             // string parameter HAS TO BE UTF8, force it !
          endif
          Return cString

   INLINE METHOD ReadString( cString ) // The DLL needs ANSI Parameters, if not UTF8 !
          DEFAULT cString TO ""
          if ::UseAutoConvUTF8  // string parameter == ANSI/OEM
             if ::nCharSet = 1    // ANSI => OEM
                cString := ConvToOemCP(cString)
             endif              // OK OEM
          else
             // wenn ! ::UseAutoConvUTF8, erhlt man UTF8, verwenden mit z.b. ReadUTF8()
             // return value is UTF8, use it !
          endif
          Return cString

   INLINE METHOD ForceUTF8( cString ) // cXbaseString => OEM or ANSI
          DEFAULT cString TO ""
          do case
             case ::nCharSet = 0 // set charset to Ansi
                  cString := cAnsiToUtf8(cString)
             case ::nCharSet = 1 // set charset to OEM
                  cString := cOemToUtf8(cString)
             otherwise
                  msgbox("ERROR: SET CHARSET # ANSI # OEM ?","ERROR in ForceUTF8()")
          end
          Return cString

   INLINE METHOD ReadUTF8( cString ) // UTF-8 => OEM or ANSI
          DEFAULT cString TO ""
          do case
             case ::nCharSet = 0 // set charset to Ansi
                 cString := cUtf8ToAnsi(cString)
             case ::nCharSet = 1 // set charset to OEM
                 cString := cUtf8ToOem(cString)
             otherwise
                  msgbox("ERROR: SET CHARSET # ANSI # OEM ?","ERROR in ReadUTF8()")
          end
          Return cString

   INLINE METHOD PathFormatPdf(cFile)                      // c:\myPath\myDoc.pfd ==> /c/myPath/myDoc.pfd
          DEFAULT cFile TO ""
          if substr(cFile,2,1)==":"                        //  ^
             cFile := "/"+left(cFile,1)+substr(cFile,3)    // /c\myPath\myDoc.pfd ==> /c/myPath/myDoc.pfd
          endif
          cFile := lower(strTran(cFile,"\","/"))
          Return cFile

   METHOD INIT
   METHOD CREATE
   METHOD DESTROY
   METHOD IsTrue, IsFalse       // 0 / #0  ->  .f. / .t.

   INLINE METHOD Points2Unit(nPoints)
          do case
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
                  return nPoints / 72 * 25.4
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
                  return nPoints / 72
          end
          return nPoints

   INLINE METHOD GetUnitText(lShowShort)
          DEFAULT lShowShort TO .t.
          do case
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
                  return "mm"
             case ::nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
                  return "inch"
          end
          return iif(lShowShort,"pt","points")

   METHOD GetTextUnderline      // return ::nTextUnderline
   METHOD GetPageSizeX          // -> QuickPDFPageWidth,   PageWidth
   METHOD GetPageSizeY          // -> QuickPDFPageHeight,  PageHeight
   METHOD GetPrinterBinA        // :GetPrinterBins()  -> String -> Array
   METHOD GetPrinterNameA       // :GetPrinterNames() -> CSV String -> Array
   METHOD GetTextAlign          // aktuelle Einstellung abfragen, Rckgabewert ist numerisch und entspricht letzter SetTextAlign(nWert) Festlegung
                                // get the current value, this is the same as the last numeric setting from SetTextAlign(nValue)
   METHOD GetColorRGB           // Xbase++ color -> {r,g,b} || nRGB -> 1=red, 2=green, 3 = blue

   // Bilder einfacher handhaben / help with images
   METHOD AddImageID            // AddImageID(nImageID,cName)       -> aadd(aImageID,{nImageID,cName}) -> OK ? .f. = Name exists, 1 ID n Names is OK.
   METHOD RemoveImageID         // RemoveImageID(nImageID)          -> aRemove(aImageID,... )          -> OK ? .f. = Parameter error
   METHOD GetImageIDByName      // GetImageIDByName(cName)          -> nImageID
   METHOD SelectImageByName     // SelectImageByName(cName) -(nImageID)-> SelectImage(nImageID) -> OK ?
   METHOD AddImageFile          // AddImageFile(cFileName,O) | AddImageFromFile(...) -(nImageID)-> AddImageID(...) -> nImageID
   METHOD DrawImageFile         // -> AddImageFile(cFileName,O) | AddImageFromFile(...) -(nImageID)-> AddImageID(...) -> FitImage...
   METHOD AddImageResource      // AddImageResource(nResourceID,O) | AddImageFromString(...) -(nImageID)-> AddImageID(...) -> nImageID
   METHOD DrawImageResource     // -> AddImageResource(nResourceID,O) -> String  | AddImageFromString(...) -(nImageID)-> AddImageID(...) -> FitImage...
   METHOD AddImageFromXbpBMP(cSetBufferString) // dem Rckgabewert bei BMPs fehlen die 14 Bytes des DateiHeader. NUR FR BMP !!!
   // needed for @...say migration
   METHOD SAY(nRow,nCol,xData,cAlign,nCPI,nLPI) // min == 1,1
   Method SayLine(nRow1,nCol1,nRow2,nCol2,cAlign1,cAlign2,nOffset,nCPI,nLPI) // Basisausrichtung der Linien/basic alignment: cAlign // nOffset +/- n
   Method SayBox(nRowTop,nColLeft,nRowBottom,nColRight,nOffset,nDrawOptions,nCPI,nLPI)
   Method SayImage(nRowTop,nColLeft,nRowBottom,nColRight,nRotateLeft,nCPI,nLPI,lRatio)   // Image in Grenzen von SayBox einpassen.

   METHOD SetLPI, GetLPI        // -> ::nLPI    *** will NOT change the FONT SIZE  !  // To CHANGE the fontsize use  ::SetTextCpi(n)
   METHOD SetCPI, GetCPI        // -> ::nCPI    *** Font Gre wird NICHT gendert !  // Zum ndern der Textgre -> ::SetTextCpi(n)
                                // beides ist NUR fr die Berechnung der SAY Position
                                // both will only be used to calculate the SAY position
                                // =>  SetTextCpi(n), GetTextCpi()

   METHOD SetSayLineFeed,GetSayLineFeed         // Zeilenhhe direkt angeben, berechnet -> ::nLPI / calculate ::nLPI from the parameter
   METHOD SetSayLinesPerPage,GetSayLinesPerPage // Zeilen je Seite direkt angeben, berechnet -> ::nLPI / lines per page calculate ::nLPI
   METHOD SetSayRowsPerPage,GetSayRowsPerPage   // Spalten je Seite direkt angeben, berechnet -> ::nCPI / rows per page calculate ::nCPI
   METHOD GetRowsPerInch                        // SetSayRowsPerPage( nRowsPerPage ) => SetTextCpi(GetRowsPerInch()) => correct font

   METHOD GetCPICharWidth(nCPI) // Breite eines Zeichens mit nCPI
   METHOD nRowToPosY(), nColToPosX()  // @say(nRow,nPos) -> x,y


   // HBPrinter() Methods

*   METHOD PrintMemo( nPosX, nPosY, cTxt, cAusrichtung, nMaxLen, cArt, xColor, cHochQuer, nMaxBis,nLineFeed )
   VAR PrintTextAlltrim
   METHOD PrintText( nPosX, nPosY, xData, cAusrichtung, nMaxLen, cArt, xColor, nDrehen )
   METHOD PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit  ) // -> lSuccess
   METHOD PrintCheckBox( nLeft, nTop, nSize, cType )  // nSize auen/outline , cType="B" eckig/Box, "R" .or. "C" rund/circle
   METHOD LineFeed()            // Neue Y Position ermitteln / calculate new Y value
   VAR    DrawTextBoxNextTop    // nTop + ::nLineFeed( ::DrawTextBox(nLeft, nTop, ... -> next nTop
   METHOD nBaselineToTop()      // nPosY - ::GetTextBound(GETTEXTBOUND_TOP)
   METHOD nTopToBaseline()      // nTop  + ::GetTextBound(GETTEXTBOUND_TOP)
   METHOD CalcCheckDigit(uEAN13_Nr) // EAN13 -> 12 + checkDigit -> 13
   METHOD getPageNo()           // ::getPageNo() -> ::nPageNo (integer) / ::getPageNo("C") -> alltrim(str(::nPageNo))
   METHOD PrintPageNo()         // PrintText(x,y,"- "+::getPageNo("C")+" -"

   // from Pablo per eMail // does not need XbpBitmap
   INLINE METHOD cLoadResource( hMod , res_id , res_type , lang_id , lAddBmfh)
          local hrs,hgr,cb,p,cc,cch
          if Valtype( res_id  ) == "N"
             res_id := MAKEINTRESOURCE(res_id)
          elseif Valtype( res_id  ) != "C" ; RETURN NIL ; end
          DEFAULT res_type := 2     // BITMAP
          DEFAULT lang_id  := MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL )
          DEFAULT hMod := AppInstance()
          hrs := @kernel32:FindResourceExA(hMod,res_type , res_id , lang_id )
          if Empty(hrs) ; RETURN NIL ; end
          hgr := @kernel32:LoadResource(hMod,hrs)
          if Empty(hgr) ; RETURN NIL ; end
          p  := @kernel32:LockResource(hgr)
          if Empty(p) ; RETURN NIL ; end
          cb := @kernel32:SizeofResource( hMod, hrs )
          cc := PeekStr(p,0,cb)
          if ! Empty(lAddBmFh)
             cch := ::cBmpGenFileHeader( p , cb )
             if cch == NIL ; RETURN cch ; end // error
             return cch + cc
          end
          return cc
   INLINE METHOD cBmpGenFileHeader( p , cb ) // p can be a string or a memory pointer
          local cbh,nbbc,nPalSize,nn
          if cb < 16 ; RETURN NIL ; end  // invalid bitmap
          cbh := PeekDWord(p)
          if cbh == 12    ; nn := 3  // OS2 bitmaps BITMAPCOREINFO  using RGBTRIPLE color table
          elseif cbh < 40 ; RETURN NIL  // invalid BITMAPINFO
          else           ; nn := 4 // BITMAPINFO using RGBQUAD color table
          end
          nbbc := PeekWord(p,0x0E)
          nPalSize := 0
          if     nbbc ==  1 ; nPalSize :=   2 * nn
          elseif nbbc ==  4 ; nPalSize :=  16 * nn
          elseif nbbc ==  8 ; nPalSize := 256 * nn
          elseif nbbc == 16 ; nPalSize := 0
          elseif nbbc == 24 ; nPalSize := 0
          elseif nbbc == 32 ; nPalSize := 0
          else              ; RETURN NIL  // invalid bbc entry
          end
          return __i16(0x4D42) + __i32( 14 + cb ,  0 , 14 + cbh + nPalSize )

   INLINE METHOD _b(cc,ptb,n) // n = Positon von CC im Puffer von PTP, beim Aufruf ::_b(,1), ::_b(,2), ::_b(,3),...
                              // PTP genug Speicher reservieren:
                              // local ptb := _xgrab(32);PokeDWord(ptb,, nAnzahl der Parameter + 1 ) // MAX-pCount() 1 => 2
                              // 1 Parameter per _b() bergeben, dann 1 als letzten Parameter von _b(,1) verwenden.
                              // 2 Parameter per _b() bergeben, dann _b(,1), _b(,2) ... etc. verwenden.
          local cb,p
          if !(Valtype(cc) $ "CM") ; RETURN cc ; end
          cb := Len(cc) ; if cb == 0; RETURN cc ; end
          p  := ::CreateBuffer(cb)
          ::AddToBuffer(p,cc,cb)
          PokeDWord(ptb,n*4,p)
          return p

   INLINE METHOD _ptb_free_( result , ptb )
          AEval( PeekDWord(ptb,4,PeekDWord(ptb)) , {|p| _xfree(p) } )
          _xfree(ptb)
          return result

   INLINE METHOD _str_result_(p)
       local cb
       if Empty(p) ; RETURN "" ; end
       cb := ::AnsiStringResultLength() //::StringResultLength()
       return PeekStr(p,0,cb)

   INLINE METHOD SetTextCpi(n) ; RETURN ::SetTextSize( 120 / n ) // tatschliche Font Gre, unabhngig von ::nCPI
   INLINE METHOD GetTextCpi()  ; RETURN (::GetTextSize() / 120)  // depend on the real font size, but not from ::nCPI

**********************************************************************************************************************
*  Erleichterungen bei Farben - use easy color values 0-255 0x00-0xFF
**********************************************************************************************************************

   INLINE METHOD HB_RGB2double(nR,nG,nB)  // PER REFERENZ AUFRUFEN - USE @ !!!
      if empty(nR) .or. empty(nG) .or. empty(nB)
         nR := nG := nB := 0
      else
         nR /= 255
         nG /= 255
         nB /= 255
      endif
      return nil

   // sortiert nach Name - sorted by name

   METHOD AddArcToPath
   METHOD AddBoxToPath
   METHOD AddCJKFont
   METHOD AddCurveToPath
   METHOD AddEmbeddedFile
   METHOD AddFileAttachment
   METHOD AddFormFieldChoiceSub
   METHOD AddFormFieldSub
   METHOD AddFormFont
   METHOD AddFreeTextAnnotation
   METHOD AddFreeTextAnnotationEx
   METHOD AddGlobalJavaScript
   METHOD AddImageFromFile
   METHOD AddImageFromFileOffset
   METHOD AddImageFromString
   METHOD AddLGIDictToPage
   METHOD AddLineToPath
   METHOD AddLinkToDestination
   METHOD AddLinkToEmbeddedFile
   METHOD AddLinkToFile
   METHOD AddLinkToFileDest
   METHOD AddLinkToFileEx
   METHOD AddLinkToJavaScript
   METHOD AddLinkToLocalFile
   METHOD AddLinkToPage
   METHOD AddLinkToWeb
   METHOD AddNoteAnnotation
   METHOD AddOpenTypeFontFromFile
   METHOD AddOpenTypeFontFromString
   METHOD AddPageLabels
   METHOD AddPageMatrix
   METHOD AddRelativeLinkToFile
   METHOD AddRelativeLinkToFileDest
   METHOD AddRelativeLinkToFileEx
   METHOD AddRelativeLinkToLocalFile
   METHOD AddSVGAnnotationFromFile
   METHOD AddSWFAnnotationFromFile
   METHOD AddSeparationColor
   METHOD AddStampAnnotation
   METHOD AddStampAnnotationFromImage
   METHOD AddStampAnnotationFromImageID
   METHOD AddStandardFont
   METHOD AddSubsettedFont
   METHOD AddTextMarkupAnnotation
   METHOD AddToBuffer
   METHOD AddToFileList
   METHOD AddTrueTypeFont
   METHOD AddTrueTypeFontFromFile
   METHOD AddTrueTypeFontFromString
   METHOD AddTrueTypeSubsettedFont
   METHOD AddType1Font
   METHOD AddU3DAnnotationFromFile
   METHOD AnalyseFile
   METHOD AnnotationCount
   METHOD AnsiStringResultLength
   METHOD AppendSpace
   METHOD AppendTableColumns
   METHOD AppendTableRows
   METHOD AppendText
   METHOD AppendToFile
   METHOD AppendToString
   METHOD ApplyStyle
   METHOD AttachAnnotToForm
   METHOD BalanceContentStream
   METHOD BalancePageTree
   METHOD BeginPageUpdate
   METHOD CapturePage
   METHOD CapturePageEx
   METHOD CharWidth
   METHOD CheckFileCompliance
   METHOD CheckObjects
   METHOD CheckPageAnnots
   METHOD CheckPassword
   METHOD ClearFileList
   METHOD ClearImage
   METHOD ClearPageLabels
   METHOD ClearTextFormatting
   METHOD CloneOutlineAction
   METHOD ClonePages
   METHOD CloseOutline
   METHOD ClosePath
   METHOD CombineContentStreams
   METHOD CombineLayers                                 // CombineLayers          => CombineContentStreams
   METHOD CompareOutlines
   METHOD CompressContent
   METHOD CompressFonts
   METHOD CompressImages
   METHOD CompressPage
   METHOD ContentStreamCount
   METHOD ContentStreamSafe
   METHOD CopyPageRanges
   METHOD CopyPageRangesEx
   METHOD CreateBuffer
   METHOD CreateNewObject
   METHOD CreateTable
   METHOD DAAppendFile
   METHOD DACapturePage
   METHOD DACapturePageEx
   METHOD DACloseFile
   METHOD DADrawCapturedPage
   METHOD DADrawRotatedCapturedPage
   METHOD DAEmbedFileStreams
   METHOD DAExtractPageText
   METHOD DAExtractPageTextBlocks
   METHOD DAFindPage
   METHOD DAGetAnnotationCount
   METHOD DAGetFormFieldCount
   METHOD DAGetFormFieldTitle
   METHOD DAGetFormFieldValue
   METHOD DAGetImageDataToString
   METHOD DAGetImageDblProperty
   METHOD DAGetImageIntProperty
   METHOD DAGetImageListCount
   METHOD DAGetInformation
   METHOD DAGetObjectCount
   METHOD DAGetObjectSource         // DAGetObjectSource      => DAGetObjectToString
   METHOD DAGetObjectToString
   METHOD DAGetPageBox
   METHOD DAGetPageContent          // DAGetPageContent       => DAGetPageContentToString
   METHOD DAGetPageContentToString
   METHOD DAGetPageCount
   METHOD DAGetPageHeight
   METHOD DAGetPageImageList
   METHOD DAGetPageLayout
   METHOD DAGetPageMode
   METHOD DAGetPageWidth
   METHOD DAGetTextBlockAsString
   METHOD DAGetTextBlockBound
   METHOD DAGetTextBlockCharWidth
   METHOD DAGetTextBlockColor
   METHOD DAGetTextBlockColorType
   METHOD DAGetTextBlockCount
   METHOD DAGetTextBlockFontName
   METHOD DAGetTextBlockFontSize
   METHOD DAGetTextBlockText
   METHOD DAHasPageBox
   METHOD DAHidePage
   METHOD DAMovePage
   METHOD DANewPage
   METHOD DANewPages
   METHOD DANormalizePage
   METHOD DAOpenFile
   METHOD DAOpenFileReadOnly
   METHOD DAPageRotation
   METHOD DAReleaseImageList
   METHOD DAReleaseTextBlocks
   METHOD DARemoveUsageRights
   METHOD DARenderPageToDC
   METHOD DARenderPageToFile
   METHOD DARenderPageToString
   METHOD DARotatePage
   METHOD DASaveAsFile
   METHOD DASaveImageDataToFile
   METHOD DASetInformation
   METHOD DASetPageBox
   METHOD DASetPageLayout
   METHOD DASetPageMode
   METHOD DASetPageSize
   METHOD DASetTextExtractionArea
   METHOD DASetTextExtractionOptions
   METHOD DASetTextExtractionScaling
   METHOD DASetTextExtractionWordGap
   METHOD DAShiftedHeader
   METHOD Decrypt
   METHOD DecryptFile
   METHOD DeleteAnalysis
   METHOD DeleteAnnotation
   METHOD DeleteContentStream
   METHOD DeleteFormField
   METHOD DeleteLayer
   METHOD DeleteOptionalContentGroup
   METHOD DeletePageLGIDict
   METHOD DeletePages
   METHOD DocJavaScriptAction
   METHOD DocumentCount
   METHOD DrawArc
   METHOD DrawBarcode
   METHOD DrawBox
   METHOD DrawCapturedPage
   METHOD DrawCapturedPageMatrix
   METHOD DrawCircle
   METHOD DrawDataMatrixSymbol
   METHOD DrawEllipse
   METHOD DrawEllipticArc
   METHOD DrawHTMLText
   METHOD DrawHTMLTextBox
   METHOD DrawHTMLTextBoxMatrix
   METHOD DrawHTMLTextMatrix
   METHOD DrawImage
   METHOD DrawImageMatrix
   METHOD DrawIntelligentMailBarcode
   METHOD DrawLine
   METHOD DrawMultiLineText
   METHOD DrawPDF417Symbol
   METHOD DrawPDF417SymbolEx
   METHOD DrawPath
   METHOD DrawPathEvenOdd
   METHOD DrawPostScriptXObject
   METHOD DrawQRCode
   METHOD DrawRotatedBox
   METHOD DrawRotatedCapturedPage
   METHOD DrawRotatedImage
   METHOD DrawRotatedMultiLineText
   METHOD DrawRotatedText
   METHOD DrawRotatedTextBox
   METHOD DrawRotatedTextBoxEx
   METHOD DrawRoundedBox
   METHOD DrawRoundedRotatedBox
   METHOD DrawScaledImage
   METHOD DrawSpacedText
   METHOD DrawTableRows
   METHOD DrawText
   METHOD DrawTextArc
   METHOD DrawTextBox
   METHOD DrawTextBoxMatrix
   METHOD DrawWrappedText
   METHOD EditableContentStream
   METHOD EditableLayer                  // EditableLayer          => EditableContentStream
   METHOD EmbedFile
   METHOD EmbeddedFileCount
   METHOD EncapsulateContentStream
   METHOD EncapsulateLayer               // EncapsulateLayer       => EncapsulateContentStream
   METHOD EncodePermissions
   METHOD Encrypt
   METHOD EncryptFile
   METHOD EncryptWithFingerprint
   METHOD EncryptionAlgorithm
   METHOD EncryptionStatus
   METHOD EncryptionStrength
   METHOD EndPageUpdate
   METHOD EndSignProcessToFile
   METHOD EndSignProcessToString
   METHOD ExtractFilePageContent          // ExtractFilePageContent => ExtractFilePageContentToString
   METHOD ExtractFilePageContentToString
   METHOD ExtractFilePageText
   METHOD ExtractFilePageTextBlocks
   METHOD ExtractFilePages
   METHOD ExtractFilePagesEx
   METHOD ExtractPageRanges
   METHOD ExtractPageTextBlocks
   METHOD ExtractPages
   METHOD FileListCount
   METHOD FileListItem
   METHOD FindFonts
   METHOD FindFormFieldByTitle
   METHOD FindImages
   METHOD FitImage
   METHOD FitRotatedTextBox
   METHOD FitTextBox
   METHOD FlattenAnnot
   METHOD FlattenFormField
   METHOD FontCount
   METHOD FontFamily
   METHOD FontHasKerning
   METHOD FontName
   METHOD FontReference
   METHOD FontSize
   METHOD FontType
   METHOD FormFieldCount
   METHOD FormFieldHasParent
   METHOD FormFieldJavaScriptAction
   METHOD FormFieldWebLinkAction
   METHOD GetActionDest
   METHOD GetActionType
   METHOD GetActionURL
   METHOD GetAnalysisInfo
   METHOD GetAnnotActionID
   METHOD GetAnnotDblProperty
   METHOD GetAnnotDest
   METHOD GetAnnotEmbeddedFileName
   METHOD GetAnnotEmbeddedFileToFile
   METHOD GetAnnotEmbeddedFileToString
   METHOD GetAnnotIntProperty
   METHOD GetAnnotQuadCount
   METHOD GetAnnotQuadPoints
   METHOD GetAnnotSoundToFile
   METHOD GetAnnotSoundToString
   METHOD GetAnnotStrProperty
   METHOD GetBarcodeWidth
   METHOD GetBaseURL
   METHOD GetCSDictEPSG
   METHOD GetCSDictType
   METHOD GetCSDictWKT
   METHOD GetCanvasDC
   METHOD GetCanvasDCEx
   METHOD GetCatalogInformation
   METHOD GetContentStreamToString
   METHOD GetCustomInformation
   METHOD GetCustomKeys
   METHOD GetDefaultPrinterName
   METHOD GetDestName
   METHOD GetDestPage
   METHOD GetDestType
   METHOD GetDestValue
   METHOD GetDocJavaScript
   METHOD GetDocumentFileName
   METHOD GetDocumentFileSize
   METHOD GetDocumentID
   METHOD GetDocumentIdentifier
   METHOD GetDocumentMetadata
   METHOD GetDocumentRepaired
   METHOD GetDocumentResourceList
   METHOD GetEmbeddedFileContentToFile
   METHOD GetEmbeddedFileContentToString
   METHOD GetEmbeddedFileID
   METHOD GetEmbeddedFileIntProperty
   METHOD GetEmbeddedFileStrProperty
   METHOD GetEncryptionFingerprint
   METHOD GetErrorText
   METHOD GetFileMetadata
   METHOD GetFirstChildOutline
   METHOD GetFirstOutline
   METHOD GetFontEncoding
   METHOD GetFontFlags
   METHOD GetFontID
   METHOD GetFontIsEmbedded
   METHOD GetFontIsSubsetted
   METHOD GetFontMetrics
   METHOD GetFontObjectNumber
   METHOD GetFormFieldActionID
   METHOD GetFormFieldAlignment
   METHOD GetFormFieldAnnotFlags
   METHOD GetFormFieldBackgroundColor
   METHOD GetFormFieldBackgroundColorType
   METHOD GetFormFieldBorderColor
   METHOD GetFormFieldBorderColorType
   METHOD GetFormFieldBorderProperty
   METHOD GetFormFieldBorderStyle
   METHOD GetFormFieldBound
   METHOD GetFormFieldCaption
   METHOD GetFormFieldCaptionEx
   METHOD GetFormFieldCheckStyle
   METHOD GetFormFieldChildTitle
   METHOD GetFormFieldChoiceType
   METHOD GetFormFieldColor
   METHOD GetFormFieldComb
   METHOD GetFormFieldDefaultValue
   METHOD GetFormFieldDescription
   METHOD GetFormFieldFlags
   METHOD GetFormFieldFontName
   METHOD GetFormFieldJavaScript
   METHOD GetFormFieldKidCount
   METHOD GetFormFieldKidTempIndex   // GetFormFieldSubTempIndex() => GetFormFieldKidTempIndex()
   METHOD GetFormFieldMaxLen
   METHOD GetFormFieldNoExport
   METHOD GetFormFieldPage
   METHOD GetFormFieldPrintable
   METHOD GetFormFieldReadOnly
   METHOD GetFormFieldRequired
   METHOD GetFormFieldRichTextString
   METHOD GetFormFieldRotation
   METHOD GetFormFieldSubCount
   METHOD GetFormFieldSubDisplayName
   METHOD GetFormFieldSubName
   METHOD GetFormFieldSubTempIndex   // GetFormFieldSubTempIndex() => GetFormFieldKidTempIndex()
   METHOD GetFormFieldSubmitActionString
   METHOD GetFormFieldTabOrder
   METHOD GetFormFieldTabOrderEx
   METHOD GetFormFieldTextFlags
   METHOD GetFormFieldTextSize
   METHOD GetFormFieldTitle
   METHOD GetFormFieldType
   METHOD GetFormFieldValue
   METHOD GetFormFieldValueByTitle
   METHOD GetFormFieldVisible
   METHOD GetFormFieldWebLink
   METHOD GetFormFontCount
   METHOD GetFormFontName
   METHOD GetGlobalJavaScript
   METHOD GetHTMLTextHeight
   METHOD GetHTMLTextLineCount
   METHOD GetHTMLTextWidth
   METHOD GetImageID
   METHOD GetImageListCount
   METHOD GetImageListItemDataToString
   METHOD GetImageListItemDblProperty
   METHOD GetImageListItemFormatDesc
   METHOD GetImageListItemIntProperty
   METHOD GetImageMeasureDict
   METHOD GetImagePageCount
   METHOD GetImagePageCountFromString
   METHOD GetImagePtDataDict
   METHOD GetInformation
   METHOD GetInstalledFontsByCharset
   METHOD GetInstalledFontsByCodePage
   METHOD GetKerning
   METHOD GetLatestPrinterNames
   METHOD GetMaxObjectNumber
   METHOD GetMeasureDictBoundsCount
   METHOD GetMeasureDictBoundsItem
   METHOD GetMeasureDictCoordinateSystem
   METHOD GetMeasureDictDCSDict
   METHOD GetMeasureDictGCSDict
   METHOD GetMeasureDictGPTSCount
   METHOD GetMeasureDictGPTSItem
   METHOD GetMeasureDictLPTSCount
   METHOD GetMeasureDictLPTSItem
   METHOD GetMeasureDictPDU
   METHOD GetNamedDestination
   METHOD GetNextOutline
   METHOD GetObjectCount
   METHOD GetObjectDecodeError
   METHOD GetObjectSource                            // GetObjectSource => GetObjectToString
   METHOD GetObjectToString
   METHOD GetOpenActionDestination
   METHOD GetOpenActionJavaScript
   METHOD GetOptionalContentConfigCount
   METHOD GetOptionalContentConfigLocked
   METHOD GetOptionalContentConfigOrderCount
   METHOD GetOptionalContentConfigOrderItemID
   METHOD GetOptionalContentConfigOrderItemLabel
   METHOD GetOptionalContentConfigOrderItemLevel
   METHOD GetOptionalContentConfigOrderItemType
   METHOD GetOptionalContentConfigState
   METHOD GetOptionalContentGroupID
   METHOD GetOptionalContentGroupName
   METHOD GetOptionalContentGroupPrintable
   METHOD GetOptionalContentGroupVisible
   METHOD GetOrigin
   METHOD GetOutlineActionID
   METHOD GetOutlineColor
   METHOD GetOutlineDest
   METHOD GetOutlineID
   METHOD GetOutlineJavaScript
   METHOD GetOutlineObjectNumber
   METHOD GetOutlineOpenFile
   METHOD GetOutlinePage
   METHOD GetOutlineStyle
   METHOD GetOutlineWebLink
   METHOD GetPageBox
   METHOD GetPageColorSpaces
   METHOD GetPageContent                        // GetPageContent         => GetPageContentToString
   METHOD GetPageContentToString
   METHOD GetPageImageList
   METHOD GetPageJavaScript
   METHOD GetPageLGIDictContent
   METHOD GetPageLGIDictCount
   METHOD GetPageLabel
   METHOD GetPageLayout
   METHOD GetPageMetricsToString
   METHOD GetPageMode
   METHOD GetPageText
   METHOD GetPageUserUnit
   METHOD GetPageViewPortCount
   METHOD GetPageViewPortID
   METHOD GetParentOutline
   METHOD GetPrevOutline
   METHOD GetPrintPreviewBitmapToSetBuffer      // substr(GetPrintPreviewBitmapToString(),15) NUR FR XbpBitmap():SetBuffer() !
   METHOD GetPrintPreviewBitmapToString
   METHOD GetPrinterBins
   METHOD GetPrinterDevModeToString
   METHOD GetPrinterMediaTypes
   METHOD GetPrinterNames
   METHOD GetRenderScale
   METHOD GetSignProcessByteRange
   METHOD GetSignProcessResult
   METHOD GetStringListCount
   METHOD GetStringListItem
   METHOD GetSubsetString
   METHOD GetTabOrderMode
   METHOD GetTableCellDblProperty
   METHOD GetTableCellIntProperty
   METHOD GetTableCellStrProperty
   METHOD GetTableColumnCount
   METHOD GetTableLastDrawnRow
   METHOD GetTableRowCount
   METHOD GetTempPath
   METHOD GetTextAscent
   METHOD GetTextBlockAsString
   METHOD GetTextBlockBound
   METHOD GetTextBlockCharWidth
   METHOD GetTextBlockColor
   METHOD GetTextBlockColorType
   METHOD GetTextBlockCount
   METHOD GetTextBlockFontName
   METHOD GetTextBlockFontSize
   METHOD GetTextBlockText
   METHOD GetTextBound
   METHOD GetTextDescent
   METHOD GetTextHeight
   METHOD GetTextSize
   METHOD GetTextWidth
   METHOD GetUnicodeCharactersFromEncoding
   METHOD GetViewPortBBox
   METHOD GetViewPortMeasureDict
   METHOD GetViewPortName
   METHOD GetViewPortPtDataDict
   METHOD GetViewerPreferences
   METHOD GetWrappedText
   METHOD GetWrappedTextBreakString
   METHOD GetWrappedTextHeight
   METHOD GetWrappedTextLineCount
   METHOD GetXFAFormFieldCount
   METHOD GetXFAFormFieldName
   METHOD GetXFAFormFieldNames
   METHOD GetXFAFormFieldValue
   METHOD GetXFAToString
   METHOD GlobalJavaScriptCount
   METHOD GlobalJavaScriptPackageName
   METHOD HasFontResources
   METHOD HasPageBox
   METHOD HidePage
   METHOD ImageCount
   METHOD ImageFillColor
   METHOD ImageHeight
   METHOD ImageHorizontalResolution
   METHOD ImageResolutionUnits
   METHOD ImageType
   METHOD ImageVerticalResolution
   METHOD ImageWidth
   METHOD ImportEMFFromFile
   METHOD InsertPages
   METHOD InsertTableColumns
   METHOD InsertTableRows
   METHOD IsAnnotFormField
   METHOD IsLinearized
   METHOD IsTaggedPDF
   METHOD LastErrorCode
   METHOD LastRenderError
   METHOD LayerCount                           // LayerCount             => ContentStreamCount
   METHOD LayerSafe                            // LayerSafe              => ContentStreamSafe
   METHOD LibraryVersion
   METHOD LibraryVersionEx
   METHOD LicenseInfo
   METHOD LinearizeFile
   METHOD Linearized                           // => IsLinearized()      renamed in 11.11
   METHOD LoadFromCanvasDC
   METHOD LoadFromFile
   METHOD LoadFromString
   METHOD LoadState
   METHOD MergeDocument
   METHOD MergeFileList
   METHOD MergeFileListFast
   METHOD MergeFiles
   METHOD MergeTableCells
   METHOD MoveContentStream
   METHOD MoveLayer                            // MoveLayer              => MoveContentStream
   METHOD MoveOutlineAfter
   METHOD MoveOutlineBefore
   METHOD MovePage
   METHOD MovePath
   METHOD MultiplyScale
   METHOD NewChildFormField
   METHOD NewContentStream
   METHOD NewCustomPrinter
   METHOD NewDestination
   METHOD NewDocument
   METHOD NewFormField
   METHOD NewInternalPrinterObject
   METHOD NewLayer                              // NewLayer               => NewContentStream
   METHOD NewNamedDestination
   METHOD NewOptionalContentGroup
   METHOD NewOutline
   METHOD NewPage
   METHOD NewPageFromCanvasDC
   METHOD NewPages
   METHOD NewPostScriptXObject
   METHOD NewRGBAxialShader
   METHOD NewSignProcessFromFile
   METHOD NewSignProcessFromString
   METHOD NewStaticOutline
   METHOD NewTilingPatternFromCapturedPage
   METHOD NoEmbedFontListAdd
   METHOD NoEmbedFontListCount
   METHOD NoEmbedFontListGet
   METHOD NoEmbedFontListRemoveAll
   METHOD NoEmbedFontListRemoveIndex
   METHOD NoEmbedFontListRemoveName
   METHOD NormalizePage
   METHOD OpenOutline
   METHOD OptionalContentGroupCount
   METHOD OutlineCount
   METHOD OutlineTitle
   METHOD PageCount
   METHOD PageHasFontResources
   METHOD PageHeight
   METHOD PageJavaScriptAction
   METHOD PageRotation
   METHOD PageWidth
   METHOD PrintDocument
   METHOD PrintDocumentToFile
   METHOD PrintMode
   METHOD PrintOptions
   METHOD PrintPages
   METHOD PrintPagesToFile
   METHOD ReleaseBuffer
   METHOD ReleaseImage
   METHOD ReleaseImageList
   METHOD ReleaseLibrary
   METHOD ReleaseSignProcess
   METHOD ReleaseStringList
   METHOD ReleaseTextBlocks
   METHOD RemoveAppearanceStream
   METHOD RemoveCustomInformation
   METHOD RemoveDocument
   METHOD RemoveEmbeddedFile
   METHOD RemoveFormFieldBackgroundColor
   METHOD RemoveFormFieldBorderColor
   METHOD RemoveFormFieldChoiceSub
   METHOD RemoveGlobalJavaScript
   METHOD RemoveOpenAction
   METHOD RemoveOutline
   METHOD RemovePageBox
   METHOD RemoveSharedContentStreams
   METHOD RemoveSharedLayers                  // RemoveSharedLayers     => RemoveSharedContentStreams
   METHOD RemoveStyle
   METHOD RemoveUsageRights
   METHOD RemoveXFAEntries
   METHOD RenderAsMultipageTIFFToFile
   METHOD RenderDocumentToFile
   METHOD RenderPageToDC
   METHOD RenderPageToDCClip
   METHOD RenderPageToFile
   METHOD RenderPageToString
   METHOD ReplaceFonts
   METHOD ReplaceImage
   METHOD ReplaceTag
   METHOD RequestPrinterStatus
   METHOD RetrieveCustomDataToFile
   METHOD RetrieveCustomDataToString
   METHOD ReverseImage
   METHOD RotatePage
   METHOD SaveFontToFile
   METHOD SaveImageListItemDataToFile
   METHOD SaveImageToFile
   METHOD SaveImageToString
   METHOD SaveState
   METHOD SaveStyle
   METHOD SaveToFile
   METHOD SaveToString
   METHOD SecurityInfo
   METHOD SelectContentStream
   METHOD SelectDocument
   METHOD SelectFont
   METHOD SelectImage
   METHOD SelectLayer                                // SelectLayer            => SelectContentStream
   METHOD SelectPage
   METHOD SelectRenderer
   METHOD SelectedDocument
   METHOD SelectedFont
   METHOD SelectedImage
   METHOD SelectedPage
   METHOD SetActionURL
   METHOD SetAdvancePassword
   METHOD SetAnnotBorderColor
   METHOD SetAnnotBorderColorRGB
   METHOD SetAnnotBorderColorXB                // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetAnnotBorderStyle
   METHOD SetAnnotContents
   METHOD SetAnnotDblProperty
   METHOD SetAnnotIntProperty
   METHOD SetAnnotOptional
   METHOD SetAnnotQuadPoints
   METHOD SetAnnotRect
   METHOD SetAnnotStrProperty
   METHOD SetAnsiMode
   METHOD SetAppendInputFromString
   METHOD SetBaseURL
   METHOD SetBlendMode
   METHOD SetBreakString
   METHOD SetCSDictEPSG
   METHOD SetCSDictType
   METHOD SetCSDictWKT
   METHOD SetCairoFileName
   METHOD SetCapturedPageOptional
   METHOD SetCapturedPageTransparencyGroup
   METHOD SetCatalogInformation
   METHOD SetCharWidth
   METHOD SetClippingPath
   METHOD SetClippingPathEvenOdd
   METHOD SetCompatibility
   METHOD SetContentStreamFromString
   METHOD SetContentStreamOptional
   METHOD SetCropBox
   METHOD SetCustomInformation
   METHOD SetCustomLineDash
   METHOD SetDPLRFileName
   METHOD SetDecodeMode
   METHOD SetDestProperties
   METHOD SetDestValue
   METHOD SetDocumentMetadata
   METHOD SetEmbeddedFileStrProperty
   METHOD SetFillColor
   METHOD SetFillColorCMYK
   METHOD SetFillColorRGB
   METHOD SetFillColorSep
   METHOD SetFillColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFillShader
   METHOD SetFillTilingPattern
   METHOD SetFindImagesMode
   METHOD SetFontEncoding
   METHOD SetFontFlags
   METHOD SetFormFieldAlignment
   METHOD SetFormFieldAnnotFlags
   METHOD SetFormFieldBackgroundColor
   METHOD SetFormFieldBackgroundColorCMYK
   METHOD SetFormFieldBackgroundColorGray
   METHOD SetFormFieldBackgroundColorRGB
   METHOD SetFormFieldBackgroundColorSep
   METHOD SetFormFieldBackgroundColorXB        // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldBorderColor
   METHOD SetFormFieldBorderColorCMYK
   METHOD SetFormFieldBorderColorGray
   METHOD SetFormFieldBorderColorRGB
   METHOD SetFormFieldBorderColorSep
   METHOD SetFormFieldBorderColorXB            // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldBorderStyle
   METHOD SetFormFieldBounds
   METHOD SetFormFieldCalcOrder
   METHOD SetFormFieldCaption
   METHOD SetFormFieldCheckStyle
   METHOD SetFormFieldChildTitle
   METHOD SetFormFieldChoiceSub
   METHOD SetFormFieldChoiceType
   METHOD SetFormFieldColor
   METHOD SetFormFieldColorCMYK
   METHOD SetFormFieldColorRGB
   METHOD SetFormFieldColorSep
   METHOD SetFormFieldColorXB                  // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetFormFieldComb
   METHOD SetFormFieldDefaultValue
   METHOD SetFormFieldDescription
   METHOD SetFormFieldFlags
   METHOD SetFormFieldFont
   METHOD SetFormFieldHighlightMode
   METHOD SetFormFieldIcon
   METHOD SetFormFieldIconStyle
   METHOD SetFormFieldMaxLen
   METHOD SetFormFieldNoExport
   METHOD SetFormFieldOptional
   METHOD SetFormFieldPage
   METHOD SetFormFieldPrintable
   METHOD SetFormFieldReadOnly
   METHOD SetFormFieldRequired
   METHOD SetFormFieldResetAction
   METHOD SetFormFieldRichTextString
   METHOD SetFormFieldRotation
   METHOD SetFormFieldSignatureImage
   METHOD SetFormFieldStandardFont
   METHOD SetFormFieldSubmitAction
   METHOD SetFormFieldSubmitActionEx
   METHOD SetFormFieldTabOrder
   METHOD SetFormFieldTextFlags
   METHOD SetFormFieldTextSize
   METHOD SetFormFieldTitle
   METHOD SetFormFieldValue
   METHOD SetFormFieldValueByTitle
   METHOD SetFormFieldVisible
   METHOD SetGDIPlusFileName
   METHOD SetGDIPlusOptions
   METHOD SetHTMLBoldFont
   METHOD SetHTMLBoldItalicFont
   METHOD SetHTMLItalicFont
   METHOD SetHTMLNormalFont
   METHOD SetHeaderCommentsFromString
   METHOD SetImageAsMask
   METHOD SetImageMask
   METHOD SetImageMaskCMYK
   METHOD SetImageMaskFromImage
   METHOD SetImageOptional
   METHOD SetImageResolution
   METHOD SetInformation
   METHOD SetJPEGQuality
   METHOD SetJavaScriptMode
   METHOD SetKerning
   METHOD SetLayerOptional                          // SetLayerOptional       => SetContentStreamOptional
   METHOD SetLineCap
   METHOD SetLineColor
   METHOD SetLineColorCMYK
   METHOD SetLineColorRGB
   METHOD SetLineColorSep
   METHOD SetLineColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetLineDash
   METHOD SetLineDashEx
   METHOD SetLineJoin
   METHOD SetLineShader
   METHOD SetLineWidth
   METHOD SetMarkupAnnotStyle
   METHOD SetMeasureDictBoundsCount
   METHOD SetMeasureDictBoundsItem
   METHOD SetMeasureDictCoordinateSystem
   METHOD SetMeasureDictGPTSCount
   METHOD SetMeasureDictGPTSItem
   METHOD SetMeasureDictLPTSCount
   METHOD SetMeasureDictLPTSItem
   METHOD SetMeasureDictPDU
   METHOD SetMeasurementUnits
   METHOD SetNeedAppearances
   METHOD SetObjectFromString
   METHOD SetObjectSource                            // SetObjectSource => SetObjectFromString
   METHOD SetOpenActionDestination
   METHOD SetOpenActionDestinationFull
   METHOD SetOpenActionJavaScript
   METHOD SetOpenActionMenu
   METHOD SetOptionalContentConfigLocked
   METHOD SetOptionalContentConfigState
   METHOD SetOptionalContentGroupName
   METHOD SetOptionalContentGroupPrintable
   METHOD SetOptionalContentGroupVisible
   METHOD SetOrigin
   METHOD SetOutlineColor
   METHOD SetOutlineColorRGB
   METHOD SetOutlineColorXB                    // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetOutlineDestination
   METHOD SetOutlineDestinationFull
   METHOD SetOutlineDestinationZoom
   METHOD SetOutlineJavaScript
   METHOD SetOutlineNamedDestination
   METHOD SetOutlineOpenFile
   METHOD SetOutlineRemoteDestination
   METHOD SetOutlineStyle
   METHOD SetOutlineTitle
   METHOD SetOutlineWebLink
   METHOD SetOverprint
   METHOD SetPDFAMode
   METHOD SetPNGTransparencyColor
   METHOD SetPageActionMenu
   METHOD SetPageBox
   METHOD SetPageContent                   // SetPageContent         => SetPageContentFromString
   METHOD SetPageContentFromString
   METHOD SetPageDimensions
   METHOD SetPageLayout
   METHOD SetPageMode
   METHOD SetPageSize
   METHOD SetPageThumbnail
   METHOD SetPageTransparencyGroup
   METHOD SetPageUserUnit
   METHOD SetPassword
   METHOD SetPrecision
   METHOD SetPrinterDevModeFromString
   METHOD SetRenderCropType
   METHOD SetRenderDCErasePage
   METHOD SetRenderDCOffset
   METHOD SetRenderOptions
   METHOD SetRenderScale
   METHOD SetScale
   METHOD SetSignProcessCustomDict
   METHOD SetSignProcessCustomSubFilter
   METHOD SetSignProcessField
   METHOD SetSignProcessFieldBounds
   METHOD SetSignProcessFieldImageFromFile
   METHOD SetSignProcessFieldImageFromString
   METHOD SetSignProcessFieldPage
   METHOD SetSignProcessInfo
   METHOD SetSignProcessKeyset
   METHOD SetSignProcessPFXFromFile
   METHOD SetSignProcessPFXFromString
   METHOD SetSignProcessPassthrough
   METHOD SetSignProcessSubFilter
   METHOD SetTabOrderMode
   METHOD SetTableBorderColor
   METHOD SetTableBorderColorCMYK
   METHOD SetTableBorderColorRGB
   METHOD SetTableBorderColorXB                // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableBorderWidth
   METHOD SetTableCellAlignment
   METHOD SetTableCellBackgroundColor
   METHOD SetTableCellBackgroundColorCMYK
   METHOD SetTableCellBackgroundColorRGB
   METHOD SetTableCellBackgroundColorXB        // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellBorderColor
   METHOD SetTableCellBorderColorCMYK
   METHOD SetTableCellBorderColorRGB
   METHOD SetTableCellBorderColorXB            // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellBorderWidth
   METHOD SetTableCellContent
   METHOD SetTableCellPadding
   METHOD SetTableCellTextColor
   METHOD SetTableCellTextColorCMYK
   METHOD SetTableCellTextColorRGB
   METHOD SetTableCellTextColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTableCellTextSize
   METHOD SetTableColumnWidth
   METHOD SetTableRowHeight
   METHOD SetTableThinBorders
   METHOD SetTableThinBordersCMYK
   METHOD SetTempFile
   METHOD SetTempPath
   METHOD SetTextAlign
   METHOD SetTextCharSpacing
   METHOD SetTextColor
   METHOD SetTextColorCMYK
   METHOD SetTextColorRGB
   METHOD SetTextColorSep
   METHOD SetTextColorXB                       // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextExtractionArea
   METHOD SetTextExtractionOptions
   METHOD SetTextExtractionScaling
   METHOD SetTextExtractionWordGap
   METHOD SetTextHighlight
   METHOD SetTextHighlightColor
   METHOD SetTextHighlightColorCMYK
   METHOD SetTextHighlightColorRGB
   METHOD SetTextHighlightColorSep
   METHOD SetTextHighlightColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextMode
   METHOD SetTextRise
   METHOD SetTextScaling
   METHOD SetTextShader
   METHOD SetTextSize
   METHOD SetTextSpacing
   METHOD SetTextUnderline
   METHOD SetTextUnderlineColor
   METHOD SetTextUnderlineColorCMYK
   METHOD SetTextUnderlineColorRGB
   METHOD SetTextUnderlineColorSep
   METHOD SetTextUnderlineColorXB              // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetTextUnderlineCustomDash
   METHOD SetTextUnderlineDash
   METHOD SetTextUnderlineDistance
   METHOD SetTextUnderlineWidth
   METHOD SetTextWordSpacing
   METHOD SetTransparency
   METHOD SetViewerPreferences
   METHOD SetXFAFormFieldAccess
   METHOD SetXFAFormFieldBorderColor
   METHOD SetXFAFormFieldBorderColorRGB
   METHOD SetXFAFormFieldBorderColorXB         // nXbColor = Xbase++ GRA_CLR_* numeric
   METHOD SetXFAFormFieldBorderPresence
   METHOD SetXFAFormFieldBorderWidth
   METHOD SetXFAFormFieldValue
   METHOD SetXFAFromString
   METHOD SetupCustomPrinter
   METHOD SignFile
   METHOD SplitPageText
   METHOD StartPath
   METHOD StoreCustomDataFromFile
   METHOD StoreCustomDataFromString
   METHOD StringResultLength
   METHOD TestTempPath
   METHOD TransformFile
   METHOD UnlockKey
   METHOD Unlocked
   METHOD UpdateAndFlattenFormField
   METHOD UpdateAppearanceStream
   METHOD UpdateTrueTypeSubsettedFont
   METHOD UseKerning
   METHOD UseUnsafeContentStreams
   METHOD UseUnsafeLayers                                // UseUnsafeLayers        => UseUnsafeContentStreams

ENDCLASS
*---------------------------------------------------
METHOD HBPrintPDF:INIT(cDefaultLanguage)
   ::_hdll_                      := 0
   ::_id_                        := 0
   ::nCharSet                    := set(_SET_CHARSET)
   ::aImageID                    := {}
   ::nLineWidth                  := ::nDefaultLineWidth := 0.3     // DrawLine etc.()
   ::nOldTextColorRed            := 0                              // 0 = Schwarz, black
   ::nOldTextColorGreen          := 0
   ::nOldTextColorBlue           := 0
   ::nOldTextHighlightColorRed   := 0
   ::nOldTextHighlightColorGreen := 0
   ::nOldTextHighlightColorBlue  := 0
   ::nOldTextUnderlineColorRed   := 0
   ::nOldTextUnderlineColorGreen := 0
   ::nOldTextUnderlineColorBlue  := 0
   ::nAktiveFillColorRed         := 0
   ::nAktiveFillColorGreen       := 0
   ::nAktiveFillColorBlue        := 0
   ::cQuickPdfDllName            := "DebenuPDFLibraryDLL1115.dll" // ==> :create() sucht eine vorhandene Datei, wenn diese nicht geladen werden kann.
   ::nDefaultPageSize            := "A4"
   ::nDefaultMeasurementUnits    := MEASUREMENTUNITS_MM
   ::nPageDefaultOrigin          := PAGE_ORIGIN_TOP_LEFT
   ::nDefaultStandardFont        := STANDARDFONTID_ARIAL
   ::nDefaultBoldFont            := STANDARDFONTID_ARIALBOLD
   ::nDefaultItalicFont          := STANDARDFONTID_ARIALITALIC
   ::nDefaultItalicBoldFont      := STANDARDFONTID_ARIALBOLDITALIC
   ::nDefaultStandardFontSize    := 12 // 12 Punkt
   if cDefaultLanguage==NIL
      ::cErrorLanguage           := "DE"      // 2 Bytes => UPPER( ISO 639-1 ) es = espania, en = english, fr = french, de = germany
   else
      ::cErrorLanguage           := upper(alltrim(cDefaultLanguage))
   endif
   do case
      case "*"+::cErrorLanguage+"*" $ "*D*DE*"
         ::cErrorLanguage        := "DE"
         ::cErrorLoadDll         := "Fehler beim Laden von Quick PDF DLL ("+::cQuickPdfDllName+" ff). Ist diese vorhanden ?"
         ::cErrorNoInstance      := "Quick PDF DLL konnte nicht initialisiert werden !"
         ::cErrorNoLicenseOK     := "Lizenz Key wurde nicht akzeptiert !"
         ::cErrorNoLicenseKey    := "Parameter cKey (Lizenz Key) wurde nicht bergeben !"
         ::cErrorNotMinVerOT4XB  := "Version 1.5.12.21 oder hher von ot4xb wird bentigt. www.xbwin.com"

         ::cDefaultYes           := "Ja"
         ::cDefaultNo            := "Nein"

      case "*"+::cErrorLanguage+"*" $ "*ES*"
         ::cErrorLoadDll         := "No se ha podido cargar la DLL Quick PDF ("+::cQuickPdfDllName+" ff). Probablemente no se ha podido hallar."
         ::cErrorNoInstance      := "No se ha podido inicializar una nueva instancia de la DLL Quick PDF"
         ::cErrorNoLicenseOK     := "La licencia no ha sido aceptada !"
         ::cErrorNoLicenseKey    := "Falta el parmetro cKey, la clave de la licencia no est definida"
         ::cErrorNotMinVerOT4XB  := "Se requiere ot4xb 1.5.12.21 o superior, busca en  www.xbwin.com"

         ::cDefaultYes           := "Si"
         ::cDefaultNo            := "No"

      case "*"+::cErrorLanguage+"*" $ "*FR*"
         ::cErrorLoadDll         := "La DLL Quick PDF ("+::cQuickPdfDllName+" ff). Peut-tre pas trouve ?"
         ::cErrorNoInstance      := "Une nouvelle instance de la DLL Quick PDF n'a pas pu tre cre."
         ::cErrorNoLicenseOK     := "La licence est refuse !"
         ::cErrorNoLicenseKey    := "Le paramtre cKey est manquant, la cl de la licence n'est pas dfinie."
         ::cErrorNotMinVerOT4XB  := "ot4xb 1.5.12.21 ou superieur requis, voir www.xbwin.com"

         ::cDefaultYes           := "Oui"
         ::cDefaultNo            := "Non"

      otherwise     // Englisch / english
         ::cErrorLoadDll         := "Could not load Quick PDF DLL ("+::cQuickPdfDllName+" ff). Maybe not found ?"
         ::cErrorNoInstance      := "The instance of Quick PDF Library could not be created !"
         ::cErrorNoLicenseOK     := "License key was not accepted !"
         ::cErrorNoLicenseKey    := "Missing Parameter cKey, license key was not defined !"
         ::cErrorNotMinVerOT4XB  := "ot4xb 1.5.12.21 or higher required, see www.xbwin.com"

         ::cDefaultYes           := "Yes"
         ::cDefaultNo            := "No"

   end

   if ::nCharSet = 1    // ANSI => OEM
      ::cErrorLoadDll          := ConvToOemCP(::cErrorLoadDll)
      ::cErrorNoInstance       := ConvToOemCP(::cErrorNoInstance)
      ::cErrorNoLicenseOK      := ConvToOemCP(::cErrorNoLicenseOK)
      ::cErrorNoLicenseKey     := ConvToOemCP(::cErrorNoLicenseKey)
      ::cErrorNotMinVerOT4XB   := ConvToOemCP(::cErrorNotMinVerOT4XB)
   endif              // OK OEM

   ::cDefaultNumFormat         := "999,999,999.99"

   ::nDefaultLPI               :=  6         //  6 lines per inch            // Zeilen  pro Zoll
   ::nDefaultCPI               := 10         // 10 chars per inch            // Zeichen pro Zoll
   ::nFirstLine                :=  4         //  3 lines TOP margin, first line in 4
   ::nLastLine                 := 67         //  3 lines BOTTOM margin, 70 Lines per Page in A4, last print line on 67
   ::nFirstRow                 :=  9         //  8 chars left margin  2 cm
   ::nLastRow                  := 78         //  4 chars right margin 1 cm
   ::nCPI                      := ::nDefaultCPI
   ::nLPI                      := ::nDefaultLPI
   ::nAlign                    := TEXT_ALIGN_LEFT
   ::PrintTextAlltrim          := .t.
   ::nPageNo                   := 1
   ::nTextUnderline            := TEXTUNDERLINE_NONE
   ::SayOrigin0                := .f.

   ::UseAutoConvUTF8           := .t.        // Vorgabe *** default

return self
*---------------------------------------------------
Method HBPrintPDF:Create(cKey)
   local aDLL, cDll, nDllVersion
   ::IsOK := .f.
   if empty(cKey)
      cKey := GetEnv("QUICKPDF_11_REGKEY")
   endif
   do case
      case empty(cKey)
           msgbox(::cErrorNoLicenseKey,"HBPrintPDF():Create(cKey)")
      case ot4xb() < "001.005.012.021"
           MsgBox(::cErrorNotMinVerOT4XB,"HBPrintPDF():Create(cKey)")
      otherwise
           // mit dem richtigen Namen kann die DLL auch im Pfad liegen, aber zu viele Anfragen ...
           // with this syntax the DLL could be found in a directory in the path, but don't ask too much.
           ::_hdll_ := dllLoad(::cQuickPdfDllName)
           if empty(::_hdll_)                          // hchste Version suchen - look newest version
              for nDllVersion := MAX_DLL_VERSION TO MIN_DLL_VERSION step -1
                  //       DebenuPDFLibraryDLL????.dll
                  cDll := "DebenuPDFLibraryDLL"+strZero(nDllVersion,4)+".dll"
                  ::_hdll_ := dllLoad(cDll)
                  if ! empty(::_hdll_)                          // hchste Version suchen - look newest version
                     exit
                  endif
              next
           endif
           if empty(::_hdll_)
              msgbox(::cErrorLoadDll,"HPPrintPDF() - dllLoad()")
           else
              ::_id_ := FpQCall( {::_hdll_,"DPLCreateLibrary"} ,"__sl__sl",::_id_)
              if empty(::_id_)
                 msgbox(::cErrorNoInstance,"HBPrintPDF():Create(cKey)")
              else
                 if ::UnlockKey(cKey)
                    if ::UseAutoConvUTF8
                       ::SetAnsiMode(0)                            // 0 = Ansi ist Standard, aber sicherheitshalber erzwingen.
                    else
                       ::SetAnsiMode(1)                            // 1 = UTF8
                    endif
                    ::IsOK := .t.
                    ::SetPageSize(::nDefaultPageSize)
                    ::SetMeasurementUnits(::nDefaultMeasurementUnits)
                    ::SetLineWidth(::nDefaultLineWidth)
                    ::SetOrigin(::nPageDefaultOrigin)
                    ::nDefaultStandardFontID       := ::AddStandardFont(::nDefaultStandardFont)
                    ::nDefaultBoldFontID           := ::AddStandardFont(::nDefaultBoldFont)
                    ::nDefaultItalicFontID         := ::AddStandardFont(::nDefaultItalicFont)
                    ::nDefaultItalicBoldFontID     := ::AddStandardFont(::nDefaultItalicBoldFont)
                    ::SetHTMLNormalFont("Default",    ::nDefaultStandardFontID  )
                    ::SetHTMLBoldFont("Default",      ::nDefaultBoldFontID      )
                    ::SetHTMLItalicFont("Default",    ::nDefaultItalicFontID    )
                    ::SetHTMLBoldItalicFont("Default",::nDefaultItalicBoldFontID)
                    ::SelectFont(::nDefaultStandardFontID)
                    ::SetTextSize(::nDefaultStandardFontSize)         // setzt auch ::nLineFeed / calculates ::nLineFeed
                 else
                    msgbox(::cErrorNoLicenseOK,"HBPrintPDF():Create(cKey)")
                    ::destroy()
                 endif
              endif
           endif
   end

return SELF
*---------------------------------------------------
Method HBPrintPDF:Destroy()
   if ::ReleaseLibrary()
      ::_id_   := 0
      ::_hdll_ := 0
   endif
return NIL
*---------------------------------------------------
Method HBPrintPDF:GetTextUnderline()
return ::nTextUnderline
*---------------------------------------------------
Method HBPrintPDF:GetPageSizeX()
return ::PageWidth()
*---------------------------------------------------
Method HBPrintPDF:GetPageSizeY()
return ::PageHeight()
*---------------------------------------------------
Method HBPrintPDF:SetLPI(nLPI)
  local nReturn
  if nLPI==NIL
     ::nLPI  := ::nDefaultLPI
     nReturn := ::nLPI
  else
     nReturn := ::nLPI
     ::nLPI  := nLPI
  endif
return nReturn
*---------------------------------------------------
Method HBPrintPDF:GetLPI()
return ::nLPI
*---------------------------------------------------
Method HBPrintPDF:SetCPI(nCPI)
  local nReturn
  if nCPI==NIL
     ::nCPI  := ::nDefaultCPI
     nReturn := ::nCPI
  else
     nReturn := ::nCPI
     ::nCPI  := nCPI
  endif
return nReturn
*---------------------------------------------------
Method HBPrintPDF:GetCPI()
return ::nCPI
*---------------------------------------------------
Method HBPrintPDF:SetSayLineFeed(nLineHeight)
   DEFAULT nLineHeight TO ::GetTextHeight()       // Standardhhe von Font / fonts standard height
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           ::nLPI := 25.4 / nLineHeight
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           ::nLPI :=  1.0 / nLineHeight
      otherwise  // Points = 1/72 Inch
           ::nLPI := 72.0 / nLineHeight
   end
return ::GetSayLineFeed()
*---------------------------------------------------
Method HBPrintPDF:GetSayLineFeed()
   local nLineHeight
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nLineHeight := 25.4 / ::nLPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nLineHeight :=  1.0 / ::nLPI
      otherwise  // Points = 1/72 Inch
           nLineHeight := 72.0 / ::nLPI
   end
return nLineHeight
*---------------------------------------------------
Method HBPrintPDF:SetSayLinesPerPage(nLinesPerPage)
   if nLinesPerPage==NIL
      ::SetSayLineFeed() // standard font size
   else
      ::SetSayLineFeed(::PageHeight()/nLinesPerPage)
   endif
return ::GetSayLinesPerPage()
*---------------------------------------------------
Method HBPrintPDF:GetSayLinesPerPage()
return ::PageHeight()/::GetSayLineFeed()
*---------------------------------------------------
Method HBPrintPDF:SetSayRowsPerPage(nRowsPerPage)
   local nPageWidthInInch  // Papierbreite in Inch
   do case
      case nRowsPerPage==NIL
           ::GetSayRowsPerPage()
      case  80 <= nRowsPerPage .and. nRowsPerPage <=  82
           ::SetCpi(10)
      case  96 <= nRowsPerPage .and. nRowsPerPage <=  98
           ::SetCpi(12)
      case 136 <= nRowsPerPage .and. nRowsPerPage <= 140
           ::SetCpi(17)
      otherwise
           do case
              case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
                   nPageWidthInInch := ::PageWidth() / 25.4
              case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
                   nPageWidthInInch := 1.0
              otherwise  // Points = 1/72 Inch
                   nPageWidthInInch := ::PageWidth() / 72.0
           end
           // 1 inch / nRowWidth in Inch
           ::SetCpi( 1 / (nPageWidthInInch/nRowsPerPage) )
   end
return ::GetSayRowsPerPage()
*---------------------------------------------------
Method HBPrintPDF:GetSayRowsPerPage()
return int(::PageWidth()/::GetCPICharWidth())
*---------------------------------------------------
Method HBPrintPDF:GetRowsPerInch()
return ::nCPI
*---------------------------------------------------
Method HBPrintPDF:GetCPICharWidth(nCPI) // Breite eines Zeichens mit nCPI
   local nSizeX
   DEFAULT nCPI TO ::GetCPI()
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nSizeX := 25.4 / nCPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nSizeX :=  1.0 / nCPI
      otherwise  // Points = 1/72 Inch
           nSizeX := 72.0 / nCPI
   end
return nSizeX
*---------------------------------------------------
Method HBPrintPDF:SAY(nRow,nCol,xData,cAlign,nCPI,nLPI) // min == 1,1
   local cTxt := "", nAlign
   do case
      case ValType(xData)=="D"
           cTxt := dtoc(xData)
      case ValType(xData)=="L"
           cTxt := iif(xData,::cDefaultYes,::cDefaultNo)
      case ValType(xData)=="N"
           cTxt := TransForm(xData,::cDefaultNumFormat)
           DEFAULT cAlign TO "R"
      case ValType(xData)=="C"
           cTxt := xData
      otherwise
           cTxt := var2char(xData)
   end
   DEFAULT cAlign TO "L"
   cAlign := upper(left(alltrim(cAlign)+"L",1))
   nAlign := ::GetTextAlign()  // alte Einstellung speichern, save old value
   do case
      case cAlign == "L"
           ::SetTextAlign(TEXT_ALIGN_LEFT)
      case cAlign == "R"
           ::SetTextAlign(TEXT_ALIGN_RIGHT)
      case cAlign == "C" .or. cAlign == "M" .or. cAlign == "Z"
           ::SetTextAlign(TEXT_ALIGN_CENTER)
   end
   ::DrawText(::nColToPosX(nCol,nCPI),::nRowToPosY(nRow,nLPI), cTxt )
   ::SetTextAlign(nAlign)
return self
*---------------------------------------------------
Method HBPrintPDF:SayLine(nRowTop,nColLeft,nRowBottom,nColRight,cAlign1,cAlign2,nOffset,nCPI,nLPI)
   local nStartX, nStartY, nEndX, nEndY, nSizeX, nSizeY,nOffsetX,nOffsetY

   DEFAULT nRowTop    TO 0
   DEFAULT nRowBottom TO 0
   DEFAULT nColLeft   TO 0
   DEFAULT nColRight  TO 0

   nStartY := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nStartX := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)

   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()

   if valtype(cAlign1)<>"C" .or. len(cAlign1) <> 2
      cAlign1 := NIL
   endif
   if valtype(cAlign2)<>"C" .or. len(cAlign2) <> 2
      cAlign2 := NIL
   endif

   DEFAULT nOffset TO 0

   do case
      case nRowTop == nRowBottom
           DEFAULT cAlign1 TO SAYLINE_ALIGN_MIDDLE_LEFT
           DEFAULT cAlign2 TO SAYLINE_ALIGN_MIDDLE_RIGHT
           nOffsetX := 0
           nOffsetY := nOffset
      case nColLeft == nColRight
           DEFAULT cAlign1 TO SAYLINE_ALIGN_TOP_CENTER
           DEFAULT cAlign2 TO SAYLINE_ALIGN_BOTTOM_CENTER
           nOffsetX := nOffset
           nOffsetY := 0
      otherwise
           DEFAULT cAlign1 TO SAYLINE_ALIGN_MIDDLE_CENTER // SAYLINE_ALIGN_TOP_LEFT
           DEFAULT cAlign2 TO SAYLINE_ALIGN_MIDDLE_CENTER // SAYLINE_ALIGN_BOTTOM_RIGHT
           nOffsetX := 0
           nOffsetY := 0
   end

   do case
      case cAlign1[1] == SAYLINE_ALIGN_LEFT
           // nStartX is OK
      case cAlign1[1] == SAYLINE_ALIGN_CENTER
           nStartX += nSizeX/2
      case cAlign1[1] == SAYLINE_ALIGN_RIGHT
           nStartX += nSizeX
   end

   do case
      case cAlign2[1] == SAYLINE_ALIGN_LEFT
           // nEndX is OK
      case cAlign2[1] == SAYLINE_ALIGN_CENTER
           nEndX += nSizeX/2
      case cAlign2[1] == SAYLINE_ALIGN_RIGHT
           nEndX += nSizeX
   end

   do case
      case cAlign1[2] == SAYLINE_ALIGN_TOP
           nStartY -= ::GetTextBound(GETTEXTBOUND_TOP)
      case cAlign1[2] == SAYLINE_ALIGN_MIDDLE
           nStartY -= ::GetTextBound(GETTEXTBOUND_TOP) - nSizeY/2
      case cAlign1[2] == SAYLINE_ALIGN_BASELINE
           // all OK
      case cAlign1[2] == SAYLINE_ALIGN_BOTTOM
           nStartY += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   end

   do case
      case cAlign2[2] == SAYLINE_ALIGN_TOP
           nEndY -= ::GetTextBound(GETTEXTBOUND_TOP)
      case cAlign2[2] == SAYLINE_ALIGN_MIDDLE
           nEndY -= ::GetTextBound(GETTEXTBOUND_TOP) - nSizeY/2
      case cAlign2[2] == SAYLINE_ALIGN_BASELINE
           // nEndY is OK
      case cAlign2[2] == SAYLINE_ALIGN_BOTTOM
           nEndY += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   end

   ::DrawLine(nStartX+nOffsetX, nStartY+nOffsetY, nEndX+nOffsetX, nEndY+nOffsetY)

return self
*---------------------------------------------------
Method HBPrintPDF:SayBox(nRowTop,nColLeft,nRowBottom,nColRight,nOffset,nDrawOptions,nCPI,nLPI)
   local nLeft, nTop, nWidth, nHeight, nEndY, nEndX, nSizeX, nSizeY, nMax, nMin
   DEFAULT nOffset TO 0
   DEFAULT nDrawOptions TO DRAWOPTIONS_OUTLINE
   DEFAULT nRowTop    TO 0
   DEFAULT nRowBottom TO 0
   DEFAULT nColLeft   TO 0
   DEFAULT nColRight  TO 0

   if nRowTop > nRowBottom .or. nColLeft > nColRight // Fehler vermeiden
      nMax := max(nRowTop,nRowBottom)
      nMin := min(nRowTop,nRowBottom)
      nRowTop    := nMin
      nRowBottom := nMax
      nMax := max(nColLeft,nColRight)
      nMin := min(nColLeft,nColRight)
      nColLeft   := nMin
      nColRight  := nMax
   endif

   // char -> mm
   nTop    := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nLeft   := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)

   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()

   nTop    -= ::GetTextBound(GETTEXTBOUND_TOP)
   nEndY   += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   nWidth  := nEndX - nLeft + nSizeX
   nHeight := nEndY - nTop

   ::DrawBox(nLeft-nOffset, nTop-nOffset, nWidth+nOffset*2, nHeight+nOffset*2, nDrawOptions)

return self
*---------------------------------------------------
Method HBPrintPDF:SayImage(nRowTop,nColLeft,nRowBottom,nColRight,nRotate,nCPI,nLPI,lRatio)
   local nLeft, nTop, nWidth, nHeight, nEndY, nEndX, nSizeX, nSizeY, nMax, nMin, IsOK
   local nSizeBmpX,nSizeBmpY, nFaktor := 1
   DEFAULT nRowTop     TO 0
   DEFAULT nRowBottom  TO 0
   DEFAULT nColLeft    TO 0
   DEFAULT nColRight   TO 0
   DEFAULT lRatio      TO .t.

   if nRowTop > nRowBottom .or. nColLeft > nColRight // Fehler vermeiden
      nMax := max(nRowTop,nRowBottom)
      nMin := min(nRowTop,nRowBottom)
      nRowTop    := nMin
      nRowBottom := nMax
      nMax := max(nColLeft,nColRight)
      nMin := min(nColLeft,nColRight)
      nColLeft   := nMin
      nColRight  := nMax
   endif

   // char -> mm
   nTop    := ::nRowToPosY(nRowTop,@nLPI)   // nLPI etc. Standardwerte laden
   nLeft   := ::nColToPosX(nColLeft,@nCPI)  // nLPI etc. get back the default values
   nEndY   := ::nRowToPosY(nRowBottom,@nLPI)
   nEndX   := ::nColToPosX(nColRight,@nCPI)
   nSizeX  := ::GetCPICharWidth(nCPI)
   nSizeY  := ::GetSayLineFeed()
   nTop    -= ::GetTextBound(GETTEXTBOUND_TOP)
   nEndY   += nSizeY - ::GetTextBound(GETTEXTBOUND_TOP)
   nWidth  := nEndX - nLeft + nSizeX
   nHeight := nEndY - nTop

   if lRatio
           // ::PrintBmp(    nPosX,  nPosY,   nXSize,    nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit  ) // -> lSuccess
      IsOK := ::PrintBMP(  nLeft+1, nTop+1, nWidth-2, nHeight-2,            ,    ,        ,        , nRotate, NIL , NIL )
   else
           // ::DrawImage(   nLeft, nTop  , nWidth  , nHeight  )    // druckt auch verzerrt - not fine, but fit in place.           // -> lSuccess
      IsOK := ::DrawImage( nLeft+1, nTop+1, nWidth-2, nHeight-2)
   endif
return IsOK
*---------------------------------------------------
Method HBPrintPDF:nColToPosX(nCol,nCPI)                  // -> :say(nCol,
   local nCharWidth, nPosX
   DEFAULT nCol TO ::nFirstRow
   DEFAULT nCPI TO ::nCPI
   if ::SayOrigin0                                       // Clipper Top Left 0,0
      nCol++
   endif
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nCharWidth := 25.4 / nCPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nCharWidth :=  1.0 / nCPI
      otherwise  // Points = 1/72 Inch
           nCharWidth := 72.0 / nCPI
   end
   nCol--  // nCol soll gedruckt werden ...
   nPosX := max(1,   nCol * nCharWidth )
return nPosX
*---------------------------------------------------
Method HBPrintPDF:nRowToPosY(nRow,nLPI)                  // -> :say(,nRow
   local nPageY, nLineHeight, nPosY
   DEFAULT nRow TO ::nFirstLine
   DEFAULT nLPI TO ::nLPI
   if ::SayOrigin0                                       // Clipper Top Left 0,0
      nRow++
   endif
   nPageY := ::PageHeight()
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           nLineHeight := 25.4 / nLPI
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           nLineHeight :=  1.0 / nLPI
      otherwise  // Points = 1/72 Inch
           nLineHeight := 72.0 / nLPI
   end
   if ::GetOrigin()==PAGE_ORIGIN_TOP_LEFT
      nPosY := max(1, nRow * nLineHeight)
   else
      nPosY := max(1, nPageY - (nRow * nLineHeight))
   endif
return nPosY
*---------------------------------------------------
Method HBPrintPDF:GetColorRGB(nXbaseGraColorConstant,nRGB )           // Xbase++ color -> {r,g,b} || nRGB -> 1=red-part, 2=green-part, 3 = blue-part
   local xReturn,x
   static aColorTable :=  { { GRA_CLR_WHITE     , {   1,   1,   1 } } ,;            // RGB  0 - 255 => 0.0000000 - 1.0000000
                            { GRA_CLR_BLACK     , {   0,   0,   0 } } ,;
                            { GRA_CLR_BLUE      , {   0,   0,   1 } } ,;
                            { GRA_CLR_RED       , {   1,   0,   0 } } ,;
                            { GRA_CLR_PINK      , {   1,   0,   1 } } ,;
                            { GRA_CLR_GREEN     , {   0,   1,   0 } } ,;
                            { GRA_CLR_CYAN      , {   0,   1,   1 } } ,;
                            { GRA_CLR_YELLOW    , {   1,   1,   0 } } ,;
                            { GRA_CLR_DARKGRAY  , { 0.5, 0.5, 0.5 } } ,;
                            { GRA_CLR_DARKBLUE  , {   0,   0, 0.5 } } ,;
                            { GRA_CLR_DARKRED   , { 0.8,   0,   0 } } ,;
                            { GRA_CLR_DARKPINK  , { 0.6,   0, 0.6 } } ,;
                            { GRA_CLR_DARKGREEN , {   0, 0.6,   0 } } ,;
                            { GRA_CLR_DARKCYAN  , {   0, 0.6, 0.6 } } ,;
                            { GRA_CLR_BROWN     , { 0.5, 0.25,  0 } } ,;
                            { GRA_CLR_PALEGRAY  , { 0.7, 0.7 ,0.7 } } }
   DEFAULT nXbaseGraColorConstant TO GRA_CLR_BLACK
   DEFAULT nRGB TO 0
   x := aScan(aColorTable,{|aC| aC[1]==nXbaseGraColorConstant })
   do case
      case empty(x) .and. empty(nRGB)
           xReturn := {0,0,0}
      case empty(x)
           xReturn := 0
      case empty(nRGB)
           xReturn := aColorTable[x,2]
      otherwise
           xReturn := aColorTable[x,2,nRGB]
   end
return xReturn
*---------------------------------------------------
METHOD HBPrintPDF:getPageNo(cDataType)
   local uReturn
   if cDataType==NIL
      cDataType := "N"
   else
      cDataType := upper(alltrim(cDataType))
   endif
   do case
      case cDataType == "N"
           uReturn := ::nPageNo
      case cDataType == "C"
           uReturn := alltrim(str(::nPageNo))
   end
return uReturn
*---------------------------------------------------
METHOD HBPrintPDF:PrintPageNo(nPosX, nPosY, cMask, cAlign, xColor)
   DEFAULT nPosX  TO ::PageWidth()/2
   DEFAULT nPosY  TO ::PageHeight()-12
   DEFAULT cMask  TO "- #PN -"
   DEFAULT cAlign TO "C"
   cMask := strTran(cMask,"#PN",::getPageNo("C"))
   cMask := strTran(cMask,"#PC",alltrim(str(::PageCount())))
return ::PrintText( nPosX, nPosY, cMask, cAlign,,, xColor)
*---------------------------------------------------
METHOD HBPrintPDF:PrintText( nPosX, nPosY, xData, cAlign, nMaxLen, cArt, xColor, nDrehen )
                        //old              cTxt   cAusrichtung     n/a   nFarbe
   local cTxt := "", nAlign, lAppendText, lColorChanged := .f., aResetColor

   DEFAULT cAlign  TO " "
   DEFAULT nDrehen TO 0
   // :AppendText() .or. :DrawText() ?
   lAppendText := ( nPosX == NIL .or. nPosY == NIL )
   // xData -> String
   do case
      case ValType(xData)=="D"
           cTxt := dtoc(xData)
      case ValType(xData)=="L"
           cTxt := iif(xData,::cDefaultYes,::cDefaultNo)
      case ValType(xData)=="N"
           cTxt := TransForm(xData,::cDefaultNumFormat)
           DEFAULT cAlign TO "R"
      case ValType(xData)=="C"
           cTxt := xData
      otherwise
           cTxt := var2char(xData)
   end
   // cAlign / cAusrichtung
   nAlign := ::GetTextAlign()  // alte Einstellung speichern, save old value
   do case
      case lAppendText
           cAlign  := " "
           nDrehen := 0
      case cAlign == "L"
           ::SetTextAlign(TEXT_ALIGN_LEFT)
      case cAlign == "R"
           ::SetTextAlign(TEXT_ALIGN_RIGHT)
      case cAlign == "C" .or. cAlign == "M" .or. cAlign == "Z"
           ::SetTextAlign(TEXT_ALIGN_CENTER)
   end
   // lnger als nMaxLen ? / too long ?
   if ValType(nMaxLen)=="N" .and. ! empty(nMaxLen)
      do while ::GetTextWidth(cTxt) > nMaxLen .and. ! empty(cTxt)
         cTxt := left(cTxt,len(cTxt)-1)
      enddo
   endif

   if xColor == NIL
      // don't change the color
      lColorChanged := .f.
   else
      if ValType(xColor)=="A"  // RGB Array !
         // don't change xColor !
      else
         // get the RGB Array out of the Xbase++ color number
         xColor := ::GetColorRGB(xColor,0) // xColor := {r,g,b}
      endif
      // save the last set colors
      aResetColor := { ::nOldTextColorRed , ::nOldTextColorGreen , ::nOldTextColorBlue }
      ::SetTextColor(xColor[1],xColor[2],xColor[3]) // change the values of ::nOldTextColorRed, ::nOldTextColorGreen, ::nOldTextColorBlue
      lColorChanged := .t.
   endif

   // Append, Rotate, normal ?
   do case
      case lAppendText
           ::AppendText(cTxt)
      case ValType(nDrehen)=="N" .and. ! empty(nDrehen)
           ::DrawRotatedText(nPosX, nPosY,nDrehen,cTxt )
      otherwise
           ::DrawText(nPosX, nPosY, cTxt )
           if ! empty(cAlign)
              ::SetTextAlign(nAlign)
           endif
   end

   // Reset color
   if lColorChanged
      ::SetTextColor(aResetColor[1], aResetColor[2], aResetColor[3])
   endif

return .t.
*---------------------------------------------------
METHOD HBPrintPDF:PrintBmp( nPosX, nPosY, nXSize, nYSize, cFileNameID, nID, nHAlign, nVAlign, nRotate, nBox, nDotsPerUnit )
   local nImageID, lFehler := .f., cErrTxt, nDLL, nOldLineWidth, nOldImage           // cFileNameID = C or N ...

   DEFAULT nHAlign TO 0
   DEFAULT nVAlign TO 0
   DEFAULT nRotate TO 0
   DEFAULT nBox    TO 0      //  nBox > 0 zeichnet eine Box auf die Auenkante
                             //  nBox > 0 draw a box outside the image

   do case
      case nRotate ==  90    // Passend zu SayImage()
           nRotate :=   1    //  90 degrees anti-clockwise
      case nRotate == 180    // Passend zu SayImage()
           nRotate :=   3    // 180 degrees
      case nRotate == 270    // Passend zu SayImage()
           nRotate :=   2    //  90 degrees clockwise
      otherwise
           nRotate :=   0    //  normal
   endcase

   // wird nur verwendet, wenn nXSize, nYSize nicht angegeben sind.
   // if nXSize, nYSize are nil, this parameter will scale the bitmap
   do case
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_MM
           DEFAULT nDotsPerUnit TO       5 // 5 Punkte pro mm, 5 dots per mm            100 => 20mm, 160 => 32 mm
      case ::nDefaultMeasurementUnits == MEASUREMENTUNITS_INCH
           DEFAULT nDotsPerUnit TO     128 // 128 dots per Inch ( 5 * 25.6 mm = 128 )
      otherwise  // Points = 1/72 Inch
           DEFAULT nDotsPerUnit TO       1.7778 // dots per point
   end

   nOldImage := ::SelectedImage()

   do case
      case nID==NIL .and. empty(cFileNameID)
           // Keine Resource, Kein Dateiname, Kein Stringpuffer => aktuell selektierte Grafik benutzen !
           // NO resource, NO filename, NO Stringbuffer         => use selected image
           if nOldImage # 0
              // OK
           else
              cErrTxt := "NO IMAGE SELECTED"
              lFehler := .t.
           endif
      case nID==NIL .and. valtype(cFileNameID)=="C"
           // Dateiname !
           nImageID := ::AddImageFile(cFileNameID,0)
           if nImageID > 0
              // OK
           else
              cErrTxt := "FILENAME NOT VALID"
              lFehler := .t.
           endif
      case nID==NIL .and. valtype(cFileNameID)=="N"
           // Image ID  !
           if ::SelectImage(cFileNameID)
              // OK
           else
              cErrTxt := "IMAGEID NOT VALID"
              lFehler := .t.
           endif
      case nID==NIL
           // ERROR
           cErrTxt := "PARAMETER ERROR ID"
           lFehler := .t.
      case nID == -1          // XbpBitmap SetBuffer() String
           if valtype(cFileNameID)=="C" .and. ! empty(cFileNameID)
              nImageID := ::AddImageFromXbpBMP(cFileNameID)
              if nImageID > 0
                 ::AddImageID(nImageID,"PBMP"+alltrim(str(seconds())))
              else
                 cErrTxt := "BMP-BUFFER NOT VALID"
                 lFehler := .t.
              endif
           else
              cErrTxt := "BMP-BUFFER NOT VALID"
              lFehler := .t.
           endif
      case nID > 0            // RESOURCE ID
           if valtype(cFileNameID)=="C" .and. ! empty(cFileNameID) // IN DLL
              nDLL := DllLoad(cFileNameID)
           else
              nDLL := NIL
           endif
           nImageID := ::AddImageResource(nID,0,nDLL)
           if nImageID > 0
              // OK
           else
              cErrTxt := "RESOURCE-ID NOT VALID"
              lFehler := .t.
           endif
      otherwise
           // ERROR
           cErrTxt := "PARAMETER ERROR"
           lFehler := .t.
   end

   if empty(nXSize) .or. empty(nYSize)
      if nRotate==1 .or. nRotate==2 // 90 oder 270
         nYSize := ::ImageWidth()  / nDotsPerUnit
         nXSize := ::ImageHeight() / nDotsPerUnit
      else
         nXSize := ::ImageWidth()  / nDotsPerUnit
         nYSize := ::ImageHeight() / nDotsPerUnit
      endif
      if empty(nXSize) .or. empty(nYSize)
         cErrTxt := "IMAGE SIZE 0"
         lFehler := .t.
      endif
   endif

   if lFehler
      ::PrintText( nPosX, nPosY, cErrTxt )
   else
      if ::FitImage(nPosX, nPosY, nXSize, nYSize, nHAlign, nVAlign, nRotate)
         if nBox < 0
            nBox := ::nDefaultLineWidth
         endif
         // OK
         if nBox > 0
            nOldLineWidth := ::SetLineWidth(nBox)
            ::DrawBox(nPosX, nPosY, nXSize, nYSize, 0) // outline
            ::SetLineWidth(nOldLineWidth)
         endif
      else
         ::PrintText( nPosX, nPosY, "IMAGE PRINT ERROR" )
         lFehler := .t.
      endif
   endif

   if nOldImage <> ::SelectedImage()
      ::SelectImage(nOldImage)
   endif

return ! lFehler
*---------------------------------------------------
Method HBPrintPDF:IsTrue(nWert)
Return nWert # 0
*---------------------------------------------------
Method HBPrintPDF:IsFalse(nWert)
Return nWert == 0
*---------------------------------------------------
Method HBPrintPDF:GetTextAlign()
return ::nAlign
*---------------------------------------------------
Method HBPrintPDF:LineFeed( nLines, nDistance )
    local nValue
    DEFAULT nLines       TO 1
    DEFAULT ::nLineFeed  TO ::GetTextHeight()
    DEFAULT nDistance    TO ::nLineFeed
    nValue := nLines * nDistance
RETURN nValue
*---------------------------------------------------
Method HBPrintPDF:nBaselineToTop(nPosY)
return nPosY - ::GetTextBound(GETTEXTBOUND_TOP)
*---------------------------------------------------
Method HBPrintPDF:nTopToBaseline(nTop)
return nTop  + ::GetTextBound(GETTEXTBOUND_TOP)
*---------------------------------------------------
Method HBPrintPDF:GetPrinterBinA(p1)
   local aBin := {}
   DEFAULT p1 TO ::GetDefaultPrinterName()
   aBin := tokenize(alltrim(::GetPrinterBins(p1)),CRLF)  // {[1,"Name 1"]CRLF[2,"Name 2"]CRLF...} -> {[1,"Name 1"],[2,"Name 2"],...}
   aeval(aBin,{|cZeile,i| aBin[i] := &("{"+cZeile+"}")}) // {[1,"Name 1"],[2,"Name 2"],...}       -> {{1,"Name 1"},{2,"Name 2"},...}
return aBin
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterNameA(cPrinters)      // cPrinters := ::GetLatestPrinterNames() / ::GetPrinterNames()  ==> Array
   local aPrinter := {}, cDelim
   if empty(cPrinters)
      DEFAULT cPrinters TO ::GetPrinterNames()                   // -> ["Printer 1","Printer 2","Printer 3"]
   endif
   aPrinter  := &("{"+cPrinters+"}")        // -> [{"Printer 1","Printer 2","Printer 3"}] -> {"Printer 1","Printer 2","Printer 3"}
return aPrinter
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageID(nImageID,cName)
   local lError := .f.
   do case
      case nImageID==NIL .or. cName==NIL .or. ValType(nImageID)#"N" .or. ValType(cName)#"C"
           lError := .t.
      case empty(nImageID) .or. empty(cName)
           lError := .t.
      otherwise
           cName := upper(alltrim(cName))
           do case
              case 0 # aScan(::aImageID,{|aZ| aZ[1]==nImageID .and. aZ[2]==cName })
                   // OK !
              case 0 # aScan(::aImageID,{|aZ| aZ[2]==cName })
                   lError := .t.        // cName muss einmalig sein / cName have to be unique
              otherwise
                   aadd(::aImageID,{nImageID,cName})
           end
   end
return ! lError
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveImageID(xVal)
   local lError := .f., x, bSeek
   do case
      case xVal==NIL .or. ! valtype(xVal) $ "CN" .or. empty(xVal)
           lError := .t.
      case valtype(xVal) == "C"
           xVal  := upper(alltrim(xVal))
           bSeek := {|aZ| aZ[2]==xVal }

      case valtype(xVal) == "N"
           bSeek := {|aZ| aZ[1]==xVal }
   end
   if bSeek # NIL
      do while .t.
         x := aScan(::aImageID,bSeek)
         if x == 0
            exit
         else
            aRemove(::aImageID,x)
         endif
      enddo
   endif
return ! lError
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageIDByName(cName)
   local nImageID := 0  // not found, error !
   if valtype(cName)="C" .and. ! empty(cName)
      cName    := upper(alltrim(cName))
      nImageID := aScan(::aImageID,{|aZ| aZ[2]==cName })
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectImageByName(cName)
   local nImageID
   nImageID := ::GetImageIDByName(cName)
return ::SelectImage(nImageID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFile(cFileName, nOptions)  // -> QuickPDFAddImageFromFile(int InstanceID, char * FileName, int Options)
   local nImageID
   nImageID := ::GetImageIDByName(cFileName)                  // ist die Datei schon enthalten / only once
   if nImageID == 0
      nImageID := ::AddImageFromFile(cFileName, nOptions)
      if nImageID > 0 // OK !
         ::AddImageID(nImageID,cFileName)
      endif
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageFile(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate,cFileName,nOptions)
                                // -> QuickPDFAddImageFromFile(int InstanceID, char * FileName, int Options)
                                // -> QuickPDFFitImage(Left, Top, Width, Height: Double; HAlign, VAlign, Rotate: Integer): Integer;
   local nImageID, lOK := .f.
   nImageID := ::AddImageFile(cFileName, nOptions)
   if nImageID > 0
      lOK := ::FitImage(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate)
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageResource(nResourceID,nOptions,nDLL)          // ONLY / NUR    BMP BITMAP RESOURCEN !!!
   LOCAL nImageID, cImageName
   DEFAULT nResourceID TO 0
   if nResourceID > 0
      cImageName := "RES_ID_"+alltrim(str(nResourceID))
      // schon vorhanden ?
      nImageID := ::GetImageIDByName(cImageName)                  // ist das Image schon enthalten / only once
      if nImageID == 0
         nImageID := ::AddImageFromString(  ::cLoadResource(nDLL,nResourceID, 2, , .t. ) , nOptions )
         if nImageID > 0 // OK !
            ::AddImageID(nImageID,cImageName)
         endif
      endif
   endif
return nImageID
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageResource(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate,nResourceID,nOptions)
   local nImageID, lOK := .f.
   nImageID := ::AddImageResource(nResourceID,nOptions)
   if nImageID > 0
      lOK := ::FitImage(nLeft, nTop, nWidth, nHeight,nHAlign,nVAlign,nRotate)
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromXbpBMP(cBMP) // NUR BEI BMP fr Rckgabewert von XbpBitmap():setBuffer()   !!! *.BMP !!!
                                           // ONLY with BMP and return value from XbpBitmap():setBuffer()!!! *.BMP !!!
   if left(cBMP,2) # "BM"
      cBMP := "BM"+U2BIN(len(cBMP)+14)+W2BIN(0)+W2BIN(0)+U2BIN(BIN2U(left(cBMP,4))+14)+cBMP
   endif
return ::AddImageFromString(cBMP,0)        // !!! *.BMP !!!
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintCheckBox( nLeft, nPosY, nSize, cType )  // nSize auen/outline , cType="B" eckig/Box, "R" .or. "C" rund/circle
   local lOK, nTop
   DEFAULT nLeft TO 10
   DEFAULT nPosY TO 10
   DEFAULT nSize TO  3
   DEFAULT cType TO "B"

   nTop := nPosY - nSize   // auf die / on the baseline

   cType := upper(left(alltrim(cType)+"B",1))
   if cType=="B"
      lOK := ::DrawBox(nLeft+0.5, nTop, nSize, nSize, 0) // outline
   else
      lOK := ::DrawCircle(nLeft+0.5, nTop, nSize, 0) // outline
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CalcCheckDigit(uEAN13_Nr) // EAN13 -> 12 + checkDigit -> 13
   local x, lFehler := .f., nSummOdd, nSummEven, cOddEven, nCheckSummValue,;
         cCheckSummValue, cCheckSummDigit,nCheckSummDigit
   do case
      case Valtype(uEAN13_Nr)="N"
           uEAN13_Nr := left(alltrim(str(uEAN13_Nr,15,0)),12)
      case Valtype(uEAN13_Nr)="C"
           uEAN13_Nr := left(alltrim(uEAN13_Nr,15),12)
      otherwise
           cCheckSummDigit := "X"
           lFehler := .t.
   endcase
   if len(uEAN13_Nr) < 12 .and. ! lFehler // noch keine Fehlermeldung erhalten,
      cCheckSummDigit := "X" // -> error
      lFehler := .t.
   endif
   if ! lFehler
      nSummOdd  := 0
      nSummEven := 0
      cOddEven  := "E" // erste Position des EAN13 Strings ist per Definition EVEN !

      for x := 1 to 12
          if cOddEven = "E"
             nSummEven += val(substr(uEAN13_Nr,x,1))
             cOddEven  := "O"
          else
             nSummOdd  += val(substr(uEAN13_Nr,x,1))
             cOddEven  := "E"
          endif
      next

      // CheckSummDigit ist der Unterschied von nCheckSummValue zum nchsten vollen 10er.
      nCheckSummValue := nSummEven + nSummOdd * 3 // Gewichtung der Odd Position mit 3
      cCheckSummValue := right(alltrim(str(nCheckSummValue,15,0)),1) // letzte Position ermitteln
      nCheckSummDigit := 10 - val(cCheckSummValue) // von 0->0 1->9 2->8 etc.
      cCheckSummDigit := right(alltrim(str(nCheckSummDigit,3,0)),1)
   endif
return cCheckSummDigit
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateNewObject()
return FpQCall( {::_hdll_,"DPLCreateNewObject"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetBaseURL()
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetBaseURLA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupPrintable(iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"DPLGetOptionalContentGroupPrintable"} ,"__sl__sl__sl",::_id_,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupVisible(iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"DPLGetOptionalContentGroupVisible"} ,"__sl__sl__sl",::_id_,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetAnnotBorderColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFillColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldBackgroundColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldBorderColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorRGB(nIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetFormFieldColor(nIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetLineColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColorRGB(nID,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetOutlineColor(nID,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorRGB(nTableID,nBorderIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableBorderColor(nTableID,nBorderIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellBackgroundColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellBorderColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorRGB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTableCellTextColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextHighlightColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorRGB(nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetTextUnderlineColor(nR/255,nG/255,nB/255)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColorRGB(cXFAFieldName,nR,nG,nB)
   DEFAULT nR TO 0
   DEFAULT nG TO 0
   DEFAULT nB TO 0
return ::SetXFAFormFieldBorderColor(cXFAFieldName,nR/255,nG/255,nB/255)

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColorXB(nIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetAnnotBorderColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorXB(nXbColor)          // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFillColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorXB(nIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldBackgroundColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorXB(nIndex,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldBorderColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorXB(nIndex,nXbColor)       // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetFormFieldColor(nIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorXB(nXbColor)                   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetLineColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColorXB(nID,nXbColor)             // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetOutlineColor(nID,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorXB(nTableID,nBorderIndex,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableBorderColor(nTableID,nBorderIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellBackgroundColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,nXbColor)   // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellBorderColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nBorderIndex,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorXB(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,nXbColor)  // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTableCellTextColor(nTableID,nFirstRow,nFirstColumn,nLastRow,nLastColumn,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorXB(nXbColor)        // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorXB(nXbColor)     // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextHighlightColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorXB(nXbColor)     // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetTextUnderlineColor(::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColorXB(cXFAFieldName,nXbColor)    // nXbColor = Xbase++ GRA_CLR_* numeric
return ::SetXFAFormFieldBorderColor(cXFAFieldName,::GetColorRGB(nXbColor,1), ::GetColorRGB(nXbColor,2), ::GetColorRGB(nXbColor,3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARemoveUsageRights(iFileHandle)
return 0 # FpQCall( {::_hdll_,"DPLDARemoveUsageRights"} ,"__sl__sl__sl",::_id_,iFileHandle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImageMatrix(dM11, dM12, dM21, dM22, dMDX, dMDY)
return 0 # FpQCall( {::_hdll_,"DPLDrawImageMatrix"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,dM11,dM12,dM21,dM22,dMDX,dMDY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileID(iIndex)
return FpQCall( {::_hdll_,"DPLGetEmbeddedFileID"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NormalizePage(iNormalizeOptions)
return FpQCall( {::_hdll_,"DPLNormalizePage"} ,"__sl__sl__sl",::_id_,iNormalizeOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveUsageRights()
return 0 # FpQCall( {::_hdll_,"DPLRemoveUsageRights"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldSubmitAction(iIndex, sActionType, sLink)
   sActionType := ::ForceAnsi(sActionType)
   sLink       := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldSubmitActionA"} ,"__sl__sl__sl__pt__pt",::_id_,iIndex,sActionType,sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMarkupAnnotStyle(iIndex, dRed, dGreen, dBlue, dTransparency)
return FpQCall( {::_hdll_,"DPLSetMarkupAnnotStyle"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,iIndex,dRed,dGreen,dBlue,dTransparency)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderDCErasePage(iNewErasePage)
return FpQCall( {::_hdll_,"DPLSetRenderDCErasePage"} ,"__sl__sl__sl",::_id_,iNewErasePage)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAEmbedFileStreams(iFileHandle, sRootPath)
   sRootPath := ::ForceAnsi(sRootPath)
return FpQCall( {::_hdll_,"DPLDAEmbedFileStreamsA"} ,"__sl__sl__sl__pt",::_id_,iFileHandle,sRootPath)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldNoExport(iIndex)
return 0 # FpQCall( {::_hdll_,"DPLGetFormFieldNoExport"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldRequired(iIndex)
return 0 # FpQCall( {::_hdll_,"DPLGetFormFieldRequired"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveCustomInformation(sKey)
   sKey := ::ForceAnsi(sKey)
return FpQCall( {::_hdll_,"DPLRemoveCustomInformationA"} ,"__sl__sl__pt",::_id_,sKey)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderStyle(iIndex, dWidth, iStyle, dDashOn, dDashOff)
return FpQCall( {::_hdll_,"DPLSetAnnotBorderStyle"} ,"__sl__sl__sl__f8__sl__f8__f8",::_id_,iIndex,dWidth,iStyle,dDashOn,dDashOff)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldChoiceType(iIndex, iChoiceType)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldChoiceType"} ,"__sl__sl__sl__sl",::_id_,iIndex,iChoiceType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldNoExport(iIndex, iNoExport)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldNoExport"} ,"__sl__sl__sl__sl",::_id_,iIndex,iNoExport)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldRequired(iIndex, iRequired)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldRequired"} ,"__sl__sl__sl__sl",::_id_,iIndex,iRequired)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DADrawRotatedCapturedPage(iFileHandle, iDACaptureID, iDestPageRef, dPntLeft, dPntBottom, dPntWidth, dPntHeight, dAngle)
return 0 # FpQCall( {::_hdll_,"DPLDADrawRotatedCapturedPage"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8__f8",::_id_,iFileHandle,iDACaptureID,iDestPageRef,dPntLeft,dPntBottom,dPntWidth,dPntHeight,dAngle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageBox(iFileHandle, iPageRef, iBoxIndex, iDimension)
return FpQCall( {::_hdll_,"DPLDAGetPageBox"} ,"__f8__sl__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef,iBoxIndex,iDimension)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAHasPageBox(iFileHandle, iPageRef, iBoxIndex)
return 0 # FpQCall( {::_hdll_,"DPLDAHasPageBox"} ,"__sl__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef,iBoxIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPageFromCanvasDC(dDPI, iOptions)
return 0 # FpQCall( {::_hdll_,"DPLNewPageFromCanvasDC"} ,"__sl__sl__f8__sl",::_id_,dDPI,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListAdd(sFontName)
   sFontName := ::ForceAnsi(sFontName)
return 0 # FpQCall( {::_hdll_,"DPLNoEmbedFontListAddA"} ,"__sl__sl__pt",::_id_,sFontName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListCount()
return FpQCall( {::_hdll_,"DPLNoEmbedFontListCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListGet(iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLNoEmbedFontListGetA"} ,"__pt__sl__sl",::_id_,iIndex)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveAll()
return FpQCall( {::_hdll_,"DPLNoEmbedFontListRemoveAll"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveIndex(iIndex)
return 0 # FpQCall( {::_hdll_,"DPLNoEmbedFontListRemoveIndex"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NoEmbedFontListRemoveName(sFontName)
   sFontName := ::ForceAnsi(sFontName)
return 0 # FpQCall( {::_hdll_,"DPLNoEmbedFontListRemoveNameA"} ,"__sl__sl__pt",::_id_,sFontName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveImageToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"DPLSaveImageToString"} ,"__pt__sl",::_id_))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToDestination(dLeft, dTop, dWidth, dHeight, iDestID, iOptions)
return 0 # FpQCall( {::_hdll_,"DPLAddLinkToDestination"} ,"__sl__sl__f8__f8__f8__f8__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,iDestID,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompareOutlines(iFirstOutlineID, iSecondOutlineID)
return 0 # FpQCall( {::_hdll_,"DPLCompareOutlines"} ,"__sl__sl__sl__sl",::_id_,iFirstOutlineID,iSecondOutlineID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetPageBox(iFileHandle, iPageRef, iBoxIndex, dX1, dY1, dX2, dY2)
return 0 # FpQCall( {::_hdll_,"DPLDASetPageBox"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iFileHandle,iPageRef,iBoxIndex,dX1,dY1,dX2,dY2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestName(iDestID)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetDestNameA"} ,"__pt__sl__sl",::_id_,iDestID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontEncoding()
return FpQCall( {::_hdll_,"DPLGetFontEncoding"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineObjectNumber(iOutlineID)
return FpQCall( {::_hdll_,"DPLGetOutlineObjectNumber"} ,"__sl__sl__sl",::_id_,iOutlineID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetRenderScale()
return FpQCall( {::_hdll_,"DPLGetRenderScale"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewDestination(iDestPage, iZoom, iDestType, dLeft, dTop, dRight, dBottom)
return FpQCall( {::_hdll_,"DPLNewDestination"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iDestPage,iZoom,iDestType,dLeft,dTop,dRight,dBottom)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewNamedDestination(sDestName, iDestID)
   sDestName := ::ForceAnsi(sDestName)
return FpQCall( {::_hdll_,"DPLNewNamedDestinationA"} ,"__sl__sl__pt__sl",::_id_,sDestName,iDestID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFindImagesMode(iNewFindImagesMode)
return FpQCall( {::_hdll_,"DPLSetFindImagesMode"} ,"__sl__sl__sl",::_id_,iNewFindImagesMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageResolution(iHorizontal, iVertical, iUnits)
return 0 # FpQCall( {::_hdll_,"DPLSetImageResolution"} ,"__sl__sl__sl__sl__sl",::_id_,iHorizontal,iVertical,iUnits)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineNamedDestination(iOutlineID, sDestName)
   sDestName := ::ForceAnsi(sDestName)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineNamedDestinationA"} ,"__sl__sl__sl__pt",::_id_,iOutlineID,sDestName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineRemoteDestination(iOutlineID, sFileName, iOpenPage, iZoom, iDestType, dPntLeft, dPntTop, dPntRight, dPntBottom, iNewWindow)
   sFileName := ::ForceAnsi(sFileName)
   sFileName := ::PathFormatPdf(sFileName)
return FpQCall( {::_hdll_,"DPLSetOutlineRemoteDestinationA"} ,"__sl__sl__sl__pt__sl__sl__sl__f8__f8__f8__f8__sl",::_id_,iOutlineID,sFileName,iOpenPage,iZoom,iDestType,dPntLeft,dPntTop,dPntRight,dPntBottom,iNewWindow)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOverprint(iStrokingOverprint, iOtherOverprint, iOverprintMode)
return 0 # FpQCall( {::_hdll_,"DPLSetOverprint"} ,"__sl__sl__sl__sl__sl",::_id_,iStrokingOverprint,iOtherOverprint,iOverprintMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderDCOffset(iNewOffsetX, iNewOffsetY)
return FpQCall( {::_hdll_,"DPLSetRenderDCOffset"} ,"__sl__sl__sl__sl",::_id_,iNewOffsetX,iNewOffsetY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderScale(dNewScale)
return FpQCall( {::_hdll_,"DPLSetRenderScale"} ,"__sl__sl__f8",::_id_,dNewScale)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTextMarkupAnnotation(iMarkupType, dLeft, dTop, dWidth, dHeight)
return FpQCall({::_hdll_,"DPLAddTextMarkupAnnotation"},"__sl__sl__sl__f8__f8__f8__f8",::_id_,iMarkupType, dLeft, dTop, dWidth, dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearImage(iImageID)
return 0 # FpQCall({::_hdll_,"DPLClearImage"},"__sl__sl__sl",::_id_,iImageID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetAnnotationCount(iFileHandle,iPageRef)
return FpQCall({::_hdll_,"DPLDAGetAnnotationCount"},"__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionDest(iActionID)
return FpQCall({::_hdll_,"DPLGetActionDest"},"__sl__sl__sl",::_id_,iActionID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionURL(iActionID)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetActionURLA"} ,"__pt__sl__sl",::_id_,iActionID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotDest(iIndex)
return FpQCall({::_hdll_,"DPLGetAnnotDest"},"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotQuadCount(iIndex)
return FpQCall({::_hdll_,"DPLGetAnnotQuadCount"},"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotQuadPoints(iIndex,iQuadNumber,iPointNumber)
return FpQCall({::_hdll_,"DPLGetAnnotQuadCount"},"__f8__sl__sl__sl__sl",::_id_,iIndex,iQuadNumber,iPointNumber)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentFileSize()
return FpQCall({::_hdll_,"DPLGetDocumentFileSize"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldActionID(iIndex,sTriggerEvent)
   DEFAULT iIndex        TO 1
   sTriggerEvent := ::ForceAnsi(sTriggerEvent)
return FpQCall({::_hdll_,"DPLGetFormFieldActionIDA"},"__sl__sl__sl__pt",::_id_,iIndex,sTriggerEvent)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInstalledFontsByCharset( iCharsetIndex, iOptions)
   DEFAULT iCharsetIndex TO 2 // default Charset=2, ANSI=1 ??
   DEFAULT iOptions      TO 1 // CSV Rckgabe
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetInstalledFontsByCharsetA"} ,"__pt__sl__sl__sl",::_id_,iCharsetIndex, iOptions)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInstalledFontsByCodePage( iCodePage, iOptions )
   DEFAULT iCodePage TO 1252
   DEFAULT iOptions      TO 1 // CSV Rckgabe
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetInstalledFontsByCodePageA"} ,"__pt__sl__sl__sl",::_id_,iCodePage, iOptions)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMaxObjectNumber()
return FpQCall({::_hdll_,"DPLGetMaxObjectNumber"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigCount()
return FpQCall({::_hdll_,"DPLGetOptionalContentConfigCount"},"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderCount(iOptionalContentConfigID)
return FpQCall({::_hdll_,"DPLGetOptionalContentConfigOrderCount"},"__sl__sl__sl",::_id_,iOptionalContentConfigID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemID(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"DPLGetOptionalContentConfigOrderItemID"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemLabel(iOptionalContentConfigID, iItemIndex)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetOptionalContentConfigOrderItemLabelA"} ,"__pt__sl__sl__sl",::_id_,iOptionalContentConfigID, iItemIndex)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemLevel(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"DPLGetOptionalContentConfigOrderItemLevel"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigOrderItemType(iOptionalContentConfigID,iItemIndex)
return FpQCall({::_hdll_,"DPLGetOptionalContentConfigOrderItemType"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigState(iOptionalContentConfigID,iOptionalContentGroupID)
return FpQCall({::_hdll_,"DPLGetOptionalContentConfigState"},"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveXFAEntries(iOptions)
   DEFAULT iOptions TO 0 // PDF ->  Reserved for future use, should be set to 0.
return FpQCall({::_hdll_,"DPLRemoveXFAEntries"},"__sl__sl__sl",::_id_,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetActionURL(iActionID, sNewURL)
   sNewURL := ::ForceAnsi(sNewURL)
return 0 # FpQCall( {::_hdll_,"DPLSetActionURLA"} ,"__sl__sl__sl__pt",::_id_,iActionID, sNewURL)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotQuadPoints(iIndex, iQuadNumber,dX1,dY1,dX2,dY2,dX3,dY3,dX4,dY4)
return 0 # FpQCall( {::_hdll_,"DPLSetAnnotQuadPoints"} ,"__sl__sl__sl__f8__f8__f8__f8__f8__f8__f8__f8",::_id_,iIndex,iQuadNumber,dX1,dY1,dX2,dY2,dX3,dY3,dX4,dY4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionWordGap(dNewWordGap)
return 0 # FpQCall( {::_hdll_,"DPLSetTextExtractionWordGap"} ,"__sl__sl__f8",::_id_,dNewWordGap)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToLocalFile(nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall({::_hdll_,"DPLAddLinkToLocalFileA"},"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImagePageCountFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall({::_hdll_,"DPLGetImagePageCountFromString"},"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveEmbeddedFile(p1)
return 0 # FpQCall({::_hdll_,"DPLRemoveEmbeddedFile"},"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveGlobalJavaScript(PackageName)
   PackageName := ::ForceAnsi(PackageName)
return 0 # FpQCall({::_hdll_,"DPLRemoveGlobalJavaScriptA"},"__sl__sl__pt",::_id_,PackageName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RequestPrinterStatus(p1)
return FpQCall({::_hdll_,"DPLRequestPrinterStatus"},"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotBorderColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                           // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return FpQCall({::_hdll_,"DPLSetAnnotBorderColor"},"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCompatibility(p1,p2)
return 0 # FpQCall({::_hdll_,"DPLSetCompatibility"},"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetEmbeddedFileStrProperty(nIndex, nTag, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return FpQCall({::_hdll_,"DPLSetEmbeddedFileStrPropertyA"},"__sl__sl__sl__sl__pt",::_id_, nIndex, nTag, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddArcToPath(p1,p2,p3)
return FpQCall( {::_hdll_,"DPLAddArcToPath"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddCJKFont(p1)
return FpQCall( {::_hdll_,"DPLAddCJKFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddCurveToPath(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"DPLAddCurveToPath"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddEmbeddedFile(sFileName,sMIMEType)
   sFileName := ::ForceAnsi(sFileName)
   sMIMEType := ::ForceAnsi(sMIMEType)
return FpQCall( {::_hdll_,"DPLAddEmbeddedFileA"} ,"__sl__sl__pt__pt",::_id_,sFileName,sMIMEType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFileAttachment(sTitle, nEmbeddedFileID)
   sTitle := ::ForceAnsi(sTitle)
return 0 # FpQCall( {::_hdll_,"DPLAddFileAttachmentA"} ,"__sl__sl__pt__sl",::_id_,sTitle, nEmbeddedFileID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFormFieldSub(nI,sSubName)
   sSubName := ::ForceAnsi(sSubName)
return FpQCall( {::_hdll_,"DPLAddFormFieldSubA"} ,"__sl__sl__sl__pt",::_id_,nI,sSubName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFormFont(p1)
return FpQCall( {::_hdll_,"DPLAddFormFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddGlobalJavaScript(sPackageName,sJavaScript)
   sPackageName := ::ForceAnsi(sPackageName)
   sJavaScript  := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"DPLAddGlobalJavaScriptA"} ,"__sl__sl__pt__pt",::_id_,sPackageName,sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromFile(sFileName,nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddImageFromFileA"} ,"__sl__sl__pt__sl",::_id_,sFileName,nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromFileOffset(sFileName,nOffset,nDataLength,nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddImageFromFileOffsetA"} ,"__sl__sl__pt__sl__sl__sl",::_id_,sFileName,nOffset,nDataLength,nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddImageFromString(iSource, nOptions)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
return ::_ptb_free_( FpQCall({::_hdll_,"DPLAddImageFromString"},"__sl__sl__pt__sl",::_id_,::_b(iSource,ptb,1),nOptions) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLGIDictToPage(sDictContent)
   sDictContent := ::ForceAnsi(sDictContent)
return 0 # FpQCall( {::_hdll_,"DPLAddLGIDictToPageA"} ,"__sl__sl__pt",::_id_,sDictContent)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLineToPath(p1,p2)
return FpQCall( {::_hdll_,"DPLAddLineToPath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------

// <  9.11: METHOD HBPrintPDF:AddLinkToEmbeddedFile(nLeft, nTop, nWidth, nHeight, nEmbeddedFileID, sTitle, nOptions)  // 0 to 5 Icon, > 1000 mit transparency.
// >= 9.11: METHOD HBPrintPDF:AddLinkToEmbeddedFile(nLeft, nTop, nWidth, nHeight, nEmbeddedFileID, sTitle, sContents, nIconType, nTranspareny)
METHOD HBPrintPDF:AddLinkToEmbeddedFile(nLeft, nTop, nWidth, nHeight, nEmbeddedFileID, sTitle, sContents, nIconType, nTranspareny) // >= 9.11
   if valtype(sContents) = "N"                                  // stimmt das ? - is this correct ?
      nIconType := sContents // 0 to 5 == OK, 1000 to 1100 => 0 to 100 => nTranspareny
      sContents := sTitle
      if nIconType >= 1000
         nTranspareny := nIconType - 1000
         nIconType    := 0
      endif
   endif
   sTitle    := ::ForceAnsi(sTitle)
   sContents := ::ForceAnsi(sContents)
   DEFAULT nIconType    TO 0
   DEFAULT nTranspareny TO 0
return 0 # FpQCall( {::_hdll_,"DPLAddLinkToEmbeddedFileA"} ,"__sl__sl__f8__f8__f8__f8__sl__pt__pt__sl__sl",::_id_,nLeft, nTop, nWidth, nHeight, nEmbeddedFileID, sTitle, sContents, nIconType, nTranspareny)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToFile(nLeft, nTop, nWidth, nHeight, sFileName, nPage, nPosition, nNewWindow, nOptions)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLAddLinkToFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__f8__sl__sl",::_id_,;
                                       nLeft, nTop, nWidth, nHeight, sFileName, nPage, nPosition, nNewWindow, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToJavaScript(nLeft, nTop, nWidth, nHeight, sJavaScript, nOptions)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"DPLAddLinkToJavaScriptA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sJavaScript, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToPage(p1,p2,p3,p4,p5,p6,p7)
return 0 # FpQCall( {::_hdll_,"DPLAddLinkToPage"} ,"__sl__sl__f8__f8__f8__f8__sl__f8__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToWeb(nLeft, nTop, nWidth, nHeight, sLink, nOptions)
   sLink := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"DPLAddLinkToWebA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sLink, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddNoteAnnotation(nLeft, nTop, nAnnotType, nPopupLeft, nPopupTop, nPopupWidth,;
                                    nPopupHeight, sTitle, sContents, nRed, nGreen, nBlue, nOpen)
   sTitle    := ::ForceAnsi(sTitle)
   sContents := ::ForceAnsi(sContents)
return 0 # FpQCall( {::_hdll_,"DPLAddNoteAnnotationA"} ,"__sl__sl__f8__f8__sl__f8__f8__f8__f8__pt__pt__f8__f8__f8__sl",::_id_,;
                                    nLeft, nTop, nAnnotType, nPopupLeft, nPopupTop, nPopupWidth,;
                                    nPopupHeight, sTitle, sContents, nRed, nGreen, nBlue, nOpen)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddPageLabels(nStart, nStyle, nOffset, sPrefix)
   sPrefix := ::ForceAnsi(sPrefix)
return 0 # FpQCall( {::_hdll_,"DPLAddPageLabelsA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nStart, nStyle, nOffset, sPrefix)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSeparationColor(sColorName, nC, nM, nY, nK, nOptions)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLAddSeparationColorA"} ,"__sl__sl__pt__f8__f8__f8__f8__sl",::_id_,sColorName, nC, nM, nY, nK, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddStandardFont(p1)
return FpQCall( {::_hdll_,"DPLAddStandardFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSubsettedFont(sFontName, nCharsetIndex, sSubsetChars)
   sFontName    := ::ForceAnsi(sFontName)
   sSubsetChars := ::ForceAnsi(sSubsetChars)
return FpQCall( {::_hdll_,"DPLAddSubsettedFontA"} ,"__sl__sl__pt__sl__pt",::_id_,sFontName, nCharsetIndex, sSubsetChars)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSVGAnnotationFromFile(nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddSVGAnnotationFromFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddToBuffer(Buffer, Source, nSourceLength) // intern, nichts ndern => _b()
return FpQCall( {::_hdll_,"DPLAddToBuffer"} ,"__sl__sl__pt__pt__sl",::_id_, Buffer, Source, nSourceLength) // OK !
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddToFileList(sListName,sFileName)
   sListName := ::ForceAnsi(sListName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddToFileListA"} ,"__sl__sl__pt__pt",::_id_,sListName,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeFont(sFontName, nEmbed)
   sFontName := ::ForceAnsi(sFontName)
return FpQCall( {::_hdll_,"DPLAddTrueTypeFontA"} ,"__sl__sl__pt__sl",::_id_,sFontName, nEmbed)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeFontFromFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddTrueTypeFontFromFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddType1Font(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddType1FontA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddU3DAnnotationFromFile(nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddU3DAnnotationFromFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sFileName, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AnalyseFile(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"DPLAnalyseFileA"} ,"__sl__sl__pt__pt",::_id_,sFileName, sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AnnotationCount()
return FpQCall( {::_hdll_,"DPLAnnotationCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendSpace(p1)
return FpQCall( {::_hdll_,"DPLAppendSpace"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendTableColumns(p1,p2)
return FpQCall( {::_hdll_,"DPLAppendTableColumns"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendTableRows(p1,p2)
return FpQCall( {::_hdll_,"DPLAppendTableRows"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendText(sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLAppendTextA"} ,"__sl__sl__pt",::_id_,sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ApplyStyle(sStyleName)
   sStyleName := ::ForceAnsi(sStyleName)
return 0 # FpQCall( {::_hdll_,"DPLApplyStyleA"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AttachAnnotToForm(p1)
return 0 # FpQCall( {::_hdll_,"DPLAttachAnnotToForm"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:BeginPageUpdate()
return FpQCall( {::_hdll_,"DPLBeginPageUpdate"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CapturePage(p1)
return FpQCall( {::_hdll_,"DPLCapturePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CapturePageEx(p1,p2)
return FpQCall( {::_hdll_,"DPLCapturePageEx"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CharWidth(p1)
return FpQCall( {::_hdll_,"DPLCharWidth"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckObjects()
return FpQCall( {::_hdll_,"DPLCheckObjects"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckPageAnnots()
return FpQCall( {::_hdll_,"DPLCheckPageAnnots"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearFileList(sListName)
   sListName := ::ForceAnsi(sListName)
return 0 # FpQCall( {::_hdll_,"DPLClearFileListA"} ,"__sl__sl__pt",::_id_,sListName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearPageLabels()
return FpQCall( {::_hdll_,"DPLClearPageLabels"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClearTextFormatting()
return FpQCall( {::_hdll_,"DPLClearTextFormatting"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CloneOutlineAction(p1)
return FpQCall( {::_hdll_,"DPLCloneOutlineAction"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClonePages(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"DPLClonePages"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CloseOutline(p1)
return 0 # FpQCall( {::_hdll_,"DPLCloseOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ClosePath()
return FpQCall( {::_hdll_,"DPLClosePath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressContent()
return 0 # FpQCall( {::_hdll_,"DPLCompressContent"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressFonts(p1)
return 0 # FpQCall( {::_hdll_,"DPLCompressFonts"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressImages(p1)
return 0 # FpQCall( {::_hdll_,"DPLCompressImages"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CompressPage()
return 0 # FpQCall( {::_hdll_,"DPLCompressPage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CopyPageRanges(nDocumentID,sRangeList)
   sRangeList := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"DPLCopyPageRangesA"} ,"__sl__sl__sl__pt",::_id_,nDocumentID,sRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateBuffer(nBufferLength) // intern, nichts ndern => _b() => gibt Pointer auf Buffer zurck.
return FpQCall({::_hdll_,"DPLCreateBuffer"},"__pt__sl__sl",::_id_,nBufferLength) // OK ! *** don't change ***
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CreateTable(p1,p2)
return FpQCall( {::_hdll_,"DPLCreateTable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAAppendFile(p1)
return FpQCall( {::_hdll_,"DPLDAAppendFile"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACapturePage(p1,p2)
return FpQCall( {::_hdll_,"DPLDACapturePage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACapturePageEx(p1,p2,p3)
return FpQCall( {::_hdll_,"DPLDACapturePageEx"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DACloseFile(p1)
return 0 # FpQCall( {::_hdll_,"DPLDACloseFile"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DADrawCapturedPage(p1,p2,p3,p4,p5,p6,p7)
return 0 # FpQCall( {::_hdll_,"DPLDADrawCapturedPage"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAExtractPageText(p1,p2,p3)
Return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLDAExtractPageTextA"} ,"__pt__sl__sl__sl__sl",::_id_,p1,p2,p3)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAFindPage(p1,p2)
return FpQCall( {::_hdll_,"DPLDAFindPage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldCount(p1)
return FpQCall( {::_hdll_,"DPLDAGetFormFieldCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldTitle(p1,p2)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLDAGetFormFieldTitleA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetFormFieldValue(p1,p2)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLDAGetFormFieldValueA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageDataToString(p1,p2,p3)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"DPLDAGetImageDataToString"} ,"__pt__sl__sl__sl__sl",::_id_,p1,p2,p3))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageDblProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLDAGetImageDblProperty"} ,"__f8__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageIntProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLDAGetImageIntProperty"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetImageListCount(p1,p2)
return FpQCall( {::_hdll_,"DPLDAGetImageListCount"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetInformation(nFileHandle, sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLDAGetInformationA"} ,"__pt__sl__sl__pt",::_id_,nFileHandle, sKey)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetObjectCount(p1)
return FpQCall( {::_hdll_,"DPLDAGetObjectCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageCount(p1)
return FpQCall( {::_hdll_,"DPLDAGetPageCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageHeight(p1,p2)
return FpQCall( {::_hdll_,"DPLDAGetPageHeight"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageImageList(p1,p2)
return FpQCall( {::_hdll_,"DPLDAGetPageImageList"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageWidth(p1,p2)
return FpQCall( {::_hdll_,"DPLDAGetPageWidth"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAHidePage(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLDAHidePage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAMovePage(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"DPLDAMovePage"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DANewPage(p1)
return FpQCall( {::_hdll_,"DPLDANewPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DANewPages(p1,p2)
return FpQCall( {::_hdll_,"DPLDANewPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAOpenFile(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"DPLDAOpenFileA"} ,"__sl__sl__pt__pt",::_id_,sFileName, sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAOpenFileReadOnly(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"DPLDAOpenFileReadOnlyA"} ,"__sl__sl__pt__pt",::_id_,sFileName, sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAPageRotation(p1,p2)
return FpQCall( {::_hdll_,"DPLDAPageRotation"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToDC(nFileHandle, nPageRef, dDPI, nDC)
return 0 # FpQCall( {::_hdll_,"DPLDARenderPageToDC"} ,"__sl__sl__sl__sl__f8__sl",::_id_,nFileHandle, nPageRef, dDPI, nDC)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToFile(nFileHandle, nPageRef, nOptions, dDPI, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLDARenderPageToFileA"} ,"__sl__sl__sl__sl__sl__f8__pt",::_id_,nFileHandle, nPageRef, nOptions, dDPI, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARenderPageToString(nFileHandle, nPageRef, nOptions, dDPI)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"DPLDARenderPageToString"} ,"__pt__sl__sl__sl__sl__f8",::_id_,nFileHandle, nPageRef, nOptions, dDPI))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DARotatePage(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"DPLDARotatePage"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASaveAsFile(nFileHandle, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLDASaveAsFileA"} ,"__sl__sl__sl__pt",::_id_,nFileHandle, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASaveImageDataToFile(nFileHandle, nImageListID, nImageIndex, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLDASaveImageDataToFileA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nFileHandle, nImageListID, nImageIndex, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetInformation(nFileHandle, sKey, sNewValue)
   sKey      := ::ForceAnsi(sKey)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"DPLDASetInformationA"} ,"__sl__sl__sl__pt__pt",::_id_,nFileHandle, sKey, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetPageSize(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"DPLDASetPageSize"} ,"__sl__sl__sl__sl__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Decrypt()
return 0 # FpQCall( {::_hdll_,"DPLDecrypt"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DecryptFile(sInputFileName, sOutputFileName, sPassword)
   sInputFileName  := ::ForceAnsi(sInputFileName)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
   sPassword       := ::ForceAnsi(sPassword)
return 0 # FpQCall( {::_hdll_,"DPLDecryptFileA"} ,"__sl__sl__pt__pt__pt",::_id_,sInputFileName, sOutputFileName, sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteAnalysis(p1)
return 0 # FpQCall( {::_hdll_,"DPLDeleteAnalysis"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteAnnotation(p1)
return 0 # FpQCall( {::_hdll_,"DPLDeleteAnnotation"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteFormField(p1)
return 0 # FpQCall( {::_hdll_,"DPLDeleteFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteLayer()
return 0 # FpQCall( {::_hdll_,"DPLDeleteLayer"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteOptionalContentGroup(p1)
return 0 # FpQCall( {::_hdll_,"DPLDeleteOptionalContentGroup"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeletePageLGIDict(p1)
return 0 # FpQCall( {::_hdll_,"DPLDeletePageLGIDict"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeletePages(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLDeletePages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DocJavaScriptAction(sActionType,sJavaScript)
   sActionType := ::ForceAnsi(sActionType)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"DPLDocJavaScriptActionA"} ,"__sl__sl__pt__pt",::_id_,sActionType,sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DocumentCount()
return FpQCall( {::_hdll_,"DPLDocumentCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawArc(p1,p2,p3,p4,p5,p6,p7)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"DPLDrawArc"} ,"__sl__sl__f8__f8__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawBarcode(nLeft, nTop, nWidth, nHeight, sText, nBarcode, nOptions)
   sText := ::ForceAnsi(sText)
   if nBarcode == 2 // EAN13
      if len(sText)==12
         sText += ::CalcCheckDigit(sText)
      endif
   endif
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"DPLDrawBarcodeA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nBarcode, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawBox(p1,p2,p3,p4,p5)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"DPLDrawBox"} ,"__sl__sl__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawCapturedPage(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"DPLDrawCapturedPage"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawCircle(p1,p2,p3,p4)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"DPLDrawCircle"} ,"__sl__sl__f8__f8__f8__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawDataMatrixSymbol(nLeft, nTop, nModuleSize, sText, nEncoding, nSymbolSize, nOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"DPLDrawDataMatrixSymbolA"} ,"__sl__sl__f8__f8__f8__pt__sl__sl__sl",::_id_,;
                                                                nLeft, nTop, nModuleSize, sText, nEncoding, nSymbolSize, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawEllipse(p1,p2,p3,p4,p5)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"DPLDrawEllipse"} ,"__sl__sl__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawEllipticArc(p1,p2,p3,p4,p5,p6,p7,p8)
       ::SetFillColor() // set the color
return 0 # FpQCall( {::_hdll_,"DPLDrawEllipticArc"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawHTMLText(nLeft, nTop, nWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return 0 # FpQCall( {::_hdll_,"DPLDrawHTMLTextA"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nLeft, nTop, nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawHTMLTextBox(nLeft, nTop, nWidth, nHeight, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLDrawHTMLTextBoxA"} ,"__pt__sl__f8__f8__f8__f8__pt",::_id_,nLeft, nTop, nWidth, nHeight, sHTMLText)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawImage(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"DPLDrawImage"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawLine(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLDrawLine"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawMultiLineText(nXPos, nYPos, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLDrawMultiLineTextA"} ,"__sl__sl__f8__f8__pt__pt",::_id_,nXPos, nYPos, sDelimiter, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPath(p1)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"DPLDrawPath"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPathEvenOdd(p1)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"DPLDrawPathEvenOdd"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPostScriptXObject(p1)
return 0 # FpQCall( {::_hdll_,"DPLDrawPostScriptXObject"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedCapturedPage(p1,p2,p3,p4,p5,p6)
return 0 # FpQCall( {::_hdll_,"DPLDrawRotatedCapturedPage"} ,"__sl__sl__sl__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedImage(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"DPLDrawRotatedImage"} ,"__sl__sl__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedText(nXPos, nYPos, nAngle, sText)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"DPLDrawRotatedTextA"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nAngle, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedTextBox(nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLDrawRotatedTextBoxA"} ,"__sl__sl__f8__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRoundedBox(p1,p2,p3,p4,p5,p6)
       ::SetFillColor() // set the color
return FpQCall( {::_hdll_,"DPLDrawRoundedBox"} ,"__sl__sl__f8__f8__f8__f8__f8__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawScaledImage(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"DPLDrawScaledImage"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawSpacedText(nXPos, nYPos, nSpacing, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLDrawSpacedTextA"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nSpacing, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTableRows(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"DPLDrawTableRows"} ,"__f8__sl__sl__f8__f8__f8__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawText(nXPos, nYPos, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLDrawTextA"} ,"__sl__sl__f8__f8__pt",::_id_,nXPos, nYPos, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTextArc(nXPos, nYPos, nRadius, nAngle, sText, nDrawOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"DPLDrawTextArcA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nXPos, nYPos, nRadius, nAngle, sText, nDrawOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTextBox(nLeft, nTop, nWidth, nHeight, sText, nOptions)                  // *HB*
       local nPrintedLines
       ::DrawTextBoxNextTop := nTop
       sText := ::ForceAnsi(sText)
       nPrintedLines := FpQCall( {::_hdll_,"DPLDrawTextBoxA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nOptions)
       ::DrawTextBoxNextTop += ::LineFeed(nPrintedLines)
return nPrintedLines
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawWrappedText(nXPos, nYPos, nWidth, sText)
       sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLDrawWrappedTextA"} ,"__sl__sl__f8__f8__f8__pt",::_id_,nXPos, nYPos, nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EmbeddedFileCount()
return FpQCall( {::_hdll_,"DPLEmbeddedFileCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EmbedFile(sTitle, sFileName, sMIMEType)
   sTitle    := ::ForceAnsi(sTitle)
   sFileName := ::ForceAnsi(sFileName)
   sMIMEType := ::ForceAnsi(sMIMEType)
return 0 # FpQCall( {::_hdll_,"DPLEmbedFileA"} ,"__sl__sl__pt__pt__pt",::_id_,sTitle, sFileName, sMIMEType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncodePermissions(p1,p2,p3,p4,p5,p6,p7,p8)
return FpQCall( {::_hdll_,"DPLEncodePermissions"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Encrypt(sOwner, sUser, nStrength, nPermissions)
   sOwner := ::ForceAnsi(sOwner)
   sUser  := ::ForceAnsi(sUser)
return 0 # FpQCall( {::_hdll_,"DPLEncryptA"} ,"__sl__sl__pt__pt__sl__sl",::_id_,sOwner, sUser, nStrength, nPermissions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptFile(sInputFileName, sOutputFileName, sOwner, sUser, nStrength, nPermissions)
   sInputFileName  := ::ForceAnsi(sInputFileName)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
   sOwner          := ::ForceAnsi(sOwner)
   sUser           := ::ForceAnsi(sUser)
return 0 # FpQCall( {::_hdll_,"DPLEncryptFileA"} ,"__sl__sl__pt__pt__pt__pt__sl__sl",::_id_,sInputFileName, sOutputFileName, sOwner, sUser, nStrength, nPermissions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionAlgorithm()
return FpQCall( {::_hdll_,"DPLEncryptionAlgorithm"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionStatus()
return FpQCall( {::_hdll_,"DPLEncryptionStatus"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptionStrength()
return FpQCall( {::_hdll_,"DPLEncryptionStrength"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncryptWithFingerprint(sFingerprint)
   sFingerprint := ::ForceAnsi(sFingerprint)
return 0 # FpQCall( {::_hdll_,"DPLEncryptWithFingerprintA"} ,"__sl__sl__pt",::_id_,sFingerprint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EndPageUpdate()
return FpQCall( {::_hdll_,"DPLEndPageUpdate"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePages(sInputFileName, sPassword, sOutputFileName, sRangeList)
   if pcount()=3 // alte Syntax, old syntax
      sRangeList      := sOutputFileName
      sOutputFileName := sPassword
      sPassword       := ""
   endif
   sInputFileName  := ::ForceAnsi(sInputFileName)
   sPassword       := ::ForceAnsi(sPassword)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
   sRangeList      := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"DPLExtractFilePagesA"} ,"__sl__sl__pt__pt__pt__pt",::_id_, sInputFileName, sPassword, sOutputFileName, sRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePageText(sFileName, sPassword, nPage, nOptions)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
RETURN ::ReadString( ::_str_result_(FpQCall( {::_hdll_,"DPLExtractFilePageTextA"} ,"__pt__sl__pt__pt__sl__sl",::_id_,sFileName, sPassword, nPage, nOptions)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractPageRanges(sRangeList)
   sRangeList := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"DPLExtractPageRangesA"} ,"__sl__sl__pt",::_id_,sRangeList)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractPages(p1,p2)
return FpQCall( {::_hdll_,"DPLExtractPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FileListCount(sListName)
   sListName := ::ForceAnsi(sListName)
return FpQCall( {::_hdll_,"DPLFileListCountA"} ,"__sl__sl__pt",::_id_,sListName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FileListItem(sListName, nIndex)
   sListName := ::ForceAnsi(sListName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLFileListItemA"} ,"__pt__sl__pt__sl",::_id_,sListName, nIndex)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindFonts()
return FpQCall( {::_hdll_,"DPLFindFonts"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindFormFieldByTitle(sTitle)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"DPLFindFormFieldByTitleA"} ,"__sl__sl__pt",::_id_,sTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FindImages()
return FpQCall( {::_hdll_,"DPLFindImages"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitImage(p1,p2,p3,p4,p5,p6,p7)
return 0 # FpQCall( {::_hdll_,"DPLFitImage"} ,"__sl__sl__f8__f8__f8__f8__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitRotatedTextBox(nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"DPLFitRotatedTextBoxA"} ,"__sl__sl__f8__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, nAngle, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FitTextBox(nLeft, nTop, nWidth, nHeight, sText, nOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"DPLFitTextBoxA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,nLeft, nTop, nWidth, nHeight, sText, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FlattenFormField(p1)
return 0 # FpQCall( {::_hdll_,"DPLFlattenFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontCount()
return FpQCall( {::_hdll_,"DPLFontCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontFamily()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLFontFamilyA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontHasKerning()
return 0 # FpQCall( {::_hdll_,"DPLFontHasKerning"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontName()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLFontNameA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontReference()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLFontReferenceA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontSize()
return FpQCall( {::_hdll_,"DPLFontSize"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FontType()
return FpQCall( {::_hdll_,"DPLFontType"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldCount()
return FpQCall( {::_hdll_,"DPLFormFieldCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldHasParent(p1)
return FpQCall( {::_hdll_,"DPLFormFieldHasParent"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldJavaScriptAction(nIndex, sActionType, sJavaScript)
   sActionType := ::ForceAnsi(sActionType)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"DPLFormFieldJavaScriptActionA"} ,"__sl__sl__sl__pt__pt",::_id_,nIndex, sActionType, sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FormFieldWebLinkAction(nIndex, sActionType, sLink)
   sActionType := ::ForceAnsi(sActionType)
   sLink       := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"DPLFormFieldWebLinkActionA"} ,"__sl__sl__sl__pt__pt",::_id_,nIndex, sActionType, sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetActionType(nActionID)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetActionTypeA"} ,"__pt__sl__sl",::_id_,nActionID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnalysisInfo(nAnalysisID,nAnalysisItem)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetAnalysisInfoA"} ,"__pt__sl__sl__sl",::_id_,nAnalysisID,nAnalysisItem)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotActionID(nIndex)
return FpQCall( {::_hdll_,"DPLGetAnnotActionID"} ,"__sl__sl__sl",::_id_,nIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotDblProperty(nIndex, nTag)
return FpQCall( {::_hdll_,"DPLGetAnnotDblProperty"} ,"__f8__sl__sl__sl",::_id_,nIndex, nTag)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotIntProperty(nIndex, nTag)
return FpQCall( {::_hdll_,"DPLGetAnnotIntProperty"} ,"__sl__sl__sl__sl",::_id_,nIndex, nTag)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotStrProperty(nIndex, nTag)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetAnnotStrPropertyA"} ,"__pt__sl__sl__sl",::_id_,nIndex, nTag)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetBarcodeWidth(nNominalWidth, sText, nBarcode)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLGetBarcodeWidthA"} ,"__f8__sl__f8__pt__sl",::_id_,nNominalWidth, sText, nBarcode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCanvasDC(p1,p2)
return FpQCall( {::_hdll_,"DPLGetCanvasDC"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCatalogInformation(sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetCatalogInformationA"} ,"__pt__sl__pt",::_id_,sKey)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCustomInformation(sKey)
   sKey := ::ForceAnsi(sKey)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetCustomInformationA"} ,"__pt__sl__pt",::_id_,sKey)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCustomKeys(nLocation)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetCustomKeysA"} ,"__pt__sl__sl",::_id_,nLocation)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDefaultPrinterName()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetDefaultPrinterNameA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestPage(p1)
return FpQCall( {::_hdll_,"DPLGetDestPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestType(p1)
return FpQCall( {::_hdll_,"DPLGetDestType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDestValue(p1,p2)
return FpQCall( {::_hdll_,"DPLGetDestValue"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocJavaScript(sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetDocJavaScriptA"} ,"__pt__sl__pt",::_id_,sActionType)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentFileName()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetDocumentFileNameA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentID(p1)
return FpQCall( {::_hdll_,"DPLGetDocumentID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentIdentifier(p1,p2)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetDocumentIdentifierA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentMetadata()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetDocumentMetadataA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentResourceList()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetDocumentResourceListA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileContentToFile(nIndex, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLGetEmbeddedFileContentToFileA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileContentToString(nIndex)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_(FpQCall( {::_hdll_,"DPLGetEmbeddedFileContentToString"} ,"__pt__sl__sl",::_id_,nIndex))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileIntProperty(p1,p2)
return FpQCall( {::_hdll_,"DPLGetEmbeddedFileIntProperty"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEmbeddedFileStrProperty(p1,p2)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetEmbeddedFileStrPropertyA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetEncryptionFingerprint()
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetEncryptionFingerprintA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFileMetadata(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFileMetadataA"} ,"__pt__sl__pt__pt",::_id_,sFileName, sPassword)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFirstChildOutline(p1)
return FpQCall( {::_hdll_,"DPLGetFirstChildOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFirstOutline()
return FpQCall( {::_hdll_,"DPLGetFirstOutline"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontID(p1)
return FpQCall( {::_hdll_,"DPLGetFontID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontObjectNumber()
return FpQCall( {::_hdll_,"DPLGetFontObjectNumber"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldAlignment(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldAlignment"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldAnnotFlags(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldAnnotFlags"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBackgroundColor(p1,p2)
return FpQCall( {::_hdll_,"DPLGetFormFieldBackgroundColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderColor(p1,p2)
return FpQCall( {::_hdll_,"DPLGetFormFieldBorderColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderProperty(p1,p2)
return FpQCall( {::_hdll_,"DPLGetFormFieldBorderProperty"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderStyle(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldBorderStyle"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBound(p1,p2)
return FpQCall( {::_hdll_,"DPLGetFormFieldBound"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldCaption(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldCaptionA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldChildTitle(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldChildTitleA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldChoiceType(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldChoiceType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldColor(p1,p2)
return FpQCall( {::_hdll_,"DPLGetFormFieldColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldComb(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldComb"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldDefaultValue(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldDefaultValueA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldDescription(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldDescriptionA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldFlags(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldFlags"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldFontName(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldFontNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldJavaScript(nIndex, sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldJavaScriptA"} ,"__pt__sl__sl__pt",::_id_,nIndex, sActionType)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldKidCount(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldKidCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldMaxLen(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldMaxLen"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldPage(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldPage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldPrintable(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldPrintable"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldReadOnly(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldReadOnly"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldRotation(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldRotation"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubCount(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldSubCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubName(p1,p2)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldSubNameA"} ,"__pt__sl__sl__sl",::_id_,p1,p2)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubTempIndex(p1,p2) // GetFormFieldSubTempIndex() => GetFormFieldKidTempIndex() => 10.11
return ::GetFormFieldKidTempIndex(p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTabOrder(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldTabOrder"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTextFlags(p1,p2)
return FpQCall( {::_hdll_,"DPLGetFormFieldTextFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTextSize(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldTextSize"} ,"__f8__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTitle(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldTitleA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldType(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldType"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldValue(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldValueA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldValueByTitle(sTitle)
   sTitle := ::ForceAnsi(sTitle)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldValueByTitleA"} ,"__pt__sl__pt",::_id_,sTitle)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldVisible(p1)
return FpQCall( {::_hdll_,"DPLGetFormFieldVisible"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldWebLink(nIndex, sActionType)
   sActionType := ::ForceAnsi(sActionType)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFieldWebLinkA"} ,"__pt__sl__sl__pt",::_id_,nIndex, sActionType)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFontCount()
return FpQCall( {::_hdll_,"DPLGetFormFontCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFontName(p1)
return ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetFormFontNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetGlobalJavaScript(sPackageName)
   sPackageName := ::ForceAnsi(sPackageName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetGlobalJavaScriptA"} ,"__pt__sl__pt",::_id_,sPackageName)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextHeight(nWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"DPLGetHTMLTextHeightA"} ,"__f8__sl__f8__pt",::_id_,nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextLineCount(nWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"DPLGetHTMLTextLineCountA"} ,"__sl__sl__f8__pt",::_id_,nWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetHTMLTextWidth(nMaxWidth, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"DPLGetHTMLTextWidthA"} ,"__f8__sl__f8__pt",::_id_,nMaxWidth, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageID(p1)
return FpQCall( {::_hdll_,"DPLGetImageID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImagePageCount(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLGetImagePageCountA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetInformation(nInstanceID)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetInformationA"} ,"__pt__sl__sl",::_id_,nInstanceID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetKerning(sCharPair)
   sCharPair := ::ForceAnsi(sCharPair)
return FpQCall( {::_hdll_,"DPLGetKerningA"} ,"__sl__sl__pt",::_id_,sCharPair)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetNamedDestination(sDestName)
   sDestName := ::ForceAnsi(sDestName)
return FpQCall( {::_hdll_,"DPLGetNamedDestinationA"} ,"__sl__sl__pt",::_id_,sDestName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetNextOutline(p1)
return FpQCall( {::_hdll_,"DPLGetNextOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetObjectCount()
return FpQCall( {::_hdll_,"DPLGetObjectCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOpenActionDestination()
return FpQCall( {::_hdll_,"DPLGetOpenActionDestination"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOpenActionJavaScript()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetOpenActionJavaScriptA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupID(p1)
return FpQCall( {::_hdll_,"DPLGetOptionalContentGroupID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentGroupName(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetOptionalContentGroupNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOrigin()
return FpQCall( {::_hdll_,"DPLGetOrigin"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineActionID(p1)
return FpQCall( {::_hdll_,"DPLGetOutlineActionID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineColor(p1,p2)
return FpQCall( {::_hdll_,"DPLGetOutlineColor"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineDest(p1)
return FpQCall( {::_hdll_,"DPLGetOutlineDest"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineID(p1)
return FpQCall( {::_hdll_,"DPLGetOutlineID"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineJavaScript(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetOutlineJavaScriptA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineOpenFile(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetOutlineOpenFileA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlinePage(p1)
return FpQCall( {::_hdll_,"DPLGetOutlinePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineStyle(p1)
return FpQCall( {::_hdll_,"DPLGetOutlineStyle"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOutlineWebLink(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetOutlineWebLinkA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageBox(p1,p2)
return FpQCall( {::_hdll_,"DPLGetPageBox"} ,"__f8__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageJavaScript(sActionType)
   sActionType := ::ForceAnsi(sActionType)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetPageJavaScriptA"} ,"__pt__sl__pt",::_id_,sActionType)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLabel(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetPageLabelA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLayout()
return FpQCall( {::_hdll_,"DPLGetPageLayout"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLGIDictContent(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetPageLGIDictContentA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageLGIDictCount()
return FpQCall( {::_hdll_,"DPLGetPageLGIDictCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageMode()
return FpQCall( {::_hdll_,"DPLGetPageMode"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageText(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetPageTextA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetParentOutline(p1)
return FpQCall( {::_hdll_,"DPLGetParentOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrevOutline(p1)
return FpQCall( {::_hdll_,"DPLGetPrevOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterBins(sPrinterName)                                   // ==> ::GetPrinterBinA(p1) ==> Array
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()                                                   // HB 2.00
   sPrinterName := ::ForceAnsi(sPrinterName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetPrinterBinsA"} ,"__pt__sl__pt",::_id_,sPrinterName)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterNames()                                              // ==> ::GetPrinterNameA()  ==> Array
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetPrinterNamesA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetSubsetString(sInputStr)
   sInputStr := ::ForceAnsi(sInputStr)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetSubsetString"} ,"__pt__sl__pt",::_id_,sInputStr)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellDblProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLGetTableCellDblProperty"} ,"__f8__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellIntProperty(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLGetTableCellIntProperty"} ,"__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableCellStrProperty(p1,p2,p3,p4)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetTableCellStrPropertyA"} ,"__pt__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableColumnCount(p1)
return FpQCall( {::_hdll_,"DPLGetTableColumnCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableLastDrawnRow(p1)
return FpQCall( {::_hdll_,"DPLGetTableLastDrawnRow"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTableRowCount(p1)
return FpQCall( {::_hdll_,"DPLGetTableRowCount"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTempPath()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetTempPathA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextAscent()
return FpQCall( {::_hdll_,"DPLGetTextAscent"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBound(p1)
return FpQCall( {::_hdll_,"DPLGetTextBound"} ,"__f8__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextDescent()
return FpQCall( {::_hdll_,"DPLGetTextDescent"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextHeight()
return FpQCall( {::_hdll_,"DPLGetTextHeight"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextSize()
return FpQCall( {::_hdll_,"DPLGetTextSize"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextWidth(sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLGetTextWidthA"} ,"__f8__sl__pt",::_id_,sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewerPreferences(p1)
return FpQCall( {::_hdll_,"DPLGetViewerPreferences"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedText(nWidth, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetWrappedTextA"} ,"__pt__sl__f8__pt__pt",::_id_,nWidth, sDelimiter, sText)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextBreakString(nWidth, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetWrappedTextBreakStringA"} ,"__pt__sl__f8__pt__pt",::_id_,nWidth, sDelimiter, sText)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextHeight(nWidth, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLGetWrappedTextHeightA"} ,"__f8__sl__f8__pt",::_id_,nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetWrappedTextLineCount(nWidth, sText)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLGetWrappedTextLineCountA"} ,"__sl__sl__f8__pt",::_id_,nWidth, sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldCount()
return FpQCall( {::_hdll_,"DPLGetXFAFormFieldCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldName(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetXFAFormFieldNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldNames(sDelimiter)
   sDelimiter := ::ForceAnsi(sDelimiter)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetXFAFormFieldNamesA"} ,"__pt__sl__pt",::_id_,sDelimiter)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAFormFieldValue(sXFAFieldName)
   sXFAFieldName:= ::ForceAnsi(sXFAFieldName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGetXFAFormFieldValueA"} ,"__pt__sl__pt",::_id_,sXFAFieldName)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GlobalJavaScriptCount()
return FpQCall( {::_hdll_,"DPLGlobalJavaScriptCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GlobalJavaScriptPackageName(p1)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLGlobalJavaScriptPackageNameA"} ,"__pt__sl__sl",::_id_,p1)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HasFontResources()
return 0 # FpQCall( {::_hdll_,"DPLHasFontResources"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HasPageBox(p1)
return FpQCall( {::_hdll_,"DPLHasPageBox"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:HidePage()
return FpQCall( {::_hdll_,"DPLHidePage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageCount()
return FpQCall( {::_hdll_,"DPLImageCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageFillColor()
return FpQCall( {::_hdll_,"DPLImageFillColor"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageHeight()
return FpQCall( {::_hdll_,"DPLImageHeight"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageHorizontalResolution()
return FpQCall( {::_hdll_,"DPLImageHorizontalResolution"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageResolutionUnits()
return FpQCall( {::_hdll_,"DPLImageResolutionUnits"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageType()
return FpQCall( {::_hdll_,"DPLImageType"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageVerticalResolution()
return FpQCall( {::_hdll_,"DPLImageVerticalResolution"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImageWidth()
return FpQCall( {::_hdll_,"DPLImageWidth"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ImportEMFFromFile(sFileName, nFontOptions, nGeneralOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLImportEMFFromFileA"} ,"__sl__sl__pt__sl__sl",::_id_,sFileName, nFontOptions, nGeneralOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertPages(p1,p2)
return FpQCall( {::_hdll_,"DPLInsertPages"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertTableColumns(p1,p2,p3)
return FpQCall( {::_hdll_,"DPLInsertTableColumns"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:InsertTableRows(p1,p2,p3)
return FpQCall( {::_hdll_,"DPLInsertTableRows"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:IsAnnotFormField(p1)
return FpQCall( {::_hdll_,"DPLIsAnnotFormField"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LastErrorCode()
return FpQCall( {::_hdll_,"DPLLastErrorCode"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LastRenderError()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLLastRenderErrorA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LibraryVersion()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLLibraryVersionA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LicenseInfo()
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLLicenseInfoA"} ,"__pt__sl",::_id_)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Linearized(); return ::IsLinearized() // renamed in 11.11
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromCanvasDC(dDPI, iOptions)
return 0 # FpQCall( {::_hdll_,"DPLLoadFromCanvasDC"} ,"__sl__sl__f8__sl",::_id_,dDPI, iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromFile(sFileName, sPassword)
   sFileName := ::ForceAnsi(sFileName)
   sPassword := ::ForceAnsi(sPassword)
return 0 # FpQCall( {::_hdll_,"DPLLoadFromFileA"} ,"__sl__sl__pt__pt",::_id_,sFileName,sPassword) // changed in 8.x
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadFromString(iSource, sPassword)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
   sPassword := ::ForceAnsi(sPassword)
return  0 # ::_ptb_free_( FpQCall({::_hdll_,"DPLLoadFromStringA"},"__sl__sl__pt__pt",::_id_,::_b(iSource,ptb,1),sPassword) ,ptb) // changed in 8.x
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LoadState()
return FpQCall( {::_hdll_,"DPLLoadState"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeDocument(p1)
return 0 # FpQCall( {::_hdll_,"DPLMergeDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFileList(sListName, sFileName)
   sListName := ::ForceAnsi(sListName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLMergeFileListA"} ,"__sl__sl__pt__pt",::_id_,sListName, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFileListFast(sListName, sFileName)
   sListName := ::ForceAnsi(sListName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLMergeFileListFastA"} ,"__sl__sl__pt__pt",::_id_,sListName, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeFiles(sFirstFileName, sSecondFileName, sOutputFileName)
   sFirstFileName  := ::ForceAnsi(sFirstFileName)
   sSecondFileName := ::ForceAnsi(sSecondFileName)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
return 0 # FpQCall( {::_hdll_,"DPLMergeFilesA"} ,"__sl__sl__pt__pt__pt",::_id_,sFirstFileName, sSecondFileName, sOutputFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MergeTableCells(p1,p2,p3,p4,p5)
return FpQCall( {::_hdll_,"DPLMergeTableCells"} ,"__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveOutlineAfter(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLMoveOutlineAfter"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveOutlineBefore(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLMoveOutlineBefore"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MovePage(p1)
return 0 # FpQCall( {::_hdll_,"DPLMovePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MovePath(p1,p2)
return FpQCall( {::_hdll_,"DPLMovePath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MultiplyScale(p1)
return FpQCall( {::_hdll_,"DPLMultiplyScale"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewChildFormField(nIndex, sTitle, nFieldType)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"DPLNewChildFormFieldA"} ,"__sl__sl__sl__pt__sl",::_id_,nIndex, sTitle, nFieldType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewCustomPrinter(sOriginalPrinterName)
   DEFAULT sOriginalPrinterName TO ::GetDefaultPrinterName()                                                   // HB 1.30
   // wenn sOriginalPrinterName ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if sOriginalPrinterName is not valid, the next line will cause a "internal data corrupted" error
   sOriginalPrinterName := ::ForceAnsi(sOriginalPrinterName)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLNewCustomPrinterA"} ,"__pt__sl__pt",::_id_,sOriginalPrinterName)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewDocument()
return FpQCall( {::_hdll_,"DPLNewDocument"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewFormField(sTitle, nFieldType)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"DPLNewFormFieldA"} ,"__sl__sl__pt__sl",::_id_,sTitle, nFieldType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewOptionalContentGroup(sGroupName)
   sGroupName := ::ForceAnsi(sGroupName)
return FpQCall( {::_hdll_,"DPLNewOptionalContentGroupA"} ,"__sl__sl__pt",::_id_,sGroupName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewOutline(nParent, sTitle, nDestPage, nDestPosition)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"DPLNewOutlineA"} ,"__sl__sl__sl__pt__sl__f8",::_id_,nParent, sTitle, nDestPage, nDestPosition)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPage()                                                 // *HB* return 0==Error else set ::nPageNo
   local nReturn
   nReturn := FpQCall( {::_hdll_,"DPLNewPage"} ,"__sl__sl",::_id_)
   if nReturn > 0
      ::nPageNo := nReturn
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPages(p1)
return 0 # FpQCall( {::_hdll_,"DPLNewPages"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewPostScriptXObject(sPS)
   sPS := ::ForceAnsi(sPS)
return FpQCall( {::_hdll_,"DPLNewPostScriptXObjectA"} ,"__sl__sl__pt",::_id_,sPS)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewRGBAxialShader(sShaderName, nStartX, nStartY, nStartRed, nStartGreen, nStartBlue, nEndX, nEndY, nEndRed, nEndGreen, nEndBlue, nExtend)
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"DPLNewRGBAxialShaderA"} ,"__sl__sl__pt__f8__f8__f8__f8__f8__f8__f8__f8__f8__f8__sl",::_id_,;
                              sShaderName, nStartX, nStartY, nStartRed, nStartGreen, nStartBlue, nEndX, nEndY, nEndRed, nEndGreen, nEndBlue, nExtend)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewStaticOutline(nParent, sTitle)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"DPLNewStaticOutlineA"} ,"__sl__sl__sl__pt",::_id_,nParent, sTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OpenOutline(p1)
return 0 # FpQCall( {::_hdll_,"DPLOpenOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OptionalContentGroupCount()
return FpQCall( {::_hdll_,"DPLOptionalContentGroupCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OutlineCount()
return FpQCall( {::_hdll_,"DPLOutlineCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:OutlineTitle(nOutlineID)
RETURN ::ReadString(::_str_result_(FpQCall( {::_hdll_,"DPLOutlineTitleA"} ,"__pt__sl__sl",::_id_,nOutlineID)))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageCount()
return FpQCall( {::_hdll_,"DPLPageCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageHeight()
return FpQCall( {::_hdll_,"DPLPageHeight"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageJavaScriptAction(sActionType,sJavaScript)
    sActionType := ::ForceAnsi(sActionType)
    sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"DPLPageJavaScriptActionA"} ,"__sl__sl__pt__pt",::_id_,sActionType,sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageRotation()
return FpQCall( {::_hdll_,"DPLPageRotation"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageWidth()
return FpQCall( {::_hdll_,"DPLPageWidth"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintDocument(sPrinterName, nStartPage, nEndPage, nOptions)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()                                          // HB 1.30
   // wenn sPrinterName ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if sPrinterName is not a valid, the next line will cause a "internal data corrupted" error
   sPrinterName := ::ForceAnsi(sPrinterName)
return 0 # FpQCall( {::_hdll_,"DPLPrintDocumentA"} ,"__sl__sl__pt__sl__sl__sl",::_id_,sPrinterName, nStartPage, nEndPage, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintDocumentToFile(sPrinterName, nStartPage, nEndPage, nOptions, sFileName)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()                                                    // HB 1.30
   // wenn cPrinterName ungltig ist, wird in der folgenden Zeile ein Fehler gemeldet: "Interne Datenstrukturen beschdigt"
   // if cPrinterName is not valid, the next line will cause an "internal data corrupted" error
   sPrinterName := ::ForceAnsi(sPrinterName)
   sFileName    := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLPrintDocumentToFileA"} ,"__sl__sl__pt__sl__sl__sl__pt",::_id_,sPrinterName, nStartPage, nEndPage, nOptions, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintOptions(nPageScaling, nAutoRotateCenter, sTitle)
   sTitle := ::ForceAnsi(sTitle)
return FpQCall( {::_hdll_,"DPLPrintOptionsA"} ,"__sl__sl__sl__sl__pt",::_id_,nPageScaling, nAutoRotateCenter, sTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseBuffer(p1)
return 0 = FpQCall( {::_hdll_,"DPLReleaseBuffer"} ,"__sl__sl__pt",::_id_,p1)     // intern, don't change !!! OK !!!
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseLibrary()                                                        // NEW *HB* return .t. / .f.
   local lOK
   if empty(::_id_)
      lOK := .t.
   else
      if 0 # FpQCall( {::_hdll_,"DPLReleaseLibrary"} ,"__sl__sl",::_id_)
         lOK := .t.
         ::_id_ := 0
      else
         lOK := .f.
      endif
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveAppearanceStream(p1)
return 0 # FpQCall( {::_hdll_,"DPLRemoveAppearanceStream"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveDocument(p1)
return 0 # FpQCall( {::_hdll_,"DPLRemoveDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveOutline(p1)
return 0 # FpQCall( {::_hdll_,"DPLRemoveOutline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveStyle(sStyleName)
   sStyleName := ::ForceAnsi(sStyleName)
return 0 # FpQCall( {::_hdll_,"DPLRemoveStyleA"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderDocumentToFile(dDPI, nStartPage, nEndPage, nOptions, sFileName)  // 10.11 - dDPI
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLRenderDocumentToFileA"} ,"__sl__sl__f8__sl__sl__sl__pt",::_id_,dDPI, nStartPage, nEndPage, nOptions, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToDC(dDPI, nPage, nDC)
return 0 # FpQCall( {::_hdll_,"DPLRenderPageToDC"} ,"__sl__sl__f8__sl__sl",::_id_,dDPI, nPage, nDC)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToFile(dDPI, nPage, nOptions, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLRenderPageToFileA"} ,"__sl__sl__f8__sl__sl__pt",::_id_,dDPI, nPage, nOptions, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToString(dDPI, iPage, iOptions)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
RETURN ::_str_result_(FpQCall( {::_hdll_,"DPLRenderPageToString"} ,"__pt__sl__f8__sl__sl",::_id_,dDPI, iPage, iOptions))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceFonts(iOptions)                   // 11.11
       DEFAULT iOptions TO 0
return FpQCall( {::_hdll_,"DPLReplaceFonts"} ,"__sl__sl__sl",::_id_,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceImage(p1,p2)
return FpQCall( {::_hdll_,"DPLReplaceImage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReplaceTag(sTag, sNewValue)
   sTag      := ::ForceAnsi(sTag)
   sNewValue := ::ForceAnsi(sNewValue)
return FpQCall( {::_hdll_,"DPLReplaceTagA"} ,"__sl__sl__pt__pt",::_id_,sTag, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RetrieveCustomDataToFile(sKey, sFileName, nLocation)
   sKey      := ::ForceAnsi(sKey)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLRetrieveCustomDataToFileA"} ,"__sl__sl__pt__pt__sl",::_id_,sKey, sFileName, nLocation)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RetrieveCustomDataToString(cKey, nLocation) // cKey == ASCIIZ == OK !  // ########### Anfrage an Support.
   cKey := ::ForceAnsi(cKey)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
RETURN ::_str_result_(FpQCall( {::_hdll_,"DPLRetrieveCustomDataToString"} ,"__pt__sl__pt__sl",::_id_,cKey, nLocation))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReverseImage(p1)
return FpQCall( {::_hdll_,"DPLReverseImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RotatePage(p1)
return 0 # FpQCall( {::_hdll_,"DPLRotatePage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveFontToFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLSaveFontToFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveImageToFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLSaveImageToFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveState()
return FpQCall( {::_hdll_,"DPLSaveState"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveStyle(sStyleName)
   sStyleName := ::ForceAnsi(sStyleName)
return FpQCall( {::_hdll_,"DPLSaveStyleA"} ,"__sl__sl__pt",::_id_,sStyleName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveToFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLSaveToFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
RETURN ::_str_result_(FpQCall( {::_hdll_,"DPLSaveToString"} ,"__pt__sl",::_id_))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SecurityInfo(p1)
return FpQCall( {::_hdll_,"DPLSecurityInfo"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectDocument(p1)
return 0 # FpQCall( {::_hdll_,"DPLSelectDocument"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedDocument()
return FpQCall( {::_hdll_,"DPLSelectedDocument"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedFont()
return FpQCall( {::_hdll_,"DPLSelectedFont"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedImage()
return FpQCall( {::_hdll_,"DPLSelectedImage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectedPage()
return FpQCall( {::_hdll_,"DPLSelectedPage"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectFont(p1)
   DEFAULT p1 TO ::nDefaultStandardFontID
return 0 # FpQCall( {::_hdll_,"DPLSelectFont"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectImage(p1)
return 0 # FpQCall( {::_hdll_,"DPLSelectImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectPage(p1)
   local lOK
   lOK := 0 # FpQCall( {::_hdll_,"DPLSelectPage"} ,"__sl__sl__sl",::_id_,p1)
   if lOK
      ::nPageNo := p1
   endif
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAdvancePassword()
   MsgFunctionRemoved("SetAdvancePassword()")
return .f.
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotContents(nIndex, sNewContents)
   sNewContents := ::ForceAnsi(sNewContents)
return FpQCall( {::_hdll_,"DPLSetAnnotContentsA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewContents)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotStrProperty(nIndex, nTag, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return FpQCall( {::_hdll_,"DPLSetAnnotStrPropertyA"} ,"__sl__sl__sl__sl__pt",::_id_,nIndex, nTag, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBaseURL(sNewBaseURL)
   sNewBaseURL := ::ForceAnsi(sNewBaseURL)
return FpQCall( {::_hdll_,"DPLSetBaseURLA"} ,"__sl__sl__pt",::_id_,sNewBaseURL)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBlendMode(p1)
return FpQCall( {::_hdll_,"DPLSetBlendMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetBreakString(sNewBreakString)
   sNewBreakString := ::ForceAnsi(sNewBreakString)
return FpQCall( {::_hdll_,"DPLSetBreakStringA"} ,"__sl__sl__pt",::_id_,sNewBreakString)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCapturedPageOptional(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetCapturedPageOptional"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCatalogInformation(sKey, sNewValue)
   sKey      := ::ForceAnsi(sKey)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetCatalogInformationA"} ,"__sl__sl__pt__pt",::_id_,sKey, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCharWidth(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetCharWidth"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetClippingPath()
return FpQCall( {::_hdll_,"DPLSetClippingPath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetClippingPathEvenOdd()
return FpQCall( {::_hdll_,"DPLSetClippingPathEvenOdd"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCropBox(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLSetCropBox"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCustomInformation(sKey, sNewValue)
   sKey      := ::ForceAnsi(sKey)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetCustomInformationA"} ,"__sl__sl__pt__pt",::_id_,sKey,sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCustomLineDash(sDashPattern, nDashPhase)
   sDashPattern := ::ForceAnsi(sDashPattern)
return 0 # FpQCall( {::_hdll_,"DPLSetCustomLineDashA"} ,"__sl__sl__pt__f8",::_id_,sDashPattern, nDashPhase)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDocumentMetadata(sXMP)
   sXMP := ::ForceAnsi(sXMP)
return 0 # FpQCall( {::_hdll_,"DPLSetDocumentMetadataA"} ,"__sl__sl__pt",::_id_,sXMP)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColor(nR,nG,nB)                                          // *HB* DrawText change this color !
   if nR==NIL .or. nG==NIL .or. nB==NIL                                                       // 1.54
      nR := ::nAktiveFillColorRed
      nG := ::nAktiveFillColorGreen
      nB := ::nAktiveFillColorBlue
   else
      if nR>1 .or. nG>1 .or. nB>1
         ::HB_RGB2double(@nR,@nG,@nB)
      endif
      ::nAktiveFillColorRed    :=  nR
      ::nAktiveFillColorGreen  :=  nG
      ::nAktiveFillColorBlue   :=  nB
   endif
return FpQCall( {::_hdll_,"DPLSetFillColor"} ,"__sl__sl__f8__f8__f8",::_id_,nR,nG,nB)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLSetFillColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillColorSep(sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLSetFillColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillShader(sShaderName)
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"DPLSetFillShaderA"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFontEncoding(p1)
return 0 # FpQCall( {::_hdll_,"DPLSetFontEncoding"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFontFlags(p1,p2,p3,p4,p5,p6,p7,p8)
return 0 # FpQCall( {::_hdll_,"DPLSetFontFlags"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldAlignment(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldAlignment"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldAnnotFlags(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldAnnotFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBackgroundColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorCMYK(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBackgroundColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorSep(nIndex, sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBackgroundColorSepA"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBorderColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorCMYK(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBorderColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorSep(nIndex, sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBorderColorSepA"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderStyle(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBorderStyle"} ,"__sl__sl__sl__f8__sl__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBounds(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBounds"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCalcOrder(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldCalcOrder"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCaption(nIndex, sNewCaption)
   sNewCaption := ::ForceAnsi(sNewCaption)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldCaptionA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewCaption)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldCheckStyle(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldCheckStyle"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldChildTitle(nInteger, sNewTitle)
   sNewTitle := ::ForceAnsi(sNewTitle)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldChildTitleA"} ,"__sl__sl__sl__pt",::_id_,nInteger, sNewTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorCMYK(p1,p2,p3,p4,p5)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldColorCMYK"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldColorSep(nIndex, sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldColorSepA"} ,"__sl__sl__sl__pt__f8",::_id_,nIndex, sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldComb(p1,p2)
return FpQCall( {::_hdll_,"DPLSetFormFieldComb"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldDefaultValue(nIndex, sNewDefaultValue)
   sNewDefaultValue := ::ForceAnsi(sNewDefaultValue)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldDefaultValueA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewDefaultValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldDescription(nIndex, sNewDescription)
   sNewDescription := ::ForceAnsi(sNewDescription)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldDescriptionA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewDescription)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldFlags(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldFlags"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldFont(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldFont"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldHighlightMode(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldHighlightMode"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldIcon(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldIcon"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldIconStyle(p1,p2,p3,p4,p5,p6)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldIconStyle"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldMaxLen(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldMaxLen"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldOptional(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldOptional"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldPage(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldPage"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldPrintable(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldPrintable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldReadOnly(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldReadOnly"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldRotation(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldRotation"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldStandardFont(p1,p2)
return FpQCall( {::_hdll_,"DPLSetFormFieldStandardFont"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTabOrder(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldTabOrder"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTextFlags(p1,p2,p3,p4,p5,p6)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldTextFlags"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTextSize(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldTextSize"} ,"__sl__sl__sl__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldValue(nIndex, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldValueA"} ,"__sl__sl__sl__pt",::_id_,nIndex, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldValueByTitle(sTitle, sNewValue)
   sTitle := ::ForceAnsi(sTitle)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldValueByTitleA"} ,"__sl__sl__pt__pt",::_id_, sTitle, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldVisible(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldVisible"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetGDIPlusFileName(sDLLFileName)
   sDLLFileName := ::ForceAnsi(sDLLFileName)
return 0 # FpQCall( {::_hdll_,"DPLSetGDIPlusFileNameA"} ,"__sl__sl__pt",::_id_,sDLLFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetGDIPlusOptions(p1,p2)
return FpQCall( {::_hdll_,"DPLSetGDIPlusOptions"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLBoldFont(sFontSet, nFontID)
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"DPLSetHTMLBoldFontA"} ,"__sl__sl__pt__sl",::_id_, sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLBoldItalicFont(sFontSet, nFontID)
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"DPLSetHTMLBoldItalicFontA"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLItalicFont(sFontSet, nFontID)
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"DPLSetHTMLItalicFontA"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHTMLNormalFont(sFontSet, nFontID)
   DEFAULT sFontSet TO "Default"
   sFontSet := ::ForceAnsi(sFontSet)
return 0 # FpQCall( {::_hdll_,"DPLSetHTMLNormalFontA"} ,"__sl__sl__pt__sl",::_id_,sFontSet, nFontID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageAsMask(p1)
return FpQCall( {::_hdll_,"DPLSetImageAsMask"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMask(p1,p2,p3,p4,p5,p6)
return 0 # FpQCall( {::_hdll_,"DPLSetImageMask"} ,"__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMaskCMYK(p1,p2,p3,p4,p5,p6,p7,p8)
return 0 # FpQCall( {::_hdll_,"DPLSetImageMaskCMYK"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageMaskFromImage(p1)
return FpQCall( {::_hdll_,"DPLSetImageMaskFromImage"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetImageOptional(p1)
return FpQCall( {::_hdll_,"DPLSetImageOptional"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetInformation(nKey, sNewValue)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetInformationA"} ,"__sl__sl__sl__pt",::_id_,nKey, sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetJavaScriptMode(p1)
return FpQCall( {::_hdll_,"DPLSetJavaScriptMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetJPEGQuality(p1)
return FpQCall( {::_hdll_,"DPLSetJPEGQuality"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetKerning(sCharPair, nAdjustment)
   sCharPair := ::ForceAnsi(sCharPair)
return 0 # FpQCall( {::_hdll_,"DPLSetKerningA"} ,"__sl__sl__pt__sl",::_id_,sCharPair, nAdjustment)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineCap(p1)
return 0 # FpQCall( {::_hdll_,"DPLSetLineCap"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColor(p1,p2,p3)
   DEFAULT p1 TO 0
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
return FpQCall( {::_hdll_,"DPLSetLineColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLSetLineColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineColorSep(sColorName, nTint)
   sColorName := ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLSetLineColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineDash(p1,p2)
return FpQCall( {::_hdll_,"DPLSetLineDash"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineJoin(p1)
return 0 # FpQCall( {::_hdll_,"DPLSetLineJoin"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineShader(sShaderName)
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"DPLSetLineShaderA"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineWidth(p1)                                                        // *HB* return current value
   local nReturn
   if valtype(P1)="N" .and. p1==0  // setze Standardwert, set default value
      p1 := ::nDefaultLineWidth
   endif
   nReturn := ::nLineWidth         // aktuellen Wert zurckgeben, return current value
   if P1 # NIL                     // neuen Wert setzen, set new value
      if 0 # FpQCall( {::_hdll_,"DPLSetLineWidth"} ,"__sl__sl__f8",::_id_,p1)
         ::nLineWidth := p1
      endif
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasurementUnits(p1)
return FpQCall( {::_hdll_,"DPLSetMeasurementUnits"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetNeedAppearances(p1)
return 0 # FpQCall( {::_hdll_,"DPLSetNeedAppearances"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionDestination(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetOpenActionDestination"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionDestinationFull(p1,p2,p3,p4,p5,p6,p7)
return 0 # FpQCall( {::_hdll_,"DPLSetOpenActionDestinationFull"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionJavaScript(sJavaScript)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"DPLSetOpenActionJavaScriptA"} ,"__sl__sl__pt",::_id_,sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOpenActionMenu(sMenuItem)
   sMenuItem := ::ForceAnsi(sMenuItem)
return 0 # FpQCall( {::_hdll_,"DPLSetOpenActionMenuA"} ,"__sl__sl__pt",::_id_,sMenuItem)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentGroupPrintable(p1,p2)
return FpQCall( {::_hdll_,"DPLSetOptionalContentGroupPrintable"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentGroupVisible(p1,p2)
return FpQCall( {::_hdll_,"DPLSetOptionalContentGroupVisible"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOrigin(p1)
return FpQCall( {::_hdll_,"DPLSetOrigin"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineColor(p1,p2,p3,p4)
   DEFAULT p2 TO 0                                                                            // 1.54
   DEFAULT p3 TO 0
   DEFAULT p4 TO 0
   if p2>1 .or. p3>1 .or. p4>1
      ::HB_RGB2double(@p2,@p3,@p4)
   endif
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineColor"} ,"__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestination(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineDestination"} ,"__sl__sl__sl__sl__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestinationFull(p1,p2,p3,p4,p5,p6,p7,p8)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineDestinationFull"} ,"__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineDestinationZoom(p1,p2,p3,p4)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineDestinationZoom"} ,"__sl__sl__sl__sl__f8__sl",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineJavaScript(nOutlineID, sJavaScript)
   sJavaScript := ::ForceAnsi(sJavaScript)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineJavaScriptA"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sJavaScript)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineOpenFile(nOutlineID, sFileName)
   sFileName := ::ForceAnsi(sFileName)
   sFileName := ::PathFormatPdf(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineOpenFileA"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineStyle(p1,p2,p3)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineStyle"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineTitle(nOutlineID, sNewTitle)
   sNewTitle := ::ForceAnsi(sNewTitle)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineTitleA"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sNewTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOutlineWebLink(nOutlineID, sLink)
   sLink := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"DPLSetOutlineWebLinkA"} ,"__sl__sl__sl__pt",::_id_,nOutlineID, sLink)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageActionMenu(sMenuItem)
   sMenuItem := ::ForceAnsi(sMenuItem)
return 0 # FpQCall( {::_hdll_,"DPLSetPageActionMenuA"} ,"__sl__sl__pt",::_id_,sMenuItem)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageBox(p1,p2,p3,p4,p5)
return FpQCall( {::_hdll_,"DPLSetPageBox"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageDimensions(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetPageDimensions"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageLayout(p1)
return 0 # FpQCall( {::_hdll_,"DPLSetPageLayout"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageMode(p1)
return 0 # FpQCall( {::_hdll_,"DPLSetPageMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageSize(sPaperName)
   sPaperName := ::ForceAnsi(sPaperName)
return 0 # FpQCall( {::_hdll_,"DPLSetPageSizeA"} ,"__sl__sl__pt",::_id_,sPaperName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageThumbnail()
return 0 # FpQCall( {::_hdll_,"DPLSetPageThumbnail"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageTransparencyGroup(p1,p2,p3)
return FpQCall( {::_hdll_,"DPLSetPageTransparencyGroup"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPassword()
   MsgFunctionRemoved("SetPassword()")
return .f.
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPNGTransparencyColor(p1,p2,p3)
return FpQCall( {::_hdll_,"DPLSetPNGTransparencyColor"} ,"__sl__sl__sl__sl__sl",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPrecision(p1)
return 0 # FpQCall( {::_hdll_,"DPLSetPrecision"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetScale(p1)
return FpQCall( {::_hdll_,"DPLSetScale"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColor(p1,p2,p3,p4,p5)
   DEFAULT p3 TO 0                                                                            // 1.54
   DEFAULT p4 TO 0
   DEFAULT p5 TO 0
   if p3>1 .or. p4>1 .or. p5>1
      ::HB_RGB2double(@p3,@p4,@p5)
   endif
return FpQCall( {::_hdll_,"DPLSetTableBorderColor"} ,"__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderColorCMYK(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"DPLSetTableBorderColorCMYK"} ,"__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableBorderWidth(p1,p2,p3)
return FpQCall( {::_hdll_,"DPLSetTableBorderWidth"} ,"__sl__sl__sl__sl__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellAlignment(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"DPLSetTableCellAlignment"} ,"__sl__sl__sl__sl__sl__sl__sl__sl",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColor(p1,p2,p3,p4,p5,p6,p7,p8)
   DEFAULT p6 TO 0                                                                            // 1.54
   DEFAULT p7 TO 0
   DEFAULT p8 TO 0
   if p6>1 .or. p7>1 .or. p8>1
      ::HB_RGB2double(@p6,@p7,@p8)
   endif
return FpQCall( {::_hdll_,"DPLSetTableCellBackgroundColor"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBackgroundColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9)
return FpQCall( {::_hdll_,"DPLSetTableCellBackgroundColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColor(p1,p2,p3,p4,p5,p6,p7,p8,p9)
   DEFAULT p7 TO 0                                                                            // 1.54
   DEFAULT p8 TO 0
   DEFAULT p9 TO 0
   if p7>1 .or. p8>1 .or. p9>1
      ::HB_RGB2double(@p7,@p8,@p9)
   endif
return FpQCall( {::_hdll_,"DPLSetTableCellBorderColor"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
return FpQCall( {::_hdll_,"DPLSetTableCellBorderColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellBorderWidth(p1,p2,p3,p4,p5,p6,p7)
return FpQCall( {::_hdll_,"DPLSetTableCellBorderWidth"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellContent(nTableID, nRowNumber, nColumnNumber, sHTMLText)
   sHTMLText := ::ForceAnsi(sHTMLText)
return FpQCall( {::_hdll_,"DPLSetTableCellContentA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,nTableID, nRowNumber, nColumnNumber, sHTMLText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellPadding(p1,p2,p3,p4,p5,p6,p7)
return FpQCall( {::_hdll_,"DPLSetTableCellPadding"} ,"__sl__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6,p7)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColor(p1,p2,p3,p4,p5,p6,p7,p8)
   DEFAULT p6 TO 0                                                                            // 1.54
   DEFAULT p7 TO 0
   DEFAULT p8 TO 0
   if p6>1 .or. p7>1 .or. p8>1
      ::HB_RGB2double(@p6,@p7,@p8)
   endif
return FpQCall( {::_hdll_,"DPLSetTableCellTextColor"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextColorCMYK(p1,p2,p3,p4,p5,p6,p7,p8,p9)
return FpQCall( {::_hdll_,"DPLSetTableCellTextColorCMYK"} ,"__sl__sl__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4,p5,p6,p7,p8,p9)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableCellTextSize(p1,p2,p3,p4,p5,p6)
return FpQCall( {::_hdll_,"DPLSetTableCellTextSize"} ,"__sl__sl__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4,p5,p6)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableColumnWidth(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLSetTableColumnWidth"} ,"__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableRowHeight(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLSetTableRowHeight"} ,"__sl__sl__sl__sl__sl__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTempFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLSetTempFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTempPath(sNewPath)
   sNewPath := ::ForceAnsi(sNewPath)
return 0 # FpQCall( {::_hdll_,"DPLSetTempPathA"} ,"__sl__sl__pt",::_id_,sNewPath)
// -------------------------------------------------------------------------------------------------------------------
Method HBPrintPDF:SetTextAlign(xAlign)             // *HB*
   local nReturn
   if xAlign == NIL .or. ! ValType(xAlign) $ "CN"  // Error
      nReturn := 0
   else
      do case
         case ValType(xAlign) == "N"
              // xAlign is ok
         case xAlign == "L"
              xAlign := TEXT_ALIGN_LEFT
         case xAlign == "R"
              xAlign := TEXT_ALIGN_RIGHT
         case xAlign == "C" .or. xAlign == "Z"
              xAlign := TEXT_ALIGN_CENTER
         case xAlign == "B"
              xAlign := TEXT_ALIGN_BLOCK_NORMAL
      end
      nReturn := FpQCall( {::_hdll_,"DPLSetTextAlign"} ,"__sl__sl__sl",::_id_,xAlign)
      if ::IsTrue(nReturn)
         ::nAlign := xAlign
      endif
   endif
return nReturn
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextCharSpacing(p1)
return FpQCall( {::_hdll_,"DPLSetTextCharSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColor(p1,p2,p3)     // <-
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextColorGreen    := p2
   ::nOldTextColorBlue     := p3
return FpQCall( {::_hdll_,"DPLSetTextColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLSetTextColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextColorSep(sColorName, nTint)
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLSetTextColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlight(p1)
return FpQCall( {::_hdll_,"DPLSetTextHighlight"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColor(p1,p2,p3)
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextHighlightColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextHighlightColorGreen    := p2
   ::nOldTextHighlightColorBlue     := p3
return FpQCall( {::_hdll_,"DPLSetTextHighlightColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLSetTextHighlightColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextHighlightColorSep(sColorName, nTint)
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLSetTextHighlightColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextMode(p1)
return FpQCall( {::_hdll_,"DPLSetTextMode"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextRise(p1)
return FpQCall( {::_hdll_,"DPLSetTextRise"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextScaling(p1)
return FpQCall( {::_hdll_,"DPLSetTextScaling"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextShader(sShaderName)
   sShaderName := ::ForceAnsi(sShaderName)
return 0 # FpQCall( {::_hdll_,"DPLSetTextShaderA"} ,"__sl__sl__pt",::_id_,sShaderName)
// -------------------------------------------------------------------------------------------------------------------
Method HBPrintPDF:SetTextSize(nFontSize)
   local lOK
   DEFAULT nFontSize TO ::nDefaultStandardFontSize
   lOK := 0 # FpQCall( {::_hdll_,"DPLSetTextSize"} ,"__sl__sl__f8",::_id_,nFontSize)
   ::nLineFeed  := ::GetTextHeight()
return lOK
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextSpacing(p1)
return FpQCall( {::_hdll_,"DPLSetTextSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderline(p1)                                                        // *HB*
       DEFAULT p1 TO TEXTUNDERLINE_NONE
       ::nTextUnderline := p1
return FpQCall( {::_hdll_,"DPLSetTextUnderline"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColor(p1,p2,p3)
   DEFAULT p1 TO 0                                                                            // 1.54
   DEFAULT p2 TO 0
   DEFAULT p3 TO 0
   if p1>1 .or. p2>1 .or. p3>1
      ::HB_RGB2double(@p1,@p2,@p3)
   endif
   ::nOldTextUnderlineColorRed      := p1         // Save last color for TextPrint()
   ::nOldTextUnderlineColorGreen    := p2
   ::nOldTextUnderlineColorBlue     := p3
return FpQCall( {::_hdll_,"DPLSetTextUnderlineColor"} ,"__sl__sl__f8__f8__f8",::_id_,p1,p2,p3)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorCMYK(p1,p2,p3,p4)
return FpQCall( {::_hdll_,"DPLSetTextUnderlineColorCMYK"} ,"__sl__sl__f8__f8__f8__f8",::_id_,p1,p2,p3,p4)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineColorSep(sColorName, nTint)
   sColorName:= ::ForceAnsi(sColorName)
return 0 # FpQCall( {::_hdll_,"DPLSetTextUnderlineColorSepA"} ,"__sl__sl__pt__f8",::_id_,sColorName, nTint)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineDash(p1,p2)
return FpQCall( {::_hdll_,"DPLSetTextUnderlineDash"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextWordSpacing(p1)
return FpQCall( {::_hdll_,"DPLSetTextWordSpacing"} ,"__sl__sl__f8",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTransparency(p1)
return 0 # FpQCall( {::_hdll_,"DPLSetTransparency"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetupCustomPrinter(sCustomPrinterName, nSetting, nNewValue)
   sCustomPrinterName := ::ForceAnsi(sCustomPrinterName)
return 0 # FpQCall( {::_hdll_,"DPLSetupCustomPrinterA"} ,"__sl__sl__pt__sl__sl",::_id_,sCustomPrinterName, nSetting, nNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetViewerPreferences(p1,p2)
return 0 # FpQCall( {::_hdll_,"DPLSetViewerPreferences"} ,"__sl__sl__sl__sl",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldAccess(sXFAFieldName, nNewAccess)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"DPLSetXFAFormFieldAccessA"} ,"__sl__sl__pt__sl",::_id_,sXFAFieldName, nNewAccess)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderColor(sXFAFieldName, nRed, nGreen, nBlue)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"DPLSetXFAFormFieldBorderColorA"} ,"__sl__sl__pt__f8__f8__f8",::_id_,sXFAFieldName, nRed, nGreen, nBlue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderPresence(sXFAFieldName, nNewPresence)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"DPLSetXFAFormFieldBorderPresenceA"} ,"__sl__sl__pt__sl",::_id_,sXFAFieldName, nNewPresence)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldBorderWidth(sXFAFieldName, nBorderWidth)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
return FpQCall( {::_hdll_,"DPLSetXFAFormFieldBorderWidthA"} ,"__sl__sl__pt__f8",::_id_,sXFAFieldName, nBorderWidth)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFormFieldValue(sXFAFieldName,sNewValue)
   sXFAFieldName := ::ForceAnsi(sXFAFieldName)
   sNewValue     := ::ForceAnsi(sNewValue)
return FpQCall( {::_hdll_,"DPLSetXFAFormFieldValueA"} ,"__sl__sl__pt__pt",::_id_,sXFAFieldName,sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SignFile(sInputFileName, sOpenPassword, sSignatureFieldName, sOutputFileName, sPFXFileName, sPFXPassword, sReason, sLocation, sContactInfo)
       sInputFileName      := ::ForceAnsi(sInputFileName)
       sOpenPassword       := ::ForceAnsi(sOpenPassword)
       sSignatureFieldName := ::ForceAnsi(sSignatureFieldName)
       sOutputFileName     := ::ForceAnsi(sOutputFileName)
       sPFXFileName        := ::ForceAnsi(sPFXFileName)
       sPFXPassword        := ::ForceAnsi(sPFXPassword)
       sReason             := ::ForceAnsi(sReason)
       sLocation           := ::ForceAnsi(sLocation)
       sContactInfo        := ::ForceAnsi(sContactInfo)
return FpQCall( {::_hdll_,"DPLSignFileA"} ,"__sl__sl__pt__pt__pt__pt__pt__pt__pt__pt__pt",::_id_,sInputFileName,;
                                                sOpenPassword, sSignatureFieldName, sOutputFileName, sPFXFileName, sPFXPassword, sReason, sLocation, sContactInfo)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SplitPageText(p1)
return FpQCall( {::_hdll_,"DPLSplitPageText"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StartPath(p1,p2)
return FpQCall( {::_hdll_,"DPLStartPath"} ,"__sl__sl__f8__f8",::_id_,p1,p2)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StoreCustomDataFromFile(sKey, sFileName, nLocation, nOptions)
   sKey      := ::ForceAnsi(sKey)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLStoreCustomDataFromFileA"} ,"__sl__sl__pt__pt__sl__sl",::_id_,sKey, sFileName, nLocation, nOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StoreCustomDataFromString(cKey, cNewValue, nLocation, nOptions) // cKey OK!
  local ptb := _xgrab(32);PokeDWord(ptb,,5) // Funktion mit 4 Parameter, daher 5 !
return 0 # ::_ptb_free_( FpQCall({::_hdll_,"DPLStoreCustomDataFromString"},"__sl__sl__pt__pt__sl__sl",::_id_,cKey,::_b(cNewValue,ptb,1),nLocation, nOptions) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:StringResultLength()
return FpQCall( {::_hdll_,"DPLStringResultLength"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:TestTempPath()
return 0 # FpQCall( {::_hdll_,"DPLTestTempPath"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:Unlocked()
return 0 # FpQCall( {::_hdll_,"DPLUnlocked"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UnlockKey(sLicenseKey)
   sLicenseKey := ::ForceAnsi(sLicenseKey)
return 0 # FpQCall( {::_hdll_,"DPLUnlockKeyA"} ,"__sl__sl__pt",::_id_,sLicenseKey)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UpdateAppearanceStream(p1)
return 0 # FpQCall( {::_hdll_,"DPLUpdateAppearanceStream"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UseKerning(p1)
return FpQCall( {::_hdll_,"DPLUseKerning"} ,"__sl__sl__sl",::_id_,p1)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddOpenTypeFontFromFile(sFileName, iOptions)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddOpenTypeFontFromFileA"} ,"__sl__sl__pt__sl",::_id_,sFileName,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddSWFAnnotationFromFile(dLeft, dTop, dWidth, dHeight, sFileName, sTitle, iOptions)
   sFileName := ::ForceAnsi(sFileName)
   sTitle := ::ForceAnsi(sTitle)
return 0 # FpQCall( {::_hdll_,"DPLAddSWFAnnotationFromFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__pt__sl",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,sTitle,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeSubsettedFont(sFontName, sSubsetChars, iOptions)
   DEFAULT iOptions TO 0    // ###### 8.16 => Options Reserved for future use. Should be set to 0.
   sFontName := ::ForceAnsi(sFontName)
   sSubsetChars := ::ForceAnsi(sSubsetChars)
return FpQCall( {::_hdll_,"DPLAddTrueTypeSubsettedFontA"} ,"__sl__sl__pt__pt__sl",::_id_,sFontName,sSubsetChars,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AnsiStringResultLength()
return FpQCall( {::_hdll_,"DPLAnsiStringResultLength"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckFileCompliance(sInputFileName, sPassword, iComplianceTest, iOptions)
   sInputFileName := ::ForceAnsi(sInputFileName)
   sPassword      := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"DPLCheckFileComplianceA"} ,"__sl__sl__pt__pt__sl__sl",::_id_,sInputFileName,sPassword,iComplianceTest,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CombineLayers() ; RETURN ::CombineContentStreams() // alt / old
METHOD HBPrintPDF:CombineContentStreams()
return 0 # FpQCall( {::_hdll_,"DPLCombineContentStreams"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LayerCount() ; RETURN ::ContentStreamCount() // alt / old
METHOD HBPrintPDF:ContentStreamCount()
return FpQCall( {::_hdll_,"DPLContentStreamCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LayerSafe() ; RETURN ::ContentStreamSafe()  // alt / old
METHOD HBPrintPDF:ContentStreamSafe()
return 0 # FpQCall( {::_hdll_,"DPLContentStreamSafe"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetObjectSource(p1,p2); RETURN ::DAGetObjectToString(p1,p2)  // alt / old
METHOD HBPrintPDF:DAGetObjectToString(iFileHandle, iObjectNumber)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"DPLDAGetObjectToString"} ,"__pt__sl__sl__sl",::_id_,iFileHandle,iObjectNumber) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageContent(p1,p2); RETURN ::DAGetPageContentToString(p1,p2)  // alt / old
METHOD HBPrintPDF:DAGetPageContentToString(iFileHandle, iPageRef)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"DPLDAGetPageContentToString"} ,"__pt__sl__sl__sl",::_id_,iFileHandle,iPageRef) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAReleaseImageList(iFileHandle, iImageListID)
return 0 # FpQCall( {::_hdll_,"DPLDAReleaseImageList"} ,"__sl__sl__sl__sl",::_id_,iFileHandle,iImageListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetTextExtractionArea(dLeft, dTop, dWidth, dHeight)
return FpQCall( {::_hdll_,"DPLDASetTextExtractionArea"} ,"__sl__sl__f8__f8__f8__f8",::_id_,dLeft,dTop,dWidth,dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetTextExtractionOptions(iOptionID, iNewValue)
return 0 # FpQCall( {::_hdll_,"DPLDASetTextExtractionOptions"} ,"__sl__sl__sl__sl",::_id_,iOptionID,iNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetTextExtractionScaling(iOptions, dHorizontal, dVertical)
return 0 # FpQCall( {::_hdll_,"DPLDASetTextExtractionScaling"} ,"__sl__sl__sl__f8__f8",::_id_,iOptions,dHorizontal,dVertical)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetTextExtractionWordGap(dNewWordGap)
return 0 # FpQCall( {::_hdll_,"DPLDASetTextExtractionWordGap"} ,"__sl__sl__f8",::_id_,dNewWordGap)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DeleteContentStream()
return 0 # FpQCall( {::_hdll_,"DPLDeleteContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawIntelligentMailBarcode(dLeft, dTop, dBarWidth, dFullBarHeight, dTrackerHeight, dSpaceWidth, sBarcodeData, iOptions)
   sBarcodeData := ::ForceAnsi(sBarcodeData)
return 0 # FpQCall( {::_hdll_,"DPLDrawIntelligentMailBarcodeA"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__pt__sl",::_id_,dLeft,dTop,dBarWidth,dFullBarHeight,dTrackerHeight,dSpaceWidth,sBarcodeData,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPDF417Symbol(dLeft, dTop, sText, iOptions)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"DPLDrawPDF417SymbolA"} ,"__sl__sl__f8__f8__pt__sl",::_id_,dLeft,dTop,sText,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedBox(dLeft, dBottom, dWidth, dHeight, dAngle, iDrawOptions)
return FpQCall( {::_hdll_,"DPLDrawRotatedBox"} ,"__sl__sl__f8__f8__f8__f8__f8__sl",::_id_,dLeft,dBottom,dWidth,dHeight,dAngle,iDrawOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedMultiLineText(dXPos, dYPos, dAngle, sDelimiter, sText)
   sDelimiter := ::ForceAnsi(sDelimiter)
   sText      := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLDrawRotatedMultiLineTextA"} ,"__sl__sl__f8__f8__f8__pt__pt",::_id_,dXPos,dYPos,dAngle,sDelimiter,sText)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EditableLayer() ; RETURN ::EditableContentStream() // alt / old
METHOD HBPrintPDF:EditableContentStream()
return 0 # FpQCall( {::_hdll_,"DPLEditableContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EncapsulateLayer() ; RETURN ::EncapsulateContentStream() // alt / old
METHOD HBPrintPDF:EncapsulateContentStream()
return FpQCall( {::_hdll_,"DPLEncapsulateContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePageContent(sInputFileName, sPassword, iPage); RETURN ::ExtractFilePageContentToString(sInputFileName, sPassword, iPage) // alt / old
METHOD HBPrintPDF:ExtractFilePageContentToString(sInputFileName, sPassword, iPage)
   sInputFileName := ::ForceAnsi(sInputFileName)
   sPassword := ::ForceAnsi(sPassword)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"DPLExtractFilePageContentToStringA"} ,"__pt__sl__pt__pt__sl",::_id_,sInputFileName,sPassword,iPage) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCSDictEPSG(iCSDictID)
return FpQCall( {::_hdll_,"DPLGetCSDictEPSG"} ,"__sl__sl__sl",::_id_,iCSDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCSDictType(iCSDictID)
return FpQCall( {::_hdll_,"DPLGetCSDictType"} ,"__sl__sl__sl",::_id_,iCSDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCSDictWKT(iCSDictID)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetCSDictWKTA"} ,"__pt__sl__sl",::_id_,iCSDictID) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetContentStreamToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetContentStreamToString"} ,"__pt__sl",::_id_) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListCount(iImageListID)
return FpQCall( {::_hdll_,"DPLGetImageListCount"} ,"__sl__sl__sl",::_id_,iImageListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListItemDataToString(iImageListID, iImageIndex, iOptions)
   // KEIN ::ReadString(), da hier ein 8 Bit Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), Returns the image data of the specified image list item as a string of 8-bit bytes.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetImageListItemDataToString"} ,"__pt__sl__sl__sl__sl",::_id_,iImageListID,iImageIndex,iOptions) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListItemDblProperty(iImageListID, iImageIndex, iPropertyID)
return FpQCall( {::_hdll_,"DPLGetImageListItemDblProperty"} ,"__f8__sl__sl__sl__sl",::_id_,iImageListID,iImageIndex,iPropertyID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListItemIntProperty(iImageListID, iImageIndex, iPropertyID)
return FpQCall( {::_hdll_,"DPLGetImageListItemIntProperty"} ,"__sl__sl__sl__sl__sl",::_id_,iImageListID,iImageIndex,iPropertyID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageMeasureDict()
return FpQCall( {::_hdll_,"DPLGetImageMeasureDict"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImagePtDataDict()
return FpQCall( {::_hdll_,"DPLGetImagePtDataDict"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetLatestPrinterNames()                                        // ==> ::GetPrinterNameA()  ==> Array
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetLatestPrinterNamesA"} ,"__pt__sl",::_id_) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictBoundsCount(iMeasureDictID)
return FpQCall( {::_hdll_,"DPLGetMeasureDictBoundsCount"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictBoundsItem(iMeasureDictID, iItemIndex)
return FpQCall( {::_hdll_,"DPLGetMeasureDictBoundsItem"} ,"__f8__sl__sl__sl",::_id_,iMeasureDictID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictCoordinateSystem(iMeasureDictID)
return FpQCall( {::_hdll_,"DPLGetMeasureDictCoordinateSystem"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictDCSDict(iMeasureDictID)
return FpQCall( {::_hdll_,"DPLGetMeasureDictDCSDict"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictGCSDict(iMeasureDictID)
return FpQCall( {::_hdll_,"DPLGetMeasureDictGCSDict"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictGPTSCount(iMeasureDictID)
return FpQCall( {::_hdll_,"DPLGetMeasureDictGPTSCount"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictGPTSItem(iMeasureDictID, iItemIndex)
return FpQCall( {::_hdll_,"DPLGetMeasureDictGPTSItem"} ,"__f8__sl__sl__sl",::_id_,iMeasureDictID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictLPTSCount(iMeasureDictID)
return FpQCall( {::_hdll_,"DPLGetMeasureDictLPTSCount"} ,"__sl__sl__sl",::_id_,iMeasureDictID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictLPTSItem(iMeasureDictID, iItemIndex)
return FpQCall( {::_hdll_,"DPLGetMeasureDictLPTSItem"} ,"__f8__sl__sl__sl",::_id_,iMeasureDictID,iItemIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetMeasureDictPDU(iMeasureDictID, iUnitIndex)
return FpQCall( {::_hdll_,"DPLGetMeasureDictPDU"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iUnitIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetObjectSource(nObjectNumber); RETURN ::GetObjectToString(nObjectNumber) // alt / old
METHOD HBPrintPDF:GetObjectToString(iObjectNumber)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetObjectToString"} ,"__pt__sl__sl",::_id_,iObjectNumber) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetOptionalContentConfigLocked(iOptionalContentConfigID, iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"DPLGetOptionalContentConfigLocked"} ,"__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageColorSpaces(iOptions)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetPageColorSpacesA"} ,"__pt__sl__sl",::_id_,iOptions) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageContent(); RETURN ::GetPageContentToString()                       // alt / old
METHOD HBPrintPDF:GetPageContentToString()
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetPageContentToString"} ,"__pt__sl",::_id_) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageImageList(iOptions)
return FpQCall( {::_hdll_,"DPLGetPageImageList"} ,"__sl__sl__sl",::_id_,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageViewPortCount()
return FpQCall( {::_hdll_,"DPLGetPageViewPortCount"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageViewPortID(iIndex)
return FpQCall( {::_hdll_,"DPLGetPageViewPortID"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterDevModeToString(sPrinterName)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()
   sPrinterName := ::ForceAnsi(sPrinterName)
   // KEIN ::ReadString(), da hier ein Datenstrom als String zurckgeliefert wird. Das sind BINR Daten.
   // NO   ::ReadString(), return image data, no text.
   // Returns a binary string containing the DEVMODE structure for the specified printer.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetPrinterDevModeToStringA"} ,"__pt__sl__pt",::_id_,sPrinterName) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrinterMediaTypes(sPrinterName)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()
   sPrinterName := ::ForceAnsi(sPrinterName)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetPrinterMediaTypesA"} ,"__pt__sl__pt",::_id_,sPrinterName) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetStringListCount(iStringListID)
return FpQCall( {::_hdll_,"DPLGetStringListCount"} ,"__sl__sl__sl",::_id_,iStringListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetStringListItem(iStringListID, iItemIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetStringListItemA"} ,"__pt__sl__sl__sl",::_id_,iStringListID,iItemIndex) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetUnicodeCharactersFromEncoding(iEncoding)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetUnicodeCharactersFromEncodingA"} ,"__pt__sl__sl",::_id_,iEncoding) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewPortBBox(iViewPortID, iDimension)
return FpQCall( {::_hdll_,"DPLGetViewPortBBox"} ,"__f8__sl__sl__sl",::_id_,iViewPortID,iDimension)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewPortMeasureDict(iViewPortID)
return FpQCall( {::_hdll_,"DPLGetViewPortMeasureDict"} ,"__sl__sl__sl",::_id_,iViewPortID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewPortName(iViewPortID)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetViewPortNameA"} ,"__pt__sl__sl",::_id_,iViewPortID) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetViewPortPtDataDict(iViewPortID)
return FpQCall( {::_hdll_,"DPLGetViewPortPtDataDict"} ,"__sl__sl__sl",::_id_,iViewPortID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetXFAToString(iOptions)
   DEFAULT iOptions TO 0
   // KEIN ::ReadString(), da hier XML Daten geliefert wird.
   // NO   ::ReadString(), return XML data, no text.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetXFAToString"} ,"__pt__sl__sl",::_id_,iOptions) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:MoveLayer(p1,p2) ; RETURN ::MoveContentStream(p1,p2) // alt / old
METHOD HBPrintPDF:MoveContentStream(iFromPosition, iToPosition)
return 0 # FpQCall( {::_hdll_,"DPLMoveContentStream"} ,"__sl__sl__sl__sl",::_id_,iFromPosition,iToPosition)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewLayer() ; RETURN ::NewContentStream() // alt / old
METHOD HBPrintPDF:NewContentStream()
return FpQCall( {::_hdll_,"DPLNewContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewTilingPatternFromCapturedPage(sPatternName, iCaptureID)
   sPatternName := ::ForceAnsi(sPatternName)
return 0 # FpQCall( {::_hdll_,"DPLNewTilingPatternFromCapturedPageA"} ,"__sl__sl__pt__sl",::_id_,sPatternName,iCaptureID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseImage(iImageID)
return 0 # FpQCall( {::_hdll_,"DPLReleaseImage"} ,"__sl__sl__sl",::_id_,iImageID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseImageList(iImageListID)
return 0 # FpQCall( {::_hdll_,"DPLReleaseImageList"} ,"__sl__sl__sl",::_id_,iImageListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveFormFieldBorderColor(iIndex)
return 0 # FpQCall( {::_hdll_,"DPLRemoveFormFieldBorderColor"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveSharedLayers(); RETURN ::RemoveSharedContentStreams() // alt / old
METHOD HBPrintPDF:RemoveSharedContentStreams()
return FpQCall( {::_hdll_,"DPLRemoveSharedContentStreams"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SaveImageListItemDataToFile(iImageListID, iImageIndex, iOptions, sImageFileName)
   sImageFileName := ::ForceAnsi(sImageFileName)
return 0 # FpQCall( {::_hdll_,"DPLSaveImageListItemDataToFileA"} ,"__sl__sl__sl__sl__sl__pt",::_id_,iImageListID,iImageIndex,iOptions,sImageFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectLayer(iNewIndex); RETURN ::SelectContentStream(iNewIndex)
METHOD HBPrintPDF:SelectContentStream(iNewIndex)
return 0 # FpQCall( {::_hdll_,"DPLSelectContentStream"} ,"__sl__sl__sl",::_id_,iNewIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SelectRenderer(iRendererID)
return FpQCall( {::_hdll_,"DPLSelectRenderer"} ,"__sl__sl__sl",::_id_,iRendererID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotIntProperty(iIndex, iTag, iNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetAnnotIntProperty"} ,"__sl__sl__sl__sl__sl",::_id_,iIndex,iTag,iNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnsiMode(iNewAnsiMode)
     if iNewAnsiMode=NIL
        if ::UseAutoConvUTF8
           iNewAnsiMode := 0
        else
           iNewAnsiMode := 1
        endif
     else
        ::UseAutoConvUTF8 := (iNewAnsiMode = 0)
        FpQCall( {::_hdll_,"DPLSetAnsiMode"} ,"__sl__sl__sl",::_id_,iNewAnsiMode)
     endif
return iNewAnsiMode
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCSDictEPSG(iCSDictID, iNewEPSG)
return 0 # FpQCall( {::_hdll_,"DPLSetCSDictEPSG"} ,"__sl__sl__sl__sl",::_id_,iCSDictID,iNewEPSG)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCSDictType(iCSDictID, iNewDictType)
return 0 # FpQCall( {::_hdll_,"DPLSetCSDictType"} ,"__sl__sl__sl__sl",::_id_,iCSDictID,iNewDictType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCSDictWKT(iCSDictID, sNewWKT)
   sNewWKT := ::ForceAnsi(sNewWKT)
return 0 # FpQCall( {::_hdll_,"DPLSetCSDictWKTA"} ,"__sl__sl__sl__pt",::_id_,iCSDictID,sNewWKT)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCairoFileName(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLSetCairoFileNameA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetCapturedPageTransparencyGroup(iCaptureID, iCS, iIsolate, iKnockout)
return 0 # FpQCall( {::_hdll_,"DPLSetCapturedPageTransparencyGroup"} ,"__sl__sl__sl__sl__sl__sl",::_id_,iCaptureID,iCS,iIsolate,iKnockout)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetContentStreamFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetContentStreamFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLayerOptional(nOptionalContentGroupID) ; RETURN ::SetContentStreamOptional(nOptionalContentGroupID)  // ALT / OLD
METHOD HBPrintPDF:SetContentStreamOptional(iOptionalContentGroupID)
return 0 # FpQCall( {::_hdll_,"DPLSetContentStreamOptional"} ,"__sl__sl__sl",::_id_,iOptionalContentGroupID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDestProperties(iDestID, iZoom, iDestType, dLeft, dTop, dRight, dBottom)
return 0 # FpQCall( {::_hdll_,"DPLSetDestProperties"} ,"__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iDestID,iZoom,iDestType,dLeft,dTop,dRight,dBottom)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDestValue(iDestID, iValueKey, dNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetDestValue"} ,"__sl__sl__sl__sl__f8",::_id_,iDestID,iValueKey,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFillTilingPattern(sPatternName)
   sPatternName := ::ForceAnsi(sPatternName)
return 0 # FpQCall( {::_hdll_,"DPLSetFillTilingPatternA"} ,"__sl__sl__pt",::_id_,sPatternName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetLineDashEx(sDashValues)
   sDashValues := ::ForceAnsi(sDashValues)
return 0 # FpQCall( {::_hdll_,"DPLSetLineDashExA"} ,"__sl__sl__pt",::_id_,sDashValues)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictBoundsCount(iMeasureDictID, iNewCount)
return 0 # FpQCall( {::_hdll_,"DPLSetMeasureDictBoundsCount"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iNewCount)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictBoundsItem(iMeasureDictID, iItemIndex, dNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetMeasureDictBoundsItem"} ,"__sl__sl__sl__sl__f8",::_id_,iMeasureDictID,iItemIndex,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictCoordinateSystem(iMeasureDictID, iCoordinateSystemID)
return 0 # FpQCall( {::_hdll_,"DPLSetMeasureDictCoordinateSystem"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iCoordinateSystemID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictGPTSCount(iMeasureDictID, iNewCount)
return 0 # FpQCall( {::_hdll_,"DPLSetMeasureDictGPTSCount"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iNewCount)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictGPTSItem(iMeasureDictID, iItemIndex, dNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetMeasureDictGPTSItem"} ,"__sl__sl__sl__sl__f8",::_id_,iMeasureDictID,iItemIndex,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictLPTSCount(iMeasureDictID, iNewCount)
return 0 # FpQCall( {::_hdll_,"DPLSetMeasureDictLPTSCount"} ,"__sl__sl__sl__sl",::_id_,iMeasureDictID,iNewCount)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictLPTSItem(iMeasureDictID, iItemIndex, dNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetMeasureDictLPTSItem"} ,"__sl__sl__sl__sl__f8",::_id_,iMeasureDictID,iItemIndex,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetMeasureDictPDU(iMeasureDictID, iLinearUnit, iAreaUnit, iAngularUnit)
return 0 # FpQCall( {::_hdll_,"DPLSetMeasureDictPDU"} ,"__sl__sl__sl__sl__sl__sl",::_id_,iMeasureDictID,iLinearUnit,iAreaUnit,iAngularUnit)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetObjectSource(iObjectNumber, sNewObjectSource); RETURN ::SetObjectFromString(iObjectNumber, sNewObjectSource) // alt / old
METHOD HBPrintPDF:SetObjectFromString(iObjectNumber, iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
return 0 # ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetObjectFromString"} ,"__sl__sl__sl__pt",::_id_,iObjectNumber,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentConfigLocked(iOptionalContentConfigID, iOptionalContentGroupID, iNewLocked)
return 0 # FpQCall( {::_hdll_,"DPLSetOptionalContentConfigLocked"} ,"__sl__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID,iNewLocked)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentConfigState(iOptionalContentConfigID, iOptionalContentGroupID, iNewState)
return 0 # FpQCall( {::_hdll_,"DPLSetOptionalContentConfigState"} ,"__sl__sl__sl__sl__sl",::_id_,iOptionalContentConfigID,iOptionalContentGroupID,iNewState)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPDFAMode(iNewMode)
return 0 # FpQCall( {::_hdll_,"DPLSetPDFAMode"} ,"__sl__sl__sl",::_id_,iNewMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageContent(cNewContent); RETURN ::SetPageContentFromString(cNewContent)       // alt / old
METHOD HBPrintPDF:SetPageContentFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetPageContentFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPrinterDevModeFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetPrinterDevModeFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderCropType(iNewCropType)
return 0 # FpQCall( {::_hdll_,"DPLSetRenderCropType"} ,"__sl__sl__sl",::_id_,iNewCropType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableThinBorders(iTableID, iThinBorders, dRed, dGreen, dBlue)
return 0 # FpQCall( {::_hdll_,"DPLSetTableThinBorders"} ,"__sl__sl__sl__sl__f8__f8__f8",::_id_,iTableID,iThinBorders,dRed,dGreen,dBlue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTableThinBordersCMYK(iTableID, iThinBorders, dC, dM, dY, dK)
return 0 # FpQCall( {::_hdll_,"DPLSetTableThinBordersCMYK"} ,"__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,iTableID,iThinBorders,dC,dM,dY,dK)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionArea(dLeft, dTop, dWidth, dHeight)
return FpQCall( {::_hdll_,"DPLSetTextExtractionArea"} ,"__sl__sl__f8__f8__f8__f8",::_id_,dLeft,dTop,dWidth,dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionOptions(iOptionID, iNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetTextExtractionOptions"} ,"__sl__sl__sl__sl",::_id_,iOptionID,iNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextExtractionScaling(iOptions, dHorizontal, dVertical)
return 0 # FpQCall( {::_hdll_,"DPLSetTextExtractionScaling"} ,"__sl__sl__sl__f8__f8",::_id_,iOptions,dHorizontal,dVertical)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineCustomDash(sDashPattern, dDashPhase)
   sDashPattern := ::ForceAnsi(sDashPattern)
return FpQCall( {::_hdll_,"DPLSetTextUnderlineCustomDashA"} ,"__sl__sl__pt__f8",::_id_,sDashPattern,dDashPhase)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineDistance(dUnderlineDistance)
return FpQCall( {::_hdll_,"DPLSetTextUnderlineDistance"} ,"__sl__sl__f8",::_id_,dUnderlineDistance)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTextUnderlineWidth(dUnderlineWidth)
return FpQCall( {::_hdll_,"DPLSetTextUnderlineWidth"} ,"__sl__sl__f8",::_id_,dUnderlineWidth)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetXFAFromString(iSource, iOptions)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
return 0 # ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetXFAFromString"} ,"__sl__sl__pt__sl",::_id_,::_b(iSource,ptb,1),iOptions) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UseUnsafeLayers(p1) ; RETURN ::UseUnsafeContentStreams(p1) // alt/old
METHOD HBPrintPDF:UseUnsafeContentStreams(iSafetyLevel)
return 0 # FpQCall( {::_hdll_,"DPLUseUnsafeContentStreams"} ,"__sl__sl__sl",::_id_,iSafetyLevel)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetErrorText(nErrorCode)
   LOCAL x, cLangID, cTxt     // This PRG use ANSI codepage // diese Datei benutzt die ANSI codepage
   STATIC aErrorText := { ;   // 2 Bytes => ISO 639-1 es = espania, en = english, fr = french, de = germany  LOWER !!!
                        { 101, "en", "The Strength parameter passed to the Encrypt function was invalid" },;
                        { 101, "de", "Der 'Strength'-Parameter der an 'Encrypt' bergeben wurde ist unglig" },;
                        { 101, "fr", "Le paramtre 'Strength' pass  la fonction 'Encrypt' tait invalide" },;
                        { 102, "en", "The Permissions parameter passed to the Encrypt function was invalid. Use the EncodePermissions function to construct a value for this parameter" },;
                        { 102, "de", "Der 'Permissions'-Parameter der an 'Encrypt' bergeben wurde ist unglig, nutze ::EncodePermissions()" },;
                        { 102, "fr", "Le paramtre 'Permissions' pass  la fonction 'Encrypt' est invalide, utilisez ::EncodePermissions()" },;
                        { 103, "en", "The Encrypt function was used on a document that was already encrypted" },;
                        { 103, "de", "Die PDF ist schon verschlsselt, ::Encrypt() ist nicht erlaubt." },;
                        { 103, "fr", "La fonction Encrypt a t utilise sur un document d&j crypt" },;
                        { 104, "en", "The Encrypt function failed for an unknown reason" },;
                        { 104, "de", "Bei ::Encrypt() ist ein unbekannter Fehler aufgetreten." },;
                        { 104, "fr", "La fonction Encrypt a rencontr une erreur inconnue" },;
                        { 201, "en", "The SetInformation function failed because the document is encrypted" },;
                        { 201, "de", "::SetInformation() kann keine verschlsselten PDF auswerten" },;
                        { 201, "fr", "Erreur dans la fonction SetInformation parce que le document est crypt" },;
                        { 202, "en", "The Key parameter passed to the SetInformation function was out of range" },;
                        { 202, "de", "::SetInformation() wurde ein falscher 'Key'-Parameter bergeben" },;
                        { 202, "fr", "Le paramtre Key pass  la fonction SetInformation function est hors limites" },;
                        { 301, "en", "An invalid combination of barcode and option was sent to the DrawBarcode function" },;
                        { 301, "de", "Die Kombination von 'barcode' und 'option' bei ::DrawBarcode() war ungltig" },;
                        { 301, "fr", "Une combination invalide de barcode et d'option a t transmise  la fonction DrawBarcode" },;
                        { 302, "en", "Non-numeric characters were sent to DrawBarcode using EAN-13" },;
                        { 302, "de", "Bei einem EAN-13 Barcode drfen nur Ziffern im String an ::DrawBarcode() bergeben werden." },;
                        { 302, "fr", "Des caractres non-numriques ont t transmis  la fonction DrawBarcode pour EAN-13" },;
                        { 303, "en", "The EAN-13 barcode has an invalid checksum character" },;
                        { 303, "de", "Die Prfziffer beim EAN-13 Barcode war falsch" },;
                        { 303, "fr", "Le code  barres EAN-13 a un caractre de contrle invalide" },;
                        { 401, "en", "Could not open input file" },;
                        { 401, "de", "Die Quelldatei konnte nicht geffnet werden" },;
                        { 401, "fr", "Le fichier d'entre n'a pas pu tre ouvert" },;
                        { 402, "en", "Output file already exists and could not be deleted" },;
                        { 402, "de", "Die Zieldatei existierte bereits und konnte nicht gelscht werden" },;
                        { 402, "fr", "Le fichier de sortie existe dj et n'a pas pu tre effac" },;
                        { 403, "en", "Could not open output file" },;
                        { 403, "de", "Die Zieldatei konnte nicht geffnet werden" },;
                        { 403, "fr", "Le fichier de sortie n'a pas pu tre ouvert" },;
                        { 404, "en", "Invalid password" },;
                        { 404, "de", "Das Passwort ist ungltig" },;
                        { 404, "fr", "Mot de passe invalide" },;
                        { 405, "en", "Document is not encrypted" },;
                        { 405, "de", "Das Dokument ist nicht verschlsselt" },;
                        { 405, "fr", "Document non crypt" },;
                        { 406, "en", "Document is already encrypted" },;
                        { 406, "de", "Das Dokument ist schon verschlsselt" },;
                        { 406, "fr", "Document dj crypt" },;
                        { 407, "en", "Invalid encryption strength" },;
                        { 407, "de", "Die Verschlsselungsstrke ist ungltig (encryption strength)" },;
                        { 407, "fr", "Force du cryptage invalide" },;
                        { 408, "en", "Invalid permissions" },;
                        { 408, "de", "Zugriff verweigert" },;
                        { 408, "fr", "Permissions invalides" },;
                        { 409, "en", "Invalid file structure, file is damaged" },;
                        { 409, "de", "Ungltige Dateistruktur, Dokument wurde beschdigt" },;
                        { 409, "fr", "Structure de fichier invalide, le fichieer est corrompu" },;
                        { 410, "en", "One of the input files is encrypted" },;
                        { 410, "de", "Eine der Quelldateien ist verschlsselt" },;
                        { 410, "fr", "Un des fichiers d'entre est crypt" },;
                        { 411, "en", "File not found" },;
                        { 411, "de", "Datei wurde nicht gefunden" },;
                        { 411, "fr", "Fichier non trouv" },;
                        { 412, "en", "Invalid page range list" },;
                        { 412, "de", "Ungltige Seitenangabe" },;
                        { 412, "fr", "Liste de page invalide" },;
                        { 501, "en", "The specified FileHandle was invalid" },;
                        { 501, "de", "Dateihandle ist ungltig" },;
                        { 501, "fr", "Le pointeur de fichier est invalide" },;
                        { 999, "en", "The function could not be used because the library is not unlocked" },;
                        { 999, "de", "DebenuPDFLibrary wurde nicht 'unlocked' - Schlsselfehler" },;
                        { 999, "fr", "La fonction n'a pas pu tre utilise car la librairie n'est pas dbloque" } ;
                        }

   x := 0
   DEFAULT nErrorCode TO ::LastErrorCode()
   cLangID := alltrim(left(lower(::cErrorLanguage),2)) // max. 2 Byte

   do case
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode .and.  cLangID == a[2] } ) )
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode .and.  "en" == a[2] } ) )
      case ! empty( x := ascan( aErrorText, {|a| a[1]=nErrorCode } ) )
   end
   if x > 0
      cTxt := var2char(nErrorCode)+": "+alltrim(aErrorText[x,3])
   else
      cTxt := var2char(nErrorCode)+": unknown, unbekannt"
   endif

   if ::nCharSet = 1    // ANSI => OEM
      cTxt := ConvToOemCP(cTxt)
   endif              // OK OEM

return cTxt

**********************************************************************************************************************
// neu in 9.11 - PowerBasic INC    9.11
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFormFieldChoiceSub(iIndex, sSubName, sDisplayName)
   sSubName := ::ForceAnsi(sSubName)
   sDisplayName := ::ForceAnsi(sDisplayName)
return FpQCall( {::_hdll_,"DPLAddFormFieldChoiceSubA"} ,"__sl__sl__sl__pt__pt",::_id_,iIndex,sSubName,sDisplayName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddStampAnnotation(dLeft, dTop, dWidth, dHeight, iStampType, sTitle, sContents, dRed, dGreen, dBlue, iOptions)
   sTitle := ::ForceAnsi(sTitle)
   sContents := ::ForceAnsi(sContents)
return 0 # FpQCall( {::_hdll_,"DPLAddStampAnnotationA"} ,"__sl__sl__f8__f8__f8__f8__sl__pt__pt__f8__f8__f8__sl",::_id_,dLeft,dTop,dWidth,dHeight,iStampType,sTitle,sContents,dRed,dGreen,dBlue,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:BalanceContentStream()
return FpQCall( {::_hdll_,"DPLBalanceContentStream"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CopyPageRangesEx(iDocumentID, sRangeList, iOptions)
   sRangeList := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"DPLCopyPageRangesExA"} ,"__sl__sl__sl__pt__sl",::_id_,iDocumentID,sRangeList,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetDocumentRepaired()
return 0 # FpQCall( {::_hdll_,"DPLGetDocumentRepaired"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubDisplayName(iIndex, iSubIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetFormFieldSubDisplayNameA"} ,"__pt__sl__sl__sl",::_id_,iIndex,iSubIndex) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotDblProperty(iIndex, iTag, dNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetAnnotDblProperty"} ,"__sl__sl__sl__sl__f8",::_id_,iIndex,iTag,dNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotRect(iIndex, dLeft, dTop, dWidth, dHeight)
return FpQCall( {::_hdll_,"DPLSetAnnotRect"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,iIndex,dLeft,dTop,dWidth,dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:TransformFile(sInputFileName, sPassword, sOutputFileName, iTransformType, iOptions)
   sInputFileName := ::ForceAnsi(sInputFileName)
   sPassword := ::ForceAnsi(sPassword)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
return FpQCall( {::_hdll_,"DPLTransformFileA"} ,"__sl__sl__pt__pt__pt__sl__sl",::_id_,sInputFileName,sPassword,sOutputFileName,iTransformType,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UpdateAndFlattenFormField(iIndex)
return 0 # FpQCall( {::_hdll_,"DPLUpdateAndFlattenFormField"} ,"__sl__sl__sl",::_id_,iIndex)

**********************************************************************************************************************
// neu in 9.12 - PowerBasic INC    9.12
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBackgroundColorType(iIndex)
return FpQCall( {::_hdll_,"DPLGetFormFieldBackgroundColorType"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldBorderColorType(iIndex)
return FpQCall( {::_hdll_,"DPLGetFormFieldBorderColorType"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveFormFieldBackgroundColor(iIndex)
return 0 # FpQCall( {::_hdll_,"DPLRemoveFormFieldBackgroundColor"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveOpenAction()
return 0 # FpQCall( {::_hdll_,"DPLRemoveOpenAction"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBackgroundColorGray(iIndex, dGray)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBackgroundColorGray"} ,"__sl__sl__sl__f8",::_id_,iIndex,dGray)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldBorderColorGray(iIndex, dGray)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldBorderColorGray"} ,"__sl__sl__sl__f8",::_id_,iIndex,dGray)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetOptionalContentGroupName(iOptionalContentGroupID, sNewGroupName)
   sNewGroupName := ::ForceAnsi(sNewGroupName)
return 0 # FpQCall( {::_hdll_,"DPLSetOptionalContentGroupNameA"} ,"__sl__sl__sl__pt",::_id_,iOptionalContentGroupID,sNewGroupName)

**********************************************************************************************************************
// neu in 9.13 - PowerBasic INC    9.13
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAExtractPageTextBlocks(iFileHandle, iPageRef, iExtractOptions)
return FpQCall( {::_hdll_,"DPLDAExtractPageTextBlocks"} ,"__sl__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef,iExtractOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockBound(iTextBlockListID, iIndex, iBoundIndex)
return FpQCall( {::_hdll_,"DPLDAGetTextBlockBound"} ,"__f8__sl__sl__sl__sl",::_id_,iTextBlockListID,iIndex,iBoundIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockCharWidth(iTextBlockListID, iIndex, iCharIndex)
return FpQCall( {::_hdll_,"DPLDAGetTextBlockCharWidth"} ,"__f8__sl__sl__sl__sl",::_id_,iTextBlockListID,iIndex,iCharIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockColor(iTextBlockListID, iIndex, iColorComponent)
return FpQCall( {::_hdll_,"DPLDAGetTextBlockColor"} ,"__f8__sl__sl__sl__sl",::_id_,iTextBlockListID,iIndex,iColorComponent)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockColorType(iTextBlockListID, iIndex)
return FpQCall( {::_hdll_,"DPLDAGetTextBlockColorType"} ,"__sl__sl__sl__sl",::_id_,iTextBlockListID,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockCount(iTextBlockListID)
return FpQCall( {::_hdll_,"DPLDAGetTextBlockCount"} ,"__sl__sl__sl",::_id_,iTextBlockListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockFontName(iTextBlockListID, iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLDAGetTextBlockFontNameA"} ,"__pt__sl__sl__sl",::_id_,iTextBlockListID,iIndex) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockFontSize(iTextBlockListID, iIndex)
return FpQCall( {::_hdll_,"DPLDAGetTextBlockFontSize"} ,"__f8__sl__sl__sl",::_id_,iTextBlockListID,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockText(iTextBlockListID, iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLDAGetTextBlockTextA"} ,"__pt__sl__sl__sl",::_id_,iTextBlockListID,iIndex) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAReleaseTextBlocks(iTextBlockListID)
return FpQCall( {::_hdll_,"DPLDAReleaseTextBlocks"} ,"__sl__sl__sl",::_id_,iTextBlockListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EndSignProcessToFile(iSignProcessID, sOutputFile)
   sOutputFile := ::ForceAnsi(sOutputFile)
return FpQCall( {::_hdll_,"DPLEndSignProcessToFileA"} ,"__sl__sl__sl__pt",::_id_,iSignProcessID,sOutputFile)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:EndSignProcessToString(iSignProcessID)
   // KEIN ::ReadString(), Das sind BINR Daten.
   // NO   ::ReadString(), return binary data.
return ::_str_result_( FpQCall( {::_hdll_,"DPLEndSignProcessToString"} ,"__pt__sl__sl",::_id_,iSignProcessID) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePageTextBlocks(sInputFileName, sPassword, iPage, iOptions)
   sInputFileName := ::ForceAnsi(sInputFileName)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"DPLExtractFilePageTextBlocksA"} ,"__sl__sl__pt__pt__sl__sl",::_id_,sInputFileName,sPassword,iPage,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractPageTextBlocks(iExtractOptions)
return FpQCall( {::_hdll_,"DPLExtractPageTextBlocks"} ,"__sl__sl__sl",::_id_,iExtractOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldCheckStyle(iIndex)
return FpQCall( {::_hdll_,"DPLGetFormFieldCheckStyle"} ,"__sl__sl__sl",::_id_,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldTabOrderEx(iIndex, iOptions)
return 0 # FpQCall( {::_hdll_,"DPLGetFormFieldTabOrderEx"} ,"__sl__sl__sl__sl",::_id_,iIndex,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockBound(iTextBlockListID, iIndex, iBoundIndex)
return FpQCall( {::_hdll_,"DPLGetTextBlockBound"} ,"__f8__sl__sl__sl__sl",::_id_,iTextBlockListID,iIndex,iBoundIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockCharWidth(iTextBlockListID, iIndex, iCharIndex)
return FpQCall( {::_hdll_,"DPLGetTextBlockCharWidth"} ,"__f8__sl__sl__sl__sl",::_id_,iTextBlockListID,iIndex,iCharIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockColor(iTextBlockListID, iIndex, iColorComponent)
return FpQCall( {::_hdll_,"DPLGetTextBlockColor"} ,"__f8__sl__sl__sl__sl",::_id_,iTextBlockListID,iIndex,iColorComponent)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockColorType(iTextBlockListID, iIndex)
return FpQCall( {::_hdll_,"DPLGetTextBlockColorType"} ,"__sl__sl__sl__sl",::_id_,iTextBlockListID,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockCount(iTextBlockListID)
return FpQCall( {::_hdll_,"DPLGetTextBlockCount"} ,"__sl__sl__sl",::_id_,iTextBlockListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockFontName(iTextBlockListID, iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetTextBlockFontNameA"} ,"__pt__sl__sl__sl",::_id_,iTextBlockListID,iIndex) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockFontSize(iTextBlockListID, iIndex)
return FpQCall( {::_hdll_,"DPLGetTextBlockFontSize"} ,"__f8__sl__sl__sl",::_id_,iTextBlockListID,iIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockText(iTextBlockListID, iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetTextBlockTextA"} ,"__pt__sl__sl__sl",::_id_,iTextBlockListID,iIndex) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewSignProcessFromFile(sInputFile, sPassword)
   sInputFile := ::ForceAnsi(sInputFile)
   sPassword := ::ForceAnsi(sPassword)
return FpQCall( {::_hdll_,"DPLNewSignProcessFromFileA"} ,"__sl__sl__pt__pt",::_id_,sInputFile,sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewSignProcessFromString(iSource, sPassword)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
   sPassword := ::ForceAnsi(sPassword)
return ::_ptb_free_( FpQCall( {::_hdll_,"DPLNewSignProcessFromStringA"} ,"__sl__sl__pt__pt",::_id_,::_b(iSource,ptb,1),sPassword) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseTextBlocks(iTextBlockListID)
return FpQCall( {::_hdll_,"DPLReleaseTextBlocks"} ,"__sl__sl__sl",::_id_,iTextBlockListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldSignatureImage(iIndex, iImageID, iOptions)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldSignatureImage"} ,"__sl__sl__sl__sl__sl",::_id_,iIndex,iImageID,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessField(iSignProcessID, sSignatureFieldName)
   sSignatureFieldName := ::ForceAnsi(sSignatureFieldName)
return FpQCall( {::_hdll_,"DPLSetSignProcessFieldA"} ,"__sl__sl__sl__pt",::_id_,iSignProcessID,sSignatureFieldName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessInfo(iSignProcessID, sReason, sLocation, sContactInfo)
   sReason := ::ForceAnsi(sReason)
   sLocation := ::ForceAnsi(sLocation)
   sContactInfo := ::ForceAnsi(sContactInfo)
return FpQCall( {::_hdll_,"DPLSetSignProcessInfoA"} ,"__sl__sl__sl__pt__pt__pt",::_id_,iSignProcessID,sReason,sLocation,sContactInfo)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessPFXFromFile(iSignProcessID, sPFXFileName, sPFXPassword)
   sPFXFileName := ::ForceAnsi(sPFXFileName)
   sPFXPassword := ::ForceAnsi(sPFXPassword)
return FpQCall( {::_hdll_,"DPLSetSignProcessPFXFromFileA"} ,"__sl__sl__sl__pt__pt",::_id_,iSignProcessID,sPFXFileName,sPFXPassword)

**********************************************************************************************************************
// neu in 9.14 - PowerBasic INC    9.14
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddBoxToPath(dLeft, dTop, dWidth, dHeight)
return FpQCall( {::_hdll_,"DPLAddBoxToPath"} ,"__sl__sl__f8__f8__f8__f8",::_id_,dLeft,dTop,dWidth,dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ExtractFilePagesEx(sInputFileName, sPassword, sOutputFileName, sRangeList, iOptions)
   sInputFileName := ::ForceAnsi(sInputFileName)
   sPassword := ::ForceAnsi(sPassword)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
   sRangeList := ::ForceAnsi(sRangeList)
return 0 # FpQCall( {::_hdll_,"DPLExtractFilePagesExA"} ,"__sl__sl__pt__pt__pt__pt__sl",::_id_,sInputFileName,sPassword,sOutputFileName,sRangeList,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:FlattenAnnot(iIndex, iOptions)
return 0 # FpQCall( {::_hdll_,"DPLFlattenAnnot"} ,"__sl__sl__sl__sl",::_id_,iIndex,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotSoundToFile(iIndex, iOptions, sSoundFileName)
   sSoundFileName := ::ForceAnsi(sSoundFileName)
return 0 # FpQCall( {::_hdll_,"DPLGetAnnotSoundToFileA"} ,"__sl__sl__sl__sl__pt",::_id_,iIndex,iOptions,sSoundFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotSoundToString(iIndex, iOptions)
   // KEIN ::ReadString(), Das sind BINR Daten.
   // NO   ::ReadString(), return binary data.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetAnnotSoundToString"} ,"__pt__sl__sl__sl",::_id_,iIndex,iOptions) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontFlags(iFontFlagItemID)
return 0 # FpQCall( {::_hdll_,"DPLGetFontFlags"} ,"__sl__sl__sl",::_id_,iFontFlagItemID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageMetricsToString(iStartPage, iEndPage, iOptions)
   // KEIN ::ReadString(), Das sind BINR Daten.
   // NO   ::ReadString(), return binary data.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetPageMetricsToString"} ,"__pt__sl__sl__sl__sl",::_id_,iStartPage,iEndPage,iOptions) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetSignProcessResult(iSignProcessID)
return FpQCall( {::_hdll_,"DPLGetSignProcessResult"} ,"__sl__sl__sl",::_id_,iSignProcessID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:IsTaggedPDF()
return 0 # FpQCall( {::_hdll_,"DPLIsTaggedPDF"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintPages(sPrinterName, sPageRanges, iOptions)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()
   sPrinterName := ::ForceAnsi(sPrinterName)
   sPageRanges := ::ForceAnsi(sPageRanges)
return 0 # FpQCall( {::_hdll_,"DPLPrintPagesA"} ,"__sl__sl__pt__pt__sl",::_id_,sPrinterName,sPageRanges,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintPagesToFile(sPrinterName, sPageRanges, iOptions, sFileName)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()
   sPrinterName := ::ForceAnsi(sPrinterName)
   sPageRanges := ::ForceAnsi(sPageRanges)
   sFileName := ::ForceAnsi(sFileName)
return 0 # FpQCall( {::_hdll_,"DPLPrintPagesToFileA"} ,"__sl__sl__pt__pt__sl__pt",::_id_,sPrinterName,sPageRanges,iOptions,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseSignProcess(iSignProcessID)
return 0 # FpQCall( {::_hdll_,"DPLReleaseSignProcess"} ,"__sl__sl__sl",::_id_,iSignProcessID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:ReleaseStringList(iStringListID)
return 0 # FpQCall( {::_hdll_,"DPLReleaseStringList"} ,"__sl__sl__sl",::_id_,iStringListID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessFieldBounds(iSignProcessID, dLeft, dTop, dWidth, dHeight)
return 0 # FpQCall( {::_hdll_,"DPLSetSignProcessFieldBounds"} ,"__sl__sl__sl__f8__f8__f8__f8",::_id_,iSignProcessID,dLeft,dTop,dWidth,dHeight)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessFieldImageFromFile(iSignProcessID, sImageFileName, iOptions)
   sImageFileName := ::ForceAnsi(sImageFileName)
return 0 # FpQCall( {::_hdll_,"DPLSetSignProcessFieldImageFromFileA"} ,"__sl__sl__sl__pt__sl",::_id_,iSignProcessID,sImageFileName,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessSubFilter(iSignProcessID, iSubFilter)
return FpQCall( {::_hdll_,"DPLSetSignProcessSubFilter"} ,"__sl__sl__sl__sl",::_id_,iSignProcessID,iSubFilter)

**********************************************************************************************************************
// neu in 9.15 - PowerBasic INC    9.15
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:BalancePageTree(iOptions)
   iOptions := 0 // Reserved for future use, should be set to zero.
return 0 # FpQCall( {::_hdll_,"DPLBalancePageTree"} ,"__sl__sl__sl",::_id_,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAShiftedHeader(iFileHandle)
return FpQCall( {::_hdll_,"DPLDAShiftedHeader"} ,"__sl__sl__sl",::_id_,iFileHandle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawCapturedPageMatrix(iCaptureID, dM11, dM12, dM21, dM22, dMDX, dMDY)
return 0 # FpQCall( {::_hdll_,"DPLDrawCapturedPageMatrix"} ,"__sl__sl__sl__f8__f8__f8__f8__f8__f8",::_id_,iCaptureID,dM11,dM12,dM21,dM22,dMDX,dMDY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawHTMLTextBoxMatrix(dWidth, dHeight, sHTMLText, dM11, dM12, dM21, dM22, dMDX, dMDY)
   sHTMLText := ::ForceAnsi(sHTMLText)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLDrawHTMLTextBoxMatrixA"} ,"__pt__sl__f8__f8__pt__f8__f8__f8__f8__f8__f8",::_id_,dWidth,dHeight,sHTMLText,dM11,dM12,dM21,dM22,dMDX,dMDY) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawPDF417SymbolEx(dLeft, dTop, sText, iOptions, iFixedColumns, iFixedRows, iErrorLevel, dModuleSize, dHeightWidthRatio)
   sText := ::ForceAnsi(sText)
return 0 # FpQCall( {::_hdll_,"DPLDrawPDF417SymbolExA"} ,"__sl__sl__f8__f8__pt__sl__sl__sl__sl__f8__f8",::_id_,dLeft,dTop,sText,iOptions,iFixedColumns,iFixedRows,iErrorLevel,dModuleSize,dHeightWidthRatio)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawTextBoxMatrix(dWidth, dHeight, sText, iOptions, dM11, dM12, dM21, dM22, dMDX, dMDY)
   sText := ::ForceAnsi(sText)
return FpQCall( {::_hdll_,"DPLDrawTextBoxMatrixA"} ,"__sl__sl__f8__f8__pt__sl__f8__f8__f8__f8__f8__f8",::_id_,dWidth,dHeight,sText,iOptions,dM11,dM12,dM21,dM22,dMDX,dMDY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldRichTextString(iIndex, sKey)
   sKey := ::ForceAnsi(sKey)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetFormFieldRichTextStringA"} ,"__pt__sl__sl__pt",::_id_,iIndex,sKey) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetObjectDecodeError(iObjectNumber)
return 0 # FpQCall( {::_hdll_,"DPLGetObjectDecodeError"} ,"__sl__sl__sl",::_id_,iObjectNumber)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetSignProcessByteRange(iSignProcessID, iArrayPosition)
   // ????? "__ul" ?????
return FpQCall( {::_hdll_,"DPLGetSignProcessByteRange"} ,"__sl__sl__sl__sl",::_id_,iSignProcessID,iArrayPosition)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldResetAction(iIndex, sActionType)
   sActionType := ::ForceAnsi(sActionType)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldResetActionA"} ,"__sl__sl__sl__pt",::_id_,iIndex,sActionType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldRichTextString(iIndex, sKey, sNewValue)
   sKey := ::ForceAnsi(sKey)
   sNewValue := ::ForceAnsi(sNewValue)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldRichTextStringA"} ,"__sl__sl__sl__pt__pt",::_id_,iIndex,sKey,sNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldSubmitActionEx(iIndex, sActionType, sLink, iFlags)
   sActionType := ::ForceAnsi(sActionType)
   sLink := ::ForceAnsi(sLink)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldSubmitActionExA"} ,"__sl__sl__sl__pt__pt__sl",::_id_,iIndex,sActionType,sLink,iFlags)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetRenderOptions(iOptionID, iNewValue)
return FpQCall( {::_hdll_,"DPLSetRenderOptions"} ,"__sl__sl__sl__sl",::_id_,iOptionID,iNewValue)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessFieldPage(iSignProcessID, iSignaturePage)
return 0 # FpQCall( {::_hdll_,"DPLSetSignProcessFieldPage"} ,"__sl__sl__sl__sl",::_id_,iSignProcessID,iSignaturePage)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessPassthrough(iSignProcessID, iSignatureLength)
return 0 # FpQCall( {::_hdll_,"DPLSetSignProcessPassthrough"} ,"__sl__sl__sl__sl",::_id_,iSignProcessID,iSignatureLength)

**********************************************************************************************************************
// neu in 9.16 - PowerBasic INC    9.16
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToFileEx(dLeft, dTop, dWidth, dHeight, sFileName, iDestPage, iNewWindow, iOptions, iZoom, iDestType, dDestLeft, dDestTop, dDestRight, dDestBottom)
   sFileName := ::ForceAnsi(sFileName)
return FpQCall( {::_hdll_,"DPLAddLinkToFileExA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,iDestPage,iNewWindow,iOptions,iZoom,iDestType,dDestLeft,dDestTop,dDestRight,dDestBottom)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrintPreviewBitmapToSetBuffer(sPrinterName, iPreviewPage, iPrintOptions, iMaxDimension, iPreviewOptions) //  NUR FR XbpBitmap():SetBuffer() !
RETURN substr(  ::GetPrintPreviewBitmapToString(sPrinterName, iPreviewPage, iPrintOptions, iMaxDimension, iPreviewOptions)  ,15)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPrintPreviewBitmapToString(sPrinterName, iPreviewPage, iPrintOptions, iMaxDimension, iPreviewOptions)
   DEFAULT sPrinterName TO ::GetDefaultPrinterName()
   sPrinterName := ::ForceAnsi(sPrinterName)
   DEFAULT iPreviewPage  TO 1
   DEFAULT iPrintOptions TO ::PrintOptions(0,0,"HBPrintPDF")
   iPreviewOptions := 0 // PreviewOptions Reserved for future use, should be set to zero.
   // KEIN ::ReadString(), Das sind BINR Daten.
   // NO   ::ReadString(), return binary data.
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetPrintPreviewBitmapToStringA"} ,"__pt__sl__pt__sl__sl__sl__sl",::_id_,sPrinterName,iPreviewPage,iPrintOptions,iMaxDimension,iPreviewOptions) )
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTabOrderMode()
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetTabOrderModeA"} ,"__pt__sl",::_id_) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:NewInternalPrinterObject(iOptions)
   iOptions := 0 // Options: Must be set to 0
return 0 # FpQCall( {::_hdll_,"DPLNewInternalPrinterObject"} ,"__sl__sl__sl",::_id_,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PageHasFontResources(iPageNumber)
return 0 # FpQCall( {::_hdll_,"DPLPageHasFontResources"} ,"__sl__sl__sl",::_id_,iPageNumber)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldChoiceSub(iIndex, iSubIndex, sSubName, sDisplayName)
   sSubName := ::ForceAnsi(sSubName)
   sDisplayName := ::ForceAnsi(sDisplayName)
return 0 # FpQCall( {::_hdll_,"DPLSetFormFieldChoiceSubA"} ,"__sl__sl__sl__sl__pt__pt",::_id_,iIndex,iSubIndex,sSubName,sDisplayName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetHeaderCommentsFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,3) // Funktion mit 2 Parameter, daher 3 !
   do case
      case empty(iSource)
           iSource := "%"
      case left(iSource,1) # "%"    // The string should start with a % character to indicate that it is a comment.
           iSource := "%"+iSource
   end
return 0 # ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetHeaderCommentsFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessKeyset(iSignProcessID, iKeysetID)
return 0 # FpQCall( {::_hdll_,"DPLSetSignProcessKeyset"} ,"__sl__sl__sl__sl",::_id_,iSignProcessID,iKeysetID)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetTabOrderMode(sMode)
   sMode := ::ForceAnsi(sMode)
return 0 # FpQCall( {::_hdll_,"DPLSetTabOrderModeA"} ,"__sl__sl__pt",::_id_,sMode)

**********************************************************************************************************************
// neu in 10.11 - PowerBasic INC    10.11
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFreeTextAnnotation(dLeft, dTop, dWidth, dHeight, sText, iAngle, iOptions)
   sText := ::ForceAnsi(sText)
return  FpQCall( {::_hdll_,"DPLAddFreeTextAnnotationA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,sText,iAngle,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendToFile(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 #  FpQCall( {::_hdll_,"DPLAppendToFileA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawHTMLTextMatrix(dWidth, sHTMLText, dM11, dM12, dM21, dM22, dMDX, dMDY)
   sHTMLText := ::ForceAnsi(sHTMLText)
return  FpQCall( {::_hdll_,"DPLDrawHTMLTextMatrixA"} ,"__sl__sl__f8__pt__f8__f8__f8__f8__f8__f8",::_id_,dWidth,sHTMLText,dM11,dM12,dM21,dM22,dMDX,dMDY)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawQRCode(dLeft, dTop, dSymbolSize, sText, iEncodeOptions, iDrawOptions)
   sText := ::ForceAnsi(sText)
   DEFAULT iEncodeOptions TO 1
   DEFAULT iDrawOptions   TO 0
return 0 #  FpQCall( {::_hdll_,"DPLDrawQRCodeA"} ,"__sl__sl__f8__f8__f8__pt__sl__sl",::_id_,dLeft,dTop,dSymbolSize,sText,iEncodeOptions,iDrawOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldKidTempIndex(iIndex, iSubIndex)   // GetFormFieldSubTempIndex() => GetFormFieldKidTempIndex()
return  FpQCall( {::_hdll_,"DPLGetFormFieldKidTempIndex"} ,"__sl__sl__sl__sl",::_id_,iIndex,iSubIndex)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderAsMultipageTIFFToFile(dDPI, sPageRanges, iImageOptions, iOutputOptions, sFileName)
   sPageRanges := ::ForceAnsi(sPageRanges)
   sFileName := ::ForceAnsi(sFileName)
return 0 #  FpQCall( {::_hdll_,"DPLRenderAsMultipageTIFFToFileA"} ,"__sl__sl__f8__pt__sl__sl__pt",::_id_,dDPI,sPageRanges,iImageOptions,iOutputOptions,sFileName)

**********************************************************************************************************************
// neu in 10.12 - PowerBasic INC    10.12
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:CheckPassword(sPassword)
   sPassword := ::ForceAnsi(sPassword)
return  FpQCall( {::_hdll_,"DPLCheckPasswordA"} ,"__sl__sl__pt",::_id_,sPassword)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemoveFormFieldChoiceSub(iIndex, sSubname)
   sSubname := ::ForceAnsi(sSubname)
return 0 #  FpQCall( {::_hdll_,"DPLRemoveFormFieldChoiceSubA"} ,"__sl__sl__sl__pt",::_id_,iIndex,sSubname)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDPLRFileName(sFileName)
   sFileName := ::ForceAnsi(sFileName)
return 0 #  FpQCall( {::_hdll_,"DPLSetDPLRFileNameA"} ,"__sl__sl__pt",::_id_,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetFormFieldTitle(iIndex, sNewTitle)
   sNewTitle := ::ForceAnsi(sNewTitle)
return 0 #  FpQCall( {::_hdll_,"DPLSetFormFieldTitleA"} ,"__sl__sl__sl__pt",::_id_,iIndex,sNewTitle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:UpdateTrueTypeSubsettedFont(sSubsetChars)
   sSubsetChars := ::ForceAnsi(sSubsetChars)
return 0 #  FpQCall( {::_hdll_,"DPLUpdateTrueTypeSubsettedFontA"} ,"__sl__sl__pt",::_id_,sSubsetChars)

**********************************************************************************************************************
// neu in 10.13 - PowerBasic INC    10.13
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddLinkToFileDest(dLeft, dTop, dWidth, dHeight, sFileName, sNamedDest, dPosition, iNewWindow, iOptions)
   sFileName := ::ForceAnsi(sFileName)
   sNamedDest := ::ForceAnsi(sNamedDest)
return  FpQCall( {::_hdll_,"DPLAddLinkToFileDestA"} ,"__sl__sl__f8__f8__f8__f8__pt__pt__f8__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,sNamedDest,dPosition,iNewWindow,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddStampAnnotationFromImage(dLeft, dTop, dWidth, dHeight, sFileName, sTitle, sContents, dRed, dGreen, dBlue, iOptions)
   sFileName := ::ForceAnsi(sFileName)
   sTitle := ::ForceAnsi(sTitle)
   sContents := ::ForceAnsi(sContents)
return 0 #  FpQCall( {::_hdll_,"DPLAddStampAnnotationFromImageA"} ,"__sl__sl__f8__f8__f8__f8__pt__pt__pt__f8__f8__f8__sl",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,sTitle,sContents,dRed,dGreen,dBlue,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRotatedTextBoxEx(dLeft, dTop, dWidth, dHeight, dAngle, sText, iOptions, iBorder, iRadius, iDrawOptions)
   sText := ::ForceAnsi(sText)
return  FpQCall( {::_hdll_,"DPLDrawRotatedTextBoxExA"} ,"__sl__sl__f8__f8__f8__f8__f8__pt__sl__sl__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,dAngle,sText,iOptions,iBorder,iRadius,iDrawOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DrawRoundedRotatedBox(dLeft, dBottom, dWidth, dHeight, dRadius, dAngle, iDrawOptions)
return  FpQCall( {::_hdll_,"DPLDrawRoundedRotatedBox"} ,"__sl__sl__f8__f8__f8__f8__f8__f8__sl",::_id_,dLeft,dBottom,dWidth,dHeight,dRadius,dAngle,iDrawOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotEmbeddedFileName(iIndex, iOptions)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetAnnotEmbeddedFileNameA"} ,"__pt__sl__sl__sl",::_id_,iIndex,iOptions) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotEmbeddedFileToFile(iIndex, iOptions, sFileName)
   sFileName := ::ForceAnsi(sFileName)
return  FpQCall( {::_hdll_,"DPLGetAnnotEmbeddedFileToFileA"} ,"__sl__sl__sl__sl__pt",::_id_,iIndex,iOptions,sFileName)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetAnnotEmbeddedFileToString(iIndex, iOptions)
return ::_str_result_( FpQCall( {::_hdll_,"DPLGetAnnotEmbeddedFileToString"} ,"__pt__sl__sl__sl",::_id_,iIndex,iOptions) ) // ByteArray !
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontIsEmbedded()
return 0 #  FpQCall( {::_hdll_,"DPLGetFontIsEmbedded"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontIsSubsetted()
return 0 #  FpQCall( {::_hdll_,"DPLGetFontIsSubsetted"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFontMetrics(iMetricType)
return  FpQCall( {::_hdll_,"DPLGetFontMetrics"} ,"__sl__sl__sl",::_id_,iMetricType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RemovePageBox(iBoxType)
return 0 #  FpQCall( {::_hdll_,"DPLRemovePageBox"} ,"__sl__sl__sl",::_id_,iBoxType)

**********************************************************************************************************************
// neu in 10.14 - PowerBasic INC    10.14
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddStampAnnotationFromImageID(dLeft, dTop, dWidth, dHeight, iImageID, sTitle, sContents, dRed, dGreen, dBlue, iOptions)
   sTitle := ::ForceAnsi(sTitle)
   sContents := ::ForceAnsi(sContents)
return 0 #  FpQCall( {::_hdll_,"DPLAddStampAnnotationFromImageIDA"} ,"__sl__sl__f8__f8__f8__f8__sl__pt__pt__f8__f8__f8__sl",::_id_,dLeft,dTop,dWidth,dHeight,iImageID,sTitle,sContents,dRed,dGreen,dBlue,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldSubmitActionString(iIndex, sActionType)
   sActionType := ::ForceAnsi(sActionType)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetFormFieldSubmitActionStringA"} ,"__pt__sl__sl__pt",::_id_,iIndex,sActionType) ))

**********************************************************************************************************************
// neu in 10.15 - PowerBasic INC    10.15
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddPageMatrix(dxscale, dyscale, dxoffset, dyoffset)
return 0 #  FpQCall( {::_hdll_,"DPLAddPageMatrix"} ,"__sl__sl__f8__f8__f8__f8",::_id_,dxscale,dyscale,dxoffset,dyoffset)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetCanvasDCEx(iCanvasWidth, iCanvasHeight, iReferenceDC)
return  FpQCall( {::_hdll_,"DPLGetCanvasDCEx"} ,"__sl__sl__sl__sl__sl",::_id_,iCanvasWidth,iCanvasHeight,iReferenceDC)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetPageUserUnit()
return  FpQCall( {::_hdll_,"DPLGetPageUserUnit"} ,"__f8__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetPageUserUnit(dUserUnit)
return  FpQCall( {::_hdll_,"DPLSetPageUserUnit"} ,"__sl__sl__f8",::_id_,dUserUnit)

**********************************************************************************************************************
// neu in 11.11 - PowerBasic INC    11.11
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddRelativeLinkToFile(dLeft, dTop, dWidth, dHeight, sFileName, iPage, dPosition, iNewWindow, iOptions)
   sFileName := ::ForceAnsi(sFileName)
return  FpQCall( {::_hdll_,"DPLAddRelativeLinkToFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__f8__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,iPage,dPosition,iNewWindow,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddRelativeLinkToFileDest(dLeft, dTop, dWidth, dHeight, sFileName, sNamedDest, dPosition, iNewWindow, iOptions)
   sFileName := ::ForceAnsi(sFileName)
   sNamedDest := ::ForceAnsi(sNamedDest)
return  FpQCall( {::_hdll_,"DPLAddRelativeLinkToFileDestA"} ,"__sl__sl__f8__f8__f8__f8__pt__pt__f8__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,sNamedDest,dPosition,iNewWindow,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddRelativeLinkToFileEx(dLeft, dTop, dWidth, dHeight, sFileName, iDestPage, iNewWindow, iOptions, iZoom, iDestType, dDestLeft, dDestTop, dDestRight, dDestBottom)
   sFileName := ::ForceAnsi(sFileName)
return  FpQCall( {::_hdll_,"DPLAddRelativeLinkToFileExA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__sl__sl__sl__sl__f8__f8__f8__f8",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,iDestPage,iNewWindow,iOptions,iZoom,iDestType,dDestLeft,dDestTop,dDestRight,dDestBottom)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddRelativeLinkToLocalFile(dLeft, dTop, dWidth, dHeight, sFileName, iOptions)
   sFileName := ::ForceAnsi(sFileName)
return  FpQCall( {::_hdll_,"DPLAddRelativeLinkToLocalFileA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl",::_id_,dLeft,dTop,dWidth,dHeight,sFileName,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AppendToString(iAppendMode)
return ::_str_result_( FpQCall( {::_hdll_,"DPLAppendToString"} ,"__pt__sl__sl",::_id_,iAppendMode) ) // ByteArray !
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DANormalizePage(iFileHandle, iPageRef, iNormalizeOptions)
return  FpQCall( {::_hdll_,"DPLDANormalizePage"} ,"__sl__sl__sl__sl__sl",::_id_,iFileHandle,iPageRef,iNormalizeOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetPageLayout(iFileHandle, iNewPageLayout)
return 0 #  FpQCall( {::_hdll_,"DPLDASetPageLayout"} ,"__sl__sl__sl__sl",::_id_,iFileHandle,iNewPageLayout)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DASetPageMode(iFileHandle, iNewPageMode)
return 0 #  FpQCall( {::_hdll_,"DPLDASetPageMode"} ,"__sl__sl__sl__sl",::_id_,iFileHandle,iNewPageMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetFormFieldCaptionEx(iIndex, iStringType)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetFormFieldCaptionExA"} ,"__pt__sl__sl__sl",::_id_,iIndex,iStringType) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:IsLinearized()        // renamed from Linearized() 11.11
return 0 #  FpQCall( {::_hdll_,"DPLIsLinearized"} ,"__sl__sl",::_id_)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LinearizeFile(sInputFileName, sPassword, sOutputFileName, iOptions)
   sInputFileName := ::ForceAnsi(sInputFileName)
   sPassword := ::ForceAnsi(sPassword)
   sOutputFileName := ::ForceAnsi(sOutputFileName)
return  FpQCall( {::_hdll_,"DPLLinearizeFileA"} ,"__sl__sl__pt__pt__pt__sl",::_id_,sInputFileName,sPassword,sOutputFileName,iOptions)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:PrintMode(iMode)
return  FpQCall( {::_hdll_,"DPLPrintMode"} ,"__sl__sl__sl",::_id_,iMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:RenderPageToDCClip(dDPI, iPage, iDC, sClip)
   sClip := ::ForceAnsi(sClip)
return 0 #  FpQCall( {::_hdll_,"DPLRenderPageToDCClip"} ,"__sl__sl__f8__sl__sl__pt",::_id_,dDPI,iPage,iDC,sClip)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAppendInputFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2) // Funktion mit 1 Parameter, daher 2 !
return 0 # ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetAppendInputFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetDecodeMode(iNewDecodeMode)
return 0 #  FpQCall( {::_hdll_,"DPLSetDecodeMode"} ,"__sl__sl__sl",::_id_,iNewDecodeMode)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessCustomSubFilter(iSignProcessID, sSubFilterStr)
   sSubFilterStr := ::ForceAnsi(sSubFilterStr)
return 0 #  FpQCall( {::_hdll_,"DPLSetSignProcessCustomSubFilterA"} ,"__sl__sl__sl__pt",::_id_,iSignProcessID,sSubFilterStr) // Fixed 'A' for Ansi at end.

**********************************************************************************************************************
// neu in 11.12 - PowerBasic INC    11.12
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetTextBlockAsString(iTextBlockListID, iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLDAGetTextBlockAsStringA"} ,"__pt__sl__sl__sl",::_id_,iTextBlockListID,iIndex) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetTextBlockAsString(iTextBlockListID, iIndex)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetTextBlockAsStringA"} ,"__pt__sl__sl__sl",::_id_,iTextBlockListID,iIndex) ))

**********************************************************************************************************************
// neu in 11.14 - PowerBasic INC    11.14
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddFreeTextAnnotationEx(dLeft, dTop, dWidth, dHeight, sText, iAngle, iOptions, iTransparency)
   sText := ::ForceAnsi(sText)
return  FpQCall( {::_hdll_,"DPLAddFreeTextAnnotationExA"} ,"__sl__sl__f8__f8__f8__f8__pt__sl__sl__sl",::_id_,dLeft,dTop,dWidth,dHeight,sText,iAngle,iOptions,iTransparency)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:GetImageListItemFormatDesc(iImageListID, iImageIndex, iOptions)
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLGetImageListItemFormatDescA"} ,"__pt__sl__sl__sl__sl",::_id_,iImageListID,iImageIndex,iOptions) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:LibraryVersionEx()
return ::ReadString(::_str_result_( FpQCall( {::_hdll_,"DPLLibraryVersionExA"} ,"__pt__sl",::_id_) ))
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetAnnotOptional(iIndex, iOptionalContentGroupID)
return 0 #  FpQCall( {::_hdll_,"DPLSetAnnotOptional"} ,"__sl__sl__sl__sl",::_id_,iIndex,iOptionalContentGroupID)

**********************************************************************************************************************
// neu in 11.15 - PowerBasic INC    11.15
**********************************************************************************************************************

// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddOpenTypeFontFromString(iSource, iOptions)
   local ptb := _xgrab(32);PokeDWord(ptb,,3)  // Funktion mit 2 Parameter, daher 3 !
return ::_ptb_free_( FpQCall( {::_hdll_,"DPLAddOpenTypeFontFromString"} ,"__sl__sl__pt__sl",::_id_,::_b(iSource,ptb,1),iOptions) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:AddTrueTypeFontFromString(iSource)
   local ptb := _xgrab(32);PokeDWord(ptb,,2)  // Funktion mit 1 Parameter, daher 2 !
return ::_ptb_free_( FpQCall( {::_hdll_,"DPLAddTrueTypeFontFromString"} ,"__sl__sl__pt",::_id_,::_b(iSource,ptb,1)) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessCustomDict(iSignProcessID, sKey, sNewValue, iStorageType)
   sKey := ::ForceAnsi(sKey)
   sNewValue := ::ForceAnsi(sNewValue)
return  FpQCall( {::_hdll_,"DPLSetSignProcessCustomDictA"} ,"__sl__sl__sl__pt__pt__sl",::_id_,iSignProcessID,sKey,sNewValue,iStorageType)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessFieldImageFromString(iSignProcessID, iSource, iOptions)
   local ptb := _xgrab(32);PokeDWord(ptb,,4) // Funktion mit 3 Parameter, daher 4 !
return ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetSignProcessFieldImageFromString"} ,"__sl__sl__sl__pt__sl",::_id_,iSignProcessID,::_b(iSource,ptb,1),iOptions) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:SetSignProcessPFXFromString(iSignProcessID, iSource, sPFXPassword)
   local ptb := _xgrab(32);PokeDWord(ptb,,4) // Funktion mit 3 Parameter, daher 4 !
   sPFXPassword := ::ForceAnsi(sPFXPassword)
return ::_ptb_free_( FpQCall( {::_hdll_,"DPLSetSignProcessPFXFromStringA"} ,"__sl__sl__sl__pt__pt",::_id_,iSignProcessID,::_b(iSource,ptb,1),sPFXPassword) ,ptb)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageLayout(iFileHandle)
return  FpQCall( {::_hdll_,"DPLDAGetPageLayout"} ,"__sl__sl__sl",::_id_,iFileHandle)
// -------------------------------------------------------------------------------------------------------------------
METHOD HBPrintPDF:DAGetPageMode(iFileHandle)
return  FpQCall( {::_hdll_,"DPLDAGetPageMode"} ,"__sl__sl__sl",::_id_,iFileHandle)

