*#### ANSI .t.    !!!!
/*
* function Auswahlliste(...) zeigt eine Listbox mit Auswahltext an.
*     Parameter  aAuswahlVorgabe   Eindimensionales Array mit Auswahltexten
*                                  oder Zweidimensionales Array mit Auswahltexten und Vorbelegung .t./.f.
*                cTitle            Text der Titelzeile
*                nLB_MarkMode      Art der Listboxmarkierung einfach etc. siehe Handbuch
*                lHorizScroll      Listbox darf auch horizontal scrollen
*                oWin              Aufrufendes Fenster, standard ist SetAppWindow()
*                IsCancel          Per Referenz bergeben markiert einen Abbruch eindeutig
*
*     Rckgabe   Array mit Auswahltexten        {"Text",...}
*/

#include "Gra.ch"
#include "Xbp.ch"
#include "Appevent.ch"
#include "Font.ch"
#include "COMMON.ch"


#define nRand          5
#define nPBHoehe      25
#define nPBBreite     80
#define nPBVorschubY  (nPBHoehe+5)
#define nPBVorschubX  (nPBBreite+10)
#define nSLEHoehe     20
#define nSLEVorschub  (nSLEHoehe+7)
#define nNormalTab    5
#define nFTHoehe      18
#define nFTVorschub   (nFTHoehe+6)
#define nFT2SLEVorschub  (nSLEHoehe+3)
#define nsleNurEinZeichen_DimX                30
#define nsleDatum_DimX                        80


function Auswahlliste(aAuswahlVorgabe,cTitle,nLB_MarkMode,lHorizScroll,oWin, IsCancel    )
   LOCAL nEvent, mp1:=NIL, mp2:=NIL, uTmp
   LOCAL oXbp:=NIL, ftBW:=NIL, pbOK:=NIL,pbCancel:=NIL
   LOCAL oDlg, drawingArea:=nil, lbAuswahlliste:=nil
   LOCAL aAuswahlMarkiert := {}, x, aReturn := {}, aAuswahl := {}
   LOCAL lIsFehlerInAuswahlVorgabe := .f.
   local nMitteX,nPBPosY,nListBoxPosY,nListBoxSizeX,nListBoxSizeY
   local nBreite, nHoehe

   // Diese Berechnungen mssen mit Resize bereinstimmen
   nBreite := 550
   nHoehe  := 500
   nMitteX := int(nBreite / 2)
   nPBPosY := nHoehe-nPBHoehe-5
   nListBoxPosY  := nFTHoehe + nRand*2
   nListBoxSizeX := nBreite  - nRand*2
   nListBoxSizeY := nPBPosY  - nRand*2 - nListBoxPosY

   IsCancel := .f.

   DEFAULT oWin TO SetAppWindow()

   if IsNil(aAuswahlVorgabe) .or. empty(aAuswahlVorgabe)
      aAuswahlVorgabe := {"Kein Auswahl Array bergeben !" }
      lIsFehlerInAuswahlVorgabe := .t.
   endif
   DEFAULT cTitle          TO "Bitte whlen Sie ... "
   DEFAULT nLB_MarkMode    TO XBPLISTBOX_MM_SINGLE
   DEFAULT lHorizScroll    TO .f.
   // Verschieben ber den gesamten Monitor, blockiere aber oWin.
   oDlg := XbpDialog():new( AppDesktop(),oWin, , ,;
                            { { XBP_PP_ORIGIN       , XBP_ORIGIN_TOPLEFT },;
                              { XBP_PP_COMPOUNDNAME , "9.Arial" },;
                              { XBP_PP_BGCLR, XBPSYSCLR_DIALOGBACKGROUND } } , .F.)
   oDlg:taskList := .F.
   oDlg:title := " "+alltrim(cTitle)
   oDlg:visible := .F.
   oDlg:close := {|u1,u2,oDlg| oDlg:destroy() }
   oDlg:maxButton := .f.
   oDlg:minButton := .t.
   oDlg:sysMenu   := .f.
   oDlg:resize := {| aOldSize, aNewSize, oXbp | AuswahllisteResize(oXbp,ftBW,pbOK,pbCancel,lbAuswahlliste ) }
   oDlg:clientSize := {nBreite, nHoehe}
*   oDlg:maxSize   := oDlg:currentSize()
   oDlg:minSize   := {200,200}

   oDlg:create()

   drawingArea := oDlg:drawingArea

   ftBW := XbpStatic():new( drawingArea ,, {nRand,nRand},{nListBoxSizeX,nFTHoehe} )
   ftBW:caption := "Bitte whlen Sie "
   ftBW:clipParent := .F.
   ftBW:autosize   := .F.
   ftBW:create()

   lbAuswahlliste := XbpListBox():new( drawingArea,,{nRand,nListBoxPosY},{nListBoxSizeX,nListBoxSizeY},;
                                       { { XBP_PP_BGCLR, XBPSYSCLR_ENTRYFIELD } } )
   lbAuswahlliste:clipParent := .T.
   lbAuswahlliste:clipSiblings := .T.
   lbAuswahlliste:tabStop := .t.
   lbAuswahlliste:markmode := nLB_MarkMode
   lbAuswahlliste:horizScroll := lHorizScroll
   lbAuswahlliste:itemSelected := {|uN1,uN2,oXbp| PostAppEvent(xbeP_Activate, , , pbOK ) }

   lbAuswahlliste:create()

   * Auswahlliste mit Auswahltexten fttern

   for x := 1 to len(aAuswahlVorgabe)
       do case
          case Valtype(aAuswahlVorgabe[x]) = "C"   // eindimensionales Array
               lbAuswahlliste:addItem(aAuswahlVorgabe[x])
          case Valtype(aAuswahlVorgabe[x]) = "A"   // zweidimensionales Array
               lbAuswahlliste:addItem(aAuswahlVorgabe[x,1])
               if Valtype(aAuswahlVorgabe[x,2])="L" .and. aAuswahlVorgabe[x,2]
                  aadd(aAuswahlMarkiert, x )
               endif
          otherwise
               lIsFehlerInAuswahlVorgabe := .t.
               msgbox( "Der Funktion Auswahlliste() wurde ein falsches Array bergeben / Error in array parameter." )
               lbAuswahlliste:addItem("Auswahl Array war von falschem Typ ! / Error in array parameter")
               exit
       endcase
   next

   lbAuswahlliste:setData(aAuswahlMarkiert,.t.)

   pbOK := XbpPushButton():new( drawingArea,,{nMitteX-10-nPBBreite, nPBPosY },{nPBBreite,nPBHoehe}  )
   pbOK:caption := "OK"
   pbOK:clipParent := .T.
   pbOK:clipSiblings := .T.
   pbOK:tabStop := .t.
   pbOK:create()
   pbOK:activate := {|| aAuswahl := lbAuswahlliste:getData() ,;
                        PostAppEvent( xbeP_Close, , , oDlg ) }

   pbCancel := XbpPushButton():new( drawingArea,, {nMitteX+10,nPBPosY },{nPBBreite,nPBHoehe}  )
   pbCancel:caption := "abbrechen"
   pbCancel:clipParent := .T.
   pbCancel:clipSiblings := .T.
   pbCancel:tabStop := .t.
   pbCancel:create()
   pbCancel:activate := {|| IsCancel := .t., PostAppEvent( xbeP_Close, , , oDlg ) }

   CenterControl(oDlg)  // WICHTIG ! Die Startgre wird oben festgelegt !
                        //           Die Controls werden im Resize positioniert.

   oDlg:setModalState( XBP_DISP_APPMODAL )
   oDlg:show()
   SetAppFocus( oDlg )
   SetAppFocus( lbAuswahlliste )

   nEvent := xbe_None
   DO WHILE nEvent <> xbeP_Close
      nEvent := AppEvent( @mp1, @mp2, @oXbp )
      oXbp:handleEvent( nEvent, mp1, mp2 )
   ENDDO

   if ! lIsFehlerInAuswahlVorgabe .and. ! empty(aAuswahl)
      for x := 1 to len(aAuswahl)
          uTmp := aAuswahlVorgabe[aAuswahl[x]]
          do case
             case Valtype(uTmp) = "C"   // eindimensionales Array
                  aadd(aReturn,uTmp)
             case Valtype(aAuswahlVorgabe[1]) = "A"   // zweidimensionales Array
                  aadd(aReturn,uTmp[1])
          endcase
      next
   endif

   SetAppFocus( oWin )

RETURN aReturn


*------------------------------------------------------------------
static function AuswahllisteResize(oDLG,ftBW,pbOK,pbCancel,lbAuswahlliste )
    local nMitteX,nPBPosY,nListBoxPosY,nListBoxSizeX,nListBoxSizeY
    local nBreite, nHoehe
    nBreite := oDLG:drawingArea:currentSize()[1]
    nHoehe  := oDLG:drawingArea:currentSize()[2]
    nMitteX := int(nBreite / 2)
    nPBPosY := nHoehe-nPBHoehe-5
    nListBoxPosY  := nFTHoehe + nRand*2
    nListBoxSizeX := nBreite  - nRand*2
    nListBoxSizeY := nPBPosY  - nRand*2 - nListBoxPosY
    // erst alle neuen Positionen bestimmen ...
    ftBW:setPosAndSize({nRand,nRand},{nListBoxSizeX,nFTHoehe},.f.)
    pbOK:setPos(     {nMitteX-10-nPBBreite, nPBPosY }, .f. )
    pbCancel:setPos( {nMitteX+10          , nPBPosY }, .f. )
    lbAuswahlliste:setPosAndSize({nRand,nListBoxPosY},{nListBoxSizeX,nListBoxSizeY},.f.)
    // dann auf einmal anzeigen, das sieht besser aus.
    oDLG:drawingArea:invalidateRect()
return NIL

