#include "Xbp.ch"
#include "Gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "HBPrintPDF.ch"

// ANSI Text ! 

procedure main
   local oPDF, cAcrobat, cPDF, cPfad, nWahl, cPrinterName, aPrinter, aBins, aBinTxt, cUnit
   local cBarCode, nY, nX, nW, nH, nF, cImage, nImageID, x, cTxt, nDestID, nActivePage, cCMD
   cls

   set charset to ansi
   set alternate to TEST_QR-code
   set alternate on

   ? "Teste HBPrintPDF"

   cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe"
   cPDF     := "Hello_QRCode.pdf"
   cPfad    := cAppPath()  // ot4xb
   delete file (cPDF)
   do while file (cPDF)
      msgbox("Die PDF Datei muss zuerst geschlossen werden / close PDF !" )
      delete file (cPDF)
   enddo
   ? "PDF:  '"+cPDF+"'"
   ? "Pfad: '"+cPfad+"'"
   ?
   ? "HBPrintPDF() erzeugen"
   ?

altd()

   oPDF := HBPrintPDF():new():create() // GetQuickPDFLizenzKey() / cKey

   if oPDF:IsOK
      ? "DLL-Version:",oPDF:LibraryVersion()
      /* Key The property to set:
         0 = PDF Version
         1 = Author
         2 = Title
         3 = Subject
         4 = Keywords
         5 = Creator
         6 = Producer
      */
      ? "SetInformation( 1 )", oPDF:SetInformation( 1 , "Hubert Brandel ()" )
      ? "SetInformation( 2 )", oPDF:SetInformation( 2 , "HBPrintPDF - QR-Code" )
      ? "SetInformation( 3 )", oPDF:SetInformation( 3 , "HBPrintPDF - PRG-Example QR-Code" )
      ? "SetInformation( 4 )", oPDF:SetInformation( 4 , "HBPrintPDF, QuickPDF" )
      ? "SetInformation( 5 )", oPDF:SetInformation( 5 , "HBPrintPDF - Xbase++ CLASS for QuickPDF" )
      ? "nach Create - Text ausgeben"
      do case
         case set(_SET_CHARSET)=0 // ANSI
            cTxt := "EXE in ANSI (0)"
         case set(_SET_CHARSET)=1 // OEM
            cTxt := "EXE in OEM (1)"
         otherwise
            cTxt := "EXE ? ("+alltrim(str(set(_SET_CHARSET),3,0))+")"
      end
      oPDF:Say(2,45,cTxt)
      ? "CHARSET: ",cTxt
      oPDF:SetPageLayout(0) // single page
      oPDF:DrawText(20,30, "HBPrintPDF (QuickPDF) DLL: "+oPDF:LibraryVersion())

      do case
         case oPDF:nDefaultMeasurementUnits=MEASUREMENTUNITS_MM
              cUnit := "mm"
         case oPDF:nDefaultMeasurementUnits=MEASUREMENTUNITS_INCH
              cUnit := "inch"
         otherwise
              cUnit := "1/72 inch"
      end

      ? "PageHeight():      ",oPDF:PageHeight(),cUnit
      ? "PageWidth ():      ",oPDF:PageWidth (),cUnit
      ? "Barcodes ..."

      nY       := 20    // mm
      nX       := 110
      cBarCode := "12345"
      oPDF:DrawText(nX, nY+7,"Code39: "+cBarCode)
      oPDF:DrawBarcode(150, nY,40,10,cBarCode,BARCODE_TYPE_Code39,0)
      nY += 20
      oPDF:DrawText(nX,nY+7, "Code128: "+cBarCode)
      oPDF:DrawBarcode(150, nY,40,10,cBarCode,BARCODE_TYPE_Code128,0)
      nY += 20
      cBarCode := "1234567890128"
      oPDF:DrawText(nX,nY+7, "EAN13 NUM + SP:")
      oPDF:DrawBarcode(150,nY,40,10,cBarCode,BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_NUMBER_SP)
      nY += 20
      oPDF:DrawText(nX,nY+7, "EAN13 NUM: ")
      oPDF:DrawBarcode(150,nY,40,10,left(cBarCode,12),BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_ONLY_NUM )
      nY += 20
      cBarCode := "4016138347036"
      oPDF:DrawText(nX,nY+7, "EAN13 NUM: ")
      oPDF:DrawBarcode(150,nY,40,10,cBarCode,BARCODE_TYPE_EAN13,BARCODE_OPTION_EAN13_DRAW_ONLY_NUM )

      nX := 20
      nY += 40
      cBarCode := "HBPrintPDF"
      oPDF:DrawText(nX,nY-7, "QR-Code:   '"+cBarCode+"' normal, dann gedreht 90, 180 und 270")
      /*
         0 = Normal
         1 = Rotate 90 degrees counter clockwise
         2 = Rotate 180 degrees
         3 = Rotate 90 degrees clockwise
      */

      if ! oPDF:DrawQRCode(nX, nY, 20, "Test ", 0, 0 ) // normal Ausrichtung - normal position
         msgbox("DrawQRCode(nX, nY, 20, cBarCode, 0, 0 ) => error")
         ? "DrawQRCode(nX, nY, 20, cBarCode, 1, 0 )",oPDF:LastErrorCode()," => ",oPDF:LastRenderError()
      endif

      for x := 3 to 1 step -1
          nX += 30
          if ! oPDF:DrawQRCode(nX, nY, 20, cBarCode, 0, x )
             msgbox("DrawQRCode(nX, nY, 20, cBarCode, 0, "+str(x)+" ) => error")
             ? "DrawQRCode(nX, nY, 20, cBarCode, 0, "+str(x)+" )",oPDF:LastErrorCode()," => ",oPDF:LastRenderError()
          endif
      next

      nX := 20
      nY += 30

      oPDF:DrawText(nX,nY, "oPDF:DrawQRCode(nX, nY, 20, cBarCode, 0, x ) with x => 0, 3, 2, 1")





      //------------------- END --- SAVE --- PRINT ------------------

      ? "Save File",oPDF:SaveToFile(cPfad+cPDF)
      ? "File ? ",file(cPfad+cPDF)
      oPDF:destroy()
      ? "destroy - 10 Sekunden warten, oder Taste drcken"
   endif

   inkey(10)

   cCMD := '@echo off'+CRLF+;
           'set AcroReader="'+GetStandardProgramm(cPDF, cPfad)+'"'+CRLF+;
           'set PDF="'+cPfad+cPDF+'"'+CRLF+;
           'echo.'+CRLF+;
           'echo Show PFD with   ShowThis1   ... and close the Reader'+CRLF+;
           '%AcroReader% /A "nameddest=ShowThis1" %PDF%'+CRLF+;
           'pause'+CRLF+;
           'echo.'+CRLF+;
           'echo Show PFD with   ShowThis2   ... and close the Reader'+CRLF+;
           '%AcroReader% /A "nameddest=ShowThis2" %PDF%'+CRLF+;
           'pause'+CRLF+;
           'echo.'+CRLF+;
           'echo Show Page 2  ... and close the Reader'+CRLF+;
           '%AcroReader% /A "page=2" %PDF%'+CRLF+;
           'echo End'+CRLF+;
           'pause'

   lMemoWrite( "ShowNamedDest.cmd" , cCMD)

   if file(cPfad+cPDF)
      if ! file(cAcrobat)
         cAcrobat := GetStandardProgramm(cPDF, cPfad)
      endif
      runshell(cPfad+cPDF,cAcrobat,.t.)
   endif


return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)   // cPath force to EXE
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if empty(cPath)
      cPath := cAppDir()
   endif
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe

