#include "Xbp.ch"
#include "Gra.ch"
#include "Common.ch"
#include "ot4xb.ch"
#include "HBPrintPDF.ch"

// ANSI Text ! 

procedure main
   local oPDF, cAcrobat, cPDF, cPfad, nPage, nID, nRootID, cTxt, x, nDestID
   cls

   set charset to ansi
   set alternate to test_Outline_Lesezeichen.txt
   set alternate on

   ? "Teste HBPrintPDF"

   cAcrobat := "C:\Programme\Adobe\Reader 9.0\Reader\AcroRd32.exe"
   cPDF     := "Test_Outline_Lesezeichen.pdf"
   cPfad    := cAppPath()  // ot4xb
   delete file (cPDF)
   do while file (cPDF)
      msgbox("Die PDF Datei muss zuerst geschlossen werden / close PDF !" )
      delete file (cPDF)
   enddo
   ? "PDF:  '"+cPDF+"'"
   ? "Pfad: '"+cPfad+"'"
   ?
   ? "HBPrintPDF() erzeugen"
   ?

   oPDF := HBPrintPDF():new():create() // GetQuickPDFLizenzKey() / cKey

   if oPDF:IsOK
      do case
         case set(_SET_CHARSET)=0 // ANSI
            cTxt := "EXE in ANSI (0)"
         case set(_SET_CHARSET)=1 // OEM
            cTxt := "EXE in OEM (1)"
         otherwise
            cTxt := "EXE ? ("+alltrim(str(set(_SET_CHARSET),3,0))+")"
      end
      oPDF:Say(2,45,cTxt)
      ? "CHARSET: ",cTxt

      oPDF:SetPageLayout(0) // single page
      oPDF:SetPageMode(1)   // bookmarks

      oPDF:DrawText(20,30, "HBPrintPDF (QuickPDF) DLL: "+oPDF:LibraryVersion())

      // Rootitem / erstes Element
      nRootID := oPDF:NewOutline( 0 , "Root ", 1 , 1 )

      for nPage := 1 to 3
          if nRootID > 0 // OK
             nID := oPDF:NewOutline( nRootID , "Page "+ntrim(nPage), nPage , 1 )
             if nID > 0 // OK
                oPDF:NewOutline( nID, "1. Bookmark", nPage,  40 )
                oPDF:NewOutline( nID, "2. Bookmark", nPage, 150 )
             endif
          endif
          oPDF:PrintPageNo()
          oPDF:DrawText(20,50,  "1. Bookmark on page "+ntrim(nPage))
          oPDF:DrawText(20,150, "2. Bookmark on page "+ntrim(nPage))
          if nPage < 3
             oPDF:newPage()
          endif
      next

      nID := oPDF:NewOutline( nRootID , "Open PDF", 3 , 1 )

      ? "SetOutlineOpenFile()  ", oPDF:SetOutlineOpenFile(nID,cPfad+"HelloFromDLL.pdf")

      ? "Infos"
      ? "OutlineCount():  ",oPDF:OutlineCount()
      for x := 1 to oPDF:OutlineCount()
          nID := oPDF:GetOutlineID(x)
          nDestID := oPDF:GetOutlineDest(nID)
          ? "outline"+str(x,3,0)+" ID:",nID," DestID:",nDestID," Type:",str(oPDF:GetDestType(nDestID))," Value:",str(oPDF:GetDestValue(nDestID,2),7,2)    // top
          if oPDF:OutlineTitle(nID) = "1. Bookmark" .and. oPDF:GetOutlinePage(nID) # 2
             ? "oPDF:SetDestValue() ? ",oPDF:SetDestValue(nDestID, 2, 30),oPDF:OutlineTitle(nID)
             ? "======>"+str(x,3,0)+" ID:",nID," DestID:",nDestID," Type:",str(oPDF:GetDestType(nDestID))," Value:",str(oPDF:GetDestValue(nDestID,2),7,2) // top
          endif
          if oPDF:OutlineTitle(nID) = "2. Bookmark" .and. oPDF:GetOutlinePage(nID) = 2
*             ? "oPDF:SetOutlineDestination() ? ",oPDF:SetOutlineDestination(nID, 2, 1), oPDF:OutlineTitle(nID) // zeigt keine Wirkung / does not work ?
             ? "oPDF:SetDestValue() ? ",oPDF:SetDestValue(nDestID, 2, 1),oPDF:OutlineTitle(nID)
             ? "======>"+str(x,3,0)+" ID:",nID," DestID:",nDestID," Type:",str(oPDF:GetDestType(nDestID))," Value:",str(oPDF:GetDestValue(nDestID,2),7,2) // top
          endif
      next

      ? "Save File",oPDF:SaveToFile(cPfad+cPDF)
      ? "File ? ",file(cPfad+cPDF)

      oPDF:destroy()
      ? "destroy - 5 Sekunden warten, oder Taste drcken"
   endif

   inkey(5)

   if file(cPfad+cPDF)
      if ! file(cAcrobat)
         cAcrobat := GetStandardProgramm(cPDF, cPfad)
      endif
      runshell(cPfad+cPDF,cAcrobat,.t.)
   endif


return

*--------------------------------------------------------------------------
function GetStandardProgramm(cFile, cPath)   // cPath force to EXE
   local cExe := ChrR(0,260) // MAX_PATH is 260
   if empty(cPath)
      cPath := cAppDir()
   endif
   if @shell32:FindExecutableA(cFile, cPath, @cExe) < 32
      cExe := ""
   else
      cExe := TrimZ(cExe)
   end
return cExe
*--------------------------------------------------------------------------
function ntrim(x);return alltrim(str(x))

